//////////
// Modifications in the original code:
// 1.	Error codes E_GMIN_NOT_PERFORMED, E_GMIN_NOT_FINISHED, E_GMIN_FAILED for
//		gmin stepping, E_SRCS_NOT_PERFORMED, E_SRCS_NOT_FINISHED, E_SRCS_FAILED for
//		source stepping, E_SRCL_NOT_PERFORMED, E_SRCL_FAILED for source lifting
//		defined.
// 2.	Error code E_FLOATNODES defined. It is used in ckt/cktsetup.c for indicating
//		that floating nodes were detected in the circuit.
// 3.	Error code E_SSSEITERLIM defined. It is used in ckt/dcssse.c for indicating
//		that maximum number of transient runs was reached in steady state analysis.
//		Separate iteration limit error code is needed to avoid confusion with
//		iteration limit error eventually generated by transient run.
// Author: Janez Puhan
//////////

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef ERRORS
#define ERRORS "error.h $Revision: 1.1 $  on $Date: 91/04/02 11:26:39 $ "

#include "iferrmsg.h"
#include "strext.h"
#include "iferrmsg.h"
#include <string.h>


        /*
         * definitions for error codes returned by SPICE3 routines.
         */

#define E_INTERN E_PANIC
#define E_BADMATRIX (E_PRIVATE+1)/* ill-formed matrix can't be decomposed */
#define E_SINGULAR (E_PRIVATE+2) /* matrix is singular */
#define E_ITERLIM (E_PRIVATE+3)  /* iteration limit reached,operation aborted */
#define E_ORDER (E_PRIVATE+4)    /* integration order not supported */
#define E_METHOD (E_PRIVATE+5)   /* integration method not supported */
#define E_TIMESTEP (E_PRIVATE+6) /* timestep too small */
#define E_XMISSIONLINE (E_PRIVATE+7)    /* transmission line in pz analysis */
#define E_MAGEXCEEDED (E_PRIVATE+8) /* pole-zero magnitude too large */
#define E_SHORT (E_PRIVATE+9)   /* pole-zero input or output shorted */
#define E_INISOUT (E_PRIVATE+10)    /* pole-zero input is output */
#define E_ASKCURRENT (E_PRIVATE+11) /* ac currents cannot be ASKed */
#define E_ASKPOWER (E_PRIVATE+12)   /* ac powers cannot be ASKed */
#define E_NODUNDEF (E_PRIVATE+13) /* node not defined in noise anal */
#define E_NOACINPUT (E_PRIVATE+14) /* no ac input src specified for noise */
#define E_NOF2SRC (E_PRIVATE+15) /* no source at F2 for IM disto analysis */
#define E_NODISTO (E_PRIVATE+16) /* no distortion analysis - NODISTO defined */
#define E_NONOISE (E_PRIVATE+17) /* no noise analysis - NONOISE defined */
#define E_GMIN_NOT_PERFORMED (E_PRIVATE+18)	// Gmin stepping error codes.
#define E_GMIN_NOT_FINISHED (E_PRIVATE+19)
#define E_GMIN_FAILED (E_PRIVATE+20)
#define E_SRCS_NOT_PERFORMED (E_PRIVATE+21)	// Source stepping error codes.
#define E_SRCS_NOT_FINISHED (E_PRIVATE+22)
#define E_SRCS_FAILED (E_PRIVATE+23)
#define E_SRCL_NOT_PERFORMED (E_PRIVATE+24)	// Source lifting error codes.
#define E_SRCL_FAILED (E_PRIVATE+25)
#define E_FLOATNODES (E_PRIVATE+26)	// Floating node detected in circuit.
#define E_SSSEITERLIM (E_PRIVATE+27)	// Steady state analysis iteration limit.

char *SPerror();
#endif
