/******************************COPYRIGHT NOTICE*******************************/
/*  (c) Centro de Regulacio Genomica                                                        */
/*  and                                                                                     */
/*  Cedric Notredame                                                                        */
/*  23 Feb 2022 - 19:30.                                                                    */
/*All rights reserved.                                                                      */
/*This file is part of T-COFFEE.                                                            */
/*                                                                                          */
/*    T-COFFEE is free software; you can redistribute it and/or modify                      */
/*    it under the terms of the GNU General Public License as published by                  */
/*    the Free Software Foundation; either version 2 of the License, or                     */
/*    (at your option) any later version.                                                   */
/*                                                                                          */
/*    T-COFFEE is distributed in the hope that it will be useful,                           */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of                        */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                         */
/*    GNU General Public License for more details.                                          */
/*                                                                                          */
/*    You should have received a copy of the GNU General Public License                     */
/*    along with Foobar; if not, write to the Free Software                                 */
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA             */
/*...............................................                                           */
/*  If you need some more information                                                       */
/*  cedric.notredame@gmail.com                                                             */
/*...............................................                                           */
/******************************COPYRIGHT NOTICE*******************************/
char *PerlScriptName[]={"rec_sum.pl","count.pl","p\
rocess_list.pl","make_license.pl","CCsed.script","\
msa2bootstrap.pl","tc_generic_method.pl","mmseqs2p\
rf.pl","dynamic.pl","rnapdb2protpdb.pl","generic_m\
ethod.tc_method","clustalw_method.tc_method","extr\
act_from_pdb","install.pl","clean_cache.pl","natur\
e_protocol.pl","mocca","dalilite.pl","wublast.pl",\
"blastpgp.pl","ncbiblast_lwp.pl","wublast_lwp.pl",\
"RNAplfold2tclib.pl","fasta_seq2RNAplfold_template\
file.pl","fasta_seq2hmmtop_fasta.pl","fasta_seq2co\
nsan_aln.pl","clustalw_aln2fasta_aln.pl","seq2name\
_seq.pl","seq2intersection.pl","msf_aln2fasta_aln.\
pl","msa.pl","upp.pl","clustalo.pl","dca.pl","blas\
t_aln2fasta_aln.pl","blast_xml2fasta_aln.pl","fast\
a_aln2fasta_aln_unique_name.pl","newick2name_list.\
pl","excel2fasta.pl","nameseq2fasta.pl","any_file2\
unix_file.pl","EndList"};char *PerlScriptFile[]={"\
use File::Copy;\nuse Env qw(HOST);\nuse Env qw(HOM\
E);\nuse Env qw(USER);\n$x_field=0;\n$y_field=1;\n\
$y_field_set=1;\n$nyf=1;\n\n$interval=0;\n$file=\"\
stdin\";\n\n$print_avg=1;\n$print_sd=0;\n$print_su\
m=0;\n$print_n=0;\nforeach $value ( @ARGV)\n    {\\
n	if ($value ne $ARGV[$np]) \n	    {\n	    ;\n	   \
 }\n	elsif($value eq \"-s\")\n	     {\n	       $st\
ep=$ARGV[++$np];\n	       $np++;\n	     }\n	elsif(\
$value eq \"-print_all\")\n	    {\n	    $print_sd=\
$print_avg=$print_n=$print_sum=1;\n	    $np++;\n	 \
   }\n	elsif($value eq \"-print_sum\")\n	    {\n	 \
   $print_sum=1;\n	    $print_avg=0;\n	    $np++;\\
n	    }\n	elsif($value eq \"-print_n\")\n	    {\n	\
    $print_n=1;\n	    $print_avg=0;\n	    $np++;\n\
	    }\n	elsif($value eq \"-print_avg\")\n	    {\n\
	    $print_avg=1;\n	    $print_avg=0;\n	    $np++\
;\n	    }\n	elsif($value eq \"-sd\")\n	    {\n	   \
 $print_sd=1;\n	    $print_avg=0;\n	    $np++;\n	 \
   }\n	elsif($value eq \"-h\")\n	    {\n	    $head\
er=1;\n	    $np++;\n	    }\n	elsif ($value eq \"-i\
\")\n	    {\n	    $interval= $ARGV[++$np];\n	    $\
np++;\n    	    }\n	elsif ($value eq \"-r2\")\n	  \
  {\n	      $r2=1;\n	      \n	      $np  = $ARGV[+\
+$np];\n	      $nsim= $ARGV[++$np];\n	      $np++;\
\n    	    }\n	elsif ($value eq \"-r\")\n	    {\n	\
    $min= $ARGV[++$np];\n	    $max= $ARGV[++$np];\\
n	    $np++;\n    	    }\n	\n	elsif ($value eq \"-\
x\")\n	    {\n	    $x_field= $ARGV[++$np]-1;\n	   \
 $np++;\n    	    }\n	elsif ($value eq \"-y\")\n	 \
   {\n	    $nyf=0;  \n	    while ($ARGV[$np+1] && \
!($ARGV[$np+1]=~/\\-/))\n	      {\n		$y_field[$nyf\
++]=$ARGV[++$np]-1;\n		$y_field_set=1;\n	      }\n\
\n	    $np++;\n    	    }\n	elsif ($value eq \"-fi\
le\")\n	    {\n	    $file= $ARGV[++$np];\n	    $fi\
le_set=1;\n	    $np++;\n    	    }       \n	elsif \
( $value eq \"h\" ||  $value eq \"-h\" || $value e\
q \"-H\" || $value eq \"-help\" || $value eq \"hel\
p\")\n	  {\n	    print STDOUT \"data_analyse: Anal\
yse and discretization of data\\n\";\n	    print S\
TDOUT \"       -file:    <file containing the data\
 to analyze>,.<def=STDIN>\\n\";\n	    print STDOUT\
 \"       -x: <field containing the X>,...........\
....<Def=0>\\n\";\n	    print STDOUT \"       -y: \
<field containing the Y>,...............<Def=1>\\n\
\";\n	    print STDOUT \"       -i:<Interval size \
on the X>,...............<Def=0>\\n\";\n	    print\
 STDOUT \"       -i:<0:only one interval>\\n\";\n	\
    print STDOUT \"       -r:<Range of the X>\\n\"\
;\n	    print STDOUT \"       -s:<Step on the  X, \
0 means non sliding bins>\\n\";\n	    print STDOUT\
 \"       -sd: print standard deviation on the Y\"\
;\n	    print STDOUT \"       -h  : print column h\
eader \\n\";\n	    exit (0);\n	  }\n	elsif ($value\
=~/-/)\n	  {\n	    print \"$value is not a valid F\
LAG[FATAL]\\n\";\n	    exit (0);\n	   } \n	elsif (\
$list eq \"\") \n	    {\n	    $file=$ARGV[$np];\n	\
    $np++;\n	    }\n	\n	\n      }\n\n\n\n\n\nif ($\
file eq \"stdin\")\n	{\n	$remove_file=1;\n	$file=\\
"tmp$$\";\n	open (F, \">$file\");\n	while (<STDIN>\
)\n		{\n		print F $_;\n		}\n	close (F);\n	 \n	;}\n\
\n\n\nif ($interval && $step)\n  {\n    my $nl;\n \
   open(F,$file);\n    while (<F>)\n      {\n	$lin\
e=$_;\n	\n	if (!/\\S/){next;}\n	@list=($line=~/(\\\
S+)/g);\n	$val{$nl}{x}=$list[$x_field];\n	$val{$nl\
}{y}=$list[$y_field[0]];\n	$nl++\n      }\n    clo\
se (F);\n    \n    for (my $a=$min; $a<($max+$inte\
rval); $a+=$step)\n      {\n	my ($avgx, $avgy, $cn\
);\n	\n	my $rmin=$a-$interval;\n	my $rmax=$a;\n	$c\
n=0;\n	for (my $b=0; $b<$nl; $b++)\n	  {\n	    my \
$x=$val{$b}{x};\n	    my $y=$val{$b}{y};\n	    if \
($x<=$rmax && $x>=$rmin)\n	      {\n		$avgx+=$x;\n\
		$avgy+=$y;\n		$cn++;\n		$tcn++;\n		$val{$b}{used\
}=1;\n	      }\n	  }\n	if ($cn)\n	  {\n	    $avgx/\
=$cn;\n	    $avgy/=$cn;\n	  }\n	printf \"%.3f %.3f\
 %.3f\\n\", $avgx, $avgy, $avgx-$avgy;\n      }\n \
   for (my $a=0; $a<$nl; $a++)\n      {\n	if ( !$v\
al{$a}{used})\n	  {\n	    print \"---$val{$a}{x}; \
$val{$a}{y}\\n\";\n	  }\n      }\n  }\nelse\n  {\n\
    if ($interval && $max)\n      {\n	$interval_si\
ze=($max-$min)/$interval;\n      }\n    elsif ($in\
terval)\n      {\n	open(F,$file);  \n	my $set_max=\
0;\n	my $set_min=0;\n	while (<F>)\n	  {\n	    my $\
v=$_;\n	    chomp($v);\n	    print \"--$v--\";\n	 \
   \n	    if ($v<$min ||!$set_min){$set_min=1;$min\
=$v;}\n	    if ($v>$max ||!$set_max){$set_max=1;$m\
ax=$v;}\n	  }\n	close (F);\n	print \"$min $max uuu\
u\";\n	$interval_size=($max-$min)/$interval;\n    \
  }\n    open(F,$file);  \n    while (<F>)\n      \
{\n	$line=$_;\n	if (!/\\S/){next;}\n	@list=($line=\
~/(\\S+)/g);\n	\n	if ($interval==0){$bin=0;}\n	els\
e{$bin=int (($list[$x_field]-$min)/($interval_size\
));}\n	\n	\n	if ($bin && $bin==$interval){$bin--;}\
\n	for ( $a=0; $a<$nyf; $a++)\n	  {\n	    $sum{$a}\
{$bin}+=$list[$y_field[$a]];\n	    $sum2{$a}{$bin}\
+=$list[$y_field[$a]]*$list[$y_field[$a]];\n	    $\
n{$a}{$bin}++;\n	  }\n      }\n    \n    if (!$int\
erval){$interval=1;}\n    for ( $a=0; $a<$interval\
; $a++)\n      {\n	printf ( \"%4d %4d \", $interva\
l_size*$a, $interval_size*($a+1));\n	for ( $b=0; $\
b<$nyf; $b++)	\n	  {\n	    $i=$interval*$a;\n	    \
if ( $n{$b}{$a}==0)\n	      {\n		$avg=0;\n		$sd=0;\
\n	      }\n	    else\n	      {\n		$avg=$sum{$b}{$\
a}/$n{$b}{$a};\n		$sd=sqrt($sum2{$b}{$a}*$n{$b}{$a\
}-$sum{$b}{$a}*$sum{$b}{$a})/($n{$b}{$a}*$n{$b}{$a\
});\n	      }\n	    if ($print_n) {printf \"%15.4f\
 \", $n{$b}{$a};}\n	    if ($print_sum){printf \"%\
15.4f \", $sum{$b}{$a};}\n	    if ($print_avg){pri\
ntf \"%15.4f \", $avg}\n	    if ($print_sd) {print\
f \"%15.4f \", $sd;}\n	  }\n	printf (\"\\n\");\n  \
    }\n  }\n\nif ( $remove_file){unlink $file;}\n"\
,"use File::Copy;\nuse Env qw(HOST);\nuse Env qw(H\
OME);\nuse Env qw(USER);\n\nforeach $v (@ARGV){$cl\
.=$v;}\n\n\nif ( $cl=~/-k(\\d+)/){$k=$1;}\nelse {$\
k=1;}\nif ( $cl=~/-w(\\d+)/){$w=$1;}\nelse {$w=-1;\
}\nif ( $cl=~/-p(\\d+)/){$p=$1;}\nelse {$p=-1;}\n\\
nwhile (<STDIN>)\n  {\n    @l=($_=~/(\\S+)/g);\n  \
  $v=$l[$k-1];\n    if ( !$h{$v}){@ll=($v, @ll);}\\
n    \n    if ( $w==-1)\n      {$h{$v}++;}\n    el\
se\n      {$h{$v}+=$l[$w-1];}\n\n    if ($p!=-1){$\
print{$v}=$l[$p-1];}\n\n  }\nforeach $v (@ll)\n  {\
\n    print \"$v $print{$v} $h{$v}\\n\";\n  }\n","\
\nuse Env qw(HOST);\nuse Env qw(HOME);\nuse Env qw\
(USER);\n$random_tag=int (rand 10000)+1;\n$unique_\
prefix=\"$$.$HOST.$random_tag\";\n$queue=\"distill\
ery.and.mid\";\n$monitor=0;\n$stderr_file=\"/dev/n\
ull\";\n$stdio_file=\"/dev/null\";\n$log_file=\"/d\
ev/null\";\n$pause_time=0;\n$max_sub_jobs=60;\n$mi\
n_sub_jobs=30;\n$output_all=0;\n$var='\\$';\n\nfor\
each $value ( @ARGV)\n    {\n	if ($value ne $ARGV[\
$np]) \n	    {\n	    ;\n	    }\n	elsif ($value eq \
\"-max_sub_jobs\")\n	    {\n	    $max_sub_jobs= $A\
RGV[++$np];\n	    $np++;\n    	    }	\n	elsif ($va\
lue eq \"-min_sub_jobs\" )\n	    {\n	    $min_sub_\
jobs= $ARGV[++$np];\n	    $np++;\n    	    }\n	els\
if ($value eq \"-para\")\n	    {\n	    $para=1;\n	\
    $monitor=1;\n	    $np++;\n    	    }\n	elsif (\
$value eq \"-monitor\") \n	    {\n	    $monitor=1;\
\n	    $np++;\n	    }\n	elsif ($value eq \"-no_mon\
itor\") \n	    {\n	    $monitor=0;\n	    $np++;\n	\
    }\n	elsif ($value eq \"-queue\")\n	    {\n	   \
 $queue=$ARGV[++$np];\n	    $np++;\n	    }	\n	elsi\
f ($value eq \"-stderr_file\")\n	    {\n	    $stde\
rr_file=$ARGV[++$np];\n	    $np++;\n	    }\n	elsif\
 ($value eq \"-stdio_file\")\n	    {\n	    $stdio_\
file=$ARGV[++$np];\n	    $np++;\n	    }\n	elsif ($\
value eq \"-output_all\")\n	    {\n	    $output_al\
l=1;\n	    $np++;\n	    }\n	elsif ($value eq \"-pa\
use\") \n	    {\n	    $pause_time=$ARGV[++$np];\n	\
    $np++;\n	    }\n	elsif ($value eq \"-log\")\n	\
      {\n	       $log=1;\n	       \n	       if ($A\
RGV[$np+1]=~/\\-\\S+/) \n	          {\n		  $log_fi\
le=\"stderr\";\n	          }\n	       else \n	    \
      {\n		  $log_file=$ARGV[++$np]; \n		  ++$np;\\
n		 \n	          }\n	      }\n	elsif ( $value eq \\
"-com\")\n	    {\n		\n		if (!$ARGV[$np+1]=~/^\\'/)\
 { $com=$ARGV[++$np];}\n		else {$com=$ARGV[++$np];\
}\n\n	     $np++;\n	    }\n	elsif ( $value eq \"-c\
heck\")\n	  {\n	    \n	    if (!$ARGV[$np+1]=~/^\\\
'/) { $check=$ARGV[++$np];}\n	    else {$check=$AR\
GV[++$np];}\n	    $np++;\n	  }\n	elsif ($com eq \"\
\") \n	    {\n	    $com_set=1;\n	    $com=$ARGV[$n\
p];\n	    \n	    $np++;\n	    }\n	elsif ($list eq \
\"\") \n	    {\n	    $list_set=1;\n	    $list=$ARG\
V[$np];\n	    $np++;\n	    }\n	elsif ( $var_set eq\
 \"\")\n	    {\n	    $var_set=1;\n	    $var=$ARGV[\
$np];\n	    $np++;\n	    }\n	}\n\n\n\n\nif ( $com \
eq \"\"){print \"You Need to Provide a Command [FA\
TAL]\\n\";\n	      die;\n	     }\n\n\n\nif ($list_\
set==0) \n    {\n    $x= int (rand 100000)+1;\n   \
 $tmp_file_name=\"tmp_file_$x\";\n    open ( TMP, \
\">$tmp_file_name\");\n    while (<STDIN>)\n      \
{\n	print TMP $_;\n      }\n    close (TMP);\n    \
open (F, $tmp_file_name);\n    }\nelse \n    {\n  \
  open (F, $list);\n    }\n\nif ($para==0) \n    {\
\n\n     @tc_list= <F>;\n     close (F); \n     \n\
     foreach $val(@tc_list) \n	    {\n	      \n	  \
    \n	      \n	      $loc_com=$com;\n	      if ($\
check){$loc_check=$check;}\n	      \n	      @i_val\
=($val=~/([^\\s]+)/g);\n	      \n	      if ( $#i_v\
al==0)\n		{\n		  if ($check){$loc_check=~s/$var/$i\
_val[0]/g;}\n		  $loc_com=~s/$var/$i_val[0]/g;\n		\
}\n	      else\n		{\n		  for ($n=1; $n<=$#i_val+1;\
$n++ )\n		    {\n		      \n		      $sub=\"$var$n\"\
;\n		      \n		      $loc_com=~s/$sub/$i_val[$n-1]\
/g;\n		      if ($check){$loc_check=~s/$var/$i_val\
[0]/g;}\n		    }\n		}\n	      if ( $check && -e $l\
oc_check)\n		{\n		  print STDERR \"skipping $loc_c\
om...\\n\";\n		  }\n	      else\n		{\n		  system \\
"$loc_com\";\n		}\n	    }\n    exit;\n    }\n\nels\
if ($para==1) \n    {\n    print STDERR \"do paral\
lel execution of: \\\"$com $list\\\"\\n\";\n    \n\
    if ($log==1) \n	{\n	if ($log_file eq \"stdout\\
" || $log_file eq \"stderr\" ) \n		{\n		$log_file=\
\"\";\n	        }\n\n        else \n		{\n		system \
\"echo LOG FILE> $log_file\";\n		\n	        }\n	}\\
n    else	\n	{\n	open ( OUT, \">/dev/null\");\n	}\\
n	\n    \n    $id=0;\n    $n_sub=0;\n    while ($v\
al=<F>) \n	    {	    	    \n	    $job_log[$id]=\"$\
HOME/tmp/$unique_prefix.$id.log_file\";\n	    \n	 \
   $job=$unique_prefix.\"_$id\";\n	    open (JOB, \
\">$job\");\n	    \n	    $loc_com=$com;\n	    chop\
 $val;\n\n	    $loc_com=~s/\\$/$val/g;\n	 \n	    p\
rint JOB \"#!/bin/csh\\n\";\n	    print JOB \"#\\$\
 -cwd\\n\";\n	    print JOB \"#\\$ -N $unique_pref\
ix\\n\";\n	    if ($queue && !($queue eq \" \")) {\
print JOB \"#\\$ -l $queue\\n\";}\n	    print JOB \
\"#\\n\";	    \n            print JOB \"$loc_com\\\
n\";\n	    print JOB \"echo FINISHED  >> $job_log[\
$id]\\n\";\n	    print JOB \"pwd\\n\";\n	    \n	  \
  close (JOB);\n	    if ( $output_all==1)\n		{\n		\
system \"qsub $job >  $unique_prefix\";		\n	      \
  }\n	    else\n		{system \"qsub $job -e $stderr_f\
ile -o $stdio_file >$unique_prefix\";	        \n	 \
       } \n\n\n\n	    print STDERR \"$id: $output_\
all\\n\";\n	    $n_sub++;\n	    if ( $max_sub_jobs\
 && $n_sub==$max_sub_jobs) \n		{\n		$n_sub=monitor\
_process($min_sub_jobs,@job_log); 		 \n		\n	      \
  }	\n	   \n            unlink $unique_prefix;\n	 \
   sleep $pause_time;\n	    $id++;\n	    }\n\n    \
close (OUT);\n    close (F);\n\n    print STDERR \\
"Your $id Jobs Have Been Submited (NAME=$unique_pr\
efix)\\n\";\n    monitor_process (0, @job_log);\n \
   foreach $file(@job_log) {if (-e $file) {unlink(\
$file);}}\n    \n    }\n\nsub monitor_process ( @j\
ob_list)\n    {\n    my (@job_list)=@_;\n    my $m\
in_sub_jobs=shift (@job_list);\n    my $n_sub_jobs\
;\n    my $finished;\n    my $n=0;\n\n    $n_sub_j\
obs=-1;\n    $finished=0;\n    print STDERR \"\\nM\
onitor Batch: [$min_sub_jobs]\";\n       \n    whi\
le (!$finished && (($n_sub_jobs>$min_sub_jobs)|| $\
n_sub_jobs==-1) ) \n	{\n	$finished=1;\n	$n_sub_job\
s=0;\n	$n=0;\n	foreach $file (@job_list)\n	       \
 {\n	\n		if (-e $file){;}\n		else \n		    {\n		   \
 $finished=0; $n_sub_jobs++;\n	            }\n	   \
     }\n	system \"sleep 1\";\n        }\n    \n   \
 return $n_sub_jobs;\n    }\n    \n    \nif ($tmp_\
file_name){unlink($tmp_file_name);}\n","\n\nforeac\
h ($np=0; $np<=$#ARGV; $np++)\n    {\n    $value=$\
ARGV[$np];\n\n    if ($value eq \"-file\")\n      \
{\n      $file= $ARGV[++$np];\n      }\n    elsif \
($value eq \"-type\")\n      {\n        $type= $AR\
GV[++$np];\n      }\n    elsif ($value eq \"-insti\
tute\")\n      {\n        $institute= $ARGV[++$np]\
;\n      }\n    elsif ($value eq \"-author\")\n   \
   {\n        $author= $ARGV[++$np];\n      }\n   \
 elsif ($value eq \"-date\")\n      {\n        $da\
te= $ARGV[++$np];\n      }\n     elsif ($value eq \
\"-program\")\n      {\n        $program= $ARGV[++\
$np];\n      }\n    elsif ($value eq \"-email\")\n\
      {\n        $email= $ARGV[++$np];\n      }\n \
   else\n      {\n	print \"$value is an unkown arg\
ument[FATAL]\\n\";\n	exit (1);\n      }\n  }\n\n\n\
\nopen F, $file || die;\nprint $INSTITUTE;\nif ( $\
type eq \"c\"){print \"/**************************\
****COPYRIGHT NOTICE******************************\
*/\\n\";}\nif ( $type eq \"perl\"){print \"#######\
#######################COPYRIGHT NOTICE###########\
###################/\\n\";}\nif ( $type eq \"txt\"\
){print \"-------------------------------COPYRIGHT\
 NOTICE------------------------------/\\n\";}\n\n\\
nwhile (<F>)\n  {\n  s/\\$INSTITUTE/$institute/g;\\
n  s/\\$AUTHOR/$author/g;\n  s/\\$DATE/$date/g;\n \
 s/\\$PROGRAM/$program/g;  \n  s/\\$EMAIL/$email/g\
;  \n  if ( $type eq \"txt\"){print $_;}\n  elsif \
($type eq \"c\"){chop $_; print \"\\/*$_*\\/\\n\";\
}\n  elsif ($type eq \"perl\"){print \"\\#$_\";}\n\
}\nclose (F);\nif ( $type eq \"c\"){print \"/*****\
*************************COPYRIGHT NOTICE*********\
**********************/\\n\";}\nif ( $type eq \"pe\
rl\"){print \"##############################COPYRI\
GHT NOTICE##############################/\\n\";}\n\
if ( $type eq \"txt\"){print \"-------------------\
------------COPYRIGHT NOTICE----------------------\
--------/\\n\";}\n\n","\nwhile (<>)	\n	{\n	s/\\=cc\
/123456789/g;\n	s/\\bcc/\\$\\(CC\\)/g;\n	s/1234567\
89/\\=cc/g;\n	print $_;\n	}\n\n","$version=\"1.00\\
";\n$rseed= int(rand(100000))+1;\n\n\nif ( $#ARGV=\
=-1)\n  {\n    print \"msa2bootstrap -i <input_fil\
e> -input <seq|msa|matrix|tree> -n <N-Boostrap> -o\
 <outtree> -tmode <nj|upgma|parsimony|ml> -dmode <\
kimura> -alignpg <t_coffee | muscle | clustalw> -r\
tree <file> -stype <prot|cdna|dna> -recompute -sys\
tem <cygwin|unix>\";\n    print \"\\n\\t-i: input \
file, can be sequneces, msa, matrix, trees, type i\
s specified via -input\";\n    print \"\\n\\t-inpu\
t: Type of input data\";\n    print \"\\n\\t\\tmsa\
: msa in fasta format\";\n    print \"\\n\\t\\tseq\
: compute an msa with -alignpg\";\n    print \"\\n\
\\t\\tmatrix: phylipp distance matrix fed directly\
 to method -tmode [caveat: tmode=nj or upgma]\";\n\
    print \"\\n\\t\\ttree: list of newick trees di\
rectly fed to consence in order to generate a boot\
straped tree\";\n    \n    print \"\\n\\t-n: numbe\
r of bootstrap replicates\";\n    print \"\\n\\t-o\
: name of the output tree. Files are not overwritt\
en. Use -recompute to overwrite existing file\";\n\
    print \"\\n\\t-tmode: tree mode: nj|upgma|pars\
imony|ml\";\n    print \"\\n\\t-dmode: distance mo\
de\";\n    print \"\\n\\t-alignpg: program for ali\
gning sequences (t_coffee=default)\";\n    print \\
"\\n\\t-rtree: replicate tree file (default: no fi\
le)\";\n    print \"\\n\\t-rmsa: replicate msa fil\
e (default: no file)\";\n    print \"\\n\\t-rmat: \
replicate matrix file (default: no file)\";\n    p\
rint \"\\n\\t-stype: sequence type: protein, dna o\
r cdna\";\n    print \"\\n\\t-recompute: force fil\
es to be overwritten\";\n    print \"\\n\\t-system\
: cygwin|unix\";\n      \n\n    \n    &my_exit (EX\
IT_FAILURE);\n  }\nforeach $arg (@ARGV){$command.=\
\"$arg \";}\n\nprint \"CLINE: $command\\n\";\n$thr\
eshold=100;\n$trim_msa=0;\n$stype=\"prot\";\nprint\
 \"msa2bootstrap \";\n\n$system=\"cygwin\";\nif(($\
command=~/\\-system (\\S+)/))\n  {\n    $system=$1\
;\n    if ( $system eq \"cygwin\")\n      {\n	$exe\
c_extension=\".exe\";\n      }\n    elsif ( $syste\
m eq \"unix\")\n      {\n	$exec_extension=\"\";\n	\
print \"system=Unix\";die;\n      }\n    else\n   \
   {\n	print \"msa2boostrap: -system=$system is an\
 unknown mode [FATAL]\\n\"; die;\n      }\n    \n \
   print \"-system $system \";\n  }\nif(($command=\
~/\\-stype (\\S+)/))\n  {\n    $stype=$1;\n  }\npr\
int \"-stype=$stype \";\n\n\n\nif(($command=~/\\-i\
 (\\S+)/))\n  {\n    $msa=$1;\n    print \"-i $msa\
 \";\n  }\n\nif(($command=~/\\-rtree (\\S+)/))\n  \
{\n    $rtree=$1;\n    print \"-rtree=$rtree \";\n\
  }\n\nif(($command=~/\\-rmsa (\\S+)/))\n  {\n    \
$rmsa=$1;\n  }\nif(($command=~/\\-rmat (\\S+)/))\n\
  {\n    $rmat=$1;\n  }\n$input=\"seq\";\nif(($com\
mand=~/\\-input (\\S+)/))\n  {\n    $input=$1;\n  \
}\nprint \"-input=$input \";\n\n$dmode=\"kimura\";\
\nif(($command=~/\\-dmode (\\S+)/))\n  {\n    $dmo\
de=$1;\n  }\nprint \"-dmode=$dmode \";\n$alignpg=\\
"muscle\";\nif(($command=~/\\-alignpg (\\S+)/))\n \
 {\n    $alignpg=$1;\n  }\nprint \"-alignpg=$dmode\
 \";\n\n$tmode=\"nj\";\nif(($command=~/\\-tmode (\\
\S+)/))\n  {\n    $tmode=$1;\n  }\nprint \"-tmode=\
$tmode \";\n$recompute=0;\nif(($command=~/\\-recom\
pute/))\n  {\n    $recompute=1;\n    print \"-reco\
mpute \";\n  }\n\n$out=$msa;\n$out=~s/\\..*//;\n$o\
ut.=\".bph\";\nif(($command=~/\\-o (\\S+)/))\n  {\\
n    $out=$1;\n    \n  }\nprint \"-out=$out \";\ni\
f (-e $out && !$recompute)\n  {\n    print \"\\nNo\
 Computation Required $out already exists\\n\";\n \
   &my_exit (EXIT_SUCCESS);\n    \n  }\n\n$n=100;\\
nif(($command=~/\\-n (\\d+)/))\n  {\n    $n=$1;\n \
 }\nprint \"-n=$n \";\n$seed=3;\nif(($command=~/\\\
-s (\\d+)/))\n  {\n    $seed=$1;\n  }\nprint \"-s=\
$seed \";\n\nif(($command=~/\\-run_name (\\d+)/))\\
n  {\n    $suffix=$1;\n  }\nelse\n  {\n    $msa=~/\
([^.]+)/;\n    $suffix=$1;\n  }\nprint \"-run_name\
=$suffix\\n\";\n\n\nif ( $input eq \"seq\")\n  {\n\
    $seq=$msa;\n    $msa=\"$suffix.prot_msa\";\n  \
  \n    if ($stype eq \"cdna\")\n      {\n	$cdna_s\
eq=$seq;\n	$clean_cdna_seq=&vtmpnam();\n	$seq=&vtm\
pnam();\n	`t_coffee -other_pg seq_reformat -in $cd\
na_seq -action +clean_cdna >$clean_cdna_seq`;\n	`t\
_coffee -other_pg seq_reformat -in $clean_cdna_seq\
 -action +translate >$seq`;\n	\n      }\n\n    if \
(!-e $msa || $recompute)\n      {\n	print \"\\n###\
##   Compute an MSA With $alignpg\\n\";\n	\n	if ( \
$alignpg eq \"t_coffee\")\n	  {`$alignpg $seq -out\
file=$msa >/dev/null 2>/dev/null`;}\n	elsif ( $ali\
gnpg eq \"muscle\")\n	  {\n	    `$alignpg -in $seq\
 > $msa 2>/dev/null`;\n	  }\n	elsif ( $alignpg eq \
\"clustalw\")\n	  {\n	    `$alignpg -infile=$seq -\
outfile=$msa -quicktree >/dev/null 2>/dev/null`;\n\
	  }\n	elsif ( $align eq \"mafft\")\n	  {\n	    `$\
alignpg $seq > $msa >/dev/null 2>/dev/null`;\n	  }\
\n	else\n	  {\n	    `$alignpg -in=$seq -outfile=$m\
sa`;\n	  }\n      }\n    if (!-e $msa)\n      {\n	\
print \"\\nError: $alignpg Could Not produce the M\
SA $msa [FATAL]\\n\";\n      }\n\n    if ($stype e\
q \"cdna\")\n      {\n	$msa2=\"$suffix.cdna_msa\";\
\n	`t_coffee -other_pg seq_reformat -in $clean_cdn\
a_seq -in2 $msa -action +thread_dna_on_prot_aln -o\
utput fasta_aln  >$msa2`;\n	$msa=$msa2;\n      }\n\
    \n    $input=\"msa\";\n  }\n\n\n\n$seqboot_o=&\
vtmpnam();\n$seqboot_c=&vtmpnam();\n\n$protdist_o=\
&vtmpnam();\n$protdist_c=&vtmpnam();\nif ( $input \
eq \"msa\")\n  {\n    if ($tmode eq \"nj\" || $tmo\
de eq \"upgma\"){$input=\"matrix\";}\n    \n    $l\
msa= &vtmpnam ();\n    `t_coffee -other_pg seq_ref\
ormat -in $msa -output phylip_aln > $lmsa`;\n    \\
n    if ( -e \"outfile\"){unlink (\"outfile\");}\n\
    # run seqboot\n  \n    if ( $n>1)\n      {\n	p\
rint \"Run SeqBoot .....\";\n	open (F, \">$seqboot\
_c\");\n	print F \"$lmsa\\nR\\n$n\\nY\\n$seed\\n\"\
;\n	close (F);\n	`seqboot$exec_extension  < $seqbo\
ot_c`;\n	if ( -e \"outfile\"){ print \"[OK]\\n\";}\
\n	else { print \"[FAILED]\\n\";&my_exit (EXIT_FAI\
LURE);}\n	`mv outfile $seqboot_o`;\n      }\n    e\
lse\n      {\n	`cp $lmsa $seqboot_o`;\n      }\n\n\
    if ($rmsa){`cp $seqboot_o $rmsa`;}\n    \n    \
if ($tmode eq \"nj\" || $tmode eq \"upgma\")\n    \
  {\n	if ( $stype eq \"prot\")\n	  {\n	    # run p\
rotdist\n	    print \"Run Protdist [dmode=$dmode]\\
";\n	    if ($dmode eq \"kimura\")\n	      {\n		$d\
mode=\"P\\nP\\nP\";\n	      }\n	    else\n	      {\
\n		print \"\\n$dmode is an unknown mode for Protd\
ist [FATAL:msa2bootstrap.pl]\\n\";\n		&my_exit (EX\
IT_FAILURE);\n	      }\n	    open (F, \">$protdist\
_c\");\n	    if ($n>1){print F \"$seqboot_o\\n$dmo\
de\\nM\\nD\\n$n\\nY\\n\";}\n	    else {printf F \"\
$seqboot_o\\n$dmode\\nY\\n\";}\n	    close (F);\n	\
    `protdist$exec_extension  < $protdist_c`;\n	  \
  if ( -e \"outfile\"){ print \"[OK]\\n\";}\n	    \
else { print \"[FAILED]\\n\";&my_exit (EXIT_FAILUR\
E);}\n	    `mv outfile $protdist_o`;\n	 \n	  }\n	e\
lsif ( $stype eq \"cdna\" || $stype eq \"dna\")\n	\
  {\n	    print \"Run dnadist [dmode=default\";\n	\
    open (F, \">$protdist_c\");\n	    if ($n>1){pr\
int F \"$seqboot_o\\nM\\nD\\n$n\\nY\\n\";}\n	    e\
lse {printf F \"$seqboot_o\\nY\\n\";}\n	    close \
(F);\n	    `protdist$exec_extension  < $protdist_c\
`;\n	    if ( -e \"outfile\"){ print \"[OK]\\n\";}\
\n	    else { print \"[FAILED]\\n\";&my_exit (EXIT\
_FAILURE);}\n	    `mv outfile $protdist_o`;\n	  }\\
n      }\n  }\nelsif ( $input eq \"matrix\")\n  {\\
n    $protdist_o=&vtmpnam();\n    print \"MSA: $ms\
a\\n\";\n    `cp $msa $protdist_o`;\n    $n=1;\n  \
}\n\n\n\n\n\n$nb_o=&vtmpnam();\n$nb_c=&vtmpnam();\\
nif ($input eq \"matrix\" && $tmode ne \"parsimony\
\" && $tmode ne \"ml\")\n  {\n    print \"Run neig\
hbor [tmode=$tmode]\";\n\n    if ($tmode eq \"nj\"\
)\n      {\n	$tmode=\"\\nN\\nN\";\n      }\n    el\
sif ( $tmode eq \"upgma\")\n      {\n	$tmode = \"\\
\nN\";\n      }\n    else\n      {\n	print \"\\n E\
RROR: $tmode is an unknown tree computation mode\\\
n\";\n	&my_exit (EXIT_FAILURE);\n      }\n\n    op\
en (F, \">$nb_c\");\n    if ($n>1){print F \"$prot\
dist_o$tmode\\nM\\n$n\\n$seed\\nY\\n\";}\n    else\
 {print F \"$protdist_o$tmode\\nY\\n\";}\n    clos\
e (F);\n\n    `neighbor$exec_extension  < $nb_c`;\\
n    if ( -e \"outtree\"){ print \"[Neighbor OK]\\\
n\";}\n    else { print \"[FAILED]\\n\";&my_exit (\
EXIT_FAILURE);}\n    `mv outtree $nb_o`;\n    unli\
nk (\"outfile\");\n  }\nelsif ($input eq \"msa\" &\
& $tmode eq \"parsimony\")\n  {\n    if ( -e \"out\
file\"){unlink (\"outfile\");}\n    if ( -e \"outt\
ree\"){unlink (\"outtree\");}\n    \n    if ($styp\
e eq \"prot\")\n      {\n	print \"Run protpars [tm\
ode=$tmode]\";\n	open (F, \">$nb_c\");\n	if ($n>1)\
{print F \"$seqboot_o\\nM\\nD\\n$n\\n$seed\\n10\\n\
Y\\n\";}\n	else {print F \"$seqboot_o\\nY\\n\";}\n\
	close (F);\n	`protpars$exec_extension  < $nb_c`;\\
n      }\n    elsif ( $stype eq \"dna\" || $stype \
eq \"cdna\")\n      {\n	print \"Run dnapars [tmode\
=$tmode]\";\n	open (F, \">$nb_c\");\n	if ($n>1){pr\
int F \"$seqboot_o\\nM\\nD\\n$n\\n$seed\\n10\\nY\\\
n\";}\n	else {print F \"$seqboot_o\\nY\\n\";}\n	cl\
ose (F);\n	`dnapars$exec_extension  < $nb_c`;\n   \
   }\n    if ( -e \"outtree\"){ print \"[OK]\\n\";\
}\n    else { print \"[FAILED]\\n\";&my_exit (EXIT\
_FAILURE);}\n    `mv outtree $nb_o`;\n   unlink (\\
"outfile\");\n  }\nelsif ($input eq \"msa\" && $tm\
ode eq \"ml\")\n  {\n    if ( -e \"outfile\"){unli\
nk (\"outfile\");}\n    if ( -e \"outtree\"){unlin\
k (\"outtree\");}\n    \n    if ($stype eq \"prot\\
")\n      {\n	print \"Error: ML impossible with Pr\
otein Sequences [ERROR]\";\n	&my_exit (EXIT_FAILUR\
E);\n      }\n    elsif ( $stype eq \"dna\" || $st\
ype eq \"cdna\")\n      {\n	print \"Run dnaml [tmo\
de=$tmode]\";\n	open (F, \">$nb_c\");\n	if ($n>1){\
print F \"$seqboot_o\\nM\\nD\\n$n\\n$seed\\n10\\nY\
\\n\";}\n	else {print F \"$seqboot_o\\nY\\n\";}\n	\
close (F);\n	`dnaml$exec_extension  < $nb_c`;\n   \
   }\n    if ( -e \"outtree\"){ print \"[OK]\\n\";\
}\n    else { print \"[FAILED]\\n\";&my_exit (EXIT\
_FAILURE);}\n    `mv outtree $nb_o`;\n   unlink (\\
"outfile\");\n  }\n\n\nelse\n  {\n    `cp $msa $nb\
_o`;\n    $n=2;\n  }\n\nif ($rmsa && -e $seqboot_o\
){print \"\\nOutput List of $n Replicate MSA: $rms\
a\\n\";`cp $seqboot_o $rmsa`;}\nif ($rmat && -e $p\
rotdist_o){print \"\\nOutput List of $n Replicate \
MATRICES: $rmat\\n\";`cp $protdist_o $rmat`;}\nif \
($rtree && -e $nb_o){print \"\\nOutput List of $n \
Replicate TREES: $rtree\\n\";`cp $nb_o $rtree`;}\n\
\n\n\n$con_o=&vtmpnam();\n$con_c=&vtmpnam();\nif (\
$n >1)\n  {\n    print \"Run Consense.....\";\n   \
 open (F, \">$con_c\");\n    print F \"$nb_o\\nY\\\
n\";\n    close (F);\n    `consense$exec_extension\
  < $con_c`;\n    if ( -s \"outtree\"  > 0) { prin\
t \"[OK]\\n\";}\n    else { print \"[FAILED]\\n\";\
&my_exit (EXIT_FAILURE);}\n    `mv outtree $con_o`\
;\n    unlink (\"outfile\");\n  }\nelse\n  {\n    \
`cp $nb_o $con_o`;\n  }\n\n\n`cp $con_o $out`;\nif\
 ( !-e $out)\n  {\n    print \"Tree Computation fa\
iled [FAILED]\\n\";\n    &my_exit (EXIT_FAILURE);\\
n  }\nelsif ($n>1)\n  {\n    print \"\\nOutput Boo\
tstrapped Tree: $out\\n\";\n    $avg=`t_coffee -ot\
her_pg seq_reformat -in $out -action +avg_bootstra\
p`;\n    $avg=~s/\\n//g;\n    print \"$avg\\n\";\n\
  }\nelse\n  {\n    print \"\\nOutput Tree: $out\\\
n\";\n  }\n\nopen (F, \"$out\");\nwhile (<F>)\n  {\
\n    \n    $tree.=$_;\n  }\nclose (F);\n$tree=~s/\
\\n//g;\nprint \"BPH: $tree\\n\";\n\n\n&my_exit (E\
XIT_SUCCESS);\n\nsub my_exit \n  {\n    my $m=@_[0\
];\n    &clean_vtmpnam();\n    exit ($m);\n  }\nsu\
b vtmpnam \n  {\n    my $file;\n\n\n    $ntmp++;\n\
    $file=\"tmp4msa2bootstrap.$rseed.$$.$ntmp\";\n\
    \n    push (@tmpfile, $file);\n    return $fil\
e;\n  }\nsub clean_vtmpnam \n  {\n    my $t;\n    \
foreach $t (@tmpfile)\n      {\n	if ( -e $t){unlin\
k ($t)};\n      }\n  }\n","use Env;\nuse FileHandl\
e;\nuse Cwd;\nuse File::Path;\nuse Sys::Hostname;\\
n\n\nour $PIDCHILD;\nour $ERROR_DONE;\nour @TMPFIL\
E_LIST;\nour $EXIT_FAILURE=1;\nour $EXIT_SUCCESS=0\
;\n\nour $REFDIR=getcwd;\nour $EXIT_SUCCESS=0;\nou\
r $EXIT_FAILURE=1;\n\nour $PROGRAM=\"tc_generic_me\
thod.pl\";\nour $CL=$PROGRAM;\n\nour $CLEAN_EXIT_S\
TARTED;\nour $debug_lock=$ENV{\"DEBUG_LOCK\"};\nou\
r $debug_generic_method=$ENV{\"DEBUG_GENERIC_METHO\
D\"};\nour $LOCKDIR=$ENV{\"LOCKDIR_4_TCOFFEE\"};\n\
if (!$LOCKDIR){$LOCKDIR=getcwd();}\nour $ERRORDIR=\
$ENV{\"ERRORDIR_4_TCOFFEE\"};\nour $ERRORFILE=$ENV\
{\"ERRORFILE_4_TCOFFEE\"};\n&set_lock ($$);\nif (i\
sshellpid(getppid())){lock4tc(getppid(), \"LLOCK\"\
, \"LSET\", \"$$\\n\");}\nour %RECODE;\nour $RECOD\
E_N;\n\n\n\n\nour $BLAST_MAX_NRUNS=2;\nour $COMMAN\
D;\nour $PIDCHILD;\n\n$REF_EMAIL=\"\";\n$tmp_dir=\\
"\";\n$init_dir=\"\";\n\n\n$test=0;\nif ($test==1)\
\n  {\n    $SERVER=\"NCBI\";\n    $query=$ARGV[0];\
\n    $hitf=$ARGV[1];\n    %s=read_fasta_seq($quer\
y);\n    @sl=keys(%s);\n    &blast_xml2profile (\"\
xx\", $s{$sl[0]}{seq},$maxid,$minid,$mincov, $hitf\
);\n    myexit ($EXIT_FAILURE);\n  }\n\nforeach $v\
(@ARGV){$cl.=\"$v \";}\n$COMMAND=$cl;\n($mode)=&my\
_get_opt ( $cl, \"-mode=\",1,0);\n\n($A)=(&my_get_\
opt ( $cl, \"-name1=\",0,0));\n($B)=(&my_get_opt (\
 $cl, \"-name2=\",0,0));\n($TMPDIR)=(&my_get_opt (\
 $cl, \"-tmpdir=\",0,0));\n($CACHE)=(&my_get_opt (\
 $cl, \"-cache=\",0,0));\n($SERVER)=((&my_get_opt \
( $cl, \"-server=\",0,0)));\n($EMAIL)=((&my_get_op\
t ( $cl, \"-email=\",0,0)));\n\nif (!$A){$A=\"A\";\
}\nif (!$B){$B=\"B\";}\n\n\nif (!$TMPDIR)\n  {\n  \
  $HOME=$ENV{HOME};\n    if ($ENV{TMP_4_TCOFFEE}){\
$TMPDIR=$ENV{TMP_4_TCOFFEE};}\n    else{$TMPDIR=\"\
$HOME/.t_coffee/tmp/\";}\n  }\nif ( ! -d $TMPDIR)\\
n  {\n    mkdir $TMPDIR;\n  }\nif ( ! -d $TMPDIR)\\
n  {\n    print \"ERROR: Could not create temporar\
y dir: $TMPDIR\\n\";\n    myexit ($EXIT_FAILURE);\\
n  }\n\n$EMAIL=~s/XEMAILX/\\@/g;\nif (!$EMAIL)\n  \
{\n    if ($ENV{EMAIL_4_TCOFFEE}){$EMAIL=$ENV{EMAI\
L_4_TCOFFEE};}\n    elsif ($ENV{EMAIL}){$EMAIL=$EN\
V{EMAIL};}\n    else {$EMAIL=$REF_EMAIL;}\n  }\n\n\
($maxid,$minid,$mincov,$trim)=(&my_get_opt ( $cl, \
\"-maxid=\",0,0, \"-minid=\",0,0,\"-mincov=\",0,0,\
 \"-trim=\",0,0));\n\nif (!$cl=~/\\-maxid\\=/){$ma\
xid=95;}\nif (!$cl=~/\\-minid\\=/){$minid=35;}\nif\
 (!$cl=~/\\-mincov\\=/){$mincov=80;}\nif (!$cl=~/\\
\-trim\\=/){$trim;}\n\n\n\n\nif ($mode eq \"seq_ms\
a\")\n  {\n    &seq2msa($mode,&my_get_opt ( $cl, \\
"-infile=\",1,1, \"-method=\",1,2, \"-param=\",0,0\
,\"-outfile=\",1,0, \"-database=\",0,0));\n  }\nel\
sif ($mode eq \"blast2prf\")\n  {\n\n    blast2prf\
 (&my_get_opt ( $cl, \"-infile=\",0,0,\"-seqfile=\\
",0,0,\"-outfile=\",0,0));\n  }\nelsif ( $mode eq \
\"tblastx_msa\")\n  {\n    &seq2tblastx_lib ($mode\
,&my_get_opt ( $cl, \"-infile=\",1,1, \"-outfile=\\
",1,0));\n  }\nelsif ( $mode eq \"tblastpx_msa\")\\
n  {\n    &seq2tblastpx_lib ($mode,&my_get_opt ( $\
cl, \"-infile=\",1,1, \"-outfile=\",1,0));\n  }\ne\
lsif ( $mode eq \"thread_pair\")\n  {\n    &seq2th\
read_pair($mode,&my_get_opt ( $cl, \"-infile=\",1,\
1, \"-pdbfile1=\",1,1, \"-method=\",1,2,\"-param=\\
",0,0, \"-outfile=\",1,0, ));\n  }\nelsif ( $mode \
eq \"pdbid_pair\")\n  {\n    &seq2pdbid_pair($mode\
,&my_get_opt ( $cl, \"-pdbfile1=\",1,0, \"-pdbfile\
2=\",1,0, \"-method=\",1,2,\"-param=\",0,0, \"-out\
file=\",1,0, ));\n  }\nelsif ( $mode eq \"pdb_pair\
\")\n  {\n    &seq2pdb_pair($mode,&my_get_opt ( $c\
l, \"-pdbfile1=\",1,1, \"-pdbfile2=\",1,1, \"-meth\
od=\",1,2,\"-param=\",0,0, \"-outfile=\",1,0, ));\\
n  }\nelsif ( $mode eq \"rnapdb_pair\")\n{\n    &s\
eq2rnapdb_pair($mode,&my_get_opt ( $cl, \"-pdbfile\
1=\",1,1, \"-pdbfile2=\",1,1, \"-method=\",1,2,\"-\
param=\",0,0, \"-outfile=\",1,0, ));\n}\nelsif ( $\
mode eq \"profile_pair\")\n  {\n     &seq2profile_\
pair($mode,&my_get_opt ( $cl, \"-profile1=\",1,1, \
\"-profile2=\",1,1, \"-method=\",1,2,\"-param=\",0\
,0, \"-outfile=\",1,0 ));\n  }\nelsif ($mode eq \"\
pdb_template_test\")\n  {\n    &blast2pdb_template\
_test ($mode,&my_get_opt ( $cl, \"-infile=\",1,1))\
;\n\n  }\nelsif ($mode eq \"psi_template_test\")\n\
  {\n    &psiblast2profile_template_test ($mode,&m\
y_get_opt ( $cl, \"-seq=\",1,1,\"-blast=\",1,1));\\
n\n  }\n\nelsif ( $mode eq \"pdb_template\")\n  {\\
n    &blast2pdb_template ($mode,&my_get_opt ( $cl,\
 \"-infile=\",1,1, \"-database=\",1,0, \"-method=\\
",1,0, \"-outfile=\",1,0,\"-pdb_type=\",1,0));\n  \
}\n\nelsif ( $mode eq \"profile_template\")\n  {\n\
\n    &seq2profile_template ($mode,&my_get_opt ( $\
cl, \"-infile=\",1,1, \"-database=\",1,0, \"-metho\
d=\",1,0, \"-outfile=\",1,0));\n  }\nelsif ( $mode\
 eq \"psiprofile_template\")\n  {\n    &seq2profil\
e_template ($mode,&my_get_opt ( $cl, \"-infile=\",\
1,1, \"-database=\",1,0, \"-method=\",1,0, \"-outf\
ile=\",1,0));\n  }\nelsif ( $mode eq \"RNA_templat\
e\")\n  {\n    &seq2RNA_template ($mode,&my_get_op\
t ( $cl, \"-infile=\",1,1,\"-pdbfile=\",1,1,\"-out\
file=\",1,0));\n  }\nelsif ( $mode eq \"tm_templat\
e\")\n  {\n    &seq2tm_template ($mode,&my_get_opt\
 ( $cl, \"-infile=\",1,1,\"-arch=\",1,1,\"-psv=\",\
1,1, \"-outfile=\",1,0));\n  }\nelsif ( $mode eq \\
"psitm_template\")\n  {\n    &seq2tm_template ($mo\
de,&my_get_opt ( $cl, \"-infile=\",1,1, \"-arch=\"\
,1,1,\"-psv=\",1,1, \"-outfile=\",1,0,\"-database=\
\",1,0));\n  }\nelsif ( $mode eq \"ssp_template\")\
\n  {\n    &seq2ssp_template ($mode,&my_get_opt ( \
$cl, \"-infile=\",1,1,\"-seq=\",1,1,\"-obs=\",1,1,\
 \"-outfile=\",1,0));\n  }\nelsif ( $mode eq \"psi\
ssp_template\")\n  {\n    &seq2ssp_template ($mode\
,&my_get_opt ( $cl, \"-infile=\",1,1,\"-seq=\",1,1\
,\"-obs=\",1,1, \"-outfile=\",1,0));\n  }\n\n\n\ne\
lse\n  {\n    myexit(flush_error( \"$mode is an un\
known mode of tc_generic_method.pl\"));\n  }\nmyex\
it ($EXIT_SUCCESS);\n\n\nsub seq2ssp_template\n  {\
\n  my ($mode, $infile,$gor_seq,$gor_obs,$outfile)\
=@_;\n  my %s, %h;\n  my $result;\n  my (@profiles\
);\n  &set_temporary_dir (\"set\",$infile,\"seq.pe\
p\");\n  %s=read_fasta_seq (\"seq.pep\");\n\n\n  o\
pen (R, \">result.aln\");\n\n  #print stdout \"\\n\
\";\n  foreach $seq (keys(%s))\n    {\n\n      ope\
n (F, \">seqfile\");\n      $s{$seq}{seq}=uc$s{$se\
q}{seq};\n      print (F \">$s{$seq}{name}\\n$s{$s\
eq}{seq}\\n\");\n      close (F);\n      $lib_name\
=\"$s{$seq}{name}.ssp\";\n      $lib_name=&clean_f\
ile_name ($lib_name);\n\n      if ($mode eq \"ssp_\
template\"){&seq2gor_prediction ($s{$seq}{name},$s\
{$seq}{seq}, \"seqfile\", $lib_name,$gor_seq, $gor\
_obs);}\n      elsif ($mode eq \"psissp_template\"\
)\n	{\n	  &seq2msa_gor_prediction ($s{$seq}{name},\
$s{$seq}{seq},\"seqfile\", $lib_name,$gor_seq, $go\
r_obs);\n	}\n\n      if ( !-e $lib_name)\n	{\n	  m\
yexit(flush_error(\"GORIV failed to compute the se\
condary structure of $s{$seq}{name}\"));\n	  myexi\
t ($EXIT_FAILURE);\n	}\n      else\n	{\n	  print s\
tdout \"!\\tProcess: >$s{$seq}{name} _E_ $lib_name\
 \\n\";\n	  print R \">$s{$seq}{name} _E_ $lib_nam\
e\\n\";\n	}\n      unshift (@profiles, $lib_name);\
\n    }\n  close (R);\n  &set_temporary_dir (\"uns\
et\",$mode, $method,\"result.aln\",$outfile, @prof\
iles);\n}\n\nsub seq2tm_template\n  {\n  my ($mode\
,$infile,$arch,$psv,$outfile,$db)=@_;\n  my %s, %h\
;\n  my $result;\n  my (@profiles);\n  &set_tempor\
ary_dir (\"set\",$infile,\"seq.pep\");\n  %s=read_\
fasta_seq (\"seq.pep\");\n\n\n  open (R, \">result\
.aln\");\n\n  #print stdout \"\\n\";\n  foreach $s\
eq (keys(%s))\n    {\n      open (F, \">seqfile\")\
;\n      print (F \">$s{$seq}{name}\\n$s{$seq}{seq\
}\\n\");\n      close (F);\n      $lib_name=\"$s{$\
seq}{name}.tmp\";\n      $lib_name=&clean_file_nam\
e ($lib_name);\n\n      if ($mode eq \"tm_template\
\")\n	{\n	  &safe_system (\"t_coffee -other_pg fas\
ta_seq2hmmtop_fasta.pl -in=seqfile -out=$lib_name \
-arch=$arch -psv=$psv\");\n	}\n      elsif ( $mode\
 eq \"psitm_template\")\n	{\n	  &seq2msa_tm_predic\
tion ($s{$seq}{name},$s{$seq}{seq}, $db, \"seqfile\
\", $lib_name,$arch, $psv);\n	}\n      if ( !-e $l\
ib_name)\n	{\n	  myexit(flush_error(\"hmmtop faile\
d to compute the secondary structure of $s{$seq}{n\
ame}\"));\n	  myexit ($EXIT_FAILURE);\n	}\n      e\
lse\n	{\n	  print stdout \"!\\tProcess: >$s{$seq}{\
name} _T_ $lib_name\\n\";\n	  print R \">$s{$seq}{\
name} _T_ $lib_name\\n\";\n	}\n      unshift (@pro\
files, $lib_name);\n    }\n  close (R);\n  &set_te\
mporary_dir (\"unset\",$mode, $method,\"result.aln\
\",$outfile, @profiles);\n}\n\n\n\nsub seq2RNA_tem\
plate\n  {\n    \n    my ($mode, $infile, $pdbfile\
, $outfile)=@_;\n    my %s, %h ;\n    my $result;\\
n    my (@profiles);\n    my ($seq_mode, $pdb_mode\
, $pwd);\n    \n    #use $seq_mode to estimate the\
 template of sequences WITHOUT a PDB\n    #use $pd\
b_mode to estimate the template of sequences WITH \
   a PDB\n\n    $seq_mode=$ENV{\"SEQ2TEMPLATE4_F_\\
"};\n    $pdb_mode=$ENV{\"PDB2TEMPLATE4_F_\"};\n  \
  \n    if (!$pdb_mode){$pdb_mode=\"find_pair-p\";\
}\n    if (!$seq_mode){$seq_mode=\"RNAplfold\";}\n\
    \n    my $cwd = cwd();\n    &set_temporary_dir\
 (\"set\",$infile,\"seq.pep\");\n    %s=read_fasta\
_seq (\"seq.pep\");\n    %pdb_template_h = &read_t\
emplate_file($pdbfile);\n    my $pdb_chain;\n    \\
n       \n    open (R, \">result.aln\");\n    #pri\
nt stdout \"\\n\";\n    foreach $seq (keys(%s))\n \
     {\n	\n	open (F, \">seqfile\");\n	print (F \">\
$s{$seq}{name}\\n$s{$seq}{seq}\\n\");\n	close (F);\
\n	$pdb_chain = $pdb_template_h{$seq};\n	$lib_name\
=\"$s{$seq}{name}.rfold\";\n	$lib_name=&clean_file\
_name ($lib_name);\n	if ($pdb_template_h{$seq} eq \
\"\")\n	  {\n	    if    ($seq_mode eq \"RNAplfold\\
"){RNAplfold2lib (\"seqfile\", \"$lib_name\");}\n	\
    elsif ($seq_mode eq \"no\"){$lib_name=0;}\n	  \
  else\n	      {\n		myexit(add_error (EXIT_FAILURE\
,$$,$$,getppid(), \"seq2RNA_template failure::meth\
od $seq_mode not available for sequences without P\
DB structures\"));\n	      }\n	  }\n	elsif ($pdb_t\
emplate_h{$seq} ne \"\")\n	  {\n	    my $pdbf;\n	 \
   if    ( -e \"$cwd/$pdb_chain\"   ){$pdbf=\"$cwd\
/$pdb_chain\"; }\n	    elsif ( -e  $pdb_chain     \
    ){$pdbf=\"$pdb_chain\";      }\n	    elsif ( -\
e  \"$CACHE$pdb_chain\" ){$pdbf=\"$CACHE$pdb_chain\
\";}\n	    elsif ( -e  \"$CACHE/$pdb_chain\"){$pdb\
f=\"$CACHE/$pdb_chain\";}\n	    else\n	      {\n		\
myexit(flush_error(\"Could not read $pdb_chain \")\
);\n	      }\n\n	    if($pdb_mode eq \"x3dna-ssr\"\
)\n	      {\n		x3dnassr2lib (\"seqfile\", \"$pdbf\\
", \"$lib_name\");\n	      }\n	    elsif ($pdb_mod\
e eq \"find_pair-p\")\n	      {\n		x3dna_find_pair\
2lib (\"seqfile\", \"$pdbf\", \"$lib_name\", \"fin\
d_pair -p\");\n	      }\n	    elsif ($pdb_mode eq \
\"find_pair\")\n	      {\n		x3dna_find_pair2lib (\\
"seqfile\", \"$pdbf\", \"$lib_name\", \"find_pair\\
");\n	      }\n	    elsif ($pdb_mode eq \"RNAplfol\
d\")\n	      {\n		RNAplfold2lib (\"seqfile\", \"$l\
ib_name\");\n	      }\n	    elsif ($pdb_mode eq \"\
no\"){$lib_name=0;}\n	    else\n	      {\n		myexit\
(add_error (EXIT_FAILURE,$$,$$,getppid(), \"seq2RN\
A_template failure::Could not find method $pdb_mod\
e\"));\n	      }\n	  }\n	if ($lib_name)\n	  {\n	  \
  print stdout \"!\\tProcess: >$s{$seq}{name} _F_ \
$lib_name\\n\";\n	    print R \">$s{$seq}{name} _F\
_ $lib_name\\n\";\n	    unshift (@profiles, $lib_n\
ame);\n	  }\n      }\n    close (R);\n    &set_tem\
porary_dir (\"unset\",$mode, $method,\"result.aln\\
",$outfile, @profiles);\n  }\n\n\n\nsub psiblast2p\
rofile_template_test\n  {\n  my ($mode, $seq,$blas\
t)=@_;\n  my %s, %h, ;\n  my ($result,$psiblast_ou\
tput,$profile_name,@profiles);\n  my $trim=0;\n  m\
y $maxid=100;\n  my $minid=0;\n  my $mincov=0;\n  \
my $maxcov=100;\n\n  %s=read_fasta_seq ($seq);\n  \
open (R, \">result.aln\");\n\n  #print stdout \"\\\
n\";\n  foreach $seq (keys(%s))\n    {\n\n      op\
en (F, \">seqfile\");\n      print (F \">$A\\n$s{$\
seq}{seq}\\n\");\n      close (F);\n      $psiblas\
t_output=$blast;\n      if ( -e $psiblast_output)\\
n	{\n	  %profile=blast_xml2profile($s{$seq}{name},\
 $s{$seq}{seq},$maxid, $minid,$mincov,$psiblast_ou\
tput);\n\n\n\n	  $profile_name=\"$s{$seq}{name}.pr\
f\";\n	  $profile_name=&clean_file_name ($profile_\
name);\n	  unshift (@profiles, $profile_name);\n	 \
 output_profile ($profile_name, \\%profile, $trim)\
;\n	  print stdout \"!\\tProcess: >$s{$seq}{name} \
_R_ $profile_name [$profile{n} Seq.] [$SERVER/blas\
t/$db][$CACHE_STATUS]\\n\";\n	  print R \">$s{$seq\
}{name} _R_ $profile_name\\n\";\n	}\n    }\n  clos\
e (R);\n\n  die;\n}\nsub seq2profile_template\n   \
 {\n      my ($mode, $infile, $db, $method, $outfi\
le)=@_;\n      if    ($method eq \"psiblast\"){ret\
urn psiblast2profile_template ($mode, $infile, $db\
, $method, $outfile);}\n      elsif ($method eq \"\
blastp\")   {return psiblast2profile_template ($mo\
de, $infile, $db, $method, $outfile);}\n      elsi\
f ($method eq \"hh\")      {return hh2profile_temp\
late ($mode, $infile, $db, $method, $outfile);}\n \
   }\n\nsub psiblast2profile_template\n  {\n  my (\
$mode, $infile, $db, $method, $outfile)=@_;\n  my \
%s, %h, ;\n  my ($result,$psiblast_output,$profile\
_name,@profiles);\n  &set_temporary_dir (\"set\",$\
infile,\"seq.pep\");\n  %s=read_fasta_seq (\"seq.p\
ep\");\n  open (R, \">result.aln\");\n\n  #print s\
tdout \"\\n\";\n  foreach $seq (keys(%s))\n    {\n\
      open (F, \">seqfile\");\n      print (F \">$\
A\\n$s{$seq}{seq}\\n\");\n      close (F);\n      \
$psiblast_output=&run_blast ($s{$seq}{name},$metho\
d, $db, \"seqfile\",\"outfile\");\n\n      if ( -e\
 $psiblast_output)\n	{\n	  my %profile=blast_xml2p\
rofile($s{$seq}{name}, $s{$seq}{seq},$maxid, $mini\
d,$mincov,$psiblast_output);\n	  unlink ($psiblast\
_output);\n	  \n	  $profile_name=\"$s{$seq}{name}.\
prf\";\n	  $profile_name=&clean_file_name ($profil\
e_name);\n	  unshift (@profiles, $profile_name);\n\
	  output_profile ($profile_name, \\%profile, $tri\
m);\n	  \n	  print stdout \"!\\tProcess: >$s{$seq}\
{name} _R_ $profile_name [$profile{n} Seq.] [$SERV\
ER/blast/$db][$CACHE_STATUS]\\n\";\n	  print R \">\
$s{$seq}{name} _R_ $profile_name\\n\";\n	  \n	  \n\
	}\n      \n    }\n  close (R);\n  \n  \n\n  &set_\
temporary_dir (\"unset\",$mode, $method,\"result.a\
ln\",$outfile, @profiles);\n}\n\nsub hh2profile_te\
mplate\n  {\n\n  #for each sequence, build a profi\
le, in FASTA, with ungapped querry on top  \n  my \
($mode, $infile, $db, $method, $outfile)=@_;\n  my\
 %s, %h, ;\n  my ($result,$psiblast_output,$profil\
e_name,@profiles);\n  &set_temporary_dir (\"set\",\
$infile,\"seq.pep\");\n  %s=read_fasta_seq (\"seq.\
pep\");\n  open (R, \">result.aln\");\n  \n  my $h\
h=$ENV{\"HHSEARCH_4_TCOFFEE\"};\n  if (!$hh)\n    \
{\n      print \"ERROR: HHSEARCH_4_TCOFFEE is not \
set\\n\";\n      myexit ($EXIT_FAILURE);\n    }\n \
 \n  #print stdout \"\\n\";\n  foreach $seq (keys(\
%s))\n    {\n      my ($profile_name, $nseq);\n   \
   open (F, \">seqfile\");\n      print (F \">$A\\\
n$s{$seq}{seq}\\n\");\n      close (F);\n      \n \
     #This function should input a querry and a da\
tabase and return as output a fasta MSA with quesr\
y on top\n      $profile_name=\"$s{$seq}{name}.prf\
\";\n      $profile_name=&clean_file_name ($profil\
e_name);\n      unshift (@profiles, $profile_name)\
;\n      \n      \n      safe_system  (\"$hh -name\
=$s{$seq}{name} -method=search -db=$db -seq=seqfil\
e -outfile=$profile_name\");\n      if (-e $profil\
e_name){$nseq=fasta2nseq($profile_name);}\n      \\
n      print stdout \"!\\tProcess: >$s{$seq}{name}\
 _R_ $profile_name [$nseq Seq.] [$method/$db][$CAC\
HE_STATUS]\\n\";\n      print R \">$s{$seq}{name} \
_R_ $profile_name\\n\";\n    }\n  close (R);\n  &s\
et_temporary_dir (\"unset\",$mode, $method,\"resul\
t.aln\",$outfile, @profiles);\n}\n\nsub blast2pdb_\
template_test\n    {\n      my ($mode,$infile)=@_;\
\n      my ($maxid,$minid,$mincov);\n      $maxid=\
100;\n      $minid=0;\n      $mincov=0;\n\n      p\
rint \"$infile\\n\";\n\n      %p=blast_xml2profile\
($s{$seq}{name}, $s{$seq}{seq},$maxid, $minid,$min\
cov,$infile);\n      $c=1;\n      print stdout \"!\
\\tProcess: >$s{$seq}{name} [$SERVER/blast/$db][$C\
ACHE_STATUS]\\n\";\n      while (!$found && $c<$p{\
n})\n	{\n	  $pdbid=&id2pdbid($p{$c}{identifyer});\\
n	  if ( length ($pdbid)>5){$pdbid=id2pdbid($p{$c}\
{definition});}\n\n	  if ( length ($pdbid)>5)\n	  \
  {\n	      myexit(add_error (EXIT_FAILURE,$$,$$,g\
etppid(), \"BLAST_FAILURE::Could Not Parse PDBID (\
$p{$c}{identifyer},$p{$c}{definition})\"));\n	    \
}\n\n\n	  if (!&pdb_is_released($pdbid))\n	    {\n\
	      print stdout \"\\t\\t**$pdbid [WARNIG: PDB \
NOT RELEASED or WITHDRAWN]\\n\";\n	      $c++;\n	 \
   }\n	  elsif (!&pdb_has_right_type ($pdbid,$type\
))\n	    {\n	      my $ptype=&pdb2type ($pdbid);\n\
	      my $etype=&type2etype($type);\n\n	      pri\
nt stdout \"\\t\\t**$pdbid [$ptype cannot be used \
(expected: $etype)]\\n\";\n	      $c++;\n	    }\n	\
  else\n	    {\n	      $found=1;\n	    }\n	}\n\n  \
    if ($found)\n	{\n	  print stdout \"\\t\\t >$s{\
$seq}{name} _P_ $pdbid\\n\";\n	}\n      else\n	{\n\
	  print stdout \"\\t\\t >$s{$seq}{name} No Templa\
te Selected\\n\";\n	}\n      die;\n    }\nsub blas\
t2pdb_template\n  {\n  my ($mode, $infile, $db, $m\
ethod, $outfile,$type)=@_;\n  my %s, %h, ;\n  my (\
$result,$blast_output);\n  &set_temporary_dir (\"s\
et\",$infile,\"seq.pep\");\n  %s=read_fasta_seq (\\
"seq.pep\");\n  open (R, \">result.aln\");\n\n\n  \
#print stdout \"\\n\";\n  foreach $seq (keys(%s))\\
n    {\n      my $c;\n      my $found;\n\n      op\
en (F, \">seqfile\");\n      print (F \">$A\\n$s{$\
seq}{seq}\\n\");\n      close (F);\n\n      $blast\
_output=&run_blast ($s{$seq}{name},$method, $db, \\
"seqfile\",\"outfile\");\n\n      %p=blast_xml2pro\
file($s{$seq}{name}, $s{$seq}{seq},$maxid, $minid,\
$mincov,$blast_output);\n      unlink ($blast_outp\
ut);\n\n      $c=1;\n      print stdout \"!\\tProc\
ess: >$s{$seq}{name} [$SERVER/blast/$db][$CACHE_ST\
ATUS]\\n\";\n      while (!$found && $c<$p{n})\n	{\
\n	  $pdbid=&id2pdbid($p{$c}{identifyer});\n	  if \
( length ($pdbid)>5){$pdbid=id2pdbid($p{$c}{defini\
tion});}\n\n	  if ( length ($pdbid)>5)\n	    {\n	 \
     myexit(add_error (EXIT_FAILURE,$$,$$,getppid(\
), \"BLAST_FAILURE::Could Not Parse PDBID ($p{$c}{\
identifyer},$p{$c}{definition})\"));\n	    }\n\n\n\
	  if (!&pdb_is_released($pdbid))\n	    {\n	      \
print stdout \"\\t\\t**$pdbid [PDB NOT RELEASED or\
 WITHDRAWN]\\n\";\n	      $c++;\n	    }\n	  elsif \
(!&pdb_has_right_type ($pdbid,$type))\n	    {\n	  \
    my $ptype=&pdb2type ($pdbid);\n	      my $etyp\
e=&type2etype($type);\n\n	      print stdout \"\\t\
\\t**$pdbid [$ptype cannot be used (expected: $ety\
pe)]\\n\";\n	      $c++;\n	    }\n	  else\n	    {\\
n	      $found=1;\n	    }\n	}\n\n      if ($found)\
\n	{\n	  print R \">$s{$seq}{name} _P_ $pdbid\\n\"\
;\n	  print stdout \"\\t\\t >$s{$seq}{name} _P_ $p\
dbid\\n\";\n	}\n      else\n	{\n	  print R \">$s{$\
seq}{name}\\n\";\n	  print stdout \"\\t\\t >$s{$se\
q}{name} No Template Selected\\n\";\n	}\n    }\n  \
close (R);\n  &set_temporary_dir (\"unset\",$mode,\
 $method,\"result.aln\",$outfile);\n}\nsub type2et\
ype\n  {\n    my $type=shift;\n    my $etype;\n\n \
   if ( $type=~/n/){$etype.=\"NMR \";}\n    if ( $\
type=~/d/){$etype.=\"diffraction \";}\n	if ( $type\
=~/e/){$etype.=\"EM \";}\n    if ( $type=~/m/){$et\
ype.=\"model \";}\n    return $etype;\n  }\nsub pd\
b2type\n  {\n     my $pdb=shift;\n     my $f=vtmpn\
am();\n\n     my $value= &safe_system (\"t_coffee \
-other_pg extract_from_pdb -model_type $pdb > $f\"\
);\n     my $r=&file2string ($f);\n     chomp($r);\
\n     return $r;\n   }\nsub pdb_has_right_type\n \
 {\n    my $pdb=shift;\n    my $type=shift;\n\n   \
 my $f=vtmpnam();\n\n    my $value= &safe_system (\
\"t_coffee -other_pg extract_from_pdb -model_type \
$pdb > $f\");\n    my $r=&file2string ($f);\n    c\
homp($r);\n\n\n    if ( $r eq \"NMR\" && $type=~/n\
/){return 1;}\n    elsif ( $r eq \"diffraction\" &\
& $type=~/d/){return 1;}\n	elsif ( $r eq \"EM\" &&\
 $type=~/e/){return 1;}\n    elsif ( $r eq \"model\
\" && $type=~/m/){return 1;}\n    else {return 0;}\
\n  }\nsub pdb_is_released\n  {\n    my $pdb=shift\
;\n    my $f=vtmpnam();\n\n    $value= &safe_syste\
m (\"t_coffee -other_pg extract_from_pdb -is_relea\
sed_pdb_name $pdb > $f\");\n    my $r=&file2string\
 ($f);\n    chomp($r);\n    return $r;\n  }\nsub b\
last_msa\n  {\n    my ($blast,$infile,$db,$outfile\
)=@_;\n    my ($a, %s1, %s, %qs, %qs1);\n    my $s\
eqfile;\n    my $SEQ=new FileHandle;\n    my $seqf\
ile=\"seqfile\";\n    my @txt;\n\n\n    %s1=&read_\
fasta_seq ($db);\n    %s=&fasta_hash2index_hash(%s\
1);\n    %qs1=&read_fasta_seq ($infile);\n    %qs=\
&fasta_hash2index_hash(%qs1);\n\n\n    #&safe_syst\
em (\"formatdb -i $db\");\n    if ($blast eq \"bla\
stp\"){&safe_system  (\"blastall -i $infile -d $db\
 -m7 -p blastp -o io\");}\n    elsif ($blast eq \"\
blastn\"){&safe_system  (\"blastn -query $infile -\
db $db -outfmt 5 -word_size 4 -out io\");}\n\n    \
&set_blast_type (\"io\");\n\n\n    my %FB=&xml2tag\
_list (\"io\", \"Iteration\");\n    open (F, \">$o\
utfile\");\n    print F \"! TC_LIB_FORMAT_01\\n\";\
\n    print F \"$s{n}\\n\";\n    for ( my $a=0; $a\
<$s{n}; $a++)\n      {\n	print F \"$s{$a}{name} $s\
{$a}{len} $s{$a}{seq}\\n\";\n      }\n\n\n    for \
( my $a=0; $a<$FB{n}; $a++)\n      {\n	my %p=blast\
_xml2profile ($qs{$a}{name}, $qs{$a}{seq},100, 0, \
0, $FB{$a}{body});\n	my $query=$p{0}{name};\n	my $\
i= $s1{$query}{order}+1;\n	for (my $b=1; $b<$p{n};\
 $b++)\n	  {\n	    my $l=length ($p{$b}{Qseq});\n	\
    my $hit=$p{$b}{definition};\n	    my $Qstart=$\
p{$b}{Qstart};\n	    my $Hstart=$p{$b}{Hstart};\n	\
    my $identity=$p{$b}{identity};\n	    my @lrQ=s\
plit (//,$p{$b}{Qseq});\n	    my @lrH=split (//,$p\
{$b}{Hseq});\n\n	    my $j= $s1{$hit}{order}+1;\n	\
    #if ( $j==$i){next;}\n	    printf F \"# %d %d\\
\n\", $i, $j;\n	    #  print  F \"\\n$p{$b}{Qseq} \
($Qstart)\\n$p{$b}{Hseq} ($Hstart)\";\n	    for ($\
c=0; $c<$l; $c++)\n	      {\n		my $rQ=$lrQ[$c];\n	\
	my $rH=$lrH[$c];\n		my $n=0;\n\n		if ($rQ ne \"-\\
"){$n++, $Qstart++;}\n		if ($rH ne \"-\"){$n++; $H\
start++;}\n\n		if ( $n==2)\n		  {\n		    printf F \
\"\\t%d %d %d\\n\", $Qstart-1, $Hstart-1,$identity\
;\n		  }\n	      }\n	  }\n      }\n    print F \"!\
 SEQ_1_TO_N\\n\";\n    close (F);\n    return $out\
put;\n  }\n\nsub blast_msa_old\n  {\n    my ($infi\
le,$outfile)=@_;\n    my ($a, %seq);\n    %s1=&rea\
d_fasta_seq ($infile);\n    foreach $s (keys (%s1)\
)\n      {\n	$i=$s1{$s}{order};\n	$s{$i}{name}=$s;\
\n	$s{$i}{seq}=$s1{$s}{seq};\n	$s{$i}{len}=length(\
 $s{$i}{seq});\n	$s{n}++;\n      }\n    &safe_syst\
em (\"formatdb -i $infile\");\n    &safe_system (\\
"blastall -i $infile -d $infile -m7 -o io\");\n   \
 &set_blast_type (\"io\");\n\n    %FB=&xml2tag_lis\
t (\"io\", \"Iteration\");\n\n    open (F, \">$out\
file\");\n    print F \"! TC_LIB_FORMAT_01\\n\";\n\
    print F \"$s{n}\\n\";\n    for ( $a=0; $a<$s{n\
}; $a++)\n      {\n	print F \"$s{$a}{name} $s{$a}{\
len} $s{$a}{seq}\\n\";\n      }\n    for ( $a=0; $\
a<$FB{n}; $a++)\n      {\n	%p=blast_xml2profile ($\
s{$a}{name}, $s{$a}{seq},100, 0, 0, $FB{$a}{body})\
;\n	for ($b=1; $b<$p{n}; $b++)\n	  {\n	    my $l=l\
ength ($p{$b}{Qseq});\n	    my $hit=$p{$b}{definit\
ion};\n	    my $Qstart=$p{$b}{Qstart};\n	    my $H\
start=$p{$b}{Hstart};\n	    my $identity=$p{$b}{id\
entity};\n	    my @lrQ=split (//,$p{$b}{Qseq});\n	\
    my @lrH=split (//,$p{$b}{Hseq});\n	    my $i= \
$s1{$s{$a}{name}}{order}+1;\n	    my $j= $s1{$hit}\
{order}+1;\n	    #if ( $j==$i){next;}\n	    printf\
 F \"# %d %d\\n\", $i, $j;\n	    #  print  F \"\\n\
$p{$b}{Qseq} ($Qstart)\\n$p{$b}{Hseq} ($Hstart)\";\
\n	    for ($c=0; $c<$l; $c++)\n	      {\n		my $rQ\
=$lrQ[$c];\n		my $rH=$lrH[$c];\n		my $n=0;\n\n		if\
 ($rQ ne \"-\"){$n++, $Qstart++;}\n		if ($rH ne \"\
-\"){$n++; $Hstart++;}\n\n		if ( $n==2)\n		  {\n		\
    printf F \"\\t%d %d %d\\n\", $Qstart-1, $Hstar\
t-1,$identity;\n		  }\n	      }\n	  }\n      }\n  \
  print F \"! SEQ_1_TO_N\\n\";\n    close (F);\n  \
  return $output;\n\n  }\n\nsub seq2msa\n  {\n    \
my ($mode, $infile, $method, $param, $outfile,$dat\
abase)=@_;\n    &set_temporary_dir (\"set\",$infil\
e,\"seq.pep\", $database, \"db.pep\");\n    $param\
.=\" >/dev/null 2>&1 \";\n\n\n    #make sure test.\
pep is in FASTA\n    &safe_system (\"t_coffee -oth\
er_pg seq_reformat -in seq.pep -output fasta_seq >\
 x\");\n    `mv x seq.pep`;\n\n    if ( $method eq\
 \"blastp\")\n      {\n	&blast_msa (\"blastp\",\"s\
eq.pep\",$database,\"result.aln\");\n      }\n    \
elsif ( $method eq \"blastn\")\n      {\n	&blast_m\
sa (\"blastn\",\"seq.pep\",$database,\"result.aln\\
");\n      }\n\n    elsif ( $method eq \"muscle\")\
\n      {\n	`muscle -in seq.pep -out result.aln $p\
aram`;\n      }\n    elsif ( $method eq \"probcons\
\")\n      {\n	`probcons seq.pep >result.aln 2>/de\
v/null`;\n      }\n    elsif ( $method eq \"mafft\\
")\n      {\n	`mafft --quiet --localpair --maxiter\
ate 1000 seq.pep> result.aln  2>/dev/null`\n      \
}\n    elsif ( $method=~/prank/)\n      {\n	`$meth\
od -d=seq.pep -o=result.aln -quiet 2>/dev/null`;\n\
	`mv result.aln.1.fas result.aln`;\n      }\n    e\
lsif ($method eq \"clustalo\")\n      {\n	`clustal\
o -i seq.pep > result.aln`;\n      }\n\n    else\n\
      {\n	`$method -infile=seq.pep -outfile=result\
.aln`;\n      }\n\n    &set_temporary_dir (\"unset\
\",$mode, $method,\"result.aln\",$outfile);\n    m\
yexit ($EXIT_SUCCESS);\n  }\n\nsub seq2thread_pair\
\n  {\n    my ($mode, $infile, $pdbfile1, $method,\
 $param, $outfile)=@_;\n    &set_temporary_dir (\"\
set\",$infile,\"seq.pep\",$pdbfile1,\"struc.pdb\")\
;\n    if ($method eq \"fugueali\")\n      {\n	#En\
v Variable that need to be defined for Fugue\n	if \
(!$ENV{FUGUE_LIB_LIST}){$ENV{FUGUE_LIB_LIST}=\"DUM\
MY\";}\n	if (!$ENV{HOMSTRAD_PATH})  {$ENV{HOMSTRAD\
_PATH}=\"DUMMY\";}\n	if (!$ENV{HOMS_PATH}){$ENV{HO\
MS_PATH}=\"DUMMY\";}\n\n	`joy struc.pdb >x 2>x`;\n\
	&check_file(\"struc.tem\", \"Joy failed [FATAL:$P\
ROGRAM/$method]\");\n	`melody -t struc.tem >x 2>x`\
;\n	&check_file(\"struc.tem\", \"Melody failed [FA\
TAL:$PROGRAM/$method]\");\n	`fugueali -seq seq.pep\
 -prf struc.fug -print > tmp_result.aln`;\n\n	&che\
ck_file(\"tmp_result.aln\", \"Fugue failed [FATAL:\
$PROGRAM/$method]\");\n	&safe_system (\"t_coffee -\
other_pg seq_reformat -in tmp_result.aln -output f\
asta_aln >result.aln\");\n      }\n    elsif ( $me\
thod eq \"t_coffee\")\n      {\n	&safe_system (\"t\
_coffee -in Pstruc.pdb Sseq.pep Mslow_pair -outfil\
e result.aln -quiet\");\n      }\n    else\n      \
{\n	&safe_system (\"$method -infile=seq.pep -pdbfi\
le1=struc.pdb -outfile=result.aln $param>x 2>x\");\
\n      }\n    &set_temporary_dir (\"unset\",$mode\
,$method,\"result.aln\",$outfile);\n    myexit ($E\
XIT_SUCCESS);\n  }\nsub seq2pdbid_pair\n  {\n    m\
y ($mode, $pdbfile1, $pdbfile2, $method, $param, $\
outfile)=@_;\n    my ($name);\n\n\n    &set_tempor\
ary_dir (\"set\");\n    $name=$pdbfile1.\" \".$pdb\
file2;\n\n    if (    &cache_file(\"GET\",\"\",\"$\
name\",\"$method\",\"dali\",$outfile,\"EBI\"))\n  \
    {return $outfile;}\n    else\n      {\n	if ($m\
ethod eq \"daliweb\")\n	  {\n	    $pdbfile1=~/(...\
.)(.)/;\n	    $id1=$1; $c1=$2;\n\n	    $pdbfile2=~\
/(....)(.)/;\n	    $id2=$1; $c2=$2;\n\n	    $comma\
nd=\"t_coffee -other_pg dalilite.pl --pdb1 $id1 --\
chainid1 $c1 --pdb2 $id2 --chainid2 $c2 --email=$E\
MAIL  >dali_stderr 2>dali_stderr\";\n	    $dali=`$\
command`;\n\n	    open (F, \"dali_stderr\");\n	   \
 while (<F>)\n	      {\n		if ( /JobId: dalilite-(\\
\S+)/)\n		{\n		  $jobid=$1;\n		}\n	      }\n	    c\
lose (F);\n	    unlink (\"dali_stderr\");\n\n	    \
$output1=\"dalilite-$jobid.txt\";\n	    if ( -e $o\
utput1)\n	      {\n		unlink ($output1);\n		&url2fi\
le (\"http://www.ebi.ac.uk/Tools/es/cgi-bin/jobres\
ults.cgi/dalilite/dalilite-$jobid/aln.html\", \"ou\
tput2\");\n\n		if ( -e \"output2\")\n		  {\n		    \
my ($seq1, $seq2);\n		    $seq1=$seq2=\"\";\n\n		 \
   open (F, \"output2\");\n		    while (<F>)\n		  \
    {\n			$l=$_;\n			if ( $l=~/Query\\s+(\\S+)/)\n\
			  {\n			    $seq1.=$1;\n			  }\n			elsif ( $l=~\
/Sbjct\\s+(\\S+)/)\n			  {\n			    $seq2.=$1;\n			\
  }\n		      }\n		    close (F);\n		    unlink (\"\
output2\");\n		    if ($seq1 ne \"\" && $seq2 ne \\
"\")\n		      {\n			$output3=\">$A\\n$seq1\\n>$B\\\
n$seq2\\n\";\n			$output3=~s/\\./-/g;\n			open (F,\
 \">result.aln\");\n			print F \"$output3\";\n			c\
lose (F);\n		      }\n		  }\n	      }\n	  }\n     \
 }\n    &cache_file(\"SET\",\"\",\"$name\",\"$meth\
od\",\"dali\",\"result.aln\",\"EBI\");\n    &set_t\
emporary_dir (\"unset\",$mode, $method, \"result.a\
ln\",$outfile);\n    myexit ($EXIT_SUCCESS);\n  }\\
nsub seq2pdb_pair\n  {\n    my ($mode, $pdbfile1, \
$pdbfile2, $method, $param, $outfile)=@_;\n\n    &\
set_temporary_dir (\"set\",$pdbfile1,\"pdb1.pdb\",\
$pdbfile2,\"pdb2.pdb\");\n    if ($method eq \"t_c\
offee\")\n      {\n	&safe_system (\"t_coffee -in P\
pdb1.pdb Ppdb2.pdb -quiet -outfile=result.aln\");\\
n      }\n    elsif ( $method eq \"DaliLite\")\n  \
    {\n	if ( &safe_system (\"DaliLite -pairwise pd\
b1.pdb pdb2.pdb >tmp1\")==$EXIT_SUCCESS)\n	  {\n	 \
    my ($seq1, $seq2);\n	     $seq1=$seq2=\"\";\n\\
n	     open (F, \"tmp1\");\n	     while (<F>)\n	  \
     {\n		 $l=$_;\n		 if ( $l=~/Query\\s+(\\S+)/)\\
n		   {\n		     $seq1.=$1;\n		   }\n		 elsif ( $l=\
~/Sbjct\\s+(\\S+)/)\n		   {\n		     $seq2.=$1;\n		\
   }\n	       }\n	     close (F);\n	     unlink (\\
"tmp1\");\n	     if ($seq1 ne \"\" && $seq2 ne \"\\
")\n	       {\n		 my $output3=\">$A\\n$seq1\\n>$B\\
\n$seq2\\n\";\n		 $output3=~s/\\./-/g;\n		 open (F\
, \">result.aln\");\n		 print F \"$output3\";\n		 \
close (F);\n	       }\n	   }\n	else\n	  {\n	    pr\
int \"ERROR: DalLite failed to align the considere\
d structures[tc_generic_method.pl]\\n\";\n	  }\n  \
    }\n    elsif ( $method eq \"TMalign\")\n      \
{\n	if ( &safe_system (\"TMalign pdb1.pdb pdb2.pdb\
 >tmp1\")==$EXIT_SUCCESS)\n	  {\n	    `tail -4 tmp\
1 > tmp2`;\n\n	    open (F, \"tmp2\");\n	    while\
 (<F>)\n	      {\n		unshift(@l, $_);\n	      }\n	 \
   close (F);\n	    open (F, \">result.aln\");\n	 \
   $l[3]=~s/[^a-zA-Z0-9-]/\\-/g;\n	    $l[1]=~s/[^\
a-zA-Z0-9-]/\\-/g;\n	    print F \">$A\\n$l[3]\\n>\
$B\\n$l[1]\\n\";\n	    close (F);\n	  }\n	else\n	 \
 {\n	    print \"ERROR: TMalign failed to align th\
e considered structures[tc_generic_method.pl]\\n\"\
;\n	    `rm result.aln >/dev/null 2>/dev/null`;\n	\
  }\n      }\n    elsif ( $method eq \"mustang\")\\
n      {\n	if ( &safe_system (\"mustang -i pdb1.pd\
b pdb2.pdb -F fasta >/dev/null 2>/dev/null\")==$EX\
IT_SUCCESS)\n	  {\n	    `mv results.afasta result.\
aln`;\n	  }\n	else\n	  {\n	    print \"ERROR: must\
ang failed to align the considered structures[tc_g\
eneric_method.pl]\\n\";\n	    `rm result.aln >/dev\
/null 2>/dev/null`;\n	  }\n      }\n    else\n    \
  {\n	if ( &safe_system (\"$method -pdbfile1=pdb1.\
pep -pdbfile2=pdb2.pdb -outfile=result.aln $param>\
x 2>x\")==$EXIT_SUCCESS)\n	  {\n	    `mv results.a\
fasta result.aln`;\n	  }\n	else\n	  {\n	    print \
\"ERROR: $method failed to align the considered st\
ructures[tc_generic_method.pl]\\n\";\n	    `rm res\
ult.aln >/dev/null 2>/dev/null`;\n	  }\n      }\n \
   &set_temporary_dir (\"unset\",$mode, $method, \\
"result.aln\",$outfile);\n    myexit ($EXIT_SUCCES\
S);\n  }\n\nsub seq2rnapdb_pair\n  {\n    my ($mod\
e, $pdbfile1, $pdbfile2, $method, $param, $outfile\
)=@_;\n    \n    if ($method eq \"runsara.py\")\n \
     {\n	my $path=$ENV{PATH};\n	\n	if ($ENV{X3DNA_\
4_SARA}){$ENV{PATH}=\"$ENV{X3DNA_4_SARA}:$path\";}\
\n	\n	open(TMP,\"<$pdbfile1\");\n	my $count = 0;\n\
	my $line;\n	while (<TMP>)\n	  {\n	    $line = $_;\
\n	    if ($count ==1)\n	      {\n		last;\n	      \
}\n	    $count += 1;\n	  }\n	\n	\n	$chain1 = subst\
r($line,length($line)-3,1);\n	\n	close TMP;\n	open\
(TMP,\"<$pdbfile2\");\n	my $count = 0;\n	while (<T\
MP>)\n	  {\n	    $line = $_;\n	    if ($count ==1)\
\n	      {\n		last;\n	      }\n	    $count += 1;\n\
	  }\n	$chain2 = substr($line,length($line)-3,1);\\
n	close TMP;\n	\n	$tmp_file=&vtmpnam();\n	\n	safe_\
system(\"runsara.py $pdbfile1 $chain1 $pdbfile2 $c\
hain2 -s -o $tmp_file --limitation 5000 > /dev/nul\
l 2> /dev/null\");\n	if ($ENV{X3DNA_4_SARA}){$ENV{\
PATH}=$path;}\n	\n	open(TMP,\"<$tmp_file\") or die\
 \"cannot open the sara tmp file:$!\\n\";\n	open(O\
UT,\">$outfile\") or die \"cannot open the $outfil\
e file:$!\\n\";\n	\n	my $switch = 0;\n	my $seqNum \
= 0;\n	foreach my $line (<TMP>)\n	  {\n	    next u\
nless ($line=~/SARAALI/);\n	    if ($line=~/>/)\n	\
      {\n		$switch =0;\n		print OUT \">seq$seqNum\\
\n\";\n		$seqNum++;\n	      }\n	    if ($switch < \
2){\n	      $switch++;\n	      next;\n	    }\n	   \
 \n	    if ($line =~/REMARK\\s+SARAALI\\s+([^\\*]+\
)\\*/)\n	      {\n		my $string = $1;\n		print OUT \
\"$string\\n\";\n	      }\n	  }\n	close TMP;\n	clo\
se OUT;\n	unlink($tmp_file);\n      }\n  }\nsub se\
q2profile_pair\n  {\n    my ($mode, $profile1, $pr\
ofile2, $method, $param, $outfile)=@_;\n    \n    \
\n    if ($method eq \"clustalw\")\n      {\n	`clu\
stalw -profile1=$profile1 -profile2=$profile2 -out\
file=$outfile`;\n      }\n    elsif ( $method eq \\
"clustalo\")\n      {\n	\n	`clustalo --p1 $profile\
1 --p2 $profile2 -o $outfile --force`;\n      }\n \
   elsif ( $method eq \"hhalign\")\n      {\n	hhal\
ign ( $profile1,$profile2,$outfile,$param);\n     \
 }\n    else\n      {\n	`$method -profile1=$profil\
e1 -profile2=$profile2 -outfile=$outfile $param> /\
dev/null 2>/dev/null`;\n      }\n    myexit ($EXIT\
_SUCCESS);\n  }\n\nsub pg_is_installed\n  {\n    m\
y @ml=@_;\n    my ($r, $p, $m);\n    my $supported\
=0;\n\n    my $p=shift (@ml);\n    if ($p=~/::/)\n\
      {\n	if (safe_system (\"perl -M$p -e 1\")==$E\
XIT_SUCCESS){return 1;}\n	else {return 0;}\n      \
}\n    else\n      {\n	my $cwhich=vtmpnam();\n	$r=\
`which $p >$cwhich 2>/dev/null`;\n	$r=file2string \
($cwhich);\n	if ($r=~/^\\//){$r=1;}\n	else {$r=0;}\
\n	\n	if ($r==0 && is_blast_package ($p)){return p\
g_is_installed (\"legacy_blast.pl\");}\n	else {ret\
urn $r;}\n      }\n  }\n\nsub is_blast_package\n  \
{\n    my $p=shift;\n    if ( $p=~/blastp/){return\
 1;}\n    elsif ($p=~/blastall/){return 1;}\n    e\
lsif ($p=~/blastn/){return 1;}\n    elsif ($p=~/bl\
astx/){return 1;}\n    elsif ($p=~/formatdb/){retu\
rn 1;}\n    else {return 0;}\n  }\n\nsub check_int\
ernet_connection\n  {\n    my $internet;\n    my $\
tmp;\n    &check_configuration ( \"wget\");\n\n   \
 $tmp=&vtmpnam ();\n\n    if     (&pg_is_installed\
    (\"wget\")){`wget www.google.com -O$tmp >/dev/\
null 2>/dev/null`;}\n    elsif  (&pg_is_installed \
   (\"curl\")){`curl www.google.com -o$tmp >/dev/n\
ull 2>/dev/null`;}\n\n    if ( !-e $tmp || -s $tmp\
 < 10){$internet=0;}\n    else {$internet=1;}\n   \
 if (-e $tmp){unlink $tmp;}\n\n    return $interne\
t;\n  }\nsub check_pg_is_installed\n  {\n    my @m\
l=@_;\n    my $r=&pg_is_installed (@ml);\n    if (\
!$r && $p=~/::/)\n      {\n	print STDERR \"\\nYou \
Must Install the perl package $p on your system.\\\
nRUN:\\n\\tsudo perl -MCPAN -e 'install $pg'\\n\";\
\n      }\n    elsif (!$r)\n      {\n	myexit(flush\
_error(\"\\nProgram $p Supported but Not Installed\
 on your system\"));\n      }\n    else\n      {\n\
	return 1;\n      }\n  }\nsub set_temporary_dir\n \
 {\n    my @list=@_;\n    my $dir_mode, $a, $mode,\
 $method;\n\n    $dir_mode=shift (@list);\n\n\n   \
 if ( $dir_mode eq \"set\")\n      {\n	$initial_di\
r=cwd();\n	if ( !$tmp_dir)\n	  {\n	    $rand=rand \
(100000);\n	    $tmp_dir=\"$TMPDIR/tmp4tcoffee_pro\
file_pair_dir_$$\\_P_$rand\";\n	  }\n	if ( !-d $tm\
p_dir)\n	  {\n	    push (@TMPDIR_LIST, $tmp_dir);\\
n	    `mkdir $tmp_dir`;\n	  }\n\n	for ( $a=0; $a<=\
$#list; $a+=2)\n	      {\n		if (-e $list[$a]){ `cp\
 $list[$a] $tmp_dir/$list[$a+1]`;}\n	      }\n	chd\
ir $tmp_dir;\n      }\n    elsif ( $dir_mode eq \"\
unset\")\n      {\n	$mode=shift (@list);\n	$method\
=shift (@list);\n\n	if (!-e $list[0])\n	  {\n	   m\
yexit(flush_error(\"Program $method failed to prod\
uce $list[1]\" ));\n	    myexit ($EXIT_FAILURE);\n\
	  }\n	else\n	  {\n	    chdir $initial_dir;\n	    \
# `t_coffee -other_pg seq_reformat -in $tmp_dir/$l\
ist[0] -output fasta_aln -out $tmp_dir/result2.aln\
`;\n	    `cp $tmp_dir/$list[0] $tmp_dir/result2.al\
n`;\n	    if ( $list[1] eq \"stdout\")\n	      {\n\
		open (F, \"$tmp_dir/result2.aln\");\n		while (<F\
>){print $_;}close(F);\n	      }\n	    else\n	    \
  {\n		`mv $tmp_dir/result2.aln $list[1]`;\n	     \
 }\n	    shift (@list); shift (@list);\n	    forea\
ch $f (@list)\n	      {\n		if (-e (\"$tmp_dir/$f\"\
)){`mv $tmp_dir/$f .`;}\n	      }\n	  }\n      }\n\
  }\n\n\n\n\nsub my_get_opt\n  {\n    my @list=@_;\
\n    my ($cl, $a, $argv, @argl);\n\n    \n    @ar\
gl=();\n    $cl=shift @list;\n    for ( my $a=0; $\
a<=$#list; $a+=3)\n      {\n	my $option=$list[$a];\
\n	my $optional=$list[$a+1];\n	my $status=$list[$a\
+2];\n	my $argv=\"\";\n	if ($cl=~/$option(\\S+)/){\
$argv=$1;}\n	@argl=(@argl,$argv);\n\n\n	#$optional\
:0=>optional\n	#$optional:1=>must be set\n	#$statu\
s: 0=>no requirement\n	#$status: 1=>must be an exi\
sting file\n	#$status: 2=>must be an installed pac\
kage\n	\n\n	if ($optional==0){;}\n	elsif ( $option\
al==1 && $argv eq \"\")\n	  {\n	    myexit(flush_e\
rror( \"ERROR: Option $option must be set\"));\n	 \
   myexit ($EXIT_FAILURE);\n	  }\n	if ($status==0)\
{;}\n	elsif ($status ==1 && $argv ne \"\" && !-e $\
argv)\n	  {\n	    myexit(flush_error( \"File [$arg\
v] must exist\"));\n	    myexit ($EXIT_FAILURE);\n\
	  }\n	elsif ( $status==2 && $argv ne \"\" && &che\
ck_pg_is_installed ($argv)==0)\n	  {\n	    myexit(\
flush_error( \" $argv is not installed\"));\n	    \
myexit ($EXIT_FAILURE);\n	  }\n      }\n    return\
 @argl;\n    }\n\nsub check_file\n  {\n    my ($fi\
le, $msg)=@_;\n\n    if ( !-e $file)\n      {\n	my\
exit(flush_error(\"$msg\"));\n      }\n    }\nsub \
hhalign\n  {\n    my ($aln1, $aln2, $outfile, $par\
am)=@_;\n    my $hh=$ENV{\"HHALIGN_4_TCOFFEE\"};\n\
    \n    \n    if ($hh)\n      {\n	\n	#external_h\
halign\n	# set via HHALIGN_4_TCOFFEE\n	#<pg> -prof\
ile1 <fasta_prf with seq1 top> -profile2 <fasta pr\
ofile with seq2 top> -outfile < fasta alignmentof \
seq1 and 2 | tc_lib of seq 1 and 2>\n	\n	safe_syst\
em (\"$hh -method=align -profile1=$aln1 -profile2=\
$aln2 -outfile=$outfile\");\n      }\n    else\n  \
    {\n	&local_hhalign ($aln1, $aln2, $outfile, $p\
aram);\n      }\n  }\n\n    \n    \nsub local_hhal\
ign\n  {\n    my ($aln1, $aln2, $outfile, $param)=\
@_;\n    my $h1, $h2;\n\n    $h{0}{index}=0;\n    \
$h{1}{index}=1;\n\n    $h{0}{aln}=$aln1;\n    $h{1\
}{aln}=$aln2;\n\n\n\n    %{$h{0}}=aln2psi_profile \
(%{$h{0}});\n    %{$h{1}}=aln2psi_profile (%{$h{1}\
});\n\n    $param=~s/#S/ /g;\n    $param=~s/#M/\\-\
/g;\n    $param=~s/#E/\\=/g;\n\n\n\n    $command=\\
"hhalign -i $h{0}{a3m} -t $h{1}{a3m} -tc $outfile.\
tmp -rank 1 -mapt 0 $param\";\n    `$command`;\n\n\
  #  `hhalign -i $h{0}{a3m} -t $h{1}{a3m} -tc $out\
file.tmp -rank 1 -mapt 0 -gapf 0.8 -gapg 0.8`;\n\n\
\n    # To run global use the following\n\n    ope\
n (I, \"$outfile.tmp\");\n    open (O, \">$outfile\
\");\n    $h{0}{cons}=s/\\./x/g;\n    $h{1}{cons}=\
s/\\./x/g;\n\n    print O \"! TC_LIB_FORMAT_01\\n2\
\\n$h{0}{name} $h{0}{len} $h{0}{seq}\\n$h{1}{name}\
 $h{1}{len} $h{1}{seq}\\n#1 2\\n\";\n\n    while (\
<I>)\n      {\n	if (/(\\d+)\\s+(\\d+)\\s+(\\d+)/)\\
n	  {\n	    print O \"\\t$h{0}{$1}\\t$h{1}{$2}\\t$\
3\\n\";\n	  }\n      }\n    print O \"! SEQ_1_TO_N\
\\n\";\n\n    close (O);\n    close (I);\n  }\n\ns\
ub aln2psi_profile\n  {\n    my (%h)=@_;\n    my (\
$aln,$i,$hv, $a, @c, $n);\n\n\n    $i=$h{index};\n\
    $aln=$h{aln};\n\n    `cp $aln $$.hhh_aln`;\n  \
  $command=\"t_coffee -other_pg seq_reformat -in $\
aln -output hasch\";\n    $hv=`$command`;chomp ($h\
v);\n\n    $h{a2m}=\"$tmp/$hv.tmp4hhpred.a2m\";\n \
   $h{a3m}=\"$tmp/$hv.tmp4hhpred.a3m\";\n    if ( \
-e $h{a3m}){;}\n    else\n      {\n	$x=`which hhco\
nsensus`;\n	`hhconsensus  -M 50 -i $h{aln} -oa2m $\
h{a2m}`;\n	if (!-e $h{a2m})\n	  {\n	    print STDE\
RR \"Program tc_generic_method.pl FAILED to run:\\\
n\\thhconsensus  -M 50 -i $h{aln} -oa2m $h{a2m}\";\
\n	    myexit ($EXIT_FAILURE);\n	  }\n\n	`hhconsen\
sus  -M 50 -i $h{aln} -oa3m $h{a3m}`;\n	if (!-e $h\
{a3m})\n	  {\n	    print STDERR \"Program tc_gener\
ic_method.pl FAILED to run:\\n\\thhconsensus  -M 5\
0 -i $h{aln} -oa3m $h{a3m}\";\n	    myexit ($EXIT_\
FAILURE);\n	  }\n       `buildali.pl $h{a3m} -n 1`\
;\n      }\n\n\n    $h{a2m_seq}=`head -n 2 $h{a2m}\
 | grep -v \">\"`;chomp ($h{a2m_seq});\n    $h{a3m\
_seq}=`head -n 2 $h{a3m} | grep -v \">\"`;chomp ($\
h{a3m_seq});\n    $h{cons}=$h{a2m_seq};\n    $h{se\
q}=`head -n 2 $h{aln} | grep -v \">\"`;chomp ($h{s\
eq});\n\n\n\n    @c=split (//, $h{cons});\n    $h{\
len}=$#c+1;\n    for ($n=0,$a=0, $b=0; $a<$h{len};\
$a++)\n      {\n	if ( $c[$a]=~/[A-Z]/)\n	  {\n	   \
 $h{++$n}=++$b;\n\n	  }\n	elsif ( $c[$a]=~/[a-z\\.\
]/)\n	  {\n	    ++$b;\n	  }\n      }\n\n    $name=\
`head -n 2 $h{aln} | grep \">\"`;\n    $name=~/\\>\
(\\S+)/;\n    $h{name}=$1;\n\n    `cp $h{a2m} $i.a\
2m`;\n    `cp $h{a3m} $i.a3m`;\n    `cp $h{aln} $i\
.hh_aln`;\n\n    return %h;\n  }\nsub read_fasta_s\
eq_index\n  {\n    my $f=@_[0];\n    my %hseq;\n  \
  my (@seq, @com, @name);\n    my ($a, $s,$nseq);\\
n\n    open (F, $f);\n    while (<F>)\n      {\n	$\
s.=$_;\n      }\n    close (F);\n\n\n    @name=($s\
=~/>(\\S*).*\\n[^>]*/g);\n\n    @seq =($s=~/>.*.*\\
\n([^>]*)/g);\n    @com =($s=~/>\\S*(.*)\\n([^>]*)\
/g);\n\n\n    $nseq=$#name+1;\n\n    for ($a=0; $a\
<$nseq; $a++)\n      {\n	my $s;\n	my $n=$name[$a];\
\n	$hseq{$a}{name}=$n;\n	$seq[$a]=~s/[^A-Za-z]//g;\
\n	$hseq{$a}{order}=$a;\n	$hseq{$a}{seq}=$seq[$a];\
\n	$hseq{$a}{com}=$com[$a];\n\n      }\n    return\
 %hseq;\n  }\nsub read_fasta_seq\n  {\n    my $f=@\
_[0];\n    my %hseq;\n    my (@seq, @com, @name);\\
n    my ($a, $s,$nseq);\n\n    open (F, $f);\n    \
while (<F>)\n      {\n	$s.=$_;\n      }\n    close\
 (F);\n\n\n    @name=($s=~/>(\\S*).*\\n[^>]*/g);\n\
\n    @seq =($s=~/>.*.*\\n([^>]*)/g);\n    @com =(\
$s=~/>\\S*(.*)\\n([^>]*)/g);\n\n\n    $nseq=$#name\
+1;\n\n    for ($a=0; $a<$nseq; $a++)\n      {\n	m\
y $s;\n	my $n=$name[$a];\n	$hseq{$n}{name}=$n;\n	$\
seq[$a]=~s/[^A-Za-z]//g;\n	$hseq{$n}{order}=$a;\n	\
$hseq{$n}{seq}=$seq[$a];\n	$hseq{$n}{com}=$com[$a]\
;\n\n      }\n    return %hseq;\n  }\n\n\nsub read\
_fasta_aln\n  {\n    my $f=@_[0];\n    my %hseq;\n\
    my (@seq, @com, @name);\n    my ($a, $s,$nseq)\
;\n\n    open (F, $f);\n    while (<F>)\n      {\n\
	$s.=$_;\n      }\n    close (F);\n\n\n    @name=(\
$s=~/>(\\S*).*\\n[^>]*/g);\n\n    @seq =($s=~/>.*.\
*\\n([^>]*)/g);\n    @com =($s=~/>\\S*(.*)\\n([^>]\
*)/g);\n\n\n    $nseq=$#name+1;\n\n    for ($a=0; \
$a<$nseq; $a++)\n      {\n	my $s;\n	my $n=$name[$a\
];\n	$hseq{$n}{name}=$n;\n	$seq[$a]=~s/[^A-Za-z-.(\
)[\\]]//g;\n	$hseq{$n}{order}=$a;\n	$hseq{$n}{seq}\
=$seq[$a];\n	$hseq{$n}{com}=$com[$a];\n\n      }\n\
    return %hseq;\n  }\n\nsub recode_name2\n{\n	my\
 ($in)=shift;\n	my $mode=shift;\n\n	my %seq;\n	my \
$new_name;\n\n	if (! -e $in){return;}\n\n	#needed \
by ClustalOmega to avoid very long names\n	open (I\
NFILE, \"+<$in\");\n\n	my $line;\n\n	if ($mode eq \
\"code\")\n	{\n		chomp($line = <INFILE>);\n		my $l\
ine_length = length($line);\n		$new_name=++$RECODE\
_N;\n		$new_name=\">$new_name\";\n		my $new_length\
 = length($new_name);\n		$RECODE {$new_name}=$line\
;\n		for ($count = $new_length; $count < $line_len\
gth; $count++)\n		{\n			$new_name .= \" \";\n		}\n\
		$new_name=\"$new_name\\n\";\n		seek INFILE, 0, 0\
\n			or die \"could not seek: $!\";\n		print INFIL\
E \"$new_name\";\n	}\n	else\n	{\n		my $n_found = 0\
;\n		my $file_pos=0;\n		$file_pos=tell INFILE;\n		\
while (<INFILE>)\n		{\n			$line=$_;\n			$line =~ s\
/\\s*$//;\n\n			$old_name= $RECODE{$line};\n			if \
($old_name ne \"\")\n			{\n				seek INFILE, $file_\
pos, 0\n					or die \"could not seek: $!\";\n				p\
rint INFILE \"$old_name\\n\";\n				$file_pos++;\n	\
			if ($file_pos == 2)\n				{\n					print \"stop\\\
n\";\n					break;\n				}\n			}\n			$file_pos=tell \
INFILE;\n		}\n\n	}\n\n\n	close INFILE;\n}\n\n\nsub\
 recode_name\n{\n	my ($in)=shift;\n	my $mode=shift\
;\n	my $f=new FileHandle;\n	my %seq;\n	my $new_nam\
e;\n\n	if (! -e $in){return;}\n\n	#needed by Clust\
alOmega to avoid very long names\n	%seq=read_fasta\
_aln ($in);\n\n	open ($f, \">$in\");\n	foreach my \
$s (keys(%seq))\n	{\n		if ($mode eq \"code\")\n		{\
\n			$new_name=++$RECODE_N;\n			$RECODE {$new_name\
}=$seq{$s}{name};\n		}\n		else\n		{\n			$new_name=\
$RECODE{$seq{$s}{name}};\n		}\n		print $f \">$new_\
name\\n$seq{$s}{seq}\\n\";\n	}\n	close $f;\n}\n\ns\
ub fasta_hash2index_hash\n  {\n    my %s1=@_;\n   \
 my %s;\n    foreach my $s (keys (%s1))\n      {\n\
	my $i=$s1{$s}{order};\n	$s{$i}{name}=$s;\n	$s{$i}\
{seq}=$s1{$s}{seq};\n	$s{$i}{len}=length( $s{$i}{s\
eq});\n	$s{n}++;\n      }\n    return %s;\n  }\nsu\
b file_contains\n  {\n    my ($file, $tag, $max)=(\
@_);\n    my ($n);\n    $n=0;\n\n    if ( !-e $fil\
e && ($file =~/$tag/)) {return 1;}\n    elsif ( !-\
e $file){return 0;}\n    else\n      {\n	open (FC,\
 \"$file\");\n	while ( <FC>)\n	  {\n	    if ( ($_=\
~/$tag/))\n	      {\n		close (FC);\n		return 1;\n	\
      }\n	    elsif ($max && $n>$max)\n	      {\n	\
	close (FC);\n		return 0;\n	      }\n	    $n++;\n	\
  }\n      }\n    close (FC);\n    return 0;\n  }\\
n\n\nsub file2string\n  {\n    my $f=@_[0];\n    m\
y $string, $l;\n    open (F,\"$f\");\n    while (<\
F>)\n      {\n\n	$l=$_;\n	#chomp ($l);\n	$string.=\
$l;\n      }\n    close (F);\n    $string=~s/\\r\\\
n//g;\n    $string=~s/\\n//g;\n    return $string;\
\n  }\n\n\nsub tag2value\n  {\n\n    my $tag=(@_[0\
]);\n    my $word=(@_[1]);\n    my $return;\n\n   \
 $tag=~/$word=\"([^\"]+)\"/;\n    $return=$1;\n   \
 return $return;\n  }\n\nsub hit_tag2pdbid\n  {\n \
   my $tag=(@_[0]);\n    my $pdbid;\n\n    $tag=~/\
id=\"(\\S+)\"/;\n    $pdbid=$1;\n    $pdbid=~s/_//\
;\n    return $pdbid;\n  }\nsub id2pdbid\n  {\n   \
 my $in=@_[0];\n    my $id;\n\n    $in=~/(\\S+)/;\\
n    $id=$in;\n    $id=~s/PDB/pdb/g;\n\n    if ($i\
d =~/pdb(.*)/){$id=$1;}\n    elsif ( $id=~/(\\S+)\\
\s+mol:protein/){$id=$1;}\n    $id=~s/[:|��_]/\
/g;\n    return $id;\n  }\nsub set_blast_type\n  {\
\n    my $file =@_[0];\n    if (&file_contains ($f\
ile,\"EBIApplicationResult\",100)){$BLAST_TYPE=\"E\
BI\";}\n    elsif (&file_contains ($file,\"NCBI_Bl\
astOutput\",100)) {$BLAST_TYPE=\"NCBI\";}\n    els\
e\n      {\n	$BLAST_TYPE=\"\";\n      }\n    retur\
n $BLAST_TYPE;\n  }\nsub is_valid_blast_xml\n    {\
\n      my $file=shift;\n      my $line;\n\n\n    \
  if ( !-e $file) {return 0;}\n      $line=&file2t\
ail ($file,100);\n\n      if ( $line=~/<\\/EBIAppl\
icationResult/ || $line=~/<\\/NCBI_BlastOutput/ ||\
 $line=~/<\\/BlastOutput/ ){return 1;}\n      retu\
rn 0;\n    }\nsub file2blast_flavor\n      {\n	my \
$file=shift; \n	if (&file_contains ($file,\"EBIApp\
licationResult\",100)){return \"EBI\";}\n	elsif (&\
file_contains ($file,\"NCBI_BlastOutput\",100)){re\
turn \"NCBI\";}\n	else {return \"UNKNOWN\";}\n    \
  }\nsub blast2prf\n	{\n	  my ($blastF, $seqF,$out\
file)=@_;\n	  my (%s, %profile);\n	  my ($result,$\
psiblast_output,$profile_name,@profiles);\n	  %s=r\
ead_fasta_seq_index ($seqF);\n	  my ($z1,$z1m)=unc\
ompress($blastF);\n	  %profile=blast_xml2profile($\
s{0}{name}, $s{0}{seq},$maxid, $minid,$mincov,$bla\
stF);\n	  output_profile ($outfile, \\%profile, $t\
rim);\n	  compress($z1,$z1m);\n	}\nsub blast_xml2p\
rofile\n  {\n    my ($name,$seq,$maxid, $minid, $m\
incov, $file)=(@_);\n    my (%p, $a, $string, $n);\
\n\n\n\n    if ($BLAST_TYPE eq \"EBI\" || &file_co\
ntains ($file,\"EBIApplicationResult\",100)){%p=eb\
i_blast_xml2profile(@_);}\n    elsif ($BLAST_TYPE \
eq \"NCBI\" || &file_contains ($file,\"NCBI_BlastO\
utput\",100)){%p=ncbi_blast_xml2profile(@_);}\n   \
 else\n      {\n	myexit(add_error ( $$,$$,getppid(\
), \"BLAST_FAILURE::unkown XML\",$CL));\n      }\n\
    for ($a=0; $a<$p{n}; $a++)\n      {\n	my $name\
=$p{$a}{name};\n	$p{$name}{seq}=$p{$a}{seq};\n	$p{\
$name}{index}=$a;\n      }\n    return %p;\n  }\ns\
ub ncbi_tblastx_xml2lib_file\n  {\n    my  ($outli\
b,$string)=(@_);\n    my ($L,$l, $a,$b,$c,$d,$i,$n\
hits,@identifyerL);\n    my (%ITERATION);\n\n    o\
pen (F, \">>$outlib\");\n\n    $seq=~s/[^a-zA-Z]//\
g;\n    $L=length ($seq);\n\n    %ITERATION=xml2ta\
g_list ($string, \"Iteration\");\n    for ($i=0; $\
i<$ITERATION{n};$i++)\n      {\n	my ($qindex, $qle\
n, %hit, $string);\n	$string=$ITERATION{$i}{body};\
\n\n	$qindex=xmltag2value($string,\"Iteration_iter\
-num\");\n	$qlen  =xmltag2value($string,\"Iteratio\
n_query-len\");\n	%hit=&xml2tag_list  ($string, \"\
Hit\");\n\n	for ($a=0; $a<$hit{n}; $a++)\n	  {\n	 \
   my ($string);\n	    $string=$hit{$a}{body};\n\n\
	    $hindex=xmltag2value($string,\"Hit_accession\\
")+1;\n	    if ($hindex<=$qindex){next;}\n	    els\
e  {print F  \"# $qindex $hindex\\n\";}\n\n\n	    \
$hlen=xmltag2value  ($string,\"Hit_len\");\n	    %\
HSP=&xml2tag_list  ($string, \"Hsp\");\n\n	    for\
 ($b=0; $b<$HSP{n}; $b++)\n	      {\n		my ($string\
, $qs,$qe,$qf,$hs,$he,$hf,$s, $d, $e);\n		$string=\
$HSP{$b}{body};\n\n		$qs=xmltag2value  ($string,\"\
Hsp_query-from\");\n		$qe=xmltag2value  ($string,\\
"Hsp_query-to\");\n		$qf=xmltag2value  ($string,\"\
Hsp_query-frame\");\n\n		$hs=xmltag2value  ($strin\
g,\"Hsp_hit-from\");\n		$he=xmltag2value  ($string\
,\"Hsp_hit-to\");\n		$hf=xmltag2value  ($string,\"\
Hsp_hit-frame\");\n\n		$s=xmltag2value  ($string,\\
"Hsp_identity\");\n		$l=xmltag2value  ($string,\"H\
sp_align-len\");\n		$s=int(($s*100)/$l);\n\n		if (\
$qf>0)\n		  {$rqs=$qs; $rqe=$qe;}\n		else\n		  {\n\
		    $rqe=($qlen-$qs)+1;\n		    $rqs=($qlen-$qe)+\
1;\n		  }\n\n		if ($hf>0)\n		  {$rhs=$hs; $rhe=$he\
;}\n		else\n		  {\n		    $rhe=($hlen-$hs)+1;\n		  \
  $rhs=($hlen-$he)+1;\n		  }\n		for ($d=0,$e=$rqs;\
 $e<$rqe; $e++,$d++)\n		  {\n		    my ($r1,$r2);\n\
		    $r1=$e;\n		    $r2=$rhs+$d;\n		    print F \\
" $r1 $r2 $s 0\\n\";\n		  }\n	      }\n	  }\n     \
 }\n    print F \"! SEQ_1_TO_N\\n\";\n\n    close \
(F);\n    return %lib;\n  }\n\nsub ncbi_tblastpx_x\
ml2lib_file\n  {\n    my  ($outlib,$string,%s)=(@_\
);\n    my ($L,$l, $a,$b,$c,$d,$i,$nhits,@identify\
erL);\n    my (%ITERATION,%hdes, %qdes);\n\n    op\
en (F, \">>$outlib\");\n\n    $seq=~s/[^a-zA-Z]//g\
;\n    $L=length ($seq);\n\n    %ITERATION=xml2tag\
_list ($string, \"Iteration\");\n    for ($i=0; $i\
<$ITERATION{n};$i++)\n      {\n	my ($qindex, $qlen\
, %hit, $string);\n	$string=$ITERATION{$i}{body};\\
n\n	$qdef=xmltag2value($string,\"Iteration_query-d\
ef\");\n	%qdes=&tblastpx_name2description($qdef,%s\
);\n	$qlen  =xmltag2value($string,\"Iteration_quer\
y-len\");\n	%hit=&xml2tag_list  ($string, \"Hit\")\
;\n\n	for ($a=0; $a<$hit{n}; $a++)\n	  {\n	    my \
($string);\n	    $string=$hit{$a}{body};\n	    $hd\
ef=xmltag2value($string,\"Hit_def\");\n	    %hdes=\
&tblastpx_name2description($hdef,%s);\n	    if ($h\
des{index}<=$qdes{index}){next;}\n	    else  {prin\
t F  \"# $qdes{index} $hdes{index}\\n\";}\n\n\n	  \
  $hlen=xmltag2value  ($string,\"Hit_len\");\n	   \
 %HSP=&xml2tag_list  ($string, \"Hsp\");\n\n	    f\
or ($b=0; $b<$HSP{n}; $b++)\n	      {\n		my ($stri\
ng, $l,$qs,$qe,$qf,$hs,$he,$hf,$s, $d, $e, @s1, @s\
2);\n		$string=$HSP{$b}{body};\n\n		$qs=xmltag2val\
ue  ($string,\"Hsp_query-from\");\n		$qe=xmltag2va\
lue  ($string,\"Hsp_query-to\");\n		$qf=$qdes{fram\
e};\n		$qseq=xmltag2value  ($string,\"Hsp_qseq\");\
\n\n		$hs=xmltag2value  ($string,\"Hsp_hit-from\")\
;\n		$he=xmltag2value  ($string,\"Hsp_hit-to\");\n\
		$hf=$hdes{frame};\n		$hseq=xmltag2value  ($strin\
g,\"Hsp_hseq\");\n\n		$s=xmltag2value  ($string,\"\
Hsp_identity\");\n		$l=xmltag2value  ($string,\"Hs\
p_align-len\");\n		$s=int(($s*100)/$l);\n		@s1=tbl\
astpx_hsp2coordinates($qseq,$qs,$qe,%qdes);\n		@s2\
=tblastpx_hsp2coordinates($hseq,$hs,$he,%hdes);\n\\
n\n		for ($f=0; $f<=$#s1; $f++)\n		  {\n		    if (\
$s1[$f]==-1 || $s2[$f]==-1){next;}\n		    else\n		\
      {\n			print F \" $s1[$f] $s2[$f] $s 0\\n\";\\
n		      }\n		  }\n	      }\n	  }\n      }\n    pr\
int F \"! SEQ_1_TO_N\\n\";\n\n    close (F);\n    \
return %lib;\n  }\nsub tblastpx_hsp2coordinates\n \
 {\n    my ($seq, $s, $e, %des)=@_;\n    my @list;\
\n    my @sa;\n    my @gap=(-1,-1,-1);\n\n    $s=$\
des{start}+3*($s-1);\n\n    if ($des{strand} eq \"\
d\"){;}\n    else {$s=($des{length}-$s)+1;}\n\n   \
 foreach $c (split (//,$seq))\n      {\n	if ( $c e\
q '-'){push (@list,@gap);}\n	elsif ($des{strand} e\
q \"d\")\n	  {\n	    push(@list,$s++,$s++,$s++);\n\
	  }\n	else\n	  {\n	    push(@list, $s--,$s--,$s--\
);\n	  }\n      }\n    return @list;\n  }\n\nsub t\
blastpx_name2description\n  {\n    my ($name, %s)=\
@_;\n    my @at=split(\"__\", $name);\n    my %des\
;\n\n    $des{name}=$at[0];\n    $des{strand}=$at[\
1];\n\n    $des{start}=$at[2];\n    $des{end}=$at[\
3];\n    $des{length}=$at[4];\n    $des{index}=$s{\
$at[0]}{order}+1;\n    return %des;\n  }\nsub ncbi\
_blast_xml2profile\n  {\n    my ($name,$seq,$maxid\
, $minid, $mincov, $string)=(@_);\n    my ($L,$l, \
$a,$b,$c,$d,$nhits,@identifyerL);\n\n    $seq=~s/[\
^a-zA-Z]//g;\n    $L=length ($seq);\n    \n    #Th\
is is causing the NCBI parser to fail when Iterati\
on_query-def is missing\n    #%query=&xml2tag_list\
 ($string, \"Iteration_query-def\");\n    #$name=$\
query{0}{body};\n\n    %hit=&xml2tag_list ($string\
, \"Hit\");\n\n    \n    for ($nhits=0,$a=0; $a<$h\
it{n}; $a++)\n      {\n	my ($ldb,$id, $identity, $\
expectation, $start, $end, $coverage, $r);\n	my (%\
ID,%DE,%HSP);\n\n	$ldb=\"\";\n\n	%ID=&xml2tag_list\
 ($hit{$a}{body}, \"Hit_id\");\n	$identifyer=$ID{0\
}{body};\n\n	%DE=&xml2tag_list ($hit{$a}{body}, \"\
Hit_def\");\n	$definition=$DE{0}{body};\n\n	%HSP=&\
xml2tag_list ($hit{$a}{body}, \"Hsp\");\n	for ($b=\
0; $b<$HSP{n}; $b++)\n	  {\n	    my (%START,%END,%\
E,%I,%Q,%M);\n\n\n	    %START=&xml2tag_list ($HSP{\
$b}{body}, \"Hsp_query-from\");\n	    %HSTART=&xml\
2tag_list ($HSP{$b}{body}, \"Hsp_hit-from\");\n\n	\
    %LEN=  &xml2tag_list ($HSP{$b}{body}, \"Hsp_al\
ign-len\");\n	    %END=  &xml2tag_list ($HSP{$b}{b\
ody}, \"Hsp_query-to\");\n	    %HEND=  &xml2tag_li\
st ($HSP{$b}{body}, \"Hsp_hit-to\");\n	    %E=&xml\
2tag_list     ($HSP{$b}{body}, \"Hsp_evalue\");\n	\
    %I=&xml2tag_list     ($HSP{$b}{body}, \"Hsp_id\
entity\");\n	    %Q=&xml2tag_list     ($HSP{$b}{bo\
dy}, \"Hsp_qseq\");\n	    %M=&xml2tag_list     ($H\
SP{$b}{body}, \"Hsp_hseq\");\n\n	    for ($e=0; $e\
<$Q{n}; $e++)\n\n	      {\n		$qs=$Q{$e}{body};\n		\
$ms=$M{$e}{body};\n\n		$expectation=$E{$e}{body};\\
n		$identity=($LEN{$e}{body}==0)?0:$I{$e}{body}/$L\
EN{$e}{body}*100;\n		$start=$START{$e}{body};\n		$\
end=$END{$e}{body};\n		$Hstart=$HSTART{$e}{body};\\
n		$Hend=$HEND{$e}{body};\n\n		$coverage=($L)?(($e\
nd-$start)*100)/$L:0;\n		if ($identity>$maxid || $\
identity<$minid || $coverage<$mincov)\n		  {\n		  \
  next;\n		  }\n		@lr1=(split (//,$qs));\n		@lr2=(\
split (//,$ms));\n		$l=$#lr1+1;\n		for ($c=0;$c<$L\
;$c++){$p[$nhits][$c]=\"-\";}\n		for ($d=0,$c=0; $\
c<$l; $c++)\n		  {\n		    $r=$lr1[$c];\n		    if (\
 $r=~/[A-Za-z]/)\n		      {\n\n			$p[$nhits][$d + \
$start-1]=$lr2[$c];\n			$d++;\n		      }\n		  }\n	\
	$Qseq[$nhits]=$qs;\n		$Hseq[$nhits]=$ms;\n		$Qsta\
rtL[$nhits]=$start;\n		$HstartL[$nhits]=$Hstart;\n\
		$identityL[$nhits]=$identity;\n		$endL[$nhits]=$\
end;\n		$definitionL[$nhits]=$definition;\n		$iden\
tifyerL[$nhits]=$identifyer;\n		$comment[$nhits]=\\
"$ldb|$identifyer [Eval=$expectation][id=$identity\
%][start=$Hstart end=$Hend]\";\n		$nhits++;\n	    \
  }\n	  }\n      }\n\n\n    $profile{n}=0;\n    $p\
rofile{$profile{n}}{name}=$name;\n    $profile{$pr\
ofile{n}}{seq}=$seq;\n    $profile {n}++;\n\n    f\
or ($a=0; $a<$nhits; $a++)\n      {\n	$n=$a+1;\n\n\
	$profile{$n}{name}=\"$name\\_$a\";\n	$profile{$n}\
{seq}=\"\";\n	$profile{$n}{Qseq}=$Qseq[$a];\n	$pro\
file{$n}{Hseq}=$Hseq[$a];\n	$profile{$n}{Qstart}=$\
QstartL[$a];\n	$profile{$n}{Hstart}=$HstartL[$a];\\
n	$profile{$n}{identity}=$identityL[$a];\n	$profil\
e{$n}{definition}=$definitionL[$a];\n	$profile{$n}\
{identifyer}=$identifyerL[$a];\n	$profile{$n}{comm\
ent}=$comment[$a];\n\n	for ($b=0; $b<$L; $b++)\n	 \
 {\n	    if ($p[$a][$b])\n	      {\n		$profile{$n}\
{seq}.=$p[$a][$b];\n	      }\n	    else\n	      {\\
n		$profile{$n}{seq}.=\"-\";\n	      }\n	  }\n    \
  }\n\n    $profile{n}=$nhits+1;\n    return %prof\
ile;\n  }\nsub ebi_blast_xml2profile\n  {\n    my \
($name,$seq,$maxid, $minid, $mincov, $string)=(@_)\
;\n    my ($L,$l, $a,$b,$c,$d,$nhits,@identifyerL,\
$identifyer);\n\n\n\n    $seq=~s/[^a-zA-Z]//g;\n  \
  $L=length ($seq);\n    %hit=&xml2tag_list ($stri\
ng, \"hit\");\n\n    for ($nhits=0,$a=0; $a<$hit{n\
}; $a++)\n      {\n	my ($ldb,$id, $identity, $expe\
ctation, $start, $end, $coverage, $r);\n	my (%Q,%M\
,%E,%I);\n\n	$ldb=&tag2value ($hit{$a}{open}, \"da\
tabase\");\n	$identifyer=&tag2value ($hit{$a}{open\
}, \"id\");\n\n	$description=&tag2value ($hit{$a}{\
open}, \"description\");\n\n	%Q=&xml2tag_list ($hi\
t{$a}{body}, \"querySeq\");\n	%M=&xml2tag_list ($h\
it{$a}{body}, \"matchSeq\");\n	%E=&xml2tag_list ($\
hit{$a}{body}, \"expectation\");\n	%I=&xml2tag_lis\
t ($hit{$a}{body}, \"identity\");\n\n\n	for ($b=0;\
 $b<$Q{n}; $b++)\n	  {\n\n	    $qs=$Q{$b}{body};\n\
	    $ms=$M{$b}{body};\n\n	    $expectation=$E{$b}\
{body};\n	    $identity=$I{$b}{body};\n\n\n	    $s\
tart=&tag2value ($Q{$b}{open}, \"start\");\n	    $\
end=&tag2value ($Q{$b}{open}, \"end\");\n	    $sta\
rtM=&tag2value ($M{$b}{open}, \"start\");\n	    $e\
ndM=&tag2value ($M{$b}{open}, \"end\");\n	    $cov\
erage=(($end-$start)*100)/$L;\n\n	   # print \"$id\
: ID: $identity COV: $coverage [$start $end]\\n\";\
\n\n	    if ($identity>$maxid || $identity<$minid \
|| $coverage<$mincov){next;}\n	    # print \"KEEP\\
\n\";\n\n\n	    @lr1=(split (//,$qs));\n	    @lr2=\
(split (//,$ms));\n	    $l=$#lr1+1;\n	    for ($c=\
0;$c<$L;$c++){$p[$nhits][$c]=\"-\";}\n	    for ($d\
=0,$c=0; $c<$l; $c++)\n	      {\n		$r=$lr1[$c];\n	\
	if ( $r=~/[A-Za-z]/)\n		  {\n\n		    $p[$nhits][$\
d + $start-1]=$lr2[$c];\n		    $d++;\n		  }\n	    \
  }\n\n	    $Qseq[$nhits]=$qs;\n	    $Hseq[$nhits]\
=$ms;\n	    $QstartL[$nhits]=$start;\n	    $Hstart\
L[$nhits]=$Hstart;\n	    $identityL[$nhits]=$ident\
ity;\n	    $endL[$nhits]=$end;\n	    $definitionL[\
$nhits]=$definition;\n	    $identifyerL[$nhits]=$i\
dentifyer;\n	    $comment[$nhits]=\"$ldb|$identify\
er [Eval=$expectation][id=$identity%][start=$start\
M end=$endM]\";\n	    $nhits++;\n	  }\n      }\n\n\
    $profile{n}=0;\n    $profile{$profile{n}}{name\
}=$name;\n    $profile{$profile{n}}{seq}=$seq;\n  \
  $profile {n}++;\n\n    for ($a=0; $a<$nhits; $a+\
+)\n      {\n	$n=$a+1;\n	$profile{$n}{name}=\"$nam\
e\\_$a\";\n	$profile{$n}{seq}=\"\";\n	$profile{$n}\
{Qseq}=$Qseq[$a];\n	$profile{$n}{Hseq}=$Hseq[$a];\\
n	$profile{$n}{Qstart}=$QstartL[$a];\n	$profile{$n\
}{Hstart}=$HstartL[$a];\n	$profile{$n}{identity}=$\
identityL[$a];\n	$profile{$n}{definition}=$definit\
ionL[$a];\n	$profile{$n}{identifyer}=$identifyerL[\
$a];\n	$profile{$n}{comment}=$comment[$a];\n\n	for\
 ($b=0; $b<$L; $b++)\n	  {\n	    if ($p[$a][$b])\n\
	      {\n		$profile{$n}{seq}.=$p[$a][$b];\n	     \
 }\n	    else\n	      {\n		$profile{$n}{seq}.=\"-\\
";\n	      }\n	  }\n      }\n    $profile{n}=$nhit\
s+1;\n\n    return %profile;\n  }\nsub output_prof\
ile\n  {\n    my ($outfile,$profileR, $trim)=(@_);\
\n    my ($a);\n    my %profile=%$profileR;\n    m\
y $P= new FileHandle;\n    my $tmp=vtmpnam();\n\n \
   open ($P, \">$tmp\");\n    for ($a=0; $a<$profi\
le{n}; $a++)\n      {\n	print $P \">$profile{$a}{n\
ame} $profile{$a}{comment}\\n$profile{$a}{seq}\\n\\
";\n      }\n    close ($P);\n\n    if ( $trim)\n \
     {\n	if ($ENV{psitrim_mode_4_TCOFFEE} eq \"tri\
m\")# old trimming\n	  {\n	    if ($trim>0)\n	    \
  {\n		&safe_system (\"t_coffee -other_pg seq_refo\
rmat -in $tmp -action +trim _aln_n$trim\\_K1 -outp\
ut fasta_aln -out $outfile\");\n	      }\n	    els\
e\n	      {\n		&safe_system (\"t_coffee -other_pg \
seq_reformat -in $tmp -action +trim _aln_%%$trim\\\
_K1 -output fasta_aln -out $outfile\");\n	      }\\
n	  }\n	else # newtrimming\n	  {\n	    my $tm;\n	 \
   if ($ENV{psitrim_tree_4_TCOFFEE}){$tm=\"-treemo\
de=\".$ENV{psitrim_tree_4_TCOFFEE};}\n	    else {$\
tm=\"-treemode=codnd\";}\n	    if ($trim>0)\n	    \
  {\n		&safe_system (\"t_coffee -other_pg seq_refo\
rmat -in $tmp $tm -keep 1 -action +regtrim $trim -\
output fasta_aln -out $outfile\");\n	      }\n	   \
 else\n	      {\n		&safe_system (\"t_coffee -other\
_pg seq_reformat -in $tmp $tm -keep 1 -action +reg\
trim $trim\\% -output fasta_aln -out $outfile\");\\
n	      }\n	   \n	  }\n	\n      }\n    else\n     \
 {\n	&safe_system (\"mv $tmp $outfile\");\n      }\
\n    return;\n  }\nsub blast_xml2hit_list\n  {\n \
   my $string=(@_[0]);\n    return &xml2tag_list (\
$string, \"hit\");\n  }\nsub xmltag2value\n  {\n  \
  my ($string_in, $tag)=@_;\n    my %TAG;\n    %TA\
G=xml2tag_list ($string_in, $tag);\n    return $TA\
G{0}{body};\n  }\n\nsub xml2tag_list\n  {\n    my \
($string_in,$tag)=@_;\n    my $tag_in, $tag_out;\n\
    my %tag;\n\n    if (-e $string_in)\n      {\n	\
$string=&file2string ($string_in);\n      }\n    e\
lse\n      {\n	$string=$string_in;\n      }\n    $\
tag_in1=\"<$tag \";\n    $tag_in2=\"<$tag>\";\n   \
 $tag_out=\"/$tag>\";\n    $string=~s/>/>##1/g;\n \
   $string=~s/</##2</g;\n    $string=~s/##1/<#/g;\\
n    $string=~s/##2/#>/g;\n    @l=($string=~/(\\<[\
^>]+\\>)/g);\n    $tag{n}=0;\n    $in=0;$n=-1;\n\n\
\n\n    foreach $t (@l)\n      {\n\n	$t=~s/<#//;\n\
	$t=~s/#>//;\n\n	if ( $t=~/$tag_in1/ || $t=~/$tag_\
in2/)\n	  {\n\n	    $in=1;\n	    $tag{$tag{n}}{ope\
n}=$t;\n	    $n++;\n\n	  }\n	elsif ($t=~/$tag_out/\
)\n	  {\n\n\n	    $tag{$tag{n}}{close}=$t;\n	    $\
tag{n}++;\n	    $in=0;\n	  }\n	elsif ($in)\n	  {\n\
\n	    $tag{$tag{n}}{body}.=$t;\n	  }\n      }\n\n\
    return %tag;\n  }\n\n\nsub seq2gor_prediction\\
n  {\n    my ($name, $seq,$infile, $outfile, $gor_\
seq, $gor_obs)=(@_);\n    my ($l);\n\n    `gorIV -\
prd $infile -seq $gor_seq -obs $gor_obs > gor_tmp`\
;\n    open (GR, \">$outfile\");\n    open (OG, \"\
gor_tmp\");\n\n    while (<OG>)\n      {\n\n	$l=$_\
;\n	if ($l=~/\\>/){print GR \"$l\";}\n	elsif ( $l=\
~/Predicted Sec. Struct./)\n	  {\n	    $l=~s/Predi\
cted Sec. Struct\\.//;\n	    print GR \"$l\";\n	  \
}\n      }\n    close (GR);\n    close (OG);\n    \
return;\n  }\nsub seq2msa_tm_prediction\n  {\n    \
my ($name, $seq, $db, $infile, $outfile, $arch, $p\
sv)=(@_);\n    my (%p,%gseq,%R, $blast_output, %s,\
 $l);\n    my $R2=new FileHandle;\n    my $method=\
\"psitm\";\n    my $SERVER=\"EBI\";\n\n    $blast_\
output=&run_blast ($name,\"blastp\", $db, $infile,\
 \"outfile\");\n\n    if (&cache_file(\"GET\",$inf\
ile,$name,$method,$db,$outfile,$SERVER))\n      {\\
n	print \"\\tPSITM: USE Cache\\n\";\n	return $outf\
ile;\n      }\n    else\n      {\n	$CACHE_STATUS=\\
"COMPUTE CACHE\";\n	%p=blast_xml2profile($name,$se\
q,$maxid, $minid,$mincov,$blast_output);\n\n\n	ope\
n (F, \">tm_input\");\n	for (my $a=0; $a<$p{n}; $a\
++)\n	  {\n	    my $s;\n\n	    $s=$p{$a}{seq};\n	 \
   $s=uc($s);\n	    print F \">$p{$a}{name}\\n$s\\\
n\";\n	    #print stdout \">$p{$a}{name}\\n$s\\n\"\
;\n	  }\n	close (F);\n	print \"\\tPSITM: kept  $p{\
n} Homologues for Sequence $p{0}{name}\\n\";\n	&sa\
fe_system (\"t_coffee -other_pg fasta_seq2hmmtop_f\
asta.pl -in=tm_input -out=$outfile -output=cons -c\
ov=70 -trim=95 -arch=$arch -psv=$psv\");\n	unlink \
(\"tm_input\");\n	&cache_file(\"SET\",$infile,$nam\
e,$method,$db,$outfile,$SERVER);\n	return;\n      \
}\n  }\n\n\nsub seq2msa_gor_prediction\n  {\n    m\
y ($name, $seq,$infile, $outfile, $gor_seq, $gor_o\
bs)=(@_);\n    my (%p,%gseq,%R, $blast_output, %s,\
 $l);\n    my $R2=new FileHandle;\n    my $db=\"un\
iprot\";\n    my $method=\"psigor\";\n    my $SERV\
ER=\"EBI\";\n\n    $blast_output=&run_blast ($name\
,\"blastp\", \"uniprot\", $infile, \"outfile\");\n\
\n    if (&cache_file(\"GET\",$infile,$name,$metho\
d,$db,$outfile,$SERVER, $psiJ))\n      {\n	print \\
"\\tPSIGOR: USE Cache\\n\";\n	return $outfile;\n  \
    }\n    else\n      {\n	$CACHE_STATUS=\"COMPUTE\
 CACHE\";\n	%p=blast_xml2profile($name,$seq,$maxid\
, $minid,$mincov,$blast_output);\n\n\n	open (F, \"\
>gor_input\");\n	for (my $a=0; $a<$p{n}; $a++)\n	 \
 {\n	    my $s;\n\n	    $s=$p{$a}{seq};\n	    $s=u\
c($s);\n	    print F \">$p{$a}{name}\\n$s\\n\";\n	\
    #print stdout \">$p{$a}{name}\\n$s\\n\";\n	  }\
\n	close (F);\n	print \"\\tGORTM: kept  $p{n} Homo\
logues for Sequence $p{0}{name}\\n\";\n	&safe_syst\
em (\"t_coffee -other_pg fasta_seq2hmmtop_fasta.pl\
 -in=gor_input -out=$outfile -output=cons -cov=70 \
-trim=95 -gor_seq=$gor_seq -gor_obs=$gor_obs -mode\
=gor\");\n	unlink (\"tm_input\");\n	&cache_file(\"\
SET\",$infile,$name,$method,$db,$outfile,$SERVER);\
\n	return;\n      }\n  }\n\n\n\nsub run_blast\n  {\
\n    my ($name, $method, $db, $infile, $outfile, \
$run)=(@_);\n    if (!$run){$run=1;}\n    my $erro\
r_log=vtmpnam();\n    my $cl_db;\n    my $psiJ=($E\
NV{psiJ_4_TCOFFEE})?$ENV{psiJ_4_TCOFFEE}:1;\n    \\
n    my $psiJFlag=\"-j$psiJ\";\n   \n    if (&cach\
e_file(\"GET\",$infile,$name,$method,$db,$outfile,\
$SERVER, $psiJ) && is_valid_blast_xml ($outfile))\\
n      {return $outfile;}\n    else\n      {\n	$CA\
CHE_STATUS=\"COMPUTE CACHE\";\n	if ( $SERVER eq \"\
EBI_SOAP\")\n	  {\n	    &check_configuration (\"EM\
AIL\",\"SOAP::Light\",\"INTERNET\");\n\n	    $cl_m\
ethod=$method;\n	    if ($cl_method =~/wu/)\n	    \
  {\n		if ( $method eq \"psiblast\" || $psiJ>1){my\
exit(add_error (EXIT_FAILURE,$$,$$,getppid(), \"BL\
AST_FAILURE::$SERVER does not Support psiblast mod\
e ($psiJFlag)\",$CL));}\n		$cl_method=~s/wu//;\n		\
if ( $cl_method eq \"psiblast\" || $psiJ>1)\n		  {\
\n		    add_warning($$,$$,\"PSI BLAST cannot be us\
ed with the wuBLAST Client. Use server=EBI Or serv\
er=LOCAL. blastp will be used instead\");\n		    $\
cl_method=\"blastp\";\n		  }\n\n		$command=\"t_cof\
fee -other_pg wublast.pl --email $EMAIL $infile -D\
 $db -p $cl_method --outfile $outfile -o xml>/dev/\
null 2>$error_log\";\n		&safe_system ( $command);\\
n		if (-e \"$outfile.xml\") {`mv $outfile.xml $out\
file`;}\n	      }\n	    else\n	      {\n		if ($cl_\
method eq \"psiblast\"){$cl_method =\"blastp $psiJ\
Flag\";}\n\n		$command=\"t_coffee -other_pg blastp\
gp.pl --email $EMAIL $infile -d $db --outfile $out\
file -p $cl_method --mode PSI-Blast>/dev/null 2>$e\
rror_log\";\n		&safe_system ( $command);\n\n		if (\
-e \"$outfile.xml\") {`mv $outfile.xml $outfile`;}\
\n	      }\n	  }\n	elsif ($SERVER eq \"EBI_REST\" \
|| $SERVER eq \"EBI\")\n	  {\n	    $cl_method=$met\
hod;\n	    &check_configuration(\"EMAIL\",\"XML::S\
imple\", \"INTERNET\");\n	    if ($db eq \"uniprot\
\"){$db1=\"uniprotkb\";}\n	    else {$db1=$db;}\n\\
n	    \n	    if ($cl_method =~/wu/)\n	      {\n		$\
cl_method=~s/wu//;\n\n		\n		if ( $cl_method eq \"p\
siblast\"){$cl_method=\"blastp\";}\n\n		$command=\\
"t_coffee -other_pg wublast_lwp.pl --email $EMAIL \
-D $db1 -p $cl_method --outfile $outfile --align 5\
 --stype protein $infile>/dev/null 2>error_log\";\\
n	      }\n	    else\n	      {\n		#if ( $cl_method\
 =~/psiblast/){$cl_method =\"blastp $psiJFlag\";}\\
n		if ( $cl_method =~/psiblast/){$cl_method =\"bla\
stp\";}\n		$command=\"t_coffee -other_pg ncbiblast\
_lwp.pl --email $EMAIL --database $db1 --program $\
cl_method --outfile $outfile --alignments 5 --styp\
e protein $infile>/dev/null 2>$error_log\";\n		#DE\
BUG\n		#$command=\"t_coffee -other_pg ncbiblast_lw\
p.pl --email $EMAIL -D $db1 -p $cl_method --outfil\
e $outfile --align 5 --stype protein $infile\";\n	\
	\n		my $maxrun=5;#number of crashes accepetd\n		m\
y $nrun;\n		my $keep_going=1;\n		while ($keep_goin\
g)\n		  {\n		    \n		    #print \"----- $command [\
$nrun]\\n\";\n		    $nrun++;\n		    $keep_going=0;\
\n		    &safe_system ( $command,5);\n		    \n		   \
 my $success=0;\n		    $success =$success || -e \"\
$outfile.out.xml\";\n		    $success =$success || -\
e \"$outfile.xml.xml\";\n		    $success =$success \
|| -e \"$outfile.out..xml\";\n		    $success =$suc\
cess || -e \"$outfile.xml..xml\";\n		    \n		    i\
f (!$success && ($nrun<$maxrun || -e \"$outfile.ou\
t.txt\"))\n		      {\n			$keep_going=1;\n			add_wa\
rning($$,$$,\"[ncbiblast_lwp.pl] [$command] failed\
 to produce xml output -- will ne tried again [$nr\
un]\");\n		      }\n		  }\n		\n		if (-e \"$outfile\
.out.xml\") {`mv $outfile.out.xml $outfile`;}\n		e\
lsif (-e \"$outfile.xml.xml\"){`mv $outfile.xml.xm\
l $outfile`;}\n		elsif (-e \"$outfile.out..xml\") \
{`mv $outfile.out..xml $outfile`;}\n		elsif (-e \"\
$outfile.xml..xml\"){`mv $outfile.xml..xml $outfil\
e`;}\n		else\n		  {\n		    add_warning($$,$$,\"[nc\
biblast_lwp.pl] [$command] failed to produce xml o\
utput\");\n		  }\n	      }\n	  }\n	elsif ($SERVER \
eq \"NCBI\")\n	  {\n	    &check_configuration (\"I\
NTERNET\");\n	    if ($db eq \"uniprot\"){$cl_db=\\
"swissprot\";}\n	    else {$cl_db=$db;}\n\n	    if\
 ( $method eq \"psiblast\" || $psiJ>1){myexit(add_\
error (EXIT_FAILURE,$$,$$,getppid(), \"BLAST_FAILU\
RE::$SERVER does not Support psiblast mode ($psiJF\
lag)\",$CL));}\n	    my $cl_method=$method;\n	    \
\n	    &check_configuration ($cl_method);  \n	    \
$command=\"$cl_method -db $cl_db -query $infile -o\
ut $outfile -outfmt 5 -remote\";\n	    &safe_syste\
m ($command);\n	  }\n	elsif ($SERVER =~/CLIENT_(.*\
)/)\n	  {\n	    my $client=$1;\n	    if ( $method \
eq \"psiblast\" || $psiJ>1){myexit(add_error (EXIT\
_FAILURE,$$,$$,getppid(), \"BLAST_FAILURE::$SERVER\
 does not Support psiblast mode ($psiJFlag)\",$CL)\
);}\n	    $command=\"$client -p $method -d $db -i \
$infile -o $outfile -m 7\";\n	    &safe_system ($c\
ommand);\n	  }\n	elsif ( $SERVER eq \"LOCAL_blasta\
ll\")\n	  {\n	    &check_configuration (\"blastall\
\");\n	    if ( $method eq \"psiblast\" || $psiJ>1\
){myexit(add_error (EXIT_FAILURE,$$,$$,getppid(), \
\"BLAST_FAILURE::$SERVER does not Support psiblast\
 mode ($psiJFlag)\",$CL));}\n	    $command=\"blast\
all -d $db -i $infile -o $outfile -m7 -p blastp\";\
\n	    &safe_system ($command);\n	  }\n	elsif ( $S\
ERVER eq \"LOCAL\")\n	  {\n	    my $legacy=0;\n	  \
  if ($ENV{\"BLAST_DB_DIR\"}) \n	      {\n	    	$x\
=$ENV{\"BLAST_DB_DIR\"};\n		$cl_db=\"$x/$db\";\n	 \
     }\n	    else\n	      {\n		$cl_db=$db;\n	     \
 }\n	    \n	    ##\n	    ## BLAST+ provide differe\
nt binaries names and CLI options\n	    ## Use the\
 'legacy_blast.pl' to keep compatibility with old \
blast commands\n	    ##\n	    $path=`which legacy_\
blast.pl 2>/dev/null`;  \n	    $path=`dirname $pat\
h`; \n	    chomp($path);\n	    \n	    if    (!$leg\
acy && ($method eq \"blastp\" || $method eq \"psib\
last\"))\n	      {\n		\n		&check_configuration(\"p\
siblast\");\n		$command=\"psiblast -db $cl_db -que\
ry $infile -num_iterations $psiJ -out $outfile -ou\
tfmt 5\";\n	      }\n	    elsif ($legacy && $metho\
d eq \"blastp\")\n	     {\n	       &check_configur\
ation(\"legacy_blast.pl\");\n	       $command=\"le\
gacy_blast.pl blastpgp --path $path -d $cl_db -i $\
infile -o $outfile -m7 $psiJFlag\";		\n	     }\n	 \
   elsif ($legacy && $method eq \"psiblast\")\n	  \
    {\n		&check_configuration(\"legacy_blast.pl\")\
;\n		$command=\"legacy_blast.pl blastpgp --path $p\
ath -d $cl_db -i $infile -o $outfile -m7 $psiJFlag\
\";\n	      }\n	    elsif ($method eq \"blastn\")\\
n	      {\n		&check_configuration(\"legacy_blast.p\
l\");\n		$command=\"legacy_blast.pl blastall --pat\
h $path -p blastn -d $cl_db -i $infile -o $outfile\
 -m7 -W6\";\n	      }\n	    &safe_system ($command\
);\n	  }\n	else\n	  {\n\n	    myexit(add_error (EX\
IT_FAILURE,$$,$$,getppid(), \"BLAST_FAILURE::Unkno\
wnServer\",$CL));\n	  }\n\n\n	#Check that everythi\
ng went well\n\n	if ( !-e $outfile || !&is_valid_b\
last_xml($outfile))\n	  {\n\n	    if ( -e $outfile\
)\n	      {\n		add_warning ($$,$$,\"Corrupted Blas\
t Output (Run $run)\");\n		unlink($outfile);\n	   \
   }\n	    if ( -e $error_log)\n	      {\n\n		my $\
error_msg=file2string ($error_log);\n\n		if ( $err\
or_msg =~/enter a valid email/)\n		  {\n		    myex\
it(add_error (EXIT_FAILURE,$$,$$,getppid(), \"BLAS\
T_FAILURE::Invalid_or_rejected_email::$EMAIL\", \"\
$command\"));\n		  }\n	      }\n	    if ( $run==$B\
LAST_MAX_NRUNS)\n	      {\n\n		myexit(add_error (E\
XIT_FAILURE,$$,$$,getppid(), \"BLAST_FAILURE::Unkn\
ownReason\", \"$command\"));\n	      }\n	    else\\
n	      {\n		my $out;\n		if ($SERVER eq \"NCBI\") \
{$SERVER=\"EBI\"; }\n		elsif ($SERVER eq \"EBI\"){\
$SERVER=\"NCBI\";}\n		add_warning ($$,$$,\"Blast f\
or $name failed (Run: $run out of $BLAST_MAX_NRUNS\
. Use $SERVER)\");\n		$out=&run_blast ($name, $met\
hod, $db,$infile, $outfile, $run+1);\n		if ($SERVE\
R eq \"NCBI\") {$SERVER=\"EBI\"; }\n		elsif ($SERV\
ER eq \"EBI\"){$SERVER=\"NCBI\";}\n		return $out;\\
n	      }\n	  }\n\n	&cache_file(\"SET\",$infile,$n\
ame,$method,$db,$outfile,$SERVER, $psiJ);\n	return\
 $outfile;\n      }\n  }\n\nsub cache_file\n  {\n \
   my ($cache_mode,$infile,$name,$method,$db, $out\
file,$server,$it)=(@_);\n    my $cache_file;\n    \
#Protect names so that they can be turned into leg\
al filenames\n    $name=&clean_file_name ($name);\\
n    if (!$it){$it=1;}\n    if ($db=~/\\//)\n     \
 {\n	$db=~/([^\\/]+)$/;\n	$db=$1;\n      }\n\n    \
$cache_file=\"$CACHE/$name.$method.$db.$server.$it\
.tmp\";\n    #print \"Look for $cache_file [$cache\
_mode][$CACHE] \\n\";\n    if ($infile ne \"\"){$c\
ache_file_infile=\"$CACHE/$name.$method.$db.$serve\
r.$it.infile.tmp\";}\n\n    if ($cache_mode eq \"G\
ET\")\n      {\n	if ($CACHE eq \"\" || $CACHE eq \\
"no\" || $CACHE eq \"ignore\"  || $CACHE eq \"loca\
l\" || $CACHE eq \"update\"){return 0;}\n	elsif ( \
!-d $CACHE)\n	  {\n	    print STDERR \"ERROR: Cach\
e Dir: $CACHE Does not Exist\";\n	    return 0;\n	\
  }\n	else\n	  {\n	    my ($z1,$z1m)=uncompress($c\
ache_file_infile);\n	    my ($z2,$z2m)=uncompress(\
$cache_file);\n	    \n	    if ( -e $cache_file && \
&fasta_file1_eq_fasta_file2($infile,$cache_file_in\
file)==1)\n	      {\n		`cp $cache_file $outfile`;\\
n		$CACHE_STATUS=\"READ CACHE\";\n		compress($z1,$\
z1m);\n		compress($z2,$z2m);\n		\n		return 1;\n	  \
    }\n	  }\n      }\n    elsif ($cache_mode eq \"\
SET\")\n      {\n	if ($CACHE eq \"\" || $CACHE eq \
\"no\" || $CACHE eq \"ignore\"  || $CACHE eq \"loc\
al\" || $CACHE eq \"update\"){return 0;}\n	elsif (\
 !-d $CACHE)\n	  {\n	    print STDERR \"ERROR: Cac\
he Dir: $CACHE Does not Exist\";\n	    return 0;\n\
	  }\n	elsif (-e $outfile)\n	  {\n	    `cp $outfil\
e $cache_file`;\n	    if ($cache_file_infile ne \"\
\"){ `cp $infile $cache_file_infile`;}\n	    retur\
n 1;\n	  }\n      }\n    $CACHE_STATUS=\"COMPUTE C\
ACHE\";\n    return 0;\n  }\nsub file1_eq_file2\n \
 {\n    my ($f1, $f2)=@_;\n    if ( $f1 eq \"\"){r\
eturn 1;}\n    elsif ( $f2 eq \"\"){return 1;}\n  \
  elsif ( !-e $f1){return 0;}\n    elsif ( !-e $f2\
){return 0;}\n    elsif ($f1 eq \"\" || $f2 eq \"\\
" || `diff $f1 $f2` eq \"\"){return 1;}\n\n    ret\
urn 0;\n  }\nsub clean_file_name\n  {\n    my $nam\
e=@_[0];\n\n    $name=~s/[^A-Za-z1-9.-]/_/g;\n    \
return $name;\n  }\nsub url2file\n  {\n    my ($ad\
dress, $out)=(@_);\n\n    if (&pg_is_installed (\"\
wget\"))\n	{\n	  return &safe_system (\"wget $addr\
ess -O$out >/dev/null 2>/dev/null\");\n	}\n    els\
if (&pg_is_installed (\"curl\"))\n      {\n	return\
 &safe_system (\"curl $address -o$out >/dev/null 2\
>/dev/null\");\n      }\n    else\n      {\n	myexi\
t(flus_error(\"neither curl nor wget are installed\
. Imnpossible to fectch remote file\"));\n	exit ($\
EXIT_FAILURE);\n      }\n  }\nsub fasta_file1_eq_f\
asta_file2\n  {\n    my ($f1, $f2)=@_;\n    my (%s\
1, %s2);\n    my @names;\n    %s1=read_fasta_seq (\
$f1);\n    %s2=read_fasta_seq ($f2);\n\n    @names\
=(keys (%s1));\n\n    foreach $n (keys(%s1))\n    \
  {\n	my $ss1=lc($s1{$n}{seq});\n	my $ss2=lc($s2{$\
n}{seq});\n	if ($ss1 ne $ss2){return 0;}\n      }\\
n    foreach $n (keys(%s2))\n      {\n	my $ss1=lc(\
$s1{$n}{seq});\n	my $ss2=lc($s2{$n}{seq});\n	if ($\
ss1 ne $ss2){return 0;}\n      }\n    \n    return\
 1;\n  }\n\n\n\nsub read_template_file\n  {\n    m\
y $pdb_templates = @_[0];\n    my $tmp=new FileHan\
dle;\n    open ($tmp, \"<$pdb_templates\");\n    m\
y %temp_h;\n    my ($skip,$seq, $temp);\n\n    #su\
pports both a simple [seq pdb] format and the regu\
lar fasta like template format\n    while (<$tmp>)\
\n      {\n	\n	$line = $_;\n	if ($line=~/\\>(\\S+)\
\\s_._\\s(\\S+)/){$temp_h{$1}= $2;}\n	elsif ($line\
 =~/(\\S+)\\s(\\S+)/){$temp_h{$1}= $2;}\n      }\n\
    close($tmp);\n    return %temp_h;\n  }\n\n\n\n\
\n\n\nsub seq2tblastx_lib\n  {\n    my ($mode, $in\
file, $outfile)=@_;\n    my (%s, $method,$nseq);\n\
\n    $method=$mode;\n    &set_temporary_dir (\"se\
t\",$infile,\"infile\");\n    %s=read_fasta_seq(\"\
infile\");\n\n\n    foreach $seq (keys(%s))\n     \
 {\n	$slist[$s{$seq}{order}]=$s{$seq}{seq};\n	$sna\
me[$s{$seq}{order}]=$s{$seq}{name};\n	$slen[$s{$se\
q}{order}]=length ($s{$seq}{seq});\n      }\n    $\
nseq=$#sname+1;\n    open (F, \">outfile\");\n    \
print F \"! TC_LIB_FORMAT_01\\n\";\n    print F \"\
$nseq\\n\";\n    for ($a=0; $a<$nseq;$a++)\n      \
{\n	print F \"$sname[$a] $slen[$a]  $slist[$a]\\n\\
"\n      }\n    close (F);\n    &safe_system (\"fo\
rmatdb -i infile -p F\");\n    &safe_system (\"bla\
stall -p tblastx -i infile -d infile -m 7 -S1>blas\
t.output\");\n\n    ncbi_tblastx_xml2lib_file (\"o\
utfile\", file2string (\"blast.output\"));\n    &s\
et_temporary_dir (\"unset\",$mode, $method, \"outf\
ile\",$outfile);\n    myexit ($EXIT_SUCCESS);\n   \
 }\nsub seq2tblastpx_lib\n  {\n    my ($mode, $inf\
ile, $outfile)=@_;\n    my (%s, $method,$nseq);\n \
   $method=$mode;\n    &set_temporary_dir (\"set\"\
,$infile,\"infile\");\n    %s=read_fasta_seq(\"inf\
ile\");\n\n    foreach $seq (keys(%s))\n      {\n	\
$slist[$s{$seq}{order}]=$s{$seq}{seq};\n	$sname[$s\
{$seq}{order}]=$s{$seq}{name};\n	$slen[$s{$seq}{or\
der}]=length ($s{$seq}{seq});\n      }\n    $nseq=\
$#sname+1;\n    open (F, \">outfile\");\n    print\
 F \"! TC_LIB_FORMAT_01\\n\";\n    print F \"$nseq\
\\n\";\n    for ($a=0; $a<$nseq;$a++)\n      {\n	p\
rint F \"$sname[$a] $slen[$a]  $slist[$a]\\n\"\n  \
    }\n    close (F);\n    &safe_system(\"t_coffee\
 -other_pg seq_reformat -in infile -output tblastx\
_db1 > tblastxdb\");\n    &safe_system (\"formatdb\
 -i tblastxdb -p T\");\n    &safe_system (\"blasta\
ll -p blastp -i tblastxdb -d tblastxdb -m7 >blast.\
output\");\n    ncbi_tblastpx_xml2lib_file (\"outf\
ile\", file2string (\"blast.output\"), %s);\n    &\
set_temporary_dir (\"unset\",$mode, $method, \"out\
file\",$outfile);\n    myexit ($EXIT_SUCCESS);\n  \
  }\n\nsub x3dna_find_pair2lib\n      {\n      my \
($seq, $pdb, $lib, $pg)=@_;\n      my $outfile1=\"\
dssr-2ndstrs.dbn\";\n      my $outfile2=\"simple.o\
utput\";\n      my $f= new FileHandle;\n      my (\
$rnaSS,$pdbSS);\n      my $command;\n      my %s_p\
db;\n      my %s_seq;\n      my $pdbseq=vtmpnam(NU\
LL);\n      \n      #$pg: \"find_pair\" OR \"find_\
pair -p\"\n      \n      if (!pg_is_installed (\"f\
ind_pair\"))\n	{\n	  add_warning ($$,$$, \"x3dna/f\
ind_pair could not be used to extract RNA secondar\
y structures. Secondary structures will be extract\
ed by x3dna-ssr instead -- Install the find-pair m\
odule of x3dna  [http://x3dna.org/]\");\n	  return\
 x3dnassr2lib ($seq, $pdb, $lib);\n	}\n      \n\n \
     #get PDB sequence\n      safe_system (\"t_cof\
fee -other_pg extract_from_pdb $pdb -seq >$pdbseq\\
");\n      \n      #get find_pair contacts\n      \
$command=\"$pg $pdb simple.output > /dev/null 2>/d\
ev/null\";\n      safe_system ($command);\n\n     \
 if (($command=~/find_pair -p/)){$outfile2=\"allpa\
irs.ana\";}\n      else {$outfile2=\"simple.output\
\";}\n      \n      if ( !-e $outfile2)\n	{\n	  my\
exit(flush_error(\"x3dna failed to compute the sec\
ondary structure file $outfile2 for $pdb\"));\n	  \
myexit ($EXIT_FAILURE);\n	}\n      \n\n      #Hand\
le situations when the pdb sequence differs from t\
he RNA sequence\n      #my @out=file2array($outfil\
e1);\n      %s_pdb=read_fasta_seq_index ($pdbseq);\
\n      %s_seq=read_fasta_seq_index ($seq);\n     \
 my $rnaS=uc($s_seq{0}{seq});\n      my $pdbS=uc($\
s_pdb{0}{seq});\n      my $vienna;\n      my @lu;\\
n    \n      if ($rnaS ne $pdbS)\n	{\n	  \n	  my (\
$rna,$pdb);\n	  $rnaSS=$rnaS;\n	  $pdbSS=$pdbS;\n	\
  $rnaSS=~s/T/U/g;\n	  $pdbSS=~s/T/U/g;\n	  ($rnaS\
S,$pdbSS)=nw ($rnaS, $pdbS);\n	  \n	  my @rnaA =sp\
lit (//,$rnaSS);\n	  my @pdbA=split (//,$pdbSS);\n\
	  my $l=@rnaA;\n	  \n	  #print \"\\n--- $s_seq{0}\
{name} $rnaSS\\n--- $s_seq{0}{name} $pdbSS\\n\\n\"\
;\n	  \n	  for (my $b=0,my $a=0; $a<$l; $a++)\n	  \
  {\n	      if   ($rnaA[$a] ne '-' && $pdbA[$a] ne\
 '-'){$lu[++$pdb]=++$rna;}\n	      elsif($rnaA[$a]\
 eq '-'){$lu[++$pdb]=-1;}\n	      elsif($pdbA[$a] \
eq '-'){++$rna;}\n	    }\n	}\n      else\n	{\n	  f\
or (my $a=0; $a<=length ($rnaS); $a++)\n	    {\n	 \
     $lu[$a]=$a;\n	    }\n	}\n      my $l=length (\
$rnaS);\n      open ($f, \">$lib\");\n      print \
$f \"! TC_LIB_FORMAT_01\\n\";\n      print $f \"1\\
\n\";\n      print $f \"$s_seq{0}{name} $l $rnaS\\\
n\";\n      print $f \"!CMT: [SOURCE] >$s_seq{0}{n\
ame} 3D contact library Generated by $pg (x3dna)\\\
n\";\n      print $f \"#1 1\\n\";\n      \n      m\
y $ne;\n      my @array=file2array($outfile2);\n  \
    for (my $a=0; $a<5; $a++){shift (@array);}\n  \
    while (!($array[0]=~/####/))\n	{\n	  my $line=\
 shift (@array);\n	  my @l=($line=~/(\\d+)/g);\n	 \
 \n	 \n	  my $f1=$lu[$l[0]];\n	  my $s1=$lu[$l[1]]\
;\n\n	  #print \"\\n$line\\n$l[0] --> $f1\\n$l[1] \
--> $s1\\n\\n\"; \n	  \n	  if (!$f1 || !$s1)\n	   \
 {\n	      print \"\\n1---- $rnaSS\\n2---- $pdbSS\\
\n$line\\n[$l[0] --- $l[1]]<---->[$f1 --- $s1]\\n\\
";\n	      myexit(flush_error(\"Error while parsin\
g s3dna::find_pair output\"));\n	    }\n	  elsif (\
$f1==-1 || $s1==-1){;}\n	  elsif ($f1<$s1){print $\
f \"$f1 $s1 100\\n\";}\n	  else {print $f \"$s1 $f\
1 100\\n\";$ne++;}\n	}\n      print $f \"! SEQ_1_T\
O_N\\n\";\n      close ($f);\n      return;\n    }\
\nsub RNAplfold2lib\n  {\n    my ($seq, $lib)=@_;\\
n    my $f= new FileHandle;\n    \n    &safe_syste\
m (\"t_coffee -other_pg RNAplfold2tclib.pl -in=$se\
q -out=$lib\");\n    \n    if ( !-e $lib)\n	{\n	 m\
yexit(flush_error(\"RNAplfold failed to compute th\
e secondary structure of $s{$seq}{name}\"));\n	 my\
exit ($EXIT_FAILURE);\n       }\n    open ($f, \">\
>$lib\");\n    print $f \"!CMT: [SOURCE] 2D contac\
t library Generated by RNAPlfold (Vienna Package)\\
\n\";\n    close $f;\n    return;\n  }\nsub x3dnas\
sr2lib\n    {\n      my ($seq, $pdb, $lib)=@_;\n  \
    my $outfile=\"dssr-2ndstrs.dbn\";\n      my $f\
= new FileHandle;\n      \n\n      if (!pg_is_inst\
alled (\"x3dna-ssr\"))\n	{\n	  add_warning ($$,$$,\
 \"x3dna-ssr could not be used to extract RNA seco\
ndary structures. Secondary structures will be pre\
dicted ab-initio instead with RNAPlfold -- Install\
 s3dna [http://x3dna.org/] \");\n	  return RNAplfo\
ld2lib ($seq,$lib);\n	}\n      \n      safe_system\
 (\"x3dna-ssr -i=$pdb >/dev/null 2>/dev/null\");\n\
      if ( !-e $outfile)\n	{\n	  myexit(flush_erro\
r(\"x3dna-ssr failed to compute the secondary stru\
cture file \"));\n	  myexit ($EXIT_FAILURE);\n	}\n\
\n      #Handle situations when the pdb sequence d\
iffers from the RNA sequence\n      @out=file2arra\
y($outfile);\n      my %s=read_fasta_seq ($seq);\n\
      my @names=keys (%s);\n      my $rnaS=uc($s{$\
names[0]}{seq});\n      my $pdbS=uc($out[1]);\n   \
   my $vienna;\n      \n      #x3dna returns non l\
egitimate nucleotides\n       $pdbS=~s/[^AGCTU]//g\
;\n      \n      if ($rnaS ne $pdbS)\n	{\n	  my ($\
rna,$pdb);\n	  my $rnaSS=$rnaS;\n	  my $pdbSS=$pdb\
S;\n	  $rnaSS=~s/T/U/g;\n	  $pdbSS=~s/T/U/g;\n	  (\
$rnaSS,$pdbSS)=nw ($rnaSS, $pdbSS);\n	  my @rnaA =\
split (//,$rnaSS);\n	  my @pdbA=split (//,$pdbSS);\
\n	  my @SS=split (//, $out[2]);\n	  \n	  my $l=@r\
naA;\n	  for (my $b=0,my $a=0; $a<$l; $a++)\n	    \
{\n	      if   ($rnaA[$a] ne '-' && $pdbA[$a] ne '\
-'){$vienna.=$SS[$b++];}\n	      elsif($rnaA[$a] e\
q '-'){$b++;}\n	      elsif($pdbA[$a] eq '-'){$vie\
nna.='.';}\n	    }\n	}\n      else\n	{\n	  $vienna\
=$out[2];\n	}\n    \n\n      open ($f, \">seq\");\\
n      print $f \">$names[0]\\n$rnaS\\n\";\n      \
close $f;\n      \n      open ($f, \">str\");\n   \
   print $f \">$names[0]\\n$vienna\\n\";\n      cl\
ose $f;\n      \n      safe_system (\"t_coffee -ot\
her_pg seq_reformat -in seq -in2 str -output vienn\
a2tc_lib >$lib\");\n      if ( !-e $lib)\n	    {\n\
	      myexit(flush_error(\"seq_reformat failed to\
 convert your secondary structure\"));\n	      mye\
xit ($EXIT_FAILURE);\n	    }\n      \n      open (\
$f, \">>$lib\");\n      print $f \"!CMT: [SOURCE] \
>$names[0] 2D Contact library generated by x3dna-s\
sr\\n\";\n      #print $f \"! Vienna_Format: >$nam\
es[0]\\n\";\n      #print $f \"! Vienna_Format: $v\
ienna\\n\";\n      \n      close $f;\n      return\
;\n    }\n\n\nsub file2head\n      {\n	my $file = \
shift;\n	my $size = shift;\n	my $f= new FileHandle\
;\n	my $line;\n	open ($f,$file);\n	read ($f,$line,\
 $size);\n	close ($f);\n	return $line;\n      }\ns\
ub file2tail\n      {\n	my $file = shift;\n	my $si\
ze = shift;\n	my $f= new FileHandle;\n	my $line;\n\
\n	open ($f,$file);\n	seek ($f,$size*-1, 2);\n	rea\
d ($f,$line, $size);\n	close ($f);\n	return $line;\
\n      }\n\n\nsub vtmpnam\n      {\n	my $r=rand(1\
00000);\n	my $f=\"file.$r.$$\";\n	while (-e $f)\n	\
  {\n	    $f=vtmpnam();\n	  }\n	push (@TMPFILE_LIS\
T, $f);\n	return $f;\n      }\n\nsub myexit\n  {\n\
    my $code=@_[0];\n    if ($CLEAN_EXIT_STARTED==\
1){return;}\n    else {$CLEAN_EXIT_STARTED=1;}\n  \
  ### ONLY BARE EXIT\n    exit ($code);\n  }\nsub \
set_error_lock\n    {\n      my $name = shift;\n  \
    my $pid=$$;\n\n\n      &lock4tc ($$,\"LERROR\"\
, \"LSET\", \"$$ -- ERROR: $name $PROGRAM\\n\");\n\
      return;\n    }\nsub set_lock\n  {\n    my $p\
id=shift;\n    my $msg= shift;\n    my $p=getppid(\
);\n    &lock4tc ($pid,\"LLOCK\",\"LRESET\",\"$p$m\
sg\\n\");\n  }\nsub unset_lock\n   {\n\n    my $pi\
d=shift;\n    &lock4tc ($pid,\"LLOCK\",\"LRELEASE\\
",\"\");\n  }\nsub shift_lock\n  {\n    my $from=s\
hift;\n    my $to=shift;\n    my $from_type=shift;\
\n    my $to_type=shift;\n    my $action=shift;\n \
   my $msg;\n\n    if (!&lock4tc($from, $from_type\
, \"LCHECK\", \"\")){return 0;}\n    $msg=&lock4tc\
 ($from, $from_type, \"LREAD\", \"\");\n    &lock4\
tc ($from, $from_type,\"LRELEASE\", $msg);\n    &l\
ock4tc ($to, $to_type, $action, $msg);\n    return\
;\n  }\nsub isshellpid\n  {\n    my $p=shift;\n   \
 if (!lock4tc ($p, \"LLOCK\", \"LCHECK\")){return \
0;}\n    else\n      {\n	my $c=lock4tc($p, \"LLOCK\
\", \"LREAD\");\n	if ( $c=~/-SHELL-/){return 1;}\n\
      }\n    return 0;\n  }\nsub isrootpid\n  {\n \
   if(lock4tc (getppid(), \"LLOCK\", \"LCHECK\")){\
return 0;}\n    else {return 1;}\n  }\nsub lock4tc\
\n	{\n	  my ($pid,$type,$action,$value)=@_;\n	  my\
 $fname;\n	  my $host=hostname;\n\n	  if ($type eq\
 \"LLOCK\"){$fname=\"$LOCKDIR/.$pid.$host.lock4tco\
ffee\";}\n	  elsif ( $type eq \"LERROR\"){ $fname=\
\"$LOCKDIR/.$pid.$host.error4tcoffee\";}\n	  elsif\
 ( $type eq \"LWARNING\"){ $fname=\"$LOCKDIR/.$pid\
.$host.warning4tcoffee\";}\n\n	  if ($debug_lock)\\
n	    {\n	      print STDERR \"\\n\\t---lock4tc(tc\
g): $action => $fname =>$value (RD: $LOCKDIR)\\n\"\
;\n	    }\n\n	  if    ($action eq \"LCHECK\") {ret\
urn -e $fname;}\n	  elsif ($action eq \"LREAD\"){r\
eturn file2string($fname);}\n	  elsif ($action eq \
\"LSET\") {return string2file ($value, $fname, \">\
>\");}\n	  elsif ($action eq \"LRESET\") {return s\
tring2file ($value, $fname, \">\");}\n	  elsif ($a\
ction eq \"LRELEASE\")\n	    {\n	      if ( $debug\
_lock)\n		{\n		  my $g=new FileHandle;\n		  open (\
$g, \">>$fname\");\n		  print $g \"\\nDestroyed by\
 $$\\n\";\n		  close ($g);\n		  safe_system (\"mv \
$fname $fname.old\");\n		}\n	      else\n		{\n		  \
unlink ($fname);\n		}\n	    }\n	  return \"\";\n	}\
\n\nsub file2string\n	{\n	  my $file=@_[0];\n	  my\
 $f=new FileHandle;\n	  my $r;\n	  open ($f, \"$fi\
le\");\n	  while (<$f>){$r.=$_;}\n	  close ($f);\n\
	  return $r;\n	}\nsub file2array\n	{\n	  my $file\
=@_[0];\n	  my $f=new FileHandle;\n	  my @r;\n	  o\
pen ($f, \"$file\");\n	  while (<$f>){@r=(@r,$_);}\
\n	  close ($f);\n	  return @r;\n	}\nsub string2fi\
le\n    {\n    my ($s,$file,$mode)=@_;\n    my $f=\
new FileHandle;\n\n    open ($f, \"$mode$file\");\\
n    print $f  \"$s\";\n    close ($f);\n  }\n\nBE\
GIN\n    {\n      srand;\n\n      $SIG{'SIGUP'}='s\
ignal_cleanup';\n      $SIG{'SIGINT'}='signal_clea\
nup';\n      $SIG{'SIGQUIT'}='signal_cleanup';\n  \
    $SIG{'SIGILL'}='signal_cleanup';\n      $SIG{'\
SIGTRAP'}='signal_cleanup';\n      $SIG{'SIGABRT'}\
='signal_cleanup';\n      $SIG{'SIGEMT'}='signal_c\
leanup';\n      $SIG{'SIGFPE'}='signal_cleanup';\n\
\n      $SIG{'SIGKILL'}='signal_cleanup';\n      $\
SIG{'SIGPIPE'}='signal_cleanup';\n      $SIG{'SIGS\
TOP'}='signal_cleanup';\n      $SIG{'SIGTTIN'}='si\
gnal_cleanup';\n      $SIG{'SIGXFSZ'}='signal_clea\
nup';\n      $SIG{'SIGINFO'}='signal_cleanup';\n\n\
      $SIG{'SIGBUS'}='signal_cleanup';\n      $SIG\
{'SIGALRM'}='signal_cleanup';\n      $SIG{'SIGTSTP\
'}='signal_cleanup';\n      $SIG{'SIGTTOU'}='signa\
l_cleanup';\n      $SIG{'SIGVTALRM'}='signal_clean\
up';\n      $SIG{'SIGUSR1'}='signal_cleanup';\n\n\\
n      $SIG{'SIGSEGV'}='signal_cleanup';\n      $S\
IG{'SIGTERM'}='signal_cleanup';\n      $SIG{'SIGCO\
NT'}='signal_cleanup';\n      $SIG{'SIGIO'}='signa\
l_cleanup';\n      $SIG{'SIGPROF'}='signal_cleanup\
';\n      $SIG{'SIGUSR2'}='signal_cleanup';\n\n   \
   $SIG{'SIGSYS'}='signal_cleanup';\n      $SIG{'S\
IGURG'}='signal_cleanup';\n      $SIG{'SIGCHLD'}='\
signal_cleanup';\n      $SIG{'SIGXCPU'}='signal_cl\
eanup';\n      $SIG{'SIGWINCH'}='signal_cleanup';\\
n\n      $SIG{'INT'}='signal_cleanup';\n      $SIG\
{'TERM'}='signal_cleanup';\n      $SIG{'KILL'}='si\
gnal_cleanup';\n      $SIG{'QUIT'}='signal_cleanup\
';\n\n      our $debug_lock=$ENV{\"DEBUG_LOCK\"};\\
n\n\n\n\n      foreach my $a (@ARGV){$CL.=\" $a\";\
}\n      if ( $debug_lock ){print STDERR \"\\n\\n\\
\n********** START PG: $PROGRAM *************\\n\"\
;}\n      if ( $debug_lock ){print STDERR \"\\n\\n\
\\n**********(tcg) LOCKDIR: $LOCKDIR $$ **********\
***\\n\";}\n      if ( $debug_lock ){print STDERR \
\"\\n --- $$ -- $CL\\n\";}\n\n\n\n\n    }\nsub flu\
sh_error\n  {\n    my $msg=shift;\n    $msg.=\" [t\
c_generic_method.pl/FATAL]\";\n    return add_erro\
r ($EXIT_FAILURE,$$, $$,getppid(), $msg, $CL);\n  \
}\nsub add_error\n  {\n    my $code=shift;\n    my\
 $rpid=shift;\n    my $pid=shift;\n    my $ppid=sh\
ift;\n    my $type=shift;\n    my $com=shift;\n\n \
   $ERROR_DONE=1;\n    lock4tc ($rpid, \"LERROR\",\
\"LSET\",\"$pid -- ERROR: $type\\n\");\n    lock4t\
c ($$, \"LERROR\",\"LSET\", \"$pid -- COM: $com\\n\
\");\n    lock4tc ($$, \"LERROR\",\"LSET\", \"$pid\
 -- STACK: $ppid -> $pid\\n\");\n\n    return $cod\
e;\n  }\nsub add_warning\n  {\n    my $rpid=shift;\
\n    my $pid =shift;\n    my $command=shift;\n   \
 my $msg=\"$$ -- WARNING: $command\\n\";\n    prin\
t STDERR \"$msg\";\n    lock4tc ($$, \"LWARNING\",\
 \"LSET\", $msg);\n  }\n\nsub signal_cleanup\n  {\\
n    print dtderr \"\\n**** $$ (tcg) was killed\\n\
\";\n    &cleanup;\n    exit ($EXIT_FAILURE);\n  }\
\nsub clean_dir\n  {\n    my $dir=@_[0];\n    if (\
 !-d $dir){return ;}\n    elsif (!($dir=~/tmp/)){r\
eturn ;}#safety check 1\n    elsif (($dir=~/\\*/))\
{return ;}#safety check 2\n    else\n      {\n	`rm\
 -rf $dir`;\n      }\n    return;\n  }\nsub cleanu\
p\n  {\n    #print stderr \"\\n----tc: $$ Kills $P\
IDCHILD\\n\";\n    #kill (SIGTERM,$PIDCHILD);\n   \
 my $p=getppid();\n    $CLEAN_EXIT_STARTED=1;\n\n\\
n\n    if (&lock4tc($$,\"LERROR\", \"LCHECK\", \"\\
"))\n      {\n	my $ppid=getppid();\n	if (!$ERROR_D\
ONE)\n	  {\n	    &lock4tc($$,\"LERROR\", \"LSET\",\
 \"$$ -- STACK: $p -> $$\\n\");\n	    &lock4tc($$,\
\"LERROR\", \"LSET\", \"$$ -- COM: $CL\\n\");\n	  \
}\n      }\n    my $warning=&lock4tc($$, \"LWARNIN\
G\", \"LREAD\", \"\");\n    my $error=&lock4tc($$,\
  \"LERROR\", \"LREAD\", \"\");\n    #release erro\
r and warning lock if root\n\n    if (isrootpid() \
&& ($warning || $error) )\n      {\n\n	print STDER\
R \"**************** Summary *************\\n$erro\
r\\n$warning\\n\";\n\n	&lock4tc($$,\"LERROR\",\"RE\
LEASE\",\"\");\n	&lock4tc($$,\"LWARNING\",\"RELEAS\
E\",\"\");\n      }\n\n\n    foreach my $f (@TMPFI\
LE_LIST)\n      {\n	if (-e $f){unlink ($f);}\n    \
  }\n    foreach my $d (@TMPDIR_LIST)\n      {\n	c\
lean_dir ($d);\n      }\n    #No More Lock Release\
\n    #&lock4tc($$,\"LLOCK\",\"LRELEASE\",\"\"); #\
release lock\n\n    if ( $debug_lock ){print STDER\
R \"\\n\\n\\n********** END PG: $PROGRAM ($$) ****\
*********\\n\";}\n    if ( $debug_lock ){print STD\
ERR \"\\n\\n\\n**********(tcg) LOCKDIR: $LOCKDIR $\
$ *************\\n\";}\n  }\nEND\n  {\n\n    &clea\
nup();\n  }\n\nsub blast_com2new_blast_com\n    {\\
n      my $com=shift;\n      if ($com=~/formatdb/)\
\n	{\n	  $com=~s/formatdb/makeblastdb/;\n	  $com=~\
s/\\-i/\\-in/;\n	  if ($com =~/pF/){$com=~s/\\-pF/\
\\-dbtype nucl/;}\n	  if ($com =~/p F/){$com=~s/\\\
-p F/\\-dbtype nucl/;}\n	  $com=\"$com -logfile /d\
ev/null\";\n	  return $com;\n	}\n      else {retur\
n $com;}\n      \n    }\nsub safe_system\n{\n  my \
$com=shift;\n  my $ntry=shift;\n  my $ctry=shift;\\
n  my $pid;\n  my $status;\n  my $ppid=getppid();\\
n  if ($com eq \"\"){return 1;}\n \n  if ( ($com=~\
/^blast/) ||($com=~/^formatdb/)){$com=&blast_com2n\
ew_blast_com($com);}\n \n  if (($pid = fork ()) < \
0){return (-1);}\n  if ($pid == 0)\n    {\n      s\
et_lock($$, \" -SHELL- $com (tcg)\");\n      if( $\
debug_generic_method ) { printf \"~ exec: %s\\n\",\
 $com; }\n      exec ($com);\n      if( $debug_gen\
eric_method ) { printf \"~ exitcode: %s\\n\", $?; \
}\n    }\n  else\n    {\n      lock4tc ($$, \"LLOC\
K\", \"LSET\", \"$pid\\n\");#update parent\n      \
$PIDCHILD=$pid;\n    }\n  if ($debug_lock){printf \
STDERR \"\\n\\t .... safe_system (fasta_seq2hmm)  \
p: $$ c: $pid COM: $com\\n\";}\n\n  waitpid ($pid,\
WTERMSIG);\n\n  shift_lock ($pid,$$, \"LWARNING\",\
\"LWARNING\", \"LSET\");\n\n  if ($? == $EXIT_FAIL\
URE || lock4tc($pid, \"LERROR\", \"LCHECK\", \"\")\
)\n    {\n      if ($ntry && $ctry <$ntry)\n	{\n\n\
	  add_warning ($$,$$,\"$com failed [retry: $ctry \
out of $ntry]\");\n	  lock4tc ($pid, \"LRELEASE\",\
 \"LERROR\", \"\");\n	  #if ($com=~/EBI/){$com=~s/\
EBI/NCBI/;}\n	  #elsif ($com=~/NCBI/){$com=~s/NCBI\
/EBI/;}\n\n	  return safe_system ($com, $ntry, ++$\
ctry);\n	}\n      elsif ($ntry == -1)\n	{\n	  if (\
!shift_lock ($pid, $$, \"LERROR\", \"LWARNING\", \\
"LSET\"))\n	    {\n	      add_warning ($$,$$,\"$co\
m failed\");\n	    }\n	  else\n	    {\n	      lock\
4tc ($pid, \"LRELEASE\", \"LERROR\", \"\");\n	    \
}\n	  return $?;}\n      else\n	{\n	  if (!shift_l\
ock ($pid,$$, \"LERROR\",\"LERROR\", \"LSET\"))\n	\
    {\n	      myexit(add_error ($EXIT_FAILURE,$$,$\
pid,getppid(), \"UNSPECIFIED system\", $com));\n	 \
   }\n	}\n    }\n  return $?;\n}\n\nsub check_conf\
iguration\n    {\n      my @l=@_;\n      my $v;\n \
     foreach my $p (@l)\n	{\n\n	  if   ( $p eq \"E\
MAIL\")\n	    {\n	      if ( !($EMAIL=~/@/))\n		{\\
n		add_warning($$,$$,\"Could Not Use EMAIL\");\n		\
myexit(add_error ($EXIT_FAILURE,$$,$$,getppid(),\"\
EMAIL\",\"$CL\"));\n	      }\n	    }\n	  elsif( $p\
 eq \"INTERNET\")\n	    {\n	      if ( !&check_int\
ernet_connection())\n		{\n		  myexit(add_error ($E\
XIT_FAILURE,$$,$$,getppid(),\"INTERNET\",\"$CL\"))\
;\n		}\n	    }\n	  elsif( $p eq \"wget\")\n	    {\\
n	      if (!&pg_is_installed (\"wget\") && !&pg_i\
s_installed (\"curl\"))\n		{\n		  myexit(add_error\
 ($EXIT_FAILURE,$$,$$,getppid(),\"PG_NOT_INSTALLED\
:wget\",\"$CL\"));\n		}\n	    }\n	  elsif( !(&pg_i\
s_installed ($p)))\n	    {\n	      myexit(add_erro\
r ($EXIT_FAILURE,$$,$$,getppid(),\"PG_NOT_INSTALLE\
D:$p\",\"$CL\"));\n	    }\n	}\n      return 1;\n  \
  }\nsub nw\n      {\n	my($A,$B)=@_;\n	my ($i,$j, \
$s);\n	my $gep=-2;\n	my $match=+2;\n	my $mismatch=\
0;\n	my ($sub, $ins, $del);\n\n\n	if ($A eq $B){re\
turn ($A,$B);}\n	\n	$A=~s/[\\s\\d]//g;	\n	$B=~s/[\\
\s\\d]//g;	\n\n\n	my @rA=split ('',$A);\n	my @rB=s\
plit ('',$B);\n	\n	#evaluate substitutions\n	my $l\
enA=@rA;\n	my $lenB=@rB;\n	\n	for ($i=0; $i<=$lenA\
; $i++){$smat[$i][0]=$i*$gep;$tb[$i][0 ]= 1;}\n	fo\
r ($j=0; $j<=$lenB; $j++){$smat[0][$j]=$j*$gep;$tb\
[0 ][$j]=-1;}\n	\n	for ($i=1; $i<=$lenA; $i++)\n	 \
 {\n	    for ($j=1; $j<=$lenB; $j++)\n	      {\n		\
if ($rA[$i-1] eq $rB[$j-1]){$s=$match;}\n		else {$\
s=$mismatch;}\n		\n		$sub=$smat[$i-1][$j-1]+$s;\n	\
	$del=$smat[$i  ][$j-1]+$gep;\n		$ins=$smat[$i-1][\
$j  ]+$gep;\n		\n		if   ($sub>=$del && $sub>=$ins)\
{$smat[$i][$j]=$sub;$tb[$i][$j]=0;}\n		elsif($del>\
$ins){$smat[$i][$j]=$del;$tb[$i][$j]=-1;}\n		else \
{$smat[$i][$j]=$ins;$tb[$i][$j]=1;}\n		}\n	  }\n	#\
print \"\\n---- SCORE=$smat[$lenA][$lenB]\\n\";\n	\
\n	$i=$lenA;\n	$j=$lenB;\n	my $aln_len=0;\n\n	whil\
e (!($i==0 && $j==0))\n	  {\n	    if ($tb[$i][$j]=\
=0)\n	    {\n	      $aA[$aln_len]=$rA[--$i];\n	   \
   $aB[$aln_len]=$rB[--$j];\n	    }\n	  elsif ($tb\
[$i][$j]==-1)\n	    {\n	      $aA[$aln_len]='-';\n\
	      $aB[$aln_len]=$rB[--$j];\n	    }\n	  elsif \
($tb[$i][$j]==1)\n	    {\n	      $aA[$aln_len]=$rA\
[--$i];\n	      $aB[$aln_len]='-';\n	    }\n	  $al\
n_len++;\n	  }\n	\n	\n	@aA=reverse (@aA);\n	@aB=re\
verse (@aB);\n	my $sA=join('',@aA);\n	my $sB=join(\
'',@aB);\n	return ($sA,$sB);\n      }\n      \nsub\
 fasta2nseq\n	{\n	  \n	  my $f=@_[0];\n	  my $nseq\
;\n\n	  open (F, \"$f\") or return 0;\n	  while (<\
F>)\n	    {\n	      if ($_=~/\\>/){$nseq++;}\n	   \
 }\n	  close (F);\n	  return $nseq;\n	}\n	\nsub co\
mpress\n	  {\n	    my ($f, $mode)=@_;\n	    if    \
($mode eq \"gz\"){system (\"gzip $f\");}\n	    els\
if ($mode eq \"zip\" ){system (\"zip $f\");}\n	   \
 return;\n	  }\nsub uncompress \n	  {\n	    my $f=\
@_[0];\n	    if ( -e $f) {return \"\";}\n\n	    my\
 $gz=$f.\".gz\";\n	    if ( -e $gz)\n	      {\n		s\
ystem (\"gunzip $gz\");\n		return ($f, \"gz\");\n	\
      }\n	    my $gz=$f.\".zip\";\n	    \n	    if \
( -e $gz)\n	      {\n		system (\"unzip $gz\");\n		\
return ($f, \"zip\");\n	      }\n	    return \"\";\
\n	  }\nmy $program=\"T-COFFEE (Version_13.45.58.c\
355d11)\";\n","use Env;\nuse strict;\nuse FileHand\
le;\nuse DirHandle;\nuse Cwd;\nuse File::Path;\nus\
e Sys::Hostname;\nuse File::Temp qw/ tempfile temp\
dir /;\n\nmy $QUIET=\">/dev/null 2>/dev/null\";\nm\
y $VERBOSE=$ENV{VERBOSE_4_DYNAMIC};\nmy $FATAL=\"[\
FATAL:mmseqs2prf]\";\nour $EXIT_FAILURE=1;\nour $E\
XIT_SUCCESS=0;\nour $LAST_COM=\"\";\n\nmy $tmpdir \
= File::Temp->newdir();\n\nmy $doquiet=0;\nmy ($ou\
tdir,$cachedb,$cacheq);\n\nmy $ff=new FileHandle;\\
nmy (%db, %q, %P, %H, %T);\nmy ($dbf, $qf, $out);\\
nmy $prot_min_cov=50;\nmy $prot_min_sim=0;\nmy $pr\
ot_max_sim=100;\nmy $psitrim_mode=\"sorttrim\";\n\\
nmy $psitrim_tree=\"codnd\";\nmy $psitrim=100;\nmy\
 $psiJ=1;\nmy $TF;\nmy $S;\n\nmy $updatedb=0;\nmy \
$updateq=0;\nmy $update=0;\nmy $qff;\nmy %CIRCULAR\
;\nmy $mmseqsR;\nmy %R;\nmy $split=1000000;\n\nfor\
 ($a=0; $a<=$#ARGV; $a++)\n  {\n    if    ($ARGV[$\
a] eq \"-protein_db\" || $ARGV[$a] eq \"-db\"){$db\
f=file2abs($ARGV[++$a]);}\n    elsif ($ARGV[$a] eq\
 \"-q\" || $ARGV[$a] eq \"-i\") {$qff =file2abs($A\
RGV[++$a]);}\n    elsif ($ARGV[$a] eq \"-update\")\
{$update=1;}\n    elsif ($ARGV[$a] eq \"-quiet\") \
{$doquiet=1;}\n    \n    elsif ($ARGV[$a] eq \"-od\
ir\") {$outdir=file2abs($ARGV[++$a]);}\n    elsif \
($ARGV[$a] eq \"-o\")    {$mmseqsR=file2abs($ARGV[\
++$a]);}\n    \n    elsif ($ARGV[$a] eq \"-templat\
e_file\" || $ARGV[$a] eq \"-tf\") {$TF=($ARGV[++$a\
]);}\n    elsif ($ARGV[$a] eq \"-cachedb\") {$cach\
edb=file2abs($ARGV[++$a]);}\n    elsif ($ARGV[$a] \
eq \"-updatedb\") {$updatedb=1;}\n    \n    \n    \
elsif ($ARGV[$a] eq \"-cacheq\")  {$cacheq=file2ab\
s($ARGV[++$a]);}\n    elsif ($ARGV[$a] eq \"-updat\
eq\") {$updateq=1;}\n    \n    elsif ($ARGV[$a] eq\
 \"-prot_min_sim\") {$prot_min_sim=($ARGV[++$a]);}\
\n    elsif ($ARGV[$a] eq \"-prot_max_sim\") {$pro\
t_max_sim=($ARGV[++$a]);}\n    elsif ($ARGV[$a] eq\
 \"-prot_min_cov\") {$prot_min_cov=($ARGV[++$a]);}\
\n    \n    elsif ($ARGV[$a] eq \"-psitrim_mode\")\
 {$psitrim_mode=$ARGV[++$a];}\n    elsif ($ARGV[$a\
] eq \"-psiJ\")         {$psiJ=$ARGV[++$a];}\n    \
elsif ($ARGV[$a] eq \"-psitrim_tree\") {$psitrim_t\
ree=$ARGV[++$a];}\n    elsif ($ARGV[$a] eq \"-psit\
rim\")      {$psitrim=$ARGV[++$a];}\n    elsif ($A\
RGV[$a] eq \"-s\")            {$S=\"-s \".$ARGV[++\
$a];}\n    elsif ($ARGV[$a] eq \"-split\")        \
{$split=$ARGV[++$a];}\n    else {die \"$ARGV[$a] i\
s an unknown argument $FATAL\";}\n  }\n\nif (!$dbf\
){print STDERR \"ERROR: mmseqs2prf required a data\
base via -protein_db $FATAL\\n\";exit ($EXIT_FAILU\
RE);}\nif (!$qff){print STDERR \"ERROR: mmseqs2prf\
 required a query    -q $FATAL\";exit ($EXIT_FAILU\
RE);}\nif (!is_installed(\"mmseqs\")){print STDERR\
 \"ERROR: mmseqs2prf required mmseqs to be install\
ed $FATAL\\n\";exit ($EXIT_FAILURE);}\n\n\nif   ($\
cachedb eq \"TMP\"){$cachedb=$tmpdir;}\nelsif(!$ca\
chedb){$cachedb=file2path($dbf);}\n\nif   (!$mmseq\
sR){$mmseqsR=\"./out.mmseqs\";}\nif   (!$cacheq ||\
 $cacheq eq \"TMP\"){$cacheq=\"$tmpdir/query\";}\n\
if   (!$outdir  ){$outdir=\"./R_dir\";}\nif   (!$d\
oquiet) {$QUIET=\"\";}\n\nmymkdir ($outdir,$cached\
b,$cacheq,$tmpdir);\nmy ($qf,%H)=filelist2h($outdi\
r,string2fasta_list($qff));\nmake_output_structure\
($outdir,%H);\n\n\nif ( ! -e $mmseqsR || $update){\
split_mmseqs($qf, $cacheq, $updateq, $dbf, $cached\
b, $updatedb,$S,$mmseqsR,$split);}\n\nmmseqs2prf (\
$mmseqsR,$outdir,$prot_min_sim,$prot_max_sim, $pro\
t_min_cov,%H);\nprf2trimprf($outdir,$psitrim_mode,\
 $psitrim_tree, $psitrim, %H);\n\nif ($TF){h2templ\
ate_file ($TF,%H);}\n\n\nsub h2template_file\n  {\\
n    my ($tf,%h)=@_;\n    my $fh =new FileHandle;\\
n    my %lu=my %lu=h2lu(%h);\n\n    open ($fh, \">\
$tf\");\n    foreach my $s (keys{%lu})\n      {\n	\
my $f=$lu{$s}{0};\n	print $fh \">$s _R_ $h{$f}{tpr\
f}{$s}{absolute}\\n\";\n      }\n    close ($fh);\\
n    return $tf;\n  }\n    \nsub prf2trimprf\n  {\\
n    my ($outdir,$psitrim_mode,$psitrim_tree,$psit\
rim, %h)=@_;\n    my $template =new FileHandle;\n \
   my $template_file;\n    my $qf=abs2file($qf);\n\
    \n    my %lu=h2lu(%h);\n    foreach my $s (key\
s(%lu))\n      {\n	my $f=$lu{$s}{0};\n	system (\"t\
_coffee -other_pg seq_reformat -in  $h{$f}{prf}{$s\
}{absolute} -treemode=$psitrim_tree -keep 1 -actio\
n +$psitrim_mode $psitrim -output fasta_aln -out $\
h{$f}{tprf}{$s}{absolute}\");\n	foreach my $i (key\
s%{$lu{$s}})\n	  {\n	   \n	    my $f2=$lu{$s}{$i};\
\n	    if ( !-e $h{$f2}{tprf}{$s}{absolute})\n	   \
   {\n		system (\"cp $h{$f}{tprf}{$s}{absolute} $h\
{$f2}{tprf}{$s}{absolute}\");\n	      }\n	  }\n   \
   }\n    return %P;\n  }\n\n\n\n\nsub h2lu\n  {\n\
    my %h=@_;\n    my %lu;\n    my %count;\n    fo\
reach my $f (keys (%h))\n      {\n	foreach my $s (\
keys(%{$h{$f}{name}}))\n	  {\n	    \n	    $lu{$s}{\
$count{$s}++}=$f;\n	  }\n      }\n    return %lu;\\
n  }\nsub mmseqs2prf\n  {\n    #\"query[0],target[\
1],qaln[2],taln[3],qstart[4],qend[5],pident[6],qco\
v[7],qlen[8]\\\" $QUIET\");\n    my ($out,$outdir,\
$min_id, $max_id,$min_cov, %h)=@_;\n    my $ff  =n\
ew FileHandle;\n    my $prf =new FileHandle;\n    \
my $nn;\n    my $tot;\n    my $psn;\n    my %lu=h2\
lu(%h);\n    my %luf;\n    \n    open ($ff,$out);\\
n    while (<$ff>)\n      {\n	my $l=$_;\n	my @ll=s\
plit (/\\s/, $l);\n	my $sn=$ll[0];\n	my $f =$lu{$s\
n}{0};\n	my $cf=$h {$f}{prf}{$sn}{absolute};\n	\n	\
if ($sn ne $psn)\n	  {\n	    close $prf;\n	    if \
($luf{$cf}){open ($prf, \">>$cf\");}\n	    else\n	\
      {		\n		open ($prf, \">$cf\");\n		print $prf \
\">$sn\\n$h{$f}{seq}{$sn}\\n\";\n	      }\n	  }\n	\
$nn=++$luf{$cf};\n	$psn=$sn;\n	\n	my $id=$ll[6]*10\
0;\n	my $cov=$ll[7]*100;\n	my $len=$ll[8];\n	print\
 \"$id $max_id $min_id\\n\";\n	if ($id<=$max_id &&\
 $id>=$min_id && $cov>$min_cov)\n	  {\n	    print \
\"Keep\";\n	    print $prf \">$sn\\_$nn\\n\";\n	  \
  for (my $a=1; $a<$ll[4]; $a++){print $prf \"-\"}\
\n	    \n	    my @ql=split (//,$ll[2]);\n	    my @\
tl=split (//,$ll[3]);\n	    my $qlen=length($ll[2]\
);\n	    for (my $a=0; $a<$qlen; $a++)\n	      {\n\
		if ($ql[$a] ne \"-\"){print $prf \"$tl[$a]\";}\n\
	      }\n	    for (my $a=$ll[5]; $a<$len; $a++){p\
rint $prf \"-\"}\n	    print $prf \"\\n\";\n	  }\n\
      }\n    close($prf);\n    close($ff);\n\n    \
# checkout the un-used ones\n    foreach my $sn (k\
eys(%lu))\n      {\n	my $f=$lu{$sn}{0};\n\n	if (!-\
e $h{$f}{prf}{$sn}{absolute})\n	  {\n	    open ($p\
rf,\">$h{$f}{prf}{$sn}{absolute}\");\n	    print $\
prf \">$sn\\n$h{$f}{seq}{$sn}\\n\";\n	    close (p\
rf);\n	  }\n      }\n    #duplicate prf files that\
 are shared by different input datasets\n    forea\
ch my $sn (keys (%lu))\n      {\n	my $f0=$lu{$sn}{\
0};\n	\n	foreach my $i (keys(%{$lu{$sn}}))\n	  {	\\
n	    my $f=$lu{$sn}{$i};\n	    if (! -e $h{$f}{pr\
f}{$sn}{absolute}){system (\"cp $h{$f0}{prf}{$sn}{\
absolute} $h{$f}{prf}{$sn}{absolute}\");}\n	  }\n \
     }\n  }\n\n\nsub file2db\n  {\n    my ($in,$di\
r, $update)=(@_);\n    my %f;\n    my $out;\n    \\
n    if ( !-e $in)\n      {\n	print \"$in does not\
 exists $FATAL \\n\";\n      }\n    if ($dir)\n   \
   {\n	if (!-d $dir){mkdir ($dir) or die \"Could n\
ot create $dir $FATAL\"; }\n	$out=$dir.\"/\".abs2f\
ile($in);}\n    else {$out=$in;}\n    \n    \n    \
$f{name}=$in;\n    $f{db}=\"$out\\.MMSEQSDB\";\n  \
  $f{index}=\"$out\\.MMSEQSINDEX\";\n    \n    \n \
   #Trigger automated update when source db younge\
r than mmseqs file\n    if (-e $f{db} && ((-M $f{d\
b})>(-M $f{name}))){$update=1;}\n    \n    if (!-e\
 $f{db} || $update)\n      {\n	system (\"mmseqs cr\
eatedb  $f{name}  $f{db} $QUIET\");\n      }\n    \
\n    if (!-d $f{index} || $update)\n      {\n	sys\
tem (\"mmseqs createindex $f{name} $f{index} $QUIE\
T\");\n      }\n\n    return %f;\n    \n  }\n\nsub\
 file2path\n    {\n      my ($f)=@_;\n      $f=fil\
e2abs($f);\n      $f=~/(.*\\/)[^\\/]*$/;\n      my\
 $cdir=$1;\n      return $cdir;\n    }\nsub file2a\
bs\n     {\n       my ($f, $mode)=@_;\n       my $\
cdir=getcwd();\n       if ($f=~/^\\//){return $f;}\
\n       return \"$cdir/$f\";\n   }\nsub abs2file\\
n    {\n      my $in=shift @_;\n      my $out;\n  \
    \n      if ( $in=~/\\//)\n	  {\n	    $in=~/.*\\
\/([^\\/]*)$/;\n	    $out=$1;\n	  }\n	else\n	  {\n\
	    $out=$in;\n	  }\n      \n    return $out;\n  \
  }\n\nsub read_fasta_seq\n  {\n    my $f=@_[0];\n\
    my %hseq;\n    my (@seq, @com, @name);\n    my\
 ($a, $s,$nseq);\n    my $fh=new FileHandle;\n    \
\n    open ($fh, $f);\n    while (<$fh>)\n      {\\
n	$s.=$_;\n      }\n    close ($fh);\n\n\n    @nam\
e=($s=~/>(\\S*).*\\n[^>]*/g);\n\n    @seq =($s=~/>\
.*.*\\n([^>]*)/g);\n    @com =($s=~/>\\S*(.*)\\n([\
^>]*)/g);\n\n\n    $nseq=$#name+1;\n\n    for ($a=\
0; $a<$nseq; $a++)\n      {\n	my $s;\n	my $n=$name\
[$a];\n	$hseq{$n}{name}=$n;\n	$hseq{$n}{cname}=cle\
an_file_name($n);\n	\n	$seq[$a]=~s/[^A-Za-z]//g;\n\
	$hseq{$n}{order}=$a;\n	$hseq{$n}{seq}=$seq[$a];\n\
	$hseq{$n}{com}=$com[$a];\n\n      }\n    return %\
hseq;\n  }\nsub mymkdir\n    {\n      my @l=@_;\n \
     foreach my $a (@l)\n	{\n	  if ( $a && !-d $a)\
\n	    {\n	      system (\"mkdir -p $a\");\n	     \
 if ( !-d $a)\n		{\n		  die \"Could not Create $a \
$FATAL\\n\";\n		}\n	    }\n	}\n\n      return 1;\n\
    }\nsub clean_file_name\n  {\n    my $name=@_[0\
];\n\n    $name=~s/[^A-Za-z1-9.-]/_/g;\n    return\
 $name;\n  }\n\nsub string2fasta_list\n    {\n    \
  my $string=@_[0];\n      if (!-f $string && !-d \
$string && !($string=~/\\*/)){return ();}\n      i\
f ($CIRCULAR{$string}){print STDERR \"ERROR: CIRCU\
LAR REFERENCE $string   $FATAL\\n\";exit ($EXIT_FA\
ILURE);}\n      $CIRCULAR{$string}=1;\n      \n\n \
     my @l1=string2list($string);\n      my @l2;\n\
      \n      foreach my $f (@l1)\n	{\n\n	  if (is\
fasta($f)){push (@l2, $f);}\n	  else \n	    {\n	  \
    foreach my $string2 (file2list($f))\n		{\n		  \
my @l3=string2fasta_list($string2);\n		  foreach m\
y $string3 (@l3)\n		    {\n		      push (@l2, $str\
ing3);\n		    }\n		}\n	    }\n	}\n      return shr\
inklist(@l2);\n    }\nsub shrinklist\n      {\n	my\
 @l=@_;\n	my @l2;\n\n	foreach my $e (@l)\n	  {\n	 \
   if ($e)\n	      {\n		print \"PUSH [$e]\\n\";\n	\
	push (@l2,$e);\n	      }\n	  }\n	return @l2;\n   \
   }\nsub string2list\n    {\n      my $string=@_[\
0];\n      my @list;\n\n      if    (-d $string   \
   ){@list= dir2list($string);}\n      elsif (   $\
string=~/\\*/){@list= glob    ($string);}\n      e\
lsif (-f $string      ){@list=         ($string);}\
\n      return @list;\n    }\nsub dir2list\n  {\n \
   my $dir=shift;\n    my @list;\n    my $cdir=get\
cwd;\n    my $dh  =new DirHandle;\n    \n    opend\
ir ($dh, $dir);\n    my @dlist=readdir($dh);\n    \
closedir($dh);\n    \n    foreach my $f (@dlist)\n\
      {\n	if ($f eq \".\" || $f eq \"..\"){;}\n	el\
se {push (@list, string2list(\"$dir/$f\"));}\n    \
  }\n    return @list;\n  }\nsub file2list\n{\n  m\
y $file=shift;\n  my @list;\n  my $fh=new FileHand\
le;\n  \n  open ($fh, \"$file\");\n  while (<$fh>)\
\n    {\n      my $l=$_;\n      chomp ($l);\n     \
 if ($l){push(@list, $l);}\n    }\n  close ($fh);\\
n  return @list;\n}\nsub file2string\n  {\n    my \
$f=@_[0];\n    my ($string, $l);\n    my $fh= new \
FileHandle;\n    open ($fh,\"$f\");\n    while (<$\
fh>)\n      {\n\n	$l=$_;\n	$string.=$l;\n      }\n\
    close ($fh);\n    $string=~s/\\r\\n/\\n/g;\n  \
  return $string;\n  }\nsub isfasta\n  {\n    my $\
file=shift;\n    my $fh=new FileHandle;\n    \n   \
 open ($fh, \"$file\");\n    while (<$fh>)\n      \
{\n	my $l=$_;\n	close ($fh);\n	if ($l=~/^>/){retur\
n 1;}\n	return 0;\n      }\n  }\n\n  \n\n\n\nsub f\
ilelist2h\n  {\n    my ($outdir,@list)=@_;\n    my\
 $infile=\"$outdir/fullseq.fa\";\n    my %h;\n    \
my %lu;\n    my $fh=new FileHandle;\n    \n    ope\
n ($fh, \">$infile\");\n    foreach my $f (@list)\\
n      {\n	if (!$QUIET){print \"! Process $f\\n\";\
}\n	my %s=read_fasta_seq($f);\n	$f=abs2file ($f);\\
n\n	$h{$f}{template_dir }=\"$outdir/$f.template_di\
r\";\n	$h{$f}{template_file}{relative}=\"$f.R.temp\
late_file\";\n	$h{$f}{template_file}{absolute}=\"$\
h{$f}{template_dir}/$h{$f}{template_file}{relative\
}\";\n		\n	foreach my $s (keys(%s))\n	  {\n	    my\
 $cname=$s{$s}{cname};\n	    my $name =$s{$s}{ nam\
e};\n	    \n	    my $seq  =$s{$s}{seq};\n	    my $\
com  =$s{$s}{com};\n	    \n	    #clean \n	    $seq\
=~s/\\-//g;\n	    $seq=~s/\\.//g;\n	    \n	    if \
($lu{$s}{seq} && $lu{$s}{seq} ne $seq)\n	      {\n\
		#print \"$lu{$s}{seq} ---> \\n$lu{$s}{source}/$s\
 \\n\";\n		#print \"$seq ---> \\n$f/$s \\n\";\n		\\
n		#die;\n		print \"ERROR: two different sequences\
 where provided for $name: [$seq/$f] and [$lu{$s}{\
seq}/$lu{$s}{source}]$FATAL]\\n\";\n		close (F);\n\
		die;\n	      }\n	    else \n	      {\n		$lu{$s}{\
seq   }=$seq;\n		$lu{$s}{source}=$f;\n		\n		print \
$fh \">$name\\n$seq\\n\";\n	      }\n	    $h{$f}{s\
eq  }{$name}=$seq;\n	    $h{$f}{name }{$name}=$nam\
e;\n	    $h{$f}{cname}{$name}=$cname;\n	    $h{$f}\
{prf}{$name}{relative}=\"$cname.R.prf\";\n	    $h{\
$f}{prf}{$name}{absolute}=\"$tmpdir/$h{$f}{prf}{$n\
ame}{relative}\";\n	    \n	    $h{$f}{tprf}{$name}\
{relative}=\"$cname.R.prf\";\n	    $h{$f}{tprf}{$n\
ame}{absolute}=\"$h{$f}{template_dir}/$h{$f}{tprf}\
{$name}{relative}\";\n	    \n	    $h{$f}{templates\
}.=\">$name _R_ $h{$f}{tprf}{$name}{relative}\\n\"\
;\n	  }\n      }\n    close ($fh);\n    return $in\
file, %h;\n  }\nsub make_output_structure\n  {\n  \
  my ($outdir,%h)=@_;\n    my $fh=new FileHandle;\\
n    mymkdir ($outdir) || die \"Could not create $\
outdir\\n\";\n    \n    foreach my $f (keys (%h))\\
n	{\n	  mymkdir ($h{$f}{template_dir}) or die \"1 \
Could not create $h{$f}{template_dir}\\n\";\n	  op\
en  ($fh, \">$h{$f}{template_file}{absolute}\") or\
 die \"Could not open $h{$f}{template_file}{absolu\
te}\";\n	  print $fh \"$h{$f}{templates}\";\n	  cl\
ose $fh;\n	}\n    return 1;\n  }\nsub is_installed\
\n  {\n    my $p=@_[0];\n    my $r=0;\n    my $cwh\
ich=\"$tmpdir/which\";\n    if (-e $cwhich){unlink\
 (\"$cwhich\");}\n    \n    system (\"which $p >$c\
which 2>/dev/null\");\n    my $w=file2string ($cwh\
ich);\n    if (($w=~/mmseqs/)){$r=1;}\n    return \
$r;\n  }\n\n  \nsub split_mmseqs\n    {\n      my \
($qf,$cacheq,$updateq, $db,$cachedb, $updatedb, $s\
,$out,$split)=@_;\n      \n      my @dbl=splitfast\
a($split,(string2fasta_list($db)));\n      \n\n   \
   if ( -e $out){unlink ($out)}\n\n\n     \n      \
foreach my $d (@dbl)\n	{\n	  my $uid=getuid();\n	 \
 my $lcacheo=\"$tmpdir/$uid/search/\";\n	  my $lca\
chedb=(($d =~/$tmpdir/))?\"$tmpdir/$uid/db/\":$cac\
hedb;\n	  my $lcacheq=$cacheq;\n	  mymkdir ($lcach\
eo, $lcachedb);\n	  \n	  print \"! Process Databas\
e $d\\n\";\n	  \n	  my %db=file2db($d ,$lcachedb,$\
updatedb);\n	  my %q =file2db($qf,$lcacheq ,$updat\
eq );\n	  my $ld=abs2file ($d);\n\n	  if (! -d $lc\
acheo){die \"NO CACHE\";}\n\n	  $q{search }=\"$lca\
cheo/$ld\\.MMSEQSSEARCH\";\n	  $q{convert}=\"$lcac\
heo/$ld\\.MMSEQSCONVERT\";\n	 \n	  system (\"mmseq\
s search $q{db} $db{db} $q{search} $db{index} $s -\
a $QUIET\");\n	  system (\"mmseqs convertalis $q{d\
b} $db{db} $q{search} $q{convert} --format-output \
\\\"query,target,qaln,taln,qstart,qend,pident,qcov\
,qlen\\\" $QUIET\");\n	  system (\"cat $q{convert}\
 >> $out\");\n	  \n	}\n      return $out;\n    }\n\
    \nsub splitfasta \n      {\n	my ($split,@list)\
=@_;\n	my @fl;\n\n		\n	if (!$split){return @list;}\
\n	\n	foreach my $e (@list)\n	  {\n	    \n	    my \
$n=`grep -c \">\" $e`;\n	    \n	    if ($n>$split)\
\n	      {\n		my $uid=getuid();\n		my $odir=\"$tmp\
dir/$uid/\";\n		mymkdir ($odir);\n		system (\"t_co\
ffee -other_pg seq_reformat -action +odir $odir +s\
plit $e $split\");\n		push (@fl,string2list (\"$od\
ir/*.split\"));\n	      }\n	    else\n	      {\n		\
push (@fl, $e);\n	      }\n	  }\n	return @fl;\n   \
   }\nsub getuid\n	{\n	  my $n;\n	  my $l=3;\n	  m\
y $string=randomstring ($l);\n	  while ($R{$string\
})\n	    {\n	      $n++;\n	      \n	      if ($n==\
10){$l++;}\n	      $string=randomstring($l);\n	   \
 }\n	  $R{$string}=1;\n	  return $string;\n	}\n		\\
nsub randomstring\n	  {\n	    my $l=shift;\n	    m\
y @s;\n	    my @alp=split (//, 'abcdefghijklmnopqr\
stuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_');\n\
	    \n	    my $lalp=@alp;\n	  \n	    for ( my $i=\
0; $i<$l; $i++)\n	      {\n		$s[$i]=$alp[rand($lal\
p)];\n	      }\n	    return join ('',@s);\n	  }\n	\
  \n		  \nmy $program=\"T-COFFEE (Version_13.45.58\
.c355d11)\";\n","use Env;\nuse strict;\nuse FileHa\
ndle;\nuse Cwd;\nuse File::Path;\nuse Sys::Hostnam\
e;\nuse File::Temp qw/ tempfile tempdir /;\nmy $QU\
IET=\"2>/dev/null\";\nmy $VERBOSE=$ENV{VERBOSE_4_D\
YNAMIC};\nour $EXIT_FAILURE=1;\nour $EXIT_SUCCESS=\
0;\nour $LAST_COM=\"\";\n\nmy %method;\nmy $method\
2use;\nmy $treeF;\nmy $tree=$ENV{\"child_tree_4_TC\
OFFEE\"};\nmy $thread=$ENV{\"child_thread_4_TCOFFE\
E\"};\nmy $dynamic=$ENV{dynamic_config_4_TCOFFEE};\
\nmy $clean;\nmy $treeFlag;\nmy $blastFlag;\nmy $i\
nfile;\nmy $outfile;\nmy $flush;\nmy $do_exit=0;\n\
my ($h1, $h2);\nmy @tmpL;\nmy $tmpdir = File::Temp\
->newdir();\nmy $stderrF=\"$tmpdir/stderr\";\n$QUI\
ET=\"2>$stderrF\";\nmy $CDIR=getcwd();\nmy $thread\
Flag4tc;\nmy $threadFlag4famsa;\nmy $threadFlag;\n\
my $tcarg;\n\nmy $QUIET_ENV=$ENV{QUIET_ENV};\n\nif\
 ($QUIET_ENV==1){$QUIET=\"\";}\n\nfor ($a=0; $a<=$\
#ARGV; $a++)\n  {\n    if    ($ARGV[$a] eq \"-seq\\
"){$infile=file2abs($ARGV[++$a]);}\n    elsif ($AR\
GV[$a] eq \"-outfile\"){$outfile=file2abs($ARGV[++\
$a], \"new\");}\n    elsif ($ARGV[$a] eq \"-dynami\
c_config\"){\n    	$dynamic=file2abs($ARGV[++$a]);\
\n    	if ($VERBOSE){print \"\\n![dynamic.pl] --- \
-dynamic_config flag if/else--- $dynamic\\n\";}\n	\
}\n    \n    elsif ($ARGV[$a] eq \"-tree\") {$tree\
=$ARGV[++$a];}\n    elsif ($ARGV[$a] eq \"-method\\
") {$method2use=$ARGV[++$a];}\n    elsif ($ARGV[$a\
] eq \"-verbose\"){$VERBOSE=1; $QUIET=\"\";}\n    \
elsif ($ARGV[$a] eq \"-clean\"){$clean=1;}\n  \n  \
  elsif ($ARGV[$a] eq \"-thread\"){$thread=$ARGV[+\
+$a]}\n    elsif ($ARGV[$a] eq \"-tcarg\") {$tcarg\
=file2string($ARGV[++$a]);}\n    else \n      {\n	\
add2tcenv($a++,@ARGV);\n      }\n  }\n\n\n\nif ($t\
ree eq \"list\")\n  {\n    my $f=\"$tmpdir/f\";\n \
   open (F, \">$f\");\n    print F \">a\\nxxx\\n>b\
\\nyyyyy\\n\";\n    close (F);\n    print STDOUT (\
\"**** Supported Guide tree modes:\\n\");\n    my_\
system (\"t_coffee -other_pg seq_reformat -in $f -\
action +seq2dnd list \");\n    $do_exit=1;\n  }\ni\
f ($method2use eq \"list\")\n  {\n    my %ml;\n   \
 my $listfile=\"$tmpdir/list\";\n    \n    $ml{tco\
ffee}=1;\n    $ml{psicoffee}=1;\n    $ml{accurate}\
=1;\n    $ml{'3dcoffee'}=1;\n    $ml{expresso}=1;\\
n    $ml{clustalo}=1;\n    $ml{mafft}=1;\n    $ml{\
famsa}=1;\n      print STDOUT (\"**** Supported MS\
A mode:\\n\");\n    my_system (\"t_coffee 2>/dev/n\
ull | grep _msa > $listfile\");\n    open (F, $lis\
tfile);\n    while (<F>)\n      {\n	my $l=$_;\n	$l\
=~/(.*_msa)\\s+(.*)/;\n	my $m=$1;\n	my $i=\"$2\\n\\
";\n	if ($m=~/mafftsparsescore/)\n	  {\n	   printf\
 STDOUT \"%-20s DOES NOT Support [-tree] -- $i\", \
$m;\n	  }\n	elsif ($m=~/tcoffee/){;}\n	elsif ($m=~\
/mafft/){;}\n	elsif (!$ml{$m})\n	  {\n	    printf \
STDOUT \"%-20s DOES     Support [-tree] -- $i\", $\
m;\n	  }\n      }\n    $do_exit=1;\n  }\nif ($do_e\
xit){my_exit ($CDIR,$EXIT_SUCCESS);}\n\nmy $NSEQ=f\
ile2nseq($infile);\n\n\nif ($NSEQ==0)\n  {\n    pr\
int \"ERROR - No sequences provided [FATAL:dynamic\
.pl]\\n\";\n    exit ($EXIT_FAILURE);\n  }\nif (!$\
outfile)\n  {\n    ($h1,$outfile)=tempfile();\n   \
 push (@tmpL,$outfile);\n    $flush=1;\n  }\n\nif \
(!($method2use=~/dynamic/)){;}\nelse \n  {\n    if\
 (-e $dynamic)\n      {\n       if ($VERBOSE){prin\
t \"\\n![dynamic.pl] --- -dynamic_config FILE: \\n\
\";}\n        my @dynamicFile;\n	open (F, $dynamic\
);\n	while (<F>)\n	  {\n	    my $f=$_;\n	    if ($\
VERBOSE){print \"\\n![dynamic.pl] --- FILE content\
: $f\\n\";}\n	    ## $f=~/(\\W)+ (\\d)+/;\n	    @d\
ynamicFile = split ' ', $f;\n	    if ($VERBOSE){pr\
int \"\\n![dynamic.pl] --- -dynamic_config --- $dy\
namicFile[0] :: $dynamicFile[1]\\n\";}\n	    $meth\
od{$dynamicFile[0]} = $dynamicFile[1];\n	  }\n	clo\
se(F);\n      }\n    else\n      {\n	$method{\"psi\
coffee_msa\"}=50;\n	$method{\"famsa_msa\"}=1000000\
000;\n      }\n    \n    foreach my $name (sort { \
$method{$a} <=> $method{$b} } keys %method) \n    \
  {\n	if ($NSEQ<=$method{$name})\n	  {\n	    $meth\
od2use=$name;\n	    last;\n	  }\n      }\n  }\n\n\\
nif ($tree)\n  {\n    ($h2,$treeF)=tempfile();\n  \
  my ($h2,$tmptree)=tempfile();\n    push (@tmpL,$\
treeF);\n    if ( $tree eq \"default\"){$treeF=0;}\
\n    elsif ( -e $tree)\n      {\n	my_system (\"cp\
 $tree $tmptree\");\n      }\n    elsif ($tree eq \
\"master\" || $tree eq \"main\" || $tree eq \"pare\
nt\")\n      {\n	if ($ENV{CHILD_TREEF_4_TCOFFEE} &\
& -e $ENV{CHILD_TREEF_4_TCOFFEE})\n	  {\n	    my $\
ctree=$ENV{CHILD_TREEF_4_TCOFFEE};\n	    my_system\
 (\"mv $ctree $tmptree\");\n	  }\n	else\n	  {\n	  \
  my $master_tree=$ENV{CHILD_TREE_4_TCOFFEE};\n	  \
  my_system (\"t_coffee -other_pg seq_reformat -in\
 $master_tree -in2 $infile -action +prune_tree -ou\
tput newick > $tmptree\");\n	  }\n      }\n    els\
e \n      {\n	my_system (\"t_coffee -other_pg seq_\
reformat -in $infile -action +seq2dnd $tree -outpu\
t newick> $tmptree\");\n      }\n    \n    if ($me\
thod2use=~/mafft/)\n      {\n	#print \"cp $tmptree\
 /Users/cnotredame/.Trash/$$.tmptree\\n\";\n	#syst\
em (\"cp $tmptree /Users/cnotredame/.Trash/$$.tmpt\
ree\");\n	\n	my_system (\"t_coffee -other_pg seq_r\
eformat -in $tmptree -output mafftdndmatrix> $tree\
F\");\n      }\n    else\n      {\n	my_system (\"m\
v $tmptree $treeF\");\n      }\n  }\nchdir ($tmpdi\
r);\n\nmy $CL4tc=get_cl4tc();#will collect from en\
v every CLTCOFEE env variable\n\nif (!$treeF || $N\
SEQ<=2){$treeFlag=\"\";}\nelsif ( $method2use=~/co\
ffee/ || $method2use=~/accurate/){$treeFlag=\"-use\
tree $treeF \";}\nelsif ( $method2use=~/clustalo/)\
{$treeFlag=\"--guidetree-in=$treeF \";}\nelsif ( $\
method2use=~/mafftsparsecore/){;}\nelsif ( $method\
2use=~/mafft/){$treeFlag=\"--treein $treeF \";}\ne\
lsif ( $method2use=~/famsa/){$treeFlag=\"-gt impor\
t $treeF \";}\n$CL4tc.=\" $treeFlag \";\n\n$thread\
Flag=($thread)?\"--thread $thread \":\"--thread 1 \
\";\n$threadFlag4tc=($thread)?\"-thread $thread \"\
:\"-thread 1 \";\n$threadFlag4famsa=($thread)?\"-t\
 $thread \":\"-t 1 \";\n$CL4tc.=\" $threadFlag4tc \
\";\n\nif ($VERBOSE){print \"\\n![dynamic.pl] --- \
CL4tc == $CL4tc\\n\";}\n\nmy $cmethod=$method2use;\
\n$cmethod=~s/_pair/_msa/;\n$cmethod=~s/_msa//;\n\\
nif ($VERBOSE){print \"\\n![dynamic.pl] --- cmetho\
d == $cmethod\\n\";}\n\nif ($cmethod eq \"tcoffee\\
"|| $cmethod eq \"t_coffee\" )\n  {\n    my_system\
 (\"t_coffee -seq $infile -outfile $outfile -outpu\
t fasta_aln $CL4tc>/dev/null  $QUIET\");    \n  }\\
nelsif ($cmethod=~/(.*coffee)/ || $cmethod=~/(accu\
rate)/ || $cmethod=~/(expresso)/)\n  {\n    my $mo\
de=$1;\n    my_system (\"t_coffee  -mode $mode -se\
q $infile -outfile $outfile -output fasta_aln $CL4\
tc >/dev/null  $QUIET\");    \n  }\nelsif ($cmetho\
d eq \"clustalo\")\n  {\n    my_system (\"clustalo\
 -i $infile $treeFlag -o $outfile  --force $thread\
Flag $QUIET\");\n    }\nelsif ($cmethod =~/sparsec\
ore/)\n  {\n    my_system (\"mafft-sparsecore.rb -\
i $infile > $outfile $QUIET\");\n  }\nelsif (($cme\
thod =~/mafft/))\n  {\n    my $mm;\n    my $retree\
;\n    \n    if ( $cmethod eq \"mafft\" || $cmetho\
d=~/\\-/ )\n      {\n	$mm=$cmethod;\n      }\n    \
elsif (($cmethod=~/mafft(.*)/))\n      {\n	$mm=\"m\
afft-\".$1;\n      }\n\n    if ($mm =~/1/)\n      \
{\n	$mm=~s/1/i/;\n	$retree=\"--retree 1 \"\n      \
};\n    \n    my_system (\"$mm --anysymbol $thread\
Flag $treeFlag $retree $infile > $outfile $QUIET\"\
);\n  }\n\nelsif ($method2use=~/famsa/)\n  {\n    \
print \"\\n![dynamic.pl] --- FAMSA DEFAULT\\n\";  \
  \n    my_system (\"famsa $treeFlag $threadFlag4f\
amsa $infile $outfile >/dev/null $QUIET\");\n  }\n\
elsif ($method2use=~/famsaUpgma/)\n  {\n    print \
\"\\n![dynamic.pl] --- FAMSA Upgma\\n\";\n    prin\
t \"\\n![dynamic.pl] --- Command: famsa -gt upgma \
$treeFlag $threadFlag4famsa $infile $outfile >/dev\
/null $QUIET\\n\";\n    my_system (\"famsa -gt upg\
ma $treeFlag $threadFlag4famsa $infile $outfile >/\
dev/null $QUIET\");\n  }\nelse\n  {\n    if ($tree\
F)\n      {\n	printf (STDERR \"WARNING: Method $me\
thod2use CANNOT use pre-sepecified guide tree [dyn\
amic.pl]\\n\");\n      }\n    my_system (\"t_coffe\
e -in $infile -method $method2use -outfile $outfil\
e -output fasta_aln $tcarg -quiet $QUIET\");\n  }\\
n\nif ( ! -e $outfile)\n  {\n    print \"ERROR - N\
o MSA computed - $LAST_COM -- [FATAL:dynamic.pl]\\\
n\";\n    my_exit ($CDIR,$EXIT_FAILURE);\n  }\nels\
if ( $flush)\n {\n   open (F, $outfile);\n   while\
 (<F>){print $_;}\n   close (F);\n }\nforeach my $\
f (@tmpL){unlink($f);}\n\n\nif ($VERBOSE!=-1)\n  {\
\n    open (F, \"$stderrF\");\n    while (<F>)\n  \
    {\n	my $l=$_;\n	if ( $VERBOSE || $l=~/WARNING/\
 || $l=~/ERROR/ || $l=~/INFORNATION/){print stderr\
 \"$l\";}\n      }\n    close (F);\n  }\n\nmy_exit\
 ($CDIR,$EXIT_SUCCESS);\n\n\nsub file2nseq\n  {\n \
   my ($f)=@_;\n    my $n=`grep -c '>' $f`; \n    \
\n    return $n;\n  }\nsub file2abs\n    {\n      \
my ($f, $mode)=@_;\n      \n      if (!$f || $f=~/\
^\\//){return $f;}\n      elsif (!-e $f && $mode e\
q \"new\"){return \"$CDIR/$f\";}\n      elsif (!-e\
 $f){return $f;}\n    \n      return \"$CDIR/$f\";\
\n    }\nsub file2string \n    {\n      my ($f)=@_\
;\n      my $s;\n\n      open (F, $f) || return 0;\
\n      while (<F>)\n	{\n	  $s.=$_;\n	}\n      clo\
se (F);\n      chomp($s);\n      return $s;\n    }\
   \n\nsub get_psicl\n      {\n	my ($psitrim, $psi\
trim_mode, $pisN);\n	my $cl;\n	\n	if ($ENV{psitrim\
_tree_4_TCOFFEE}){$cl.=\" -psitrim_tree=\".$ENV{ps\
itrim_tree_4_TCOFFEE}.\" \";}\n	if ($ENV{psitrim_m\
ode_4_TCOFFEE}){$cl.=\" -psitrim_mode=\".$ENV{psit\
rim_mode_4_TCOFFEE}.\" \";}\n	if ($ENV{psitrim_4_T\
COFFEE}){$cl.=\" -psitrim=\".$ENV{psitrim_4_TCOFFE\
E}.\" \";}\n	if ($ENV{psiJ_4_TCOFFEE}){$cl.=\" -ps\
iJ=\".$ENV{psiJ_4_TCOFFEE}.\" \";}\n	\n\n	return $\
cl;\n      }\n      \nsub get_cl4tc\n	{\n	  my $cl\
;\n	  \n	  foreach my $arg (keys(%ENV))\n	    {\n	\
      if ($arg=~/(.*)_4_CLTCOFFEE/)\n		{\n		  my $\
name=$1;\n		  my $val=$ENV{$arg};\n		  if (-e $val\
){$val=file2abs($val);}\n		  \n\n		  if ($val eq \\
"FLAGSET\"){$val=\"\";}\n		  $cl.=\"-$name $val \"\
;\n		}\n	    }\n	  if ($VERBOSE){print \"\\n![dyna\
mic.pl] --- get_psicl --- $cl\\n\";}\n	  return $c\
l;\n	}\n\nsub add2tcenv\n	    {\n	      my ($p, @a\
rgv)=@_;\n\n	      my $flag=$argv[$p];\n	      $fl\
ag =~s/^-//;\n	      my $val =file2abs($argv[$p+1]\
);\n	      my $envv=\"$flag\\_4_CLTCOFFEE\";\n	   \
   $ENV{$envv}=$val;\n	    }\n	      \nsub my_exit\
\n    {\n      my ($dir,$ec)=@_;\n      my $a;\n  \
    if ($VERBOSE)\n	{\n	  print \"\\n![dynamic.pl]\
 --- CDIR: $CDIR\\n\";\n	  print \"\\n![dynamic.pl\
] --- Processed $NSEQ\\n\";\n	  print \"\\n![dynam\
ic.pl] --- \";\n	  foreach my $arg (@ARGV)\n	    {\
\n	      print \"$arg \";\n	    }\n	  \n	  print \\
"\\n![dynamic.pl] --- EXIT: $ec ($EXIT_SUCCESS:suc\
cess, $EXIT_FAILURE:failure)-- Verbose mode -- uns\
et VERBOSE_4_DYNAMIC to turn verbose mode off\\n\"\
;\n	}\n      chdir ($dir);\n      exit ($ec);\n   \
 }\n	      \nsub my_system \n  {\n    my ($com)=@_\
;\n    $LAST_COM=$com;\n    \n    if ($VERBOSE){pr\
int \"\\n![dynamic.pl] --- SysCall --- $com\\n\";}\
\n    \n    system ($com);\n  }\nmy $program=\"T-C\
OFFEE (Version_13.45.58.c355d11)\";\n","use Env;\n\
use FileHandle;\nuse Cwd;\nuse File::Path;\nuse Sy\
s::Hostname;\nmy $f = new FileHandle;\n\nopen ($f,\
 $ARGV[1]);\n$atom=$ARGV[0];\n\n$atom=~s/PRIME/\\'\
/;\nwhile (<$f>)\n  {\n    my $l=$_;\n\n    $l=~s/\
$atom/CA /;\n    \n    \n    $l=~s/  G /GLY /g;\n \
   $l=~s/  C /CYS /g;\n    $l=~s/  T /THR /g;\n   \
 $l=~s/  A /ALA /g;\n    $l=~s/  U /THR /g;\n    \\
n    $l=~s/ DG /GLY /g;\n    $l=~s/ DC /CYS /g;\n \
   $l=~s/ DT /THR /g;\n    $l=~s/ DA /ALA /g;\n   \
 $l=~s/ DU /THR /g;\n    \n    print $l;\n  }\n\n\\
n\n","*TC_METHOD_FORMAT_01\n******************gene\
ric_method.tc_method*************\n*\n*       Inco\
rporating new methods in T-Coffee\n*       Cedric \
Notredame 26/08/08\n*\n***************************\
****************************\n*This file is a meth\
od file\n*Copy it and adapt it to your need so tha\
t the method \n*you want to use can be incorporate\
d within T-Coffee\n*******************************\
************************\n*                  USAGE\
                              *\n*****************\
**************************************\n*This file\
 is passed to t_coffee via -in:\n*\n*	t_coffee -in\
 Mgeneric_method.method\n*\n*	The method is passed\
 to the shell using the following\n*call:\n*<EXECU\
TABLE><PARAM1><IN_FLAG><seq_file><PARAM2><OUT_FLAG\
><outname><PARAM>\n*\n*Conventions:\n*<FLAG_NAME> \
	<TYPE>		<VALUE>\n*<VALUE>:	no_name 	<=> Replaced \
with a space\n*<VALUE>:	&nbsp	<=> Replaced with a \
space\n*\n****************************************\
***************\n*                  ALN_MODE      \
                     *\n**************************\
*****************************\n*pairwise   ->all V\
s all (no self )[(n2-n)/2aln]\n*m_pairwise ->all V\
s all (no self)[n^2-n]^2\n*s_pairwise ->all Vs all\
 (self): [n^2-n]/2 + n\n*multiple   ->All the sequ\
ences in one go\n*\nALN_MODE		pairwise\n*\n*******\
************************************************\n\
*                  OUT_MODE                       \
    *\n*******************************************\
************\n* mode for the output:\n*External me\
thods: \n* aln -> alignmnent File (Fasta or Clusta\
lW Format)\n* lib-> Lib file (TC_LIB_FORMAT_01)\n*\
Internal Methods:\n* fL -> Internal Function retur\
ning a List (Librairie)\n* fA -> Internal Function\
 returning an Alignmnent\n*\nOUT_MODE		aln\n******\
*************************************************\\
n*                  SEQ_TYPE                      \
     *\n******************************************\
*************\n*G: Genomic, S: Sequence, P: PDB, R\
: Profile\n*Examples:\n*SEQTYPE	S	sequences agains\
t sequences (default)\n*SEQTYPE	S_P	sequence again\
st structure\n*SEQTYPE	P_P	structure against struc\
ture\n*SEQTYPE	PS	mix of sequences and structure	\\
n*\nSEQ_TYPE	S\n*\n\n*****************************\
**************************\n*                COMMA\
ND LINE                         *\n*EXECUTABLE PAR\
AM1 IN_FLAG OUT_FLAG PARAM             *\n********\
***********************************************\n*\
**************************************************\
****\n*                  EXECUTABLE               \
          *\n*************************************\
******************\n*name of the executable\n*pass\
ed to the shell: executable\n*	\nEXECUTABLE	tc_gen\
eric_method.pl\n*\n*******************************\
************************\n*                  IN_FL\
AG                             *\n****************\
***************************************\n*IN_FLAG\\
n*flag indicating the name of the in coming sequen\
ces\n*IN_FLAG S no_name ->no flag\n*IN_FLAG S &bns\
p-in&bnsp -> \" -in \"\n*\nIN_FLAG		-infile=\n*\n*\
**************************************************\
****\n*                  OUT_FLAG                 \
          *\n*************************************\
******************\n*OUT_FLAG\n*flag indicating th\
e name of the out-coming data\n*same conventions a\
s IN_FLAG\n*OUT_FLAG	S no_name ->no flag\n*if you \
want to redirect, pass the parameters via PARAM1\n\
*set OUT_FLAG to >\n*\nOUT_FLAG		-outfile=\n*\n***\
**************************************************\
**\n*                  PARAM_1                    \
          *\n*************************************\
******************\n*<EXECUTABLE><PARAM1><IN_FLAG>\
<seq_file><PARAM2><OUT_FLAG><outname><PARAM>\n*Par\
ameters sent to the EXECUTABLE and specified *befo\
re* IN_FLAG \n*If there is more than 1 PARAM line,\
 the lines are\n*concatenated\n*Command_line: @EP@\
PARAM@-gapopen%e10%s-gapext%e20\n*	%s white space\\
n*	%e equal sign\n*\n*PARAM1	\n*\n*\n*\n**********\
*********************************************\n*  \
                PARAM_2                           \
   *\n********************************************\
***********\n*<EXECUTABLE><PARAM1><IN_FLAG><seq_fi\
le><PARAM2><OUT_FLAG><outname><PARAM>\n*Parameters\
 sent to the EXECUTABLE and specified \n*after* IN\
_FLAG and *before* OUT_FLAG\n*If there is more tha\
n 1 PARAM line, the lines are\n*concatenated\n*\n*\
PARAM1	\n*\n*\n***********************************\
********************\n*                  PARAM    \
                          *\n*********************\
**********************************\n*<EXECUTABLE><\
PARAM1><IN_FLAG><seq_file><PARAM2><OUT_FLAG><outna\
me><PARAM>\n*Parameters sent to the EXECUTABLE and\
 specified *after* OUT_FLAG\n*If there is more tha\
n 1 PARAM line, the lines are\n*concatenated\n*\nP\
ARAM	-mode=seq_msa -method=clustalw2\nPARAM   -OUT\
ORDER=INPUT -NEWTREE=core -align -gapopen=-15\n*\n\
**************************************************\
*****\n*                  END                     \
           *\n************************************\
*******************\n","*TC_METHOD_FORMAT_01\n****\
***********clustalw_method.tc_method*********\nEXE\
CUTABLE	clustalw\nALN_MODE		pairwise\nIN_FLAG		-IN\
FILE=\nOUT_FLAG		-OUTFILE=\nOUT_MODE		aln\nPARAM		\
-gapopen=-10\nSEQ_TYPE		S\n***********************\
**************************\n","$VersionTag =      \
                                                  \
                                                  \
                         2.43;\nuse Env;\nuse File\
Handle;\nuse Cwd;\nuse File::Path;\nuse Sys::Hostn\
ame;\n\nour $PIDCHILD;\nour $ERROR_DONE;\nour @TMP\
FILE_LIST;\nour $EXIT_FAILURE=1;\nour $EXIT_SUCCES\
S=0;\n\nour $REFDIR=getcwd;\nour $EXIT_SUCCESS=0;\\
nour $EXIT_FAILURE=1;\n\nour $PROGRAM=\"extract_fr\
om_pdb\";\nour $CL=$PROGRAM;\n\nour $CLEAN_EXIT_ST\
ARTED;\nour $debug_lock=$ENV{\"DEBUG_LOCK\"};\nour\
 $LOCKDIR=$ENV{\"LOCKDIR_4_TCOFFEE\"};\nif (!$LOCK\
DIR){$LOCKDIR=getcwd();}\nour $ERRORDIR=$ENV{\"ERR\
ORDIR_4_TCOFFEE\"};\nour $ERRORFILE=$ENV{\"ERRORFI\
LE_4_TCOFFEE\"};\n&set_lock ($$);\nif (isshellpid(\
getppid())){lock4tc(getppid(), \"LLOCK\", \"LSET\"\
, \"$$\\n\");}\n      \nour $SILENT=\" >/dev/null \
2>/dev/null\";\nour $INTERNET=-1;\n\n\n\n\n\n\n\no\
ur $BLAST_MAX_NRUNS=2;\nour $EXIT_SUCCESS=0;\nour \
$EXIT_FAILURE=1;\nour $CONFIGURATION=-1;\nour $REF\
_EMAIL=\"\";\nour $PROGRAM=\"extract_from_pdb\";\n\
\n\nmy %onelett_prot=&fill_onelett_prot();\nmy %th\
reelett_prot=&fill_threelett_prot();\nmy %onelett_\
RNA=&fill_onelett_RNA();\nmy %threelett_RNA=&fill_\
threelett_RNA();\nmy %onelett_DNA=&fill_onelett_DN\
A();\nmy %threelett_DNA=&fill_threelett_DNA();\n\n\
\n\n\n\nmy %onelett = (\n'P' => \\%onelett_prot,\n\
'D' => \\%onelett_DNA,\n'R' => \\%onelett_RNA\n);\\
n\n\nmy %threelett = (\n'P' => \\%threelett_prot,\\
n'D' => \\%threelett_DNA,\n'R' => \\%threelett_RNA\
\n);\n\n\n\n\n\n\n\nif($ARGV[0]=~/help/ ||$ARGV[0]\
=~/man/ || $ARGV[0]=~/HELP/ || $ARGV[0]=~/Man/ || \
$ARGV[0] eq \"-h\"  || $ARGV[0] eq \"-H\"  )\n{die\
 \"SYNTAX: extract_from_pdb Version $VersionTag	\n\
	Minimum:             [extract_from_pdb file] \n		\
	   OR \n			     [... | extract_from_pdb]\n 	Flags\
 (Default setting on the first line)\n	   -version\
...................[Returns the Version Number]\n \
          -force.....................[Forces the f\
ile to be treated like a PDB file]\n              \
                        [Regenerates the header an\
d SEQRES fields]\n           -force_name..........\
......[Forces the file to be named after name]]\n \
          -infile.....file...........[Flag can be \
omited]\n			              [File must be pdb or fro\
 pgm]\n                                      [File\
 can also be compressed Z or gz]\n                \
                      [In the case of a compressed\
 file, you can omit the gz|Z extension]\n         \
  -netfile...................[File will be fetch f\
rom the net using wget]\n                         \
             [wget or curl must be installed]\n   \
                                   [ftp://ftp.gnu.\
org/pub/gnu/wget/]\n                              \
        [http://curl.haxx.se/]\n                  \
                    [Must also be used to retrieve\
 the file from a local pdb copy (cf netaddress)]\n\
           -netaddress................[Address use\
d for the retrieving the netfile]\n               \
                       [http://www.rcsb.org/pdb/cg\
i/export.cgi/%%.pdb.gz?format=PDB&pdbId=%%&compres\
sion=gz]\n                                      [h\
ttp://www.expasy.ch/cgi-bin/get-pdb-entry.pl?%%]\n\
                                      [local -> wi\
ll get the file from pdb_dir (see pdb_dir)]\n     \
      -netcompression............[Extension if the\
 netfile comes compressed]\n                      \
                [gz]\n           -pdb_dir.........\
..........[address of the repertory where the pdb \
is installed]\n                                   \
   [Supports standard ftp style installation OR ev\
ery stru in DIR]\n                                \
      [Give the ..../pdb/structure/ dir]\n        \
                              [If value omitted, t\
he pg gets it from the env variable PDB_DIR]\n    \
       -netcompression_pg.........[gunzip]\n      \
     -is_pdb_name..........name.[Returns 1 if the \
name is a PDB ID, 0 otherwise]\n           -model_\
type...........name.[Returns the model type if val\
id PDB name]\n           -is_released_pdb_name nam\
e.[Returns 1 if the name corresponds to a released\
 PDB file]\n           -get_pdb_chains.....name...\
[Returns the list of chains corresponding to the e\
ntry]\n           -get_pdb_id.........name...[Retu\
rns the PDB id within the provided pdb file]\n    \
       -get_fugue_name.....name...[Turns a name in\
to a name valid for fugue]\n                      \
                [Uses the netaddress to do so]\n	 \
  -chain......FIRST..........[Extract the first ch\
ain only]\n		       A B C..........[Extract Severa\
l chains if needed]\n		       ALL............[Extr\
act all the chains]	\n           -ligand.....ALL..\
..........[Extract the ligands in the chain (HETAT\
M)]\n                       <name1>,<name2>[Extrac\
t All the named lignds]\n	   -ligand_only.........\
......[Extract only the ligands]\n           -liga\
nd_list...............[Extract the list of ligands\
]\n	   -coor.......<start>..<end>.[Coordinates of \
the fragment to extract]\n			              [Omit e\
nd to include the Cter]\n           -num........ab\
solute.......[absolute: relative to the seq] \n   \
                    file...........[file: relative\
 to file]\n           -num_out....new............[\
new: start 1->L]\n                       old......\
......[old: keep the file coordinates]\n          \
 -delete.....<start>..<end>.[Delete from residue s\
tart to residue end]\n	   -atom.......CA..........\
...[Atoms to include, ALL for all of them]\n		    \
   CA O N.........[Indicate several atoms if neede\
d]\n	   -code.......3..............[Use the 1 lett\
er code or the 3 letters code]\n	   -mode.......ra\
w............[Output original pdb file]\n         \
              pdb............[Output something tha\
t looks like pdb]\n		       fasta..........[Output\
 the sequences in fasta format]\n		       simple..\
.......[Output a format easy to parse in C ]\n    \
        -seq_field..ATOM...........[Field used to \
extract the sequence]\n		       SEQRES.........[Us\
e the complete sequence]\n	   -seq................\
.......[Equivalent to  -mode fasta]\n	   -model...\
...1..............[Chosen Model in an NMR file]\n \
          -nodiagnostic..............[Switches Err\
or Messages off]\n           -debug...............\
......[Sets the DEBUG ON]\n           -no_remote_p\
db_dir.........[Do not look for a remote file]\n  \
         -cache_pdb.................[Cache Value, \
default is $HOME/.t_coffee/cache, other values: NO\
<=> No cache]\n\n      Environement Variables\n   \
        These variables can be set from the enviro\
nement\n           Command line values with the co\
rresponding flag superseed evironement value\n    \
       NO_REMOTE_PDB_DIR..........[Prevents the pr\
ogram from searching remote file: faster]\n       \
    PDB_DIR....................[Indicates where PD\
B file must be fetched (localy)]\n\n	 PROBLEMS: pl\
ease contact cedric.notredame\\@europe.com\\n\";\n\
	 exit ($EXIT_SUCCESS);\n}\n\n$np=0;\n$n_para=$#AR\
GV;\n$model=1;\n$pdb_dir=$ENV{'PDB_DIR'};if ($pdb_\
dir){$pdb_dir.=\"/\";}\n$debug=$ENV{'DEBUG_EXTRACT\
_FROM_PDB'};\n\n$no_remote_pdb_dir=$ENV{NO_REMOTE_\
PDB_DIR};\n$HOME=$ENV{'HOME'};\nif ( $ENV{CACHE_4_\
TCOFFEE})\n{$cache=$ENV{CACHE_4_TCOFFEE};}\nelse\n\
{\n    $cache=\"$HOME/.t_coffee/cache/\";\n}\n\n  \
 \n$netaddress=\"https://files.rcsb.org/download/%\
%.pdb.gz\";\n$netcompression_pg=\"gunzip\";\n$netc\
ompression=\"gz\";\n\nforeach ($np=0; $np<=$n_para\
; $np++)\n  {        \n    $value=$ARGV[$np];\n   \
\n    if  ($np==0 && !($value=~/^-.*/))\n      { \\
n	$pdb_file= $ARGV[$np];\n      }\n    elsif ( !($\
value=~/^-.*/))\n      {\n	print \"@ARGV\";\n	die;\
\n      } \n    \n    elsif ($value eq \"-nodiagno\
stic\"){$nodiagnostic=1;}\n    elsif ($value eq \"\
-force\")\n      {\n	$force_pdb=1;\n      }\n    e\
lsif ($value eq \"-force_name\")\n      {\n	$force\
_name=$ARGV[++$np];\n	$force_pdb=1;\n      }\n    \
\n    elsif ($value eq \"-is_pdb_name\")\n      {\\
n	$pdb_file= $ARGV[++$np];	\n	$is_pdb_name=1;	\n  \
    } \n    elsif ($value eq \"-is_released_pdb_na\
me\")\n      {\n	$pdb_file= $ARGV[++$np];\n	\n	if \
(!$pdb_file){print \"0\";exit (EXIT_SUCCESS);}\n	$\
is_released_pdb_name=1;\n      }\n    elsif ($valu\
e eq \"-model_type\")\n      {\n	$pdb_file= $ARGV[\
++$np];	\n	$model_type=1;\n      }\n    elsif ($va\
lue eq \"-debug\")\n{\n	$debug=1;\n}\n    elsif ($\
value eq \"-get_pdb_chains\")\n{\n	$pdb_file= $ARG\
V[++$np];\n	$get_pdb_chains=1;\n}\n    elsif ($val\
ue eq \"-get_pdb_ligands\")\n{\n	$get_pdb_ligands=\
1;\n}\n    \n    elsif ($value eq \"-get_pdb_id\")\
\n{\n	$pdb_file= $ARGV[++$np];\n	$get_pdb_id=1;\n	\
\n}\n    \n    elsif ( $value eq \"-get_fugue_name\
\")\n{\n	$pdb_file= $ARGV[++$np];\n	$get_fugue_nam\
e=1;\n}\n    elsif ( $value eq \"-infile\")\n{\n  \
     $pdb_file= $ARGV[++$np];\n} \n    elsif ($val\
ue eq \"-netfile\")\n{\n	$netfile=1;\n	if ( !($ARG\
V[$np+1]=~/^-.*/)){$pdb_file= $ARGV[++$np];}\n}\n \
   elsif (  $value eq \"-num\")\n{\n       $number\
ing= $ARGV[++$np];\n}\n    elsif (  $value eq \"-n\
um_out\")\n{\n       $numbering_out= $ARGV[++$np];\
\n}\n    elsif ( $value eq \"-netaddress\")\n{\n	$\
netadress=$ARGV[++$np];\n}\n     \n    elsif ( $va\
lue eq \"-netcompression\")\n{\n	 $netcompression=\
$ARGV[++$np];\n}\n    elsif ( $value eq \"-pdb_dir\
\")\n{\n	 if ( !($ARGV[$np+1]=~/^-.*/)){$pdb_dir= \
\"$ARGV[++$np]/\";}\n}\n     elsif ( $value eq \"-\
no_remote_pdb_dir\")\n{\n	$no_remote_pdb_dir=1;\n	\
if ( !($ARGV[$np+1]=~/^-.*/)){$pdb_dir= \"$ARGV[++\
$np]/\";}\n}\n    elsif ( $value eq \"-cache\")\n{\
\n	$cache=$ARGV[++$np];\n}\n    \n    elsif ($valu\
e eq \"-netcompression_pg\")\n{\n	  $netcompressio\
n_pg=$ARGV[++$np];\n}\n     elsif ($value eq \"-mo\
de\")\n{\n       $MODE=$ARGV[++$np];\n}\n\n    els\
if ( $value eq \"-model\")\n{\n       $model= $ARG\
V[++$np];\n}\n    elsif ($value eq \"-seq_field\" \
)\n{\n       $seq_field= $ARGV[++$np];\n}   \n    \
elsif ($value eq \"-coor\" )\n{\n       $start= $A\
RGV[++$np];\n  \n       if (($ARGV[$np+1] eq \"\")\
 ||($ARGV[$np+1]=~/^-.*/)){$end=\"*\";} \n       e\
lse {$end=   $ARGV[++$np];}     \n       $coor_set\
=1;\n}\n    elsif ($value eq \"-delete\" )\n{\n   \
    $delete_start= $ARGV[++$np];\n       $delete_e\
nd= $ARGV[++$np];\n       $delete_set=1;\n}\n    e\
lsif  ($value eq \"-code\")\n{\n       $code= $ARG\
V[++$np];\n}\n    elsif  ($value eq \"-no_hetatm\"\
)\n{\n       $no_hetatm=1;\n}\n    elsif ($value e\
q \"-chain\")\n{\n       while (!($ARGV[$np+1] eq \
\"\") &&!($ARGV[$np+1]=~/^-.*/))\n{\n	      ++$np;\
\n	      @c_chain=(@chain,  $ARGV[$np]);\n	      $\
hc_chain{$ARGV[$np]}=$#c_chain+1;\n}           \n}\
\n    elsif ($value eq \"-atom\")\n{\n\n       whi\
le (!($ARGV[$np+1] eq \"\") && !($ARGV[$np+1]=~/^-\
.*/))\n{\n	      ++$np;\n	      $atom[$n_atom++]= \
 $ARGV[$np];\n	      $atom_list{$ARGV[$np]}=1;	   \
   \n} \n       \n}\n    elsif ( $value eq \"-unfo\
ld\")\n{\n	$unfold=1;\n}\n    elsif ($value eq \"-\
seq\" ||$value eq \"-fasta\" )\n{\n       $MODE=\"\
fasta\";\n}\n    elsif ( $value eq \"-version\")\n\
{\n	print STDERR  \"\\nextract_from_pdb: Version $\
VersionTag\\n\";\n	&myexit ($EXIT_SUCCESS);\n}\n  \
  elsif ( $value eq \"-ligand\")\n{\n	while (!($AR\
GV[$np+1] eq \"\") && !($ARGV[$np+1]=~/^-.*/))\n{\\
n	    ++$np;\n	    $ligand=1;\n	    $ligand_list{$\
ARGV[$np]}=1;	      \n} \n	$hc_chain{'LIGAND'}=1;\\
n}\n    elsif ( $value eq \"-ligand_only\")\n{\n	$\
ligand_only=1;\n}\n}\nif ( $debug)\n{\n    print S\
TDERR \"\\n[DEBUG:extract_from_pdb] NO_REMOTE_PDB_\
DIR: $no_remote_pdb_dir\\n\";\n    print STDERR \"\
\\n[DEBUG:extract_from_pdb] PDB_DIR: $pdb_dir\\n\"\
;\n}\n\n\nif ( $is_pdb_name)\n  {\n    if (&remote\
_is_pdb_name($pdb_file))\n      {\n	print \"1\";\n\
      }\n    else\n      {\n	print \"0\";\n      }\
\n    exit ($EXIT_SUCCESS);\n  }\n\nif ( $is_relea\
sed_pdb_name)\n  {\n    \n    if (&is_released($pd\
b_file))\n      {\n	print \"1\";\n      }\n    els\
e\n      {\n	print \"0\";\n      }\n    exit ($EXI\
T_SUCCESS);\n  }\nif ($model_type)\n  {\n   \n    \
printf \"%s\", &pdb2model_type($pdb_file);\n    ex\
it ($EXIT_SUCCESS);\n    \n  }\n    \n\nif (!$forc\
e_name)\n{\n    $pdb_file=~/([^\\/]*)$/;\n    $for\
ce_name=$1;\n}\n\n$local_pdb_file=$pdb_file;\n\nif\
 ( $debug){print STDERR \"\\n[DEBUG: extract_from_\
pdb] Scan For $local_pdb_file\\n\";}\n\n$mem=$no_r\
emote_pdb_dir;\n$no_remote_pdb_dir=1;\n$tmp_pdb_fi\
le=get_pdb_file ($local_pdb_file);\n\nif ( !-e $tm\
p_pdb_file || $tmp_pdb_file eq \"\")\n  {\n    $lo\
cal_pdb_file=$pdb_file;\n    ($local_pdb_file, $su\
ffix_chain)=&pdb_name2name_and_chain($local_pdb_fi\
le);\n\n    if ($local_pdb_file)\n      {\n	if ( $\
debug){print STDERR \"\\nSplit $pdb_file into $loc\
al_pdb_file and $suffix_chain \\n\";}\n	$tmp_pdb_f\
ile=get_pdb_file ($local_pdb_file);\n	if ( $tmp_pd\
b_file ne \"\")\n	  {\n	    @c_chain=();\n	    @c_\
chain=($suffix_chain);\n	    %hc_chain=();\n	    $\
hc_chain{$suffix_chain}=1;\n	  }\n      }\n  }\n\n\
$no_remote_pdb_dir=$mem;\nif ($no_remote_pdb_dir==\
0)\n  {\n    \n    if ( !-e $tmp_pdb_file || $tmp_\
pdb_file eq \"\")\n      {\n	\n	$local_pdb_file=$p\
db_file;\n	($local_pdb_file, $suffix_chain)=&pdb_n\
ame2name_and_chain($local_pdb_file);\n	if ($local_\
pdb_file)\n	  {\n	    \n	    if ( $debug){print ST\
DERR \"\\nSplit $pdb_file into $local_pdb_file and\
 $suffix_chain \\n\";}\n	    \n	    $tmp_pdb_file=\
get_pdb_file ($local_pdb_file);    \n	    \n	    i\
f ( $tmp_pdb_file ne \"\")\n	      {\n		@c_chain=(\
);\n		@c_chain=($suffix_chain);\n		%hc_chain=();\n\
		$hc_chain{$suffix_chain}=1;\n	      }\n	  }\n   \
   }\n  }\n\nif ( $debug){print STDERR \"\\n$pdb_f\
ile copied into ##$tmp_pdb_file##\\n\";}\n\nif ( !\
-e $tmp_pdb_file || $tmp_pdb_file eq \"\")\n{\n	if\
 ($is_pdb_name)\n{\n	    print \"0\\n\"; exit ($EX\
IT_SUCCESS);\n}\n	else\n{\n  \n	    print \"\\nEXT\
RACT_FROM_PDB: NO RESULT for $pdb_file\\n\";\n	   \
 &myexit ($EXIT_SUCCESS);	\n}\n}\n\n\n\n\n%molecul\
e_type=&pdbfile2chaintype($tmp_pdb_file);\nif ( $d\
ebug){print STDERR \"\\n\\tSequence Type determine\
d\\n\";}\n\n$pdb_id=&get_pdb_id ($tmp_pdb_file);\n\
if ( $debug){print STDERR \"\\n\\tID: $pdb_id (for\
 $tmp_pdb_file)\\n\";}\n\nif ( $pdb_id eq \"\"){$p\
db_id=$force_name;}\n\n@f_chain=&get_chain_list ($\
tmp_pdb_file);\nif ( $debug){print STDERR \"\\n\\t\
Chain_list:@f_chain\\n\";}\n\nif ( $get_pdb_chains\
)\n{\n    print \"@f_chain\\n\";\n    &myexit ($EX\
IT_SUCCESS);\n}\nif ( $get_pdb_ligands)\n{\n    %c\
omplete_ligand_list=&get_ligand_list ($tmp_pdb_fil\
e);\n    print $complete_ligand_list{\"result\"};\\
n    &myexit ($EXIT_SUCCESS);\n}\n\nelsif ( $get_p\
db_id ||$get_fugue_name )\n{\n    if    (@c_chain \
&& $c_chain[0] eq \"FIRST\"){$pdb_id=$pdb_id.$f_ch\
ain[0];}\n    elsif (@c_chain && $c_chain[0] ne \"\
 \"){$pdb_id=$pdb_id.$c_chain[0];}\n    \n    prin\
t \"$pdb_id\\n\";\n    &myexit ($EXIT_SUCCESS);\n \
   \n}\nelsif ( $is_pdb_name)\n{\n    printf \"1\\\
n\";\n    &myexit ($EXIT_SUCCESS);\n}\n\n\n\n$stru\
cture_file=vtmpnam();\n\nif ( $debug){print STDERR\
 \"\\n\\tCheck_point #1: $tmp_pdb_file  $structure\
_file\\n\";}\n\n$INFILE=vfopen (\"$tmp_pdb_file\",\
 \"r\"); \nmy $TMP=vfopen (\"$structure_file\", \"\
w\");\n\n$print_model=1;\n$in_model=0;\n\nif ( $de\
bug){print STDERR \"\\n\\tCheck_point #2\\n\";}\nw\
hile ( <$INFILE>)\n{\n  my $first_model=0;\n  $lin\
e=$_;\n\n  if ( !$first_model && ($line =~/^MODEL\\
\s*(\\d*)/))\n    {\n      $first_model=$1;\n     \
 if ($model==1){$model=$first_model;}\n    }\n  \n\
  if (($line =~/^MODEL\\s*(\\d*)/))\n    {\n      \
if ($1==$model)\n	{\n	  $in_model=1;\n	  $print_mo\
del=1;\n	  $is_nmr=1;\n	}\n      elsif ( $in_model\
==0)\n	{\n	  $print_model=0;\n	}\n      elsif ( $i\
n_model==1)\n	{\n	  last;\n	}\n    }\n  if ($print\
_model){print $TMP $line;}  \n}\nclose ($TMP);\ncl\
ose ($INFILE);\n\nif ( $debug){print STDERR \"\\n\\
\tCheck_point #3\\n\";}	\n\n  if ($numbering eq \"\
\"){$numbering=\"absolute\";}\n  if ($numbering_ou\
t eq \"\"){$numbering_out=\"new\";}\n\n  if ( $del\
ete_set && $coor_set) {die \"-delete and -coor are\
 mutually exclusive, sorry\\n\";}\n  if ( $n_atom=\
=0){$atom_list[$n_atom++]=\"ALL\";$atom_list{$atom\
_list[0]}=1;}\n  if ( $seq_field eq \"\"){$seq_fie\
ld=\"ATOM\";}\n  \n  if ( $MODE eq \"\"){$MODE=\"p\
db\";}\n  elsif ( $MODE eq \"simple\" && $code==0)\
{$code=1;}\n\n  if ( $code==0){$code=3;}\n\n\nif (\
$f_chain[0] eq \" \"){$hc_chain{' '}=1;$c_chain[0]\
=\" \";}\nelsif (!@c_chain){$hc_chain{FIRST}=1;$c_\
chain[0]=\"FIRST\";}#make sure the first chain is \
taken by default\n\nif    ($hc_chain{ALL}) \n{\n  \
    @c_chain=@f_chain;\n      foreach $e (@c_chain\
){$hc_chain{$e}=1;}\n}\nelsif($hc_chain{FIRST})\n{\
\n	@c_chain=($f_chain[0]);\n	$hc_chain{$f_chain[0]\
}=1;\n}\n\n\n$MAIN_HOM_CODE=&get_main_hom_code ($s\
tructure_file);\n$INFILE=vfopen ($structure_file, \
\"r\");\n\n\nif ( $MODE eq \"raw_pdb\" || $MODE eq\
 \"raw\")\n{\n    while (<$INFILE>)\n{	print \"$_\\
";}\n    close ( $INFILE);\n    &myexit($EXIT_SUCC\
ESS);\n}    \nif ( $MODE eq \"raw4fugue\" )\n{\n  \
  while (<$INFILE>)\n{	\n	$l=$_;\n	if ($l=~/^SEQRE\
S/)\n{\n	    \n	    $c= substr($l,11,1);\n	    if \
($hc_chain {$c}){print \"$l\";}\n}\n	elsif ( $l=~/\
^ATOM/)\n{\n	    $c=substr($l,21,1);\n	    if ($hc\
_chain {$c}){print \"$l\";}\n}\n}\n    close ( $IN\
FILE);\n    &myexit($EXIT_SUCCESS);\n}    \n\nif (\
 $MODE eq \"pdb\")\n{\n\n    $read_header=0;\n    \
while (<$INFILE>) \n{\n	    $line=$_;\n	    if    \
($line =~ /^HEADER/){print \"$line\";$read_header=\
1;}\n}\n    close ($INFILE);\n\n    if (!$read_hea\
der)\n{\n	print \"HEADER    UNKNOWN               \
                  00-JAN-00   $force_name\\n\";\n}\
\n\n    $INFILE=vfopen ($structure_file, \"r\");\n\
    \n    print \"COMPND   1 CHAIN:\";\n    $last=\
pop(@c_chain);\n    foreach $c ( @c_chain){ print \
\" $c,\";}\n    if ( $last eq \" \"){print \" NULL\
;\\n\";}\n    else \n{\n      print \" $last;\\n\"\
;\n}\n    @c_chain=(@c_chain, $last);\n    \n    p\
rint \"REMARK Output of the program extract_from_p\
db (Version $VersionTag)\\n\";\n    print \"REMARK\
 Legal PDB format not Guaranteed\\n\";\n    print \
\"REMARK This format is not meant to be used in pl\
ace of the PDB format\\n\";\n    print \"REMARK Th\
e header refers to the original entry\\n\";\n    p\
rint \"REMARK The sequence from the original file \
has been taken in the field: $seq_field\\n\";\n   \
 print \"REMARK extract_from_pdb, 2001, 2002, 2003\
, 2004, 2005 2006 (c) CNRS and Cedric Notredame\\n\
\";   \n    if ( $coor_set)\n{\n       print \"REM\
ARK Partial chain: Start $start End $end\\n\";\n}\\
n    if ( $is_nmr)\n{\n       print \"REMARK NMR s\
tructure: MODEL $model\\n\";\n}\n   \n    if ( $n_\
atom!=0)\n{\n       print \"REMARK Contains Coordi\
nates of: \";\n       foreach $a (@atom){print \"$\
a \";}\n       print \"\\n\";\n}  \n}\n\n\n\n\nmy \
$residue_index = -999;\nmy $old_c = \"TemporaryCha\
in\";\n\nwhile (<$INFILE>) \n{\n	$line=$_;\n\n\n	i\
f ($line =~ /^SEQRES/)\n{\n\n		@field=/(\\S*)\\s*/\
g;\n\n		$c= substr($_,11,1);\n\n		\n		$l=$#field;\\
n		for ($a=4; $a<$#field ;)\n{\n			if (!$onelett{$\
molecule_type{$c}}->{$field[$a]})\n{\n				splice @\
field, $a, 1;\n}\n			else \n{\n				$a++;\n}\n}\n	\\
n		if ( $c ne $in_chain)\n{\n			$pdb_chain_list[$n\
_pdb_chains]=$c;\n			$pdb_chain_len [$n_pdb_chains\
]=$len;\n			$in_chain=$c;\n			$n_pdb_chains++;\n}\\
n	\n		for ( $a=4; $a<$#field;$a++)\n{\n			$complet\
e_seq{$c}[$complete_seq_len{$c}++]=$field[$a];\n}\\
n}\n    elsif ( $line=~/^ATOM/ || ($line=~/^HETATM\
/ && &is_aa(substr($line,17,3),substr($line,21,1))\
 && !$no_hetatm))\n{\n\n	 \n    $RAW_AT_ID=$AT_ID=\
substr($line,12,4);\n	$RES_ID=&is_aa(substr($line,\
17,3),substr($line,21,1));\n	$CHAIN=substr($line,2\
1,1);\n\n    $RES_NO=substr($line,22,4);\n	$HOM_CO\
DE=substr ($line, 26, 1);\n	$TEMP=substr($line,60,\
6);\n	\n	$TEMP=~s/\\s//g;\n        $AT_ID=~s/\\s//\
g;\n	$RES_ID=~s/\\s//g;\n        $RES_NO=~s/\\s//g\
;\n		\n	if ( $HOM_CODE ne $MAIN_HOM_CODE){next;}\n\
	elsif ( $already_read2{$CHAIN}{$RES_ID}{$AT_ID}{$\
RES_NO}){next;}\n	else{$already_read2{$CHAIN}{$RES\
_ID}{$AT_ID}{$RES_NO}=1;}\n	\n	\n	if ($coor_set &&\
 $numbering eq \"file\" && $residue_index ne $RES_\
NO)\n{\n	    \n	    if ( $RES_NO<=$start){$real_st\
art{$CHAIN}++;}\n	    if ( $RES_NO<=$end){$real_en\
d{$CHAIN}++;}\n}\n	elsif ($numbering eq \"absolute\
\")\n{\n	    $real_start{$CHAIN}=$start;\n	    $re\
al_end{$CHAIN}=$end;\n}\n\n        $KEY=\"ALL\";\n\
        if ( $CHAIN ne $in_atom_chain)\n{\n	    \n\
	  $pdb_atom_chain_list[$n_pdb_atom_chains]=$c;\n	\
  $pdb_atom_chain_len [$n_pdb_atom_chains]=$len;\n\
	  $in_atom_chain=$c;\n	  $n_pdb_atom_chains++;\n}\
\n	\n	if ( $residue_index ne $RES_NO)\n{\n	     $r\
esidue_index = $RES_NO;\n	     $atom_seq{$CHAIN}[$\
atom_seq_len{$CHAIN}++]=$RES_ID;;\n}\n}\n\n}\nclos\
e ($INFILE);\n\n\n\n\n\n\n$INFILE=vfopen ($structu\
re_file, \"r\");\nforeach $c (@c_chain)\n{\n\n	if \
   ( $seq_field eq \"SEQRES\"){@pdb_seq=@{$complet\
e_seq{$c}};}\n	elsif ( $seq_field eq \"ATOM\")  {@\
pdb_seq=@{$atom_seq{$c}};}\n	\n\n	$full_length=$l=\
$#pdb_seq+1;\n		\n	if ( $real_end{$c}==\"*\"){$rea\
l_end{$c}=$full_length;}\n	if ( $coor_set)\n{	   \\
n\n	   if ( $real_end{$c} < $l){splice @pdb_seq, $\
real_end{$c}, $l;}\n	   if ( $real_start{$c} < $l)\
{splice @pdb_seq, 0, $real_start{$c}-1;}	  	   \n	\
   $l=$#pdb_seq;\n}\n\n	elsif ( $delete_set)\n{\n	\
   splice @pdb_seq, $delete_start, $delete_end-$de\
lete_start+1;\n	   $l=$#pdb_seq;\n}\n	\n	$new_fast\
a_name=\"$pdb_id$c\";\n	if ( $coor_set)\n{\n	   if\
 ( $n_pdb_chains==0){$new_fasta_name=\"$new_fasta_\
name$c\";}\n	   $new_fasta_name= $new_fasta_name.\\
"\\_$start\\_$end\";\n}\n	   \n	if ( $MODE eq \"pd\
b\")\n{\n	   $nl=1;\n	   $n=0;\n	   \n	   foreach \
$res ( @pdb_seq)\n		{\n		if ( !$n)\n		{\n		\n		 pr\
intf \"SEQRES %3d %1s %4d  \", $nl,$c, $l;\n		 $nl\
++;\n	}\n	     $res=~s/\\s//g;\n	     \n	     if (\
$code==1){ printf \"%3s \",$onelett{$molecule_type\
{$c}}->{$res};}\n	     elsif  ($code==3){ printf \\
"%3s \",$res};\n	     \n	     $n++;		  \n	     if \
( $n==13){$n=0;print \"\\n\";}\n}\n	  if ( $n!=0){\
print \"\\n\"; $n=0;}\n}\n	elsif ( $MODE eq \"simp\
le\")\n{\n	  print \"# SIMPLE_PDB_FORMAT\\n\";\n	 \
 if ( $new_fasta_name eq \" \"){$new_fasta_name=\"\
dummy_name\";}\n	  print \">$new_fasta_name\\n\";\\
n\n	  foreach $res ( @pdb_seq)\n{\n	      print \"\
$onelett{$molecule_type{$c}}->{$res}\";\n}\n	  pri\
nt \"\\n\";\n}\n	elsif ( $MODE eq \"fasta\")\n{\n	\
  $n=0;\n	  print \">$new_fasta_name\\n\";\n	  \n	\
  foreach $res ( @pdb_seq)\n{\n\n	      print \"$o\
nelett{$molecule_type{$c}}->{$res}\";\n           \
   $n++;\n	      if ( $n==60){print \"\\n\"; $n=0;\
}\n}\n	  print \"\\n\"; \n}\n}\n\nif ( $MODE eq \"\
fasta\")\n{\n     &myexit($EXIT_SUCCESS);\n  \n}\n\
\n  \n  $charcount=0;\n  $inchain=\"BEGIN\";\n  $n\
=0;\n  while (<$INFILE>) \n{\n    $line=$_;\n     \
\n    if ($line =~/^ATOM/  ||  ($line=~/^HETATM/))\
\n{\n	$line_header=\"UNKNWN\";\n	$RES_ID=substr($l\
ine,17,3);\n	$chain = substr($line,21,1);\n\n	if (\
$line =~/^ATOM/)\n{\n	    $line_header=\"ATOM\";\n\
	    $RES_ID=(&is_aa($RES_ID,$chain))?&is_aa($RES_\
ID,$chain):$RES_ID;\n}\n	elsif ($line=~/^HETATM/ &\
& ($ligand_list {$RES_ID} ||$ligand_list {'ALL'} |\
| !&is_aa($RES_ID,$chain)))\n{\n	    $line_header=\
\"HETATM\";\n}\n	elsif ($line=~/^HETATM/ && (&is_a\
a($RES_ID,$chain) && !$no_hetatm))\n{\n	    $line_\
header=\"ATOM\";\n	    $RES_ID=&is_aa($RES_ID,$cha\
in);\n}\n	else\n{\n	    next;\n}\n\n	\n\n	$X=subst\
r($line,30,8);     \n	$Y=substr($line,38,8);\n	$Z=\
substr($line,46,8);\n	$TEMP=substr($line,60,6);\n	\
\n	$RAW_AT_ID=$AT_ID=substr($line,12,4);\n	$CHAIN=\
substr($line,21,1);\n	$RES_NO=substr($line,22,4);\\
n	$HOM_CODE=substr ($line, 26, 1);\n	\n	$X=~s/\\s/\
/g;\n	$Y=~s/\\s//g;\n	$Z=~s/\\s//g;\n	$TEMP=~s/\\s\
//g;\n	\n	$AT_ID=~s/\\s//g;\n	$RES_ID=~s/\\s//g;\n\
	$RES_NO=~s/\\s//g;\n\n	\n	if ( $HOM_CODE ne $MAIN\
_HOM_CODE){next;}\n	elsif ( $already_read{$CHAIN}{\
$RES_ID}{$AT_ID}{$RES_NO}){next;}\n	else{$already_\
read{$CHAIN}{$RES_ID}{$AT_ID}{$RES_NO}=1;}\n	\n	$K\
EY=\"ALL\";\n\n      	if ( $RES_NO ==0){$start_at_\
zero=1;}\n\n	$RES_NO+=$start_at_zero;    \n	\n	if \
( $current_chain ne $CHAIN)\n{\n	    $current_chai\
n=$CHAIN;\n	    $pos=$current_residue=0;\n	    $of\
fset=($coor_set)?($real_start{$CHAIN}-1):0;\n	    \
if    ( $seq_field eq \"SEQRES\"){@ref_seq=@{$comp\
lete_seq{$CHAIN}};}\n	    elsif ( $seq_field eq \"\
ATOM\")  {@ref_seq=@{$atom_seq{$CHAIN}};}\n}\n	\n	\
if ($current_residue != $RES_NO)\n{\n	    $current\
_residue=$RES_NO;\n	    if    ( $seq_field eq \"SE\
QRES\"){$pos=$current_residue;}\n	    elsif ( $seq\
_field eq \"ATOM\"){$pos++;}\n}\n	\n	\n	if ($n_ato\
m==0 || $atom_list{$AT_ID}==1 || $atom_list{$KEY}=\
=1)\n{ 	\n	    \n	    $do_it=(!@c_chain || $hc_cha\
in{$CHAIN} ||$hc_chain{'LIGAND'} );\n	    \n	    $\
do_it= ($do_it==1) && ($coor_set==0 ||($pos>=$real\
_start{$CHAIN} && $pos<=$real_end{$CHAIN}));\n	   \
 $do_it= ($do_it==1) && ($delete_set==0 || $pos<$d\
elete_start ||$pos>$delete_end );\n	    if ($ligan\
d==0 && $line_header eq \"HETATM\" ){$do_it=0;}\n	\
    if ($ligand_only==1 && $line_header eq \"ATOM\\
" ){$do_it=0;}\n	    if ($ligand==1 && $line_heade\
r eq \"HETATM\" && $ligand_list{$RES_ID}==0 && $li\
gand_list{\"ALL\"}==0){$do_it=0;} \n	    \n	    \n\
	    if ( $do_it)\n{\n		$n++;\n		$out_pos=$pos;\n	\
	\n	       if ( $delete_set)\n{\n		  if ( $out_pos\
< $delete_start){;}\n		  else {$offset=$delete_end\
-$delete_start;}\n}       \n	       \n	       if (\
 $numbering_out eq \"new\"){$out_pos-=$offset;}\n	\
       elsif ( $numbering_out eq \"old\"){$out_pos\
=$RES_NO;}\n	       \n       \n	       \n	       i\
f ( $code==1){$RES_ID=$onelett{$molecule_type{$c}}\
->{$RES_ID};}\n	    \n	       if ($unfold)\n{\n		 \
  $unfolded_x+=5;\n		   $X=$unfolded_x;\n		   $Y=0\
;\n		   $Z=0;\n		   $float=1;\n}\n	       else\n{\\
n		   $float=3;\n}\n\n	       if ( $MODE eq \"pdb\\
")\n{\n		   printf \"%-6s%5d %-4s %3s %s%4d    %8.\
3f%8.3f%8.3f  1.00 %5.2f\\n\",$line_header, $n, $R\
AW_AT_ID,$RES_ID,$CHAIN,$out_pos, $X, $Y, $Z,$TEMP\
;		  \n}\n	       elsif ( $MODE eq \"simple\")\n{\\
n		    if ( $RES_ID eq \"\"){$RES_ID=\"X\";}\n		  \
printf \"%-6s %5s %s %2s %4d    %8.3f %8.3f %8.3f\\
\n\",$line_header, $AT_ID, $RES_ID,($CHAIN eq\"\" \
|| $CHAIN eq \" \")?\"A\":$CHAIN,$out_pos, $X, $Y,\
 $Z,$TEMP;\n}\n\n}\n}\n}\n}\nprint \"\\n\";\nclose\
($INFILE);\n\n\nif ( $error ne \"\") \n{$error=$er\
ror.\"\\nDiagnostic:    SEQRES and the residues in\
 ATOM are probably Incompatible\\n\";\n    $error=\
$error.  \"Recomendation: Rerun with '-fix 1' in o\
rder to ignore the SEQRES sequences\\n\";\n}\nif (\
!$nodiagnostic){print STDERR $error;}\n&myexit ( $\
EXIT_SUCCESS);\n\nsub get_pdb_entry_type_file\n  {\
\n    my $cache_file=\"$cache/pdb_entry_type.txt\"\
;\n    my $env_file  = $ENV{\"PDB_ENTRY_TYPE_FILE\\
"};\n    my $pdb_file  =\"$ENV{'PDB_DIR'}/derived_\
data/pdb_entry_type.txt\";\n    \n    \n    if (-z\
 $cache_file){unlink ($cache_file);}#will get upda\
ted\n    if (-z $env_file){$env_file=\"\";}    #ca\
nnot update\n    if (-z $pdb_file){$pdb_file=\"\";\
}    #cannot update\n    \n    if    (-e $env_file\
){return $env_file;} #env wins: user decides\n    \
elsif (-e $pdb_file){return $pdb_file;} #local dat\
abase wins: network file may be out of sync\n    e\
lsif ($no_remote_pdb_dir==1)\n      {\n	if (-e $ca\
che_file){return $cache_file;}\n	else\n	  {add_war\
ning($$,$$,\"PDB_ENTRY_TYPE_FILE must be set to th\
e location of <pdb>/derived_data/pdb_entry_type.tx\
t when using NO_REMOTE_PDB_DIR=1\");\n	   return \\
"\";\n	 }\n      }\n    else #update can only take\
 place if the file lives in cache\n      {\n	my $n\
ew_file;\n	if (!-e $cache_file || (-M $cache_file)\
>1)\n	  {\n	    $new_file=vtmpnam();\n	    &url2fi\
le(\"ftp://ftp.wwpdb.org/pub/pdb/derived_data/pdb_\
entry_type.txt\", $new_file);\n	    if ( !-z $new_\
file){system (\"mv $new_file $cache_file\"); unlin\
k ($new_file); $new_file=$cache_file;}\n	    else \
{unlink($new_file);}\n	  }\n	else\n	  {\n	    $new\
_file=$cache_file;\n	  }\n	\n	if (!-e $cache_file \
&& !-e $new_file)\n	  {\n	    add_warning($$,$$,\"\
Could not download ftp://ftp.wwpdb.org/pub/pdb/der\
ived_data/pdb_entry_type.txt\");\n	    return \"\"\
;\n	  }\n	elsif (-e $cache_file && !-e $new_file)\\
n	  {\n	    my $m=(-M $cache_file);\n	    add_warn\
ing($$,$$,\"Could not update file ftp://ftp.wwpdb.\
org/pub/pdb/derived_data/pdb_entry_type.txt. Older\
 Version [$cache_file]($m Month(s) old) will be us\
ed instead\");\n	    return $cache_file;\n	  }\n	e\
lse\n	  {\n	    return $new_file;\n	  }\n      }\n\
  }\n\n\n\nsub get_unrealeased_file\n  {\n    my $\
cache_file=\"$cache/unreleased_entries.json.gz\";\\
n    my $env_file  = $ENV{\"PDB_UNREALEASED_FILE\"\
};\n    my $pdb_file  =\"$ENV{'PDB_DIR'}/derived_d\
ata/unreleased_entries.json.gz\";\n    \n    \n   \
 if ($env_file eq \"NO\" || $env_file eq \"No\" ||\
 $env_file eq \"no\" || $env_file eq \"0\"){return\
 \"NO\";}\n\n    if (-z $cache_file){unlink ($cach\
e_file);}#will get updated\n    if (-z $env_file){\
unlink($env_file);}     #will update\n    if (-z $\
pdb_file){$pdb_file=\"\";}          #cannot update\
\n    \n    if    (-e $env_file){return $env_file;\
} #env wins: user decides\n    elsif (-e $pdb_file\
){return $pdb_file;} #local database wins: network\
 file may be out of sync\n    elsif ($no_remote_pd\
b_dir==1)        \n      {\n	if (-e $cache_file){r\
eturn $cache_file;}\n	elsif ( $env_file && ! -e $e\
nv_file)\n	  {\n	    &url2file(\"https://ftp.rcsb.\
org/pub/pdb/holdings/unreleased_entries.json.gz\",\
$env_file);\n	    if ( -e $env_file && !-z $env_fi\
le){return $env_file;}\n	  }\n	else\n	  {\n	    ad\
d_warning($$,$$,\"UNREALEASED_FILE must be set to \
the location of your unrealeased.xml file as downl\
oaded from https://ftp.rcsb.org/pub/pdb/holdings/u\
nreleased_entries.json.gz when using NO_REMOTE_PDB\
_DIR=1\");\n	    return \"\";\n	  }\n      }\n    \
else #update can only take place if the file lives\
 in cache\n      {\n	my $new_file=vtmpnam ();\n	if\
 (!-e $cache_file || (-M $cache_file)>1)\n	  {\n	 \
   &url2file(\"https://ftp.rcsb.org/pub/pdb/holdin\
gs/unreleased_entries.json.gz\",$new_file);\n	    \
if ( !-z $new_file){system (\"mv $new_file $cache_\
file\"); unlink ($new_file); $new_file=$cache_file\
;}\n	    else {unlink($new_file);}\n	  }\n	else\n	\
  {\n	    $new_file=$cache_file;\n	  }\n	\n	if (!-\
e $cache_file && !-e $new_file)\n	  {\n	    add_wa\
rning($$,$$,\"Could not download https://ftp.rcsb.\
org/pub/pdb/holdings/unreleased_entries.json.gz\")\
;\n	    return \"\";\n	  }\n	elsif (-e $cache_file\
 && !-e $new_file)\n	  {\n	    my $m=(-M $cache_fi\
le);\n	    add_warning($$,$$,\"Could not update fi\
le https://ftp.rcsb.org/pub/pdb/holdings/unrelease\
d_entries.json.gz. Older Version [$cache_file]($m \
Month(s) ) will be used\");\n	    return $cache_fi\
le;\n	  }\n	else\n	  {\n	    return $new_file;\n	 \
 }\n      }\n  }\n\nsub is_released \n  {\n    my \
($r);\n    my $in=@_[0];\n    my $name=&remote_is_\
pdb_name ($in);\n    my $hold=&remote_is_on_hold($\
in);\n    \n    $r=($name && !$hold)?1:0;\n    ret\
urn $r;\n  }\n\nsub remote_is_pdb_name \n  {\n    \
my $in=@_[0];\n    my ($pdb);\n    my ($value,$val\
ue1,$value2);\n    my $max=2;\n    \n    \n    \n \
   my $ref_file=&get_pdb_entry_type_file();\n    \\
n    if ( $in=~/[^\\w\\d\\:\\_]/){return 0;}\n    \
elsif (!-e $ref_file)\n      {\n	add_warning ($$,$\
$,\"Cannot find pdb_entry_type.txt;  $in is assume\
d to be valid; add ftp://ftp.wwpdb.org/pub/pdb/der\
ived_data/pdb_entry_type.txt in $cache to automati\
cally check name status\");\n	return 1;\n      }\n\
    else\n      {\n	$pdb=substr ($in,0, 4);\n	chom\
p(($value1=`grep -c $pdb $ref_file`));\n	$pdb=lc($\
pdb);\n	chomp(($value2=`grep -c $pdb $ref_file`));\
\n	$value=($value1 || $value2)?1:0;\n	$value=($val\
ue>0)?1:0;\n	\n	return $value;\n      }\n  }\n\n\n\
\nsub pdb2model_type\n{\n    my $in=@_[0];\n    my\
 ($ref_file, $pdb);\n    my ($value, $ret);\n\n   \
 if ( $in=~/[^\\w\\d\\:\\_]/){return 0;}\n    $ref\
_file=&get_pdb_entry_type_file();\n    if (!-e $re\
f_file)\n      {\n	add_warning ($$,$$,\"Cannot fin\
d pdb_entry_type.txt;  $in is assumed to be diffra\
ction; add ftp://ftp.wwpdb.org/pub/pdb/derived_dat\
a/pdb_entry_type.txt in $cache to check name statu\
s\");\n	return \"diffraction\";\n      }\n    else\
\n      {\n	$pdb=substr ($in,0, 4);\n	$pdb=lc($pdb\
);\n	\n	chomp(($value=`grep $pdb $ref_file`));\n	\\
n	$value=~/^\\S+\\s+\\S+\\s+(\\S+)/;\n	$ret=$1;\n	\
if ( $ret eq\"\"){return \"UNKNOWN\";}\n	\n	return\
 $ret;\n      }\n  }\nsub remote_is_on_hold\n  {\n\
    my $in=@_[0];\n    my ($ref_file, $pdb);\n    \
my ($value1, $value2,$value);\n    \n\n\n    \n   \
 $ref_file=&get_unrealeased_file();\n    if ($ref_\
file eq \"NO\"){return 0;}\n\n\n    if ($no_remote\
_pdb==1){return 0;}\n    if ( $in=~/[^\\w\\d\\:\\_\
]/){return 0;}\n    \n    $ref_file=&get_unrealeas\
ed_file();\n    if (!-e $ref_file)\n      {\n	add_\
warning ($$,$$,\"Cannot find https://ftp.rcsb.org/\
pub/pdb/holdings/unreleased_entries.json.gz;  $in \
is assumed to be released;\");\n	return 1;\n      \
}\n    \n    $pdb=substr ($in,0, 4);\n    chomp(($\
value1=`grep -c $pdb $ref_file`));\n    $pdb=lc($p\
db);\n    chomp(($value2=`grep -c $pdb $ref_file`)\
);\n    $value=($value1 || $value2)?1:0;\n    $val\
ue=($value>0)?1:0;\n    return $value;\n  }\n\nsub\
 is_pdb_file\n  {\n    my @arg=@_;\n    \n    if (\
 !-e $arg[0]){return 0;}\n    \n    $F=vfopen ($ar\
g[0], \"r\");\n    while ( <$F>)\n      {\n	if (/^\
HEADER/)\n	  {\n	    close $F;\n	    return 1;\n	 \
 }\n	elsif ( /^SEQRES/)\n	  {\n	    close $F;\n	  \
  return 1;\n	  }\n	elsif ( /^ATOM/)\n	  {\n	    c\
lose $F;\n	    return 1;\n	  }\n      }\n    retur\
n 0;\n  }\nsub get_pdb_id\n{\n    my $header_file=\
@_[0];\n    my $id;\n    my $F= new FileHandle;\n \
   \n    \n    $F=vfopen (\"$header_file\", \"r\")\
;\n\n    while ( <$F>)\n      {\n	if ( /HEADER/)\n\
	  {\n	    if ($debug){print \"$_\";}\n	    $id=su\
bstr($_,62,4 );\n	    return $id;\n	  }\n      }\n\
    close ($F);\n    \n    return \"\";\n}\n\nsub \
get_ligand_list\n{\n    my $pdb_file=@_[0];\n    m\
y $chain;\n    my $ligand;\n    my %complete_ligan\
d_list;\n    \n\n    $F=vfopen ($pdb_file, \"r\");\
\n    while ( <$F>)\n{\n	if ( /^HETATM/)\n{\n	    \
$line=$_;\n	    $chain=substr($line,21,1);\n	    $\
ligand=substr($line,17,3);\n	    \n	    if (!$comp\
lete_ligand_list{$chain}{$ligand})\n{\n		\n		$comp\
lete_ligand_list{\"result\"}.=\"CHAIN $chain LIGAN\
D $ligand\\n\";\n		$complete_ligand_list{$chain}{$\
ligand}=1;\n}\n}\n}\n    close ($F);\n    return %\
complete_ligand_list;\n}\n\nsub get_chain_list \n{\
\n    my $header_file;\n    my @chain_list;\n    m\
y @list;\n    my $n_chains;\n    my %chain_hasch;\\
n    my $pdb_file=@_[0];\n    my $c;\n    my %hasc\
h;\n    my $chain;\n  \n    \n    $F=vfopen ($pdb_\
file, \"r\");\n    while ( <$F>)\n{\n\n\n	if (/SEQ\
RES\\s+\\d+\\s+(\\S+)/)\n	  {\n	    $chain = subst\
r($_,11,1);$chain=~s/\\s//g;if ( $chain eq \"\"){$\
chain=\" \";}\n	    if (!$hasch{$chain}){$hasch{$c\
hain}=1;push @chain_list, $chain;}\n	  }\n	if (/^A\
TOM/ || /^HETATM/)\n	  {\n	    $chain = substr($_,\
21,1); $chain=~s/\\s//g;if ( $chain eq \"\"){$chai\
n=\" \";}\n	    if (!$hasch{$chain}){$hasch{$chain\
}=1;push @chain_list, $chain;}\n	  }\n      }\n\n\\
nclose ($F);\nif (!@chain_list)\n  {\n    @chain_l\
ist=(\"A\");\n  }\n\n\nreturn @chain_list;\n}\n\ns\
ub token_is_in_list\n{\n\n    my @list=@_;\n    my\
 $a;\n    \n    for ($a=1; $a<=$#list; $a++)\n{\n	\
if ( $list[$a] eq $list[0]){return $a;}\n}\n}\n\ns\
ub pdb_name2name_and_chain \n{\n    my $pdb_file=@\
_[0];\n    my $pdb_file_in;\n    my @array;\n    m\
y $chain;\n    my $c;\n\n    $pdb_file_in=$pdb_fil\
e;\n\n    $pdb_file=~/^(.{4})/;$pdb_id=$1;\n    @a\
rray=($pdb_file=~/([\\w])/g);\n  \n  \n    $chain=\
uc ($array[4]);\n    $chain=($chain eq \"\")?\"FIR\
ST\":$chain;\n    \n    return ( $pdb_id, $chain);\
\n\n    if ( $#array==3){return ($pdb_id, \"FIRST\\
");}\n    elsif ( $#array<4){ return ($pdb_id, \"\\
");}\n    else {return ( $pdb_id, $chain);}\n     \
 \n    \n    \n}\nsub get_main_hom_code \n{\n    m\
y $pdb_file=@_[0];\n    my %hom, $n, $best, $best_\
h;\n    open (F, $pdb_file);\n    while (<F>)\n{\n\
	if ( $_=~/^ATOM/)\n{\n	    $h=substr ($_,26, 1);\\
n	    $n=++$hom{$h};\n	    if ($n>$best)\n{\n		$be\
st=$n;\n		$best_h=$h;\n}\n}\n}\n    close (F);\n  \
  return $best_h;\n}\n\n\nsub get_pdb_file \n{\n  \
  my ($pdb_file_in)=(@_);\n    my $result;\n    my\
 @letter;\n    my @chain;\n    my $v;\n    my $pdb\
_file=$pdb_file_in;\n\n    $pdb_file=($pdb_file_in\
=~/\\S+_S_(\\S+)/)?$1:$pdb_file_in;\n    \n    if \
($no_remote_pdb_dir==0)\n      {\n	$no_remote_pdb_\
dir=1;\n	$result=get_pdb_file3 ($pdb_file);\n	$no_\
remote_pdb_dir=0;\n	if ( $result){return $result;}\
\n	else\n	  {\n	    \n	    lc ($pdb_file);\n	    $\
result=get_pdb_file3($pdb_file);\n	    return  $re\
sult;\n	  }\n      }\n    else\n      {\n	return g\
et_pdb_file3 ($pdb_file);\n      }\n    \n  }\n\ns\
ub get_pdb_file3 \n{\n    my $pdb_file_in=@_[0];\n\
    my $result;\n    my @letter;\n    my @chain;\n\
    my $lcfile;\n    my $ucfile;\n    my $pdb_file\
=$pdb_file_in;\n    \n    $lcfile=lc $pdb_file;\n \
   $ucfile=uc $pdb_file;\n\n    if ( ($result=get_\
pdb_file2 ($pdb_file))){return $result;}\n    \n\n\
    if ($lcfile ne $pdb_file && ($result=get_pdb_f\
ile2 ($lcfile))){return $result;}\n    if ($ucfile\
 ne $pdb_file && ($result=get_pdb_file2 ($ucfile))\
){return $result;}\n    \n   \n    \n    return \"\
\";\n}\nsub get_pdb_file2\n{\n    my $pdb_file=@_[\
0];\n    my $return_value;\n    \n    $return_valu\
e=\"\";\n    \n    if ( ($result=get_pdb_file1 ($p\
db_file))){$return_value=$result;}\n    elsif ( !(\
$pdb_file=~/\\.pdb/) && !($pdb_file=~/\\.PDB/))\n{\
\n	if ( ($result=get_pdb_file1 (\"$pdb_file.pdb\")\
)){$return_value=$result;}\n	elsif ( ($result=get_\
pdb_file1 (\"$pdb_file.PDB\"))){$return_value=$res\
ult;}\n\n	elsif ( ($result=get_pdb_file1 (\"pdb$pd\
b_file.pdb\"))){$return_value=$result;}	\n	elsif (\
 ($result=get_pdb_file1 (\"pdb$pdb_file.PDB\"))){$\
return_value=$result;}\n	elsif ( ($result=get_pdb_\
file1 (\"PDB$pdb_file.PDB\"))){$return_value=$resu\
lt;}\n	elsif ( ($result=get_pdb_file1 (\"PDB$pdb_f\
ile.pdb\"))){$return_value=$result;}\n	\n	\n	elsif\
 ( ($result=get_pdb_file1 (\"$pdb_file.ent\"))){$r\
eturn_value=$result;}\n	elsif ( ($result=get_pdb_f\
ile1 (\"pdb$pdb_file.ent\"))){$return_value=$resul\
t;}\n	elsif ( ($result=get_pdb_file1 (\"PDB$pdb_fi\
le.ent\"))){$return_value=$result;}\n\n	elsif ( ($\
result=get_pdb_file1 (\"$pdb_file.ENT\"))){$return\
_value=$result;}\n	elsif ( ($result=get_pdb_file1 \
(\"pdb$pdb_file.ENT\"))){$return_value=$result;}\n\
	elsif ( ($result=get_pdb_file1 (\"PDB$pdb_file.EN\
T\"))){$return_value=$result;}\n	\n	\n	\n}\n    re\
turn $return_value;\n}\n    \nsub get_pdb_file1\n{\
\n    my ($pdb_file)=(@_);\n    my $return_value;\\
n    \n\n    $return_value=\"\";\n    if ( ($resul\
t=get_pdb_file0 ($pdb_file))){$return_value=$resul\
t;}\n    elsif ( ($result=get_pdb_file0 (\"$pdb_fi\
le.Z\"))){$return_value=$result;}\n    elsif ( ($r\
esult=get_pdb_file0 (\"$pdb_file.gz\"))){$return_v\
alue=$result;}\n    elsif ( ($result=get_pdb_file0\
 (\"$pdb_file.GZ\"))){$return_value=$result;}\n   \
 return $return_value;\n}\nsub get_pdb_file0 \n{ \\
n    my ($pdb_file, $attempt)=(@_);\n    my $pdb_f\
ile=@_[0];\n    my $tmp_pdb_file;    \n    my $ret\
urn_value;\n\n    if ( !$attempt){$attempt=1;}\n  \
  \n    $local_pdb_file=\"$pdb_file\";\n    if ( $\
local_pdb_file eq \"\")\n{\n	$tmp_pdb_file=vtmpnam\
();\n	open F, \">$tmp_pdb_file\";\n	\n	while (<STD\
IN>){print F \"$_\";}\n	close (F);\n	\n	if (-e $tm\
p_pdb_file && &is_pdb_file ( $local_pdb_file))\n{r\
eturn $tmp_pdb_file;}\n}\n\n    $local_pdb_file=\"\
$pdb_file\";\n    &debug_print (\"\\nTry access lo\
cal file: $local_pdb_file\");\n    \n    $local_pd\
b_file=&check_pdb_file4compression ($local_pdb_fil\
e);\n    if ( -e $local_pdb_file && (&is_pdb_file \
($local_pdb_file) || $force_pdb))\n{\n	&debug_prin\
t ( \"\\n\\tIs in Current Dir\");\n	$tmp_pdb_file=\
vtmpnam();\n	`cp $local_pdb_file $tmp_pdb_file`;\n\
	return $tmp_pdb_file;\n}\n    else\n{\n	&debug_pr\
int (\"\\n\\tFile Not in Current Dir\");\n}\n\n   \
 if ($pdb_file=~/^pdb/||$pdb_file=~/^PDB/){$pdb_di\
v=substr ($pdb_file, 4, 2);}\n    else\n{\n	  $pdb\
_div=substr ($pdb_file, 1, 2);\n}\n    $local_pdb_\
file=\"$pdb_dir/$pdb_div/$pdb_file\";\n    $local_\
pdb_file=&check_pdb_file4compression ( $local_pdb_\
file);\n    &debug_print (\"\\nTry access file Fro\
m PDB_DIR: $local_pdb_file\");\n    if ($pdb_dir &\
& -e $local_pdb_file && &is_pdb_file ($local_pdb_f\
ile))\n{\n	&debug_print ( \"\\n\\tIs in Local PDB \
DIR\");\n	$tmp_pdb_file=vtmpnam();\n	`cp $local_pd\
b_file $tmp_pdb_file`;\n	return $tmp_pdb_file;\n}\\
n\n    $local_pdb_file=\"$pdb_dir/$pdb_file\";\n  \
  $local_pdb_file=&check_pdb_file4compression ( $l\
ocal_pdb_file);\n    &debug_print (\"\\nTry access\
 file From PDB_DIR: local_pdb_file\");\n    if ($p\
db_dir && -e $local_pdb_file && &is_pdb_file ($loc\
al_pdb_file))\n{\n	&debug_print ( \"\\n\\tIs in Lo\
cal PDB DIR\");\n	$tmp_pdb_file=vtmpnam();\n	`cp $\
local_pdb_file $tmp_pdb_file`;\n	return $tmp_pdb_f\
ile;\n}\n\n    $local_pdb_file=\"$pdb_dir$pdb_file\
\";\n    $local_pdb_file=&check_pdb_file4compressi\
on ( $local_pdb_file);\n    &debug_print (\"\\nTry\
 access file From PDB_DIR: $local_pdb_file\");\n  \
  if ($pdb_dir && -e $local_pdb_file && &is_pdb_fi\
le ($local_pdb_file))\n{\n	&debug_print ( \"\\n\\t\
Is in Local PDB DIR\");\n	$tmp_pdb_file=vtmpnam();\
\n	`cp $local_pdb_file $tmp_pdb_file`;\n	return $t\
mp_pdb_file;\n}\n    else\n{&debug_print ( \"\\n\\\
tNot In Local Pdb Dir\");}\n\n    if ($cache ne \"\
NO\" && $cache ne \"no\")\n{\n\n	$local_pdb_file=\\
"$cache/$pdb_file\";\n	$local_pdb_file=&check_pdb_\
file4compression ( $local_pdb_file);\n	&debug_prin\
t(\"\\nTry access file From Cache: $local_pdb_file\
\");\n	if (-e $local_pdb_file && &is_pdb_file ($lo\
cal_pdb_file))\n{\n	    &debug_print ( \"\\n\\tIs \
in T-Coffee Cache\");\n	    $tmp_pdb_file=vtmpnam(\
);\n	    `cp $local_pdb_file $tmp_pdb_file`;\n	   \
 return $tmp_pdb_file;\n}\n	else{&debug_print ( \"\
\\n\\tNot in Cache Dir\");}\n}\n\nif (!$no_remote_\
pdb_dir) \n  {\n    my $value=&is_released ($pdb_f\
ile);\n    my $return_value=\"\";\n    if ($value=\
=1)\n      {\n	\n	&debug_print (\"\\n*************\
****************************************\\nTry Rem\
ote Access for $pdb_file\");\n	$tmp_pdb_file=vtmpn\
am();\n	$netcommand=$netaddress;\n	$netcommand=~s/\
%%/$pdb_file/g;\n	&url2file(\"$netcommand\", \"$tm\
p_pdb_file.$netcompression\");\n	&debug_print(\"\\\
nREMOTE: $netcommand\\n\");\n	\n	$compressed_tmp_f\
ile_name=\"$tmp_pdb_file.$netcompression\";\n	\n	i\
f ($netcompression && -B $compressed_tmp_file_name\
 && $attempt<5)\n	  {\n	    my $r;\n	    &debug_pr\
int (\"\\n\\tFile Found Remotely\");\n	    if (($r\
=safe_system ( \"$netcompression_pg $compressed_tm\
p_file_name\")!=$EXIT_SUCCESS) && $attempts<5)\n	 \
     {\n		&debug_print (\"\\n\\tProper Download Fa\
iled Try again\");\n		unlink $compressed_tmp_file_\
name;\n		print \"\\nFailed to Download $compressed\
_tmp_file_name. New Attempt $attempt/5\\n\";\n		re\
turn &get_pdb_file0($pdb_file, $attempt+1);\n	    \
  }\n	    elsif ($r== $EXIT_SUCCESS)\n	      {\n		\
&debug_print (\"\\n\\tProper Download Succeeded \"\
);\n		$return_value=$tmp_pdb_file;\n	      }\n	   \
 else\n	      {\n		&debug_print (\"\\n\\tProper Do\
wnload Failed \");\n		&debug_print (\"\\nFile Not \
Found Remotely\");\n		unlink $compressed_tmp_file_\
name;\n	      }\n	  }\n	else\n	  {\n\n	    &debug_\
print (\"\\nFile Not Found Remotely\");\n	    unli\
nk $compressed_tmp_file_name;\n	  }\n	#Update cach\
e if required\n	if ($cache ne \"no\" && $cache ne \
\"update\" && -e $return_value)\n	  {\n	    `cp $r\
eturn_value $cache/$pdb_file.pdb`;\n	    #`t_coffe\
e -other_pg clean_cache.pl -file $pdb_file.pdb -di\
r $cache`;\n	  }\n      }\n    &debug_print (\"\\n\
Remote Download Finished\");\n    return $return_v\
alue;\n  }\nreturn \"\";\n}\n\nsub check_pdb_file4\
compression \n{\n    my $file=@_[0];\n    my $tmp;\
\n    my $r;\n    \n    $tmp=&vtmpnam();\n    if (\
-e $tmp){unlink $tmp;}\n    \n    $file=~s/\\/\\//\
\\//g;\n    if    (-B $file && ($file=~/\\.Z/)) {`\
cp $file $tmp.Z`;`rm $tmp`;`gunzip $tmp.Z $SILENT`\
;$r=$tmp;}\n    elsif (-B $file && ($file=~/\\.gz/\
)){`cp $file $tmp.gz`;`gunzip $tmp.gz $SILENT`;ret\
urn $r=$tmp;}\n    elsif (-B $file ){`cp $file $tm\
p.gz`;`gunzip $tmp.gz $SILENT`;$r=$tmp;}\n    elsi\
f ( -e $file ) {$r= $file;}\n    elsif ( -e \"$fil\
e.gz\" ){ `cp $file.gz $tmp.gz`;`gunzip     $tmp.g\
z $SILENT`;$r=$tmp;}    \n    elsif ( -e \"$file.Z\
\") {`cp $file.Z  $tmp.Z`; `gunzip $tmp.Z $SILENT`\
;$r=$tmp;}\n    else  {$r= $file;}\n\n    if ( -e \
\"$tmp.Z\"){unlink \"$tmp.Z\";}\n    if ( -e \"$tm\
p.gz\"){unlink \"$tmp.gz\";}\n    \n    return $r;\
\n    \n}\n\n\n\n\n\n    \n\n\n\n\n\n\n\nsub vfope\
n \n{\n    my $file=@_[0];\n    my $mode=@_[1];\n \
   my $tmp;\n    my $F = new FileHandle;\n    \n  \
  \n    $tmp=$file;\n	\n    \n    if ( $mode eq \"\
r\" && !-e $file){ myexit(flush_error (\"Cannot op\
en file $file\"));}\n    elsif ($mode eq \"w\"){$t\
mp=\">$file\";}\n    elsif ($mode eq \"a\"){$tmp=\\
">>$file\";}\n    \n    \n    open ($F,$tmp);\n   \
 return $F;\n}\nsub debug_print\n{\n    my $messag\
e =@_[0];\n    if ($debug){print STDERR \"NO_REMOT\
E_PDB_DIR: $no_remote_pdb_dir - $message [DEBUG:ex\
tract_from_pdb]\";}\n    return;\n}\nsub is_aa \n{\
\n    my ($aa, $chain) =@_;\n\n    my $one;\n    m\
y $trhee;\n    \n    if ( $onelett{$molecule_type{\
$chain}}->{$aa} eq 'X' || !$onelett{$molecule_type\
{$chain}}->{$aa} ){return '';}\n    else\n      {\\
n	$one=$onelett{$molecule_type{$chain}}->{$aa};\n\\
n	$three=$threelett{$molecule_type{$chain}}->{$one\
};\n	\n\n	return $three;\n      }\n  }\n\n\n\n\n\n\
sub url2file\n{\n    my ($address, $out, $wget_arg\
, $curl_arg)=(@_);\n    my ($pg, $flag, $r, $arg, \
$count);\n    \n    if (!$CONFIGURATION){&check_co\
nfiguration (\"wget\", \"INTERNET\", \"gzip\");$CO\
NFIGURATION=1;}\n    \n\n    if (&pg_is_installed \
(\"curl\")){$pg=\"curl\"; $flag=\"-o\";$arg=$curl_\
arg;}\n    elsif (&pg_is_installed (\"wget\"))   {\
$pg=\"wget\"; $flag=\"-O\";$arg=$wget_arg;}\n    \\
n    return safe_system (\"$pg $flag$out $address \
>/dev/null 2>/dev/null\");\n\n}\n\n\n\n\nsub pdbfi\
le2chaintype\n  {\n    my $file=@_[0];\n    my %ct\
;\n    my $F;\n    \n    $F=vfopen ($file, \"r\");\
\n    while (<$F>)\n      {\n	my $line=$_;\n	if ($\
line =~/^ATOM/)\n	  {\n	    my $C=substr($line,21,\
1);\n	    if (!$ct{$C})\n	      {	\n		my $r=substr\
($line,17,3);\n		$r=~s/\\s+//;\n		if (length ($r)=\
=1){$ct{$C}=\"R\";}\n		elsif (length ($r)==2){$ct{\
$C}=\"D\";}\n		elsif (length ($r)==3){$ct{$C}=\"P\\
";}\n		else \n		  {\n		    myexit(flush_error(\"ER\
ROR: Could not read RES_ID field in file $file\"))\
;\n		  }\n	      }\n	  }\n      }\n    close ($F);\
\n    return %ct;\n  }\n   \n    \n\n\n\nsub fill_\
threelett_RNA\n{\n\n	my %threelett=(\n	'A', '  A',\
\n	'T', '  T',\n	'U', '  U',\n	'C', '  C',\n	'G', \
'  G',\n	'I', '  I', #Inosine\n	);\n	\n	return %th\
reelett;\n\n}\n\n\nsub fill_onelett_RNA\n{\n	my   \
%onelett=(\n	'  A' => 'A',\n	'  T' => 'T',\n	'  U'\
 => 'U',\n	'  C' => 'C',\n	'  G' => 'G',\n	'CSL' =\
> 'X',\n	'UMS' => 'X',\n	'  I' => 'I',\n	'A' => 'A\
',\n	'T' => 'T',\n	'U' => 'U',\n	'C' => 'C',\n	'G'\
 => 'G',\n	'I' => 'I',\n	);\n\n	return %onelett;\n\
\n}\n\n\nsub fill_onelett_DNA\n{\n	my   %onelett=(\
\n	' DA', 'A',\n	' DT', 'T',\n	' DC', 'C',\n	' DG'\
, 'G',\n	'DA', 'A',\n	'DT', 'T',\n	'DC', 'C',\n	'D\
G', 'G',\n	);\n\n	return %onelett;\n\n}\n\nsub fil\
l_threelett_DNA\n{\n\n	my %threelett=(\n	'A', ' DA\
',\n	'T', ' DT',\n	'C', ' DC',\n	'G', ' DG',\n	);\\
n\n	return %threelett;\n\n}\n\n\n\n\nsub fill_thre\
elett_prot\n{  \n  my %threelett;\n\n  %threelett=\
(\n'A', 'ALA',\n'C', 'CYS',\n'D', 'ASP',\n'E', 'GL\
U',\n'F', 'PHE',\n'G', 'GLY',\n'H', 'HIS',\n'I', '\
ILE',\n'K', 'LYS',\n'L', 'LEU',\n'N', 'ASN',\n'M',\
 'MET',\n'P', 'PRO',\n'Q', 'GLN',\n'R', 'ARG',\n'S\
', 'SER',\n'T', 'THR',\n'V', 'VAL',\n'W', 'TRP',\n\
'Y', 'TYR',\n);\n\nreturn %threelett;\n\n\n}\n\nsu\
b fill_onelett_prot\n{\n    my %onelett;\n    \n  \
  %onelett=(\n\n'10A', 'X',\n'11O', 'X',\n'12A', '\
X',\n'13P', 'X',\n'13R', 'X',\n'13S', 'X',\n'14W',\
 'X',\n'15P', 'X',\n'16A', 'X',\n'16G', 'X',\n'1AN\
', 'X',\n'1AP', 'X',\n'1AR', 'X',\n'1BH', 'X',\n'1\
BO', 'X',\n'1C5', 'X',\n'1CU', 'X',\n'1DA', 'X',\n\
'1GL', 'X',\n'1GN', 'X',\n'1IN', 'X',\n'1LU', 'L',\
\n'1MA', 'X',\n'1MC', 'X',\n'1MG', 'X',\n'1MZ', 'X\
',\n'1NA', 'X',\n'1NB', 'X',\n'1NI', 'X',\n'1PA', \
'A',\n'1PC', 'X',\n'1PE', 'X',\n'1PG', 'X',\n'1PI'\
, 'A',\n'1PM', 'X',\n'1PN', 'X',\n'1PU', 'X',\n'1P\
Y', 'X',\n'1UN', 'X',\n'24T', 'X',\n'25T', 'X',\n'\
26P', 'X',\n'2AB', 'X',\n'2AM', 'X',\n'2AN', 'X',\\
n'2AP', 'X',\n'2AR', 'X',\n'2AS', 'D',\n'2BL', 'X'\
,\n'2BM', 'X',\n'2CP', 'X',\n'2DA', 'X',\n'2DG', '\
X',\n'2DP', 'X',\n'2DT', 'X',\n'2EP', 'X',\n'2EZ',\
 'X',\n'2FG', 'X',\n'2FL', 'X',\n'2FP', 'X',\n'2FU\
', 'X',\n'2GL', 'X',\n'2GP', 'X',\n'2HP', 'X',\n'2\
IB', 'X',\n'2IP', 'X',\n'2LU', 'L',\n'2MA', 'X',\n\
'2MD', 'X',\n'2ME', 'X',\n'2MG', 'X',\n'2ML', 'L',\
\n'2MO', 'X',\n'2MR', 'R',\n'2MU', 'X',\n'2MZ', 'X\
',\n'2NO', 'X',\n'2NP', 'X',\n'2OG', 'X',\n'2PA', \
'X',\n'2PC', 'X',\n'2PE', 'X',\n'2PG', 'X',\n'2PH'\
, 'X',\n'2PI', 'X',\n'2PL', 'X',\n'2PP', 'X',\n'2P\
U', 'X',\n'2SI', 'X',\n'2TB', 'X',\n'34C', 'X',\n'\
35G', 'X',\n'3AA', 'X',\n'3AD', 'X',\n'3AH', 'H',\\
n'3AN', 'X',\n'3AP', 'X',\n'3AT', 'X',\n'3BT', 'X'\
,\n'3CH', 'X',\n'3CN', 'X',\n'3CO', 'X',\n'3CP', '\
X',\n'3DR', 'X',\n'3EP', 'X',\n'3FM', 'X',\n'3GA',\
 'X',\n'3GP', 'X',\n'3HB', 'X',\n'3HC', 'X',\n'3HP\
', 'X',\n'3IB', 'X',\n'3ID', 'X',\n'3IN', 'X',\n'3\
MA', 'X',\n'3MB', 'X',\n'3MC', 'X',\n'3MD', 'D',\n\
'3MF', 'X',\n'3MP', 'X',\n'3MT', 'X',\n'3OL', 'X',\
\n'3PA', 'X',\n'3PG', 'X',\n'3PO', 'X',\n'3PP', 'X\
',\n'3PY', 'X',\n'49A', 'X',\n'4AB', 'X',\n'4AM', \
'X',\n'4AN', 'X',\n'4AP', 'X',\n'4BA', 'X',\n'4BT'\
, 'X',\n'4CA', 'X',\n'4CO', 'X',\n'4HP', 'X',\n'4I\
P', 'X',\n'4MO', 'X',\n'4MV', 'X',\n'4MZ', 'X',\n'\
4NC', 'X',\n'4NP', 'X',\n'4OX', 'X',\n'4PB', 'X',\\
n'4PN', 'X',\n'4PP', 'X',\n'4SC', 'X',\n'4SU', 'X'\
,\n'4TB', 'X',\n'55C', 'X',\n'5AD', 'X',\n'5AN', '\
X',\n'5AT', 'X',\n'5CM', 'X',\n'5GP', 'X',\n'5HP',\
 'E',\n'5HT', 'X',\n'5IT', 'X',\n'5IU', 'X',\n'5MB\
', 'X',\n'5MC', 'X',\n'5MD', 'X',\n'5MP', 'X',\n'5\
MU', 'X',\n'5NC', 'X',\n'5OB', 'X',\n'5PA', 'X',\n\
'5PV', 'X',\n'6AB', 'X',\n'6CT', 'X',\n'6HA', 'X',\
\n'6HC', 'X',\n'6HG', 'X',\n'6HT', 'X',\n'6IN', 'X\
',\n'6MO', 'X',\n'6MP', 'X',\n'6PG', 'X',\n'6WO', \
'X',\n'70U', 'X',\n'7DG', 'X',\n'7HP', 'X',\n'7I2'\
, 'X',\n'7MG', 'X',\n'7MQ', 'X',\n'7NI', 'X',\n'87\
Y', 'X',\n'8AD', 'X',\n'8BR', 'X',\n'8IG', 'X',\n'\
8IN', 'X',\n'8OG', 'X',\n'95A', 'X',\n'9AD', 'X',\\
n'9AM', 'X',\n'9AP', 'X',\n'9DG', 'X',\n'9DI', 'X'\
,\n'9HX', 'X',\n'9OH', 'X',\n'9TA', 'X',\n'A12', '\
X',\n'A15', 'X',\n'A23', 'X',\n'A24', 'X',\n'A26',\
 'X',\n'A2G', 'X',\n'A2P', 'X',\n'A32', 'X',\n'A3P\
', 'X',\n'A4P', 'X',\n'A5P', 'X',\n'A70', 'X',\n'A\
76', 'X',\n'A77', 'X',\n'A78', 'X',\n'A79', 'X',\n\
'A80', 'X',\n'A85', 'X',\n'A88', 'X',\n'A9A', 'X',\
\n'AA3', 'X',\n'AA4', 'X',\n'AA6', 'X',\n'AAA', 'X\
',\n'AAB', 'X',\n'AAC', 'X',\n'AAE', 'X',\n'AAG', \
'R',\n'AAH', 'X',\n'AAM', 'X',\n'AAN', 'X',\n'AAP'\
, 'X',\n'AAR', 'R',\n'AAS', 'X',\n'AAT', 'X',\n'AB\
A', 'X',\n'ABC', 'X',\n'ABD', 'X',\n'ABE', 'X',\n'\
ABH', 'X',\n'ABI', 'X',\n'ABK', 'X',\n'ABM', 'X',\\
n'ABN', 'X',\n'ABP', 'X',\n'ABR', 'X',\n'ABS', 'X'\
,\n'ABU', 'X',\n'AC1', 'X',\n'AC2', 'X',\n'ACA', '\
X',\n'ACB', 'D',\n'ACC', 'C',\n'ACD', 'X',\n'ACE',\
 'X',\n'ACH', 'X',\n'ACI', 'X',\n'ACL', 'R',\n'ACM\
', 'X',\n'ACN', 'X',\n'ACO', 'X',\n'ACP', 'X',\n'A\
CQ', 'X',\n'ACR', 'X',\n'ACS', 'X',\n'ACT', 'X',\n\
'ACV', 'V',\n'ACX', 'X',\n'ACY', 'X',\n'AD2', 'X',\
\n'AD3', 'X',\n'ADC', 'X',\n'ADD', 'X',\n'ADE', 'X\
',\n'ADH', 'X',\n'ADI', 'X',\n'ADM', 'X',\n'ADN', \
'X',\n'ADP', 'X',\n'ADQ', 'X',\n'ADR', 'X',\n'ADS'\
, 'X',\n'ADT', 'X',\n'ADU', 'X',\n'ADW', 'X',\n'AD\
X', 'X',\n'AE2', 'X',\n'AEA', 'X',\n'AEB', 'X',\n'\
AEI', 'D',\n'AEN', 'X',\n'AET', 'T',\n'AF1', 'X',\\
n'AF3', 'X',\n'AFA', 'D',\n'AFP', 'X',\n'AG7', 'X'\
,\n'AGB', 'X',\n'AGF', 'X',\n'AGL', 'X',\n'AGM', '\
R',\n'AGN', 'X',\n'AGP', 'X',\n'AGS', 'X',\n'AGU',\
 'X',\n'AH0', 'X',\n'AH1', 'X',\n'AHA', 'X',\n'AHB\
', 'D',\n'AHC', 'X',\n'AHF', 'X',\n'AHG', 'X',\n'A\
HH', 'X',\n'AHM', 'X',\n'AHO', 'X',\n'AHP', 'X',\n\
'AHS', 'X',\n'AHT', 'Y',\n'AHU', 'X',\n'AHX', 'X',\
\n'AI1', 'X',\n'AI2', 'X',\n'AIB', 'X',\n'AIC', 'X\
',\n'AIM', 'X',\n'AIP', 'X',\n'AIQ', 'X',\n'AIR', \
'X',\n'AJ3', 'X',\n'AKB', 'X',\n'AKG', 'X',\n'AKR'\
, 'X',\n'AL1', 'X',\n'AL2', 'X',\n'AL3', 'X',\n'AL\
4', 'X',\n'AL5', 'X',\n'AL6', 'X',\n'AL7', 'X',\n'\
AL8', 'X',\n'AL9', 'X',\n'ALA', 'A',\n'ALB', 'X',\\
n'ALC', 'X',\n'ALD', 'L',\n'ALE', 'X',\n'ALF', 'X'\
,\n'ALG', 'X',\n'ALL', 'X',\n'ALM', 'A',\n'ALN', '\
A',\n'ALO', 'T',\n'ALP', 'X',\n'ALQ', 'X',\n'ALR',\
 'X',\n'ALS', 'X',\n'ALT', 'A',\n'ALY', 'K',\n'ALZ\
', 'X',\n'AMA', 'X',\n'AMB', 'X',\n'AMC', 'X',\n'A\
MD', 'X',\n'AMG', 'X',\n'AMH', 'X',\n'AMI', 'X',\n\
'AML', 'X',\n'AMN', 'X',\n'AMO', 'X',\n'AMP', 'X',\
\n'AMQ', 'X',\n'AMR', 'X',\n'AMS', 'X',\n'AMT', 'X\
',\n'AMU', 'X',\n'AMW', 'X',\n'AMX', 'X',\n'AMY', \
'X',\n'ANA', 'X',\n'ANB', 'X',\n'ANC', 'X',\n'AND'\
, 'X',\n'ANE', 'X',\n'ANI', 'X',\n'ANL', 'X',\n'AN\
O', 'X',\n'ANP', 'X',\n'ANS', 'X',\n'ANT', 'X',\n'\
AOE', 'X',\n'AOP', 'X',\n'AP1', 'X',\n'AP2', 'X',\\
n'AP3', 'X',\n'AP4', 'X',\n'AP5', 'X',\n'AP6', 'X'\
,\n'APA', 'X',\n'APB', 'X',\n'APC', 'X',\n'APE', '\
F',\n'APF', 'X',\n'APG', 'X',\n'APH', 'A',\n'API',\
 'X',\n'APL', 'X',\n'APM', 'X',\n'APN', 'G',\n'APP\
', 'X',\n'APQ', 'X',\n'APR', 'X',\n'APS', 'X',\n'A\
PT', 'X',\n'APU', 'X',\n'APX', 'X',\n'APY', 'X',\n\
'APZ', 'X',\n'AQS', 'X',\n'AR1', 'X',\n'AR2', 'X',\
\n'ARA', 'X',\n'ARB', 'X',\n'ARC', 'X',\n'ARD', 'X\
',\n'ARG', 'R',\n'ARH', 'X',\n'ARI', 'X',\n'ARM', \
'R',\n'ARN', 'X',\n'ARO', 'R',\n'ARP', 'X',\n'ARQ'\
, 'X',\n'ARS', 'X',\n'AS1', 'R',\n'AS2', 'X',\n'AS\
A', 'D',\n'ASB', 'D',\n'ASC', 'X',\n'ASD', 'X',\n'\
ASE', 'X',\n'ASF', 'X',\n'ASI', 'X',\n'ASK', 'D',\\
n'ASL', 'X',\n'ASM', 'N',\n'ASO', 'X',\n'ASP', 'D'\
,\n'ASQ', 'X',\n'ASU', 'X',\n'ATA', 'X',\n'ATC', '\
X',\n'ATD', 'X',\n'ATF', 'X',\n'ATG', 'X',\n'ATH',\
 'X',\n'ATM', 'X',\n'ATO', 'X',\n'ATP', 'X',\n'ATQ\
', 'X',\n'ATR', 'X',\n'ATT', 'X',\n'ATY', 'X',\n'A\
TZ', 'X',\n'AUC', 'X',\n'AUR', 'X',\n'AVG', 'X',\n\
'AXP', 'X',\n'AYA', 'A',\n'AZ2', 'X',\n'AZA', 'X',\
\n'AZC', 'X',\n'AZD', 'X',\n'AZE', 'X',\n'AZI', 'X\
',\n'AZL', 'X',\n'AZM', 'X',\n'AZR', 'X',\n'AZT', \
'X',\n'B12', 'X',\n'B1F', 'F',\n'B2A', 'A',\n'B2F'\
, 'F',\n'B2I', 'I',\n'B2V', 'V',\n'B3I', 'X',\n'B3\
P', 'X',\n'B7G', 'X',\n'B96', 'X',\n'B9A', 'X',\n'\
BA1', 'X',\n'BAA', 'X',\n'BAB', 'X',\n'BAC', 'X',\\
n'BAF', 'X',\n'BAH', 'X',\n'BAI', 'X',\n'BAK', 'X'\
,\n'BAL', 'A',\n'BAM', 'X',\n'BAO', 'X',\n'BAP', '\
X',\n'BAR', 'X',\n'BAS', 'X',\n'BAT', 'F',\n'BAY',\
 'X',\n'BAZ', 'X',\n'BB1', 'X',\n'BB2', 'X',\n'BBA\
', 'X',\n'BBH', 'X',\n'BBS', 'X',\n'BBT', 'X',\n'B\
BZ', 'X',\n'BCA', 'X',\n'BCB', 'X',\n'BCC', 'X',\n\
'BCD', 'X',\n'BCL', 'X',\n'BCN', 'X',\n'BCR', 'X',\
\n'BCS', 'C',\n'BCT', 'X',\n'BCY', 'X',\n'BCZ', 'X\
',\n'BDA', 'X',\n'BDG', 'X',\n'BDK', 'X',\n'BDM', \
'X',\n'BDN', 'X',\n'BDS', 'X',\n'BE1', 'X',\n'BE2'\
, 'X',\n'BEA', 'X',\n'BEF', 'X',\n'BEN', 'X',\n'BE\
O', 'X',\n'BEP', 'X',\n'BER', 'X',\n'BES', 'X',\n'\
BET', 'X',\n'BEZ', 'X',\n'BF2', 'X',\n'BFA', 'X',\\
n'BFD', 'X',\n'BFP', 'X',\n'BFS', 'X',\n'BFU', 'X'\
,\n'BG6', 'X',\n'BGF', 'X',\n'BGG', 'X',\n'BGL', '\
X',\n'BGN', 'X',\n'BGP', 'X',\n'BGX', 'X',\n'BH4',\
 'X',\n'BHA', 'X',\n'BHC', 'X',\n'BHD', 'D',\n'BHO\
', 'X',\n'BHS', 'X',\n'BIC', 'X',\n'BIN', 'X',\n'B\
IO', 'X',\n'BIP', 'X',\n'BIS', 'X',\n'BIZ', 'X',\n\
'BJH', 'X',\n'BJI', 'X',\n'BJP', 'X',\n'BLA', 'X',\
\n'BLB', 'X',\n'BLE', 'L',\n'BLG', 'P',\n'BLI', 'X\
',\n'BLM', 'X',\n'BLV', 'X',\n'BLY', 'K',\n'BM1', \
'X',\n'BM2', 'X',\n'BM5', 'X',\n'BM9', 'X',\n'BMA'\
, 'X',\n'BMD', 'X',\n'BME', 'X',\n'BMP', 'X',\n'BM\
Q', 'X',\n'BMS', 'X',\n'BMT', 'T',\n'BMU', 'X',\n'\
BMY', 'X',\n'BMZ', 'X',\n'BNA', 'X',\n'BNG', 'X',\\
n'BNI', 'X',\n'BNN', 'F',\n'BNO', 'L',\n'BNS', 'X'\
,\n'BNZ', 'X',\n'BO3', 'X',\n'BO4', 'X',\n'BOC', '\
X',\n'BOG', 'X',\n'BOM', 'X',\n'BOT', 'X',\n'BOX',\
 'X',\n'BOZ', 'X',\n'BPA', 'X',\n'BPB', 'X',\n'BPD\
', 'X',\n'BPG', 'X',\n'BPH', 'X',\n'BPI', 'X',\n'B\
PJ', 'X',\n'BPM', 'X',\n'BPN', 'X',\n'BPO', 'X',\n\
'BPP', 'X',\n'BPT', 'X',\n'BPY', 'X',\n'BRB', 'X',\
\n'BRC', 'X',\n'BRE', 'X',\n'BRI', 'X',\n'BRL', 'X\
',\n'BRM', 'X',\n'BRN', 'X',\n'BRO', 'X',\n'BRS', \
'X',\n'BRU', 'X',\n'BRZ', 'X',\n'BSB', 'X',\n'BSI'\
, 'X',\n'BSP', 'X',\n'BT1', 'X',\n'BT2', 'X',\n'BT\
3', 'X',\n'BTA', 'L',\n'BTB', 'X',\n'BTC', 'C',\n'\
BTD', 'X',\n'BTN', 'X',\n'BTP', 'X',\n'BTR', 'W',\\
n'BU1', 'X',\n'BUA', 'X',\n'BUB', 'X',\n'BUC', 'X'\
,\n'BUG', 'X',\n'BUL', 'X',\n'BUM', 'X',\n'BUQ', '\
X',\n'BUT', 'X',\n'BVD', 'X',\n'BX3', 'X',\n'BYS',\
 'X',\n'BZ1', 'X',\n'BZA', 'X',\n'BZB', 'X',\n'BZC\
', 'X',\n'BZD', 'X',\n'BZF', 'X',\n'BZI', 'X',\n'B\
ZM', 'X',\n'BZO', 'X',\n'BZP', 'X',\n'BZQ', 'X',\n\
'BZS', 'X',\n'BZT', 'X',\n'C02', 'X',\n'C11', 'X',\
\n'C1O', 'X',\n'C20', 'X',\n'C24', 'X',\n'C2F', 'X\
',\n'C2O', 'X',\n'C2P', 'X',\n'C3M', 'X',\n'C3P', \
'X',\n'C3X', 'X',\n'C48', 'X',\n'C4M', 'X',\n'C4X'\
, 'X',\n'C5C', 'X',\n'C5M', 'X',\n'C5P', 'X',\n'C5\
X', 'X',\n'C60', 'X',\n'C6C', 'X',\n'C6M', 'X',\n'\
C78', 'X',\n'C8E', 'X',\n'CA3', 'X',\n'CA5', 'X',\\
n'CAA', 'X',\n'CAB', 'X',\n'CAC', 'X',\n'CAD', 'X'\
,\n'CAF', 'C',\n'CAG', 'X',\n'CAH', 'X',\n'CAL', '\
X',\n'CAM', 'X',\n'CAN', 'X',\n'CAO', 'X',\n'CAP',\
 'X',\n'CAQ', 'X',\n'CAR', 'X',\n'CAS', 'C',\n'CAT\
', 'X',\n'CAV', 'X',\n'CAY', 'C',\n'CAZ', 'X',\n'C\
B3', 'X',\n'CB4', 'X',\n'CBA', 'X',\n'CBD', 'X',\n\
'CBG', 'X',\n'CBI', 'X',\n'CBL', 'X',\n'CBM', 'X',\
\n'CBN', 'X',\n'CBO', 'X',\n'CBP', 'X',\n'CBS', 'X\
',\n'CBX', 'X',\n'CBZ', 'X',\n'CC0', 'X',\n'CC1', \
'X',\n'CCC', 'X',\n'CCH', 'X',\n'CCI', 'X',\n'CCM'\
, 'X',\n'CCN', 'X',\n'CCO', 'X',\n'CCP', 'X',\n'CC\
R', 'X',\n'CCS', 'C',\n'CCV', 'X',\n'CCY', 'X',\n'\
CD1', 'X',\n'CDC', 'X',\n'CDE', 'X',\n'CDF', 'X',\\
n'CDI', 'X',\n'CDL', 'X',\n'CDM', 'X',\n'CDP', 'X'\
,\n'CDR', 'X',\n'CDU', 'X',\n'CE1', 'X',\n'CEA', '\
C',\n'CEB', 'X',\n'CEC', 'X',\n'CED', 'X',\n'CEF',\
 'X',\n'CEH', 'X',\n'CEM', 'X',\n'CEO', 'X',\n'CEP\
', 'X',\n'CEQ', 'X',\n'CER', 'X',\n'CES', 'G',\n'C\
ET', 'X',\n'CFC', 'X',\n'CFF', 'X',\n'CFM', 'X',\n\
'CFO', 'X',\n'CFP', 'X',\n'CFS', 'X',\n'CFX', 'X',\
\n'CGN', 'X',\n'CGP', 'X',\n'CGS', 'X',\n'CGU', 'E\
',\n'CH2', 'X',\n'CH3', 'X',\n'CHA', 'X',\n'CHB', \
'X',\n'CHD', 'X',\n'CHF', 'X',\n'CHG', 'G',\n'CHI'\
, 'X',\n'CHN', 'X',\n'CHO', 'X',\n'CHP', 'G',\n'CH\
R', 'X',\n'CHS', 'F',\n'CHT', 'X',\n'CHX', 'X',\n'\
CIC', 'X',\n'CIN', 'X',\n'CIP', 'X',\n'CIR', 'X',\\
n'CIT', 'X',\n'CIU', 'X',\n'CKI', 'X',\n'CL1', 'X'\
,\n'CL2', 'X',\n'CLA', 'X',\n'CLB', 'A',\n'CLC', '\
S',\n'CLD', 'A',\n'CLE', 'L',\n'CLF', 'X',\n'CLK',\
 'S',\n'CLL', 'X',\n'CLM', 'X',\n'CLN', 'X',\n'CLO\
', 'X',\n'CLP', 'X',\n'CLQ', 'X',\n'CLR', 'X',\n'C\
LS', 'X',\n'CLT', 'X',\n'CLX', 'X',\n'CLY', 'X',\n\
'CMA', 'R',\n'CMC', 'X',\n'CMD', 'X',\n'CME', 'C',\
\n'CMG', 'X',\n'CMK', 'X',\n'CMN', 'X',\n'CMO', 'X\
',\n'CMP', 'X',\n'CMR', 'X',\n'CMS', 'X',\n'CMT', \
'C',\n'CMX', 'X',\n'CNA', 'X',\n'CNC', 'X',\n'CND'\
, 'X',\n'CNH', 'X',\n'CNM', 'X',\n'CNN', 'X',\n'CN\
O', 'X',\n'CNP', 'X',\n'CO2', 'X',\n'CO3', 'X',\n'\
CO5', 'X',\n'CO8', 'X',\n'COA', 'X',\n'COB', 'X',\\
n'COC', 'X',\n'COD', 'X',\n'COE', 'X',\n'COF', 'X'\
,\n'COH', 'X',\n'COI', 'X',\n'COJ', 'X',\n'COL', '\
X',\n'COM', 'X',\n'CON', 'X',\n'COP', 'X',\n'COR',\
 'X',\n'COS', 'X',\n'COT', 'X',\n'COY', 'X',\n'CP1\
', 'G',\n'CP2', 'X',\n'CP4', 'X',\n'CPA', 'X',\n'C\
PB', 'X',\n'CPC', 'X',\n'CPD', 'X',\n'CPG', 'X',\n\
'CPH', 'X',\n'CPI', 'X',\n'CPM', 'X',\n'CPN', 'G',\
\n'CPO', 'X',\n'CPP', 'X',\n'CPQ', 'X',\n'CPR', 'X\
',\n'CPS', 'X',\n'CPT', 'X',\n'CPU', 'X',\n'CPV', \
'X',\n'CPY', 'X',\n'CR1', 'X',\n'CR6', 'X',\n'CRA'\
, 'X',\n'CRB', 'X',\n'CRC', 'X',\n'CRG', 'X',\n'CR\
H', 'X',\n'CRO', 'T',\n'CRP', 'X',\n'CRQ', 'X',\n'\
CRS', 'X',\n'CRT', 'X',\n'CRY', 'X',\n'CSA', 'C',\\
n'CSB', 'X',\n'CSD', 'C',\n'CSE', 'C',\n'CSH', 'X'\
,\n'CSI', 'X',\n'CSN', 'X',\n'CSO', 'C',\n'CSP', '\
C',\n'CSR', 'C',\n'CSS', 'C',\n'CST', 'X',\n'CSW',\
 'C',\n'CSX', 'C',\n'CSY', 'X',\n'CSZ', 'C',\n'CT3\
', 'X',\n'CTA', 'X',\n'CTB', 'X',\n'CTC', 'X',\n'C\
TD', 'X',\n'CTH', 'T',\n'CTO', 'X',\n'CTP', 'X',\n\
'CTR', 'X',\n'CTS', 'X',\n'CTT', 'X',\n'CTY', 'X',\
\n'CTZ', 'X',\n'CU1', 'X',\n'CUA', 'X',\n'CUC', 'X\
',\n'CUL', 'X',\n'CUO', 'X',\n'CUZ', 'X',\n'CVI', \
'X',\n'CXF', 'X',\n'CXL', 'X',\n'CXM', 'M',\n'CXN'\
, 'X',\n'CXP', 'X',\n'CXS', 'X',\n'CY1', 'C',\n'CY\
3', 'X',\n'CYB', 'X',\n'CYC', 'X',\n'CYF', 'C',\n'\
CYG', 'C',\n'CYH', 'X',\n'CYL', 'X',\n'CYM', 'C',\\
n'CYN', 'X',\n'CYO', 'X',\n'CYP', 'X',\n'CYQ', 'C'\
,\n'CYS', 'C',\n'CYU', 'X',\n'CYY', 'X',\n'CYZ', '\
X',\n'CZH', 'X',\n'CZZ', 'C',\n'D12', 'X',\n'D13',\
 'X',\n'D16', 'X',\n'D18', 'X',\n'D19', 'X',\n'D1P\
', 'X',\n'D24', 'X',\n'D34', 'X',\n'D35', 'X',\n'D\
4D', 'X',\n'D4T', 'X',\n'D6G', 'X',\n'DA2', 'R',\n\
'DA3', 'X',\n'DA6', 'X',\n'DA7', 'X',\n'DAA', 'X',\
\n'DAB', 'X',\n'DAC', 'X',\n'DAD', 'X',\n'DAE', 'X\
',\n'DAF', 'X',\n'DAG', 'X',\n'DAH', 'A',\n'DAJ', \
'X',\n'DAK', 'X',\n'DAL', 'A',\n'DAM', 'A',\n'DAN'\
, 'X',\n'DAO', 'X',\n'DAP', 'X',\n'DAQ', 'X',\n'DA\
R', 'R',\n'DAS', 'D',\n'DAT', 'X',\n'DAU', 'X',\n'\
DAV', 'X',\n'DBA', 'X',\n'DBD', 'X',\n'DBF', 'X',\\
n'DBG', 'X',\n'DBI', 'X',\n'DBV', 'X',\n'DBY', 'Y'\
,\n'DCA', 'X',\n'DCB', 'X',\n'DCE', 'X',\n'DCF', '\
X',\n'DCG', 'X',\n'DCH', 'X',\n'DCI', 'I',\n'DCL',\
 'X',\n'DCM', 'X',\n'DCP', 'X',\n'DCS', 'X',\n'DCT\
', 'X',\n'DCY', 'C',\n'DCZ', 'X',\n'DDA', 'X',\n'D\
DB', 'X',\n'DDC', 'X',\n'DDF', 'X',\n'DDG', 'X',\n\
'DDH', 'X',\n'DDL', 'X',\n'DDM', 'X',\n'DDO', 'L',\
\n'DDP', 'X',\n'DDQ', 'X',\n'DDT', 'Y',\n'DDU', 'X\
',\n'DEA', 'X',\n'DEB', 'X',\n'DEC', 'X',\n'DEF', \
'X',\n'DEL', 'X',\n'DEM', 'X',\n'DEN', 'X',\n'DEP'\
, 'X',\n'DEQ', 'X',\n'DES', 'X',\n'DET', 'X',\n'DF\
C', 'X',\n'DFG', 'X',\n'DFI', 'X',\n'DFL', 'X',\n'\
DFO', 'X',\n'DFP', 'X',\n'DFR', 'X',\n'DFT', 'X',\\
n'DFV', 'X',\n'DFX', 'X',\n'DG2', 'X',\n'DG3', 'X'\
,\n'DG6', 'X',\n'DGA', 'X',\n'DGD', 'X',\n'DGG', '\
X',\n'DGL', 'E',\n'DGN', 'Q',\n'DGP', 'X',\n'DGT',\
 'X',\n'DGX', 'X',\n'DH2', 'X',\n'DHA', 'A',\n'DHB\
', 'X',\n'DHC', 'X',\n'DHD', 'X',\n'DHE', 'X',\n'D\
HF', 'X',\n'DHG', 'X',\n'DHI', 'H',\n'DHL', 'X',\n\
'DHM', 'X',\n'DHN', 'V',\n'DHP', 'X',\n'DHQ', 'X',\
\n'DHR', 'X',\n'DHS', 'X',\n'DHT', 'X',\n'DHU', 'X\
',\n'DHY', 'X',\n'DHZ', 'X',\n'DI2', 'X',\n'DI3', \
'G',\n'DI4', 'X',\n'DI5', 'X',\n'DIA', 'X',\n'DIC'\
, 'X',\n'DIF', 'X',\n'DIG', 'X',\n'DII', 'X',\n'DI\
L', 'I',\n'DIM', 'X',\n'DIO', 'X',\n'DIP', 'X',\n'\
DIQ', 'X',\n'DIS', 'X',\n'DIT', 'X',\n'DIV', 'V',\\
n'DIX', 'X',\n'DIY', 'X',\n'DKA', 'X',\n'DLA', 'X'\
,\n'DLE', 'L',\n'DLF', 'X',\n'DLS', 'K',\n'DLY', '\
K',\n'DM1', 'X',\n'DM2', 'X',\n'DM3', 'X',\n'DM4',\
 'X',\n'DM5', 'X',\n'DM6', 'X',\n'DM7', 'X',\n'DM8\
', 'X',\n'DM9', 'X',\n'DMA', 'X',\n'DMB', 'X',\n'D\
MC', 'X',\n'DMD', 'X',\n'DME', 'X',\n'DMF', 'X',\n\
'DMG', 'G',\n'DMH', 'N',\n'DMI', 'X',\n'DMJ', 'X',\
\n'DML', 'X',\n'DMM', 'X',\n'DMN', 'X',\n'DMO', 'X\
',\n'DMP', 'X',\n'DMQ', 'X',\n'DMR', 'X',\n'DMS', \
'X',\n'DMT', 'X',\n'DMV', 'X',\n'DMY', 'X',\n'DNC'\
, 'X',\n'DND', 'X',\n'DNH', 'X',\n'DNJ', 'X',\n'DN\
N', 'X',\n'DNP', 'X',\n'DNQ', 'X',\n'DNR', 'X',\n'\
DO2', 'X',\n'DO3', 'X',\n'DOA', 'X',\n'DOB', 'X',\\
n'DOC', 'X',\n'DOH', 'D',\n'DOM', 'X',\n'DOS', 'X'\
,\n'DOX', 'X',\n'DP5', 'X',\n'DP7', 'X',\n'DPA', '\
X',\n'DPC', 'X',\n'DPD', 'X',\n'DPE', 'X',\n'DPG',\
 'X',\n'DPH', 'F',\n'DPM', 'X',\n'DPN', 'F',\n'DPO\
', 'X',\n'DPP', 'X',\n'DPR', 'P',\n'DPS', 'X',\n'D\
PT', 'X',\n'DPX', 'X',\n'DPY', 'X',\n'DPZ', 'X',\n\
'DQH', 'X',\n'DQN', 'X',\n'DR1', 'X',\n'DRB', 'X',\
\n'DRC', 'X',\n'DRI', 'X',\n'DRP', 'X',\n'DRT', 'X\
',\n'DRU', 'X',\n'DSA', 'X',\n'DSB', 'X',\n'DSC', \
'X',\n'DSD', 'X',\n'DSE', 'S',\n'DSI', 'X',\n'DSN'\
, 'S',\n'DSP', 'D',\n'DSR', 'X',\n'DSS', 'X',\n'DS\
X', 'X',\n'DSY', 'X',\n'DTB', 'X',\n'DTD', 'X',\n'\
DTH', 'T',\n'DTN', 'X',\n'DTO', 'X',\n'DTP', 'X',\\
n'DTQ', 'X',\n'DTR', 'W',\n'DTT', 'X',\n'DTY', 'Y'\
,\n'DUD', 'X',\n'DUO', 'X',\n'DUR', 'X',\n'DUT', '\
X',\n'DVA', 'V',\n'DVR', 'X',\n'DX9', 'X',\n'DXA',\
 'X',\n'DXB', 'X',\n'DXC', 'X',\n'DXG', 'X',\n'DXX\
', 'X',\n'DZF', 'X',\n'E09', 'X',\n'E20', 'X',\n'E\
2P', 'X',\n'E3G', 'X',\n'E4N', 'X',\n'E4P', 'X',\n\
'E64', 'X',\n'E6C', 'X',\n'E96', 'X',\n'E97', 'X',\
\n'EA2', 'X',\n'EAA', 'X',\n'EAP', 'X',\n'EBP', 'X\
',\n'EBW', 'X',\n'ECO', 'X',\n'EDA', 'X',\n'EDC', \
'X',\n'EDE', 'X',\n'EDO', 'X',\n'EDR', 'X',\n'EEB'\
, 'X',\n'EEE', 'X',\n'EFC', 'X',\n'EFZ', 'X',\n'EG\
1', 'X',\n'EG2', 'X',\n'EG3', 'X',\n'EGC', 'X',\n'\
EGL', 'X',\n'EHP', 'A',\n'EIC', 'X',\n'EJT', 'X',\\
n'ELA', 'X',\n'EMB', 'X',\n'EMC', 'X',\n'EMD', 'X'\
,\n'EMM', 'X',\n'EMO', 'X',\n'EMP', 'X',\n'EMR', '\
X',\n'ENA', 'X',\n'ENC', 'X',\n'ENH', 'X',\n'ENO',\
 'X',\n'ENP', 'X',\n'EOA', 'X',\n'EOH', 'X',\n'EOT\
', 'X',\n'EOX', 'X',\n'EPA', 'X',\n'EPE', 'X',\n'E\
PH', 'X',\n'EPI', 'X',\n'EPN', 'X',\n'EPO', 'X',\n\
'EPT', 'X',\n'EPU', 'X',\n'EPX', 'X',\n'EPY', 'X',\
\n'EQI', 'X',\n'EQP', 'X',\n'EQU', 'X',\n'ERG', 'X\
',\n'ERI', 'X',\n'ERY', 'X',\n'ESC', 'X',\n'ESD', \
'X',\n'ESI', 'X',\n'ESO', 'X',\n'ESP', 'X',\n'EST'\
, 'X',\n'ESX', 'X',\n'ETA', 'X',\n'ETC', 'X',\n'ET\
D', 'X',\n'ETF', 'X',\n'ETH', 'X',\n'ETI', 'X',\n'\
ETN', 'X',\n'ETO', 'X',\n'ETP', 'X',\n'ETR', 'X',\\
n'ETS', 'X',\n'ETY', 'X',\n'EU3', 'X',\n'EUG', 'X'\
,\n'EYS', 'C',\n'F09', 'X',\n'F2B', 'X',\n'F3S', '\
X',\n'F42', 'X',\n'F43', 'X',\n'F4S', 'X',\n'F6B',\
 'X',\n'F6P', 'X',\n'F89', 'X',\n'FA1', 'X',\n'FA5\
', 'F',\n'FAA', 'X',\n'FAB', 'X',\n'FAC', 'X',\n'F\
AD', 'X',\n'FAF', 'X',\n'FAG', 'X',\n'FAM', 'X',\n\
'FAR', 'X',\n'FAS', 'X',\n'FAT', 'X',\n'FBA', 'X',\
\n'FBE', 'X',\n'FBI', 'X',\n'FBP', 'X',\n'FBQ', 'X\
',\n'FBS', 'X',\n'FBT', 'X',\n'FBU', 'X',\n'FCA', \
'X',\n'FCB', 'X',\n'FCI', 'X',\n'FCN', 'X',\n'FCO'\
, 'X',\n'FCR', 'X',\n'FCT', 'X',\n'FCX', 'X',\n'FC\
Y', 'C',\n'FD1', 'F',\n'FD2', 'F',\n'FD3', 'F',\n'\
FD4', 'F',\n'FDA', 'X',\n'FDC', 'X',\n'FDI', 'X',\\
n'FDP', 'X',\n'FDS', 'X',\n'FE2', 'X',\n'FEA', 'X'\
,\n'FEL', 'X',\n'FEM', 'X',\n'FEN', 'X',\n'FEO', '\
X',\n'FEP', 'X',\n'FER', 'X',\n'FES', 'X',\n'FFB',\
 'X',\n'FFC', 'X',\n'FFF', 'X',\n'FFO', 'X',\n'FGL\
', 'G',\n'FHB', 'X',\n'FHC', 'X',\n'FHP', 'X',\n'F\
HU', 'X',\n'FID', 'X',\n'FII', 'X',\n'FIP', 'X',\n\
'FK5', 'X',\n'FKA', 'X',\n'FKI', 'X',\n'FKP', 'X',\
\n'FL2', 'X',\n'FL9', 'X',\n'FLA', 'A',\n'FLC', 'X\
',\n'FLD', 'X',\n'FLE', 'L',\n'FLF', 'X',\n'FLO', \
'X',\n'FLP', 'X',\n'FLT', 'Y',\n'FLU', 'X',\n'FLX'\
, 'X',\n'FM1', 'X',\n'FM2', 'X',\n'FMA', 'X',\n'FM\
B', 'X',\n'FMC', 'X',\n'FME', 'M',\n'FMN', 'X',\n'\
FMP', 'X',\n'FMR', 'X',\n'FMS', 'X',\n'FMT', 'X',\\
n'FNE', 'X',\n'FNP', 'X',\n'FNS', 'X',\n'FOC', 'X'\
,\n'FOE', 'X',\n'FOG', 'F',\n'FOH', 'X',\n'FOK', '\
X',\n'FOL', 'X',\n'FON', 'X',\n'FOP', 'X',\n'FOR',\
 'X',\n'FOS', 'X',\n'FPA', 'X',\n'FPC', 'X',\n'FPI\
', 'X',\n'FPO', 'X',\n'FPP', 'X',\n'FPT', 'X',\n'F\
QP', 'X',\n'FRA', 'X',\n'FRD', 'F',\n'FRU', 'X',\n\
'FS3', 'X',\n'FS4', 'X',\n'FSB', 'X',\n'FSO', 'X',\
\n'FSX', 'X',\n'FTC', 'X',\n'FTP', 'X',\n'FTR', 'W\
',\n'FTT', 'X',\n'FTY', 'Y',\n'FUA', 'X',\n'FUC', \
'X',\n'FUM', 'X',\n'FUP', 'X',\n'FVF', 'X',\n'FXP'\
, 'X',\n'FXV', 'X',\n'FYA', 'F',\n'G16', 'X',\n'G1\
P', 'X',\n'G20', 'X',\n'G21', 'X',\n'G23', 'X',\n'\
G26', 'X',\n'G28', 'X',\n'G2F', 'X',\n'G37', 'X',\\
n'G39', 'X',\n'G3H', 'X',\n'G3P', 'X',\n'G4D', 'X'\
,\n'G6D', 'X',\n'G6P', 'X',\n'G6Q', 'X',\n'G7M', '\
X',\n'GA2', 'X',\n'GAA', 'X',\n'GAB', 'X',\n'GAC',\
 'X',\n'GAI', 'X',\n'GAL', 'X',\n'GAM', 'X',\n'GAN\
', 'X',\n'GAO', 'X',\n'GAP', 'X',\n'GAR', 'G',\n'G\
AS', 'X',\n'GAT', 'X',\n'GBC', 'X',\n'GBI', 'X',\n\
'GBP', 'X',\n'GBS', 'X',\n'GBX', 'X',\n'GC4', 'X',\
\n'GCA', 'X',\n'GCD', 'X',\n'GCG', 'G',\n'GCH', 'G\
',\n'GCK', 'X',\n'GCL', 'X',\n'GCM', 'X',\n'GCN', \
'X',\n'GCO', 'X',\n'GCP', 'X',\n'GCR', 'X',\n'GCS'\
, 'X',\n'GCU', 'X',\n'GD3', 'X',\n'GDB', 'X',\n'GD\
M', 'X',\n'GDN', 'X',\n'GDP', 'X',\n'GDS', 'X',\n'\
GDU', 'X',\n'GE1', 'X',\n'GE2', 'X',\n'GE3', 'X',\\
n'GEA', 'X',\n'GEL', 'X',\n'GEM', 'X',\n'GEN', 'X'\
,\n'GEP', 'X',\n'GER', 'X',\n'GFP', 'X',\n'GGB', '\
X',\n'GGL', 'E',\n'GGP', 'X',\n'GHP', 'G',\n'GIP',\
 'X',\n'GIS', 'X',\n'GKR', 'X',\n'GL2', 'X',\n'GL3\
', 'G',\n'GL4', 'X',\n'GL5', 'X',\n'GL7', 'X',\n'G\
L9', 'X',\n'GLA', 'X',\n'GLB', 'X',\n'GLC', 'X',\n\
'GLD', 'X',\n'GLE', 'X',\n'GLF', 'X',\n'GLG', 'X',\
\n'GLH', 'Q',\n'GLI', 'X',\n'GLL', 'X',\n'GLM', 'G\
',\n'GLN', 'Q',\n'GLO', 'X',\n'GLP', 'X',\n'GLR', \
'X',\n'GLS', 'X',\n'GLT', 'X',\n'GLU', 'E',\n'GLV'\
, 'X',\n'GLW', 'X',\n'GLY', 'G',\n'GLZ', 'X',\n'GM\
1', 'X',\n'GMA', 'X',\n'GMC', 'X',\n'GMH', 'X',\n'\
GMP', 'X',\n'GMY', 'X',\n'GN7', 'X',\n'GNA', 'X',\\
n'GNB', 'X',\n'GNH', 'X',\n'GNP', 'X',\n'GNT', 'X'\
,\n'GOA', 'X',\n'GOL', 'X',\n'GOX', 'X',\n'GP1', '\
X',\n'GP3', 'X',\n'GP4', 'X',\n'GP6', 'X',\n'GP8',\
 'X',\n'GPB', 'E',\n'GPC', 'X',\n'GPE', 'X',\n'GPG\
', 'X',\n'GPI', 'X',\n'GPJ', 'X',\n'GPL', 'K',\n'G\
PM', 'X',\n'GPN', 'G',\n'GPP', 'X',\n'GPR', 'X',\n\
'GPS', 'X',\n'GPX', 'X',\n'GR1', 'X',\n'GR3', 'X',\
\n'GR4', 'X',\n'GSA', 'X',\n'GSB', 'X',\n'GSC', 'G\
',\n'GSE', 'S',\n'GSH', 'X',\n'GSP', 'X',\n'GSR', \
'X',\n'GSS', 'X',\n'GT9', 'C',\n'GTA', 'X',\n'GTB'\
, 'X',\n'GTD', 'X',\n'GTE', 'X',\n'GTH', 'T',\n'GT\
N', 'X',\n'GTO', 'X',\n'GTP', 'X',\n'GTR', 'X',\n'\
GTS', 'X',\n'GTT', 'X',\n'GTX', 'X',\n'GTZ', 'X',\\
n'GU7', 'X',\n'GUA', 'X',\n'GUD', 'X',\n'GUM', 'X'\
,\n'GUN', 'X',\n'GUP', 'X',\n'GUR', 'X',\n'GW3', '\
X',\n'GZZ', 'X',\n'H2B', 'X',\n'H2P', 'H',\n'H2S',\
 'X',\n'H2U', 'X',\n'H4B', 'X',\n'H5M', 'P',\n'H5P\
', 'X',\n'HAA', 'X',\n'HAB', 'X',\n'HAC', 'A',\n'H\
AD', 'X',\n'HAE', 'X',\n'HAG', 'X',\n'HAI', 'X',\n\
'HAM', 'X',\n'HAP', 'X',\n'HAQ', 'X',\n'HAR', 'R',\
\n'HAS', 'X',\n'HAV', 'V',\n'HAX', 'X',\n'HAZ', 'X\
',\n'HBA', 'X',\n'HBC', 'X',\n'HBD', 'X',\n'HBI', \
'X',\n'HBO', 'X',\n'HBU', 'X',\n'HBY', 'X',\n'HC0'\
, 'X',\n'HC1', 'X',\n'HC4', 'X',\n'HCA', 'X',\n'HC\
C', 'X',\n'HCI', 'X',\n'HCS', 'X',\n'HDA', 'X',\n'\
HDD', 'X',\n'HDF', 'X',\n'HDN', 'X',\n'HDS', 'X',\\
n'HDZ', 'X',\n'HE1', 'X',\n'HE6', 'X',\n'HEA', 'X'\
,\n'HEB', 'X',\n'HEC', 'X',\n'HED', 'X',\n'HEE', '\
X',\n'HEF', 'X',\n'HEG', 'X',\n'HEM', 'X',\n'HEN',\
 'X',\n'HEO', 'X',\n'HEP', 'X',\n'HEU', 'X',\n'HEV\
', 'X',\n'HEX', 'X',\n'HEZ', 'X',\n'HF1', 'X',\n'H\
FA', 'X',\n'HFP', 'X',\n'HGA', 'Q',\n'HGB', 'X',\n\
'HGC', 'X',\n'HGI', 'X',\n'HGU', 'X',\n'HHO', 'X',\
\n'HHP', 'X',\n'HIB', 'X',\n'HIC', 'H',\n'HII', 'X\
',\n'HIN', 'X',\n'HIO', 'X',\n'HIP', 'H',\n'HIS', \
'H',\n'HLE', 'X',\n'HLT', 'X',\n'HMA', 'A',\n'HMB'\
, 'X',\n'HMC', 'X',\n'HMD', 'X',\n'HMF', 'A',\n'HM\
G', 'X',\n'HMH', 'X',\n'HMI', 'L',\n'HMM', 'X',\n'\
HMN', 'X',\n'HMO', 'X',\n'HMP', 'X',\n'HMR', 'R',\\
n'HNI', 'X',\n'HNP', 'X',\n'HOA', 'X',\n'HOE', 'X'\
,\n'HOH', 'X',\n'HOM', 'X',\n'HOP', 'X',\n'HOQ', '\
X',\n'HP1', 'A',\n'HP2', 'A',\n'HP3', 'X',\n'HPA',\
 'X',\n'HPB', 'X',\n'HPC', 'X',\n'HPD', 'X',\n'HPE\
', 'A',\n'HPG', 'X',\n'HPH', 'F',\n'HPP', 'X',\n'H\
PQ', 'F',\n'HPR', 'X',\n'HPT', 'X',\n'HPY', 'X',\n\
'HQO', 'X',\n'HQQ', 'X',\n'HQU', 'X',\n'HRG', 'R',\
\n'HRI', 'X',\n'HSA', 'X',\n'HSE', 'S',\n'HSF', 'X\
',\n'HSM', 'X',\n'HSO', 'H',\n'HSP', 'X',\n'HT1', \
'X',\n'HT2', 'X',\n'HTA', 'X',\n'HTL', 'X',\n'HTO'\
, 'X',\n'HTP', 'X',\n'HTR', 'W',\n'HUP', 'X',\n'HU\
X', 'X',\n'HV5', 'A',\n'HV7', 'X',\n'HV8', 'X',\n'\
HXA', 'X',\n'HXC', 'X',\n'HXP', 'X',\n'HY1', 'X',\\
n'HYA', 'X',\n'HYB', 'X',\n'HYD', 'X',\n'HYG', 'X'\
,\n'HYP', 'P',\n'I06', 'X',\n'I10', 'X',\n'I11', '\
X',\n'I17', 'X',\n'I2P', 'X',\n'I3N', 'X',\n'I3P',\
 'X',\n'I40', 'X',\n'I48', 'X',\n'I4B', 'X',\n'I52\
', 'X',\n'I5P', 'X',\n'I84', 'G',\n'IAG', 'G',\n'I\
AS', 'X',\n'IB2', 'X',\n'IBB', 'X',\n'IBP', 'X',\n\
'IBR', 'X',\n'IBS', 'X',\n'IBZ', 'X',\n'IC1', 'X',\
\n'ICA', 'X',\n'ICI', 'X',\n'ICL', 'X',\n'ICP', 'X\
',\n'ICT', 'X',\n'ICU', 'X',\n'ID2', 'X',\n'IDC', \
'X',\n'IDG', 'X',\n'IDH', 'X',\n'IDM', 'X',\n'IDO'\
, 'X',\n'IDP', 'X',\n'IDR', 'X',\n'IDS', 'X',\n'ID\
T', 'X',\n'IDU', 'X',\n'IFG', 'X',\n'IFP', 'X',\n'\
IGL', 'X',\n'IGN', 'X',\n'IGP', 'X',\n'IGU', 'X',\\
n'IH1', 'X',\n'IH2', 'X',\n'IH3', 'X',\n'IHB', 'X'\
,\n'IHN', 'X',\n'IHP', 'X',\n'IIC', 'X',\n'IIL', '\
I',\n'IIP', 'X',\n'IK2', 'X',\n'IKT', 'X',\n'ILA',\
 'I',\n'ILE', 'I',\n'ILG', 'X',\n'ILO', 'X',\n'ILX\
', 'I',\n'IM1', 'X',\n'IM2', 'X',\n'IMC', 'X',\n'I\
MD', 'X',\n'IME', 'X',\n'IMF', 'X',\n'IMG', 'X',\n\
'IMH', 'X',\n'IMI', 'X',\n'IML', 'I',\n'IMM', 'X',\
\n'IMN', 'X',\n'IMO', 'X',\n'IMP', 'X',\n'IMR', 'X\
',\n'IMU', 'X',\n'IN0', 'D',\n'IN1', 'R',\n'IN2', \
'K',\n'IN3', 'L',\n'IN4', 'X',\n'IN5', 'A',\n'IN6'\
, 'L',\n'IN7', 'X',\n'IN8', 'X',\n'IN9', 'X',\n'IN\
A', 'L',\n'INB', 'X',\n'INC', 'X',\n'IND', 'X',\n'\
INE', 'X',\n'INF', 'F',\n'ING', 'F',\n'INH', 'R',\\
n'INI', 'X',\n'INJ', 'X',\n'INK', 'X',\n'INL', 'X'\
,\n'INM', 'X',\n'INN', 'A',\n'INO', 'X',\n'INP', '\
X',\n'INQ', 'X',\n'INR', 'X',\n'INS', 'X',\n'INT',\
 'V',\n'INU', 'X',\n'INV', 'X',\n'INW', 'X',\n'INX\
', 'X',\n'INY', 'X',\n'INZ', 'X',\n'IOA', 'X',\n'I\
OB', 'X',\n'IOC', 'X',\n'IOD', 'X',\n'IOE', 'X',\n\
'IOF', 'X',\n'IOH', 'X',\n'IOL', 'X',\n'IOP', 'X',\
\n'IP1', 'X',\n'IP2', 'X',\n'IP3', 'X',\n'IP4', 'X\
',\n'IPA', 'X',\n'IPB', 'X',\n'IPD', 'X',\n'IPG', \
'G',\n'IPH', 'X',\n'IPL', 'X',\n'IPM', 'X',\n'IPN'\
, 'X',\n'IPO', 'F',\n'IPP', 'X',\n'IPS', 'X',\n'IP\
T', 'X',\n'IPU', 'X',\n'IPY', 'A',\n'IQB', 'X',\n'\
IQP', 'X',\n'IQS', 'X',\n'IR3', 'X',\n'IRI', 'X',\\
n'IRP', 'X',\n'ISA', 'X',\n'ISF', 'X',\n'ISO', 'X'\
,\n'ISP', 'X',\n'ISQ', 'X',\n'ISU', 'X',\n'ITM', '\
X',\n'ITP', 'X',\n'ITR', 'W',\n'ITS', 'X',\n'ITU',\
 'X',\n'IU5', 'X',\n'IUM', 'X',\n'IUR', 'X',\n'IVA\
', 'X',\n'IYG', 'G',\n'IYR', 'Y',\n'J77', 'X',\n'J\
78', 'X',\n'J80', 'X',\n'JE2', 'X',\n'JEN', 'X',\n\
'JST', 'X',\n'K21', 'X',\n'KAH', 'X',\n'KAI', 'X',\
\n'KAM', 'X',\n'KAN', 'X',\n'KAP', 'X',\n'KCP', 'X\
',\n'KCX', 'K',\n'KDO', 'X',\n'KEF', 'X',\n'KET', \
'X',\n'KGR', 'X',\n'KH1', 'X',\n'KIF', 'X',\n'KIV'\
, 'V',\n'KNI', 'X',\n'KPH', 'K',\n'KTH', 'X',\n'KT\
N', 'X',\n'KTP', 'X',\n'KWT', 'X',\n'L04', 'X',\n'\
L1P', 'X',\n'L24', 'E',\n'L2P', 'X',\n'L34', 'E',\\
n'L37', 'E',\n'L3P', 'X',\n'L4P', 'X',\n'L75', 'X'\
,\n'LAC', 'X',\n'LAD', 'X',\n'LAK', 'X',\n'LAM', '\
X',\n'LAR', 'X',\n'LAT', 'X',\n'LAX', 'X',\n'LCO',\
 'X',\n'LCP', 'X',\n'LCS', 'X',\n'LDA', 'X',\n'LDO\
', 'L',\n'LDP', 'X',\n'LEA', 'X',\n'LEO', 'X',\n'L\
EU', 'L',\n'LG2', 'X',\n'LG6', 'X',\n'LGC', 'X',\n\
'LGP', 'X',\n'LHG', 'X',\n'LHY', 'F',\n'LI1', 'X',\
\n'LIG', 'X',\n'LIL', 'X',\n'LIM', 'X',\n'LIN', 'X\
',\n'LIO', 'X',\n'LIP', 'X',\n'LLA', 'X',\n'LLP', \
'K',\n'LLY', 'K',\n'LMG', 'X',\n'LML', 'X',\n'LMT'\
, 'X',\n'LMU', 'X',\n'LMZ', 'X',\n'LNK', 'X',\n'LN\
L', 'X',\n'LNO', 'X',\n'LOF', 'X',\n'LOL', 'L',\n'\
LOM', 'X',\n'LOR', 'X',\n'LOS', 'X',\n'LOV', 'L',\\
n'LOX', 'X',\n'LP1', 'X',\n'LP2', 'R',\n'LPA', 'X'\
,\n'LPC', 'X',\n'LPF', 'X',\n'LPL', 'X',\n'LPM', '\
X',\n'LPP', 'X',\n'LRB', 'X',\n'LRU', 'X',\n'LS1',\
 'X',\n'LS2', 'X',\n'LS3', 'X',\n'LS4', 'X',\n'LS5\
', 'X',\n'LTA', 'X',\n'LTL', 'X',\n'LTR', 'W',\n'L\
UM', 'X',\n'LVS', 'L',\n'LXC', 'X',\n'LY2', 'X',\n\
'LY3', 'X',\n'LYA', 'X',\n'LYB', 'X',\n'LYC', 'X',\
\n'LYD', 'X',\n'LYM', 'K',\n'LYN', 'X',\n'LYS', 'K\
',\n'LYT', 'X',\n'LYW', 'X',\n'LYZ', 'K',\n'M1A', \
'X',\n'M1G', 'X',\n'M2G', 'X',\n'M3L', 'K',\n'M6P'\
, 'X',\n'M6T', 'X',\n'M7G', 'X',\n'MA1', 'X',\n'MA\
2', 'X',\n'MA3', 'X',\n'MA4', 'X',\n'MA6', 'X',\n'\
MAA', 'A',\n'MAB', 'X',\n'MAC', 'X',\n'MAE', 'X',\\
n'MAG', 'X',\n'MAH', 'X',\n'MAI', 'R',\n'MAK', 'X'\
,\n'MAL', 'X',\n'MAM', 'X',\n'MAN', 'X',\n'MAO', '\
X',\n'MAP', 'X',\n'MAR', 'X',\n'MAS', 'X',\n'MAT',\
 'X',\n'MAU', 'X',\n'MAZ', 'X',\n'MBA', 'X',\n'MBD\
', 'X',\n'MBG', 'X',\n'MBH', 'X',\n'MBN', 'X',\n'M\
BO', 'X',\n'MBR', 'X',\n'MBS', 'X',\n'MBV', 'X',\n\
'MBZ', 'X',\n'MCA', 'X',\n'MCD', 'X',\n'MCE', 'X',\
\n'MCG', 'G',\n'MCI', 'X',\n'MCN', 'X',\n'MCP', 'X\
',\n'MCT', 'X',\n'MCY', 'X',\n'MD2', 'X',\n'MDA', \
'X',\n'MDC', 'X',\n'MDG', 'X',\n'MDH', 'X',\n'MDL'\
, 'X',\n'MDM', 'X',\n'MDN', 'X',\n'MDP', 'X',\n'ME\
6', 'X',\n'MEB', 'X',\n'MEC', 'X',\n'MEL', 'X',\n'\
MEN', 'N',\n'MEP', 'X',\n'MER', 'X',\n'MES', 'X',\\
n'MET', 'M',\n'MEV', 'X',\n'MF2', 'X',\n'MF3', 'M'\
,\n'MFB', 'X',\n'MFD', 'X',\n'MFU', 'X',\n'MG7', '\
X',\n'MGA', 'X',\n'MGB', 'X',\n'MGD', 'X',\n'MGG',\
 'R',\n'MGL', 'X',\n'MGN', 'Q',\n'MGO', 'X',\n'MGP\
', 'X',\n'MGR', 'X',\n'MGS', 'X',\n'MGT', 'X',\n'M\
GU', 'X',\n'MGY', 'G',\n'MHB', 'X',\n'MHF', 'X',\n\
'MHL', 'L',\n'MHM', 'X',\n'MHO', 'M',\n'MHS', 'H',\
\n'MHZ', 'X',\n'MIA', 'X',\n'MIC', 'X',\n'MID', 'X\
',\n'MIL', 'X',\n'MIM', 'X',\n'MIN', 'G',\n'MIP', \
'X',\n'MIS', 'S',\n'MIT', 'X',\n'MJI', 'X',\n'MK1'\
, 'X',\n'MKC', 'X',\n'MLA', 'X',\n'MLC', 'X',\n'ML\
E', 'L',\n'MLN', 'X',\n'MLT', 'X',\n'MLY', 'K',\n'\
MLZ', 'K',\n'MM3', 'X',\n'MM4', 'X',\n'MMA', 'X',\\
n'MMC', 'X',\n'MME', 'M',\n'MMO', 'R',\n'MMP', 'X'\
,\n'MMQ', 'X',\n'MMT', 'X',\n'MN1', 'X',\n'MN2', '\
X',\n'MN3', 'X',\n'MN5', 'X',\n'MN7', 'X',\n'MN8',\
 'X',\n'MNA', 'X',\n'MNB', 'X',\n'MNC', 'X',\n'MNG\
', 'X',\n'MNL', 'L',\n'MNO', 'X',\n'MNP', 'X',\n'M\
NQ', 'X',\n'MNS', 'X',\n'MNT', 'X',\n'MNV', 'V',\n\
'MO1', 'X',\n'MO2', 'X',\n'MO3', 'X',\n'MO4', 'X',\
\n'MO5', 'X',\n'MO6', 'X',\n'MOA', 'X',\n'MOB', 'X\
',\n'MOC', 'X',\n'MOE', 'X',\n'MOG', 'X',\n'MOH', \
'X',\n'MOL', 'X',\n'MOO', 'X',\n'MOP', 'X',\n'MOR'\
, 'X',\n'MOS', 'X',\n'MOT', 'X',\n'MOX', 'X',\n'MP\
1', 'X',\n'MP3', 'X',\n'MPA', 'X',\n'MPB', 'X',\n'\
MPC', 'X',\n'MPD', 'X',\n'MPG', 'X',\n'MPH', 'M',\\
n'MPI', 'X',\n'MPJ', 'M',\n'MPL', 'X',\n'MPN', 'X'\
,\n'MPO', 'X',\n'MPP', 'X',\n'MPQ', 'G',\n'MPR', '\
X',\n'MPS', 'X',\n'MQ0', 'X',\n'MQ7', 'X',\n'MQ8',\
 'X',\n'MQ9', 'X',\n'MQI', 'X',\n'MR2', 'X',\n'MRC\
', 'X',\n'MRM', 'X',\n'MRP', 'X',\n'MS2', 'X',\n'M\
SA', 'X',\n'MSB', 'X',\n'MSD', 'X',\n'MSE', 'M',\n\
'MSF', 'X',\n'MSI', 'X',\n'MSO', 'M',\n'MSQ', 'X',\
\n'MST', 'X',\n'MSU', 'X',\n'MTA', 'X',\n'MTB', 'X\
',\n'MTC', 'X',\n'MTD', 'X',\n'MTE', 'X',\n'MTF', \
'X',\n'MTG', 'X',\n'MTO', 'X',\n'MTS', 'X',\n'MTT'\
, 'X',\n'MTX', 'X',\n'MTY', 'Y',\n'MUG', 'X',\n'MU\
P', 'X',\n'MUR', 'X',\n'MVA', 'V',\n'MW1', 'X',\n'\
MW2', 'X',\n'MXA', 'X',\n'MXY', 'X',\n'MYA', 'X',\\
n'MYC', 'X',\n'MYG', 'X',\n'MYR', 'X',\n'MYS', 'X'\
,\n'MYT', 'X',\n'MZM', 'X',\n'N1T', 'X',\n'N25', '\
X',\n'N2B', 'X',\n'N3T', 'X',\n'N4B', 'X',\n'NA2',\
 'X',\n'NA5', 'X',\n'NA6', 'X',\n'NAA', 'X',\n'NAB\
', 'X',\n'NAC', 'X',\n'NAD', 'X',\n'NAE', 'X',\n'N\
AF', 'X',\n'NAG', 'X',\n'NAH', 'X',\n'NAI', 'X',\n\
'NAL', 'A',\n'NAM', 'A',\n'NAN', 'X',\n'NAO', 'X',\
\n'NAP', 'X',\n'NAQ', 'X',\n'NAR', 'X',\n'NAS', 'X\
',\n'NAU', 'X',\n'NAV', 'X',\n'NAW', 'X',\n'NAX', \
'X',\n'NAY', 'X',\n'NBA', 'X',\n'NBD', 'X',\n'NBE'\
, 'X',\n'NBG', 'X',\n'NBN', 'X',\n'NBP', 'X',\n'NB\
S', 'X',\n'NBU', 'X',\n'NCA', 'X',\n'NCB', 'A',\n'\
NCD', 'X',\n'NCH', 'X',\n'NCM', 'X',\n'NCN', 'X',\\
n'NCO', 'X',\n'NCR', 'X',\n'NCS', 'X',\n'ND4', 'X'\
,\n'NDA', 'X',\n'NDC', 'X',\n'NDD', 'X',\n'NDO', '\
X',\n'NDP', 'X',\n'NDT', 'X',\n'NEA', 'X',\n'NEB',\
 'X',\n'NED', 'X',\n'NEM', 'H',\n'NEN', 'X',\n'NEO\
', 'X',\n'NEP', 'H',\n'NEQ', 'X',\n'NES', 'X',\n'N\
ET', 'X',\n'NEV', 'X',\n'NFA', 'F',\n'NFE', 'X',\n\
'NFG', 'X',\n'NFP', 'X',\n'NFS', 'X',\n'NG6', 'X',\
\n'NGA', 'X',\n'NGL', 'X',\n'NGM', 'X',\n'NGO', 'X\
',\n'NGP', 'X',\n'NGT', 'X',\n'NGU', 'X',\n'NH2', \
'X',\n'NH3', 'X',\n'NH4', 'X',\n'NHD', 'X',\n'NHE'\
, 'X',\n'NHM', 'X',\n'NHP', 'X',\n'NHR', 'X',\n'NH\
S', 'X',\n'NI1', 'X',\n'NI2', 'X',\n'NIC', 'X',\n'\
NID', 'X',\n'NIK', 'X',\n'NIO', 'X',\n'NIP', 'X',\\
n'NIT', 'X',\n'NIU', 'X',\n'NIY', 'Y',\n'NLA', 'X'\
,\n'NLE', 'L',\n'NLG', 'X',\n'NLN', 'L',\n'NLP', '\
L',\n'NM1', 'X',\n'NMA', 'A',\n'NMB', 'X',\n'NMC',\
 'G',\n'NMD', 'X',\n'NME', 'X',\n'NMN', 'X',\n'NMO\
', 'X',\n'NMQ', 'X',\n'NMX', 'X',\n'NMY', 'X',\n'N\
NH', 'R',\n'NNO', 'X',\n'NO2', 'X',\n'NO3', 'X',\n\
'NOA', 'X',\n'NOD', 'X',\n'NOJ', 'X',\n'NON', 'X',\
\n'NOP', 'X',\n'NOR', 'X',\n'NOS', 'X',\n'NOV', 'X\
',\n'NOX', 'X',\n'NP3', 'X',\n'NPA', 'X',\n'NPC', \
'X',\n'NPD', 'X',\n'NPE', 'X',\n'NPF', 'X',\n'NPH'\
, 'C',\n'NPI', 'X',\n'NPL', 'X',\n'NPN', 'X',\n'NP\
O', 'X',\n'NPP', 'X',\n'NPT', 'X',\n'NPY', 'X',\n'\
NRG', 'R',\n'NRI', 'X',\n'NS1', 'X',\n'NS5', 'X',\\
n'NSP', 'X',\n'NTA', 'X',\n'NTB', 'X',\n'NTC', 'X'\
,\n'NTH', 'X',\n'NTM', 'X',\n'NTP', 'X',\n'NTS', '\
X',\n'NTU', 'X',\n'NTZ', 'X',\n'NU1', 'X',\n'NVA',\
 'V',\n'NVI', 'X',\n'NVP', 'X',\n'NW1', 'X',\n'NYP\
', 'X',\n'O4M', 'X',\n'OAA', 'X',\n'OAI', 'X',\n'O\
AP', 'X',\n'OAR', 'X',\n'OAS', 'S',\n'OBA', 'X',\n\
'OBN', 'X',\n'OC1', 'X',\n'OC2', 'X',\n'OC3', 'X',\
\n'OC4', 'X',\n'OC5', 'X',\n'OC6', 'X',\n'OC7', 'X\
',\n'OCL', 'X',\n'OCM', 'X',\n'OCN', 'X',\n'OCO', \
'X',\n'OCP', 'X',\n'OCS', 'C',\n'OCT', 'X',\n'OCV'\
, 'K',\n'OCY', 'C',\n'ODA', 'X',\n'ODS', 'X',\n'OE\
S', 'X',\n'OET', 'X',\n'OF1', 'X',\n'OF2', 'X',\n'\
OF3', 'X',\n'OFL', 'X',\n'OFO', 'X',\n'OHE', 'X',\\
n'OHO', 'X',\n'OHT', 'X',\n'OIC', 'X',\n'OIP', 'X'\
,\n'OKA', 'X',\n'OLA', 'X',\n'OLE', 'X',\n'OLI', '\
X',\n'OLO', 'X',\n'OMB', 'X',\n'OMC', 'X',\n'OMD',\
 'X',\n'OME', 'X',\n'OMG', 'X',\n'OMP', 'X',\n'OMT\
', 'M',\n'OMU', 'X',\n'ONE', 'X',\n'ONL', 'L',\n'O\
NP', 'X',\n'OPA', 'X',\n'OPD', 'X',\n'OPE', 'X',\n\
'OPG', 'X',\n'OPH', 'X',\n'OPN', 'X',\n'OPP', 'X',\
\n'OPR', 'R',\n'ORN', 'X',\n'ORO', 'X',\n'ORP', 'X\
',\n'OSB', 'X',\n'OSS', 'X',\n'OTA', 'X',\n'OTB', \
'X',\n'OTE', 'X',\n'OTG', 'X',\n'OUT', 'X',\n'OVA'\
, 'X',\n'OWQ', 'X',\n'OXA', 'X',\n'OXE', 'X',\n'OX\
I', 'X',\n'OXL', 'X',\n'OXM', 'X',\n'OXN', 'X',\n'\
OXO', 'X',\n'OXP', 'X',\n'OXS', 'X',\n'OXY', 'X',\\
n'P11', 'A',\n'P24', 'X',\n'P28', 'X',\n'P2P', 'X'\
,\n'P2U', 'X',\n'P3M', 'X',\n'P4C', 'X',\n'P4P', '\
X',\n'P5P', 'X',\n'P6G', 'X',\n'PA1', 'X',\n'PA2',\
 'X',\n'PA3', 'X',\n'PA4', 'X',\n'PA5', 'X',\n'PAA\
', 'X',\n'PAB', 'X',\n'PAC', 'X',\n'PAD', 'X',\n'P\
AE', 'X',\n'PAG', 'X',\n'PAH', 'X',\n'PAI', 'X',\n\
'PAL', 'D',\n'PAM', 'X',\n'PAN', 'X',\n'PAO', 'X',\
\n'PAP', 'A',\n'PAQ', 'F',\n'PAR', 'X',\n'PAS', 'X\
',\n'PAT', 'W',\n'PBA', 'X',\n'PBB', 'X',\n'PBC', \
'X',\n'PBF', 'F',\n'PBG', 'X',\n'PBI', 'X',\n'PBM'\
, 'X',\n'PBN', 'X',\n'PBP', 'X',\n'PBR', 'X',\n'PB\
Z', 'X',\n'PC2', 'X',\n'PCA', 'E',\n'PCB', 'X',\n'\
PCD', 'X',\n'PCE', 'X',\n'PCG', 'X',\n'PCH', 'X',\\
n'PCL', 'X',\n'PCM', 'X',\n'PCP', 'X',\n'PCR', 'X'\
,\n'PCS', 'X',\n'PCU', 'X',\n'PCV', 'X',\n'PCY', '\
X',\n'PD1', 'X',\n'PDA', 'X',\n'PDC', 'X',\n'PDD',\
 'A',\n'PDE', 'A',\n'PDI', 'X',\n'PDL', 'A',\n'PDN\
', 'X',\n'PDO', 'X',\n'PDP', 'X',\n'PDT', 'X',\n'P\
DU', 'X',\n'PE2', 'X',\n'PE6', 'X',\n'PEA', 'X',\n\
'PEB', 'X',\n'PEC', 'X',\n'PED', 'X',\n'PEE', 'X',\
\n'PEF', 'X',\n'PEG', 'X',\n'PEL', 'X',\n'PEO', 'X\
',\n'PEP', 'X',\n'PEQ', 'X',\n'PER', 'X',\n'PET', \
'X',\n'PFB', 'X',\n'PFC', 'X',\n'PFG', 'X',\n'PFL'\
, 'X',\n'PFM', 'X',\n'PFZ', 'X',\n'PG4', 'X',\n'PG\
5', 'X',\n'PG6', 'X',\n'PGA', 'X',\n'PGC', 'X',\n'\
PGD', 'X',\n'PGE', 'X',\n'PGG', 'G',\n'PGH', 'X',\\
n'PGL', 'X',\n'PGO', 'X',\n'PGP', 'X',\n'PGQ', 'X'\
,\n'PGR', 'X',\n'PGS', 'X',\n'PGU', 'X',\n'PGX', '\
X',\n'PGY', 'G',\n'PH1', 'X',\n'PH2', 'X',\n'PH3',\
 'X',\n'PHA', 'F',\n'PHB', 'X',\n'PHC', 'X',\n'PHD\
', 'X',\n'PHE', 'F',\n'PHG', 'X',\n'PHH', 'X',\n'P\
HI', 'F',\n'PHL', 'F',\n'PHM', 'X',\n'PHN', 'X',\n\
'PHO', 'X',\n'PHP', 'X',\n'PHQ', 'X',\n'PHS', 'H',\
\n'PHT', 'X',\n'PHW', 'P',\n'PHY', 'X',\n'PI1', 'X\
',\n'PI2', 'X',\n'PI3', 'X',\n'PI4', 'X',\n'PI5', \
'X',\n'PI6', 'X',\n'PI7', 'X',\n'PI8', 'X',\n'PI9'\
, 'X',\n'PIA', 'X',\n'PIB', 'X',\n'PIC', 'X',\n'PI\
D', 'X',\n'PIG', 'X',\n'PIH', 'X',\n'PIM', 'X',\n'\
PIN', 'X',\n'PIO', 'X',\n'PIP', 'X',\n'PIQ', 'X',\\
n'PIR', 'X',\n'PIV', 'X',\n'PKF', 'X',\n'PL1', 'X'\
,\n'PL9', 'X',\n'PLA', 'D',\n'PLC', 'X',\n'PLE', '\
L',\n'PLG', 'G',\n'PLH', 'X',\n'PLM', 'X',\n'PLP',\
 'X',\n'PLS', 'S',\n'PLT', 'W',\n'PLU', 'L',\n'PLY\
', 'X',\n'PMA', 'X',\n'PMB', 'X',\n'PMC', 'X',\n'P\
ME', 'F',\n'PML', 'X',\n'PMM', 'X',\n'PMO', 'X',\n\
'PMP', 'X',\n'PMS', 'X',\n'PMY', 'X',\n'PN2', 'X',\
\n'PNA', 'X',\n'PNB', 'X',\n'PNC', 'G',\n'PND', 'X\
',\n'PNE', 'A',\n'PNF', 'X',\n'PNG', 'X',\n'PNI', \
'X',\n'PNL', 'X',\n'PNM', 'X',\n'PNN', 'X',\n'PNO'\
, 'X',\n'PNP', 'X',\n'PNQ', 'X',\n'PNS', 'X',\n'PN\
T', 'X',\n'PNU', 'X',\n'PO2', 'X',\n'PO4', 'X',\n'\
POB', 'X',\n'POC', 'X',\n'POL', 'X',\n'POM', 'P',\\
n'PON', 'X',\n'POP', 'X',\n'POR', 'X',\n'POS', 'X'\
,\n'PP1', 'X',\n'PP2', 'X',\n'PP3', 'A',\n'PP4', '\
X',\n'PP5', 'X',\n'PP6', 'X',\n'PP7', 'X',\n'PP8',\
 'N',\n'PP9', 'X',\n'PPB', 'X',\n'PPC', 'X',\n'PPD\
', 'X',\n'PPE', 'E',\n'PPG', 'X',\n'PPH', 'F',\n'P\
PI', 'X',\n'PPJ', 'V',\n'PPL', 'X',\n'PPM', 'X',\n\
'PPN', 'A',\n'PPO', 'X',\n'PPP', 'X',\n'PPQ', 'X',\
\n'PPR', 'X',\n'PPS', 'X',\n'PPT', 'X',\n'PPU', 'X\
',\n'PPX', 'F',\n'PPY', 'X',\n'PPZ', 'X',\n'PQ0', \
'X',\n'PQN', 'X',\n'PQQ', 'X',\n'PR1', 'X',\n'PR2'\
, 'X',\n'PR3', 'X',\n'PRA', 'X',\n'PRB', 'X',\n'PR\
C', 'X',\n'PRD', 'X',\n'PRE', 'X',\n'PRF', 'X',\n'\
PRH', 'X',\n'PRI', 'P',\n'PRL', 'X',\n'PRN', 'X',\\
n'PRO', 'P',\n'PRP', 'X',\n'PRR', 'A',\n'PRS', 'P'\
,\n'PRZ', 'X',\n'PS0', 'X',\n'PSA', 'X',\n'PSD', '\
X',\n'PSE', 'X',\n'PSF', 'S',\n'PSG', 'X',\n'PSI',\
 'X',\n'PSO', 'X',\n'PSQ', 'X',\n'PSS', 'X',\n'PST\
', 'X',\n'PSU', 'X',\n'PT1', 'X',\n'PT3', 'X',\n'P\
TA', 'X',\n'PTC', 'X',\n'PTD', 'X',\n'PTE', 'X',\n\
'PTH', 'Y',\n'PTL', 'X',\n'PTM', 'Y',\n'PTN', 'X',\
\n'PTO', 'X',\n'PTP', 'X',\n'PTR', 'Y',\n'PTS', 'X\
',\n'PTT', 'X',\n'PTU', 'X',\n'PTY', 'X',\n'PUA', \
'X',\n'PUB', 'X',\n'PUR', 'X',\n'PUT', 'X',\n'PVA'\
, 'X',\n'PVB', 'X',\n'PVH', 'H',\n'PVL', 'X',\n'PX\
A', 'X',\n'PXF', 'X',\n'PXG', 'X',\n'PXP', 'X',\n'\
PXY', 'X',\n'PXZ', 'X',\n'PY2', 'X',\n'PY4', 'X',\\
n'PY5', 'X',\n'PY6', 'X',\n'PYA', 'A',\n'PYC', 'X'\
,\n'PYD', 'X',\n'PYE', 'X',\n'PYL', 'X',\n'PYM', '\
X',\n'PYO', 'X',\n'PYP', 'X',\n'PYQ', 'X',\n'PYR',\
 'X',\n'PYS', 'X',\n'PYT', 'X',\n'PYX', 'X',\n'PYY\
', 'X',\n'PYZ', 'X',\n'PZQ', 'X',\n'Q82', 'X',\n'Q\
NC', 'X',\n'QND', 'X',\n'QSI', 'Q',\n'QTR', 'X',\n\
'QUA', 'X',\n'QUE', 'X',\n'QUI', 'X',\n'QUO', 'X',\
\n'R11', 'X',\n'R12', 'X',\n'R13', 'X',\n'R18', 'X\
',\n'R1P', 'X',\n'R56', 'X',\n'R5P', 'X',\n'RA2', \
'X',\n'RAD', 'X',\n'RAI', 'X',\n'RAL', 'X',\n'RAM'\
, 'X',\n'RAN', 'X',\n'RAP', 'X',\n'RBF', 'X',\n'RB\
U', 'X',\n'RCA', 'X',\n'RCL', 'X',\n'RCO', 'X',\n'\
RDC', 'X',\n'RDF', 'W',\n'RE9', 'X',\n'REA', 'X',\\
n'RED', 'K',\n'REO', 'X',\n'REP', 'X',\n'RET', 'X'\
,\n'RFA', 'X',\n'RFB', 'X',\n'RFL', 'X',\n'RFP', '\
X',\n'RG1', 'X',\n'RGS', 'X',\n'RH1', 'X',\n'RHA',\
 'X',\n'RHC', 'X',\n'RHD', 'X',\n'RHM', 'X',\n'RHO\
', 'X',\n'RHQ', 'X',\n'RHS', 'X',\n'RIA', 'X',\n'R\
IB', 'X',\n'RIC', 'X',\n'RIF', 'X',\n'RIN', 'X',\n\
'RIP', 'X',\n'RIT', 'X',\n'RMB', 'X',\n'RMN', 'X',\
\n'RMP', 'X',\n'RNG', 'X',\n'RNS', 'X',\n'RNT', 'X\
',\n'RO2', 'X',\n'RO4', 'X',\n'ROC', 'N',\n'ROI', \
'X',\n'ROM', 'X',\n'RON', 'V',\n'ROP', 'X',\n'ROS'\
, 'X',\n'ROX', 'X',\n'RPA', 'X',\n'RPD', 'X',\n'RP\
H', 'X',\n'RPL', 'X',\n'RPP', 'X',\n'RPR', 'X',\n'\
RPX', 'X',\n'RQ3', 'X',\n'RR1', 'X',\n'RR6', 'X',\\
n'RRS', 'X',\n'RS1', 'X',\n'RS2', 'X',\n'RS7', 'X'\
,\n'RSS', 'X',\n'RTA', 'X',\n'RTB', 'X',\n'RTC', '\
X',\n'RTL', 'X',\n'RUB', 'X',\n'RUN', 'X',\n'RWJ',\
 'X',\n'RXP', 'X',\n'S02', 'X',\n'S11', 'X',\n'S1H\
', 'S',\n'S27', 'X',\n'S2C', 'C',\n'S3P', 'X',\n'S\
4U', 'X',\n'S57', 'X',\n'S58', 'X',\n'S5H', 'X',\n\
'S6G', 'X',\n'S80', 'X',\n'SAA', 'X',\n'SAB', 'X',\
\n'SAC', 'S',\n'SAD', 'X',\n'SAE', 'X',\n'SAF', 'X\
',\n'SAH', 'C',\n'SAI', 'C',\n'SAL', 'X',\n'SAM', \
'M',\n'SAN', 'X',\n'SAP', 'X',\n'SAR', 'X',\n'SAS'\
, 'X',\n'SB1', 'X',\n'SB2', 'X',\n'SB3', 'X',\n'SB\
4', 'X',\n'SB5', 'X',\n'SB6', 'X',\n'SBA', 'L',\n'\
SBB', 'X',\n'SBD', 'A',\n'SBI', 'X',\n'SBL', 'A',\\
n'SBN', 'X',\n'SBO', 'X',\n'SBR', 'X',\n'SBS', 'X'\
,\n'SBT', 'X',\n'SBU', 'X',\n'SBX', 'X',\n'SC4', '\
X',\n'SCA', 'X',\n'SCC', 'X',\n'SCD', 'X',\n'SCH',\
 'C',\n'SCI', 'X',\n'SCL', 'X',\n'SCM', 'X',\n'SCN\
', 'X',\n'SCO', 'X',\n'SCP', 'S',\n'SCR', 'X',\n'S\
CS', 'X',\n'SCV', 'C',\n'SCY', 'C',\n'SD8', 'X',\n\
'SDK', 'X',\n'SDZ', 'X',\n'SE4', 'X',\n'SEA', 'X',\
\n'SEB', 'S',\n'SEC', 'X',\n'SEG', 'A',\n'SEI', 'X\
',\n'SEL', 'S',\n'SEM', 'X',\n'SEO', 'X',\n'SEP', \
'S',\n'SER', 'S',\n'SES', 'X',\n'SET', 'S',\n'SEU'\
, 'X',\n'SF4', 'X',\n'SFG', 'X',\n'SFN', 'X',\n'SF\
O', 'X',\n'SGA', 'X',\n'SGC', 'X',\n'SGL', 'X',\n'\
SGM', 'X',\n'SGN', 'X',\n'SGP', 'X',\n'SHA', 'X',\\
n'SHC', 'X',\n'SHF', 'X',\n'SHH', 'X',\n'SHP', 'G'\
,\n'SHR', 'E',\n'SHT', 'T',\n'SHU', 'X',\n'SI2', '\
X',\n'SIA', 'X',\n'SIF', 'X',\n'SIG', 'X',\n'SIH',\
 'X',\n'SIM', 'X',\n'SIN', 'X',\n'SKD', 'X',\n'SKF\
', 'X',\n'SLB', 'X',\n'SLE', 'X',\n'SLZ', 'K',\n'S\
MA', 'X',\n'SMC', 'C',\n'SME', 'M',\n'SML', 'X',\n\
'SMM', 'M',\n'SMN', 'X',\n'SMP', 'X',\n'SMS', 'X',\
\n'SN1', 'X',\n'SN6', 'X',\n'SN7', 'X',\n'SNC', 'C\
',\n'SNN', 'X',\n'SNP', 'X',\n'SO1', 'X',\n'SO2', \
'X',\n'SO3', 'X',\n'SO4', 'X',\n'SOA', 'X',\n'SOC'\
, 'C',\n'SOM', 'X',\n'SOR', 'X',\n'SOT', 'X',\n'SO\
X', 'X',\n'SPA', 'X',\n'SPB', 'X',\n'SPC', 'X',\n'\
SPD', 'X',\n'SPE', 'X',\n'SPG', 'X',\n'SPH', 'X',\\
n'SPI', 'X',\n'SPK', 'X',\n'SPM', 'X',\n'SPN', 'X'\
,\n'SPO', 'X',\n'SPP', 'X',\n'SPS', 'X',\n'SPY', '\
X',\n'SQU', 'X',\n'SRA', 'X',\n'SRB', 'X',\n'SRD',\
 'X',\n'SRL', 'X',\n'SRM', 'X',\n'SRS', 'X',\n'SRY\
', 'X',\n'SSA', 'X',\n'SSB', 'X',\n'SSG', 'X',\n'S\
SP', 'X',\n'ST1', 'X',\n'ST2', 'X',\n'ST3', 'X',\n\
'ST4', 'X',\n'ST5', 'X',\n'ST6', 'X',\n'STA', 'X',\
\n'STB', 'X',\n'STE', 'X',\n'STG', 'X',\n'STI', 'X\
',\n'STL', 'X',\n'STN', 'X',\n'STO', 'X',\n'STP', \
'X',\n'STR', 'X',\n'STU', 'X',\n'STY', 'Y',\n'SU1'\
, 'X',\n'SU2', 'X',\n'SUC', 'X',\n'SUI', 'X',\n'SU\
L', 'X',\n'SUR', 'X',\n'SVA', 'S',\n'SWA', 'X',\n'\
T16', 'X',\n'T19', 'X',\n'T23', 'X',\n'T29', 'X',\\
n'T33', 'X',\n'T3P', 'X',\n'T42', 'A',\n'T44', 'X'\
,\n'T5A', 'X',\n'T6A', 'T',\n'T6P', 'X',\n'T80', '\
X',\n'T87', 'X',\n'TA1', 'X',\n'TAA', 'X',\n'TAB',\
 'X',\n'TAC', 'X',\n'TAD', 'X',\n'TAF', 'X',\n'TAM\
', 'X',\n'TAP', 'X',\n'TAR', 'X',\n'TAS', 'X',\n'T\
AU', 'X',\n'TAX', 'X',\n'TAZ', 'X',\n'TB9', 'X',\n\
'TBA', 'X',\n'TBD', 'X',\n'TBG', 'G',\n'TBH', 'X',\
\n'TBM', 'T',\n'TBO', 'X',\n'TBP', 'X',\n'TBR', 'X\
',\n'TBS', 'X',\n'TBT', 'X',\n'TBU', 'X',\n'TBZ', \
'X',\n'TC4', 'X',\n'TCA', 'X',\n'TCB', 'X',\n'TCH'\
, 'X',\n'TCK', 'X',\n'TCL', 'X',\n'TCM', 'X',\n'TC\
N', 'X',\n'TCP', 'X',\n'TCR', 'W',\n'TCS', 'X',\n'\
TCZ', 'X',\n'TDA', 'X',\n'TDB', 'X',\n'TDG', 'X',\\
n'TDP', 'X',\n'TDR', 'X',\n'TDX', 'X',\n'TEA', 'X'\
,\n'TEM', 'X',\n'TEN', 'X',\n'TEO', 'X',\n'TEP', '\
X',\n'TER', 'X',\n'TES', 'X',\n'TET', 'X',\n'TFA',\
 'X',\n'TFB', 'X',\n'TFH', 'X',\n'TFI', 'X',\n'TFK\
', 'X',\n'TFP', 'X',\n'THA', 'X',\n'THB', 'X',\n'T\
HC', 'T',\n'THD', 'X',\n'THE', 'X',\n'THF', 'X',\n\
'THJ', 'X',\n'THK', 'X',\n'THM', 'X',\n'THN', 'X',\
\n'THO', 'T',\n'THP', 'X',\n'THQ', 'X',\n'THR', 'T\
',\n'THS', 'X',\n'THT', 'X',\n'THU', 'X',\n'THX', \
'X',\n'THZ', 'X',\n'TI1', 'X',\n'TI2', 'X',\n'TI3'\
, 'P',\n'TIA', 'X',\n'TIH', 'A',\n'TK4', 'X',\n'TL\
A', 'X',\n'TLC', 'X',\n'TLM', 'X',\n'TLN', 'X',\n'\
TLX', 'X',\n'TM5', 'X',\n'TM6', 'X',\n'TMA', 'X',\\
n'TMB', 'T',\n'TMC', 'X',\n'TMD', 'T',\n'TME', 'X'\
,\n'TMF', 'X',\n'TML', 'K',\n'TMM', 'X',\n'TMN', '\
X',\n'TMP', 'X',\n'TMQ', 'X',\n'TMR', 'X',\n'TMT',\
 'X',\n'TMZ', 'X',\n'TNB', 'C',\n'TND', 'X',\n'TNK\
', 'X',\n'TNP', 'X',\n'TNT', 'X',\n'TOA', 'X',\n'T\
OB', 'X',\n'TOC', 'X',\n'TOL', 'X',\n'TOP', 'X',\n\
'TOS', 'X',\n'TOT', 'X',\n'TP1', 'G',\n'TP2', 'P',\
\n'TP3', 'E',\n'TP4', 'E',\n'TP7', 'T',\n'TPA', 'X\
',\n'TPE', 'X',\n'TPF', 'X',\n'TPI', 'X',\n'TPL', \
'W',\n'TPM', 'X',\n'TPN', 'G',\n'TPO', 'T',\n'TPP'\
, 'X',\n'TPQ', 'A',\n'TPR', 'P',\n'TPS', 'X',\n'TP\
T', 'X',\n'TPV', 'X',\n'TPX', 'X',\n'TPY', 'X',\n'\
TQ3', 'X',\n'TQ4', 'X',\n'TQ5', 'X',\n'TQ6', 'X',\\
n'TR1', 'X',\n'TRA', 'X',\n'TRB', 'X',\n'TRC', 'X'\
,\n'TRD', 'X',\n'TRE', 'X',\n'TRF', 'W',\n'TRG', '\
K',\n'TRH', 'X',\n'TRI', 'X',\n'TRJ', 'X',\n'TRM',\
 'X',\n'TRN', 'W',\n'TRO', 'W',\n'TRP', 'W',\n'TRQ\
', 'X',\n'TRS', 'X',\n'TRX', 'W',\n'TRZ', 'X',\n'T\
S2', 'X',\n'TS3', 'X',\n'TS4', 'X',\n'TS5', 'X',\n\
'TSA', 'X',\n'TSB', 'X',\n'TSI', 'X',\n'TSM', 'X',\
\n'TSN', 'X',\n'TSP', 'X',\n'TSU', 'X',\n'TTA', 'X\
',\n'TTE', 'X',\n'TTN', 'X',\n'TTO', 'X',\n'TTP', \
'X',\n'TTX', 'X',\n'TXL', 'X',\n'TYA', 'Y',\n'TYB'\
, 'Y',\n'TYD', 'X',\n'TYI', 'Y',\n'TYL', 'X',\n'TY\
M', 'W',\n'TYN', 'Y',\n'TYQ', 'Y',\n'TYR', 'Y',\n'\
TYS', 'Y',\n'TYV', 'X',\n'TYY', 'A',\n'TZB', 'X',\\
n'TZC', 'X',\n'TZE', 'X',\n'TZL', 'X',\n'TZO', 'X'\
,\n'TZP', 'X',\n'U01', 'X',\n'U02', 'X',\n'U03', '\
X',\n'U04', 'X',\n'U05', 'X',\n'U0E', 'X',\n'U10',\
 'X',\n'U18', 'X',\n'U2G', 'X',\n'U3P', 'X',\n'U49\
', 'X',\n'U55', 'X',\n'U5P', 'X',\n'U66', 'X',\n'U\
89', 'X',\n'U8U', 'X',\n'UAA', 'X',\n'UAG', 'A',\n\
'UAP', 'X',\n'UAR', 'X',\n'UC1', 'X',\n'UC2', 'X',\
\n'UC3', 'X',\n'UC4', 'X',\n'UD1', 'X',\n'UD2', 'X\
',\n'UDP', 'X',\n'UDX', 'X',\n'UFG', 'X',\n'UFM', \
'X',\n'UFP', 'X',\n'UGA', 'X',\n'UIN', 'X',\n'UKP'\
, 'A',\n'UM3', 'X',\n'UMA', 'A',\n'UMG', 'X',\n'UM\
P', 'X',\n'UNA', 'X',\n'UND', 'X',\n'UNI', 'X',\n'\
UNK', 'X',\n'UNN', 'X',\n'UNX', 'X',\n'UP5', 'X',\\
n'UP6', 'X',\n'UPA', 'X',\n'UPF', 'X',\n'UPG', 'X'\
,\n'UPP', 'X',\n'UQ1', 'X',\n'UQ2', 'X',\n'UQ6', '\
X',\n'UR2', 'X',\n'URA', 'X',\n'URE', 'X',\n'URF',\
 'X',\n'URI', 'X',\n'URS', 'X',\n'UTP', 'X',\n'UVC\
', 'X',\n'UVW', 'X',\n'V35', 'X',\n'V36', 'X',\n'V\
4O', 'X',\n'V7O', 'X',\n'VAA', 'V',\n'VAC', 'X',\n\
'VAD', 'V',\n'VAF', 'V',\n'VAG', 'X',\n'VAL', 'V',\
\n'VAN', 'X',\n'VAS', 'X',\n'VAX', 'X',\n'VDX', 'X\
',\n'VDY', 'X',\n'VG1', 'X',\n'VIB', 'X',\n'VIR', \
'X',\n'VIT', 'X',\n'VK3', 'X',\n'VO3', 'X',\n'VO4'\
, 'X',\n'VS1', 'F',\n'VS2', 'F',\n'VS3', 'F',\n'VS\
4', 'F',\n'VXA', 'X',\n'W01', 'X',\n'W02', 'X',\n'\
W03', 'X',\n'W11', 'X',\n'W33', 'X',\n'W35', 'X',\\
n'W42', 'X',\n'W43', 'X',\n'W54', 'X',\n'W56', 'X'\
,\n'W59', 'X',\n'W71', 'X',\n'W84', 'X',\n'W8R', '\
X',\n'W91', 'X',\n'WAY', 'X',\n'WCC', 'X',\n'WO2',\
 'X',\n'WO4', 'X',\n'WRB', 'X',\n'WRR', 'X',\n'WRS\
', 'X',\n'WW7', 'X',\n'X2F', 'X',\n'X7O', 'X',\n'X\
AA', 'X',\n'XAN', 'X',\n'XAO', 'X',\n'XBB', 'X',\n\
'XBP', 'X',\n'XDN', 'X',\n'XDP', 'X',\n'XIF', 'X',\
\n'XIM', 'X',\n'XK2', 'X',\n'XL1', 'X',\n'XLS', 'X\
',\n'XMP', 'X',\n'XN1', 'X',\n'XN2', 'X',\n'XN3', \
'X',\n'XUL', 'X',\n'XV6', 'X',\n'XYD', 'X',\n'XYH'\
, 'X',\n'XYL', 'X',\n'XYP', 'X',\n'XYS', 'X',\n'YO\
F', 'Y',\n'YRR', 'X',\n'YT3', 'X',\n'YZ9', 'X',\n'\
Z34', 'G',\n'Z5A', 'X',\n'ZAF', 'X',\n'ZAP', 'X',\\
n'ZEB', 'X',\n'ZEN', 'X',\n'ZES', 'X',\n'ZID', 'X'\
,\n'ZMR', 'X',\n'ZN3', 'X',\n'ZNH', 'X',\n'ZNO', '\
X',\n'ZO3', 'X',\n'ZPR', 'P',\n'ZRA', 'A',\n'ZST',\
 'X',\n'ZYA', 'A',\n\n\n'ASN','N');\n} \n\n\nsub f\
ile2head\n      {\n	my $file = shift;\n	my $size =\
 shift;\n	my $f= new FileHandle;\n	my $line;\n	ope\
n ($f,$file);\n	read ($f,$line, $size);\n	close ($\
f);\n	return $line;\n      }\nsub file2tail\n     \
 {\n	my $file = shift;\n	my $size = shift;\n	my $f\
= new FileHandle;\n	my $line;\n	\n	open ($f,$file)\
;\n	seek ($f,$size*-1, 2);\n	read ($f,$line, $size\
);\n	close ($f);\n	return $line;\n      }\n\n\nsub\
 vtmpnam\n      {\n	my $r=rand(100000);\n	my $f=\"\
file.$r.$$\";\n	while (-e $f)\n	  {\n	    $f=vtmpn\
am();\n	  }\n	push (@TMPFILE_LIST, $f);\n	return $\
f;\n      }\n\nsub myexit\n  {\n    my $code=@_[0]\
;\n    if ($CLEAN_EXIT_STARTED==1){return;}\n    e\
lse {$CLEAN_EXIT_STARTED=1;}\n    ### ONLY BARE EX\
IT\n    exit ($code);\n  }\nsub set_error_lock\n  \
  {\n      my $name = shift;\n      my $pid=$$;\n\\
n      \n      &lock4tc ($$,\"LERROR\", \"LSET\", \
\"$$ -- ERROR: $name $PROGRAM\\n\");\n      return\
;\n    }\nsub set_lock\n  {\n    my $pid=shift;\n \
   my $msg= shift;\n    my $p=getppid();\n    &loc\
k4tc ($pid,\"LLOCK\",\"LRESET\",\"$p$msg\\n\");\n \
 }\nsub unset_lock\n   {\n     \n    my $pid=shift\
;\n    &lock4tc ($pid,\"LLOCK\",\"LRELEASE\",\"\")\
;\n  }\nsub shift_lock\n  {\n    my $from=shift;\n\
    my $to=shift;\n    my $from_type=shift;\n    m\
y $to_type=shift;\n    my $action=shift;\n    my $\
msg;\n    \n    if (!&lock4tc($from, $from_type, \\
"LCHECK\", \"\")){return 0;}\n    $msg=&lock4tc ($\
from, $from_type, \"LREAD\", \"\");\n    &lock4tc \
($from, $from_type,\"LRELEASE\", $msg);\n    &lock\
4tc ($to, $to_type, $action, $msg);\n    return;\n\
  }\nsub isshellpid\n  {\n    my $p=shift;\n    if\
 (!lock4tc ($p, \"LLOCK\", \"LCHECK\")){return 0;}\
\n    else\n      {\n	my $c=lock4tc($p, \"LLOCK\",\
 \"LREAD\");\n	if ( $c=~/-SHELL-/){return 1;}\n   \
   }\n    return 0;\n  }\nsub isrootpid\n  {\n    \
if(lock4tc (getppid(), \"LLOCK\", \"LCHECK\")){ret\
urn 0;}\n    else {return 1;}\n  }\nsub lock4tc\n	\
{\n	  my ($pid,$type,$action,$value)=@_;\n	  my $f\
name;\n	  my $host=hostname;\n	  \n	  if ($type eq\
 \"LLOCK\"){$fname=\"$LOCKDIR/.$pid.$host.lock4tco\
ffee\";}\n	  elsif ( $type eq \"LERROR\"){ $fname=\
\"$LOCKDIR/.$pid.$host.error4tcoffee\";}\n	  elsif\
 ( $type eq \"LWARNING\"){ $fname=\"$LOCKDIR/.$pid\
.$host.warning4tcoffee\";}\n	  \n	  if ($debug_loc\
k)\n	    {\n	      print STDERR \"\\n\\t---lock4tc\
(tcg): $action => $fname =>$value (RD: $LOCKDIR)\\\
n\";\n	    }\n\n	  if    ($action eq \"LCHECK\") {\
return -e $fname;}\n	  elsif ($action eq \"LREAD\"\
){return file2string($fname);}\n	  elsif ($action \
eq \"LSET\") {return string2file ($value, $fname, \
\">>\");}\n	  elsif ($action eq \"LRESET\") {retur\
n string2file ($value, $fname, \">\");}\n	  elsif \
($action eq \"LRELEASE\") \n	    {\n	      if ( $d\
ebug_lock)\n		{\n		  my $g=new FileHandle;\n		  op\
en ($g, \">>$fname\");\n		  print $g \"\\nDestroye\
d by $$\\n\";\n		  close ($g);\n		  safe_system (\\
"mv $fname $fname.old\");\n		}\n	      else\n		{\n\
		  unlink ($fname);\n		}\n	    }\n	  return \"\";\
\n	}\n	\nsub file2string\n	{\n	  my $file=@_[0];\n\
	  my $f=new FileHandle;\n	  my $r;\n	  open ($f, \
\"$file\");\n	  while (<$f>){$r.=$_;}\n	  close ($\
f);\n	  return $r;\n	}\nsub string2file \n    {\n \
   my ($s,$file,$mode)=@_;\n    my $f=new FileHand\
le;\n    \n    open ($f, \"$mode$file\");\n    pri\
nt $f  \"$s\";\n    close ($f);\n  }\n\nBEGIN\n   \
 {\n      srand;\n    \n      $SIG{'SIGUP'}='signa\
l_cleanup';\n      $SIG{'SIGINT'}='signal_cleanup'\
;\n      $SIG{'SIGQUIT'}='signal_cleanup';\n      \
$SIG{'SIGILL'}='signal_cleanup';\n      $SIG{'SIGT\
RAP'}='signal_cleanup';\n      $SIG{'SIGABRT'}='si\
gnal_cleanup';\n      $SIG{'SIGEMT'}='signal_clean\
up';\n      $SIG{'SIGFPE'}='signal_cleanup';\n    \
  \n      $SIG{'SIGKILL'}='signal_cleanup';\n     \
 $SIG{'SIGPIPE'}='signal_cleanup';\n      $SIG{'SI\
GSTOP'}='signal_cleanup';\n      $SIG{'SIGTTIN'}='\
signal_cleanup';\n      $SIG{'SIGXFSZ'}='signal_cl\
eanup';\n      $SIG{'SIGINFO'}='signal_cleanup';\n\
      \n      $SIG{'SIGBUS'}='signal_cleanup';\n  \
    $SIG{'SIGALRM'}='signal_cleanup';\n      $SIG{\
'SIGTSTP'}='signal_cleanup';\n      $SIG{'SIGTTOU'\
}='signal_cleanup';\n      $SIG{'SIGVTALRM'}='sign\
al_cleanup';\n      $SIG{'SIGUSR1'}='signal_cleanu\
p';\n\n\n      $SIG{'SIGSEGV'}='signal_cleanup';\n\
      $SIG{'SIGTERM'}='signal_cleanup';\n      $SI\
G{'SIGCONT'}='signal_cleanup';\n      $SIG{'SIGIO'\
}='signal_cleanup';\n      $SIG{'SIGPROF'}='signal\
_cleanup';\n      $SIG{'SIGUSR2'}='signal_cleanup'\
;\n\n      $SIG{'SIGSYS'}='signal_cleanup';\n     \
 $SIG{'SIGURG'}='signal_cleanup';\n      $SIG{'SIG\
CHLD'}='signal_cleanup';\n      $SIG{'SIGXCPU'}='s\
ignal_cleanup';\n      $SIG{'SIGWINCH'}='signal_cl\
eanup';\n      \n      $SIG{'INT'}='signal_cleanup\
';\n      $SIG{'TERM'}='signal_cleanup';\n      $S\
IG{'KILL'}='signal_cleanup';\n      $SIG{'QUIT'}='\
signal_cleanup';\n      \n      our $debug_lock=$E\
NV{\"DEBUG_LOCK\"};\n      \n      \n      \n     \
 \n      foreach my $a (@ARGV){$CL.=\" $a\";}\n   \
   if ( $debug_lock ){print STDERR \"\\n\\n\\n****\
****** START PG: $PROGRAM *************\\n\";}\n  \
    if ( $debug_lock ){print STDERR \"\\n\\n\\n***\
*******(tcg) LOCKDIR: $LOCKDIR $$ *************\\n\
\";}\n      if ( $debug_lock ){print STDERR \"\\n \
--- $$ -- $CL\\n\";}\n      \n	     \n      \n    \
  \n    }\nsub flush_error\n  {\n    my $msg=shift\
;\n    return add_error ($EXIT_FAILURE,$$, $$,getp\
pid(), $msg, $CL);\n  }\nsub add_error \n  {\n    \
my $code=shift;\n    my $rpid=shift;\n    my $pid=\
shift;\n    my $ppid=shift;\n    my $type=shift;\n\
    my $com=shift;\n    \n    $ERROR_DONE=1;\n    \
lock4tc ($rpid, \"LERROR\",\"LSET\",\"$pid -- ERRO\
R: $type\\n\");\n    lock4tc ($$, \"LERROR\",\"LSE\
T\", \"$pid -- COM: $com\\n\");\n    lock4tc ($$, \
\"LERROR\",\"LSET\", \"$pid -- STACK: $ppid -> $pi\
d\\n\");\n   \n    return $code;\n  }\nsub add_war\
ning \n  {\n    my $rpid=shift;\n    my $pid =shif\
t;\n    my $command=shift;\n    my $msg=\"$$ -- WA\
RNING: $command\\n\";\n    print STDERR \"$msg\";\\
n    lock4tc ($$, \"LWARNING\", \"LSET\", $msg);\n\
  }\n\nsub signal_cleanup\n  {\n    print dtderr \\
"\\n**** $$ (tcg) was killed\\n\";\n    &cleanup;\\
n    exit ($EXIT_FAILURE);\n  }\nsub clean_dir\n  \
{\n    my $dir=@_[0];\n    if ( !-d $dir){return ;\
}\n    elsif (!($dir=~/tmp/)){return ;}#safety che\
ck 1\n    elsif (($dir=~/\\*/)){return ;}#safety c\
heck 2\n    else\n      {\n	`rm -rf $dir`;\n      \
}\n    return;\n  }\nsub cleanup\n  {\n    #print \
stderr \"\\n----tc: $$ Kills $PIDCHILD\\n\";\n    \
#kill (SIGTERM,$PIDCHILD);\n    my $p=getppid();\n\
    $CLEAN_EXIT_STARTED=1;\n    \n    \n    \n    \
if (&lock4tc($$,\"LERROR\", \"LCHECK\", \"\"))\n  \
    {\n	my $ppid=getppid();\n	if (!$ERROR_DONE) \n\
	  {\n	    &lock4tc($$,\"LERROR\", \"LSET\", \"$$ \
-- STACK: $p -> $$\\n\");\n	    &lock4tc($$,\"LERR\
OR\", \"LSET\", \"$$ -- COM: $CL\\n\");\n	  }\n   \
   }\n    my $warning=&lock4tc($$, \"LWARNING\", \\
"LREAD\", \"\");\n    my $error=&lock4tc($$,  \"LE\
RROR\", \"LREAD\", \"\");\n    #release error and \
warning lock if root\n    \n    if (isrootpid() &&\
 ($warning || $error) )\n      {\n	\n	print STDERR\
 \"**************** Summary *************\\n$error\
\\n$warning\\n\";\n\n	&lock4tc($$,\"LERROR\",\"REL\
EASE\",\"\");\n	&lock4tc($$,\"LWARNING\",\"RELEASE\
\",\"\");\n      } \n    \n    \n    foreach my $f\
 (@TMPFILE_LIST)\n      {\n	if (-e $f){unlink ($f)\
;} \n      }\n    foreach my $d (@TMPDIR_LIST)\n  \
    {\n	clean_dir ($d);\n      }\n    #No More Loc\
k Release\n    #&lock4tc($$,\"LLOCK\",\"LRELEASE\"\
,\"\"); #release lock \n\n    if ( $debug_lock ){p\
rint STDERR \"\\n\\n\\n********** END PG: $PROGRAM\
 ($$) *************\\n\";}\n    if ( $debug_lock )\
{print STDERR \"\\n\\n\\n**********(tcg) LOCKDIR: \
$LOCKDIR $$ *************\\n\";}\n  }\nEND \n  {\n\
    \n    &cleanup();\n  }\n   \n\nsub safe_system\
 \n{\n  my $com=shift;\n  my $ntry=shift;\n  my $c\
try=shift;\n  my $pid;\n  my $status;\n  my $ppid=\
getppid();\n  if ($com eq \"\"){return 1;}\n  \n  \
\n\n  if (($pid = fork ()) < 0){return (-1);}\n  i\
f ($pid == 0)\n    {\n      set_lock($$, \" -SHELL\
- $com (tcg)\");\n      exec ($com);\n    }\n  els\
e\n    {\n      lock4tc ($$, \"LLOCK\", \"LSET\", \
\"$pid\\n\");#update parent\n      $PIDCHILD=$pid;\
\n    }\n  if ($debug_lock){printf STDERR \"\\n\\t\
 .... safe_system (fasta_seq2hmm)  p: $$ c: $pid C\
OM: $com\\n\";}\n\n  waitpid ($pid,WTERMSIG);\n\n \
 shift_lock ($pid,$$, \"LWARNING\",\"LWARNING\", \\
"LSET\");\n\n  if ($? == $EXIT_FAILURE || lock4tc(\
$pid, \"LERROR\", \"LCHECK\", \"\"))\n    {\n     \
 if ($ntry && $ctry <$ntry)\n	{\n	  add_warning ($\
$,$$,\"$com failed [retry: $ctry]\");\n	  lock4tc \
($pid, \"LRELEASE\", \"LERROR\", \"\");\n	  return\
 safe_system ($com, $ntry, ++$ctry);\n	}\n      el\
sif ($ntry == -1)\n	{\n	  if (!shift_lock ($pid, $\
$, \"LERROR\", \"LWARNING\", \"LSET\"))\n	    {\n	\
      add_warning ($$,$$,\"$com failed\");\n	    }\
\n	  else\n	    {\n	      lock4tc ($pid, \"LRELEAS\
E\", \"LERROR\", \"\");\n	    }\n	  return $?;}\n \
     else\n	{\n	  if (!shift_lock ($pid,$$, \"LERR\
OR\",\"LERROR\", \"LSET\"))\n	    {\n	      myexit\
(add_error ($EXIT_FAILURE,$$,$pid,getppid(), \"UNS\
PECIFIED system\", $com));\n	    }\n	}\n    }\n  r\
eturn $?;\n}\n\nsub check_configuration \n    {\n \
     my @l=@_;\n      my $v;\n      foreach my $p \
(@l)\n	{\n	  \n	  if   ( $p eq \"EMAIL\")\n	    { \
\n	      if ( !($EMAIL=~/@/))\n		{\n		add_warning(\
$$,$$,\"Could Not Use EMAIL\");\n		myexit(add_erro\
r ($EXIT_FAILURE,$$,$$,getppid(),\"EMAIL\",\"$CL\"\
));\n	      }\n	    }\n	  elsif( $p eq \"INTERNET\\
")\n	    {\n	      if ( !&check_internet_connectio\
n())\n		{\n		  myexit(add_error ($EXIT_FAILURE,$$,\
$$,getppid(),\"INTERNET\",\"$CL\"));\n		}\n	    }\\
n	  elsif( $p eq \"wget\")\n	    {\n	      if (!&p\
g_is_installed (\"wget\") && !&pg_is_installed (\"\
curl\"))\n		{\n		  myexit(add_error ($EXIT_FAILURE\
,$$,$$,getppid(),\"PG_NOT_INSTALLED:wget\",\"$CL\"\
));\n		}\n	    }\n	  elsif( !(&pg_is_installed ($p\
)))\n	    {\n	      myexit(add_error ($EXIT_FAILUR\
E,$$,$$,getppid(),\"PG_NOT_INSTALLED:$p\",\"$CL\")\
);\n	    }\n	}\n      return 1;\n    }\nsub pg_is_\
installed\n  {\n    my @ml=@_;\n    my $r, $p, $m;\
\n    my $supported=0;\n    \n    my $p=shift (@ml\
);\n    if ($p=~/::/)\n      {\n	if (safe_system (\
\"perl -M$p -e 1\")==$EXIT_SUCCESS){return 1;}\n	e\
lse {return 0;}\n      }\n    else\n      {\n	$r=`\
which $p 2>/dev/null`;\n	if ($r eq \"\"){return 0;\
}\n	else {return 1;}\n      }\n  }\n\n\n\nsub chec\
k_internet_connection\n  {\n    my $internet;\n   \
 my $tmp;\n    &check_configuration ( \"wget\"); \\
n    \n    $tmp=&vtmpnam ();\n    \n    if     (&p\
g_is_installed    (\"wget\")){`wget www.google.com\
 -O$tmp >/dev/null 2>/dev/null`;}\n    elsif  (&pg\
_is_installed    (\"curl\")){`curl www.google.com \
-o$tmp >/dev/null 2>/dev/null`;}\n    \n    if ( !\
-e $tmp || -s $tmp < 10){$internet=0;}\n    else {\
$internet=1;}\n    if (-e $tmp){unlink $tmp;}\n\n \
   return $internet;\n  }\nsub check_pg_is_install\
ed\n  {\n    my @ml=@_;\n    my $r=&pg_is_installe\
d (@ml);\n    if (!$r && $p=~/::/)\n      {\n	prin\
t STDERR \"\\nYou Must Install the perl package $p\
 on your system.\\nRUN:\\n\\tsudo perl -MCPAN -e '\
install $pg'\\n\";\n      }\n    elsif (!$r)\n    \
  {\n	myexit(flush_error(\"\\nProgram $p Supported\
 but Not Installed on your system\"));\n      }\n \
   else\n      {\n	return 1;\n      }\n  }\n\n\nsu\
b remote_is_pdb_name_deprecated\n{\n    my $in=@_[\
0];\n    my ($ref_file, $pdb);\n    my ($value,$va\
lue1,$value2);\n    my $max=2;\n    \n    \n    \n\
    $ref_file=\"$cache/pdb_entry_type.txt\";\n    \
\n    if ( $in=~/[^\\w\\d\\:\\_]/){return 0;}\n   \
 elsif ($no_remote_pdb_dir==1)\n      {\n	my $pdbd\
ir=$ENV{'PDB_DIR'};\n	\n	my $r1=\"$pdbdir/derived_\
data/pdb_entry_type.txt\";\n	my $r2=$ref_file;\n	i\
f    (-e $r1){$ref_file=$r1;}\n	elsif (-e $r2){$re\
f_file=$r2;}\n	else\n	  {\n	    my $p=substr ($in,\
0, 4);\n	    add_warning ($$, $$, \"Cannot find pd\
b_entry_type.txt;  $p is assumed to be valid; add \
ftp://ftp.wwpdb.org/pub/pdb/derived_data/pdb_entry\
_type.txt in $cache to check name status\");\n	  }\
\n      }\n    elsif ( !-e $ref_file || (-M $ref_f\
ile)>$max || -z $ref_file)\n      {\n	&url2file(\"\
ftp://ftp.wwpdb.org/pub/pdb/derived_data/pdb_entry\
_type.txt\", $ref_file);\n      }\n    $pdb=substr\
 ($in,0, 4);\n    chomp(($value1=`grep -c $pdb $re\
f_file`));\n    $pdb=lc($pdb);\n    chomp(($value2\
=`grep -c $pdb $ref_file`));\n    $value=($value1 \
|| $value2)?1:0;\n    $value=($value>0)?1:0;\n    \
\n    return $value;\n  }\n","use Cwd;\nuse Env;\n\
use File::Path;\nuse FileHandle;\nuse strict;\n\n\\
nour (%MODE, %PG, %ENV_SET, %SUPPORTED_OS);\n\nour\
 $VERSION=\"0\"; #_#UPDATE_VERSION\n\nour $EXIT_SU\
CCESS=0;\nour $EXIT_FAILURE=1;\nour $INTERNET=0;\n\
\nour $CP=\"cp \"; #was causing a crash on MacOSX\\
nour $SILENT=\">/dev/null 2>/dev/null\";\nour $WEB\
_BASE=\"http://www.tcoffee.org\";\nour $TCLINKDB_A\
DDRESS=\"$WEB_BASE/Resources/tclinkdb.txt\";\nour \
$OS=get_os();\nour $ROOT=&get_root();\nour $CD=cwd\
();\nour $CDIR=$CD;\nour $HOME=$ENV{'HOME'};\n\nou\
r $OSNAME=$ENV{'OSNAME'};\nour $OSARCH=$ENV{'OSARC\
H'};\nour $REPO_ROOT=\"\";\n\nour $TCDIR;\nour $TC\
CACHE;\nour $TCTMP;\nour $TCM;\nour $TCMETHODS;\no\
ur $TCPLUGINS;\nour $PLUGINS_DIR=\"\";\nour $INSTA\
LL_DIR=\"\";\nour $email;\nour $recompile;\n\nour \
$CXX=\"g++\";\nour $CXXFLAGS=\"\";\n\nour $CPP=\"g\
++\";\nour $CPPFLAGS=\"\";\n\nour $CC=\"gcc\";\nou\
r $CFLAGS=$ENV{'CFLAGS'};\n\nour $FC=\"f77\";\nour\
 $FFLAGS=\"\";\n\nmy $install=\"all\";\nmy $defaul\
t_update_action=\"no_update\";\nmy @required_appli\
cations=(\"wget_OR_curl\");\nmy @smode=(\"all\", \\
"clean\", \"install\");\n\n&initialize_PG();\nmy $\
cl=join( \" \", @ARGV);\nif ($#ARGV==-1 || ($cl=~/\
-h/) ||($cl=~/-H/) )\n  {\n     print \"\\n!!!!!!!\
 ./install  t_coffee             --> installs t_co\
ffee only\";\n     print \"\\n!!!!!!! ./install  a\
ll                  --> installs all the modes [mc\
offee, expresso, psicoffee,rcoffee..]\";\n     pri\
nt \"\\n!!!!!!! ./install  [mcoffee|rcoffee|..] --\
> installs the specified mode\";\n     print \"\\n\
!!!!!!! ./install  -h                   --> print \
usage\\n\\n\";\n     if ( $#ARGV==-1){exit ($EXIT_\
FAILURE);}\n   }\n     \nif (($cl=~/-h/) ||($cl=~/\
-H/) )\n  {\n    my $m;\n    print \"\\n\\n!!!!!!!\
 advanced mode\\n\";\n    foreach $m ((keys (%MODE\
)),@smode)\n      {\n	print \"!!!!!!!       ./inst\
all $m\\n\";\n      }\n    \n    print \"!!!!!!! .\
/install [target:package|mode|] [-update|-force|-e\
xec=dir|-dis=dir|-root|-tclinkdb=file|-] [CC=|FCC=\
|CXX=|CFLAGS=|CXXFLAGS=]\\n\";\n    print \"!!!!!!\
! ./install clean    [removes all executables]\\n\\
";\n    print \"!!!!!!! ./install [optional:target\
] -update               [updates package already i\
nstalled]\\n\";\n    print \"!!!!!!! ./install [op\
tional:target] -recompile            [forces the r\
ecompilation of T-Coffee]\\n\";\n\n    print \"!!!\
!!!! ./install [optional:target] -force           \
     [Forces recompilation over everything]\\n\";\\
n    \n    print \"!!!!!!! ./install [optional:tar\
get] -root                 [You are running as roo\
t]\\n\";\n    print \"!!!!!!! ./install [optional:\
target] -exec=/foo/bar/       [address for the T-C\
offee executable]\\n\";\n    print \"!!!!!!! ./ins\
tall [optional:target] -dis=/foo/bar/        [Addr\
ess where distributions should be stored]\\n\";\n \
   print \"!!!!!!! ./install [optional:target] -tc\
linkdb=foo|update  [file containing all the packag\
es to be installed]\\n\";\n    print \"!!!!!!! ./i\
nstall [optional:target] -clean                [cl\
ean everything]\\n\";\n    print \"!!!!!!! ./insta\
ll [optional:target] -plugins              [plugin\
s directory]\\n\";\n    print \"!!!!!!! ./install \
[optional:target] -tcdir=/foor/bar      [base path\
 where T-Coffee will be installed - default ~/.t_c\
offee]\\n\";\n    print \"!!!!!!! ./install [optio\
nal:target] -repo=/path/to/repo   [binaries reposi\
tory root directory]\\n\";\n    print \"!!!!!!! ./\
install [optional:target] -email=<your email>   [n\
eeded for remote BLAST]\\n\";\n    print \"!!!!!!!\
 ./install [optional:target] -proxy=<proxy>   [may\
 be needed to access remote services]\\n\";\n    \\
n    print \"!!!!!!! mode:\";\n    foreach $m (key\
s(%MODE)){print \"$m \";}\n    print \"\\n\";\n   \
 print \"!!!!!!! Packages:\";\n    foreach $m (key\
s (%PG)){print \"$m \";}\n    print \"\\n\";\n    \
\n    print \"\\n\\n\";\n    exit ($EXIT_FAILURE);\
\n  }\n\n\n\nmy (@argl)=($cl=~/(\\S+=[^=]+)\\s\\w+\
=/g);\npush (@argl, ($cl=~/(\\S+=[^=]+\\S)\\s*$/g)\
);\n\nforeach $a (@argl)\n  {\n    if ( ($cl=~/CXX\
=(.*)/)){$CXX=$1;}\n    if ( ($cl=~/-CC=(.*)/    )\
){$CC=$1;}\n    if ( ($cl=~/-FC=(.*)/    )){$FC=$1\
;}\n    if ( ($cl=~/-CFLAGS=(.*)/)){$CFLAGS=$1;}\n\
    if ( ($cl=~/-CXXFLAGS=(.*)/)){$CXXFLAGS=$1;}\n\
  }\nour ($ROOT_INSTALL, $NO_QUESTION, $default_up\
date_action,$BINARIES_ONLY,$force, $default_update\
_action, $INSTALL_DIR, $PLUGINS_DIR, $DISTRIBUTION\
S,$tclinkdb, $proxy, $clean);\nif ( ($cl=~/-root/)\
){$ROOT_INSTALL=1;}\nif ( ($cl=~/-no_question/)){$\
NO_QUESTION=1;}\nif ( ($cl=~/-update/)){$default_u\
pdate_action=\"update\";}\nif ( ($cl=~/-recompile/\
)){$recompile=1;}\n\n\n$BINARIES_ONLY=1;\n\nif ( (\
$cl=~/-nobinaries/)){$BINARIES_ONLY=0;}\nif ( ($cl\
=~/-force/)){$force=1;$default_update_action=\"upd\
ate\"}\nif ( ($cl=~/-exec=\\s*(\\S+)/)){$INSTALL_D\
IR=$1;}\nif ( ($cl=~/-plugins=\\s*(\\S+)/)){$PLUGI\
NS_DIR=$1;}\nif ( ($cl=~/-dis=\\s*(\\S+)/)){$DISTR\
IBUTIONS=$1;}\n\nif ( ($cl=~/-tclinkdb=\\s*(\\S+)/\
)){$tclinkdb=$1;}\nif ( ($cl=~/-proxy=\\s*(\\S+)/)\
){$proxy=$1;}\nif ( ($cl=~/-clean/)){$clean=1;}\ni\
f ( ($cl=~/-repo=\\s*(\\S+)/)){ $REPO_ROOT=$1; }\n\
if ( ($cl=~/-tcdir=\\s*(\\S+)/)){ $TCDIR=$1; }\n\n\
if ( ($cl=~/-email=\\s*(\\S+)/)){$email=$1;}\n\n\n\
if ($tclinkdb){&update_tclinkdb ($tclinkdb);}\n\n\\
nif( $REPO_ROOT ne \"\" ) {\n	if( $OSNAME eq \"\" \
) { print \"You have specified the repository fold\
er but the required \\\"OSNAME\\\" enviroment vari\
able is missing. \\n\"; exit 1; } \n	if( $OSARCH e\
q \"\" ) { print \"You have specified the reposito\
ry folder but the required \\\"OSARCH\\\" envirome\
nt variable is missing. \\n\"; exit 1; } \n}\n\n\n\
if(!$TCDIR) { $TCDIR=\"$HOME/.t_coffee\"; }\n&add_\
dir ($TCDIR);\n&add_dir ($TCCACHE=\"$TCDIR/cache\"\
);\n&add_dir ($TCTMP=\"$CDIR/tmp\");\n&add_dir ($T\
CM=\"$TCDIR/mcoffee\");\n&add_dir ($TCMETHODS=\"$T\
CDIR/methods\");\n&add_dir ($TCPLUGINS=\"$TCDIR/pl\
ugins/$OS\");\n\n\nour $BASE=\"$CD/bin\";\nour $BI\
N=\"$BASE/cache/binaries/$OS\";\nour $DOWNLOAD_DIR\
=\"$BASE/cache/download\";\nour $DOWNLOAD_FILE=\"$\
DOWNLOAD_DIR/files\";\nour $TMP=\"$BASE/cache/tmp\\
";\n\n&add_dir($BASE);\n&add_dir($BIN);\n&add_dir(\
$DOWNLOAD_DIR);\n&add_dir($DOWNLOAD_FILE);\nif (!$\
DISTRIBUTIONS){$DISTRIBUTIONS=\"$DOWNLOAD_DIR/dist\
ributions\";}\n&add_dir ($DISTRIBUTIONS);\n&add_di\
r ($TMP);\n\n\nif    (!$PLUGINS_DIR && !$ROOT_INST\
ALL){$PLUGINS_DIR=$TCPLUGINS;}\nelsif (!$PLUGINS_D\
IR &&  $ROOT_INSTALL){$PLUGINS_DIR=\"/usr/local/bi\
n/\";}\n\nif    (!$INSTALL_DIR && !$ROOT_INSTALL){\
$INSTALL_DIR=\"$TCDIR/bin/$OS\";mkpath ($INSTALL_D\
IR);}\nelsif (!$INSTALL_DIR &&  $ROOT_INSTALL){$IN\
STALL_DIR=\"/usr/local/bin/\";}\n\nif (-d \"mcoffe\
e\"){`cp mcoffee/* $TCM`;}\n\n\nour $ENV_FILE=\"$T\
CDIR/.t_coffee_env\";\nunlink ($ENV_FILE);\n&add2e\
nv_file ($ENV_FILE,\"EMAIL_4_TCOFFEE\", $email);\n\
&add2env_file ($ENV_FILE,\"http_proxy_4_TCOFFEE\",\
 $proxy);\n&env_file2putenv ($ENV_FILE);\n&set_pro\
xy($proxy);\n\n\n\nmy ($target, $p, $r);\n$target=\
$p;\n\nforeach $p (  ((keys (%PG)),(keys(%MODE)),(\
@smode)) )\n  {\n    if ($ARGV[0] eq $p && $target\
 eq \"\"){$target=$p;}\n  }\nif ($target eq \"\"){\
exit ($EXIT_FAILURE);}\n\n\nforeach $r (@required_\
applications)\n  {\n    my @app_list;\n    my $i;\\
n    $i=0;\n    \n    @app_list=split (/_OR_/, $r)\
;\n    foreach my $pg (@app_list)\n      {\n	$i+=&\
pg_is_installed ($pg);\n      }\n    if ($i==0)\n \
     {\n      print \"One of the following package\
s must be installed to proceed: \";\n      foreach\
 my $pg (@app_list)\n	{\n	  print (\"$pg \");\n	}\\
n      die;\n    }\n  }\n\n\n\n\n\n\n&sign_license\
_ni();\n\n\n$PG{C}{compiler}=get_C_compiler($CC);\\
n$PG{Fortran}{compiler}=get_F_compiler($FC);\n$PG{\
CXX}{compiler}=$PG{CPP}{compiler}=$PG{GPP}{compile\
r}=get_CXX_compiler($CXX);\nif ($CXXFLAGS){$PG{CPP\
}{options}=$PG{GPP}{options}=$PG{CXX}{options}=$CX\
XFLAGS;}\nif ($CFLAGS ne \"\" ){$PG{C}{options}=$C\
FLAGS;}\nforeach my $c (keys(%PG))\n  {\n    my $a\
rguments;\n    if ($PG{$c}{compiler})\n      {\n	$\
arguments=\"$PG{$c}{compiler_flag}=$PG{$c}{compile\
r} \";\n	if ($PG{$c}{options})\n	  {\n	    $argume\
nts.=\"$PG{$c}{options_flag}='\" . $PG{$c}{options\
} . \"' \";\n	  }\n	$PG{$c}{arguments}=$arguments;\
\n      }\n  }\n\nif ($PG{$target}){$PG{$target}{i\
nstall}=1;}\nelse\n  {\n    foreach my $pg (keys(%\
PG))\n      {\n	if ( $target eq \"all\" || ($PG{$p\
g}{mode}=~/$target/))\n	  {\n	    $PG{$pg} {instal\
l}=1;\n	  }\n      }\n  }\n\nforeach my $pg (keys(\
%PG))\n  {\n    if (!$PG{$pg}{update_action}){$PG{\
$pg}{update_action}=$default_update_action;}\n    \
elsif ($PG{$pg}{update_action} eq \"never\"){$PG{$\
pg}{install}=0;}\n    if ( $force && $PG{$pg}{inst\
all})\n      {\n	`rm $BIN/$pg $BIN/$pg.exe $SILENT\
`;\n      }\n    if ($PG{$pg}{update_action} eq \"\
update\" && $PG{$pg}{install}){$PG{$pg}{update}=1;\
}\n  }\n\nif (($target=~/clean/))\n  {\n    print \
\"------- cleaning executables -----\\n\";\n    `r\
m bin/* $SILENT`;\n    exit ($EXIT_SUCCESS);\n  }\\
n\nif ( !$PG{$target}){print \"------- Installing \
T-Coffee Modes\\n\";}\n\nforeach my $m (keys(%MODE\
))\n  {\n    if ( $target eq \"all\" || $target eq\
 $m)\n      {\n	print \"\\n------- The installer w\
ill now install the $m components $MODE{$m}{descri\
ption}\\n\";\n	foreach my $pg (keys(%PG))\n	  {\n	\
    if ( $PG{$pg}{mode} =~/$m/ && $PG{$pg}{install\
})\n	      {\n		if ($PG{$pg}{touched}){print \"---\
---- $PG{$pg}{dname}: already processed\\n\";}\n		\
else {$PG{$pg}{success}=&install_pg($pg);$PG{$pg}{\
touched}=1;}\n	      }\n	  }\n      }\n  }\n\nif (\
 $PG{$target}){print \"------- Installing Individu\
al Package\\n\";}\nforeach my $pg (keys (%PG))\n  \
{\n    \n    if ( $PG{$pg}{install} && !$PG{$pg}{t\
ouched})\n      {\n	print \"\\n------- Install $pg\
\\n\";\n	$PG{$pg}{success}=&install_pg($pg);$PG{$p\
g}{touched}=1;\n      }\n  }\nprint \"------- Fini\
shing The installation\\n\";\nmy $final_report=&in\
stall ($INSTALL_DIR);\n\nprint \"\\n\";\nprint \"*\
**************************************************\
******************\\n\";\nprint \"********        \
      INSTALLATION SUMMARY          **************\
***\\n\";\nprint \"*******************************\
**************************************\\n\";\nprin\
t \"------- SUMMARY package Installation:\\n\";\np\
rint \"-------   Executable Installed in: $PLUGINS\
_DIR\\n\";\n\nforeach my $pg (keys(%PG))\n  {\n   \
 if ( $PG{$pg}{install})\n      {\n	my $bin_status\
=($PG{$pg}{from_binary} && $PG{$pg}{success})?\"[f\
rom binary]\":\"\";\n	if     ( $PG{$pg}{new} && !$\
PG{$pg}{old})                     {print \"*------\
        $PG{$pg}{dname}: installed $bin_status\\n\\
"; $PG{$pg}{status}=1;}\n	elsif  ( $PG{$pg}{new} &\
&  $PG{$pg}{old})                     {print \"*--\
----        $PG{$pg}{dname}: updated $bin_status\\\
n\"  ; $PG{$pg}{status}=1;} \n	elsif  (!$PG{$pg}{n\
ew} &&  $PG{$pg}{old} && !$PG{$pg}{update}){print \
\"*------        $PG{$pg}{dname}: previous\\n\" ; \
$PG{$pg}{status}=1;}\n	elsif  (!$PG{$pg}{new} &&  \
$PG{$pg}{old} &&  $PG{$pg}{update}){print \"*-----\
-        $PG{$pg}{dname}: failed update (previous \
installation available)\\n\";$PG{$pg}{status}=0;}\\
n	else                                            \
              {print \"*------        $PG{$pg}{dna\
me}: failed installation\\n\";$PG{$pg}{status}=0;}\
\n      }\n  }\nmy $failure;\n\nif ( !$PG{$target}\
){print \"*------ SUMMARY mode Installation:\\n\";\
}\nforeach my $m (keys(%MODE))\n  {\n  \n    if ( \
$target eq \"all\" || $target eq $m)\n      {\n	my\
 $succesful=1;\n	foreach my $pg (keys(%PG))\n	  {\\
n	    if (($PG{$pg}{mode}=~/$m/) && $PG{$pg}{insta\
ll} && $PG{$pg}{status}==0)\n	      {\n		$succesfu\
l=0;\n		print \"*!!!!!!       $PG{$pg}{dname}: Mis\
sing\\n\";\n	      }\n	  }\n	if ( $succesful)\n	  \
{\n	    $MODE{$m}{status}=1;\n	    print \"*------\
       MODE $MODE{$m}{dname} SUCCESSFULLY installe\
d\\n\";\n	  }\n	else\n	  {\n	    $failure++;\n	   \
 $MODE{$m}{status}=0;\n	    print \"*!!!!!!       \
MODE $MODE{$m}{dname} UNSUCCESSFULLY installed\\n\\
";\n	  }\n      }\n  }\n\n    \n      \nif ($clean\
==1 && ($BASE=~/install4tcoffee/) ){print \"*-----\
- Clean Installation Directory: $BASE\\n\";`rm -rf\
 $BASE`;}\nforeach my $pg (keys(%PG)){if ($PG{$pg}\
{install} && $PG{$pg}{status}==0){exit ($EXIT_FAIL\
URE);}}\n\nif ($failure)\n  {\n    print \"*******\
**************************************************\
************\\n\";\n    print \"********     SOME \
PACKAGES FAILED TO INSTALL        ****************\
*\\n\";\n    print \"*****************************\
****************************************\\n\";\n  \
  print \"\\nSome of the reported failures may be \
due to connectivity problems\";\n    print \"\\nRe\
run the installation and the installer will specif\
ically try to install the missing packages\";\n   \
 print \"\\nIf this Fails, go to the original webs\
ite and install the package manually\";\n  }\n\npr\
int \"********************************************\
*************************\\n\";\nprint \"******** \
             FINALIZE YOUR INSTALLATION    *******\
**********\\n\";\nprint \"************************\
*********************************************\\n\"\
;\nprint \"------- Your third party executables ar\
e in:\\n\"; \nprint \"-------       $PLUGINS_DIR:\\
\n\";\nprint \"------- Your t_coffee exccutable is\
 in\\n\";\nprint \"-------       $INSTALL_DIR:\\n\\
";\nprint \"------- In order to make your installa\
tion permanent add these two lines\\n\";\nprint \"\
export PATH=$INSTALL_DIR:\\$PATH\\n\";\nprint \"ex\
port PLUGINS_4_TCOFFEE=$PLUGINS_DIR:\\n\";\nif ($O\
S eq \"linux\")\n  {\n    print \"-------       to\
 the file: $HOME/.bashrc\\n\";\n  }\nelse \n  {\n \
   print \"-------       to the file: $HOME/.profi\
le\\ OR $HOME/.basrc\";\n  }\nexit ($EXIT_SUCCESS)\
;  \n  \nsub get_CXX_compiler\n  {\n    my $c=@_[0\
];\n    my (@clist)=(\"g++\");\n    \n    return g\
et_compil ($c, @clist);\n }\nsub get_C_compiler\n \
 {\n    my $c=@_[0];\n    my (@clist)=(\"gcc\", \"\
cc\", \"icc\");\n    \n    return get_compil ($c, \
@clist);\n }\n\nsub get_F_compiler\n  {\n    my ($\
c)=@_[0];\n    my @clist=(\"f77\", \"g77\",\"g95\"\
, \"gfortran\", \"ifort\");\n    return get_compil\
 ($c, @clist);\n  } \n       \nsub get_compil\n  {\
\n    my ($fav,@clist)=(@_);\n    \n    #return th\
e first compiler found installed in the system. Ch\
eck first the favorite\n    foreach my $c ($fav,@c\
list)\n      {\n	if  (&pg_is_installed ($c)){retur\
n $c;}\n      }\n    return \"\";\n  }\nsub exit_i\
f_pg_not_installed\n  {\n    my (@arg)=(@_);\n    \
\n    foreach my $p (@arg)\n      {\n	if ( !&pg_is\
_installed ($p))\n	  {\n	    print \"!!!!!!!! The \
$p utility must be installed for this installation\
 to proceed [FATAL]\\n\";\n	    die;\n	  }\n      \
}\n    return 1;\n  }\nsub set_proxy\n  {\n    my \
($proxy)=(@_);\n    my (@list,$p);\n    \n    @lis\
t= (\"HTTP_proxy\", \"http_proxy\", \"HTTP_PROXY\"\
, \"ALL_proxy\", \"all_proxy\",\"HTTP_proxy_4_TCOF\
FEE\",\"http_proxy_4_TCOFFEE\");\n    \n    if (!$\
proxy)\n      {\n	foreach my $p (@list)\n	  {\n	  \
  if ( ($ENV_SET{$p}) || $ENV{$p}){$proxy=$ENV{$p}\
;}\n	  }\n      }\n    foreach my $p(@list){$ENV{$\
p}=$proxy;}\n  }\n	\nsub check_internet_connection\
\n  {\n    my $internet;\n    \n    if ( -e \"x\")\
{unlink (\"x\");}\n    if     (&pg_is_installed   \
 (\"wget\")){`wget www.google.com -Ox >/dev/null 2\
>/dev/null`;}\n    elsif  (&pg_is_installed    (\"\
curl\")){`curl www.google.com -ox >/dev/null 2>/de\
v/null`;}\n    else\n      {\n	printf stderr \"\\n\
ERROR: No pg for remote file fetching [wget or cur\
l][FATAL]\\n\";\n	exit ($EXIT_FAILURE);\n      }\n\
    \n    if ( !-e \"x\" || -s \"x\" < 10){$intern\
et=0;}\n    else {$internet=1;}\n    if (-e \"x\")\
{unlink \"x\";}\n    return $internet;\n  }\nsub u\
rl2file\n  {\n    my ($cmd, $file,$wget_arg, $curl\
_arg)=(@_);\n    my ($exit,$flag, $pg, $arg);\n   \
 \n    if ($INTERNET || check_internet_connection \
()){$INTERNET=1;}\n    else\n      {\n	print STDER\
R \"ERROR: No Internet Connection [FATAL:install.p\
l]\\n\";\n	exit ($EXIT_FAILURE);\n      }\n    \n \
   if     (&pg_is_installed    (\"wget\")){$pg=\"w\
get\"; $flag=\"-O\";$arg=\"--tries=2 --connect-tim\
eout=10 --no-check-certificate $wget_arg\";}\n    \
elsif  (&pg_is_installed    (\"curl\")){$pg=\"curl\
\"; $flag=\"-f -o\";$arg=$curl_arg;}\n    else\n  \
    {\n	printf stderr \"\\nERROR: No pg for remote\
 file fetching [wget or curl][FATAL]\\n\";\n	exit \
($EXIT_FAILURE);\n      }\n    \n    \n    if (-e \
$file){unlink($file);}\n    $exit=system \"$pg $cm\
d $flag$file $arg\";\n    return $exit;\n  }\n\nsu\
b pg_is_installed\n  {\n    my ($p, $dir)=(@_);\n \
   my ($r,$m, $ret);\n    my ($supported, $languag\
e, $compil);\n    \n  \n    if ( $PG{$p})\n      {\
\n	$language=$PG{$p}{language2};\n	$compil=$PG{$la\
nguage}{compiler};\n      }\n    \n    if ( $compi\
l eq \"CPAN\")\n      {\n	if ( system (\"perl -M$p\
 -e 1\")==$EXIT_SUCCESS){$ret=1;}\n	else {$ret=0;}\
\n      }\n    elsif ($dir)\n      {\n	if (-e \"$d\
ir/$p\" || -e \"$dir/$p\\.exe\"){$ret=1;}\n	else {\
$ret=0;}\n      }\n    elsif (-e \"$PLUGINS_DIR/$p\
\" || -e \"$PLUGINS_DIR/$p.exe\"){$ret=1;}\n    el\
se\n      {\n	$r=`which $p 2>/dev/null`;\n	if ($r \
eq \"\"){$ret=0;}\n	else {$ret=1;}\n      }\n   \n\
    return $ret;\n  }\nsub install\n  {\n    my ($\
new_bin)=(@_);\n    my ($copied, $report);\n\n    \
\n    if (!$ROOT_INSTALL)\n      {\n	`$CP $BIN/* $\
PLUGINS_DIR`;\n	if (-e \"$BIN/t_coffee\")\n	  {\n	\
    `$CP $BIN/t_coffee $INSTALL_DIR`;\n	      unli\
nk(\"$PLUGINS_DIR/t_coffee\");\n	  }\n	$copied=1;\\
n      }\n    else\n      {\n	$copied=&root_run (\\
"You must be root to finalize the installation\", \
\"$CP $BIN/* $PLUGINS_DIR $SILENT\");\n	if (-e \"$\
BIN/t_coffee\")\n	  {\n	    &root_run (\"You must \
be root to finalize the installation\", \"$CP $BIN\
/t_coffee $INSTALL_DIR\");\n	    &root_run (\"You \
must be root to finalize the installation\", \"rm \
 $PLUGINS_DIR/t_coffee\");\n	  }\n      }\n    \n \
    \n  if ( !$copied)\n    {\n      $report=\"*!!\
!!!! Installation unsuccesful. The executables hav\
e been left in $BASE/bin\\n\";\n    }\n  elsif ( $\
copied && $ROOT)\n    {\n      $report=\"*------ I\
nstallation succesful. Your executables have been \
copied in $new_bin and are on your PATH\\n\";\n   \
 }\n  elsif ( $copied && !$ROOT)\n    {\n      $re\
port= \"*!!!!!! T-Coffee has been installed in $IN\
STALL_DIR\\n\";\n      $report= \"*!!!!!! T-Coffee\
 and associated packages have been copied in: $PLU\
GINS_DIR\\n\";\n      $report.=\"*!!!!!! This T-Co\
ffee location is NOT on your PATH sytem variable\\\
n\";\n      if ( $OS eq \"linux\")\n	{\n	  $report\
.=\"*!!!!!! You can do so by adding the following \
line in your ~/.bashrc file:\\n\";\n	}\n      else\
\n	{\n	  $report.=\"*!!!!!! You can do so by addin\
g the following line in your ~/.profile file:\\n\"\
;\n	}\n      $report.=\"*!!!!!! export PATH=$INSTA\
LL_DIR:\\$PATH\\n\";\n    }\n  return $report;\n}\\
n\nsub sign_license_ni\n  {\n    my $F=new FileHan\
dle;\n    open ($F, \"license.txt\");\n    while (\
<$F>)\n      {\n	print \"$_\";\n      }\n    close\
 ($F);\n    \n    return;\n  }\n\nsub install_pg\n\
  {\n    my ($pg)=(@_);\n    my ($report, $previou\
s, $language, $compiler, $return);\n    \n    if (\
!$PG{$pg}{install}){return 1;}\n    \n    $previou\
s=&pg_is_installed ($pg);\n    \n    if ($PG{$pg}{\
update_action} eq \"no_update\" && $previous)\n   \
   {\n	$PG{$pg}{old}=1;\n	$PG{$pg}{new}=0;\n	$retu\
rn=1;\n      }\n    else\n      {\n	$PG{$pg}{old}=\
$previous;\n	\n	if ($PG{$pg} {language2} eq \"Perl\
\"){&install_perl_package ($pg);}\n	elsif ($BINARI\
ES_ONLY && &install_binary_package ($pg)){$PG{$pg}\
{from_binary}=1;}\n	elsif (&install_source_package\
 ($pg)){;}\n	else \n	  {\n	    \n	    if (!&suppor\
ted_os($OS))\n	      {\n		print \"!!!!!!!! $pg com\
pilation failed, binary unsupported for $OS\\n\"; \
\n	      }\n	    elsif (!($PG{$pg}{from_binary}=&i\
nstall_binary_package ($pg)))\n	      {\n		print \\
"!!!!!!!! $pg compilation and  binary installation\
 failed\\n\";\n	      }\n	  }\n	$PG{$pg}{new}=$ret\
urn=&pg_is_installed ($pg,$BIN);\n      }\n\n    \\
n    return $return;\n  }\nsub install_perl_packag\
e\n  {\n    my ($pg)=(@_);\n    my ($report, $lang\
uage, $compiler);\n    \n    $language=$PG{$pg} {l\
anguage2};\n    $compiler=$PG{$language}{compiler}\
;\n    \n    if (!&pg_is_installed ($pg))\n      {\
\n	if ( $OS eq \"windows\"){`perl -M$compiler -e '\
install $pg'`;}\n	elsif ( $ROOT eq \"sudo\"){syste\
m (\"sudo perl -M$compiler -e 'install $pg'\");}\n\
	else {system (\"su root -c perl -M$compiler -e 'i\
nstall $pg'\");}\n      }\n    return &pg_is_insta\
lled ($pg);\n  }\n\n\n\nsub install_source_package\
\n  {\n    my ($pg)=(@_);\n    my ($report, $downl\
oad, $arguments, $language, $address, $name, $ext,\
 $main_dir, $distrib);\n    my $wget_tmp=\"$TMP/wg\
et.tmp\";\n    my (@fl);\n    if ( $default_update\
_action ne \"update\" && (-e \"$BIN/$pg\" || -e \"\
$BIN/$pg.exe\" )  ){return 1;}\n    \n    #\n    #\
 check if the module exists in the repository cach\
e \n    #\n	if( repo_load($pg) ) {\n		return 1;\n	\
}\n    \n    if ($pg eq \"t_coffee\")  {return   &\
install_t_coffee_source ($pg);}\n    elsif ($pg eq\
 \"TMalign\"){return   &install_TMalign ($pg);}\n \
   \n    chdir $DISTRIBUTIONS;\n    \n    $downloa\
d=$PG{$pg}{source};\n    \n    if (($download =~/t\
gz/))\n      {\n	($address,$name,$ext)=($download=\
~/(.+\\/)([^\\/]+)(\\.tgz).*/);\n      }\n    elsi\
f (($download=~/tar\\.gz/))\n      {\n	($address,$\
name,$ext)=($download=~/(.+\\/)([^\\/]+)(\\.tar\\.\
gz).*/);\n      }\n    elsif (($download=~/tar/))\\
n      {\n	($address,$name,$ext)=($download=~/(.+\\
\/)([^\\/]+)(\\.tar).*/);\n      }\n    else\n    \
  {\n	($address,$name)=($download=~/(.+\\/)([^\\/]\
+)/);\n	$ext=\"\";\n      }\n    $distrib=\"$name$\
ext\";\n    \n    if ( !-d $pg){mkdir $pg;}\n    c\
hdir $pg;\n   \n    #get the distribution if avail\
able\n    if ( -e \"$DOWNLOAD_DIR/$distrib\")\n   \
   {\n	`$CP $DOWNLOAD_DIR/$distrib .`;\n      }\n \
   #UNTAR and Prepare everything\n    if (!-e \"$n\
ame.tar\" && !-e \"$name\")\n      {\n	&check_rm (\
$wget_tmp);\n	print \"\\n------- Downloading/Insta\
lling $pg\\n\";\n	\n	if (!-e $distrib && &url2file\
 (\"$download\", \"$wget_tmp\")==$EXIT_SUCCESS)\n	\
  {\n	    \n	    `mv $wget_tmp $distrib`;\n	    `$\
CP $distrib $DOWNLOAD_DIR/`;\n	  }\n\n	if (!-e $di\
strib)\n	  {\n	    print \"!!!!!!! Download of $pg\
 distribution failed\\n\";\n	    print \"!!!!!!! C\
heck Address: $PG{$pg}{source}\\n\";\n	    return \
0;\n	  }\n	print \"\\n------- unzipping/untaring $\
name\\n\";\n	if (($ext =~/z/))\n	  { \n	    &flush\
_command (\"gunzip -f $name$ext\");\n	    \n	  }\n\
	if (($ext =~/tar/) || ($ext =~/tgz/))\n	  {\n	   \
 &flush_command(\"tar -xvf $name.tar\");\n	  }\n  \
    }\n    #Guess and enter the distribution direc\
tory\n    @fl=ls($p);\n    foreach my $f (@fl)\n  \
    {\n	if (-d $f)\n	  {\n	    $main_dir=$f;\n	  }\
\n      }\n    if (-d $main_dir)\n	  \n      {\n	c\
hdir $main_dir;}\n    else\n      {\n	print \"Erro\
r: $main_dir does not exist\";\n      }\n    print\
 \"\\n------- Compiling/Installing $pg\\n\";\n    \
`make clean $SILENT`;\n    \n    \n    #\n    # SA\
P module\n    #\n    if ($pg eq \"sap\")\n      {\\
n	if (-e \"./configure\")\n	  {\n	    #new sap dis\
tribution\n	    \n	    &flush_command (\"./configu\
re\");\n	    &flush_command (\"make clean\");\n	  \
  &flush_command (\"make\");\n	    &check_cp (\"./\
src/$pg\", \"$BIN\");\n	    repo_store(\"./src/$pg\
\");\n	  }\n	else\n	  {\n	    #old style distribut\
ion\n	    `rm *.o sap  sap.exe ./util/aa/*.o  ./ut\
il/wt/.o $SILENT`;\n	    &flush_command (\"make $a\
rguments sap\");\n	    &check_cp ($pg, \"$BIN\");\\
n	    repo_store($pg);\n	  }\n      }\n    \n    #\
\n    # CLUSTALW2 module\n    #\n    elsif ($pg eq\
 \"clustalw2\")\n      {\n	&flush_command(\"./conf\
igure\");\n	&flush_command(\"make $arguments\");\n\
	&check_cp (\"./src/$pg\", \"$BIN\");\n	repo_store\
(\"./src/$pg\");\n      }\n\n    #\n    # CLUSTAL-\
OMEGA module\n    #\n    elsif ($pg eq \"clustalo\\
")\n      {\n	&flush_command(\"./configure\");\n	&\
flush_command(\"make $arguments\");\n	&check_cp (\\
"./src/$pg\", \"$BIN\");\n	repo_store(\"./src/$pg\\
");\n      }\n\n    #\n    # STRIKE module\n    #\\
n    elsif ($pg eq \"strike\")\n      {\n	&flush_c\
ommand(\"make $arguments\");\n	&check_cp (\"./bin/\
$pg\", \"$BIN\");\n	repo_store(\"./bin/$pg\");\n  \
    }\n    \n    #\n    # FSA module\n    # \n    \
elsif ($pg eq \"fsa\")\n      {\n	&flush_command(\\
"./configure --prefix=$BIN\");\n	&flush_command(\"\
make $arguments\");\n	&flush_command (\"make insta\
ll\");\n\n	repo_store(\"fsa\", \"$BIN/bin\");\n	`m\
v $BIN/bin/* $BIN`;\n	`rmdir $BIN/bin`;\n      }\n\
    \n    #\n    # CLUSTALW module\n    #\n    els\
if ($pg eq \"clustalw\")\n      {\n	&flush_command\
(\"make $arguments clustalw\");\n	`$CP $pg $BIN $S\
ILENT`;\n	repo_store($pg);\n      }\n    \n    #\n\
    # MAFFT module\n    #\n    elsif ($pg eq \"maf\
ft\")\n      {\n	my $base=cwd();\n	my $c;\n	\n	#co\
mpile core\n	mkpath (\"./mafft/bin\");\n	mkpath (\\
"./mafft/lib\");\n	chdir \"$base/core\";\n	`make c\
lean $SILENT`;\n	&flush_command (\"make $arguments\
\");\n	&flush_command (\"make install LIBDIR=../ma\
fft/lib BINDIR=../mafft/bin\");\n	\n	#compile exte\
nsion\n	chdir \"$base/extensions\";\n	`make clean \
$SILENT`;\n	&flush_command (\"make $arguments\");\\
n	&flush_command (\"make install LIBDIR=../mafft/l\
ib BINDIR=../mafft/bin\");\n	\n	#put everything in\
 mafft and copy the compiled stuff in bin\n	chdir \
\"$base\";\n	if ($ROOT_INSTALL)\n	  {\n	    &root_\
run (\"You Must be Root to Install MAFFT\\n\", \"m\
kdir /usr/local/mafft/;$CP mafft/lib/* /usr/local/\
mafft;$CP mafft/lib/mafft* /usr/local/bin ;$CP maf\
ft/bin/mafft /usr/local/bin/; \");\n	  }\n	else\n	\
  {\n	    `$CP mafft/lib/*  $BIN`;\n	    `$CP maff\
t/bin/mafft  $BIN`;\n	  }\n	`tar -cvf mafft.tar ma\
fft`;\n	`gzip mafft.tar`;\n	`mv mafft.tar.gz $BIN`\
;\n	\n	repo_store(\"mafft/bin/mafft\", \"mafft/lib\
/\", \"$BIN/mafft.tar.gz\");\n      }\n      \n   \
 #\n    # DIALIGN-TX module\n    #\n    elsif ( $p\
g eq \"dialign-tx\" )\n      {\n	my $f;\n	my $base\
=cwd();\n\n	chdir \"./source\";\n	if ($OS eq \"mac\
osx\"){&flush_command (\"cp makefile.MAC_OS makefi\
le\");}\n\n	&flush_command (\" make CPPFLAGS='-O3 \
-funroll-loops' all\");\n	\n	chdir \"..\";\n	&chec\
k_cp (\"./source/$pg\", \"$BIN\");\n	repo_store(\"\
./source/$pg\");\n      }\n      \n    #\n    # DI\
ALIGN-T module \n    # (is the same as dialign-tx,\
 but it is mantained for backward name compatibili\
ty with tcoffee)\n    #\n    elsif ( $pg eq \"dial\
ign-t\" )\n      {\n	my $f;\n	my $base=cwd();\n\n	\
chdir \"./source\";\n	if ($OS eq \"macosx\"){&flus\
h_command (\"cp makefile.MAC_OS makefile\");}\n\n	\
&flush_command (\" make CPPFLAGS='-O3 -funroll-loo\
ps' all\");\n	\n	chdir \"..\";\n	&check_cp (\"./so\
urce/dialign-tx\", \"$BIN/dialign-t\");\n	repo_sto\
re(\"$BIN/dialign-t\");	\n      }      \n      \n \
   #\n    # POA module\n    #\n    elsif ($pg eq \\
"poa\")\n      {\n	&flush_command (\"make $argumen\
ts poa\");\n	&check_cp (\"$pg\", \"$BIN\");\n	repo\
_store(\"$pg\");\n      }\n     \n     \n    #\n  \
  # PROBCONS module\n    #\n    elsif ( $pg eq \"p\
robcons\")\n      {\n	&add_C_libraries(\"./Probabi\
listicModel.h\", \"list\", \"cstring\");\n	\n	`rm \
*.exe $SILENT`;\n	&flush_command (\"make $argument\
s probcons\");\n	&check_cp(\"$pg\", \"$BIN/$pg\");\
\n	repo_store(\"$pg\");\n      }\n      \n    #\n \
   # PROBCONS RNA module\n    #\n    elsif ( $pg e\
q \"probconsRNA\")\n      {\n	&add_C_libraries(\".\
/ProbabilisticModel.h\", \"list\", \"cstring\");\n\
	&add_C_libraries(\"./Main.cc\", \"iomanip\", \"cs\
tring\",\"climits\");\n	`rm *.exe $SILENT`;\n	&flu\
sh_command (\"make $arguments probcons\");\n	&chec\
k_cp(\"probcons\", \"$BIN/$pg\");\n	repo_store(\"$\
BIN/$pg\");\n      }\n\n	#\n	# MUSCLE module\n	#\n\
    elsif (  $pg eq \"muscle\")\n      {	\n	`rm *.\
o muscle muscle.exe $SILENT`;\n	if ($OS eq \"macos\
x\" || $OS eq \"linux\")\n	  {\n	    &replace_line\
_in_file (\"./Makefile\", \"LDLIBS = -lm -static\"\
,  \"LDLIBS = -lm\");\n	  }\n	elsif ($OS eq \"wind\
ows\")\n	  {\n	    &replace_line_in_file (\"./intm\
ath.cpp\",  \"double log2e\",      \"double cedric\
_log\");\n	    &replace_line_in_file (\"./intmath.\
cpp\",  \"double log2\",       \"double log_notuse\
\");\n	    &replace_line_in_file (\"./intmath.cpp\\
",  \"double cedric_log\", \"double log2e\");\n	  \
}\n	&flush_command (\"make $arguments all\");\n	&c\
heck_cp(\"$pg\", \"$BIN\");\n	repo_store(\"$pg\");\
	\n      }\n      \n     #\n     # MUS4 module\n  \
   #\n     elsif (  $pg eq \"mus4\")\n      {\n	`r\
m *.o muscle muscle.exe $SILENT`;\n	&flush_command\
 (\"./mk\");\n	&check_cp(\"$pg\", \"$BIN\");\n	rep\
o_store(\"$pg\");	\n      }\n      \n    #\n    # \
PCMA module\n    #\n    elsif ( $pg eq \"pcma\")\n\
      {\n	if ($OS eq \"macosx\")\n	  {\n	    &repl\
ace_line_in_file (\"./alcomp2.c\", \"malloc.h\",  \
\"\");\n	  }\n	&flush_command (\"make $arguments p\
cma\");\n	&check_cp(\"$pg\", \"$BIN\");\n	repo_sto\
re(\"$pg\");	\n      }\n      \n    #\n    # KALIG\
N module\n    #\n    elsif ($pg eq \"kalign\")\n  \
    {\n	&flush_command (\"./configure\");\n	&flush\
_command(\"make $arguments\");\n	&check_cp (\"$pg\\
",$BIN);\n	repo_store(\"$pg\");	\n      }\n      \\
n    #\n    # AMAP module\n    #\n    elsif ( $pg \
eq \"amap\")\n      {\n	&add_C_libraries(\"./Amap.\
cc\", \"iomanip\", \"cstring\",\"climits\");	\n	`m\
ake clean $SILENT`;\n	&flush_command (\"make $argu\
ments all\");\n	&check_cp (\"$pg\", $BIN);\n	repo_\
store(\"$pg\");	\n      }\n      \n    #\n    # PR\
ODA module\n    #\n    elsif ( $pg eq \"proda\")\n\
      {\n	`sed -i '' 's/int errno = 0;/int errno; \
errno = 0;/' Main.cc`;\n	&add_C_libraries(\"Aligne\
dFragment.h\", \"vector\", \"iostream\", \"cstring\
\",\"cstdlib\");\n	&add_C_libraries(\"Main.cc\", \\
"vector\", \"climits\");	\n	&add_C_libraries(\"Seq\
uence.cc\", \"stdlib.h\", \"cstdio\");	\n	&flush_c\
ommand (\"make $arguments all\");\n	&check_cp (\"$\
pg\", $BIN);\n	repo_store(\"$pg\");	\n      }\n   \
   \n    #\n    # PRANK module\n    #\n    elsif (\
 $pg eq \"prank\")\n      {\n	&flush_command (\"ma\
ke $arguments all\");\n	&check_cp (\"$pg\", $BIN);\
\n	repo_store(\"$pg\");	\n      }\n      \n    #\n\
    # !!!! MUSTANG module\n    #\n     elsif ( $pg\
 eq \"mustang\")\n      {\n	&flush_command (\"rm .\
/bin/*\");\n	&flush_command (\"make $arguments all\
\");\n\n	if ( $OS=~/windows/){&flush_command(\"cp \
./bin/* $BIN/mustang.exe\");}\n	else {&flush_comma\
nd(\"cp ./bin/* $BIN/mustang\");}\n	\n	repo_store(\
\"$BIN/mustang\");\n      }\n\n	#\n	# RNAplfold mo\
dule\n	#\n    elsif ( $pg eq \"RNAplfold\")\n     \
 {\n	&flush_command(\"./configure\");\n	&flush_com\
mand (\"make $arguments all\");\n	&check_cp(\"./Pr\
ogs/RNAplfold\", \"$BIN\");\n	&check_cp(\"./Progs/\
RNAalifold\", \"$BIN\");\n	&check_cp(\"./Progs/RNA\
fold\", \"$BIN\");\n	\n	repo_store(\"./Progs/RNApl\
fold\", \"./Progs/RNAalifold\", \"./Progs/RNAfold\\
");\n      }\n      \n    #\n    # !!! RETREE modu\
le\n    #\n    elsif ( $pg eq \"retree\")\n      {\
\n	chdir \"src\";\n	&flush_command (\"cp Makefile.\
unx Makefile\");\n	&flush_command (\"make $argumen\
ts all\");\n	&flush_command (\"make put\");\n	syst\
em \"cp ../exe/* $BIN\";\n	\n	repo_store(\"retree\\
", \"../exe\");\n      }\n	\n    chdir $CDIR;\n   \
 return &pg_is_installed ($pg, $BIN);\n  }\n\nsub \
install_t_coffee_source\n  {\n    my ($pg)=(@_);\n\
    my ($report,$cflags, $arguments, $language, $c\
ompiler) ;\n\n    #1-Install T-Coffee\n    chdir \\
"t_coffee_source\";\n    &flush_command (\"make cl\
ean\");\n    print \"\\n------- Compiling T-Coffee\
\\n\";\n    $language=$PG{$pg} {language2};\n    $\
arguments=$PG{$language}{arguments};\n    \n    if\
 ( $CC ne \"\")\n      {\n	print \"make -i $argume\
nts t_coffee \\n\";\n	&flush_command (\"make -i $a\
rguments t_coffee\");\n      }\n    &check_cp ($pg\
, $BIN);\n    \n    chdir $CDIR;\n    return &pg_i\
s_installed ($pg, $BIN);\n  }\nsub install_TMalign\
\n  {\n    my ($pg)=(@_);\n    my $report;\n    ch\
dir \"t_coffee_source\";\n    print \"\\n------- C\
ompiling TMalign\\n\";\n    `rm TMalign TMalign.ex\
e $SILENT`;\n    if ( $FC ne \"\"){&flush_command \
(\"make -i $PG{Fortran}{arguments} TMalign\");}\n \
   &check_cp ($pg, $BIN);\n    repo_store($pg);\n\\
n    if ( !-e \"$BIN/$pg\" && pg_has_binary_distri\
b ($pg))\n      {\n	print \"!!!!!!! Compilation of\
 $pg impossible. Will try to install from binary\\\
n\";\n	return &install_binary_package ($pg);\n    \
  }\n    chdir $CDIR;\n    return &pg_is_installed\
 ($pg, $BIN);\n  }\n\nsub pg_has_binary_distrib\n \
 {\n    my ($pg)=(@_);\n    if ($PG{$pg}{windows})\
{return 1;}\n    elsif ($PG{$pg}{osx}){return 1;}\\
n    elsif ($PG{$pg}{macosx}){return 1;}\n\n    el\
sif ($PG{$pg}{linux}){return 1;}\n    return 0;\n \
 }\nsub install_binary_package\n  {\n    my ($pg)=\
(@_);\n    my ($base,$report,$name, $download, $ar\
guments, $language, $dir);\n    my $isdir;\n    &i\
nput_os();\n    \n    #\n    # - paolodt - Check i\
f the module exists in the repository cache \n    \
#\n	if( repo_load($pg) ) {\n	    $PG{$pg}{from_bin\
ary}=1;\n		return 1;\n	}\n    # - paolodt - end \n\
    \n    if (!&supported_os($OS)){return 0;}\n   \
 if ( $PG{$pg}{binary}){$name=$PG{$pg}{binary};}\n\
    else {$name=$pg;}\n    if ($name eq \"t_coffee\
\")\n      {\n	#check if local bin is there\n	if (\
-e \"./bin/$OS/t_coffee\")\n	  {\n	    print \"\\n\
------- Installing  T-Coffee from Pre-Compiled/Pre\
-Downloaded $OS binary\\n\";\n	    print \"\\n----\
--- If you want to trigger a fresh compilation use\
 -recompile\\n\";\n	    &check_cp (\"./bin/$OS/t_c\
offee\", $BIN);\n	    return &pg_is_installed ($pg\
, $BIN);\n	  }\n	#try to get precompiled binary --\
 available from MAC is distribution from MAC\n	els\
e\n	  {\n	    $download=\"$WEB_BASE/Packages/Binar\
ies/tcoffee/$OS/$name.$VERSION\";\n	  }\n      }\n\
    else\n      {\n	$download=\"$WEB_BASE/Packages\
/Binaries/plugins/$OS/$name\";\n      }\n    \n   \
 $base=cwd();\n    chdir $TMP;\n    \n    if (!-e \
$name)\n      {\n	`rm x $SILENT`;\n	if ( url2file(\
\"$download\",\"x\")==$EXIT_SUCCESS)\n	  {\n	    `\
mv x $name`;\n	  }\n      }\n    \n    if (!-e $na\
me)\n      {\n	print \"!!!!!!! $PG{$pg}{dname}: Do\
wnload of $pg binary failed\\n\";\n	print \"!!!!!!\
! $PG{$pg}{dname}: Check Address: $download\\n\";\\
n	chdir $base;\n	return 0;\n      }\n    print \"\\
\n------- Installing $pg\\n\";\n    \n    if ($nam\
e =~/tar\\.gz/)\n      {\n	`gunzip  -f $name`;\n	`\
tar -xvf $pg.tar`;\n	chdir $pg;\n	`chmod u+x *`;\n\
 	`mv * $BIN`;\n	#if (!($pg=~/\\*/)){`rm -rf $pg`;\
}\n      }\n    else\n      {\n	&check_cp (\"$pg\"\
, \"$BIN\");\n	`chmod u+x $BIN/$pg`; \n	unlink ($p\
g);\n      }\n    chdir $base;\n    $PG{$pg}{from_\
binary}=1;\n\n    return &pg_is_installed ($pg, $B\
IN);\n  }\n\n	\nsub add_dir\n  {\n    my $dir=@_[0\
];\n    \n    if (!-e $dir && !-d $dir)\n      {\n\
	my @l;\n	umask (0000);\n	@l=mkpath ($dir,{mode =>\
 0777});\n	\n      }\n    else\n      {\n	return 0\
;\n      }\n  }\nsub check_rm \n  {\n    my ($file\
)=(@_);\n    \n    if ( -e $file)\n      {\n	retur\
n unlink($file);\n      }\n    return 0;\n  }\nsub\
 check_cp\n  {\n    my ($from, $to)=(@_);\n    if \
( !-e $from && -e \"$from\\.exe\"){$from=\"$from\\\
.exe\";}\n    if ( !-e $from){return 0;}\n        \
\n    `$CP $from $to`;\n    return 1;\n  }\n\nsub \
repo_store \n{\n   # check that all required data \
are available\n   if( $REPO_ROOT eq \"\" ) { retur\
n; }\n\n\n    # extract the package name from the \
specified path\n    my $pg =`basename $_[0]`;\n   \
 chomp($pg);\n	\n    my $VER = $PG{$pg}{version};\\
n    my $CACHE = \"$REPO_ROOT/$pg/$VER/$OSNAME-$OS\
ARCH\"; \n    \n    print \"-------- Storing packa\
ge: \\\"$pg\\\" to path: $CACHE\\n\";\n    \n    #\
 clean the cache path if exists and create it agai\
n\n    `rm -rf $CACHE`;\n    `mkdir -p $CACHE`;\n \
   \n 	for my $path (@_) {\n\n	    # check if it i\
s a single file \n	 	if( -f $path ) {\n	    	`cp $\
path $CACHE`;\n		}\n		# .. or a directory, in this\
 case copy all the content \n		elsif( -d $path ) {\
\n			opendir(IMD, $path);\n			my @thefiles= readdi\
r(IMD);\n			closedir(IMD);\n			\n			for my $_file \
(@thefiles) {\n				if( $_file ne \".\" && $_file n\
e \"..\") {\n	    			`cp $path/$_file $CACHE`;\n		\
		}\n			}\n		} \n	}	   \n    \n	\n}   \n\nsub repo\
_load \n{\n    my ($pg)=(@_);\n\n    #Bypass the R\
epository Cache\n    return 0;\n    # check that a\
ll required data are available\n    if( $REPO_ROOT\
 eq \"\" ) { return 0; }\n\n    my $VER = $PG{$pg}\
{version};\n    my $CACHE = \"$REPO_ROOT/$pg/$VER/\
$OSNAME-$OSARCH\"; \n    if( !-e \"$CACHE/$pg\" ) \
{\n   	 	print \"-------- Module \\\"$pg\\\" NOT f\
ound on repository cache.\\n\";\n    	return 0;\n \
   }\n    \n    print \"-------- Module \\\"$pg\\\\
" found on repository cache. Using copy on path: $\
CACHE\\n\";\n    `cp $CACHE/* $BIN`;\n    return 1\
;\n}\n\nsub check_file_list_exists \n  {\n    my (\
$base, @flist)=(@_);\n    my $f;\n\n    foreach $f\
 (@flist)\n      {\n	if ( !-e \"$base/$f\"){return\
 0;}\n      }\n    return 1;\n  }\nsub ls\n  {\n  \
  my $f=@_[0];\n    my @fl;\n    chomp(@fl=`ls -1 \
$f`);\n    return @fl;\n  }\nsub flush_command\n  \
{\n    my $command=@_[0];\n    my $F=new FileHandl\
e;\n    open ($F, \"$command|\");\n    while (<$F>\
){print \"    --- $_\";}\n    close ($F);\n  }    \
\n\nsub input_installation_directory\n  {\n    my \
$dir=@_[0];\n    my $new;\n    \n    print \"-----\
-- The current installation directory is: [$dir]\\\
n\";\n    print \"??????? Return to keep the defau\
lt or new value:\";\n   \n    if ($NO_QUESTION==0)\
\n      {\n	chomp ($new=<stdin>);\n	while ( $new n\
e \"\" && !input_yes (\"You have entered $new. Is \
this correct? ([y]/n):\"))\n	  {\n	    print \"???\
????New installation directory:\";\n	    chomp ($n\
ew=<stdin>);\n	  }\n	$dir=($new eq \"\")?$dir:$new\
;\n	$dir=~s/\\/$//;\n      }\n    \n    if ( -d $d\
ir){return $dir;}\n    elsif (&root_run (\"You mus\
t be root to create $dir\",\"mkdir $dir\")==$EXIT_\
SUCCESS){return $dir;}\n    else\n      {\n	print \
\"!!!!!!! $dir could not be created\\n\";\n	if ( $\
NO_QUESTION)\n	  {\n	    return \"\";\n	  }\n	elsi\
f ( &input_yes (\"??????? Do you want to provide a\
 new directory([y]/n)?:\"))\n	  {\n	    return inp\
ut_installation_directory ($dir);\n	  }\n	else\n	 \
 {\n	    return \"\";\n	  }\n      }\n    \n  }\ns\
ub input_yes\n  {\n    my $question =@_[0];\n    m\
y $answer;\n\n    if ($NO_QUESTION==1){return 1;}\\
n    \n    if ($question eq \"\"){$question=\"????\
??? Do you wish to proceed ([y]/n)?:\";}\n    prin\
t $question;\n    chomp($answer=lc(<STDIN>));\n   \
 if (($answer=~/^y/) || $answer eq \"\"){return 1;\
}\n    elsif ( ($answer=~/^n/)){return 0;}\n    el\
se\n      {\n	return input_yes($question);\n      \
}\n  }\nsub root_run\n  {\n    my ($txt, $cmd)=(@_\
);\n    \n    if ( system ($cmd)==$EXIT_SUCCESS){r\
eturn $EXIT_SUCCESS;}\n    else \n      {\n	print \
\"------- $txt\\n\";\n	if ( $ROOT eq \"sudo\"){ret\
urn system (\"sudo $cmd\");}\n	else {return system\
 (\"su root -c \\\"$cmd\\\"\");}\n      }\n  }\nsu\
b get_root\n  {\n    if (&pg_is_installed (\"sudo\\
")){return \"sudo\";}\n    else {return \"su\";}\n\
  }\n\nsub get_os\n  {\n    my $raw_os=`uname`;\n \
   my $os;\n\n    $raw_os=lc ($raw_os);\n    \n   \
 if ($raw_os =~/cygwin/){$os=\"windows\";}\n    el\
sif ($raw_os =~/linux/){$os=\"linux\";}\n    elsif\
 ($raw_os =~/osx/){$os=\"macosx\";}\n    elsif ($r\
aw_os =~/darwin/){$os=\"macosx\";}\n    else\n    \
  {\n	$os=$raw_os;\n      }\n    return $os;\n  }\\
nsub input_os\n  {\n    my $answer;\n    if ($OS) \
{return $OS;}\n    \n    print \"??????? which os \
do you use: [w]indows, [l]inux, [m]acosx:?\";\n   \
 $answer=lc(<STDIN>);\n\n    if (($answer=~/^m/)){\
$OS=\"macosx\";}\n    elsif ( ($answer=~/^w/)){$OS\
=\"windows\";}\n    elsif ( ($answer=~/^linux/)){$\
OS=\"linux\";}\n    \n    else\n      {\n	return &\
input_os();\n      }\n    return $OS;\n  }\n\nsub \
supported_os\n  {\n    my ($os)=(@_[0]);\n    retu\
rn $SUPPORTED_OS{$os};\n  }\n\nsub add2env_file\n \
 {\n    my ($env, $var, $value)=(@_);\n    my $F =\
 new FileHandle;\n    my $t;\n    if (!$value){ret\
urn;}\n    #make sure new variables do not get dup\
licated\n    if ( -e $env)\n      {\n	open ($F, \"\
$env\");\n	while (<$F>)\n	  {\n	    my $line=$_;\n\
	    if (!($line=~/$var/)){$t.=$line;}\n	  }\n	clo\
se ($F);\n      }\n    $t.=\"$var=$value\\n\";\n  \
  open ($F, \">$env\");\n    print $F \"$t\";\n   \
 $ENV{$var}=$value;\n    close ($F);\n  }    \n   \
 \n\n\nsub update_tclinkdb \n  {\n    my $file =@_\
[0];\n    my $name;\n    my $F=new FileHandle;\n  \
  my ($download, $address, $name, $l, $db);\n    \\
n    if ( $file eq \"update\"){$file=$TCLINKDB_ADD\
RESS;}\n    \n    if ( $file =~/http:\\/\\// || $f\
ile =~/ftp:\\/\\//)\n      {\n	($address, $name)=(\
$download=~/(.*)\\/([^\\/]+)$/);\n	`rm x $SILENT`;\
\n	if (&url2file ($file,\"x\")==$EXIT_SUCCESS)\n	 \
 {\n	    print \"------- Susscessful upload of $na\
me\";\n	    `mv x $name`;\n	    $file=$name;\n	  }\
\n      }\n    open ($F, \"$file\");\n    while (<\
$F>)\n      {\n	my $l=$_;\n	if (($l =~/^\\/\\//) |\
| ($db=~/^#/)){;}\n	elsif ( !($l =~/\\w/)){;}\n	el\
se\n	  {\n	    my @v=split (/\\s+/, $l);\n	    if \
( $l=~/^MODE/)\n	      {\n		$MODE{$v[1]}{$v[2]}=$v\
[3];\n	      }\n	    elsif ($l=~/^PG/)\n	      {\n\
		$PG{$v[1]}{$v[2]}=$v[3];\n	      }\n	  }\n      \
}\n    close ($F);\n    &post_process_PG();\n    r\
eturn;\n  }\n\n\n\nsub initialize_PG\n  {\n\n$PG{\\
"t_coffee\"}{\"4_TCOFFEE\"}=\"TCOFFEE\";\n$PG{\"t_\
coffee\"}{\"type\"}=\"sequence_multiple_aligner\";\
\n$PG{\"t_coffee\"}{\"ADDRESS\"}=\"http://www.tcof\
fee.org\";\n$PG{\"t_coffee\"}{\"language\"}=\"C++\\
";\n$PG{\"t_coffee\"}{\"language2\"}=\"CXX\";\n$PG\
{\"t_coffee\"}{\"source\"}=\"http://www.tcoffee.or\
g/Packages/sources/tcoffee/stable/T-COFFEE_distrib\
ution.tar.gz\";\n$PG{\"t_coffee\"}{\"update_action\
\"}=\"always\";\n$PG{\"t_coffee\"}{\"binary\"}=\"t\
_coffee\";\n$PG{\"t_coffee\"}{\"mode\"}=\"tcoffee,\
mcoffee,rcoffee,expresso,3dcoffee\";\n$PG{\"clusta\
lo\"}{\"4_TCOFFEE\"}=\"CLUSTALO\";\n$PG{\"clustalo\
\"}{\"type\"}=\"sequence_multiple_aligner\";\n$PG{\
\"clustalo\"}{\"ADDRESS\"}=\"http://www.clustal.or\
g/omega/\";\n$PG{\"clustalo\"}{\"language\"}=\"C++\
\";\n$PG{\"clustalo\"}{\"language2\"}=\"C++\";\n$P\
G{\"clustalo\"}{\"source\"}=\"http://www.clustal.o\
rg/omega/clustal-omega-1.2.4.tar.gz\";\n$PG{\"clus\
talo\"}{\"mode\"}=\"mcoffee\";\n$PG{\"clustalo\"}{\
\"binary\"}=\"clustalo\";\n$PG{\"clustalo\"}{\"ver\
sion\"}=\"1.2.4\";\n$PG{\"strike\"}{\"4_TCOFFEE\"}\
=\"STRIKE\";\n$PG{\"strike\"}{\"type\"}=\"sequence\
_alignment_scoring\";\n$PG{\"strike\"}{\"ADDRESS\"\
}=\"http://www.tcoffee.org/Projects/strike/index.h\
tml\";\n$PG{\"strike\"}{\"language\"}=\"C++\";\n$P\
G{\"strike\"}{\"language2\"}=\"CXX\";\n$PG{\"strik\
e\"}{\"source\"}=\"http://www.tcoffee.org/Projects\
/strike/strike_v1.2.tar.bz2\";\n$PG{\"strike\"}{\"\
mode\"}=\"tcoffee,expresso\";\n$PG{\"strike\"}{\"v\
ersion\"}=\"1.2\";\n$PG{\"strike\"}{\"binary\"}=\"\
strike\";\n$PG{\"clustalw2\"}{\"4_TCOFFEE\"}=\"CLU\
STALW2\";\n$PG{\"clustalw2\"}{\"type\"}=\"sequence\
_multiple_aligner\";\n$PG{\"clustalw2\"}{\"ADDRESS\
\"}=\"http://www.clustal.org\";\n$PG{\"clustalw2\"\
}{\"language\"}=\"C++\";\n$PG{\"clustalw2\"}{\"lan\
guage2\"}=\"CXX\";\n$PG{\"clustalw2\"}{\"source\"}\
=\"http://www.clustal.org/download/2.0.10/clustalw\
-2.0.10-src.tar.gz\";\n$PG{\"clustalw2\"}{\"mode\"\
}=\"mcoffee,rcoffee\";\n$PG{\"clustalw2\"}{\"binar\
y\"}=\"clustalw2\";\n$PG{\"clustalw2\"}{\"version\\
"}=\"2.0.10\";\n$PG{\"clustalw\"}{\"4_TCOFFEE\"}=\\
"CLUSTALW\";\n$PG{\"clustalw\"}{\"type\"}=\"sequen\
ce_multiple_aligner\";\n$PG{\"clustalw\"}{\"ADDRES\
S\"}=\"http://www.clustal.org\";\n$PG{\"clustalw\"\
}{\"language\"}=\"C\";\n$PG{\"clustalw\"}{\"langua\
ge2\"}=\"C\";\n$PG{\"clustalw\"}{\"source\"}=\"htt\
p://www.clustal.org/download/1.X/ftp-igbmc.u-stras\
bg.fr/pub/ClustalW/clustalw1.82.UNIX.tar.gz\";\n$P\
G{\"clustalw\"}{\"mode\"}=\"mcoffee,rcoffee\";\n$P\
G{\"clustalw\"}{\"version\"}=\"1.82\";\n$PG{\"clus\
talw\"}{\"binary\"}=\"clustalw\";\n$PG{\"dialign-t\
\"}{\"4_TCOFFEE\"}=\"DIALIGNT\";\n$PG{\"dialign-t\\
"}{\"type\"}=\"sequence_multiple_aligner\";\n$PG{\\
"dialign-t\"}{\"ADDRESS\"}=\"http://dialign-tx.gob\
ics.de/\";\n$PG{\"dialign-t\"}{\"DIR\"}=\"/usr/sha\
re/dialign-tx/\";\n$PG{\"dialign-t\"}{\"language\"\
}=\"C\";\n$PG{\"dialign-t\"}{\"language2\"}=\"C\";\
\n$PG{\"dialign-t\"}{\"source\"}=\"http://dialign-\
tx.gobics.de/DIALIGN-TX_1.0.2.tar.gz\";\n$PG{\"dia\
lign-t\"}{\"mode\"}=\"mcoffee\";\n$PG{\"dialign-t\\
"}{\"binary\"}=\"dialign-t\";\n$PG{\"dialign-t\"}{\
\"version\"}=\"1.0.2\";\n$PG{\"dialign-tx\"}{\"4_T\
COFFEE\"}=\"DIALIGNTX\";\n$PG{\"dialign-tx\"}{\"ty\
pe\"}=\"sequence_multiple_aligner\";\n$PG{\"dialig\
n-tx\"}{\"ADDRESS\"}=\"http://dialign-tx.gobics.de\
/\";\n$PG{\"dialign-tx\"}{\"DIR\"}=\"/usr/share/di\
align-tx/\";\n$PG{\"dialign-tx\"}{\"language\"}=\"\
C\";\n$PG{\"dialign-tx\"}{\"language2\"}=\"C\";\n$\
PG{\"dialign-tx\"}{\"source\"}=\"http://dialign-tx\
.gobics.de/DIALIGN-TX_1.0.2.tar.gz\";\n$PG{\"diali\
gn-tx\"}{\"mode\"}=\"mcoffee\";\n$PG{\"dialign-tx\\
"}{\"binary\"}=\"dialign-tx\";\n$PG{\"dialign-tx\"\
}{\"version\"}=\"1.0.2\";\n$PG{\"poa\"}{\"4_TCOFFE\
E\"}=\"POA\";\n$PG{\"poa\"}{\"type\"}=\"sequence_m\
ultiple_aligner\";\n$PG{\"poa\"}{\"ADDRESS\"}=\"ht\
tp://www.bioinformatics.ucla.edu/poa/\";\n$PG{\"po\
a\"}{\"language\"}=\"C\";\n$PG{\"poa\"}{\"language\
2\"}=\"C\";\n$PG{\"poa\"}{\"source\"}=\"http://dow\
nloads.sourceforge.net/poamsa/poaV2.tar.gz\";\n$PG\
{\"poa\"}{\"DIR\"}=\"/usr/share/\";\n$PG{\"poa\"}{\
\"FILE1\"}=\"blosum80.mat\";\n$PG{\"poa\"}{\"mode\\
"}=\"mcoffee\";\n$PG{\"poa\"}{\"binary\"}=\"poa\";\
\n$PG{\"poa\"}{\"version\"}=\"2.0\";\n$PG{\"probco\
ns\"}{\"4_TCOFFEE\"}=\"PROBCONS\";\n$PG{\"probcons\
\"}{\"type\"}=\"sequence_multiple_aligner\";\n$PG{\
\"probcons\"}{\"ADDRESS\"}=\"http://probcons.stanf\
ord.edu/\";\n$PG{\"probcons\"}{\"language2\"}=\"CX\
X\";\n$PG{\"probcons\"}{\"language\"}=\"C++\";\n$P\
G{\"probcons\"}{\"source\"}=\"http://probcons.stan\
ford.edu/probcons_v1_12.tar.gz\";\n$PG{\"probcons\\
"}{\"mode\"}=\"mcoffee\";\n$PG{\"probcons\"}{\"bin\
ary\"}=\"probcons\";\n$PG{\"probcons\"}{\"version\\
"}=\"1.12\";\n$PG{\"msaprobs\"}{\"4_TCOFFEE\"}=\"M\
SAPROBS\";\n$PG{\"msaprobs\"}{\"type\"}=\"sequence\
_multiple_aligner\";\n$PG{\"msaprobs\"}{\"ADDRESS\\
"}=\"http://msaprobs.sourceforge.net/homepage.htm#\
latest\";\n$PG{\"msaprobs\"}{\"language2\"}=\"CXX\\
";\n$PG{\"msaprobs\"}{\"language\"}=\"C++\";\n$PG{\
\"msaprobs\"}{\"source\"}=\"https://sourceforge.ne\
t/projects/msaprobs/files/MSAProbs-MPI/MSAProbs-MP\
I_rel1.0.5.tar.gz\";\n$PG{\"msaprobs\"}{\"mode\"}=\
\"mcoffee\";\n$PG{\"msaprobs\"}{\"binary\"}=\"msap\
robs\";\n$PG{\"msaprobs\"}{\"version\"}=\"1.05\";\\
n$PG{\"msaprobs\"}{\"update_action\"}=\"never\";\n\
$PG{\"upp\"}{\"4_TCOFFEE\"}=\"UPP\";\n$PG{\"upp\"}\
{\"type\"}=\"sequence_multiple_aligner\";\n$PG{\"u\
pp\"}{\"ADDRESS\"}=\"http://www.cs.utexas.edu/user\
s/phylo/software/upp/\";\n$PG{\"upp\"}{\"language2\
\"}=\"CXX\";\n$PG{\"upp\"}{\"language\"}=\"C++\";\\
n$PG{\"upp\"}{\"source\"}=\"https://github.com/smi\
rarab/pasta/archive/upp.zip\";\n$PG{\"upp\"}{\"mod\
e\"}=\"mcoffee\";\n$PG{\"upp\"}{\"binary\"}=\"upp\\
";\n$PG{\"upp\"}{\"version\"}=\"1\";\n$PG{\"upp\"}\
{\"update_action\"}=\"never\";\n$PG{\"famsa\"}{\"4\
_TCOFFEE\"}=\"FAMSA\";\n$PG{\"famsa\"}{\"type\"}=\\
"sequence_multiple_aligner\";\n$PG{\"famsa\"}{\"AD\
DRESS\"}=\"https://github.com/refresh-bio/FAMSA\";\
\n$PG{\"famsa\"}{\"language\"}=\"C++\";\n$PG{\"fam\
sa\"}{\"language\"}=\"C++\";\n$PG{\"famsa\"}{\"sou\
rce\"}=\"https://github.com/refresh-bio/FAMSA.git\\
";\n$PG{\"famsa\"}{\"mode\"}=\"mcoffee,rcoffee\";\\
n$PG{\"famsa\"}{\"binary\"}=\"famsa\";\n$PG{\"fams\
a\"}{\"version\"}=\"1.1\";\n$PG{\"mafft\"}{\"4_TCO\
FFEE\"}=\"MAFFT\";\n$PG{\"mafft\"}{\"type\"}=\"seq\
uence_multiple_aligner\";\n$PG{\"mafft\"}{\"ADDRES\
S\"}=\"http://align.bmr.kyushu-u.ac.jp/mafft/onlin\
e/server/\";\n$PG{\"mafft\"}{\"language\"}=\"C\";\\
n$PG{\"mafft\"}{\"language\"}=\"C\";\n$PG{\"mafft\\
"}{\"source\"}=\"http://mafft.cbrc.jp/alignment/so\
ftware/mafft-7.310-with-extensions-src.tgz\";\n$PG\
{\"mafft\"}{\"mode\"}=\"mcoffee,rcoffee\";\n$PG{\"\
mafft\"}{\"binary\"}=\"mafft.tar.gz\";\n$PG{\"maff\
t\"}{\"version\"}=\"7.310\";\n$PG{\"msa\"}{\"4_TCO\
FFEE\"}=\"MSA\";\n$PG{\"msa\"}{\"type\"}=\"sequenc\
e_multiple_aligner\";\n$PG{\"msa\"}{\"ADDRESS\"}=\\
"https://www.ncbi.nlm.nih.gov/CBBresearch/Schaffer\
/msa.html\";\n$PG{\"msa\"}{\"language\"}=\"C\";\n$\
PG{\"msa\"}{\"language\"}=\"C\";\n$PG{\"msa\"}{\"s\
ource\"}=\"ftp://ftp.ncbi.nih.gov/pub/msa/msa.tar.\
Z\";\n$PG{\"msa\"}{\"mode\"}=\"mcoffee\";\n$PG{\"m\
sa\"}{\"binary\"}=\"msa.pl\";\n$PG{\"msa\"}{\"vers\
ion\"}=\"1.0\";\n$PG{\"msa\"}{\"update_action\"}=\\
"never\";\n$PG{\"dca\"}{\"4_TCOFFEE\"}=\"DCA\";\n$\
PG{\"dca\"}{\"type\"}=\"sequence_multiple_aligner\\
";\n$PG{\"dca\"}{\"ADDRESS\"}=\"https://bibiserv2.\
cebitec.uni-bielefeld.de/dca\";\n$PG{\"dca\"}{\"la\
nguage\"}=\"C\";\n$PG{\"dca\"}{\"language\"}=\"C\"\
;\n$PG{\"dca\"}{\"source\"}=\"https://bibiserv2.ce\
bitec.uni-bielefeld.de/applications/dca/resources/\
downloads/dca-1.1-src.tar.gz\";\n$PG{\"dca\"}{\"mo\
de\"}=\"mcoffee\";\n$PG{\"dca\"}{\"binary\"}=\"dca\
.pl\";\n$PG{\"dca\"}{\"version\"}=\"1.1\";\n$PG{\"\
dca\"}{\"update_action\"}=\"never\";\n$PG{\"muscle\
\"}{\"4_TCOFFEE\"}=\"MUSCLE\";\n$PG{\"muscle\"}{\"\
type\"}=\"sequence_multiple_aligner\";\n$PG{\"musc\
le\"}{\"ADDRESS\"}=\"http://www.drive5.com/muscle/\
\";\n$PG{\"muscle\"}{\"language\"}=\"C++\";\n$PG{\\
"muscle\"}{\"language2\"}=\"GPP\";\n$PG{\"muscle\"\
}{\"source\"}=\"http://www.drive5.com/muscle/downl\
oads3.7/muscle3.7_src.tar.gz\";\n$PG{\"muscle\"}{\\
"windows\"}=\"http://www.drive5.com/muscle/downloa\
ds3.7/muscle3.7_win32.zip\";\n$PG{\"muscle\"}{\"li\
nux\"}=\"http://www.drive5.com/muscle/downloads3.7\
/muscle3.7_linux_ia32.tar.gz\";\n$PG{\"muscle\"}{\\
"mode\"}=\"mcoffee,rcoffee\";\n$PG{\"muscle\"}{\"v\
ersion\"}=\"3.7\";\n$PG{\"pcma\"}{\"4_TCOFFEE\"}=\\
"PCMA\";\n$PG{\"pcma\"}{\"type\"}=\"sequence_multi\
ple_aligner\";\n$PG{\"pcma\"}{\"ADDRESS\"}=\"http:\
//prodata.swmed.edu/pcma/pcma.php\";\n$PG{\"pcma\"\
}{\"language\"}=\"C\";\n$PG{\"pcma\"}{\"language2\\
"}=\"C\";\n$PG{\"pcma\"}{\"source\"}=\"http://prod\
ata.swmed.edu/download/pub/PCMA/pcma.tar.gz\";\n$P\
G{\"pcma\"}{\"mode\"}=\"mcoffee\";\n$PG{\"pcma\"}{\
\"version\"}=\"1.0\";\n$PG{\"kalign\"}{\"4_TCOFFEE\
\"}=\"KALIGN\";\n$PG{\"kalign\"}{\"type\"}=\"seque\
nce_multiple_aligner\";\n$PG{\"kalign\"}{\"ADDRESS\
\"}=\"http://msa.cgb.ki.se\";\n$PG{\"kalign\"}{\"l\
anguage\"}=\"C\";\n$PG{\"kalign\"}{\"language2\"}=\
\"C\";\n$PG{\"kalign\"}{\"source\"}=\"http://msa.c\
gb.ki.se/downloads/kalign/current.tar.gz\";\n$PG{\\
"kalign\"}{\"mode\"}=\"mcoffee\";\n$PG{\"kalign\"}\
{\"version\"}=\"1.0\";\n$PG{\"amap\"}{\"4_TCOFFEE\\
"}=\"AMAP\";\n$PG{\"amap\"}{\"type\"}=\"sequence_m\
ultiple_aligner\";\n$PG{\"amap\"}{\"ADDRESS\"}=\"h\
ttp://bio.math.berkeley.edu/amap/\";\n$PG{\"amap\"\
}{\"language\"}=\"C++\";\n$PG{\"amap\"}{\"language\
2\"}=\"CXX\";\n$PG{\"amap\"}{\"source\"}=\"https:/\
/github.com/mes5k/amap-align/archive/amap.zip\";\n\
$PG{\"amap\"}{\"mode\"}=\"mcoffee\";\n$PG{\"amap\"\
}{\"version\"}=\"2.0\";\n$PG{\"amap\"}{\"update_ac\
tion\"}=\"never\";\n$PG{\"proda\"}{\"4_TCOFFEE\"}=\
\"PRODA\";\n$PG{\"proda\"}{\"type\"}=\"sequence_mu\
ltiple_aligner\";\n$PG{\"proda\"}{\"ADDRESS\"}=\"h\
ttp://proda.stanford.edu\";\n$PG{\"proda\"}{\"lang\
uage\"}=\"C++\";\n$PG{\"proda\"}{\"language2\"}=\"\
CXX\";\n$PG{\"proda\"}{\"source\"}=\"http://proda.\
stanford.edu/proda_1_0.tar.gz\";\n$PG{\"proda\"}{\\
"mode\"}=\"mcoffee\";\n$PG{\"proda\"}{\"version\"}\
=\"1.0\";\n$PG{\"prank\"}{\"4_TCOFFEE\"}=\"PRANK\"\
;\n$PG{\"prank\"}{\"type\"}=\"sequence_multiple_al\
igner\";\n$PG{\"prank\"}{\"ADDRESS\"}=\"http://www\
.ebi.ac.uk/goldman-srv/prank/\";\n$PG{\"prank\"}{\\
"language\"}=\"C++\";\n$PG{\"prank\"}{\"language2\\
"}=\"CXX\";\n$PG{\"prank\"}{\"source\"}=\"http://w\
ww.ebi.ac.uk/goldman-srv/prank/src/prank/prank.src\
.100802.tgz\";\n$PG{\"prank\"}{\"mode\"}=\"mcoffee\
\";\n$PG{\"prank\"}{\"version\"}=\"100303\";\n$PG{\
\"sap\"}{\"4_TCOFFEE\"}=\"SAP\";\n$PG{\"sap\"}{\"t\
ype\"}=\"structure_pairwise_aligner\";\n$PG{\"sap\\
"}{\"ADDRESS\"}=\"https://mathbio.crick.ac.uk/wiki\
/Software#SAP\";\n$PG{\"sap\"}{\"language\"}=\"C\"\
;\n$PG{\"sap\"}{\"language2\"}=\"C\";\n$PG{\"sap\"\
}{\"source\"}=\"https://github.com/jkleinj/SAP/arc\
hive/v.1.1.3.tar.gz\";\n$PG{\"sap\"}{\"mode\"}=\"e\
xpresso,3dcoffee\";\n$PG{\"sap\"}{\"version\"}=\"1\
.1.3\";\n$PG{\"sap\"}{\"binary\"}=\"sap\";\n$PG{\"\
TMalign\"}{\"4_TCOFFEE\"}=\"TMALIGN\";\n$PG{\"TMal\
ign\"}{\"type\"}=\"structure_pairwise_aligner\";\n\
$PG{\"TMalign\"}{\"ADDRESS\"}=\"http://zhanglab.cc\
mb.med.umich.edu/TM-align/TMalign.f\";\n$PG{\"TMal\
ign\"}{\"language\"}=\"Fortran\";\n$PG{\"TMalign\"\
}{\"language2\"}=\"Fortran\";\n$PG{\"TMalign\"}{\"\
source\"}=\"http://zhanglab.ccmb.med.umich.edu/TM-\
align/TMalign.f\";\n$PG{\"TMalign\"}{\"linux\"}=\"\
http://zhanglab.ccmb.med.umich.edu/TM-align/TMalig\
n_32.gz\";\n$PG{\"TMalign\"}{\"mode\"}=\"expresso,\
3dcoffee\";\n$PG{\"TMalign\"}{\"version\"}=\"2013.\
05.11\";\n$PG{\"mustang\"}{\"4_TCOFFEE\"}=\"MUSTAN\
G\";\n$PG{\"mustang\"}{\"type\"}=\"structure_pairw\
ise_aligner\";\n$PG{\"mustang\"}{\"ADDRESS\"}=\"ht\
tp://lcb.infotech.monash.edu.au/mustang/\";\n$PG{\\
"mustang\"}{\"language\"}=\"C++\";\n$PG{\"mustang\\
"}{\"language2\"}=\"CXX\";\n$PG{\"mustang\"}{\"sou\
rce\"}=\"http://lcb.infotech.monash.edu.au/mustang\
/mustang_v3.2.3.tgz\";\n$PG{\"mustang\"}{\"mode\"}\
=\"expresso,3dcoffee\";\n$PG{\"mustang\"}{\"versio\
n\"}=\"3.2.3\";\n$PG{\"lsqman\"}{\"4_TCOFFEE\"}=\"\
LSQMAN\";\n$PG{\"lsqman\"}{\"type\"}=\"structure_p\
airwise_aligner\";\n$PG{\"lsqman\"}{\"ADDRESS\"}=\\
"empty\";\n$PG{\"lsqman\"}{\"language\"}=\"empty\"\
;\n$PG{\"lsqman\"}{\"language2\"}=\"empty\";\n$PG{\
\"lsqman\"}{\"source\"}=\"empty\";\n$PG{\"lsqman\"\
}{\"update_action\"}=\"never\";\n$PG{\"lsqman\"}{\\
"mode\"}=\"expresso,3dcoffee\";\n$PG{\"align_pdb\"\
}{\"4_TCOFFEE\"}=\"ALIGN_PDB\";\n$PG{\"align_pdb\"\
}{\"type\"}=\"structure_pairwise_aligner\";\n$PG{\\
"align_pdb\"}{\"ADDRESS\"}=\"empty\";\n$PG{\"align\
_pdb\"}{\"language\"}=\"empty\";\n$PG{\"align_pdb\\
"}{\"language2\"}=\"empty\";\n$PG{\"align_pdb\"}{\\
"source\"}=\"empty\";\n$PG{\"align_pdb\"}{\"update\
_action\"}=\"never\";\n$PG{\"align_pdb\"}{\"mode\"\
}=\"expresso,3dcoffee\";\n$PG{\"fugueali\"}{\"4_TC\
OFFEE\"}=\"FUGUE\";\n$PG{\"fugueali\"}{\"type\"}=\\
"structure_pairwise_aligner\";\n$PG{\"fugueali\"}{\
\"ADDRESS\"}=\"http://mizuguchilab.org/fugue/\";\n\
$PG{\"fugueali\"}{\"language\"}=\"empty\";\n$PG{\"\
fugueali\"}{\"language2\"}=\"empty\";\n$PG{\"fugue\
ali\"}{\"source\"}=\"empty\";\n$PG{\"fugueali\"}{\\
"update_action\"}=\"never\";\n$PG{\"fugueali\"}{\"\
mode\"}=\"expresso,3dcoffee\";\n$PG{\"dalilite.pl\\
"}{\"4_TCOFFEE\"}=\"DALILITEc\";\n$PG{\"dalilite.p\
l\"}{\"type\"}=\"structure_pairwise_aligner\";\n$P\
G{\"dalilite.pl\"}{\"ADDRESS\"}=\"built_in\";\n$PG\
{\"dalilite.pl\"}{\"ADDRESS2\"}=\"http://www.ebi.a\
c.uk/Tools/webservices/services/dalilite\";\n$PG{\\
"dalilite.pl\"}{\"language\"}=\"Perl\";\n$PG{\"dal\
ilite.pl\"}{\"language2\"}=\"Perl\";\n$PG{\"dalili\
te.pl\"}{\"source\"}=\"empty\";\n$PG{\"dalilite.pl\
\"}{\"update_action\"}=\"never\";\n$PG{\"dalilite.\
pl\"}{\"mode\"}=\"expresso,3dcoffee\";\n$PG{\"prob\
consRNA\"}{\"4_TCOFFEE\"}=\"PROBCONSRNA\";\n$PG{\"\
probconsRNA\"}{\"type\"}=\"RNA_multiple_aligner\";\
\n$PG{\"probconsRNA\"}{\"ADDRESS\"}=\"http://probc\
ons.stanford.edu/\";\n$PG{\"probconsRNA\"}{\"langu\
age\"}=\"C++\";\n$PG{\"probconsRNA\"}{\"language2\\
"}=\"CXX\";\n$PG{\"probconsRNA\"}{\"source\"}=\"ht\
tp://probcons.stanford.edu/probconsRNA.tar.gz\";\n\
$PG{\"probconsRNA\"}{\"mode\"}=\"mcoffee,rcoffee\"\
;\n$PG{\"probconsRNA\"}{\"version\"}=\"1.0\";\n$PG\
{\"sfold\"}{\"4_TCOFFEE\"}=\"CONSAN\";\n$PG{\"sfol\
d\"}{\"type\"}=\"RNA_pairwise_aligner\";\n$PG{\"sf\
old\"}{\"ADDRESS\"}=\"http://selab.janelia.org/sof\
tware/consan/\";\n$PG{\"sfold\"}{\"language\"}=\"e\
mpty\";\n$PG{\"sfold\"}{\"language2\"}=\"empty\";\\
n$PG{\"sfold\"}{\"source\"}=\"empty\";\n$PG{\"sfol\
d\"}{\"update_action\"}=\"never\";\n$PG{\"sfold\"}\
{\"mode\"}=\"rcoffee\";\n$PG{\"RNAplfold\"}{\"4_TC\
OFFEE\"}=\"RNAPLFOLD\";\n$PG{\"RNAplfold\"}{\"type\
\"}=\"RNA_secondarystructure_predictor\";\n$PG{\"R\
NAplfold\"}{\"ADDRESS\"}=\"http://www.tbi.univie.a\
c.at/RNA/\";\n$PG{\"RNAplfold\"}{\"language\"}=\"C\
\";\n$PG{\"RNAplfold\"}{\"language2\"}=\"C\";\n$PG\
{\"RNAplfold\"}{\"source\"}=\"http://www.tbi.univi\
e.ac.at/RNA/packages/source/ViennaRNA-2.1.9.tar.gz\
\";\n$PG{\"RNAplfold\"}{\"mode\"}=\"rcoffee,\";\n$\
PG{\"RNAplfold\"}{\"binary\"}=\"RNAplfold.tar.gz\"\
;\n$PG{\"RNAplfold\"}{\"version\"}=\"2.1.9\";\n$PG\
{\"retree\"}{\"4_TCOFFEE\"}=\"PHYLIP\";\n$PG{\"ret\
ree\"}{\"type\"}=\"Phylogeny\";\n$PG{\"retree\"}{\\
"ADDRESS\"}=\"http://evolution.gs.washington.edu/p\
hylip/\";\n$PG{\"retree\"}{\"language\"}=\"C\";\n$\
PG{\"retree\"}{\"language2\"}=\"C\";\n$PG{\"retree\
\"}{\"source\"}=\"http://www.tcoffee.org/Packages/\
mirrors/source/phylip-3.66.tar.gz\";\n$PG{\"retree\
\"}{\"mode\"}=\"trmsd,\";\n$PG{\"retree\"}{\"binar\
y\"}=\"retree.tar.gz\";\n$PG{\"retree\"}{\"version\
\"}=\"3.66\";\n$PG{\"hmmtop\"}{\"4_TCOFFEE\"}=\"HM\
MTOP\";\n$PG{\"hmmtop\"}{\"type\"}=\"protein_secon\
darystructure_predictor\";\n$PG{\"hmmtop\"}{\"ADDR\
ESS\"}=\"www.enzim.hu/hmmtop/\";\n$PG{\"hmmtop\"}{\
\"language\"}=\"C\";\n$PG{\"hmmtop\"}{\"language2\\
"}=\"C\";\n$PG{\"hmmtop\"}{\"source\"}=\"http://ww\
w.tcoffee.org/Packages/mirrors/hmmtop2.1.tgz\";\n$\
PG{\"hmmtop\"}{\"binary\"}=\"hmmtop\";\n$PG{\"hmmt\
op\"}{\"update_action\"}=\"never\";\n$PG{\"hmmtop\\
"}{\"mode\"}=\"psicoffee\";\n$PG{\"hmmtop\"}{\"ver\
sion\"}=\"2.1\";\n$PG{\"gorIV\"}{\"4_TCOFFEE\"}=\"\
GOR4\";\n$PG{\"gorIV\"}{\"type\"}=\"protein_second\
arystructure_predictor\";\n$PG{\"gorIV\"}{\"ADDRES\
S\"}=\"http://mig.jouy.inra.fr/logiciels/gorIV/\";\
\n$PG{\"gorIV\"}{\"language\"}=\"C\";\n$PG{\"gorIV\
\"}{\"language2\"}=\"C\";\n$PG{\"gorIV\"}{\"source\
\"}=\"http://www.tcoffee.org/Packages/mirrors/GOR_\
IV.tar.gz\";\n$PG{\"gorIV\"}{\"update_action\"}=\"\
never\";\n$PG{\"gorIV\"}{\"mode\"}=\"tcoffee\";\n$\
PG{\"wublast.pl\"}{\"4_TCOFFEE\"}=\"EBIWUBLASTc\";\
\n$PG{\"wublast.pl\"}{\"type\"}=\"protein_homology\
_predictor\";\n$PG{\"wublast.pl\"}{\"ADDRESS\"}=\"\
built_in\";\n$PG{\"wublast.pl\"}{\"ADDRESS2\"}=\"h\
ttp://www.ebi.ac.uk/Tools/webservices/services/wub\
last\";\n$PG{\"wublast.pl\"}{\"language\"}=\"Perl\\
";\n$PG{\"wublast.pl\"}{\"language2\"}=\"Perl\";\n\
$PG{\"wublast.pl\"}{\"source\"}=\"empty\";\n$PG{\"\
wublast.pl\"}{\"update_action\"}=\"never\";\n$PG{\\
"wublast.pl\"}{\"mode\"}=\"psicoffee,expresso,accu\
rate\";\n$PG{\"blastpgp.pl\"}{\"4_TCOFFEE\"}=\"EBI\
BLASTPGPc\";\n$PG{\"blastpgp.pl\"}{\"type\"}=\"pro\
tein_homology_predictor\";\n$PG{\"blastpgp.pl\"}{\\
"ADDRESS\"}=\"built_in\";\n$PG{\"blastpgp.pl\"}{\"\
ADDRESS2\"}=\"http://www.ebi.ac.uk/Tools/webservic\
es/services/blastpgp\";\n$PG{\"blastpgp.pl\"}{\"la\
nguage\"}=\"Perl\";\n$PG{\"blastpgp.pl\"}{\"langua\
ge2\"}=\"Perl\";\n$PG{\"blastpgp.pl\"}{\"source\"}\
=\"empty\";\n$PG{\"blastpgp.pl\"}{\"update_action\\
"}=\"never\";\n$PG{\"blastpgp.pl\"}{\"mode\"}=\"ps\
icoffee,expresso,accurate\";\n$PG{\"blastall\"}{\"\
4_TCOFFEE\"}=\"blastall\";\n$PG{\"blastall\"}{\"ty\
pe\"}=\"protein_homology_predictor\";\n$PG{\"blast\
all\"}{\"ADDRESS\"}=\"ftp://ftp.ncbi.nih.gov/blast\
/executables/LATEST\";\n$PG{\"blastall\"}{\"langua\
ge\"}=\"C\";\n$PG{\"blastall\"}{\"language2\"}=\"C\
\";\n$PG{\"blastall\"}{\"source\"}=\"ftp://ftp.ncb\
i.nlm.nih.gov/blast/executables/blast+/2.6.0/ncbi-\
blast-2.6.0+-src.tar.gz\";\n$PG{\"blastall\"}{\"up\
date_action\"}=\"never\";\n$PG{\"blastall\"}{\"mod\
e\"}=\"psicoffee,expresso,3dcoffee\";\n$PG{\"legac\
y_blast.pl\"}{\"4_TCOFFEE\"}=\"NCBIBLAST\";\n$PG{\\
"legacy_blast.pl\"}{\"type\"}=\"protein_homology_p\
redictor\";\n$PG{\"legacy_blast.pl\"}{\"ADDRESS\"}\
=\"ftp://ftp.ncbi.nih.gov/blast/executables/LATEST\
\";\n$PG{\"legacy_blast.pl\"}{\"language\"}=\"C\";\
\n$PG{\"legacy_blast.pl\"}{\"language2\"}=\"C\";\n\
$PG{\"legacy_blast.pl\"}{\"source\"}=\"ftp://ftp.n\
cbi.nlm.nih.gov/blast/executables/blast+/2.6.0/ncb\
i-blast-2.6.0+-src.tar.gz\";\n$PG{\"legacy_blast.p\
l\"}{\"update_action\"}=\"never\";\n$PG{\"legacy_b\
last.pl\"}{\"mode\"}=\"psicoffee,expresso,3dcoffee\
\";\n$PG{\"SOAP::Lite\"}{\"4_TCOFFEE\"}=\"SOAPLITE\
\";\n$PG{\"SOAP::Lite\"}{\"type\"}=\"library\";\n$\
PG{\"SOAP::Lite\"}{\"ADDRESS\"}=\"http://cpansearc\
h.perl.org/src/MKUTTER/SOAP-Lite-0.710.08/Makefile\
.PL\";\n$PG{\"SOAP::Lite\"}{\"language\"}=\"Perl\"\
;\n$PG{\"SOAP::Lite\"}{\"language2\"}=\"Perl\";\n$\
PG{\"SOAP::Lite\"}{\"source\"}=\"empty\";\n$PG{\"S\
OAP::Lite\"}{\"update_action\"}=\"never\";\n$PG{\"\
SOAP::Lite\"}{\"mode\"}=\"none\";\n$PG{\"XML::Simp\
le\"}{\"4_TCOFFEE\"}=\"XMLSIMPLE\";\n$PG{\"XML::Si\
mple\"}{\"type\"}=\"library\";\n$PG{\"XML::Simple\\
"}{\"ADDRESS\"}=\"http://search.cpan.org/~grantm/X\
ML-Simple-2.18/lib/XML/Simple.pm\";\n$PG{\"XML::Si\
mple\"}{\"language\"}=\"Perl\";\n$PG{\"XML::Simple\
\"}{\"language2\"}=\"Perl\";\n$PG{\"XML::Simple\"}\
{\"source\"}=\"empty\";\n$PG{\"XML::Simple\"}{\"mo\
de\"}=\"psicoffee,expresso,accurate\";\n$PG{\"x3dn\
a\"}{\"4_TCOFFEE\"}=\"x3dna\";\n$PG{\"x3dna\"}{\"t\
ype\"}=\"RNA_secondarystructure_predictor\";\n$PG{\
\"x3dna\"}{\"ADDRESS\"}=\"http://x3dna.bio.columbi\
a.edu/\";\n$PG{\"x3dna\"}{\"source\"}=\"http://www\
.tcoffee.org/Packages/mirrors/source/x3dna-v2.3-li\
nux-64bit.tar.gz\";\n$PG{\"x3dna\"}{\"mode\"}=\"sa\
racoffee\";\n$PG{\"x3dna\"}{\"update_action\"}=\"n\
ever\";\n$PG{\"fsa\"}{\"4_TCOFFEE\"}=\"FSA\";\n$PG\
{\"fsa\"}{\"type\"}=\"sequence_multiple_aligner\";\
\n$PG{\"fsa\"}{\"ADDRESS\"}=\"http://fsa.sourcefor\
ge.net/\";\n$PG{\"fsa\"}{\"language\"}=\"C++\";\n$\
PG{\"fsa\"}{\"language2\"}=\"CXX\";\n$PG{\"fsa\"}{\
\"source\"}=\"http://sourceforge.net/projects/fsa/\
files/fsa-1.15.3.tar.gz/download/\";\n$PG{\"fsa\"}\
{\"mode\"}=\"mcoffee\";\n$PG{\"fsa\"}{\"version\"}\
=\"1.15.3\";\n$PG{\"fsa\"}{\"update_action\"}=\"ne\
ver\";\n$PG{\"mus4\"}{\"4_TCOFFEE\"}=\"MUS4\";\n$P\
G{\"mus4\"}{\"type\"}=\"sequence_multiple_aligner\\
";\n$PG{\"mus4\"}{\"ADDRESS\"}=\"http://www.drive5\
.com/muscle/\";\n$PG{\"mus4\"}{\"language\"}=\"C++\
\";\n$PG{\"mus4\"}{\"language2\"}=\"GPP\";\n$PG{\"\
mus4\"}{\"source\"}=\"http://www.drive5.com/muscle\
/muscle4.0_src.tar.gz\";\n$PG{\"mus4\"}{\"mode\"}=\
\"mcoffee,rcoffee\";\n$PG{\"mus4\"}{\"version\"}=\\
"4.0\";\n$PG{\"mus4\"}{\"update_action\"}=\"never\\
";\n$MODE{\"tcoffee\"}{\"name\"}=\"tcoffee\";\n$MO\
DE{\"rcoffee\"}{\"name\"}=\"rcoffee\";\n$MODE{\"3d\
coffee\"}{\"name\"}=\"3dcoffee\";\n$MODE{\"mcoffee\
\"}{\"name\"}=\"mcoffee\";\n$MODE{\"expresso\"}{\"\
name\"}=\"expresso\";\n$MODE{\"trmsd\"}{\"name\"}=\
\"trmsd\";\n$MODE{\"accurate\"}{\"name\"}=\"accura\
te\";\n$MODE{\"seq_reformat\"}{\"name\"}=\"seq_ref\
ormat\";\n\n\n$PG{C}{compiler}=\"gcc\";\n$PG{C}{co\
mpiler_flag}=\"CC\";\n$PG{C}{options}=\"\";\n$PG{C\
}{options_flag}=\"CFLAGS\";\n$PG{C}{type}=\"compil\
er\";\n\n$PG{\"CXX\"}{compiler}=\"g++\";\n$PG{\"CX\
X\"}{compiler_flag}=\"CXX\";\n$PG{\"CXX\"}{options\
}=\"\";\n$PG{\"CXX\"}{options_flag}=\"CXXFLAGS\";\\
n$PG{CXX}{type}=\"compiler\";\n\n$PG{\"CPP\"}{comp\
iler}=\"g++\";\n$PG{\"CPP\"}{compiler_flag}=\"CPP\\
";\n$PG{\"CPP\"}{options}=\"\";\n$PG{\"CPP\"}{opti\
ons_flag}=\"CPPFLAGS\";\n$PG{CPP}{type}=\"compiler\
\";\n\n$PG{\"GPP\"}{compiler}=\"g++\";\n$PG{\"GPP\\
"}{compiler_flag}=\"GPP\";\n$PG{\"GPP\"}{options}=\
\"\";\n$PG{\"GPP\"}{options_flag}=\"CFLAGS\";\n$PG\
{GPP}{type}=\"compiler\";\n\n$PG{Fortran}{compiler\
}=\"g77\";\n$PG{Fortran}{compiler_flag}=\"FCC\";\n\
$PG{Fortran}{type}=\"compiler\";\n\n$PG{Perl}{comp\
iler}=\"CPAN\";\n$PG{Perl}{type}=\"compiler\";\n\n\
$SUPPORTED_OS{macosx}=\"Macintosh\";\n$SUPPORTED_O\
S{linux}=\"Linux\";\n$SUPPORTED_OS{windows}=\"Cygw\
in\";\n\n\n\n$MODE{t_coffee}{description}=\" for r\
egular multiple sequence alignments\";\n$MODE{rcof\
fee} {description}=\" for RNA multiple sequence al\
ignments\";\n\n$MODE{psicoffee} {description}=\" f\
or Homology Extended multiple sequence alignments\\
";\n$MODE{expresso}{description}=\" for very accur\
ate structure based multiple sequence alignments\"\
;\n$MODE{\"3dcoffee\"}{description}=\" for multipl\
e structure alignments\";\n$MODE{mcoffee} {descrip\
tion}=\" for combining alternative multiple sequen\
ce alignment packages\\n------- into a unique meta\
-package. The installer will upload several MSA pa\
ckages and compile them\\n\n\";\n\n\n&post_process\
_PG();\nreturn;\n}\n\nsub post_process_PG\n  {\n  \
  my $p;\n    \n    %PG=&name2dname (%PG);\n    %M\
ODE=&name2dname(%MODE);\n    foreach $p (keys(%PG)\
){if ( $PG{$p}{type} eq \"compiler\"){$PG{$p}{upda\
te_action}=\"never\";}}\n    \n  }\n\nsub name2dna\
me\n  {\n    my (%L)=(@_);\n    my ($l, $ml);\n   \
 \n    foreach my $pg (keys(%L))\n      {\n	$l=len\
gth ($pg);\n	if ( $l>$ml){$ml=$l;}\n      }\n    $\
ml+=1;\n    foreach my $pg (keys(%L))\n      {\n	m\
y $name;\n	$l=$ml-length ($pg);\n	$name=$pg;\n	for\
 ( $b=0; $b<$l; $b++)\n	  {\n	    $name .=\" \";\n\
	  }\n	$L{$pg}{dname}=$name;\n      }\n    return \
%L;\n  }\n\nsub env_file2putenv\n  {\n    my $f=@_\
[0];\n    my $F=new FileHandle;\n    my $n;\n    \\
n    open ($F, \"$f\");\n    while (<$F>)\n      {\
\n	my $line=$_;\n	my($var, $value)=($_=~/(\\S+)\\=\
(\\S*)/);\n	$ENV{$var}=$value;\n	$ENV_SET{$var}=1;\
\n	$n++;\n      }\n    close ($F);\n    return $n;\
\n  }\n\nsub replace_line_in_file\n  {\n    my ($f\
ile, $wordin, $wordout)=@_;\n    my $O=new FileHan\
dle;\n    my $I=new FileHandle;\n    my $l;\n    i\
f (!-e $file){return;}\n    \n    system (\"mv $fi\
le $file.old\");\n    open ($O, \">$file\");\n    \
open ($I, \"$file.old\");\n    while (<$I>)\n     \
 {\n	$l=$_;\n	if (!($l=~/$wordin/)){print $O \"$l\\
";}\n	elsif ( $wordout ne \"\"){$l=~s/$wordin/$wor\
dout/g;print $O \"$l\";}\n      }\n    close ($O);\
\n    close ($I);\n    return;\n  }\n\nsub add_C_l\
ibraries\n  {\n   my ($file,$first,@list)=@_;\n   \
\n    my $O=new FileHandle;\n    my $I=new FileHan\
dle;\n    my ($l,$anchor);\n    if (!-e $file){ret\
urn;}\n   \n    $anchor=\"#include <$first>\";\n	 \
\n    system (\"mv $file $file.old\");\n    open (\
$O, \">$file\");\n    open ($I, \"$file.old\");\n \
   while (<$I>)\n      {\n	$l=$_;\n	print $O \"$l\\
";\n	if (!($l=~/$anchor/))\n	   {\n	    \n	    for\
each my $lib (@list)\n	       {\n                 \
 print $O \"#include <$lib>\\n\";\n	       }\n    \
       }\n      }\n    close ($O);\n    close ($I)\
;\n    return;\n    }\n","use Env;\nuse Cwd;\n@suf\
fix=(\"tmp\", \"temp\", \"cache\", \"t_coffee\", \\
"core\", \"tcoffee\");\n\nif ($#ARGV==-1)\n  {\n  \
  print \"clean_cache.pl -file <file to add in -di\
r> -dir=<dir> -size=<value in Mb>\\n0: unlimited -\
1 always.\\nWill only clean directories matching:[\
\";\n    foreach $k(@suffix){print \"*$k* \";}\n  \
  print \"]\\n\";\n    exit (EXIT_FAILURE);\n  }\n\
\n$cl=join (\" \",@ARGV);\nif (($cl=~/\\-no_action\
/))\n  {\n    exit (EXIT_SUCCESS);\n  }\n\nif (($c\
l=~/\\-debug/))\n  {\n    $DEBUG=1;\n  }\nelse\n  \
{\n    $DEBUG=0;\n  }\n\nif (($cl=~/\\-dir=(\\S+)/\
))\n  {\n    $dir=$1;\n  }\nelse\n  {\n    $dir=\"\
./\";\n  }\n\nif ($cl=~/\\-file=(\\S+)/)\n  {\n   \
 $file=$1;\n  }\nelse\n  {\n    $file=0;\n  }\n\ni\
f ($cl=~/\\-size=(\\S+)/)\n  {\n    $max_size=$1;\\
n  }\nelse\n  {\n    $max_size=0;#unlimited\n  }\n\
if ($cl=~/\\-force/)\n  {\n    $force=1;\n  }\nels\
e\n  {\n    $force=0;\n  }\n\nif ($cl=~/\\-age=(\\\
S+)/)\n  {\n    $max_age=$1;\n  }\nelse\n  {\n    \
$max_age=0;#unlimited\n  }\n\n$max_size*=1000000;\\
nif ( ! -d $dir)\n  {\n    print STDERR \"\\nCanno\
t process $dir: does not exist \\n\";\n    exit (E\
XIT_FAILURE);\n  }\n\nif ( !($dir=~/^\\//))\n  {\n\
    $base=cwd();\n    $dir=\"$base/$dir\";\n  }\n\\
n$proceed=0;\nforeach $s (@suffix)\n  {\n    \n   \
 if (($dir=~/$s/)){$proceed=1;}\n    $s=uc ($s);\n\
    if (($dir=~/$s/)){$proceed=1;}\n  }\nif ( $pro\
ceed==0)\n  {\n    print STDERR \"Clean_cache.pl c\
an only clean directories whose absolute path name\
 contains the following strings:\";\n    foreach $\
w (@suffix) {print STDERR \"$w \";$w=lc($w); print\
 STDERR \"$w \";}\n    print STDERR \"\\nCannot pr\
ocess $dir\\n\";\n    exit (EXIT_FAILURE);\n  }\n\\
n$name_file=\"$dir/name_file.txt\";\n$size_file=\"\
$dir/size_file.txt\";\nif ( $force){&create_ref_fi\
le ($dir,$name_file,$size_file);}\nif ($file){&add\
_file ($dir, $name_file, $size_file, $file);}\n&cl\
ean_dir ($dir, $name_file, $size_file, $max_size,$\
max_age);\nexit (EXIT_SUCCESS);\n\nsub clean_dir \\
n  {\n    my ($dir, $name_file, $size_file, $max_s\
ize, $max_age)=@_;\n    my ($tot_size, $size, $f, \
$s);\n\n  \n    $tot_size=&get_tot_size ($dir, $na\
me_file, $size_file);\n\n    if ( $tot_size<=$max_\
size){return ;}\n    else {$max_size/=2;}\n    \n \
   #recreate the name file in case some temprary f\
iles have not been properly registered\n    &creat\
e_ref_file ($dir, $name_file, $size_file, $max_age\
);\n  \n    $new_name_file=&vtmpnam();\n    open (\
R, \"$name_file\");\n    open (W, \">$new_name_fil\
e\");\n    while (<R>)\n      {\n	my $line=$_;\n	\\
n	($f, $s)=($line=~/(\\S+) (\\S+)/);\n	if ( !($f=~\
/\\S/)){next;}\n	\n	elsif ($max_size && $tot_size>\
=$max_size && !($f=~/name_file/))\n	  {\n	    remo\
ve ( \"$dir/$f\");\n	    $tot_size-=$s;\n	  }\n	el\
sif ( $max_age && -M(\"$dir/$f\")>=$max_age)\n	  {\
\n	    remove ( \"$dir/$f\");\n	    $tot_size-=$s;\
\n	  }\n	else\n	  {\n	    print W \"$f $s\\n\";\n	\
  }\n      }\n    close (R);\n    close (W);\n    \
open (F, \">$size_file\");\n    print F \"$tot_siz\
e\";\n    if ( -e $new_name_file){`mv $new_name_fi\
le $name_file`;}\n    close (F);\n  }\nsub get_tot\
_size\n  {\n    my ($dir, $name_file, $size_file)=\
@_;\n    my $size;\n    \n    if ( !-d $dir){retur\
n 0;}\n    if ( !-e $name_file)\n      {\n	\n	&cre\
ate_ref_file ($dir, $name_file, $size_file);\n    \
  }\n    open (F, \"$size_file\");\n    $size=<F>;\
\n    close (F);\n    chomp ($size);\n    return $\
size;\n  }\nsub size \n  {\n    my $f=@_[0];\n\n  \
  if ( !-d $f){return -s($f);}\n    else {return &\
dir2size($f);}\n  }\nsub dir2size\n  {\n    my $d=\
@_[0];\n    my ($s, $f);\n    \n    if ( !-d $d) {\
return 0;}\n    \n    foreach $f (&dir2list ($d))\\
n      {\n	if ( -d $f){$s+=&dir2size (\"$d/$f\");}\
\n	else {$s+= -s \"$dir/$f\";}\n      }\n    retur\
n $s;\n  }\n\nsub remove \n  {\n    my $file=@_[0]\
;\n    my ($f);\n    \n    debug_print( \"--- $fil\
e ---\\n\");\n    if (($file eq \".\") || ($file e\
q \"..\") || ($file=~/\\*/)){return EXIT_FAILURE;}\
\n    elsif ( !-d $file)\n      {\n	debug_print (\\
"unlink $file\\n\");\n	if (-e $file){unlink ($file\
);}\n      }\n    elsif ( -d $file)\n      {\n	deb\
ug_print (\"++++++++ $file +++++++\\n\");\n	foreac\
h $f (&dir2list($file))\n	  {\n	    &remove (\"$fi\
le/$f\");\n	  }\n	debug_print (\"rmdir $file\\n\")\
;\n	rmdir $file;\n      }\n    else\n      {\n	deb\
ug_print (\"????????? $file ????????\\n\");\n     \
 }\n    return EXIT_SUCCESS;\n  }\n\nsub dir2list\\
n  {\n    my $dir=@_[0];\n    my (@list1, @list2,@\
list3, $l);\n\n    opendir (DIR,$dir);\n    @list1\
=readdir (DIR);\n    closedir (DIR);\n    \n    fo\
reach $l (@list1)\n      {\n	if ( $l ne \".\" && $\
l ne \"..\"){@list2=(@list2, $l);}\n      }\n    @\
list3 = sort { (-M \"$dir/$list2[$b]\") <=> (-M \"\
$dir/$list2[$a]\")} @list2;\n    return @list3;\n \
   \n  }\n\nsub debug_print\n  {\n    \n    if ($D\
EBUG==1){print @_;}\n    \n  }\nsub create_ref_fil\
e\n  {\n    my ($dir,$name_file,$size_file)=@_;\n \
   my ($f, $s, $tot_size, @l);\n    \n    if ( !-d\
 $dir){return;}\n    \n    @l=&dir2list ($dir);\n \
   open (F, \">$name_file\");\n    foreach $f (@l)\
\n      {\n	$s=&size(\"$dir/$f\");\n	$tot_size+=$s\
;\n	print F \"$f $s\\n\";\n      }\n    &myecho ($\
tot_size, \">$size_file\");\n    close (F);\n  }\n\
sub add_file \n  {\n    my ($dir,$name_file,$size_\
file,$file)=@_;\n    my ($s, $tot_size);\n    \n  \
  if ( !-d $dir)   {return;}\n    if ( !-e \"$dir/\
$file\" ) {return;}\n    if ( !-e $name_file){&cre\
ate_ref_file ($dir,$name_file,$size_file);}\n					\
    \n    $s=&size(\"$dir/$file\");\n    open (F, \
\">>$name_file\");\n    print F \"$file\\n\";\n   \
 close (F);\n\n    $tot_size=&get_tot_size ($dir,$\
name_file,$size_file);\n    $tot_size+=$s;\n    &m\
yecho ($tot_size, \">$size_file\");\n    \n  }\n	\\
nsub myecho\n  {\n    my ($string, $file)=@_;\n   \
 open (ECHO, $file) || die;\n    print ECHO \"$str\
ing\";\n    close (ECHO);\n  }\n    \n		\n	\nsub v\
tmpnam\n  {\n    my $tmp_file_name;\n    $tmp_name\
_counter++;\n    $tmp_file_name=\"tmp_file_for_cle\
an_cache_pdb$$.$tmp_name_counter\";\n    $tmp_file\
_list[$ntmp_file++]=$tmp_file_name;\n    if ( -e $\
tmp_file_name) {return &vtmpnam ();}\n    else {re\
turn $tmp_file_name;}\n  }\n","\nmy $address=\"htt\
p://www.tcoffee.org/Data/Datasets/NatureProtocolsD\
ataset.tar.gz\";\nmy $out=\"NatureProtocolsDataset\
.tar.gz\";\n&url2file ($address,$out);\n\nif ( -e \
$out)\n  {\n    \n    system (\"gunzip NatureProto\
colsDataset.tar.gz\");\n    system (\"tar -xvf Nat\
ureProtocolsDataset.tar\");\n  	system (\"rm -rf N\
atureProtocolsDataset.tar\");  \n    print \"Your \
Data Set is in the Folder 'NatureProtocolsDataset'\
\\n\";\n  }\nelse \n  {\n    print \"Could not Dow\
nload Dataset --- Web site may be down -- Try agai\
n later\\n\";\n  }\n\n\n\n\nsub url2file\n{\n    m\
y ($address, $out, $wget_arg, $curl_arg)=(@_);\n  \
  my ($pg, $flag, $r, $arg, $count);\n    \n    if\
 (!$CONFIGURATION){&check_configuration (\"wget\",\
 \"INTERNET\", \"gzip\");$CONFIGURATION=1;}\n    \\
n    if (&pg_is_installed (\"wget\"))   {$pg=\"wge\
t\"; $flag=\"-O\";$arg=$wget_arg;}\n    elsif (&pg\
_is_installed (\"curl\")){$pg=\"curl\"; $flag=\"-o\
\";$arg=$curl_arg;}\n    return system (\"$pg $add\
ress $flag $out>/dev/null 2>/dev/null\");\n\n}\n\n\
sub pg_is_installed\n  {\n    my @ml=@_;\n    my $\
r, $p, $m;\n    my $supported=0;\n    \n    my $p=\
shift (@ml);\n    if ($p=~/::/)\n      {\n	if (sys\
tem (\"perl -M$p -e 1\")==$EXIT_SUCCESS){return 1;\
}\n	else {return 0;}\n      }\n    else\n      {\n\
	$r=`which $p 2>/dev/null`;\n	if ($r eq \"\"){retu\
rn 0;}\n	else {return 1;}\n      }\n  }\nsub check\
_configuration \n    {\n      my @l=@_;\n      my \
$v;\n      foreach my $p (@l)\n	{\n	  \n	  if   ( \
$p eq \"EMAIL\")\n	    { \n	      if ( !($EMAIL=~/\
@/))\n		{\n		  exit (EXIT_FAILURE);\n		}\n	    }\n\
	  elsif( $p eq \"INTERNET\")\n	    {\n	      if (\
 !&check_internet_connection())\n		{\n		  exit (EX\
IT_FAILURE);\n		}\n	    }\n	  elsif( $p eq \"wget\\
")\n	    {\n	      if (!&pg_is_installed (\"wget\"\
) && !&pg_is_installed (\"curl\"))\n		{\n		  exit \
(EXIT_FAILURE);\n		}\n	    }\n	  elsif( !(&pg_is_i\
nstalled ($p)))\n	    {\n	      exit (EXIT_FAILURE\
);\n	    }\n	}\n      return 1;\n    }\nsub check_\
internet_connection\n  {\n    my $internet;\n    m\
y $tmp;\n    &check_configuration ( \"wget\"); \n \
   \n    $tmp=&vtmpnam ();\n    \n    if     (&pg_\
is_installed    (\"wget\")){`wget www.google.com -\
O$tmp >/dev/null 2>/dev/null`;}\n    elsif  (&pg_i\
s_installed    (\"curl\")){`curl www.google.com -o\
$tmp >/dev/null 2>/dev/null`;}\n    \n    if ( !-e\
 $tmp || -s $tmp < 10){$internet=0;}\n    else {$i\
nternet=1;}\n    if (-e $tmp){unlink $tmp;}\n\n   \
 return $internet;\n  }\n\nsub vtmpnam\n      {\n	\
my $r=rand(100000);\n	my $f=\"file.$r.$$\";\n	whil\
e (-e $f)\n	  {\n	    $f=vtmpnam();\n	  }\n	push (\
@TMPFILE_LIST, $f);\n	return $f;\n      }\n\n","\n\
$t_coffee=\"t_coffee\";\n\nforeach $value ( @ARGV)\
\n  {\n    $seq_file=$seq_file.\" \".$value;\n  }\\
n\n$name=$ARGV[0];\n$name=~s/\\.[^\\.]*$//;\n$lib_\
name=\"$name.mocca_lib\";\n$type=`t_coffee $seq_fi\
le -get_type -quiet`;\nchop ($type);\n\nif ( $type\
 eq \"PROTEIN\"){$lib_mode=\"lalign_rs_s_pair -lal\
ign_n_top 20\";}\nelsif ( $type eq\"DNA\"){$lib_mo\
de=\"lalign_rs_s_dna_pair -lalign_n_top 40\";}\n\n\
if ( !(-e $lib_name))\n  {\n	  \n  $command=\"$t_c\
offee -mocca -seq_weight=no -cosmetic_penalty=0 -m\
occa_interactive -in $lib_mode -out_lib $lib_name \
-infile $seq_file\";\n  \n  }\nelsif ( (-e $lib_na\
me))\n  {\n  $command=\"$t_coffee -mocca -seq_weig\
ht=no -cosmetic_penalty=0 -mocca_interactive -in $\
lib_name -infile $seq_file\";\n  \n  }\n\nsystem (\
$command);\n\nexit;\n\n","my $WSDL = 'http://www.e\
bi.ac.uk/Tools/webservices/wsdl/WSDaliLite.wsdl';\\
n\nuse SOAP::Lite;\nuse Data::Dumper;\nuse Getopt:\
:Long qw(:config no_ignore_case bundling);\nuse Fi\
le::Basename;\n\nmy $checkInterval = 5;\n\nmy %par\
ams=(\n	    'async' => '1', # Use async mode and s\
imulate sync mode in client\n	    );\nGetOptions(\\
n    'pdb1=s'     => \\$params{'sequence1'},\n    \
'chainid1=s' => \\$params{'chainid1'},\n    'pdb2=\
s'     => \\$params{'sequence2'},\n    'chainid2=s\
' => \\$params{'chainid2'},\n    \"help|h\"	 => \\\
$help, # Usage info\n    \"async|a\"	 => \\$async,\
 # Asynchronous submission\n    \"polljob\"	 => \\\
$polljob, # Get results\n    \"status\"	 => \\$sta\
tus, # Get status\n    \"jobid|j=s\"  => \\$jobid,\
 # JobId\n    \"email|S=s\"  => \\$params{email}, \
# E-mail address\n    \"trace\"      => \\$trace, \
# SOAP messages\n    \"sequence=s\" => \\$sequence\
, # Input PDB\n    );\n\nmy $scriptName = basename\
($0, ());\nif($help) {\n    &usage();\n    exit(0)\
;\n}\n\nif($trace) {\n    print \"Tracing active\\\
n\";\n    SOAP::Lite->import(+trace => 'debug');\n\
}\n\nmy $soap = SOAP::Lite\n    ->service($WSDL)\n\
    ->on_fault(sub {\n        my $soap = shift;\n \
       my $res = shift;\n        # Throw an except\
ion for all faults\n        if(ref($res) eq '') {\\
n            die($res);\n        } else {\n       \
     die($res->faultstring);\n        }\n        r\
eturn new SOAP::SOM;\n    }\n               );\n\n\
if( !($polljob || $status) &&\n    !( defined($par\
ams{'sequence1'}) && defined($params{'sequence2'})\
 )\n    ) {\n    print STDERR 'Error: bad option c\
ombination', \"\\n\";\n    &usage();\n    exit(1);\
\n}\nelsif($polljob && defined($jobid)) {\n    pri\
nt \"Getting results for job $jobid\\n\";\n    get\
Results($jobid);\n}\nelsif($status && defined($job\
id)) {\n    print STDERR \"Getting status for job \
$jobid\\n\";\n    my $result = $soap->checkStatus(\
$jobid);\n    print STDOUT \"$result\", \"\\n\";\n\
    if($result eq 'DONE') {\n	print STDERR \"To ge\
t results: $scriptName --polljob --jobid $jobid\\n\
\";\n    }\n}\nelse {\n    if(-f $params{'sequence\
1'}) {\n	$params{'sequence1'} = read_file($params{\
'sequence1'});\n    }\n    if(-f $params{'sequence\
2'}) {\n	$params{'sequence2'} = read_file($params{\
'sequence2'});\n    }\n\n    my $jobid;\n    my $p\
aramsData = SOAP::Data->name('params')->type(map=>\
\\%params);\n    # For SOAP::Lite 0.60 and earlier\
 parameters are passed directly\n    if($SOAP::Lit\
e::VERSION eq '0.60' || $SOAP::Lite::VERSION =~ /0\
\\.[1-5]/) {\n        $jobid = $soap->runDaliLite(\
$paramsData);\n    }\n    # For SOAP::Lite 0.69 an\
d later parameter handling is different, so pass\n\
    # undef's for templated params, and then pass \
the formatted args.\n    else {\n        $jobid = \
$soap->runDaliLite(undef,\n				     $paramsData);\\
n    }\n\n    if (defined($async)) {\n	print STDOU\
T $jobid, \"\\n\";\n        print STDERR \"To chec\
k status: $scriptName --status --jobid $jobid\\n\"\
;\n    } else { # Synchronous mode\n        print \
STDERR \"JobId: $jobid\\n\";\n        sleep 1;\n  \
      getResults($jobid);\n    }\n}\n\nsub clientP\
oll($) {\n    my $jobid = shift;\n    my $result =\
 'PENDING';\n    # Check status and wait if not fi\
nished\n    #print STDERR \"Checking status: $jobi\
d\\n\";\n    while($result eq 'RUNNING' || $result\
 eq 'PENDING') {\n        $result = $soap->checkSt\
atus($jobid);\n        print STDERR \"$result\\n\"\
;\n        if($result eq 'RUNNING' || $result eq '\
PENDING') {\n            # Wait before polling aga\
in.\n            sleep $checkInterval;\n        }\\
n    }\n}\n\nsub getResults($) {\n    $jobid = shi\
ft;\n    # Check status, and wait if not finished\\
n    clientPoll($jobid);\n    # Use JobId if outpu\
t file name is not defined\n    unless(defined($ou\
tfile)) {\n        $outfile=$jobid;\n    }\n    # \
Get list of data types\n    my $resultTypes = $soa\
p->getResults($jobid);\n    # Get the data and wri\
te it to a file\n    if(defined($outformat)) { # S\
pecified data type\n        my $selResultType;\n  \
      foreach my $resultType (@$resultTypes) {\n  \
          if($resultType->{type} eq $outformat) {\\
n                $selResultType = $resultType;\n  \
          }\n        }\n        $res=$soap->poll($\
jobid, $selResultType->{type});\n        write_fil\
e($outfile.'.'.$selResultType->{ext}, $res);\n    \
} else { # Data types available\n        # Write a\
 file for each output type\n        for my $result\
Type (@$resultTypes){\n            #print \"Gettin\
g $resultType->{type}\\n\";\n            $res=$soa\
p->poll($jobid, $resultType->{type});\n           \
 write_file($outfile.'.'.$resultType->{ext}, $res)\
;\n        }\n    }\n}\n\nsub read_file($) {\n    \
my $filename = shift;\n    open(FILE, $filename);\\
n    my $content;\n    my $buffer;\n    while(sysr\
ead(FILE, $buffer, 1024)) {\n	$content.= $buffer;\\
n    }\n    close(FILE);\n    return $content;\n}\\
n\nsub write_file($$) {\n    my ($tmp,$entity) = @\
_;\n    print STDERR \"Creating result file: \".$t\
mp.\"\\n\";\n    unless(open (FILE, \">$tmp\")) {\\
n	return 0;\n    }\n    syswrite(FILE, $entity);\n\
    close (FILE);\n    return 1;\n}\n\nsub usage {\
\n    print STDERR <<EOF\nDaliLite\n========\n\nPa\
irwise comparison of protein structures\n\n[Requir\
ed]\n\n  --pdb1                : str  : PDB ID for\
 structure 1\n  --pdb2                : str  : PDB\
 ID for structure 2\n\n[Optional]\n\n  --chain1   \
           : str  : Chain identifer in structure 1\
\n  --chain2              : str  : Chain identifer\
 in structure 2\n\n[General]\n\n  -h, --help      \
      :      : prints this help text\n  -S, --emai\
l           : str  : user email address\n  -a, --a\
sync           :      : asynchronous submission\n \
     --status          :      : poll for the statu\
s of a job\n      --polljob         :      : poll \
for the results of a job\n  -j, --jobid           \
: str  : jobid for an asynchronous job\n  -O, --ou\
tfile         : str  : file name for results (defa\
ult is jobid)\n      --trace	        :      : show\
 SOAP messages being interchanged \n\nSynchronous \
job:\n\n  The results/errors are returned as soon \
as the job is finished.\n  Usage: $scriptName --em\
ail <your\\@email> [options] pdbFile [--outfile st\
ring]\n  Returns: saves the results to disk\n\nAsy\
nchronous job:\n\n  Use this if you want to retrie\
ve the results at a later time. The results \n  ar\
e stored for up to 24 hours. \n  The asynchronous \
submission mode is recommended when users are subm\
itting \n  batch jobs or large database searches	\\
n  Usage: $scriptName --email <your\\@email> --asy\
nc [options] pdbFile\n  Returns: jobid\n\n  Use th\
e jobid to query for the status of the job. \n  Us\
age: $scriptName --status --jobid <jobId>\n  Retur\
ns: string indicating the status of the job:\n    \
DONE - job has finished\n    RUNNING - job is runn\
ing\n    NOT_FOUND - job cannot be found\n    ERRO\
R - the jobs has encountered an error\n\n  When do\
ne, use the jobid to retrieve the status of the jo\
b. \n  Usage: $scriptName --polljob --jobid <jobId\
> [--outfile string]\n\n[Help]\n\n  For more detai\
led help information refer to\n  http://www.ebi.ac\
.uk/DaliLite/\nEOF\n;\n}\n","my $WSDL = 'http://ww\
w.ebi.ac.uk/Tools/webservices/wsdl/WSWUBlast.wsdl'\
;\n\nuse strict;\nuse SOAP::Lite;\nuse Getopt::Lon\
g qw(:config no_ignore_case bundling);\nuse File::\
Basename;\n\nmy $checkInterval = 15;\n\nmy $numOpt\
s = scalar(@ARGV);\nmy ($outfile, $outformat, $hel\
p, $async, $polljob, $status, $ids, $jobid, $trace\
, $sequence);\nmy %params= ( # Defaults\n	      'a\
sync' => 1, # Force into async mode\n	      'exp' \
=> 10.0, # E-value threshold\n	      'numal' => 50\
, # Maximum number of alignments\n	      'scores' \
=> 100, # Maximum number of scores\n            );\
\nGetOptions( # Map the options into variables\n  \
  \"program|p=s\"     => \\$params{program}, # BLA\
ST program\n    \"database|D=s\"    => \\$params{d\
atabase}, # Search database\n    \"matrix|m=s\"   \
   => \\$params{matrix}, # Scoring matrix\n    \"e\
xp|E=f\"         => \\$params{exp}, # E-value thre\
shold\n    \"echofilter|e\"    => \\$params{echofi\
lter}, # Display filtered sequence\n    \"filter|f\
=s\"      => \\$params{filter}, # Low complexity f\
ilter name\n    \"alignments|b=i\"  => \\$params{n\
umal}, # Number of alignments\n    \"scores|s=i\" \
     => \\$params{scores}, # Number of scores\n   \
 \"sensitivity|S=s\" => \\$params{sensitivity}, # \
Search sensitivity\n    \"sort|t=s\"	      => \\$p\
arams{sort}, # Sort hits by...\n    \"stats|T=s\" \
      => \\$params{stats}, # Scoring statistic to \
use\n    \"strand|d=s\"      => \\$params{strand},\
 # Strand to use in DNA vs. DNA search\n    \"topc\
ombon|c=i\"   => \\$params{topcombon}, # Consisten\
t sets of HSPs\n    \"outfile=s\"       => \\$outf\
ile, # Output file\n    \"outformat|o=s\"   => \\$\
outformat, # Output format\n    \"help|h\"	      =\
> \\$help, # Usage info\n    \"async|a\"	      => \
\\$async, # Asynchronous mode\n    \"polljob\"	   \
   => \\$polljob, # Get results\n    \"status\"	  \
    => \\$status, # Get job status\n    \"ids\"   \
          => \\$ids, # Get ids from result\n    \"\
jobid|j=s\"       => \\$jobid, # JobId\n    \"emai\
l=s\"         => \\$params{email}, # E-mail addres\
s\n    \"trace\"           => \\$trace, # SOAP tra\
ce\n    \"sequence=s\"      => \\$sequence, # Quer\
y sequence\n    );\n\nmy $scriptName = basename($0\
, ());\nif($help || $numOpts == 0) {\n    &usage()\
;\n    exit(0);\n}\n\nif($trace){\n    print STDER\
R \"Tracing active\\n\";\n    SOAP::Lite->import(+\
trace => 'debug');\n}\n\nmy $soap = SOAP::Lite\n  \
  ->service($WSDL)\n    ->proxy('http://localhost/\
',\n    #proxy => ['http' => 'http://your.proxy.se\
rver/'], # HTTP proxy\n    timeout => 600, # HTTP \
connection timeout\n    )\n    ->on_fault(sub { # \
SOAP fault handler\n        my $soap = shift;\n   \
     my $res = shift;\n        # Throw an exceptio\
n for all faults\n        if(ref($res) eq '') {\n \
           die($res);\n        } else {\n         \
   die($res->faultstring);\n        }\n        ret\
urn new SOAP::SOM;\n    }\n               );\n\nif\
( !($polljob || $status || $ids) &&\n    !( define\
d($ARGV[0]) || defined($sequence) )\n    ) {\n    \
print STDERR 'Error: bad option combination', \"\\\
n\";\n    &usage();\n    exit(1);\n}\nelsif($pollj\
ob && defined($jobid)) {\n    print \"Getting resu\
lts for job $jobid\\n\";\n    getResults($jobid);\\
n}\nelsif($status && defined($jobid)) {\n    print\
 STDERR \"Getting status for job $jobid\\n\";\n   \
 my $result = $soap->checkStatus($jobid);\n    pri\
nt STDOUT \"$result\\n\";\n    if($result eq 'DONE\
') {\n	print STDERR \"To get results: $scriptName \
--polljob --jobid $jobid\\n\";\n    }\n}  \nelsif(\
$ids && defined($jobid)) {\n    print STDERR \"Get\
ting ids from job $jobid\\n\";\n    getIds($jobid)\
;\n}\nelse {\n    # Prepare input data\n    my $co\
ntent;\n    my (@contents) = ();\n    if(-f $ARGV[\
0] || $ARGV[0] eq '-') {	\n	$content={type=>'seque\
nce',content=>read_file($ARGV[0])};	\n    }\n    i\
f($sequence) {	\n	if(-f $sequence || $sequence eq \
'-') {	\n	    $content={type=>'sequence',content=>\
read_file($ARGV[0])};	\n	} else {\n	    $content={\
type=>'sequence',content=>$sequence};\n	}\n    }\n\
    push @contents, $content;\n\n    # Submit the \
job\n    my $paramsData = SOAP::Data->name('params\
')->type(map=>\\%params);\n    my $contentData = S\
OAP::Data->name('content')->value(\\@contents);\n \
   # For SOAP::Lite 0.60 and earlier parameters ar\
e passed directly\n    if($SOAP::Lite::VERSION eq \
'0.60' || $SOAP::Lite::VERSION =~ /0\\.[1-5]/) {\n\
        $jobid = $soap->runWUBlast($paramsData, $c\
ontentData);\n    }\n    # For SOAP::Lite 0.69 and\
 later parameter handling is different, so pass\n \
   # undef's for templated params, and then pass t\
he formatted args.\n    else {\n        $jobid = $\
soap->runWUBlast(undef, undef,\n				   $paramsData\
, $contentData);\n    }\n\n    # Asynchronous mode\
: output jobid and exit.\n    if (defined($async))\
 {\n	print STDOUT $jobid, \"\\n\";\n        print \
STDERR \"To check status: $scriptName --status --j\
obid $jobid\\n\";\n    }\n    # Synchronous mode: \
try to get results\n    else {\n        print STDE\
RR \"JobId: $jobid\\n\";\n        sleep 1;\n      \
  getResults($jobid);\n    }\n}\n\nsub getIds($) {\
\n    my $jobid = shift;\n    my $results = $soap-\
>getIds($jobid);\n    for my $result (@$results){\\
n	print \"$result\\n\";\n    }\n}\n\nsub clientPol\
l($) {\n    my $jobid = shift;\n    my $result = '\
PENDING';\n    # Check status and wait if not fini\
shed\n    while($result eq 'RUNNING' || $result eq\
 'PENDING') {\n        $result = $soap->checkStatu\
s($jobid);\n        print STDERR \"$result\\n\";\n\
        if($result eq 'RUNNING' || $result eq 'PEN\
DING') {\n            # Wait before polling again.\
\n            sleep $checkInterval;\n        }\n  \
  }\n}\n\nsub getResults($) {\n    my $jobid = shi\
ft;\n    my $res;\n    # Check status, and wait if\
 not finished\n    clientPoll($jobid);\n    # Use \
JobId if output file name is not defined\n    unle\
ss(defined($outfile)) {\n        $outfile=$jobid;\\
n    }\n    # Get list of data types\n    my $resu\
ltTypes = $soap->getResults($jobid);\n    # Get th\
e data and write it to a file\n    if(defined($out\
format)) { # Specified data type\n	if($outformat e\
q 'xml') {$outformat = 'toolxml';}\n	if($outformat\
 eq 'txt') {$outformat = 'tooloutput';}\n        m\
y $selResultType;\n        foreach my $resultType \
(@$resultTypes) {\n            if($resultType->{ty\
pe} eq $outformat) {\n                $selResultTy\
pe = $resultType;\n            }\n        }\n     \
   $res=$soap->poll($jobid, $selResultType->{type}\
);\n	if($outfile eq '-') {\n	     write_file($outf\
ile, $res);\n	} else {\n	    write_file($outfile.'\
.'.$selResultType->{ext}, $res);\n	}\n    } else {\
 # Data types available\n        # Write a file fo\
r each output type\n        for my $resultType (@$\
resultTypes){\n            #print STDERR \"Getting\
 $resultType->{type}\\n\";\n            $res=$soap\
->poll($jobid, $resultType->{type});\n	    if($out\
file eq '-') {\n		write_file($outfile, $res);\n	  \
  } else {\n		write_file($outfile.'.'.$resultType-\
>{ext}, $res);\n	    }\n        }\n    }\n}\n\nsub\
 read_file($) {\n    my $filename = shift;\n    my\
 ($content, $buffer);\n    if($filename eq '-') {\\
n	while(sysread(STDIN, $buffer, 1024)) {\n	    $co\
ntent .= $buffer;\n	}\n    }\n    else { # File\n	\
open(FILE, $filename) or die \"Error: unable to op\
en input file\";\n	while(sysread(FILE, $buffer, 10\
24)) {\n	    $content .= $buffer;\n	}\n	close(FILE\
);\n    }\n    return $content;\n}\n\nsub write_fi\
le($$) {\n    my ($filename, $data) = @_;\n    pri\
nt STDERR 'Creating result file: ' . $filename . \\
"\\n\";\n    if($filename eq '-') {\n	print STDOUT\
 $data;\n    }\n    else {\n	open(FILE, \">$filena\
me\") or die \"Error: unable to open output file\"\
;\n	syswrite(FILE, $data);\n	close(FILE);\n    }\n\
}\n\nsub usage {\n    print STDERR <<EOF\nWU-BLAST\
\n========\n\nRapid sequence database search progr\
ams utilizing the BLAST algorithm.\n   \n[Required\
]\n\n      --email       : str  : user email addre\
ss \n  -p, --program	    : str  : BLAST program to\
 use: blastn, blastp, blastx, \n                  \
           tblastn or tblastx\n  -D, --database   \
 : str  : database to search\n  seqFile           \
: file : query sequence data file (\"-\" for STDIN\
)\n\n[Optional]\n\n  -m, --matrix	    : str  : sco\
ring matrix\n  -E, --exp	    : real : 0<E<= 1000. \
Statistical significance threshold\n              \
               for reporting database sequence mat\
ches.\n  -e, --echofilter  :      : display the fi\
ltered query sequence in the output\n  -f, --filte\
r	    : str  : activates filtering of the query se\
quence\n  -b, --alignments  : int  : number of ali\
gnments to be reported\n  -s, --scores	    : int  \
: number of scores to be reported\n  -S, --sensiti\
vity : str  :\n  -t, --sort	    : str  :\n  -T, --\
stats       : str  :\n  -d, --strand      : str  :\
 DNA strand to search with in DNA vs. DNA searches\
 \n  -c, --topcombon   :      :\n\n[General]	\n\n \
 -h, --help       :      : prints this help text\n\
  -a, --async      :      : forces to make an asyn\
chronous query\n      --status     :      : poll f\
or the status of a job\n      --polljob    :      \
: poll for the results of a job\n  -j, --jobid    \
  : str  : jobid that was returned when an asynchr\
onous job \n                            was submit\
ted.\n  -O, --outfile    : str  : name of the file\
 results should be written to \n                  \
          (default is based on the jobid; \"-\" fo\
r STDOUT)\n  -o, --outformat  : str  : txt or xml \
output (no file is written)\n      --trace	   :   \
   : show SOAP messages being interchanged \n\nSyn\
chronous job:\n\n  The results/errors are returned\
 as soon as the job is finished.\n  Usage: $script\
Name --email <your\\@email> [options...] seqFile\n\
  Returns: saves the results to disk\n\nAsynchrono\
us job:\n\n  Use this if you want to retrieve the \
results at a later time. The results \n  are store\
d for up to 24 hours. \n  The asynchronous submiss\
ion mode is recommended when users are submitting \
\n  batch jobs or large database searches	\n  Usag\
e: $scriptName --async --email <your\\@email> [opt\
ions...] seqFile\n  Returns : jobid\n\n  Use the j\
obid to query for the status of the job. \n  Usage\
: $scriptName --status --jobid <jobId>\n  Returns \
: string indicating the status of the job:\n    DO\
NE - job has finished\n    RUNNING - job is runnin\
g\n    NOT_FOUND - job cannot be found\n    ERROR \
- the jobs has encountered an error\n\n  When done\
, use the jobid to retrieve the status of the job.\
 \n  Usage: $scriptName --polljob --jobid <jobId> \
[--outfile string]\n  Returns: saves the results t\
o disk\n\n[Help]\n\nFor more detailed help informa\
tion refer to \nhttp://www.ebi.ac.uk/blast2/WU-Bla\
st2_Help_frame.html\n \nEOF\n;\n}\n","\nmy $WSDL =\
 'http://www.ebi.ac.uk/Tools/webservices/wsdl/WSBl\
astpgp.wsdl';\n\nuse SOAP::Lite;\nuse Getopt::Long\
 qw(:config no_ignore_case bundling);\nuse File::B\
asename;\n\nmy $checkInterval = 15;\n\nmy %params=\
(\n	    'async' => '1', # Use async mode and simul\
ate sync mode in client\n	    );\nGetOptions(\n   \
 \"mode=s\"           => \\$params{mode}, # Search\
 mode: PSI-Blast or PHI-Blast\n    \"database|d=s\\
"     => \\$params{database}, # Database to search\
\n    \"matrix|M=s\"       => \\$params{matrix},# \
Scoring maxtrix\n    \"exp|e=f\"          => \\$pa\
rams{exp}, # E-value\n    \"expmulti|h=f\"     => \
\\$params{expmulti}, # E-value\n    \"filter|F=s\"\
       => \\$params{filter}, # Low complexity filt\
er\n    \"dropoff|X=i\"      => \\$params{dropoff}\
, # Dropoff score\n    \"finaldropoff|Z=i\" => \\$\
params{finaldropoff}, # Final dropoff score\n    \\
"scores|v=i\"       => \\$params{scores}, # Max nu\
mber of scores\n    \"align=i\"          => \\$par\
ams{align}, # Alignment view\n    \"startregion|S=\
i\"  => \\$params{startregion}, # Start of region \
in query\n    \"endregion|H=i\"    => \\$params{en\
dregion}, # End of region in query\n    \"maxpasse\
s|j=i\"    => \\$params{maxpasses}, # Number of PS\
I iterations\n    \"opengap|G=i\"      => \\$param\
s{opengap}, # Gap open penalty\n    \"extendgap|E=\
i\"    => \\$params{extendgap}, # Gap extension pe\
nalty\n    \"pattern=s\"        => \\$params{patte\
rn}, # PHI-BLAST pattern\n    \"usagemode|p=s\"   \
 => \\$params{usagemode}, # PHI-BLAST program\n   \
 \"appxml=s\"         => \\$params{appxml}, # Appl\
ication XML\n    \"sequence=s\"       => \\$sequen\
ce, # Query sequence\n    \"help\"	       => \\$he\
lp, # Usage info\n    \"polljob\"	       => \\$pol\
ljob, # Get results\n    \"status\"	       => \\$s\
tatus, # Get status\n    \"ids\"      	       => \\
\$ids, # Get ids from result\n    \"jobid=s\"     \
     => \\$jobid, # JobId\n    \"outfile=s\"      \
  => \\$outfile, # Output filename\n    \"outforma\
t|o=s\"    => \\$outformat, # Output file format\n\
    \"async|a\"	       => \\$async, # Async submis\
sion\n    \"email=s\"          => \\$params{email}\
, # User e-mail address\n    \"trace\"            \
=> \\$trace, # Show SOAP messages\n    );\n\nmy $s\
criptName = basename($0, ());\nif($help) {\n    &u\
sage();\n    exit(0);\n}\n\nif ($trace){\n    prin\
t \"Tracing active\\n\";\n    SOAP::Lite->import(+\
trace => 'debug');\n}\n\nmy $soap = SOAP::Lite\n  \
  ->service($WSDL)\n    ->on_fault(sub {\n        \
my $soap = shift;\n        my $res = shift;\n     \
   # Throw an exception for all faults\n        if\
(ref($res) eq '') {\n            die($res);\n     \
   } else {\n            die($res->faultstring);\n\
        }\n        return new SOAP::SOM;\n    }\n \
              );\n\nif( !($polljob || $status || $\
ids) &&\n    !( (defined($ARGV[0]) && -f $ARGV[0])\
 || defined($sequence) )\n    ) {\n    print STDER\
R 'Error: bad option combination', \"\\n\";\n    &\
usage();\n    exit(1);\n}\nelsif($polljob && defin\
ed($jobid)) {\n    print \"Getting results for job\
 $jobid\\n\";\n    getResults($jobid);\n}\nelsif($\
status && defined($jobid)) {\n    print STDERR \"G\
etting status for job $jobid\\n\";\n    my $result\
 = $soap->checkStatus($jobid);\n    print STDOUT $\
result, \"\\n\";\n    if($result eq 'DONE') {\n	pr\
int STDERR \"To get results: $scriptName --polljob\
 --jobid $jobid\\n\";\n    }\n}  \nelsif($ids && d\
efined($jobid)) {\n    print STDERR \"Getting ids \
from job $jobid\\n\";\n    getIds($jobid);\n}\nels\
e {\n    if(-f $ARGV[0]) {	\n	$content={type=>'seq\
uence', content=>read_file($ARGV[0])};	\n    }\n  \
  if($sequence) {	\n	if(-f $sequence) {\n	    $con\
tent={type=>'sequence', content=>read_file($sequen\
ce)};	\n	} else {\n	    $content={type=>'sequence'\
, content=>$sequence};\n	}\n    }\n    push @conte\
nt, $content;\n\n    my $jobid;\n    my $paramsDat\
a = SOAP::Data->name('params')->type(map=>\\%param\
s);\n    my $contentData = SOAP::Data->name('conte\
nt')->value(\\@content);\n    # For SOAP::Lite 0.6\
0 and earlier parameters are passed directly\n    \
if($SOAP::Lite::VERSION eq '0.60' || $SOAP::Lite::\
VERSION =~ /0\\.[1-5]/) {\n        $jobid = $soap-\
>runBlastpgp($paramsData, $contentData);\n    }\n \
   # For SOAP::Lite 0.69 and later parameter handl\
ing is different, so pass\n    # undef's for templ\
ated params, and then pass the formatted args.\n  \
  else {\n        $jobid = $soap->runBlastpgp(unde\
f, undef,\n				    $paramsData, $contentData);\n  \
  }\n\n    if (defined($async)) {\n	print STDOUT $\
jobid, \"\\n\";\n        print STDERR \"To check s\
tatus: $scriptName --status --jobid $jobid\\n\";\n\
    } else { # Synchronous mode\n        print STD\
ERR \"JobId: $jobid\\n\";\n        sleep 1;\n     \
   getResults($jobid);\n    }\n}\n\nsub getIds($) \
{\n    $jobid = shift;\n    my $results = $soap->g\
etIds($jobid);\n    for $result (@$results){\n	pri\
nt \"$result\\n\";\n    }\n}\n\nsub clientPoll($) \
{\n    my $jobid = shift;\n    my $result = 'PENDI\
NG';\n    # Check status and wait if not finished\\
n    #print STDERR \"Checking status: $jobid\\n\";\
\n    while($result eq 'RUNNING' || $result eq 'PE\
NDING') {\n        $result = $soap->checkStatus($j\
obid);\n        print STDERR \"$result\\n\";\n    \
    if($result eq 'RUNNING' || $result eq 'PENDING\
') {\n            # Wait before polling again.\n  \
          sleep $checkInterval;\n        }\n    }\\
n}\n\nsub getResults($) {\n    $jobid = shift;\n  \
  # Check status, and wait if not finished\n    cl\
ientPoll($jobid);\n    # Use JobId if output file \
name is not defined\n    unless(defined($outfile))\
 {\n        $outfile=$jobid;\n    }\n    # Get lis\
t of data types\n    my $resultTypes = $soap->getR\
esults($jobid);\n    # Get the data and write it t\
o a file\n    if(defined($outformat)) { # Specifie\
d data type\n        my $selResultType;\n        f\
oreach my $resultType (@$resultTypes) {\n         \
   if($resultType->{type} eq $outformat) {\n      \
          $selResultType = $resultType;\n         \
   }\n        }\n        $res=$soap->poll($jobid, \
$selResultType->{type});\n        write_file($outf\
ile.'.'.$selResultType->{ext}, $res);\n    } else \
{ # Data types available\n        # Write a file f\
or each output type\n        for my $resultType (@\
$resultTypes){\n            #print \"Getting $resu\
ltType->{type}\\n\";\n            $res=$soap->poll\
($jobid, $resultType->{type});\n            write_\
file($outfile.'.'.$resultType->{ext}, $res);\n    \
    }\n    }\n}\n\nsub read_file($) {\n    my $fil\
ename = shift;\n    open(FILE, $filename);\n    my\
 $content;\n    my $buffer;\n    while(sysread(FIL\
E, $buffer, 1024)) {\n	$content.= $buffer;\n    }\\
n    close(FILE);  \n    return $content;\n}\n\nsu\
b write_file($$) {\n    my ($tmp,$entity) = @_;\n \
   print STDERR \"Creating result file: \".$tmp.\"\
\\n\";\n    unless(open (FILE, \">$tmp\")) {\n	ret\
urn 0;\n    }\n    syswrite(FILE, $entity);\n    c\
lose (FILE);\n    return 1;\n}\n\nsub usage {\n   \
 print STDERR <<EOF\nBlastpgp\n========\n   \nThe \
blastpgp program implements the PSI-BLAST and PHI-\
BLAST variations\nof NCBI BLAST.\n\nFor more detai\
led help information refer to\nhttp://www.ebi.ac.u\
k/blastpgp/blastpsi_help_frame.html\n \nBlastpgp s\
pecific options:\n\n[Required]\n\n      --mode    \
        : str  : search mode to use: PSI-Blast or \
PHI-Blast\n  -d, --database        : str  : protei\
n database to search\n  seqFile               : fi\
le : query sequence\n\n[Optional]\n\n  -M, --matri\
x          : str  : scoring matrix\n  -e, --exp   \
          : real : Expectation value\n  -h, --expm\
ulti        : real : threshold (multipass model)\n\
  -F, --filter          : str  : filter query sequ\
ence with SEG [T,F]\n  -m, --align           : int\
  : alignment view option:\n                      \
           0 - pairwise, 1 - M/S identities,\n    \
                             2 - M/S non-identitie\
s, 3 - Flat identities,\n                         \
        4 - Flat non-identities\n  -G, --opengap  \
       : int  : cost to open a gap\n  -E, --extend\
gap       : int  : cost to extend a gap\n  -g, --g\
apalign        : str  : Gapped [T,F]\n  -v, --scor\
es          : int  : number of scores to be report\
ed\n  -j, --maxpasses       : int  : number of ite\
rations\n  -X, --dropoff         : int  : Dropoff \
score\n  -Z, --finaldropoff    : int  : Dropoff fo\
r final alignment\n  -S, --startregion     : int  \
: Start of required region in query\n  -H, --endre\
gion       : int  : End of required region in quer\
y\n  -k, --pattern         : str  : Hit File (PHI-\
BLAST only)\n  -p, --usagemode       : str  : Prog\
ram option (PHI-BLAST only):\n                    \
             blastpgp, patseedp, seedp\n\n[General\
]\n\n      --help            :      : prints this \
help text\n  -a, --async           :      : forces\
 to make an asynchronous query\n      --status    \
      :      : poll for the status of a job\n     \
 --polljob         :      : poll for the results o\
f a job\n      --jobid           : str  : jobid of\
 an asynchronous job\n      --ids             :   \
   : get hit identifiers for result \n  -O, --outf\
ile         : str  : name of the file results shou\
ld be written to\n                                \
 (default is based on the jobid)\n  -o, --outforma\
t       : str  : txt or xml output (no file is wri\
tten)\n      --trace           :      : show SOAP \
messages being interchanged\n\nSynchronous job:\n\\
n  The results/errors are returned as soon as the \
job is finished.\n  Usage: blastpgp.pl --email <yo\
ur@email> [options...] seqfile\n  Returns: saves t\
he results to disk\n\nAsynchronous job:\n\n  Use t\
his if you want to retrieve the results at a later\
 time. The results\n  are stored for up to 24 hour\
s.\n  The asynchronous submission mode is recommen\
ded when users are submitting\n  batch jobs or lar\
ge database searches\n  Usage: blastpgp.pl --email\
 <your@email> --async [options...] seqFile\n  Retu\
rns: jobid\n\n  Use the jobid to query for the sta\
tus of the job.\n  Usage: blastpgp.pl --status --j\
obid <jobId>\n  Returns: string indicating the sta\
tus of the job\n    DONE - job has finished\n    R\
UNNING - job is running\n    NOT_FOUND - job canno\
t be found\n    ERROR - the jobs has encountered a\
n error\n\n  When done, use the jobid to retrieve \
the results of the job.\n  Usage: blastpgp.pl --po\
lljob --jobid <jobId> [--outfile <fileName>]\n  Re\
turns: saves the results to disk\nEOF\n;\n}\n","\n\
=head1 NAME\n\nncbiblast.pl\n\n=head1 DESCRIPTION\\
n\nNCBI Blast (REST) web service Perl client using\
 L<LWP>.\n\nTested with:\n\n=over\n\n=item *\nL<LW\
P> 6.35, L<XML::Simple> 2.25 and Perl 5.22.0 (MacO\
S 10.13.6)\n\n=back\n\nFor further information see\
:\n\n=over\n\n=item *\nL<https://www.ebi.ac.uk/Too\
ls/webservices/>\n\n=back\n\n=head1 LICENSE\n\nCop\
yright 2012-2018 EMBL - European Bioinformatics In\
stitute\n\nLicensed under the Apache License, Vers\
ion 2.0 (the \"License\");\nyou may not use this f\
ile except in compliance with the License.\nYou ma\
y obtain a copy of the License at\n\n    http://ww\
w.apache.org/licenses/LICENSE-2.0\n\nUnless requir\
ed by applicable law or agreed to in writing, soft\
ware\ndistributed under the License is distributed\
 on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CON\
DITIONS OF ANY KIND, either express or implied.\nS\
ee the License for the specific language governing\
 permissions and\nlimitations under the License.\n\
\nPerl Client Automatically generated with:\nhttps\
://github.com/ebi-wp/webservice-clients-generator\\
n\n=cut\n\nuse strict;\nuse warnings;\n\nuse Engli\
sh;\nuse LWP;\nuse XML::Simple;\nuse Getopt::Long \
qw(:config no_ignore_case bundling);\nuse File::Ba\
sename;\nuse Data::Dumper;\nuse Time::HiRes qw(usl\
eep);\n\nmy $baseUrl = 'https://www.ebi.ac.uk/Tool\
s/services/rest/ncbiblast';\nmy $version = '2019-0\
7-03 16:26';\n\nmy $checkInterval = 3;\n\nmy $maxE\
rrorStatusCount = 3;\n\nmy $outputLevel = 1;\n\nmy\
 $numOpts = scalar(@ARGV);\nmy %params = (\n    'd\
ebugLevel' => 0,\n    'maxJobs'    => 1\n);\n\nGet\
Options(\n    # Tool specific options\n    'progra\
m=s'       => \\$params{'program'},        # The B\
LAST program to be used for the Sequence Similarit\
y Search.\n    'task=s'          => \\$params{'tas\
k'},           # Task option (only selectable for \
blastn)\n    'matrix=s'        => \\$params{'matri\
x'},         # (Protein searches) The substitution\
 matrix used for scoring alignments when searching\
 the database.\n    'alignments=i'    => \\$params\
{'alignments'},     # Maximum number of match alig\
nments reported in the result output.\n    'scores\
=i'        => \\$params{'scores'},         # Maxim\
um number of match score summaries reported in the\
 result output.\n    'exp=s'           => \\$param\
s{'exp'},            # Limits the number of scores\
 and alignments reported based on the expectation \
value. This is the maximum number of times the mat\
ch is expected to occur by chance.\n    'dropoff=i\
'       => \\$params{'dropoff'},        # The amou\
nt a score can drop before gapped extension of wor\
d hits is halted\n    'match_scores=s'  => \\$para\
ms{'match_scores'},   # (Nucleotide searches) The \
match score is the bonus to the alignment score wh\
en matching the same base. The mismatch is the pen\
alty when failing to match.\n    'gapopen=i'      \
 => \\$params{'gapopen'},        # Penalty taken a\
way from the score when a gap is created in sequen\
ce. Increasing the gap openning penalty will decre\
ase the number of gaps in the final alignment.\n  \
  'gapext=i'        => \\$params{'gapext'},       \
  # Penalty taken away from the score for each bas\
e or residue in the gap. Increasing the gap extens\
ion penalty favors short gaps in the final alignme\
nt, conversly decreasing the gap extension penalty\
 favors long gaps in the final alignment.\n    'fi\
lter=s'        => \\$params{'filter'},         # F\
ilter regions of low sequence complexity. This can\
 avoid issues with low complexity sequences where \
matches are found due to composition rather than m\
eaningful sequence similarity. However in some cas\
es filtering also masks regions of interest and so\
 should be used with caution.\n    'seqrange=s'   \
   => \\$params{'seqrange'},       # Specify a ran\
ge or section of the input sequence to use in the \
search. Example: Specifying '34-89' in an input se\
quence of total length 100, will tell BLAST to onl\
y use residues 34 to 89, inclusive.\n    'gapalign\
'        => \\$params{'gapalign'},       # This is\
 a true/false setting that tells the program the p\
erform optimised alignments within regions involvi\
ng gaps. If set to true, the program will perform \
an alignment using gaps. Otherwise, if it is set t\
o false, it will report only individual HSP where \
two sequence match each other, and thus will not p\
roduce alignments with gaps.\n    'wordsize=i'    \
  => \\$params{'wordsize'},       # Word size for \
wordfinder algorithm\n    'compstats=s'     => \\$\
params{'compstats'},      # Use composition-based \
statistics.\n    'align=i'         => \\$params{'a\
lign'},          # Formating for the alignments\n \
   'transltable=i'   => \\$params{'transltable'}, \
   # Query Genetic code to use in translation\n   \
 'stype=s'         => \\$params{'stype'},         \
 # Indicates if the sequence is protein or DNA/RNA\
.\n    'sequence=s'      => \\$params{'sequence'},\
       # The query sequence can be entered directl\
y into this form. The sequence can be in GCG, FAST\
A, EMBL (Nucleotide only), GenBank, PIR, NBRF, PHY\
LIP or UniProtKB/Swiss-Prot (Protein only) format.\
 A partially formatted sequence is not accepted. A\
dding a return to the end of the sequence may help\
 certain applications understand the input. Note t\
hat directly using data from word processors may y\
ield unpredictable results as hidden/control chara\
cters may be present.\n    'database=s'      => \\\
$params{'database'},       # Database\n    # Gener\
ic options\n    'email=s'         => \\$params{'em\
ail'},          # User e-mail address\n    'title=\
s'         => \\$params{'title'},          # Job t\
itle\n    'outfile=s'       => \\$params{'outfile'\
},        # Output file name\n    'outformat=s'   \
  => \\$params{'outformat'},      # Output file ty\
pe\n    'jobid=s'         => \\$params{'jobid'},  \
        # JobId\n    'help|h'          => \\$param\
s{'help'},           # Usage help\n    'asyncjob' \
       => \\$params{'asyncjob'},       # Asynchron\
ous submission\n    'polljob'         => \\$params\
{'polljob'},        # Get results\n    'pollFreq=f\
'      => \\$params{'pollFreq'},       # Poll Freq\
uency\n    'resultTypes'     => \\$params{'resultT\
ypes'},    # Get result types\n    'status'       \
   => \\$params{'status'},         # Get status\n \
   'params'          => \\$params{'params'},      \
   # List input parameters\n    'paramDetail=s'   \
=> \\$params{'paramDetail'},    # Get details for \
parameter\n    'multifasta'      => \\$params{'mul\
tifasta'},     # Multiple fasta input\n    'useSeq\
Id'        => \\$params{'useSeqId'},       # Seq I\
d file name\n    'maxJobs=i'       => \\$params{'m\
axJobs'},        # Max. parallel jobs\n\n    'verb\
ose'         => \\$params{'verbose'},        # Inc\
rease output level\n    'version'         => \\$pa\
rams{'version'},        # Prints out the version o\
f the Client and exit.\n    'quiet'           => \\
\$params{'quiet'},          # Decrease output leve\
l\n    'debugLevel=i'    => \\$params{'debugLevel'\
},     # Debugging level\n    'baseUrl=s'       =>\
 \\$baseUrl,                  # Base URL for servi\
ce.\n);\nif ($params{'verbose'}) {$outputLevel++}\\
nif ($params{'quiet'}) {$outputLevel--}\nif ($para\
ms{'pollFreq'}) {$checkInterval = $params{'pollFre\
q'} * 1000 * 1000}\nif ($params{'baseUrl'}) {$base\
Url = $params{'baseUrl'}}\n\n&print_debug_message(\
'MAIN', 'LWP::VERSION: ' . $LWP::VERSION,\n    1);\
\n\n&print_debug_message('MAIN', \"params:\\n\" . \
Dumper(\\%params), 11);\n\nmy $ua;\n\nmy $scriptNa\
me = basename($0, ());\n\nif ($params{'help'} || $\
numOpts == 0) {\n    &usage();\n    exit(0);\n}\n\\
n&print_debug_message('MAIN', 'baseUrl: ' . $baseU\
rl, 1);\nif (\n    !(\n        $params{'polljob'}\\
n            || $params{'resultTypes'}\n          \
  || $params{'status'}\n            || $params{'pa\
rams'}\n            || $params{'paramDetail'}\n   \
         || $params{'version'}\n    )\n        && \
!(defined($ARGV[0]) || defined($params{'sequence'}\
))\n) {\n\n    # Bad argument combination, so prin\
t error message and usage\n    print STDERR 'Error\
: bad option combination', \"\\n\";\n    &usage();\
\n    exit(1);\n}\nelsif ($params{'params'}) {\n  \
  &print_tool_params();\n}\n\nelsif ($params{'para\
mDetail'}) {\n    &print_param_details($params{'pa\
ramDetail'});\n}\n\nelsif ($params{'version'}) {\n\
  print STDOUT 'Revision: ' . $version, \"\\n\";\n\
  exit(1);\n}\n\nelsif ($params{'status'} && defin\
ed($params{'jobid'})) {\n    &print_job_status($pa\
rams{'jobid'});\n}\n\nelsif ($params{'resultTypes'\
} && defined($params{'jobid'})) {\n    &print_resu\
lt_types($params{'jobid'});\n}\n\nelsif ($params{'\
polljob'} && defined($params{'jobid'})) {\n    &ge\
t_results($params{'jobid'});\n}\n\nelse {\n    # M\
ultiple input sequence mode, assume fasta format.\\
n    if (defined($params{'multifasta'}) && $params\
{'multifasta'}) {\n        &multi_submit_job();\n \
   }\n\n    # Entry identifier list file.\n    els\
if ((defined($params{'sequence'}) && $params{'sequ\
ence'} =~ m/^\\@/)\n        || (defined($ARGV[0]) \
&& $ARGV[0] =~ m/^\\@/)) {\n        my $list_filen\
ame = $params{'sequence'} || $ARGV[0];\n        $l\
ist_filename =~ s/^\\@//;\n        &list_file_subm\
it_job($list_filename);\n    }\n    # Default: sin\
gle sequence/identifier.\n    else {\n        # Wa\
rn for invalid batch only option use.\n        if \
(defined($params{'useSeqId'}) && $params{'useSeqId\
'}) {\n            print STDERR \"Warning: --useSe\
qId option ignored.\\n\";\n            delete $par\
ams{'useSeqId'};\n        }\n        if (defined($\
params{'maxJobs'}) && $params{'maxJobs'} > 1) {\n \
           print STDERR \"Warning: --maxJobs optio\
n ignored.\\n\";\n            $params{'maxJobs'} =\
 1;\n        }\n        # Load the sequence data a\
nd submit.\n        &submit_job(&load_data());\n  \
  }\n}\n\n\n\n=head1 FUNCTIONS\n\n=cut\n\n\n=head2\
 rest_user_agent()\n\nGet a LWP UserAgent to use t\
o perform REST requests.\n\n  my $ua = &rest_user_\
agent();\n\n=cut\n\nsub rest_user_agent() {\n    p\
rint_debug_message('rest_user_agent', 'Begin', 21)\
;\n    # Create an LWP UserAgent for making HTTP c\
alls.\n    my $ua = LWP::UserAgent->new();\n    # \
Set 'User-Agent' HTTP header to identifiy the clie\
nt.\n    my $revisionNumber = 0;\n    $revisionNum\
ber = \"Revision: \" . $version;\n    $ua->agent(\\
"EBI-Sample-Client/$revisionNumber ($scriptName; $\
OSNAME) \" . $ua->agent());\n    # Configure HTTP \
proxy support from environment.\n    $ua->env_prox\
y;\n    print_debug_message('rest_user_agent', 'En\
d', 21);\n    return $ua;\n}\n\n=head2 rest_error(\
)\n\nCheck a REST response for an error condition.\
 An error is mapped to a die.\n\n  &rest_error($re\
sponse, $content_data);\n\n=cut\n\nsub rest_error(\
) {\n    print_debug_message('rest_error', 'Begin'\
, 21);\n    my $response = shift;\n    my $content\
data;\n    if (scalar(@_) > 0) {\n        $content\
data = shift;\n    }\n    if (!defined($contentdat\
a) || $contentdata eq '') {\n        $contentdata \
= $response->content();\n    }\n    # Check for HT\
TP error codes\n    if ($response->is_error) {\n  \
      my $error_message = '';\n        # HTML resp\
onse.\n        if ($contentdata =~ m/<h1>([^<]+)<\\
\/h1>/) {\n            $error_message = $1;\n     \
   }\n        #  XML response.\n        elsif ($co\
ntentdata =~ m/<description>([^<]+)<\\/description\
>/) {\n            $error_message = $1;\n        }\
\n        # die 'http status: ' . $response->code \
. ' ' . $response->message . '  ' . $error_message\
;\n    }\n    print_debug_message('rest_error', 'E\
nd', 21);\n}\n\n=head2 rest_request()\n\nPerform a\
 REST request (HTTP GET).\n\n  my $response_str = \
&rest_request($url);\n\n=cut\n\nsub rest_request {\
\n    print_debug_message('rest_request', 'Begin',\
 11);\n    my $requestUrl = shift;\n    print_debu\
g_message('rest_request', 'URL: ' . $requestUrl, 1\
1);\n\n    # Get an LWP UserAgent.\n    $ua = &res\
t_user_agent() unless defined($ua);\n    # Availab\
le HTTP compression methods.\n    my $can_accept;\\
n    eval {\n        $can_accept = HTTP::Message::\
decodable();\n    };\n    $can_accept = '' unless \
defined($can_accept);\n    # Perform the request\n\
    my $response = $ua->get($requestUrl,\n        \
'Accept-Encoding' => $can_accept, # HTTP compressi\
on.\n    );\n    print_debug_message('rest_request\
', 'HTTP status: ' . $response->code,\n        11)\
;\n    print_debug_message('rest_request',\n      \
  'response length: ' . length($response->content(\
)), 11);\n    print_debug_message('rest_request',\\
n        'request:' . \"\\n\" . $response->request\
()->as_string(), 32);\n    print_debug_message('re\
st_request',\n        'response: ' . \"\\n\" . $re\
sponse->as_string(), 32);\n    # Unpack possibly c\
ompressed response.\n    my $retVal;\n    if (defi\
ned($can_accept) && $can_accept ne '') {\n        \
$retVal = $response->decoded_content();\n    }\n  \
  # If unable to decode use orginal content.\n    \
$retVal = $response->content() unless defined($ret\
Val);\n    # Check for an error.\n    &rest_error(\
$response, $retVal);\n    print_debug_message('res\
t_request', 'retVal: ' . $retVal, 12);\n    print_\
debug_message('rest_request', 'End', 11);\n\n    #\
 Return the response data\n    return $retVal;\n}\\
n\n=head2 rest_get_parameters()\n\nGet list of too\
l parameter names.\n\n  my (@param_list) = &rest_g\
et_parameters();\n\n=cut\n\nsub rest_get_parameter\
s {\n    print_debug_message('rest_get_parameters'\
, 'Begin', 1);\n    my $url = $baseUrl . '/paramet\
ers/';\n    my $param_list_xml_str = rest_request(\
$url);\n    my $param_list_xml = XMLin($param_list\
_xml_str);\n    my (@param_list) = @{$param_list_x\
ml->{'id'}};\n    print_debug_message('rest_get_pa\
rameters', 'End', 1);\n    return(@param_list);\n}\
\n\n=head2 rest_get_parameter_details()\n\nGet det\
ails of a tool parameter.\n\n  my $paramDetail = &\
rest_get_parameter_details($param_name);\n\n=cut\n\
\nsub rest_get_parameter_details {\n    print_debu\
g_message('rest_get_parameter_details', 'Begin', 1\
);\n    my $parameterId = shift;\n    print_debug_\
message('rest_get_parameter_details',\n        'pa\
rameterId: ' . $parameterId, 1);\n    my $url = $b\
aseUrl . '/parameterdetails/' . $parameterId;\n   \
 my $param_detail_xml_str = rest_request($url);\n \
   my $param_detail_xml = XMLin($param_detail_xml_\
str);\n    print_debug_message('rest_get_parameter\
_details', 'End', 1);\n    return($param_detail_xm\
l);\n}\n\n=head2 rest_run()\n\nSubmit a job.\n\n  \
my $job_id = &rest_run($email, $title, \\%params )\
;\n\n=cut\n\nsub rest_run {\n    print_debug_messa\
ge('rest_run', 'Begin', 1);\n    my $email = shift\
;\n    my $title = shift;\n    my $params = shift;\
\n    $email = '' if (!$email);\n    print_debug_m\
essage('rest_run', 'email: ' . $email, 1);\n    if\
 (defined($title)) {\n        print_debug_message(\
'rest_run', 'title: ' . $title, 1);\n    }\n    pr\
int_debug_message('rest_run', 'params: ' . Dumper(\
$params), 1);\n\n    # Get an LWP UserAgent.\n    \
$ua = &rest_user_agent() unless defined($ua);\n\n \
   # Clean up parameters\n    my (%tmp_params) = %\
{$params};\n    $tmp_params{'email'} = $email;\n  \
  $tmp_params{'title'} = $title;\n    foreach my $\
param_name (keys(%tmp_params)) {\n        if (!def\
ined($tmp_params{$param_name})) {\n            del\
ete $tmp_params{$param_name};\n        }\n    }\n\\
n    # Submit the job as a POST\n    my $url = $ba\
seUrl . '/run';\n    my $response = $ua->post($url\
, \\%tmp_params);\n    print_debug_message('rest_r\
un', 'HTTP status: ' . $response->code, 11);\n    \
print_debug_message('rest_run',\n        'request:\
' . \"\\n\" . $response->request()->as_string(), 1\
1);\n    print_debug_message('rest_run',\n        \
'response: ' . length($response->as_string()) . \"\
\\n\" . $response->as_string(), 11);\n\n    # Chec\
k for an error.\n    &rest_error($response);\n\n  \
  # The job id is returned\n    my $job_id = $resp\
onse->content();\n    print_debug_message('rest_ru\
n', 'End', 1);\n    return $job_id;\n}\n\n=head2 r\
est_get_status()\n\nCheck the status of a job.\n\n\
  my $status = &rest_get_status($job_id);\n\n=cut\\
n\nsub rest_get_status {\n    print_debug_message(\
'rest_get_status', 'Begin', 1);\n    my $job_id = \
shift;\n    print_debug_message('rest_get_status',\
 'jobid: ' . $job_id, 2);\n    my $status_str = 'U\
NKNOWN';\n    my $url = $baseUrl . '/status/' . $j\
ob_id;\n    $status_str = &rest_request($url);\n  \
  print_debug_message('rest_get_status', 'status_s\
tr: ' . $status_str, 2);\n    print_debug_message(\
'rest_get_status', 'End', 1);\n    return $status_\
str;\n}\n\n=head2 rest_get_result_types()\n\nGet l\
ist of result types for finished job.\n\n  my (@re\
sult_types) = &rest_get_result_types($job_id);\n\n\
=cut\n\nsub rest_get_result_types {\n    print_deb\
ug_message('rest_get_result_types', 'Begin', 1);\n\
    my $job_id = shift;\n    print_debug_message('\
rest_get_result_types', 'jobid: ' . $job_id, 2);\n\
    my (@resultTypes);\n    my $url = $baseUrl . '\
/resulttypes/' . $job_id;\n    my $result_type_lis\
t_xml_str = &rest_request($url);\n    my $result_t\
ype_list_xml = XMLin($result_type_list_xml_str);\n\
    (@resultTypes) = @{$result_type_list_xml->{'ty\
pe'}};\n    print_debug_message('rest_get_result_t\
ypes',\n        scalar(@resultTypes) . ' result ty\
pes', 2);\n    print_debug_message('rest_get_resul\
t_types', 'End', 1);\n    return(@resultTypes);\n}\
\n\n=head2 rest_get_result()\n\nGet result data of\
 a specified type for a finished job.\n\n  my $res\
ult = rest_get_result($job_id, $result_type);\n\n=\
cut\n\nsub rest_get_result {\n    print_debug_mess\
age('rest_get_result', 'Begin', 1);\n    my $job_i\
d = shift;\n    my $type = shift;\n    print_debug\
_message('rest_get_result', 'jobid: ' . $job_id, 1\
);\n    print_debug_message('rest_get_result', 'ty\
pe: ' . $type, 1);\n    my $url = $baseUrl . '/res\
ult/' . $job_id . '/' . $type;\n    my $result = &\
rest_request($url);\n    print_debug_message('rest\
_get_result', length($result) . ' characters',\n  \
      1);\n    print_debug_message('rest_get_resul\
t', 'End', 1);\n    return $result;\n}\n\n\n=head2\
 print_debug_message()\n\nPrint debug message at s\
pecified debug level.\n\n  &print_debug_message($m\
ethod_name, $message, $level);\n\n=cut\n\nsub prin\
t_debug_message {\n    my $function_name = shift;\\
n    my $message = shift;\n    my $level = shift;\\
n    if ($level <= $params{'debugLevel'}) {\n     \
   print STDERR '[', $function_name, '()] ', $mess\
age, \"\\n\";\n    }\n}\n\n=head2 print_tool_param\
s()\n\nPrint list of tool parameters.\n\n  &print_\
tool_params();\n\n=cut\n\nsub print_tool_params {\\
n    print_debug_message('print_tool_params', 'Beg\
in', 1);\n    my (@param_list) = &rest_get_paramet\
ers();\n    foreach my $param (sort (@param_list))\
 {\n        print $param, \"\\n\";\n    }\n    pri\
nt_debug_message('print_tool_params', 'End', 1);\n\
}\n\n=head2 print_param_details()\n\nPrint details\
 of a tool parameter.\n\n  &print_param_details($p\
aram_name);\n\n=cut\n\nsub print_param_details {\n\
    print_debug_message('print_param_details', 'Be\
gin', 1);\n    my $paramName = shift;\n    print_d\
ebug_message('print_param_details', 'paramName: ' \
. $paramName, 2);\n    my $paramDetail = &rest_get\
_parameter_details($paramName);\n    print $paramD\
etail->{'name'}, \"\\t\", $paramDetail->{'type'}, \
\"\\n\";\n    print $paramDetail->{'description'},\
 \"\\n\";\n    if (defined($paramDetail->{'values'\
}->{'value'})) {\n        if (ref($paramDetail->{'\
values'}->{'value'}) eq 'ARRAY') {\n            fo\
reach my $value (@{$paramDetail->{'values'}->{'val\
ue'}}) {\n                &print_param_value($valu\
e);\n            }\n        }\n        else {\n   \
         &print_param_value($paramDetail->{'values\
'}->{'value'});\n        }\n    }\n    print_debug\
_message('print_param_details', 'End', 1);\n}\n\n=\
head2 print_param_value()\n\nPrint details of a to\
ol parameter value.\n\n  &print_param_details($par\
am_value);\n\nUsed by print_param_details() to han\
dle both singluar and array values.\n\n=cut\n\nsub\
 print_param_value {\n    my $value = shift;\n    \
print $value->{'value'};\n    if ($value->{'defaul\
tValue'} eq 'true') {\n        print \"\\t\", 'def\
ault';\n    }\n    print \"\\n\";\n    print \"\\t\
\", $value->{'label'}, \"\\n\";\n    if (defined($\
value->{'properties'})) {\n        foreach\n      \
  my $key (sort ( keys(%{$value->{'properties'}{'p\
roperty'}}) )) {\n            if (ref($value->{'pr\
operties'}{'property'}{$key}) eq 'HASH'\n         \
       && defined($value->{'properties'}{'property\
'}{$key}{'value'})\n            ) {\n             \
   print \"\\t\", $key, \"\\t\",\n                \
    $value->{'properties'}{'property'}{$key}{'valu\
e'}, \"\\n\";\n            }\n            else {\n\
                print \"\\t\", $value->{'propertie\
s'}{'property'}{'key'},\n                    \"\\t\
\", $value->{'properties'}{'property'}{'value'}, \\
"\\n\";\n                last;\n            }\n   \
     }\n    }\n}\n\n=head2 print_job_status()\n\nP\
rint status of a job.\n\n  &print_job_status($job_\
id);\n\n=cut\n\nsub print_job_status {\n    print_\
debug_message('print_job_status', 'Begin', 1);\n  \
  my $jobid = shift;\n    print_debug_message('pri\
nt_job_status', 'jobid: ' . $jobid, 1);\n    if ($\
outputLevel > 0) {\n        print STDERR 'Getting \
status for job ', $jobid, \"\\n\";\n    }\n    my \
$result = &rest_get_status($jobid);\n    print \"$\
result\\n\";\n    if ($result eq 'FINISHED' && $ou\
tputLevel > 0) {\n        print STDERR \"To get re\
sults: perl $scriptName --polljob --jobid \" . $jo\
bid\n            . \"\\n\";\n    }\n    print_debu\
g_message('print_job_status', 'End', 1);\n}\n\n=he\
ad2 print_result_types()\n\nPrint available result\
 types for a job.\n\n  &print_result_types($job_id\
);\n\n=cut\n\nsub print_result_types {\n    print_\
debug_message('result_types', 'Begin', 1);\n    my\
 $jobid = shift;\n    print_debug_message('result_\
types', 'jobid: ' . $jobid, 1);\n    if ($outputLe\
vel > 0) {\n        print STDERR 'Getting result t\
ypes for job ', $jobid, \"\\n\";\n    }\n    my $s\
tatus = &rest_get_status($jobid);\n    if ($status\
 eq 'PENDING' || $status eq 'RUNNING') {\n        \
print STDERR 'Error: Job status is ', $status,\n  \
          '. To get result types the job must be f\
inished.', \"\\n\";\n    }\n    else {\n        my\
 (@resultTypes) = &rest_get_result_types($jobid);\\
n        if ($outputLevel > 0) {\n            prin\
t STDOUT 'Available result types:', \"\\n\";\n    \
    }\n        foreach my $resultType (@resultType\
s) {\n            print STDOUT $resultType->{'iden\
tifier'}, \"\\n\";\n            if (defined($resul\
tType->{'label'})) {\n                print STDOUT\
 \"\\t\", $resultType->{'label'}, \"\\n\";\n      \
      }\n            if (defined($resultType->{'de\
scription'})) {\n                print STDOUT \"\\\
t\", $resultType->{'description'}, \"\\n\";\n     \
       }\n            if (defined($resultType->{'m\
ediaType'})) {\n                print STDOUT \"\\t\
\", $resultType->{'mediaType'}, \"\\n\";\n        \
    }\n            if (defined($resultType->{'file\
Suffix'})) {\n                print STDOUT \"\\t\"\
, $resultType->{'fileSuffix'}, \"\\n\";\n         \
   }\n        }\n        if ($status eq 'FINISHED'\
 && $outputLevel > 0) {\n            print STDERR \
\"\\n\", 'To get results:', \"\\n\",\n            \
    \"  perl $scriptName --polljob --jobid \" . $p\
arams{'jobid'} . \"\\n\",\n                \"  per\
l $scriptName --polljob --outformat <type> --jobid\
 \"\n                    . $params{'jobid'} . \"\\\
n\";\n        }\n    }\n    print_debug_message('r\
esult_types', 'End', 1);\n}\n\n=head2 submit_job()\
\n\nSubmit a job to the service.\n\n  &submit_job(\
$seq);\n\n=cut\n\nsub submit_job {\n    print_debu\
g_message('submit_job', 'Begin', 1);\n\n    # Set \
input sequence\n    $params{'sequence'} = shift;\n\
    my $seq_id = shift;\n\n    # Load parameters\n\
    &load_params();\n\n    # Submit the job\n    m\
y $jobid = &rest_run($params{'email'}, $params{'ti\
tle'}, \\%params);\n\n    # Asynchronous submissio\
n.\n    if (defined($params{'asyncjob'})) {\n     \
   print STDOUT $jobid, \"\\n\";\n        if ($out\
putLevel > 0) {\n            print STDERR\n       \
         \"To check status: perl $scriptName --sta\
tus --jobid $jobid\\n\";\n        }\n    }\n\n    \
# Simulate synchronous submission serial mode.\n  \
  else {\n        if ($outputLevel > 0) {\n       \
     print STDERR \"JobId: $jobid\\n\";\n        }\
 else {\n            print STDERR \"$jobid\\n\";\n\
        }\n        usleep($checkInterval);\n      \
  # Get results.\n        &get_results($jobid, $se\
q_id);\n\n    }\n    print_debug_message('submit_j\
ob', 'End', 1);\n    return $jobid;\n}\n=head2 mul\
ti_submit_job()\n\nSubmit multiple jobs assuming i\
nput is a collection of fasta formatted sequences.\
\n\n  &multi_submit_job();\n\n=cut\n\nsub multi_su\
bmit_job {\n    print_debug_message('multi_submit_\
job', 'Begin', 1);\n    my (@filename_list) = ();\\
n\n    # Query sequence\n    if (defined($ARGV[0])\
) {                  # Bare option\n        if (-f\
 $ARGV[0] || $ARGV[0] eq '-') { # File\n          \
  push(@filename_list, $ARGV[0]);\n        }\n    \
    else {\n            warn 'Warning: Input file \
\"' . $ARGV[0] . '\" does not exist';\n        }\n\
    }\n    if ($params{'sequence'}) {             \
                         # Via --sequence\n       \
 if (-f $params{'sequence'} || $params{'sequence'}\
 eq '-') { # File\n            push(@filename_list\
, $params{'sequence'});\n        }\n        else {\
\n            warn 'Warning: Input file \"'\n     \
           . $params{'sequence'}\n                \
. '\" does not exist';\n        }\n    }\n\n    # \
Job identifier tracking for parallel execution.\n \
   my @jobid_list = ();\n    my $job_number = 0;\n\
    $/ = '>';\n    foreach my $filename (@filename\
_list) {\n        my $INFILE;\n        if ($filena\
me eq '-') { # STDIN.\n            open($INFILE, '\
<-')\n                or die 'Error: unable to STD\
IN (' . $! . ')';\n        }\n        else { # Fil\
e.\n            open($INFILE, '<', $filename)\n   \
             or die 'Error: unable to open file '\\
n                . $filename . ' ('\n             \
   . $! . ')';\n        }\n        while (<$INFILE\
>) {\n            my $seq = $_;\n            $seq \
=~ s/>$//;\n            if ($seq =~ m/(\\S+)/) {\n\
                my $seq_id = $1;\n                \
print STDERR \"Submitting job for: $seq_id\\n\"\n \
                   if ($outputLevel > 0);\n       \
         $seq = '>' . $seq;\n                &prin\
t_debug_message('multi_submit_job', $seq, 11);\n  \
              $job_number++;\n                my $\
job_id = &submit_job($seq, $seq_id);\n\n          \
      my $job_info_str = sprintf('%s %d %d', $job_\
id, 0, $job_number);\n\n                push(@jobi\
d_list, $job_info_str);\n            }\n\n        \
    # Parallel mode, wait for job(s) to finish to \
free slots.\n            while ($params{'maxJobs'}\
 > 1\n                && scalar(@jobid_list) >= $p\
arams{'maxJobs'}) {\n                &_job_list_po\
ll(\\@jobid_list);\n                print_debug_me\
ssage('multi_submit_job',\n                    'Re\
maining jobs: ' . scalar(@jobid_list), 1);\n      \
      }\n        }\n        close $INFILE;\n    }\\
n\n    # Parallel mode, wait for remaining jobs to\
 finish.\n    while ($params{'maxJobs'} > 1 && sca\
lar(@jobid_list) > 0) {\n        &_job_list_poll(\\
\@jobid_list);\n        print_debug_message('multi\
_submit_job',\n            'Remaining jobs: ' . sc\
alar(@jobid_list), 1);\n    }\n    print_debug_mes\
sage('multi_submit_job', 'End', 1);\n}\n\n\n=head2\
 _job_list_poll()\n\nPoll the status of a list of \
jobs and fetch results for finished jobs.\n\n  whi\
le(scalar(@jobid_list) > 0) {\n    &_job_list_poll\
(\\@jobid_list);\n  }\n\n=cut\n\nsub _job_list_pol\
l {\n    print_debug_message('_job_list_poll', 'Be\
gin', 1);\n    my $jobid_list = shift;\n    print_\
debug_message('_job_list_poll', 'Num jobs: ' . sca\
lar(@$jobid_list),\n        11);\n\n    # Loop tho\
ugh job Id list polling job status.\n    for (my $\
jobNum = (scalar(@$jobid_list) - 1); $jobNum > -1;\
 $jobNum--) {\n        my ($jobid, $seq_id, $error\
_count, $job_number) =\n            split(/\\s+/, \
$jobid_list->[$jobNum]);\n        print_debug_mess\
age('_job_list_poll', 'jobNum: ' . $jobNum, 12);\n\
        print_debug_message('_job_list_poll',\n   \
         'Job info: ' . $jobid_list->[$jobNum], 12\
);\n\n        # Get job status.\n        my $job_s\
tatus = &rest_get_status($jobid);\n        print_d\
ebug_message('_job_list_poll', 'Status: ' . $job_s\
tatus, 12);\n\n        # Fetch results and remove \
finished/failed jobs from list.\n        if (\n   \
         !(\n                $job_status eq 'RUNNI\
NG'\n                    || $job_status eq 'PENDIN\
G'\n                    || ($job_status eq 'ERROR'\
\n                    && $error_count < $maxErrorS\
tatusCount)\n            )\n        ) {\n         \
   if ($job_status eq 'ERROR' || $job_status eq 'F\
AILED') {\n                print STDERR\n         \
           \"Warning: job $jobid failed for sequen\
ce $job_number: $seq_id\\n\";\n            }\n			#\
 Duplicated getting results.\n            #&get_re\
sults($jobid, $seq_id);\n            splice(@$jobi\
d_list, $jobNum, 1);\n        }\n        else {\n\\
n            # Update error count, increment for n\
ew error or clear old errors.\n            if ($jo\
b_status eq 'ERROR') {\n                $error_cou\
nt++;\n            }\n            elsif ($error_co\
unt > 0) {\n                $error_count--;\n     \
       }\n\n            # Update job tracking info\
.\n            my $job_info_str = sprintf('%s %s %\
d %d',\n                $jobid, $seq_id, $error_co\
unt, $job_number);\n            $jobid_list->[$job\
Num] = $job_info_str;\n        }\n    }\n    print\
_debug_message('_job_list_poll', 'Num jobs: ' . sc\
alar(@$jobid_list),\n        11);\n    print_debug\
_message('_job_list_poll', 'End', 1);\n}\n\n=head2\
 list_file_submit_job()\n\nSubmit multiple jobs us\
ing a file containing a list of entry identifiers \
as\ninput.\n\n  &list_file_submit_job($list_filena\
me)\n\n=cut\n\nsub list_file_submit_job {\n    pri\
nt_debug_message('list_file_submit_job', 'Begin', \
1);\n    my $filename = shift;\n\n    # Open the f\
ile of identifiers.\n    my $LISTFILE;\n    if ($f\
ilename eq '-') { # STDIN.\n        open($LISTFILE\
, '<-')\n            or die 'Error: unable to STDI\
N (' . $! . ')';\n    }\n    else { # File.\n     \
   open($LISTFILE, '<', $filename)\n            or\
 die 'Error: unable to open file ' . $filename . '\
 (' . $! . ')';\n    }\n\n    # Job identifier tra\
cking for parallel execution.\n    my @jobid_list \
= ();\n    my $job_number = 0;\n\n    # Iterate ov\
er identifiers, submitting each job\n    while (<$\
LISTFILE>) {\n        my $line = $_;\n        chom\
p($line);\n        if ($line ne '') {\n           \
 &print_debug_message('list_file_submit_job', 'lin\
e: ' . $line, 2);\n            if ($line =~ m/\\w:\
\\w/) {\n                # Check this is an identi\
fier\n                my $seq_id = $line;\n       \
         print STDERR \"Submitting job for: $seq_i\
d\\n\"\n                    if ($outputLevel > 0);\
\n                $job_number++;\n                \
my $job_id = &submit_job($seq_id, $seq_id);\n     \
           my $job_info_str =\n                   \
 sprintf('%s %s %d %d', $job_id, $seq_id, 0, $job_\
number);\n                push(@jobid_list, $job_i\
nfo_str);\n            }\n            else {\n    \
            print STDERR\n                    \"Wa\
rning: line \\\"$line\\\" is not recognised as an \
identifier\\n\";\n            }\n\n            # P\
arallel mode, wait for job(s) to finish to free sl\
ots.\n            while ($params{'maxJobs'} > 1\n \
               && scalar(@jobid_list) >= $params{'\
maxJobs'}) {\n                &_job_list_poll(\\@j\
obid_list);\n                print_debug_message('\
list_file_submit_job',\n                    'Remai\
ning jobs: ' . scalar(@jobid_list), 1);\n         \
   }\n        }\n    }\n    close $LISTFILE;\n\n  \
  # Parallel mode, wait for remaining jobs to fini\
sh.\n    while ($params{'maxJobs'} > 1 && scalar(@\
jobid_list) > 0) {\n        &_job_list_poll(\\@job\
id_list);\n        print_debug_message('list_file_\
submit_job',\n            'Remaining jobs: ' . sca\
lar(@jobid_list), 1);\n    }\n    print_debug_mess\
age('list_file_submit_job', 'End', 1);\n}\n\n\n=he\
ad2 load_data()\n\nLoad sequence data from file or\
 option specified on the command-line.\n\n  &load_\
data();\n\n=cut\n\nsub load_data {\n    print_debu\
g_message('load_data', 'Begin', 1);\n    my $retSe\
q;\n\n    # Query sequence\n    if (defined($ARGV[\
0])) {                  # Bare option\n        if \
(-f $ARGV[0] || $ARGV[0] eq '-') { # File\n       \
     $retSeq = &read_file($ARGV[0]);\n        }\n \
       else { # DB:ID or sequence\n            $re\
tSeq = $ARGV[0];\n        }\n    }\n    if ($param\
s{'sequence'}) {                                  \
    # Via --sequence\n        if (-f $params{'sequ\
ence'} || $params{'sequence'} eq '-') { # File\n  \
          $retSeq = &read_file($params{'sequence'}\
);\n        }\n        else { # DB:ID or sequence\\
n            $retSeq = $params{'sequence'};\n     \
   }\n    }\n    print_debug_message('load_data', \
'End', 1);\n    return $retSeq;\n}\n\n=head2 load_\
params()\n\nLoad job parameters from command-line \
options.\n\n  &load_params();\n\n=cut\n\nsub load_\
params {\n    print_debug_message('load_params', '\
Begin', 1);\n\n    # Pass default values and fix b\
ools (without default value)\n    if ($params{'sty\
pe'} eq 'protein') {\n        if (!$params{'task'}\
) {\n            $params{'task'} = 'blastp'\n     \
   }\n    }\n    if ($params{'stype'} eq 'nucleoti\
de') {\n        if (!$params{'task'}) {\n         \
   $params{'task'} = 'blastn'\n        }\n    }\n \
   if ($params{'stype'} eq 'vector') {\n        if\
 (!$params{'task'}) {\n            $params{'task'}\
 = 'blastn'\n        }\n    }\n\n    if ($params{'\
stype'} eq 'protein') {\n        if (!$params{'mat\
rix'}) {\n            $params{'matrix'} = 'BLOSUM6\
2'\n        }\n    }\n    if ($params{'stype'} eq \
'nucleotide') {\n        if (!$params{'matrix'}) {\
\n            $params{'matrix'} = 'NONE'\n        \
}\n    }\n    if ($params{'stype'} eq 'vector') {\\
n        if (!$params{'matrix'}) {\n            $p\
arams{'matrix'} = 'NONE'\n        }\n    }\n\n    \
if (!$params{'alignments'}) {\n        $params{'al\
ignments'} = 50\n    }\n\n    if (!$params{'scores\
'}) {\n        $params{'scores'} = 50\n    }\n\n  \
  if (!$params{'exp'}) {\n        $params{'exp'} =\
 '10'\n    }\n\n    if (!$params{'dropoff'}) {\n  \
      $params{'dropoff'} = 0\n    }\n\n    if ($pa\
rams{'stype'} eq 'nucleotide') {\n        if (!$pa\
rams{'match_scores'}) {\n            $params{'matc\
h_scores'} = '1,-3'\n        }\n    }\n    if ($pa\
rams{'stype'} eq 'vector') {\n        if (!$params\
{'match_scores'}) {\n            $params{'match_sc\
ores'} = '1,-3'\n        }\n    }\n\n    if (!$par\
ams{'gapopen'}) {\n        $params{'gapopen'} = -1\
\n    }\n\n    if (!$params{'gapext'}) {\n        \
$params{'gapext'} = -1\n    }\n\n    if ($params{'\
stype'} eq 'protein') {\n        if (!$params{'fil\
ter'}) {\n            $params{'filter'} = 'F'\n   \
     }\n    }\n    if ($params{'stype'} eq 'nucleo\
tide') {\n        if (!$params{'filter'}) {\n     \
       $params{'filter'} = 'T'\n        }\n    }\n\
    if ($params{'stype'} eq 'vector') {\n        i\
f (!$params{'filter'}) {\n            $params{'fil\
ter'} = 'T'\n        }\n    }\n\n    if (!$params{\
'gapalign'}) {\n        $params{'gapalign'} = 'tru\
e'\n    }\n\n    if (!$params{'compstats'}) {\n   \
     $params{'compstats'} = 'F'\n    }\n\n    if (\
!$params{'align'}) {\n        $params{'align'} = 0\
\n    }\n\n    if (!$params{'transltable'}) {\n   \
     $params{'transltable'} = 1\n    }\n\n    prin\
t_debug_message('load_params', 'End', 1);\n}\n\n=h\
ead2 client_poll()\n\nClient-side job polling.\n\n\
  &client_poll($job_id);\n\n=cut\n\nsub client_pol\
l {\n    print_debug_message('client_poll', 'Begin\
', 1);\n    my $jobid = shift;\n    my $status = '\
PENDING';\n\n    # Check status and wait if not fi\
nished. Terminate if three attempts get \"ERROR\".\
\n    my $errorCount = 0;\n    while ($status eq '\
RUNNING'\n        || $status eq 'PENDING'\n       \
 || ($status eq 'ERROR' && $errorCount < 2)) {\n  \
      $status = rest_get_status($jobid);\n        \
print STDERR \"$status\\n\" if ($outputLevel > 0);\
\n        if ($status eq 'ERROR') {\n            $\
errorCount++;\n        }\n        elsif ($errorCou\
nt > 0) {\n            $errorCount--;\n        }\n\
        if ($status eq 'RUNNING'\n            || $\
status eq 'PENDING'\n            || $status eq 'ER\
ROR') {\n\n            # Wait before polling again\
.\n            usleep($checkInterval);\n        }\\
n    }\n    print_debug_message('client_poll', 'En\
d', 1);\n    return $status;\n}\n\n=head2 get_resu\
lts()\n\nGet the results for a job identifier.\n\n\
  &get_results($job_id);\n\n=cut\n\nsub get_result\
s {\n    print_debug_message('get_results', 'Begin\
', 1);\n    my $jobid = shift;\n    print_debug_me\
ssage('get_results', 'jobid: ' . $jobid, 1);\n    \
my $seq_id = shift;\n    print_debug_message('get_\
results', 'seq_id: ' . $seq_id, 1) if ($seq_id);\n\
\n    my $output_basename = $jobid;\n\n    # Verbo\
se\n    if ($outputLevel > 1) {\n        print 'Ge\
tting results for job ', $jobid, \"\\n\";\n    }\n\
\n    # Check status, and wait if not finished\n  \
  client_poll($jobid);\n\n    # Default output fil\
e names use JobId, however the name can be specifi\
ed...\n    if (defined($params{'outfile'})) {\n   \
     $output_basename = $params{'outfile'};\n    }\
\n    # Or use sequence identifer.\n    elsif (def\
ined($params{'useSeqId'} && defined($seq_id) && $s\
eq_id ne '')) {\n        $output_basename = $seq_i\
d;\n\n        # Make safe to use as a file name.\n\
        $output_basename =~ s/\\W/_/g;\n    }\n\n \
   # Use JobId if output file name is not defined\\
n    else {\n        unless (defined($params{'outf\
ile'})) {\n            #$params{'outfile'} = $jobi\
d;\n            $output_basename = $jobid;\n      \
  }\n    }\n\n    # Get list of data types\n    my\
 (@resultTypes) = rest_get_result_types($jobid);\n\
\n\n    # Get the data and write it to a file\n   \
 if (defined($params{'outformat'})) {\n        # S\
pecified data type\n        # check to see if ther\
e are multiple formats (comma separated)\n        \
my $sep = \",\";\n        my (@multResultTypes);\n\
        if ($params{'outformat'} =~ /$sep/) {\n   \
         @multResultTypes = split(',', $params{'ou\
tformat'});\n        }\n        else {\n          \
  $multResultTypes[0] = $params{'outformat'};\n   \
     }\n        # check if the provided formats ar\
e recognised\n        foreach my $inputType (@mult\
ResultTypes) {\n            my $expectation = 0;\n\
            foreach my $resultType (@resultTypes) \
{\n                if ($resultType->{'identifier'}\
 eq $inputType && $expectation eq 0) {\n          \
          $expectation = 1;\n                }\n  \
          }\n            if ($expectation ne 1) {\\
n                die 'Error: unknown result format\
 \"' . $inputType . '\"';\n            }\n        \
}\n        # if so get the files\n        my $selR\
esultType;\n        foreach my $resultType (@resul\
tTypes) {\n            if (grep {$_ eq $resultType\
->{'identifier'}} @multResultTypes) {\n           \
     $selResultType = $resultType;\n              \
  my $result = rest_get_result($jobid, $selResultT\
ype->{'identifier'});\n                if (defined\
($params{'outfile'}) && $params{'outfile'} eq '-')\
 {\n                    write_file($params{'outfil\
e'}, $result);\n                }\n               \
 else {\n                    write_file(\n        \
                $output_basename . '.'\n          \
                  . $selResultType->{'identifier'}\
 . '.'\n                            . $selResultTy\
pe->{'fileSuffix'},\n                        $resu\
lt\n                    );\n                }\n   \
         }\n        }\n    }\n    else { # Data ty\
pes available\n        # Write a file for each out\
put type\n        for my $resultType (@resultTypes\
) {\n            if ($outputLevel > 1) {\n        \
        print STDERR 'Getting ', $resultType->{'id\
entifier'}, \"\\n\";\n            }\n            m\
y $result = rest_get_result($jobid, $resultType->{\
'identifier'});\n            if (defined($params{'\
outfile'}) && $params{'outfile'} eq '-') {\n      \
          write_file($params{'outfile'}, $result);\
\n            }\n            else {\n             \
   write_file(\n                    $output_basena\
me . '.'\n                        . $resultType->{\
'identifier'} . '.'\n                        . $re\
sultType->{'fileSuffix'},\n                    $re\
sult\n                );\n            }\n        }\
\n    }\n    print_debug_message('get_results', 'E\
nd', 1);\n}\n\n=head2 read_file()\n\nRead a file i\
nto a scalar. The special filename '-' can be used\
 to read from\nstandard input (STDIN).\n\n  my $da\
ta = &read_file($filename);\n\n=cut\n\nsub read_fi\
le {\n    print_debug_message('read_file', 'Begin'\
, 1);\n    my $filename = shift;\n    print_debug_\
message('read_file', 'filename: ' . $filename, 2);\
\n    my ($content, $buffer);\n    if ($filename e\
q '-') {\n        while (sysread(STDIN, $buffer, 1\
024)) {\n            $content .= $buffer;\n       \
 }\n    }\n    else {\n        # File\n        ope\
n(my $FILE, '<', $filename)\n            or die \"\
Error: unable to open input file $filename ($!)\";\
\n        while (sysread($FILE, $buffer, 1024)) {\\
n            $content .= $buffer;\n        }\n    \
    close($FILE);\n    }\n    print_debug_message(\
'read_file', 'End', 1);\n    return $content;\n}\n\
\n=head2 write_file()\n\nWrite data to a file. The\
 special filename '-' can be used to write to\nsta\
ndard output (STDOUT).\n\n  &write_file($filename,\
 $data);\n\n=cut\n\nsub write_file {\n    print_de\
bug_message('write_file', 'Begin', 1);\n    my ($f\
ilename, $data) = @_;\n    print_debug_message('wr\
ite_file', 'filename: ' . $filename, 2);\n    if (\
$outputLevel > 0) {\n        print STDERR 'Creatin\
g result file: ' . $filename . \"\\n\";\n    }\n  \
  if ($filename eq '-') {\n        print STDOUT $d\
ata;\n    }\n    else {\n        open(my $FILE, '>\
', $filename)\n            or die \"Error: unable \
to open output file $filename ($!)\";\n        sys\
write($FILE, $data);\n        close($FILE);\n    }\
\n    print_debug_message('write_file', 'End', 1);\
\n}\n\n=head2 usage()\n\nPrint program usage messa\
ge.\n\n  &usage();\n\n=cut\n\nsub usage {\n    pri\
nt STDERR <<EOF\nEMBL-EBI NCBI Blast Perl Client:\\
n\nSequence similarity search with NCBI Blast.\n\n\
[Required (for job submission)]\n  --email        \
       E-mail address.\n  --program             Th\
e BLAST program to be used for the Sequence Simila\
rity\n                        Search.\n  --stype  \
             Indicates if the sequence is protein \
or DNA/RNA.\n  --sequence            The query seq\
uence can be entered directly into this form.\n   \
                     The sequence can be in GCG, F\
ASTA, EMBL (Nucleotide only),\n                   \
     GenBank, PIR, NBRF, PHYLIP or UniProtKB/Swiss\
-Prot (Protein\n                        only) form\
at. A partially formatted sequence is not\n       \
                 accepted. Adding a return to the \
end of the sequence may\n                        h\
elp certain applications understand the input. Not\
e that\n                        directly using dat\
a from word processors may yield\n                \
        unpredictable results as hidden/control ch\
aracters may be\n                        present.\\
n  --database            Database.\n\n[Optional]\n\
  --task                Task option (only selectab\
le for blastn).\n  --matrix              (Protein \
searches) The substitution matrix used for scoring\
\n                        alignments when searchin\
g the database.\n  --alignments          Maximum n\
umber of match alignments reported in the result\n\
                        output.\n  --scores       \
       Maximum number of match score summaries rep\
orted in the\n                        result outpu\
t.\n  --exp                 Limits the number of s\
cores and alignments reported based on\n          \
              the expectation value. This is the m\
aximum number of times\n                        th\
e match is expected to occur by chance.\n  --dropo\
ff             The amount a score can drop before \
gapped extension of word\n                        \
hits is halted.\n  --match_scores        (Nucleoti\
de searches) The match score is the bonus to the\n\
                        alignment score when match\
ing the same base. The mismatch is\n              \
          the penalty when failing to match.\n  --\
gapopen             Penalty taken away from the sc\
ore when a gap is created in\n                    \
    sequence. Increasing the gap openning penalty \
will decrease\n                        the number \
of gaps in the final alignment.\n  --gapext       \
       Penalty taken away from the score for each \
base or residue\n                        in the ga\
p. Increasing the gap extension penalty favors\n  \
                      short gaps in the final alig\
nment, conversly decreasing the\n                 \
       gap extension penalty favors long gaps in t\
he final\n                        alignment.\n  --\
filter              Filter regions of low sequence\
 complexity. This can avoid\n                     \
   issues with low complexity sequences where matc\
hes are found\n                        due to comp\
osition rather than meaningful sequence\n         \
               similarity. However in some cases f\
iltering also masks\n                        regio\
ns of interest and so should be used with caution.\
\n  --seqrange            Specify a range or secti\
on of the input sequence to use in\n              \
          the search. Example: Specifying '34-89' \
in an input sequence\n                        of t\
otal length 100, will tell BLAST to only use resid\
ues 34\n                        to 89, inclusive.\\
n  --gapalign            This is a true/false sett\
ing that tells the program the\n                  \
      perform optimised alignments within regions \
involving gaps.\n                        If set to\
 true, the program will perform an alignment using\
\n                        gaps. Otherwise, if it i\
s set to false, it will report only\n             \
           individual HSP where two sequence match\
 each other, and thus\n                        wil\
l not produce alignments with gaps.\n  --wordsize \
           Word size for wordfinder algorithm.\n  \
--compstats           Use composition-based statis\
tics.\n  --align               Formating for the a\
lignments.\n  --transltable         Query Genetic \
code to use in translation.\n\n[General]\n  -h, --\
help            Show this help message and exit.\n\
  --asyncjob            Forces to make an asynchro\
nous query.\n  --title               Title for job\
.\n  --status              Get job status.\n  --re\
sultTypes         Get available result types for j\
ob.\n  --polljob             Poll for the status o\
f a job.\n  --pollFreq            Poll frequency i\
n seconds (default 3s).\n  --jobid               J\
obId that was returned when an asynchronous job wa\
s submitted.\n  --outfile             File name fo\
r results (default is JobId; for STDOUT).\n  --mul\
tifasta          Treat input as a set of fasta for\
matted sequences.\n  --useSeqId            Use seq\
uence identifiers for output filenames.\n         \
               Only available in multi-fasta and m\
ulti-identifier modes.\n  --maxJobs             Ma\
ximum number of concurrent jobs. Only\n           \
             available in multifasta or list file \
modes.\n  --outformat           Result format(s) t\
o retrieve. It accepts comma-separated values.\n  \
--params              List input parameters.\n  --\
paramDetail         Display details for input para\
meter.\n  --quiet               Decrease output.\n\
  --verbose             Increase output.\n  --vers\
ion             Prints out the version of the Clie\
nt and exit.\n  --baseUrl             Base URL. De\
faults to:\n                        https://www.eb\
i.ac.uk/Tools/services/rest/ncbiblast\n\nSynchrono\
us job:\n  The results/errors are returned as soon\
 as the job is finished.\n  Usage: perl $scriptNam\
e --email <your\\@email.com> [options...] <SeqFile\
|SeqID(s)>\n  Returns: results as an attachment\n\\
nAsynchronous job:\n  Use this if you want to retr\
ieve the results at a later time. The results\n  a\
re stored for up to 24 hours.\n  Usage: perl $scri\
ptName --asyncjob --email <your\\@email.com> [opti\
ons...] <SeqFile|SeqID(s)>\n  Returns: jobid\n\nCh\
eck status of Asynchronous job:\n  Usage: perl $sc\
riptName --status --jobid <jobId>\n\nRetrieve job \
data:\n  Use the jobid to query for the status of \
the job. If the job is finished,\n  it also return\
s the results/errors.\n  Usage: perl $scriptName -\
-polljob --jobid <jobId> [--outfile string]\n  Ret\
urns: string indicating the status of the job and \
if applicable, results\n  as an attachment.\n\nFur\
ther information:\n  https://www.ebi.ac.uk/Tools/w\
ebservices and\n    https://github.com/ebi-wp/webs\
ervice-clients\n\nSupport/Feedback:\n  https://www\
.ebi.ac.uk/support/\nEOF\n}\n\n=head1 FEEDBACK/SUP\
PORT\n\nPlease contact us at L<https://www.ebi.ac.\
uk/support/> if you have any\nfeedback, suggestion\
s or issues with the service or this client.\n\n=c\
ut\n","\n=head1 NAME\n\nwublast_lwp.pl\n\n=head1 D\
ESCRIPTION\n\nWU-BLAST (REST) web service Perl cli\
ent using L<LWP>.\n\nTested with:\n\n=over\n\n=ite\
m *\nL<LWP> 5.79, L<XML::Simple> 2.12 and Perl 5.8\
.3\n\n=item *\nL<LWP> 5.808, L<XML::Simple> 2.18 a\
nd Perl 5.8.8 (Ubuntu 8.04 LTS)\n\n=item *\nL<LWP>\
 5.834, L<XML::Simple> 2.18 and Perl 5.10.1 (Ubunt\
u 10.04 LTS)\n\n=item *\nL<LWP> 6.03, L<XML::Simpl\
e> 2.18 and Perl 5.14.2 (Ubuntu 12.04 LTS)\n\n=bac\
k\n\nFor further information see:\n\n=over\n\n=ite\
m *\nL<http://www.ebi.ac.uk/Tools/webservices/serv\
ices/sss/wu_blast_rest>\n\n=item *\nL<http://www.e\
bi.ac.uk/Tools/webservices/tutorials/perl>\n\n=bac\
k\n\n=head1 LICENSE\n\nCopyright 2012-2013 EMBL - \
European Bioinformatics Institute\n\nLicensed unde\
r the Apache License, Version 2.0 (the \"License\"\
);\nyou may not use this file except in compliance\
 with the License.\nYou may obtain a copy of the L\
icense at\n\n    http://www.apache.org/licenses/LI\
CENSE-2.0\n\nUnless required by applicable law or \
agreed to in writing, software\ndistributed under \
the License is distributed on an \"AS IS\" BASIS,\\
nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, eit\
her express or implied.\nSee the License for the s\
pecific language governing permissions and\nlimita\
tions under the License.\n\n=head1 VERSION\n\n$Id:\
 wublast_lwp.pl 2560 2013-03-20 12:56:31Z hpm $\n\\
n=cut\n\nuse strict;\nuse warnings;\n\nuse English\
;\nuse LWP;\nuse XML::Simple;\nuse Getopt::Long qw\
(:config no_ignore_case bundling);\nuse File::Base\
name;\nuse Data::Dumper;\n\nmy $baseUrl = 'http://\
www.ebi.ac.uk/Tools/services/rest/wublast';\n\nmy \
$checkInterval = 3;\n\nmy $outputLevel = 1;\n\nmy \
$numOpts = scalar(@ARGV);\nmy %params = ( 'debugLe\
vel' => 0 );\n\nmy %tool_params = ();\nGetOptions(\
\n\n	# Tool specific options\n	'program|p=s'     =\
> \\$tool_params{'program'},      # BLAST program\\
n	'database|D=s'    => \\$params{'database'},     \
# Search database\n	'matrix|m=s'      => \\$tool_p\
arams{'matrix'},       # Scoring matrix\n	'exp|E=f\
'         => \\$tool_params{'exp'},          # E-v\
alue threshold\n	'viewfilter|e'    => \\$tool_para\
ms{'viewfilter'},   # Display filtered sequence\n	\
'filter|f=s'      => \\$tool_params{'filter'},    \
   # Low complexity filter name\n	'alignments|n=i'\
  => \\$tool_params{'alignments'},   # Number of a\
lignments\n	'scores|s=i'      => \\$tool_params{'s\
cores'},       # Number of scores\n	'sensitivity|S\
=s' => \\$tool_params{'sensitivity'},  # Search se\
nsitivity\n	'sort|t=s'        => \\$tool_params{'s\
ort'},         # Sort hits by...\n	'stats|T=s'    \
   => \\$tool_params{'stats'},        # Scoring st\
atistic to use\n	'strand|d=s'      => \\$tool_para\
ms{'strand'},       # Strand to use\n	'topcombon|c\
=i'   => \\$tool_params{'topcombon'},    # Consist\
ent sets of HSPs\n	'align|A=i'       => \\$tool_pa\
rams{'align'},   # Pairwise alignment format\n	'st\
ype=s' => \\$tool_params{'stype'},    # Sequence t\
ype 'protein' or 'dna'\n	'sequence=s' => \\$params\
{'sequence'},         # Query sequence file or DB:\
ID\n	'multifasta' => \\$params{'multifasta'},     \
  # Multiple fasta input\n\n	# Compatability optio\
ns, old command-line.\n	'echofilter|e'    => \\$pa\
rams{'echofilter'},   # Display filtered sequence\\
n	'b=i'  => \\$params{'numal'},        # Number of\
 alignments\n	'appxml=s'        => \\$params{'appx\
ml'},       # Application XML\n\n	# Generic option\
s\n	'email=s'       => \\$params{'email'},        \
  # User e-mail address\n	'title=s'       => \\$pa\
rams{'title'},          # Job title\n	'outfile=s' \
    => \\$params{'outfile'},        # Output file \
name\n	'outformat=s'   => \\$params{'outformat'}, \
     # Output file type\n	'jobid=s'       => \\$pa\
rams{'jobid'},          # JobId\n	'help|h'        \
=> \\$params{'help'},           # Usage help\n	'as\
ync'         => \\$params{'async'},          # Asy\
nchronous submission\n	'polljob'       => \\$param\
s{'polljob'},        # Get results\n	'resultTypes'\
   => \\$params{'resultTypes'},    # Get result ty\
pes\n	'status'        => \\$params{'status'},     \
    # Get status\n	'params'        => \\$params{'p\
arams'},         # List input parameters\n	'paramD\
etail=s' => \\$params{'paramDetail'},    # Get det\
ails for parameter\n	'quiet'         => \\$params{\
'quiet'},          # Decrease output level\n	'verb\
ose'       => \\$params{'verbose'},        # Incre\
ase output level\n	'debugLevel=i'  => \\$params{'d\
ebugLevel'},     # Debug output level\n	'baseUrl=s\
'     => \\$baseUrl,                  # Base URL f\
or service.\n);\nif ( $params{'verbose'} ) { $outp\
utLevel++ }\nif ( $params{'quiet'} )  { $outputLev\
el-- }\n\n&print_debug_message( 'MAIN', 'LWP::VERS\
ION: ' . $LWP::VERSION,\n	1 );\n\n&print_debug_mes\
sage( 'MAIN', \"params:\\n\" . Dumper( \\%params )\
,           11 );\n&print_debug_message( 'MAIN', \\
"tool_params:\\n\" . Dumper( \\%tool_params ), 11 \
);\n\nmy $ua;\n\nmy $scriptName = basename( $0, ()\
 );\n\nif ( $params{'help'} || $numOpts == 0 ) {\n\
	&usage();\n	exit(0);\n}\n\n&print_debug_message( \
'MAIN', 'baseUrl: ' . $baseUrl, 1 );\n\nif (\n	!(\\
n		   $params{'polljob'}\n		|| $params{'resultType\
s'}\n		|| $params{'status'}\n		|| $params{'params'\
}\n		|| $params{'paramDetail'}\n	)\n	&& !( defined\
( $ARGV[0] ) || defined( $params{'sequence'} ) )\n\
  )\n{\n\n	# Bad argument combination, so print er\
ror message and usage\n	print STDERR 'Error: bad o\
ption combination', \"\\n\";\n	&usage();\n	exit(1)\
;\n}\n\nelsif ( $params{'params'} ) {\n	&print_too\
l_params();\n}\n\nelsif ( $params{'paramDetail'} )\
 {\n	&print_param_details( $params{'paramDetail'} \
);\n}\n\nelsif ( $params{'status'} && defined( $pa\
rams{'jobid'} ) ) {\n	&print_job_status( $params{'\
jobid'} );\n}\n\nelsif ( $params{'resultTypes'} &&\
 defined( $params{'jobid'} ) ) {\n	&print_result_t\
ypes( $params{'jobid'} );\n}\n\nelsif ( $params{'p\
olljob'} && defined( $params{'jobid'} ) ) {\n	&get\
_results( $params{'jobid'} );\n}\n\nelse {\n\n	# M\
ultiple input sequence mode, assume fasta format.\\
n	if ( $params{'multifasta'} ) {\n		&multi_submit_\
job();\n	}\n\n	# Entry identifier list file.\n	els\
if (( defined( $params{'sequence'} ) && $params{'s\
equence'} =~ m/^\\@/ )\n		|| ( defined( $ARGV[0] )\
 && $ARGV[0] =~ m/^\\@/ ) )\n	{\n		my $list_filena\
me = $params{'sequence'} || $ARGV[0];\n		$list_fil\
ename =~ s/^\\@//;\n		&list_file_submit_job($list_\
filename);\n	}\n\n	# Default: single sequence/iden\
tifier.\n	else {\n\n		# Load the sequence data and\
 submit.\n		&submit_job( &load_data() );\n	}\n}\n\\
n=head1 FUNCTIONS\n\n=cut\n\n\n=head2 rest_user_ag\
ent()\n\nGet a LWP UserAgent to use to perform RES\
T requests.\n\n  my $ua = &rest_user_agent();\n\n=\
cut\n\nsub rest_user_agent() {\n	print_debug_messa\
ge( 'rest_user_agent', 'Begin', 21 );\n	# Create a\
n LWP UserAgent for making HTTP calls.\n	my $ua = \
LWP::UserAgent->new();\n	# Set 'User-Agent' HTTP h\
eader to identifiy the client.\n	'$Revision: 2560 \
$' =~ m/(\\d+)/;\n	$ua->agent(\"EBI-Sample-Client/\
$1 ($scriptName; $OSNAME) \" . $ua->agent());\n	# \
Configure HTTP proxy support from environment.\n	$\
ua->env_proxy;\n	print_debug_message( 'rest_user_a\
gent', 'End', 21 );\n	return $ua;\n}\n\n=head2 res\
t_error()\n\nCheck a REST response for an error co\
ndition. An error is mapped to a die.\n\n  &rest_e\
rror($response, $content_data);\n\n=cut\n\nsub res\
t_error() {\n	print_debug_message( 'rest_error', '\
Begin', 21 );\n	my $response = shift;\n	my $conten\
tdata;\n	if(scalar(@_) > 0) {\n		$contentdata = sh\
ift;\n	}\n	if(!defined($contentdata) || $contentda\
ta eq '') {\n		$contentdata = $response->content()\
;\n	}\n	# Check for HTTP error codes\n	if ( $respo\
nse->is_error ) {\n		my $error_message = '';\n		# \
HTML response.\n		if(	$contentdata =~ m/<h1>([^<]+\
)<\\/h1>/ ) {\n			$error_message = $1;\n		}\n		#  \
XML response.\n		elsif($contentdata =~ m/<descript\
ion>([^<]+)<\\/description>/) {\n			$error_message\
 = $1;\n		}\n		die 'http status: ' . $response->co\
de . ' ' . $response->message . '  ' . $error_mess\
age;\n	}\n	print_debug_message( 'rest_error', 'End\
', 21 );\n}\n\n=head2 rest_request()\n\nPerform a \
REST request (HTTP GET).\n\n  my $response_str = &\
rest_request($url);\n\n=cut\n\nsub rest_request {\\
n	print_debug_message( 'rest_request', 'Begin', 11\
 );\n	my $requestUrl = shift;\n	print_debug_messag\
e( 'rest_request', 'URL: ' . $requestUrl, 11 );\n\\
n	# Get an LWP UserAgent.\n	$ua = &rest_user_agent\
() unless defined($ua);\n	# Available HTTP compres\
sion methods.\n	my $can_accept;\n	eval {\n	    $ca\
n_accept = HTTP::Message::decodable();\n	};\n	$can\
_accept = '' unless defined($can_accept);\n	# Perf\
orm the request\n	my $response = $ua->get($request\
Url,\n		'Accept-Encoding' => $can_accept, # HTTP c\
ompression.\n	);\n	print_debug_message( 'rest_requ\
est', 'HTTP status: ' . $response->code,\n		11 );\\
n	print_debug_message( 'rest_request',\n		'respons\
e length: ' . length($response->content()), 11 );\\
n	print_debug_message( 'rest_request',\n		'request\
:' .\"\\n\" . $response->request()->as_string(), 3\
2 );\n	print_debug_message( 'rest_request',\n		're\
sponse: ' . \"\\n\" . $response->as_string(), 32 )\
;\n	# Unpack possibly compressed response.\n	my $r\
etVal;\n	if ( defined($can_accept) && $can_accept \
ne '') {\n	    $retVal = $response->decoded_conten\
t();\n	}\n	# If unable to decode use orginal conte\
nt.\n	$retVal = $response->content() unless define\
d($retVal);\n	# Check for an error.\n	&rest_error(\
$response, $retVal);\n	print_debug_message( 'rest_\
request', 'retVal: ' . $retVal, 12 );\n	print_debu\
g_message( 'rest_request', 'End', 11 );\n\n	# Retu\
rn the response data\n	return $retVal;\n}\n\n=head\
2 rest_get_parameters()\n\nGet list of tool parame\
ter names.\n\n  my (@param_list) = &rest_get_param\
eters();\n\n=cut\n\nsub rest_get_parameters {\n	pr\
int_debug_message( 'rest_get_parameters', 'Begin',\
 1 );\n	my $url                = $baseUrl . '/para\
meters/';\n	my $param_list_xml_str = rest_request(\
$url);\n	my $param_list_xml     = XMLin($param_lis\
t_xml_str);\n	my (@param_list)       = @{ $param_l\
ist_xml->{'id'} };\n	print_debug_message( 'rest_ge\
t_parameters', 'End', 1 );\n	return (@param_list);\
\n}\n\n=head2 rest_get_parameter_details()\n\nGet \
details of a tool parameter.\n\n  my $paramDetail \
= &rest_get_parameter_details($param_name);\n\n=cu\
t\n\nsub rest_get_parameter_details {\n	print_debu\
g_message( 'rest_get_parameter_details', 'Begin', \
1 );\n	my $parameterId = shift;\n	print_debug_mess\
age( 'rest_get_parameter_details',\n		'parameterId\
: ' . $parameterId, 1 );\n	my $url                \
  = $baseUrl . '/parameterdetails/' . $parameterId\
;\n	my $param_detail_xml_str = rest_request($url);\
\n	my $param_detail_xml     = XMLin($param_detail_\
xml_str);\n	print_debug_message( 'rest_get_paramet\
er_details', 'End', 1 );\n	return ($param_detail_x\
ml);\n}\n\n=head2 rest_run()\n\nSubmit a job.\n\n \
 my $job_id = &rest_run($email, $title, \\%params \
);\n\n=cut\n\nsub rest_run {\n	print_debug_message\
( 'rest_run', 'Begin', 1 );\n	my $email  = shift;\\
n	my $title  = shift;\n	my $params = shift;\n	prin\
t_debug_message( 'rest_run', 'email: ' . $email, 1\
 );\n	if ( defined($title) ) {\n		print_debug_mess\
age( 'rest_run', 'title: ' . $title, 1 );\n	}\n	pr\
int_debug_message( 'rest_run', 'params: ' . Dumper\
($params), 1 );\n\n	# Get an LWP UserAgent.\n	$ua \
= &rest_user_agent() unless defined($ua);\n\n	# Cl\
ean up parameters\n	my (%tmp_params) = %{$params};\
\n	$tmp_params{'email'} = $email;\n	$tmp_params{'t\
itle'} = $title;\n	foreach my $param_name ( keys(%\
tmp_params) ) {\n		if ( !defined( $tmp_params{$par\
am_name} ) ) {\n			delete $tmp_params{$param_name}\
;\n		}\n	}\n\n	# Submit the job as a POST\n	my $ur\
l = $baseUrl . '/run';\n	my $response = $ua->post(\
 $url, \\%tmp_params );\n	print_debug_message( 're\
st_run', 'HTTP status: ' . $response->code, 11 );\\
n	print_debug_message( 'rest_run',\n		'request:' .\
\"\\n\" . $response->request()->as_string(), 11 );\
\n	print_debug_message( 'rest_run',\n		'response: \
' . length($response->as_string()) . \"\\n\" . $re\
sponse->as_string(), 11 );\n\n	# Check for an erro\
r.\n	&rest_error($response);\n\n	# The job id is r\
eturned\n	my $job_id = $response->content();\n	pri\
nt_debug_message( 'rest_run', 'End', 1 );\n	return\
 $job_id;\n}\n\n=head2 rest_get_status()\n\nCheck \
the status of a job.\n\n  my $status = &rest_get_s\
tatus($job_id);\n\n=cut\n\nsub rest_get_status {\n\
	print_debug_message( 'rest_get_status', 'Begin', \
1 );\n	my $job_id = shift;\n	print_debug_message( \
'rest_get_status', 'jobid: ' . $job_id, 2 );\n	my \
$status_str = 'UNKNOWN';\n	my $url        = $baseU\
rl . '/status/' . $job_id;\n	$status_str = &rest_r\
equest($url);\n	print_debug_message( 'rest_get_sta\
tus', 'status_str: ' . $status_str, 2 );\n	print_d\
ebug_message( 'rest_get_status', 'End', 1 );\n	ret\
urn $status_str;\n}\n\n=head2 rest_get_result_type\
s()\n\nGet list of result types for finished job.\\
n\n  my (@result_types) = &rest_get_result_types($\
job_id);\n\n=cut\n\nsub rest_get_result_types {\n	\
print_debug_message( 'rest_get_result_types', 'Beg\
in', 1 );\n	my $job_id = shift;\n	print_debug_mess\
age( 'rest_get_result_types', 'jobid: ' . $job_id,\
 2 );\n	my (@resultTypes);\n	my $url              \
        = $baseUrl . '/resulttypes/' . $job_id;\n	\
my $result_type_list_xml_str = &rest_request($url)\
;\n	my $result_type_list_xml     = XMLin($result_t\
ype_list_xml_str);\n	(@resultTypes) = @{ $result_t\
ype_list_xml->{'type'} };\n	print_debug_message( '\
rest_get_result_types',\n		scalar(@resultTypes) . \
' result types', 2 );\n	print_debug_message( 'rest\
_get_result_types', 'End', 1 );\n	return (@resultT\
ypes);\n}\n\n=head2 rest_get_result()\n\nGet resul\
t data of a specified type for a finished job.\n\n\
  my $result = rest_get_result($job_id, $result_ty\
pe);\n\n=cut\n\nsub rest_get_result {\n	print_debu\
g_message( 'rest_get_result', 'Begin', 1 );\n	my $\
job_id = shift;\n	my $type   = shift;\n	print_debu\
g_message( 'rest_get_result', 'jobid: ' . $job_id,\
 1 );\n	print_debug_message( 'rest_get_result', 't\
ype: ' . $type,    1 );\n	my $url    = $baseUrl . \
'/result/' . $job_id . '/' . $type;\n	my $result =\
 &rest_request($url);\n	print_debug_message( 'rest\
_get_result', length($result) . ' characters',\n		\
1 );\n	print_debug_message( 'rest_get_result', 'En\
d', 1 );\n	return $result;\n}\n\n\n=head2 print_de\
bug_message()\n\nPrint debug message at specified \
debug level.\n\n  &print_debug_message($method_nam\
e, $message, $level);\n\n=cut\n\nsub print_debug_m\
essage {\n	my $function_name = shift;\n	my $messag\
e       = shift;\n	my $level         = shift;\n	if\
 ( $level <= $params{'debugLevel'} ) {\n		print ST\
DERR '[', $function_name, '()] ', $message, \"\\n\\
";\n	}\n}\n\n=head2 print_tool_params()\n\nPrint l\
ist of tool parameters.\n\n  &print_tool_params();\
\n\n=cut\n\nsub print_tool_params {\n	print_debug_\
message( 'print_tool_params', 'Begin', 1 );\n	my (\
@param_list) = &rest_get_parameters();\n	foreach m\
y $param ( sort(@param_list) ) {\n		print $param, \
\"\\n\";\n	}\n	print_debug_message( 'print_tool_pa\
rams', 'End', 1 );\n}\n\n=head2 print_param_detail\
s()\n\nPrint details of a tool parameter.\n\n  &pr\
int_param_details($param_name);\n\n=cut\n\nsub pri\
nt_param_details {\n	print_debug_message( 'print_p\
aram_details', 'Begin', 1 );\n	my $paramName = shi\
ft;\n	print_debug_message( 'print_param_details', \
'paramName: ' . $paramName, 2 );\n	my $paramDetail\
 = &rest_get_parameter_details($paramName);\n	prin\
t $paramDetail->{'name'}, \"\\t\", $paramDetail->{\
'type'}, \"\\n\";\n	print $paramDetail->{'descript\
ion'}, \"\\n\";\n	if(defined($paramDetail->{'value\
s'}->{'value'})) {\n		if(ref($paramDetail->{'value\
s'}->{'value'}) eq 'ARRAY') {\n			foreach my $valu\
e ( @{ $paramDetail->{'values'}->{'value'} } ) {\n\
				&print_param_value($value);\n			}\n		}\n		else\
 {\n				&print_param_value($paramDetail->{'values'\
}->{'value'});\n		}\n	}\n	print_debug_message( 'pr\
int_param_details', 'End', 1 );\n}\n\n=head2 print\
_param_value()\n\nPrint details of a tool paramete\
r value.\n\n  &print_param_details($param_value);\\
n\nUsed by print_param_details() to handle both si\
ngluar and array values.\n\n=cut\n\nsub print_para\
m_value {\n	my $value = shift;\n	print $value->{'v\
alue'};\n	if ( $value->{'defaultValue'} eq 'true' \
) {\n		print \"\\t\", 'default';\n	}\n	print \"\\n\
\";\n	print \"\\t\", $value->{'label'}, \"\\n\";\n\
	if ( defined( $value->{'properties'} ) ) {\n		for\
each\n		  my $key ( sort( keys( %{ $value->{'prope\
rties'}{'property'} } ) ) )\n		{\n			if ( ref( $va\
lue->{'properties'}{'property'}{$key} ) eq 'HASH'\\
n				&& defined( $value->{'properties'}{'property'\
}{$key}{'value'} )\n			  )\n			{\n				print \"\\t\\
", $key, \"\\t\",\n				  $value->{'properties'}{'p\
roperty'}{$key}{'value'}, \"\\n\";\n			}\n			else \
{\n				print \"\\t\", $value->{'properties'}{'prop\
erty'}{'key'},\n				  \"\\t\", $value->{'propertie\
s'}{'property'}{'value'}, \"\\n\";\n				last;\n			\
}\n		}\n	}\n}\n\n=head2 print_job_status()\n\nPrin\
t status of a job.\n\n  &print_job_status($job_id)\
;\n\n=cut\n\nsub print_job_status {\n	print_debug_\
message( 'print_job_status', 'Begin', 1 );\n	my $j\
obid = shift;\n	print_debug_message( 'print_job_st\
atus', 'jobid: ' . $jobid, 1 );\n	if ( $outputLeve\
l > 0 ) {\n		print STDERR 'Getting status for job \
', $jobid, \"\\n\";\n	}\n	my $result = &rest_get_s\
tatus($jobid);\n	print \"$result\\n\";\n	if ( $res\
ult eq 'FINISHED' && $outputLevel > 0 ) {\n		print\
 STDERR \"To get results: $scriptName --polljob --\
jobid \" . $jobid\n		  . \"\\n\";\n	}\n	print_debu\
g_message( 'print_job_status', 'End', 1 );\n}\n\n=\
head2 print_result_types()\n\nPrint available resu\
lt types for a job.\n\n  &print_result_types($job_\
id);\n\n=cut\n\nsub print_result_types {\n	print_d\
ebug_message( 'result_types', 'Begin', 1 );\n	my $\
jobid = shift;\n	print_debug_message( 'result_type\
s', 'jobid: ' . $jobid, 1 );\n	if ( $outputLevel >\
 0 ) {\n		print STDERR 'Getting result types for j\
ob ', $jobid, \"\\n\";\n	}\n	my $status = &rest_ge\
t_status($jobid);\n	if ( $status eq 'PENDING' || $\
status eq 'RUNNING' ) {\n		print STDERR 'Error: Jo\
b status is ', $status,\n		  '. To get result type\
s the job must be finished.', \"\\n\";\n	}\n	else \
{\n		my (@resultTypes) = &rest_get_result_types($j\
obid);\n		if ( $outputLevel > 0 ) {\n			print STDO\
UT 'Available result types:', \"\\n\";\n		}\n		for\
each my $resultType (@resultTypes) {\n			print STD\
OUT $resultType->{'identifier'}, \"\\n\";\n			if (\
 defined( $resultType->{'label'} ) ) {\n				print \
STDOUT \"\\t\", $resultType->{'label'}, \"\\n\";\n\
			}\n			if ( defined( $resultType->{'description'\
} ) ) {\n				print STDOUT \"\\t\", $resultType->{'\
description'}, \"\\n\";\n			}\n			if ( defined( $r\
esultType->{'mediaType'} ) ) {\n				print STDOUT \\
"\\t\", $resultType->{'mediaType'}, \"\\n\";\n			}\
\n			if ( defined( $resultType->{'fileSuffix'} ) )\
 {\n				print STDOUT \"\\t\", $resultType->{'fileS\
uffix'}, \"\\n\";\n			}\n		}\n		if ( $status eq 'F\
INISHED' && $outputLevel > 0 ) {\n			print STDERR \
\"\\n\", 'To get results:', \"\\n\",\n			  \"  $sc\
riptName --polljob --jobid \" . $params{'jobid'} .\
 \"\\n\",\n			  \"  $scriptName --polljob --outfor\
mat <type> --jobid \"\n			  . $params{'jobid'} . \\
"\\n\";\n		}\n	}\n	print_debug_message( 'result_ty\
pes', 'End', 1 );\n}\n\n=head2 submit_job()\n\nSub\
mit a job to the service.\n\n  &submit_job($seq);\\
n\n=cut\n\nsub submit_job {\n	print_debug_message(\
 'submit_job', 'Begin', 1 );\n\n	# Set input seque\
nce\n	$tool_params{'sequence'} = shift;\n\n	# Load\
 parameters\n	&load_params();\n\n	# Submit the job\
\n	my $jobid = &rest_run( $params{'email'}, $param\
s{'title'}, \\%tool_params );\n\n	# Simulate sync/\
async mode\n	if ( defined( $params{'async'} ) ) {\\
n		print STDOUT $jobid, \"\\n\";\n		if ( $outputLe\
vel > 0 ) {\n			print STDERR\n			  \"To check stat\
us: $scriptName --status --jobid $jobid\\n\";\n		}\
\n	}\n	else {\n		if ( $outputLevel > 0 ) {\n			pri\
nt STDERR \"JobId: $jobid\\n\";\n		}\n		sleep 1;\n\
		&get_results($jobid);\n	}\n	print_debug_message(\
 'submit_job', 'End', 1 );\n}\n\n=head2 multi_subm\
it_job()\n\nSubmit multiple jobs assuming input is\
 a collection of fasta formatted sequences.\n\n  &\
multi_submit_job();\n\n=cut\n\nsub multi_submit_jo\
b {\n	print_debug_message( 'multi_submit_job', 'Be\
gin', 1 );\n	my $jobIdForFilename = 1;\n	$jobIdFor\
Filename = 0 if ( defined( $params{'outfile'} ) );\
\n	my (@filename_list) = ();\n\n	# Query sequence\\
n	if ( defined( $ARGV[0] ) ) {    # Bare option\n	\
	if ( -f $ARGV[0] || $ARGV[0] eq '-' ) {    # File\
\n			push( @filename_list, $ARGV[0] );\n		}\n		els\
e {\n			warn 'Warning: Input file \"' . $ARGV[0] .\
 '\" does not exist'\n		}\n	}\n	if ( $params{'sequ\
ence'} ) {                   # Via --sequence\n		i\
f ( -f $params{'sequence'} || $params{'sequence'} \
eq '-' ) {    # File\n			push( @filename_list, $pa\
rams{'sequence'} );\n		}\n		else {\n			warn 'Warni\
ng: Input file \"' . $params{'sequence'} . '\" doe\
s not exist'\n		}\n	}\n\n	$/ = '>';\n	foreach my $\
filename (@filename_list) {\n		my $INFILE;\n		if($\
filename eq '-') { # STDIN.\n			open( $INFILE, '<-\
' )\n			  or die 'Error: unable to STDIN (' . $! .\
 ')';\n		} else { # File.\n			open( $INFILE, '<', \
$filename )\n			  or die 'Error: unable to open fi\
le ' . $filename . ' (' . $! . ')';\n		}\n		while \
(<$INFILE>) {\n			my $seq = $_;\n			$seq =~ s/>$//\
;\n			if ( $seq =~ m/(\\S+)/ ) {\n				print STDERR\
 \"Submitting job for: $1\\n\"\n				  if ( $output\
Level > 0 );\n				$seq = '>' . $seq;\n				&print_d\
ebug_message( 'multi_submit_job', $seq, 11 );\n			\
	&submit_job($seq);\n				$params{'outfile'} = unde\
f if ( $jobIdForFilename == 1 );\n			}\n		}\n		clo\
se $INFILE;\n	}\n	print_debug_message( 'multi_subm\
it_job', 'End', 1 );\n}\n\n=head2 list_file_submit\
_job()\n\nSubmit multiple jobs using a file contai\
ning a list of entry identifiers as \ninput.\n\n  \
&list_file_submit_job($list_filename)\n\n=cut\n\ns\
ub list_file_submit_job {\n	print_debug_message( '\
list_file_submit_job', 'Begin', 11 );\n	my $filena\
me         = shift;\n	my $jobIdForFilename = 1;\n	\
$jobIdForFilename = 0 if ( defined( $params{'outfi\
le'} ) );\n\n	# Iterate over identifiers, submitti\
ng each job\n	my $LISTFILE;\n	if($filename eq '-')\
 { # STDIN.\n		open( $LISTFILE, '<-' )\n		  or die\
 'Error: unable to STDIN (' . $! . ')';\n	} else {\
 # File.\n		open( $LISTFILE, '<', $filename )\n		 \
 or die 'Error: unable to open file ' . $filename \
. ' (' . $! . ')';\n	}\n	while (<$LISTFILE>) {\n		\
my $line = $_;\n		chomp($line);\n		if ( $line ne '\
' ) {\n			&print_debug_message( 'list_file_submit_\
job', 'line: ' . $line, 2 );\n			if ( $line =~ m/\\
\w:\\w/ ) {    # Check this is an identifier\n				\
print STDERR \"Submitting job for: $line\\n\"\n			\
	  if ( $outputLevel > 0 );\n				&submit_job($line\
);\n			}\n			else {\n				print STDERR\n\"Warning: \
line \\\"$line\\\" is not recognised as an identif\
ier\\n\";\n			}\n		}\n		$params{'outfile'} = undef\
 if ( $jobIdForFilename == 1 );\n	}\n	close $LISTF\
ILE;\n	print_debug_message( 'list_file_submit_job'\
, 'End', 11 );\n}\n\n=head2 load_data()\n\nLoad se\
quence data from file or option specified on the c\
ommand-line.\n\n  &load_data();\n\n=cut\n\nsub loa\
d_data {\n	print_debug_message( 'load_data', 'Begi\
n', 1 );\n	my $retSeq;\n\n	# Query sequence\n	if (\
 defined( $ARGV[0] ) ) {    # Bare option\n		if ( \
-f $ARGV[0] || $ARGV[0] eq '-' ) {    # File\n			$\
retSeq = &read_file( $ARGV[0] );\n		}\n		else {   \
                                  # DB:ID or seque\
nce\n			$retSeq = $ARGV[0];\n		}\n	}\n	if ( $param\
s{'sequence'} ) {                   # Via --sequen\
ce\n		if ( -f $params{'sequence'} || $params{'sequ\
ence'} eq '-' ) {    # File\n			$retSeq = &read_fi\
le( $params{'sequence'} );\n		}\n		else {    # DB:\
ID or sequence\n			$retSeq = $params{'sequence'};\\
n		}\n	}\n	print_debug_message( 'load_data', 'End'\
, 1 );\n	return $retSeq;\n}\n\n=head2 load_params(\
)\n\nLoad job parameters from command-line options\
.\n\n  &load_params();\n\n=cut\n\nsub load_params \
{\n	print_debug_message( 'load_params', 'Begin', 1\
 );\n\n	# Database(s) to search\n	my (@dbList) = s\
plit /[ ,]/, $params{'database'};\n	$tool_params{'\
database'} = \\@dbList;\n\n	# Compatability option\
s, old command-line.\n	if(!$tool_params{'viewfilte\
r'} && $params{'echofilter'}) {\n		$tool_params{'v\
iewfilter'} = 'true';\n	}\n	if(!$tool_params{'alig\
nments'} && $params{'numal'}) {\n		$tool_params{'a\
lignments'} = $params{'numal'};\n	}\n	# TODO: set \
alignment format option to get NCBI BLAST XML.\n	i\
f($params{'appxml'}) {\n		$tool_params{'align'} = \
'';\n	}\n\n	print_debug_message( 'load_params', 'E\
nd', 1 );\n}\n\n=head2 client_poll()\n\nClient-sid\
e job polling.\n\n  &client_poll($job_id);\n\n=cut\
\n\nsub client_poll {\n	print_debug_message( 'clie\
nt_poll', 'Begin', 1 );\n	my $jobid  = shift;\n	my\
 $status = 'PENDING';\n\n	my $errorCount = 0;\n	wh\
ile ($status eq 'RUNNING'\n		|| $status eq 'PENDIN\
G'\n		|| ( $status eq 'ERROR' && $errorCount < 2 )\
 )\n	{\n		$status = rest_get_status($jobid);\n		pr\
int STDERR \"$status\\n\" if ( $outputLevel > 0 );\
\n		if ( $status eq 'ERROR' ) {\n			$errorCount++;\
\n		}\n		elsif ( $errorCount > 0 ) {\n			$errorCou\
nt--;\n		}\n		if (   $status eq 'RUNNING'\n			|| $\
status eq 'PENDING'\n			|| $status eq 'ERROR' )\n	\
	{\n\n			# Wait before polling again.\n			sleep $c\
heckInterval;\n		}\n	}\n	print_debug_message( 'cli\
ent_poll', 'End', 1 );\n	return $status;\n}\n\n=he\
ad2 get_results()\n\nGet the results for a job ide\
ntifier.\n\n  &get_results($job_id);\n\n=cut\n\nsu\
b get_results {\n	print_debug_message( 'get_result\
s', 'Begin', 1 );\n	my $jobid = shift;\n	print_deb\
ug_message( 'get_results', 'jobid: ' . $jobid, 1 )\
;\n\n	# Verbose\n	if ( $outputLevel > 1 ) {\n		pri\
nt 'Getting results for job ', $jobid, \"\\n\";\n	\
}\n\n	# Check status, and wait if not finished\n	c\
lient_poll($jobid);\n\n	# Use JobId if output file\
 name is not defined\n	unless ( defined( $params{'\
outfile'} ) ) {\n		$params{'outfile'} = $jobid;\n	\
}\n\n	# Get list of data types\n	my (@resultTypes)\
 = rest_get_result_types($jobid);\n\n	# Get the da\
ta and write it to a file\n	if ( defined( $params{\
'outformat'} ) ) {    # Specified data type\n		my \
$selResultType;\n		foreach my $resultType (@result\
Types) {\n			if ( $resultType->{'identifier'} eq $\
params{'outformat'} ) {\n				$selResultType = $res\
ultType;\n			}\n		}\n		if ( defined($selResultType\
) ) {\n			my $result =\n			  rest_get_result( $job\
id, $selResultType->{'identifier'} );\n			if ( $pa\
rams{'outfile'} eq '-' ) {\n				write_file( $param\
s{'outfile'}, $result );\n			}\n			else {\n				wri\
te_file(\n					$params{'outfile'} . '.'\n					  . \
$selResultType->{'identifier'} . '.'\n					  . $se\
lResultType->{'fileSuffix'},\n					$result\n				);\
\n			}\n		}\n		else {\n			die 'Error: unknown resu\
lt format \"' . $params{'outformat'} . '\"';\n		}\\
n	}\n	else {    # Data types available\n		      # \
Write a file for each output type\n		for my $resul\
tType (@resultTypes) {\n			if ( $outputLevel > 1 )\
 {\n				print STDERR 'Getting ', $resultType->{'id\
entifier'}, \"\\n\";\n			}\n			my $result = rest_g\
et_result( $jobid, $resultType->{'identifier'} );\\
n			if ( $params{'outfile'} eq '-' ) {\n				write_\
file( $params{'outfile'}, $result );\n			}\n			els\
e {\n				write_file(\n					$params{'outfile'} . '.\
'\n					  . $resultType->{'identifier'} . '.'\n			\
		  . $resultType->{'fileSuffix'},\n					$result\n\
				);\n			}\n		}\n	}\n	print_debug_message( 'get_\
results', 'End', 1 );\n}\n\n=head2 read_file()\n\n\
Read a file into a scalar. The special filename '-\
' can be used to read from \nstandard input (STDIN\
).\n\n  my $data = &read_file($filename);\n\n=cut\\
n\nsub read_file {\n	print_debug_message( 'read_fi\
le', 'Begin', 1 );\n	my $filename = shift;\n	print\
_debug_message( 'read_file', 'filename: ' . $filen\
ame, 2 );\n	my ( $content, $buffer );\n	if ( $file\
name eq '-' ) {\n		while ( sysread( STDIN, $buffer\
, 1024 ) ) {\n			$content .= $buffer;\n		}\n	}\n	e\
lse {    # File\n		open( my $FILE, '<', $filename \
)\n		  or die \"Error: unable to open input file $\
filename ($!)\";\n		while ( sysread( $FILE, $buffe\
r, 1024 ) ) {\n			$content .= $buffer;\n		}\n		clo\
se($FILE);\n	}\n	print_debug_message( 'read_file',\
 'End', 1 );\n	return $content;\n}\n\n=head2 write\
_file()\n\nWrite data to a file. The special filen\
ame '-' can be used to write to \nstandard output \
(STDOUT).\n\n  &write_file($filename, $data);\n\n=\
cut\n\nsub write_file {\n	print_debug_message( 'wr\
ite_file', 'Begin', 1 );\n	my ( $filename, $data )\
 = @_;\n	print_debug_message( 'write_file', 'filen\
ame: ' . $filename, 2 );\n	if ( $outputLevel > 0 )\
 {\n		print STDERR 'Creating result file: ' . $fil\
ename . \"\\n\";\n	}\n	if ( $filename eq '-' ) {\n\
		print STDOUT $data;\n	}\n	else {\n		open( my $FI\
LE, '>', $filename )\n		  or die \"Error: unable t\
o open output file $filename ($!)\";\n		syswrite( \
$FILE, $data );\n		close($FILE);\n	}\n	print_debug\
_message( 'write_file', 'End', 1 );\n}\n\n=head2 u\
sage()\n\nPrint program usage message.\n\n  &usage\
();\n\n=cut\n\nsub usage {\n	print STDERR <<EOF\nW\
U-BLAST\n========\n   \nRapid sequence database se\
arch programs utilizing the BLAST algorithm\n    \\
n[Required]\n\n  -p, --program      : str  : BLAST\
 program to use, see --paramDetail program\n  -D, \
--database     : str  : database(s) to search, spa\
ce separated. See\n                              -\
-paramDetail database\n      --stype        : str \
 : query sequence type, see --paramDetail stype\n \
 seqFile            : file : query sequence (\"-\"\
 for STDIN, \\@filename for\n                     \
         identifier list file)\n\n[Optional]\n\n  \
-m, --matrix       : str  : scoring matrix, see --\
paramDetail matrix\n  -e, --exp          : real : \
0<E<= 1000. Statistical significance threshold \n \
                             for reporting databas\
e sequence matches.\n  -e, --viewfilter   :      :\
 display the filtered query sequence\n  -f, --filt\
er       : str  : filter the query sequence for lo\
w complexity \n                              regio\
ns, see --paramDetail filter\n  -A, --align       \
 : int  : pairwise alignment format, see --paramDe\
tail align\n  -s, --scores       : int  : number o\
f scores to be reported\n  -b, --alignments   : in\
t  : number of alignments to report\n  -S, --sensi\
tivity  : str  : sensitivity of the search, \n    \
                          see --paramDetail sensit\
ivity\n  -t, --sort	     : str  : sort order for h\
its, see --paramDetail sort\n  -T, --stats        \
: str  : statistical model, see --paramDetail stat\
s\n  -d, --strand       : str  : DNA strand to sea\
rch with,\n                              see --par\
amDetail strand\n  -c, --topcombon    : str  : con\
sistent sets of HSPs\n      --multifasta   :      \
: treat input as a set of fasta formatted sequence\
s\n\n[General]\n\n  -h, --help         :      : pr\
ints this help text\n      --async        :      :\
 forces to make an asynchronous query\n      --ema\
il        : str  : e-mail address\n      --title  \
      : str  : title for job\n      --status      \
 :      : get job status\n      --resultTypes  :  \
    : get available result types for job\n      --\
polljob      :      : poll for the status of a job\
\n      --jobid        : str  : jobid that was ret\
urned when an asynchronous job \n                 \
             was submitted.\n      --outfile      \
: str  : file name for results (default is jobid;\\
n                              \"-\" for STDOUT)\n\
      --outformat    : str  : result format to ret\
rieve\n      --params       :      : list input pa\
rameters\n      --paramDetail  : str  : display de\
tails for input parameter\n      --quiet        : \
     : decrease output\n      --verbose      :    \
  : increase output\n   \nSynchronous job:\n\n  Th\
e results/errors are returned as soon as the job i\
s finished.\n  Usage: $scriptName --email <your\\@\
email> [options...] seqFile\n  Returns: results as\
 an attachment\n\nAsynchronous job:\n\n  Use this \
if you want to retrieve the results at a later tim\
e. The results \n  are stored for up to 24 hours. \
	\n  Usage: $scriptName --async --email <your\\@em\
ail> [options...] seqFile\n  Returns: jobid\n\n  U\
se the jobid to query for the status of the job. I\
f the job is finished, \n  it also returns the res\
ults/errors.\n  Usage: $scriptName --polljob --job\
id <jobId> [--outfile string]\n  Returns: string i\
ndicating the status of the job and if applicable,\
 results \n  as an attachment.\n\nFurther informat\
ion:\n\n  http://www.ebi.ac.uk/Tools/webservices/s\
ervices/sss/wu_blast_rest\n  http://www.ebi.ac.uk/\
Tools/webservices/tutorials/perl\n\nSupport/Feedba\
ck:\n\n  http://www.ebi.ac.uk/support/\nEOF\n}\n\n\
=head1 FEEDBACK/SUPPORT\n\nPlease contact us at L<\
http://www.ebi.ac.uk/support/> if you have any \nf\
eedback, suggestions or issues with the service or\
 this client.\n\n=cut\n","\n\n\nmy $PROBTRESH = 0.\
3;# base pairs below this prob threshold will be i\
gnored\nmy $WEIGHT = 100.0; # float!!\nmy $NUCALPH\
 = \"ACGTUNRYMKSWHBVD\";\nuse vars qw($NUCALPH $WE\
IGHT);\n\nmy $myname = basename($0);\n\nuse strict\
;\nuse warnings;\n\nuse File::Basename;\nuse Getop\
t::Long;\nuse File::Glob ':glob';\nuse File::Spec;\
\nuse File::Temp qw/ tempfile tempdir /;\n\n\n\n\n\
sub tcoffeelib_header($;$)\n{\n    my ($nseq, $fd)\
 = @_;\n    if (! defined($fd)) {\n        $fd = *\
STDOUT;\n    }\n    printf $fd \"! TC_LIB_FORMAT_0\
1\\n\";\n    printf $fd \"%d\\n\", $nseq;\n}\n\n\n\
sub tcoffeelib_header_addseq($$;$)\n{\n    my ($id\
, $seq, $fd) = @_;\n    if (! defined($fd)) {\n   \
     $fd = *STDOUT;\n    }\n    printf $fd \"%s %d\
 %s\\n\", $id, length($seq), $seq;\n}\n\n\nsub tco\
ffeelib_comment($;$)\n{\n    my ($comment, $fd) = \
@_;\n    if (! defined($fd)) {\n        $fd = *STD\
OUT;\n    }\n    printf $fd \"!\" . $comment . \"\\
\n\";\n}\n\n\nsub tcoffeelib_struct($$$;$)\n{\n   \
 my ($nseq, $len, $bpm, $fd) = @_;\n\n    if (! de\
fined($fd)) {\n        $fd = *STDOUT;\n    }\n\n  \
  # output basepair indices with fixed weight\n   \
 printf $fd \"#%d %d\\n\", $nseq, $nseq;\n    # ou\
tput basepairs (only once) and with unit-offset\n \
   for (my $i=0; $i<$len; $i++) {\n        for (my\
 $j=$i+1; $j<$len; $j++) {\n            if (! defi\
ned($bpm->[$i][$j])) {\n                print STDE\
RR \"ERROR: \\$bpm->[$i][$j] undefined\\n\";\n    \
        }\n            if ($bpm->[$i][$j]>0) {\n  \
              print $fd $i+1;\n                pri\
nt $fd \" \";\n                print $fd $j+1;\n  \
              print $fd \" \" . $bpm->[$i][$j] . \\
"\\n\";\n            }\n        }\n    }\n}\n\n\ns\
ub tcoffeelib_footer(;$)\n{\n    my ($fd) = @_;\n \
   if (! defined($fd)) {\n        $fd = *STDOUT;\n\
    }\n    print $fd \"! SEQ_1_TO_N\\n\";\n}\n\n\n\
    \nsub plfold($$$)\n{    \n    my ($id, $seq, $\
probtresh) = @_;\n    my (@struct);# return\n    m\
y ($templ, $fhtmp, $fnametmp, $cmd, $ctr, $window_\
size);\n    our $ntemp++;\n    \n    $templ = $myn\
ame . \".pid-\" . $$ .$ntemp .\".XXXXXX\";\n    ($\
fhtmp, $fnametmp) = tempfile($templ, UNLINK => 1);\
 \n    print $fhtmp \">$id\\n$seq\\n\";\n\n    # -\
-- init basepair array\n    #\n    for (my $i=0; $\
i<length($seq); $i++) {\n        for (my $j=$i+1; \
$j<length($seq); $j++) {\n            $struct[$i][\
$j]=0;\n        }\n    }\n\n\n    # --- call rnapl\
fold and drop a readme\n    #\n    $window_size=(l\
ength($seq)<70)?length($seq):70;\n    $cmd = \"RNA\
plfold -W $window_size < $fnametmp >/dev/null\";\n\
    system($cmd);\n    \n    if ($? != 0) {\n     \
   printf STDERR \"ERROR: RNAplfold ($cmd) exited \
with error status %d\\n\", $? >> 8;\n        retur\
n;\n    }\n    #unlink($fnametmp);\n    my $fps = \
sprintf(\"%s_dp.ps\", $id); # check long name\n   \
 \n    if (! -s $fps) {\n      {\n\n	$fps = sprint\
f(\"%s_dp.ps\", substr($id,0,12)); # check short n\
ame\n 	if (! -s $fps)\n	  {\n	    die(\"couldn't f\
ind expected file $fps\\n\");\n	    return;\n	  }\\
n      }\n    }\n\n    \n    # --- read base pairs\
 from created postscript\n    #\n    open(FH, $fps\
);\n    while (my $line = <FH>) {\n        my ($nt\
i, $ntj, $prob);\n        chomp($line);        \n \
       # line: bp bp sqrt-prob ubox\n        my @m\
atch = ($line =~ m/^([0-9]+) +([0-9]+) +([0-9\\.]+\
) +ubox$/);\n        if (scalar(@match)) {\n      \
      $nti=$1;\n            $ntj=$2;\n            \
$prob=$3*$3;# prob stored as square root\n\n      \
      if ($prob>$probtresh) {\n                #pr\
intf STDERR \"\\$struct[$nti][$ntj] sqrtprob=$3 pr\
ob=$prob > $probtresh\\n\";\n                $stru\
ct[$nti-1][$ntj-1] = $WEIGHT\n            }\n     \
       # store with zero-offset\n        }\n    }\\
n    close(FH);\n\n    # remove or gzi postscript\\
n    #\n    unlink($fps);\n    #\n    # or gzip\n \
   #$cmd = \"gzip -qf $fps\";\n    #system($cmd);\\
n    #if ($? != 0) {\n    #    printf STDERR \"ERR\
OR: gzip ($cmd) exited with error status %d\\n\", \
$? >> 8;\n    #}\n\n    return \\@struct;\n}\n\n\n\
\n\n\nsub rnaseqfmt($)\n{\n    my ($seq) = @_;\n  \
  # remove gaps\n    $seq =~ s/-//g;\n    # upperc\
ase RNA\n    $seq = uc($seq);\n    # T -> U\n    $\
seq =~ s/T/U/g;\n    # check for invalid charaters\
\n    $_ = $seq;\n    s/[^$NUCALPH]//g;\n    retur\
n $_;\n}\n\n\n\n\nsub usage(;$)\n{    \n    my ($e\
rrmsg) = @_;\n    if ($errmsg) {\n        print ST\
DERR \"ERROR: $errmsg\\n\";\n    }\n    print STDE\
RR << \"EOF\";\n$myname:\n Creates a T-Coffee RNA \
structure library from RNAplfold prediction.\n See\
 FIXME:citation\nUsage:\n $myname -in seq_file -ou\
t tcoffee_lib\nEOF\n    exit(1);\n}\n\nsub read_fa\
sta_seq \n  {\n    my $f=$_[0];\n    my %hseq;\n  \
  my (@seq, @com, @name);\n    my ($a, $s,$nseq);\\
n\n    open (F, $f);\n    while (<F>)\n      {\n	$\
s.=$_;\n      }\n    close (F);\n\n    \n    @name\
=($s=~/>(\\S*).*\\n[^>]*/g);\n    \n    @seq =($s=\
~/>.*.*\\n([^>]*)/g);\n    @com =($s=~/>(\\S*)(.*)\
\\n([^>]*)/g);\n\n\n    $nseq=$#name+1;\n  \n    f\
or ($a=0; $a<$nseq; $a++)\n      {\n	my $n=$name[$\
a];\n	my $s;\n	$hseq{$n}{name}=$n;\n	$s=$seq[$a];$\
s=~s/\\s//g;\n	\n	$hseq{$n}{seq}=$s;\n	$hseq{$n}{c\
om}=$com[$a];\n      }\n    return %hseq;\n  }\n\n\
\n\n\n\n\n\nmy $fmsq = \"\";\nmy $flib = \"\";\nmy\
 %OPTS;\nmy %seq;\nmy ($id, $nseq, $i);\nmy @nl;\n\
\nGetOptions(\"in=s\" => \\$fmsq, \"out=s\" => \\$\
flib);\n\nif (! -s $fmsq) {\n    usage(\"empty or \
non-existant file \\\"$fmsq\\\"\")\n}\nif (length(\
$flib)==0) {\n    usage(\"empty out-filename\")\n}\
\n\n\n\n\n\n\n%seq=read_fasta_seq($fmsq);\n\n\n@nl\
=keys(%seq);\n\n$nseq=$#nl+1;\nopen FD_LIB, \">$fl\
ib\" or die \"can't open $flib!\";\ntcoffeelib_hea\
der($nseq, *FD_LIB);\nforeach $id (keys (%seq))\n \
 {\n    my ($seq, $fmtseq);\n    \n    $seq = $seq\
{$id}{seq};\n    \n    $fmtseq = rnaseqfmt($seq);#\
 check here, formatting for folding important late\
r\n    if (length($seq)!=length($fmtseq)) {\n     \
   print STDERR \"ERROR: invalid sequence $id is n\
ot an RNA sequence. read seq is: $seq\\n\";\n     \
   exit\n      }\n   \n    tcoffeelib_header_addse\
q($id, uc($seq), *FD_LIB);\n  }\ntcoffeelib_commen\
t(\"generated by $myname on \" . localtime(), *FD_\
LIB);\n\n\n\n$i=0;\nforeach $id (keys (%seq))\n  {\
\n    my ($cleanid, $seq, $bpm);\n    $seq=$seq{$i\
d}{seq};\n    $cleanid = $id;\n    $cleanid =~ s,[\
/ ],_,g;# needed for rnaplfold\n    $seq = rnaseqf\
mt($seq);\n    \n    $bpm = plfold($cleanid, rnase\
qfmt($seq), $PROBTRESH);       \n    \n    tcoffee\
lib_struct($i+1, length($seq), $bpm, *FD_LIB);\n  \
  $i++;\n}\n\n\ntcoffeelib_footer(*FD_LIB);\nclose\
 FD_LIB;\nexit (0);\n\n","\n\n\n\n\n$cmd=join ' ',\
 @ARGV;\nif ($cmd=~/-infile=(\\S+)/){ $seqfile=$1;\
}\nif ($cmd=~/-outfile=(\\S+)/){ $libfile=$1;}\n\n\
\n\n%s=read_fasta_seq ($seqfile);\n\nopen (F, \">$\
libfile\");\nforeach $name (keys (%s))\n  {\n    m\
y $tclib=\"$name.RNAplfold_tclib\";\n    print (F \
\">$name _F_ $tclib\\n\");\n    seq2RNAplfold2tcli\
b ($name, $s{$name}{seq}, $tclib);\n  }\nclose (F)\
;\nexit (EXIT_SUCCESS);\n\nsub seq2RNAplfold2tclib\
\n  {\n    my ($name, $seq, $tclib)=@_;\n    my ($\
tmp);\n    $n++;\n    $tmp=\"tmp4seq2RNAplfold_tcl\
ib.$$.$n.pep\";\n    open (RF, \">$tmp\");\n    pr\
int (RF \">$name\\n$seq\\n\");\n    close (RF);\n \
   \n    system \"t_coffee -other_pg RNAplfold2tcl\
ib.pl -in=$tmp -out=$tclib\";\n    \n    unlink ($\
tmp);\n    return $tclib;\n  }\n    \n    \nsub re\
ad_fasta_seq \n  {\n    my $f=@_[0];\n    my %hseq\
;\n    my (@seq, @com, @name);\n    my ($a, $s,$ns\
eq);\n\n    open (F, $f);\n    while (<F>)\n      \
{\n	$s.=$_;\n      }\n    close (F);\n\n    \n    \
@name=($s=~/>(\\S*).*\\n[^>]*/g);\n    \n    @seq \
=($s=~/>.*.*\\n([^>]*)/g);\n    @com =($s=~/>\\S*(\
.*)\\n([^>]*)/g);\n\n    \n    $nseq=$#name+1;\n  \
  \n    for ($a=0; $a<$nseq; $a++)\n      {\n	my $\
n=$name[$a];\n	$hseq{$n}{name}=$n;\n	$hseq{$n}{seq\
}=$seq[$a];\n	$hseq{$n}{com}=$com[$a];\n      }\n \
   return %hseq;\n  }\n","use Getopt::Long;\nuse F\
ile::Path;\nuse Env;\nuse FileHandle;\nuse Cwd;\nu\
se Sys::Hostname;\nour $PIDCHILD;\nour $ERROR_DONE\
;\nour @TMPFILE_LIST;\nour $EXIT_FAILURE=1;\nour $\
EXIT_SUCCESS=0;\n\nour $REFDIR=getcwd;\nour $EXIT_\
SUCCESS=0;\nour $EXIT_FAILURE=1;\n\nour $PROGRAM=\\
"tc_generic_method.pl\";\nour $CL=$PROGRAM;\n\nour\
 $CLEAN_EXIT_STARTED;\nour $debug_lock=$ENV{\"DEBU\
G_LOCK\"};\nour $LOCKDIR=$ENV{\"LOCKDIR_4_TCOFFEE\\
"};\nif (!$LOCKDIR){$LOCKDIR=getcwd();}\nour $ERRO\
RDIR=$ENV{\"ERRORDIR_4_TCOFFEE\"};\nour $ERRORFILE\
=$ENV{\"ERRORFILE_4_TCOFFEE\"};\n&set_lock ($$);\n\
if (isshellpid(getppid())){lock4tc(getppid(), \"LL\
OCK\", \"LSET\", \"$$\\n\");}\n      \nour $print;\
\nmy ($fmsq1, $fmsq2, $output, $outfile, $arch, $p\
sv, $hmmtop_home, $trim, $cov, $sample, $mode, $go\
r_home, $gor_seq, $gor_obs);\n\nGetOptions(\"-in=s\
\" => \\$fmsq1,\"-output=s\" =>\\$output ,\"-out=s\
\" => \\$outfile, \"-arch=s\" => \\$arch,\"-psv=s\\
" => \\$psv, \"-hmmtop_home=s\", \\$hmmtop_home,\"\
-trim=s\" =>\\$trim ,\"-print=s\" =>\\$print,\"-co\
v=s\" =>\\$cov , \"-sample=s\" =>\\$sample, \"-mod\
e=s\" =>\\$mode, \"-gor_home=s\"=>\\$gor_home, \"-\
gor_seq=s\"=>\\$gor_seq,\"-gor_obs=s\"=>\\$gor_obs\
);\n\n\nif (!$mode){$mode = \"hmmtop\"}\nelsif ($m\
ode eq \"hmmtop\"){;}\nelsif ($mode eq \"gor\"){;}\
\nelse {myexit(flush_error (\"-mode=$mode is unkno\
wn\"));}\n\n\nour $HOME=$ENV{\"HOME\"};\nour $MCOF\
FEE=($ENV{\"MCOFFEE_4_TCOFFEE\"})?$ENV{\"MCOFFEE_4\
_TCOFFEE\"}:\"$HOME/.t_coffee/mcoffee\";\n\nif ($m\
ode eq \"hmmtop\")\n  {\n    \n    check_configura\
tion (\"hmmtop\");\n    if (-e $arch){$ENV{'HMMTOP\
_ARCH'}=$arch;}\n    elsif (-e $ENV{HMMTOP_ARCH}){\
$arch=$ENV{HMMTOP_ARCH};}\n    elsif (-e \"$MCOFFE\
E/hmmtop.arch\"){$arch=$ENV{'HMMTOP_ARCH'}=\"$MCOF\
FEE/hmmtop.arch\";}\n    elsif (-e \"$hmmtop_home/\
hmmtop.arch\"){$arch=$ENV{'HMMTOP_ARCH'}=\"$hmmtop\
_home/hmmtop.arch\";}\n    else {myexit(flush_erro\
r ( \"Could not find ARCH file for hmmtop\"));}\n \
   \n    \n    if (-e $psv){$ENV{'HMMTOP_PSV'}=$ps\
v;}\n    elsif (-e $ENV{HMMTOP_PSV}){$psv=$ENV{HMM\
TOP_PSV};}\n    elsif (-e \"$MCOFFEE/hmmtop.psv\")\
{$psv=$ENV{'HMMTOP_PSV'}=\"$MCOFFEE/hmmtop.psv\";}\
\n    elsif (-e \"$hmmtop_home/hmmtop.psv\"){$psv=\
$ENV{'HMMTOP_PSV'}=\"$hmmtop_home/hmmtop.psv\";}\n\
    else {myexit(flush_error ( \"Could not find PS\
V file for hmmtop\"));}\n\n  }\nelsif ($mode eq \"\
gor\")\n  {\n    our $GOR_SEQ;\n    our $GOR_OBS;\\
n    \n    check_configuration (\"gorIV\");\n    i\
f (-e $gor_seq){$GOR_SEQ=$gor_seq;}\n    elsif (-e\
 $ENV{GOR_SEQ}){$GOR_SEQ=$ENV{GOR_SEQ};}\n    elsi\
f (-e \"$MCOFFEE/New_KS.267.seq\"){$GOR_SEQ=\"$MCO\
FFEE/New_KS.267.seq\";}\n    elsif (-e \"$gor_home\
/New_KS.267.seq\"){$GOR_SEQ=\"$gor_home/New_KS.267\
.seq\";}\n    else {myexit(flush_error ( \"Could n\
ot find SEQ file for gor\"));}\n\n    if (-e $gor_\
obs){$GOR_OBS=$gor_obs;}\n    elsif (-e $ENV{GOR_O\
BS}){$GOR_OBS=$ENV{GOR_OBS};}\n    elsif (-e \"$MC\
OFFEE/New_KS.267.obs\"){$GOR_OBS=\"$MCOFFEE/New_KS\
.267.obs\";}\n    elsif (-e \"$gor_home/New_KS.267\
.obs\"){$GOR_OBS=\"$gor_home/New_KS.267.obs\";}\n \
   else {myexit(flush_error ( \"Could not find OBS\
 file for gor\"));}\n  }\n\n\nif ( ! -e $fmsq1){my\
exit(flush_error (\"Could Not Read Input file $fms\
q1\"));}\n\n\nmy $fmsq2=vtmpnam();\nmy $fmsq3=vtmp\
nam();\nmy $tmpfile=vtmpnam();\nmy $predfile=vtmpn\
am();\n\nif ($trim){$trim_action=\" +trim _aln_%%$\
trim\\_K1 \";}\nif ($cov) {$cov_action= \" +sim_fi\
lter _aln_c$cov \";}\n&safe_system(\"t_coffee -oth\
er_pg seq_reformat -in $fmsq1 -action +convert 'BO\
UJXZ-' $cov_action $trim_action -output fasta_aln \
-out $fmsq2\");\nmy (%pred, %seq, %predA);\n\n\n%s\
eq=read_fasta_seq($fmsq2);\n%seq=fasta2sample(\\%s\
eq, $sample);\n\nif (1==2 &&$mode eq \"hmmtop\" &&\
 $output eq \"cons\")\n  {\n    fasta2hmmtop_cons(\
$outfile,\\%seq);\n  }\nelse\n  {\n   \n    %pred=\
fasta2pred(\\%seq, $mode);\n    %predA=pred2aln (\\
\%pred, \\%seq);\n    \n    \n    if (!$output || \
$output eq \"prediction\"){output_fasta_seq (\\%pr\
edA, $outfile);}\n    elsif ($output eq \"color_ht\
ml\"){pred2color (\\%pred,\\%seq, $outfile);}\n   \
 elsif ($output eq \"cons\"){pred2cons($outfile,\\\
%predA);}\n    else {flush_error (\"$output is an \
unknown output mode\");}\n  }\n\nsub fasta2sample\\
n  {\n    my $SR=shift;\n    my $it=shift;\n    my\
 %S=%$SR;\n    \n    my $seq=index2seq_name (\\%S,\
 1);\n    my $l=length($S{$seq}{seq});\n    my @sl\
=keys(%S);\n    my $nseq=$#sl+1;\n    my $index=$n\
seq;\n  \n    if (!$sample) {return %S;}\n    for \
(my $a=0; $a<$it; $a++)\n      {\n	my $newseq=\"\"\
;\n	my $nname=\"$seq\\_sampled_$index\";\n	for (my\
 $p=0; $p<$l; $p++)\n	  {\n	    my $i=int(rand($ns\
eq));\n	    \n	    my $name = $sl[$i];\n	    my $s\
eq=$S{$name}{seq};\n	    my $r=substr ($seq, $p, 1\
);\n	    $newseq.=$r;\n	  }\n	$S{$nname}{name}=$nn\
ame;\n	$S{$nname}{seq}=$newseq;\n	$S{$nname}{com}=\
\"sampled\";\n	$S{$nname}{index}=++$index;\n      \
}\n    return %S;\n  }\n	      \nsub fasta2pred\n \
 {\n    my $s=shift;\n    my $mode=shift;\n\n    i\
f ( $mode eq \"hmmtop\"){return fasta2hmmtop_pred(\
$s);}\n    elsif ($mode eq \"gor\"){return fasta2g\
or_pred ($s);}\n  }\nsub fasta2hmmtop_cons\n  {\n \
   my $outfile=shift;\n    my $SR=shift;\n    \n  \
  my $o = new FileHandle;\n    my $i = new FileHan\
dle;\n    my $tmp_in =vtmpnam();\n    my $tmp_out=\
vtmpnam();\n    my %seq=%$SR;\n    my %pred;\n    \
my $N=keys(%seq);\n    \n    output_fasta_seq (\\%\
seq,$tmp_in, \"seq\");\n    `hmmtop -pi=mpred -if=\
$tmp_in -sf=FAS -pl 2>/dev/null >$tmp_out`;\n    o\
pen ($o, \">$outfile\");\n    open ($i, \"$tmp_out\
\");\n    while (<$i>)\n      {\n	my $l=$_;\n	if (\
($l=~/>HP\\:\\s+(\\d+)\\s+(.*)/)){my $line=\">$2 N\
SEQ: $N\\n\";print $o \"$line\";}\n	elsif ( ($l=~/\
.*pred(.*)/))  {my $line=\"$1\\n\";print $o \"$lin\
e\";}\n      }\n    close ($o);\n    close ($i);\n\
    return read_fasta_seq($tmp);\n  }\nsub fasta2h\
mmtop_pred\n  {\n    my $SR=shift;\n    my $o = ne\
w FileHandle;\n    my $i = new FileHandle;\n    my\
 $tmp    =vtmpnam();\n    my $tmp_in =vtmpnam();\n\
    my $tmp_out=vtmpnam();\n    my %seq=%$SR;\n   \
 my %pred;\n    \n\n    output_fasta_seq (\\%seq,$\
tmp_in, \"seq\");\n\n    \n    `hmmtop -if=$tmp_in\
 -sf=FAS -pl 2>/dev/null >$tmp_out`;\n    \n\n    \
\n    \n    open ($o, \">$tmp\");\n    open ($i, \\
"$tmp_out\");\n    while (<$i>)\n      {\n	my $l=$\
_;\n	if (($l=~/>HP\\:\\s+(\\d+)\\s+(.*)/)){my $lin\
e=\">$2\\n\";print $o \"$line\";}\n	elsif ( ($l=~/\
.*pred(.*)/))  {my $line=\"$1\\n\";print $o \"$lin\
e\";}\n      }\n    close ($o);\n    close ($i);\n\
    return read_fasta_seq($tmp);\n  }\n    \n	\n	\\
n	    \n	\n	\n\n	\nsub fasta2gor_pred\n  {\n    my\
 $SR=shift;\n    my $o = new FileHandle;\n    my $\
i = new FileHandle;\n    my $tmp    =vtmpnam();\n \
   my $tmp_in =vtmpnam();\n    my $tmp_out=vtmpnam\
();\n    my %seq=%$SR;\n    my %pred;\n    \n\n   \
 output_fasta_seq (\\%seq,$tmp_in, \"seq\");\n    \
`gorIV -prd $tmp_in -seq $GOR_SEQ -obs $GOR_OBS >$\
tmp_out`;\n    open ($o, \">$tmp\");\n    open ($i\
, \"$tmp_out\");\n    while (<$i>)\n      {\n	my $\
l=$_;\n\n	\n	if ( $l=~/>/){print $o \"$l\";}\n	els\
if ( $l=~/Predicted Sec. Struct./){$l=~s/Predicted\
 Sec. Struct\\.//;print $o \"$l\";}\n      }\n    \
close ($o);\n    close ($i);\n    return read_fast\
a_seq($tmp);\n  }\n			\n			     \nsub index2seq_na\
me\n  {\n    \n    my $SR=shift;\n    my $index=sh\
ift;\n    \n    \n    my %S=%$SR;\n    \n    forea\
ch my $s (%S)\n      {\n	if ( $S{$s}{index}==$inde\
x){return $s;}\n      }\n    return \"\";\n  }\n\n\
sub pred2cons\n  {\n    my $outfile=shift;\n    my\
 $predR=shift;\n    my $seq=shift;\n    my %P=%$pr\
edR;\n    my %C;\n    my ($s,@r,$nseq);\n    my $f\
= new FileHandle;\n\n    open ($f, \">$outfile\");\
\n\n    if (!$seq){$seq=index2seq_name(\\%P,1);}\n\
    foreach my $s (keys(%P))\n      {\n	$nseq++;\n\
	$string= $P{$s}{seq};\n	$string = uc $string;\n	m\
y @r=split (//,$string);\n	for (my $a=0; $a<=$#r; \
$a++)\n	  {\n	    if (($r[$a]=~/[OHICE]/)){$C{$a}{\
$r[$a]}++;}\n	  }\n      }\n    @l=keys(%C);\n    \
\n    \n    $s=$P{$seq}{seq};\n    print $f \">$se\
q pred based on $nseq\\n\";\n    @r=split (//,$s);\
\n    \n    for (my $x=0; $x<=$#r; $x++)\n      {\\
n	if ($r[$x] ne \"-\")\n	  {\n	    my $h=$C{$x}{H}\
;\n	    my $i=$C{$x}{I};\n	    my $o=$C{$x}{O};\n	\
    my $c=$C{$x}{C};\n	    my $e=$C{$x}{E};\n	    \
my $l=$i+$o;\n	    \n	    if ($h>=$i && $h>=$o && \
$h>=$c && $h>=$e){$r[$x]='H';}\n	    elsif ($i>=$o\
 && $i>=$c && $i>=$e){$r[$x]='I';}\n	    elsif ($o\
>=$c && $o>=$e){$r[$x]='O';}\n	    elsif ($c>=$e){\
$r[$x]='C';}\n	    else {$r[$x]='E';}\n	  }\n     \
 }\n    $j=join ('', @r);\n    print $f \"$j\\n\";\
\n    close ($f);\n    return $j;\n  }\n\nsub pred\
2aln\n  {\n    my $PR=shift;\n    my $AR=shift;\n \
   \n    my $f=new FileHandle;\n    my %P=%$PR;\n \
   my %A=%$AR;\n    my %PA;\n    my $tmp=vtmpnam()\
;\n    my $f= new FileHandle;\n    \n    open ($f,\
 \">$tmp\");\n    foreach my $s (sort{$A{$a}{index\
}<=>$A{$b}{index}}(keys (%A)))\n      {\n	my (@lis\
t, $seq, @plist, @pseq, $L, $PL, $c, $w);\n	my $se\
q;\n	my $seq=$A{$s}{seq};\n	my $pred=$P{$s}{seq};\\
n	$seq=pred2alnS($P{$s}{seq},$A{$s}{seq});\n	print\
 $f \">$s\\n$seq\\n\";\n      }\n    close ($f);\n\
    return read_fasta_seq ($tmp);\n  }\nsub pred2a\
lnS\n  {\n    my $pred=shift;\n    my $aln= shift;\
\n    my ($j,$a,$b);\n    my @P=split (//, $pred);\
\n    my @A=split (//, $aln);\n    for ($a=$b=0;$a\
<=$#A; $a++)\n      {\n	if ($A[$a] ne \"-\"){$A[$a\
]=$P[$b++];}\n      }\n    if ($b!= ($#P+1)){add_w\
arning (\"Could not thread sequence: $b $#P\");}\n\
    \n    $j= join ('', @A);\n    return $j;\n  }\\
nsub pred2color\n  {\n    my $predP=shift;\n    my\
 $alnP=shift;\n    my $out=shift;\n    my $F=new F\
ileHandle;\n    my $struc=vtmpnam();\n    my $aln=\
vtmpnam();\n    \n\n    output_fasta_seq ($alnP, $\
aln);\n    my %p=%$predP;\n    \n    open ($F, \">\
$struc\");\n    \n    \n    foreach my $s (keys(%p\
))\n      {\n	\n	print $F \">$s\\n\";\n	my $s=uc($\
p{$s}{seq});\n	\n	$s=~s/[Oo]/0/g;\n	$s=~s/[Ee]/0/g\
;\n	\n	$s=~s/[Ii]/5/g;\n	$s=~s/[Cc]/5/g;\n	\n	$s=~\
s/[Hh]/9/g;\n	\n	print $F \"$s\\n\";\n      }\n   \
 close ($F);\n    \n    \n    \n    safe_system ( \
\"t_coffee -other_pg seq_reformat -in $aln -struc_\
in $struc -struc_in_f number_fasta -output color_h\
tml -out $out\");\n    return;\n  }\n	  \n    \nsu\
b display_fasta_seq\n  {\n    my $SR=shift;\n    m\
y %S=%$SR;\n    \n    foreach my $s (sort{$S{$a}{i\
ndex}<=>$S{$b}{index}}(keys (%S)))\n      {\n	prin\
t STDERR \">$s\\n$S{$s}{seq}\\n\";\n      }\n    c\
lose ($f);\n  }\nsub output_fasta_seq\n  {\n    my\
 $SR=shift;\n    my $outfile=shift;\n    my $mode \
=shift;\n    my $f= new FileHandle;\n    my %S=%$S\
R;\n    \n    \n    open ($f, \">$outfile\");\n   \
 foreach my $s (sort{$S{$a}{index}<=>$S{$b}{index}\
}(keys (%S)))\n      {\n	my $seq=$S{$s}{seq};\n	if\
 ( $mode eq \"seq\"){$seq=~s/\\-//g;}\n	print $f \\
">$s\\n$seq\\n\";\n      }\n    close ($f);\n  }\n\
      \nsub read_fasta_seq \n  {\n    my $f=$_[0];\
\n    my %hseq;\n    my (@seq, @com, @name);\n    \
my ($a, $s,$nseq);\n    my $index;\n    open (F, $\
f);\n    while (<F>)\n      {\n	$s.=$_;\n      }\n\
    close (F);\n\n    \n    @name=($s=~/>(\\S*).*\\
\n[^>]*/g);\n    \n    @seq =($s=~/>.*.*\\n([^>]*)\
/g);\n    @com =($s=~/>.*(.*)\\n([^>]*)/g);\n\n\n \
   $nseq=$#name+1;\n    \n  \n    for ($a=0; $a<$n\
seq; $a++)\n      {\n	my $n=$name[$a];\n	my $s;\n	\
$hseq{$n}{name}=$n;\n	$s=$seq[$a];$s=~s/\\s//g;\n	\
$hseq{$n}{index}=++$index;\n	$hseq{$n}{seq}=$s;\n	\
$hseq{$n}{com}=$com[$a];\n      }\n    return %hse\
q;\n  }\n\n\nsub file2head\n      {\n	my $file = s\
hift;\n	my $size = shift;\n	my $f= new FileHandle;\
\n	my $line;\n	open ($f,$file);\n	read ($f,$line, \
$size);\n	close ($f);\n	return $line;\n      }\nsu\
b file2tail\n      {\n	my $file = shift;\n	my $siz\
e = shift;\n	my $f= new FileHandle;\n	my $line;\n	\
\n	open ($f,$file);\n	seek ($f,$size*-1, 2);\n	rea\
d ($f,$line, $size);\n	close ($f);\n	return $line;\
\n      }\n\n\nsub vtmpnam\n      {\n	my $r=rand(1\
00000);\n	my $f=\"file.$r.$$\";\n	while (-e $f)\n	\
  {\n	    $f=vtmpnam();\n	  }\n	push (@TMPFILE_LIS\
T, $f);\n	return $f;\n      }\n\nsub myexit\n  {\n\
    my $code=@_[0];\n    if ($CLEAN_EXIT_STARTED==\
1){return;}\n    else {$CLEAN_EXIT_STARTED=1;}\n  \
  ### ONLY BARE EXIT\n    exit ($code);\n  }\nsub \
set_error_lock\n    {\n      my $name = shift;\n  \
    my $pid=$$;\n\n      \n      &lock4tc ($$,\"LE\
RROR\", \"LSET\", \"$$ -- ERROR: $name $PROGRAM\\n\
\");\n      return;\n    }\nsub set_lock\n  {\n   \
 my $pid=shift;\n    my $msg= shift;\n    my $p=ge\
tppid();\n    &lock4tc ($pid,\"LLOCK\",\"LRESET\",\
\"$p$msg\\n\");\n  }\nsub unset_lock\n   {\n     \\
n    my $pid=shift;\n    &lock4tc ($pid,\"LLOCK\",\
\"LRELEASE\",\"\");\n  }\nsub shift_lock\n  {\n   \
 my $from=shift;\n    my $to=shift;\n    my $from_\
type=shift;\n    my $to_type=shift;\n    my $actio\
n=shift;\n    my $msg;\n    \n    if (!&lock4tc($f\
rom, $from_type, \"LCHECK\", \"\")){return 0;}\n  \
  $msg=&lock4tc ($from, $from_type, \"LREAD\", \"\\
");\n    &lock4tc ($from, $from_type,\"LRELEASE\",\
 $msg);\n    &lock4tc ($to, $to_type, $action, $ms\
g);\n    return;\n  }\nsub isshellpid\n  {\n    my\
 $p=shift;\n    if (!lock4tc ($p, \"LLOCK\", \"LCH\
ECK\")){return 0;}\n    else\n      {\n	my $c=lock\
4tc($p, \"LLOCK\", \"LREAD\");\n	if ( $c=~/-SHELL-\
/){return 1;}\n      }\n    return 0;\n  }\nsub is\
rootpid\n  {\n    if(lock4tc (getppid(), \"LLOCK\"\
, \"LCHECK\")){return 0;}\n    else {return 1;}\n \
 }\nsub lock4tc\n	{\n	  my ($pid,$type,$action,$va\
lue)=@_;\n	  my $fname;\n	  my $host=hostname;\n	 \
 \n	  if ($type eq \"LLOCK\"){$fname=\"$LOCKDIR/.$\
pid.$host.lock4tcoffee\";}\n	  elsif ( $type eq \"\
LERROR\"){ $fname=\"$LOCKDIR/.$pid.$host.error4tco\
ffee\";}\n	  elsif ( $type eq \"LWARNING\"){ $fnam\
e=\"$LOCKDIR/.$pid.$host.warning4tcoffee\";}\n	  \\
n	  if ($debug_lock)\n	    {\n	      print STDERR \
\"\\n\\t---lock4tc(tcg): $action => $fname =>$valu\
e (RD: $LOCKDIR)\\n\";\n	    }\n\n	  if    ($actio\
n eq \"LCHECK\") {return -e $fname;}\n	  elsif ($a\
ction eq \"LREAD\"){return file2string($fname);}\n\
	  elsif ($action eq \"LSET\") {return string2file\
 ($value, $fname, \">>\");}\n	  elsif ($action eq \
\"LRESET\") {return string2file ($value, $fname, \\
">\");}\n	  elsif ($action eq \"LRELEASE\") \n	   \
 {\n	      if ( $debug_lock)\n		{\n		  my $g=new F\
ileHandle;\n		  open ($g, \">>$fname\");\n		  prin\
t $g \"\\nDestroyed by $$\\n\";\n		  close ($g);\n\
		  safe_system (\"mv $fname $fname.old\");\n		}\n\
	      else\n		{\n		  unlink ($fname);\n		}\n	    \
}\n	  return \"\";\n	}\n	\nsub file2string\n	{\n	 \
 my $file=@_[0];\n	  my $f=new FileHandle;\n	  my \
$r;\n	  open ($f, \"$file\");\n	  while (<$f>){$r.\
=$_;}\n	  close ($f);\n	  return $r;\n	}\nsub stri\
ng2file \n    {\n    my ($s,$file,$mode)=@_;\n    \
my $f=new FileHandle;\n    \n    open ($f, \"$mode\
$file\");\n    print $f  \"$s\";\n    close ($f);\\
n  }\n\nBEGIN\n    {\n      srand;\n    \n      $S\
IG{'SIGUP'}='signal_cleanup';\n      $SIG{'SIGINT'\
}='signal_cleanup';\n      $SIG{'SIGQUIT'}='signal\
_cleanup';\n      $SIG{'SIGILL'}='signal_cleanup';\
\n      $SIG{'SIGTRAP'}='signal_cleanup';\n      $\
SIG{'SIGABRT'}='signal_cleanup';\n      $SIG{'SIGE\
MT'}='signal_cleanup';\n      $SIG{'SIGFPE'}='sign\
al_cleanup';\n      \n      $SIG{'SIGKILL'}='signa\
l_cleanup';\n      $SIG{'SIGPIPE'}='signal_cleanup\
';\n      $SIG{'SIGSTOP'}='signal_cleanup';\n     \
 $SIG{'SIGTTIN'}='signal_cleanup';\n      $SIG{'SI\
GXFSZ'}='signal_cleanup';\n      $SIG{'SIGINFO'}='\
signal_cleanup';\n      \n      $SIG{'SIGBUS'}='si\
gnal_cleanup';\n      $SIG{'SIGALRM'}='signal_clea\
nup';\n      $SIG{'SIGTSTP'}='signal_cleanup';\n  \
    $SIG{'SIGTTOU'}='signal_cleanup';\n      $SIG{\
'SIGVTALRM'}='signal_cleanup';\n      $SIG{'SIGUSR\
1'}='signal_cleanup';\n\n\n      $SIG{'SIGSEGV'}='\
signal_cleanup';\n      $SIG{'SIGTERM'}='signal_cl\
eanup';\n      $SIG{'SIGCONT'}='signal_cleanup';\n\
      $SIG{'SIGIO'}='signal_cleanup';\n      $SIG{\
'SIGPROF'}='signal_cleanup';\n      $SIG{'SIGUSR2'\
}='signal_cleanup';\n\n      $SIG{'SIGSYS'}='signa\
l_cleanup';\n      $SIG{'SIGURG'}='signal_cleanup'\
;\n      $SIG{'SIGCHLD'}='signal_cleanup';\n      \
$SIG{'SIGXCPU'}='signal_cleanup';\n      $SIG{'SIG\
WINCH'}='signal_cleanup';\n      \n      $SIG{'INT\
'}='signal_cleanup';\n      $SIG{'TERM'}='signal_c\
leanup';\n      $SIG{'KILL'}='signal_cleanup';\n  \
    $SIG{'QUIT'}='signal_cleanup';\n      \n      \
our $debug_lock=$ENV{\"DEBUG_LOCK\"};\n      \n   \
   \n      \n      \n      foreach my $a (@ARGV){$\
CL.=\" $a\";}\n      if ( $debug_lock ){print STDE\
RR \"\\n\\n\\n********** START PG: $PROGRAM ******\
*******\\n\";}\n      if ( $debug_lock ){print STD\
ERR \"\\n\\n\\n**********(tcg) LOCKDIR: $LOCKDIR $\
$ *************\\n\";}\n      if ( $debug_lock ){p\
rint STDERR \"\\n --- $$ -- $CL\\n\";}\n      \n	 \
    \n      \n      \n    }\nsub flush_error\n  {\\
n    my $msg=shift;\n    return add_error ($EXIT_F\
AILURE,$$, $$,getppid(), $msg, $CL);\n  }\nsub add\
_error \n  {\n    my $code=shift;\n    my $rpid=sh\
ift;\n    my $pid=shift;\n    my $ppid=shift;\n   \
 my $type=shift;\n    my $com=shift;\n    \n    $E\
RROR_DONE=1;\n    lock4tc ($rpid, \"LERROR\",\"LSE\
T\",\"$pid -- ERROR: $type\\n\");\n    lock4tc ($$\
, \"LERROR\",\"LSET\", \"$pid -- COM: $com\\n\");\\
n    lock4tc ($$, \"LERROR\",\"LSET\", \"$pid -- S\
TACK: $ppid -> $pid\\n\");\n   \n    return $code;\
\n  }\nsub add_warning \n  {\n    my $rpid=shift;\\
n    my $pid =shift;\n    my $command=shift;\n    \
my $msg=\"$$ -- WARNING: $command\\n\";\n    print\
 STDERR \"$msg\";\n    lock4tc ($$, \"LWARNING\", \
\"LSET\", $msg);\n  }\n\nsub signal_cleanup\n  {\n\
    print dtderr \"\\n**** $$ (tcg) was killed\\n\\
";\n    &cleanup;\n    exit ($EXIT_FAILURE);\n  }\\
nsub clean_dir\n  {\n    my $dir=@_[0];\n    if ( \
!-d $dir){return ;}\n    elsif (!($dir=~/tmp/)){re\
turn ;}#safety check 1\n    elsif (($dir=~/\\*/)){\
return ;}#safety check 2\n    else\n      {\n	`rm \
-rf $dir`;\n      }\n    return;\n  }\nsub cleanup\
\n  {\n    #print stderr \"\\n----tc: $$ Kills $PI\
DCHILD\\n\";\n    #kill (SIGTERM,$PIDCHILD);\n    \
my $p=getppid();\n    $CLEAN_EXIT_STARTED=1;\n    \
\n    \n    \n    if (&lock4tc($$,\"LERROR\", \"LC\
HECK\", \"\"))\n      {\n	my $ppid=getppid();\n	if\
 (!$ERROR_DONE) \n	  {\n	    &lock4tc($$,\"LERROR\\
", \"LSET\", \"$$ -- STACK: $p -> $$\\n\");\n	    \
&lock4tc($$,\"LERROR\", \"LSET\", \"$$ -- COM: $CL\
\\n\");\n	  }\n      }\n    my $warning=&lock4tc($\
$, \"LWARNING\", \"LREAD\", \"\");\n    my $error=\
&lock4tc($$,  \"LERROR\", \"LREAD\", \"\");\n    #\
release error and warning lock if root\n    \n    \
if (isrootpid() && ($warning || $error) )\n      {\
\n	\n	print STDERR \"**************** Summary ****\
*********\\n$error\\n$warning\\n\";\n\n	&lock4tc($\
$,\"LERROR\",\"RELEASE\",\"\");\n	&lock4tc($$,\"LW\
ARNING\",\"RELEASE\",\"\");\n      } \n    \n    \\
n    foreach my $f (@TMPFILE_LIST)\n      {\n	if (\
-e $f){unlink ($f);} \n      }\n    foreach my $d \
(@TMPDIR_LIST)\n      {\n	clean_dir ($d);\n      }\
\n    #No More Lock Release\n    #&lock4tc($$,\"LL\
OCK\",\"LRELEASE\",\"\"); #release lock \n\n    if\
 ( $debug_lock ){print STDERR \"\\n\\n\\n*********\
* END PG: $PROGRAM ($$) *************\\n\";}\n    \
if ( $debug_lock ){print STDERR \"\\n\\n\\n*******\
***(tcg) LOCKDIR: $LOCKDIR $$ *************\\n\";}\
\n  }\nEND \n  {\n    \n    &cleanup();\n  }\n   \\
n\nsub safe_system \n{\n  my $com=shift;\n  my $nt\
ry=shift;\n  my $ctry=shift;\n  my $pid;\n  my $st\
atus;\n  my $ppid=getppid();\n  if ($com eq \"\"){\
return 1;}\n  \n  \n\n  if (($pid = fork ()) < 0){\
return (-1);}\n  if ($pid == 0)\n    {\n      set_\
lock($$, \" -SHELL- $com (tcg)\");\n      exec ($c\
om);\n    }\n  else\n    {\n      lock4tc ($$, \"L\
LOCK\", \"LSET\", \"$pid\\n\");#update parent\n   \
   $PIDCHILD=$pid;\n    }\n  if ($debug_lock){prin\
tf STDERR \"\\n\\t .... safe_system (fasta_seq2hmm\
)  p: $$ c: $pid COM: $com\\n\";}\n\n  waitpid ($p\
id,WTERMSIG);\n\n  shift_lock ($pid,$$, \"LWARNING\
\",\"LWARNING\", \"LSET\");\n\n  if ($? == $EXIT_F\
AILURE || lock4tc($pid, \"LERROR\", \"LCHECK\", \"\
\"))\n    {\n      if ($ntry && $ctry <$ntry)\n	{\\
n	  add_warning ($$,$$,\"$com failed [retry: $ctry\
]\");\n	  lock4tc ($pid, \"LRELEASE\", \"LERROR\",\
 \"\");\n	  return safe_system ($com, $ntry, ++$ct\
ry);\n	}\n      elsif ($ntry == -1)\n	{\n	  if (!s\
hift_lock ($pid, $$, \"LERROR\", \"LWARNING\", \"L\
SET\"))\n	    {\n	      add_warning ($$,$$,\"$com \
failed\");\n	    }\n	  else\n	    {\n	      lock4t\
c ($pid, \"LRELEASE\", \"LERROR\", \"\");\n	    }\\
n	  return $?;}\n      else\n	{\n	  if (!shift_loc\
k ($pid,$$, \"LERROR\",\"LERROR\", \"LSET\"))\n	  \
  {\n	      myexit(add_error ($EXIT_FAILURE,$$,$pi\
d,getppid(), \"UNSPECIFIED system\", $com));\n	   \
 }\n	}\n    }\n  return $?;\n}\n\nsub check_config\
uration \n    {\n      my @l=@_;\n      my $v;\n  \
    foreach my $p (@l)\n	{\n	  \n	  if   ( $p eq \\
"EMAIL\")\n	    { \n	      if ( !($EMAIL=~/@/))\n	\
	{\n		add_warning($$,$$,\"Could Not Use EMAIL\");\\
n		myexit(add_error ($EXIT_FAILURE,$$,$$,getppid()\
,\"EMAIL\",\"$CL\"));\n	      }\n	    }\n	  elsif(\
 $p eq \"INTERNET\")\n	    {\n	      if ( !&check_\
internet_connection())\n		{\n		  myexit(add_error \
($EXIT_FAILURE,$$,$$,getppid(),\"INTERNET\",\"$CL\\
"));\n		}\n	    }\n	  elsif( $p eq \"wget\")\n	   \
 {\n	      if (!&pg_is_installed (\"wget\") && !&p\
g_is_installed (\"curl\"))\n		{\n		  myexit(add_er\
ror ($EXIT_FAILURE,$$,$$,getppid(),\"PG_NOT_INSTAL\
LED:wget\",\"$CL\"));\n		}\n	    }\n	  elsif( !(&p\
g_is_installed ($p)))\n	    {\n	      myexit(add_e\
rror ($EXIT_FAILURE,$$,$$,getppid(),\"PG_NOT_INSTA\
LLED:$p\",\"$CL\"));\n	    }\n	}\n      return 1;\\
n    }\nsub pg_is_installed\n  {\n    my @ml=@_;\n\
    my $r, $p, $m;\n    my $supported=0;\n    \n  \
  my $p=shift (@ml);\n    if ($p=~/::/)\n      {\n\
	if (safe_system (\"perl -M$p -e 1\")==$EXIT_SUCCE\
SS){return 1;}\n	else {return 0;}\n      }\n    el\
se\n      {\n	$r=`which $p 2>/dev/null`;\n	if ($r \
eq \"\"){return 0;}\n	else {return 1;}\n      }\n \
 }\n\n\n\nsub check_internet_connection\n  {\n    \
my $internet;\n    my $tmp;\n    &check_configurat\
ion ( \"wget\"); \n    \n    $tmp=&vtmpnam ();\n  \
  \n    if     (&pg_is_installed    (\"wget\")){`w\
get www.google.com -O$tmp >/dev/null 2>/dev/null`;\
}\n    elsif  (&pg_is_installed    (\"curl\")){`cu\
rl www.google.com -o$tmp >/dev/null 2>/dev/null`;}\
\n    \n    if ( !-e $tmp || -s $tmp < 10){$intern\
et=0;}\n    else {$internet=1;}\n    if (-e $tmp){\
unlink $tmp;}\n\n    return $internet;\n  }\nsub c\
heck_pg_is_installed\n  {\n    my @ml=@_;\n    my \
$r=&pg_is_installed (@ml);\n    if (!$r && $p=~/::\
/)\n      {\n	print STDERR \"\\nYou Must Install t\
he perl package $p on your system.\\nRUN:\\n\\tsud\
o perl -MCPAN -e 'install $pg'\\n\";\n      }\n   \
 elsif (!$r)\n      {\n	myexit(flush_error(\"\\nPr\
ogram $p Supported but Not Installed on your syste\
m\"));\n      }\n    else\n      {\n	return 1;\n  \
    }\n  }\n\n\n\n","\n\n\n\n\nmy $FMODEL =\"\"; \\
nmy $TMPDIR = \"/tmp\";\n\n\n\n\nmy $NUCALPH = \"A\
CGTUNRYMKSWHBVD\";\nmy $PRIMNUCALPH = \"ACGTUN\";\\
nuse vars qw($NUCALPH $PRIMNUCALPH $TMPDIR);\n\n\n\
my $errmsg;\nuse vars qw($errmsg);\n\n\n\nuse Geto\
pt::Long;\nuse Cwd;\nuse File::Basename;\nuse File\
::Temp qw/ tempfile tempdir /;\nuse File::Copy;\nu\
se File::Path;\n\n\n\nsub usage(;$)\n{\n    my ($e\
rrmsg) = @_;\n    my $myname = basename($0);\n\n  \
  if ($errmsg) {\n        print STDERR \"ERROR: $e\
rrmsg\\n\";\n    }\n\n    print STDERR << \"EOF\";\
\n    \n$myname: align two sequences by means of c\
onsan\\'s sfold\nUsage:\n $myname -i file -o file \
-d path\nOptions:\n -i|--in : pairwise input seque\
nce file\n -o|--out: output alignment\n -d|--direc\
tory containing data\n\nEOF\n}\n\nsub read_stk_aln\
 \n  {\n    my $f=$_[0];\n    my ($seq, $id);\n   \
 \n    my %hseq;\n\n    open (STK, \"$f\");\n    w\
hile (<STK>)\n      {\n	if ( /^#/ || /^\\/\\// || \
/^\\s*$/){;}\n	else\n	  {\n	    ($id,$seq)=/(\\S+)\
\\s+(\\S+)/;\n	    $hseq{$id}{'seq'}.=$seq;\n	  }\\
n      }\n    close (STK);\n    return %hseq;\n  }\
\nsub read_fasta_seq \n  {\n    my $f=$_[0];\n    \
my %hseq;\n    my (@seq, @com, @name);\n    my ($a\
, $s,$nseq);\n\n    open (F, $f);\n    while (<F>)\
\n      {\n	$s.=$_;\n      }\n    close (F);\n\n  \
  \n    @name=($s=~/>(.*).*\\n[^>]*/g);\n    \n   \
 @seq =($s=~/>.*.*\\n([^>]*)/g);\n    @com =($s=~/\
>.*(.*)\\n([^>]*)/g);\n\n    \n    $nseq=$#name+1;\
\n    \n    for ($a=0; $a<$nseq; $a++)\n      {\n	\
my $n=$name[$a];\n	$hseq{$n}{name}=$n;\n	$hseq{$n}\
{seq}=$seq[$a];\n	$hseq{$n}{com}=$com[$a];\n      \
}\n    return %hseq;\n  }\n\n\n\nsub sfold_parseou\
tput($$)\n{\n    my ($frawout, $foutfa) = @_;\n   \
 my %haln;\n    my ($fstk, $cmd, $id);\n    open F\
OUTFA, \">$foutfa\";\n    \n    $fstk = $frawout .\
 \".stk\";\n    \n    # first line of raw out cont\
ains info\n    # remaining stuff is stockholm form\
atted\n    $cmd = \"sed -e '1d' $frawout\";\n    s\
ystem(\"$cmd > $fstk\");\n    if ($? != 0) {\n    \
    $errmsg = \"command failed with exit status $?\
.\";\n        $errmsg .=  \"Command was \\\"$cmd\\\
\"\";\n        return -1;\n    }\n\n    # this giv\
es an error message. just ignore it...\n    %haln=\
read_stk_aln ( $fstk);\n    foreach $i (keys (%hal\
n))\n      {\n	my $s;\n	$s=$haln{$i}{'seq'};\n	$s \
=~ s/\\./-/g;\n	print FOUTFA \">$i\\n$s\\n\";\n   \
   }\n    close FOUTFA;\n    return 0;\n}\n\n\n\n\\
nsub sfold_wrapper($$$$)\n{\n    \n    my ($fs1, $\
fs2, $fmodel, $foutfa) = @_;\n    \n\n    my ($cmd\
, $frawout, $ferrlog, $freadme, $ftimelog, $fstk);\
\n\n    # add  basename($fmsqin) (unknown here!)\n\
    $frawout = \"sfold.log\";\n    $ferrlog = \"sf\
old.err\";\n    $ftimelog = \"sfold.time\";\n    $\
freadme =  \"sfold.README\";\n    $fstk = \"sfold.\
stk\";\n    \n    # prepare execution...\n    #\n \
   # ./tmp is essential for dswpalign\n    # other\
wise you'll get a segfault\n    mkdir \"./tmp\";\n\
    \n    $cmd = \"sfold -m $fmodel $fs1 $fs2\";\n\
    open(FREADME,\">$freadme\");\n    print FREADM\
E \"$cmd\\n\"; \n    close(FREADME);\n\n    # and \
go\n    #\n    system(\"/usr/bin/time -p -o $ftime\
log $cmd >$frawout 2>$ferrlog\");\n    if ($? != 0\
) {\n        $errmsg = \"command failed with exit \
status $?\";\n        $errmsg .= \"command was \\\\
"$cmd\\\". See \" . getcwd . \"\\n\";\n        ret\
urn -1;\n    }\n\n    return sfold_parseoutput($fr\
awout, $foutfa);\n}\n\n\n\n\n\n\n\nmy ($help, $fms\
qin, $fmsaout);\nGetOptions(\"help\"  => \\$help,\\
n           \"in=s\" => \\$fmsqin,\n           \"o\
ut=s\" => \\$fmsaout,\n	   \"data=s\" => \\$ref_di\
r);\n\n\n\nif ($help) {\n    usage();\n    exit(0)\
;\n}\nif (! defined($fmsqin)) {\n    usage('missin\
g input filename');\n    exit(1);\n}\nif (! define\
d($fmsaout)) {\n    usage('missing output filename\
');\n    exit(1);\n\n}\nif (scalar(@ARGV)) {\n    \
usage('Unknown remaining args');\n    exit(1);\n}\\
n\n$FMODEL = \"$ref_dir/mix80.mod\";\nif (! -e \"$\
FMODEL\") {\n    die(\"couldn't find sfold grammar\
 model file. Expected $FMODEL\\n\");\n}\n\n\nmy %h\
seq=read_fasta_seq ($fmsqin);\nmy $id;\n\nforeach \
$id (keys(%hseq))\n  {\n    push(@seq_array, $hseq\
{$id});\n  }\n\nif ( scalar(@seq_array) != 2 ) {\n\
    die(\"Need *exactly* two sequences as input (p\
airwise alignment!).\")\n}\n\n\n\nmy ($sec, $min, \
$hour, $mday, $mon, $year, $wday, $yday, $isdst) =\
 localtime(time);\nmy $datei = sprintf(\"%4d-%02d-\
%02d\", $year+1900, $mon+1, $mday);\nmy $templ = b\
asename($0) . \".\" . $datei . \".pid-\" . $$ . \"\
.XXXXXX\";\nmy $wd = tempdir ( $templ, DIR => $TMP\
DIR);\n\ncopy($fmsqin, \"$wd/\" . basename($fmsqin\
) . \".org\"); # for reproduction\ncopy($FMODEL, \\
"$wd\");\nmy $fmodel = basename($FMODEL);\nmy $org\
wd = getcwd;\nchdir $wd;\n\n\n\nmy @sepseqfiles;\n\
foreach $id (keys(%hseq)) {\n    my ($seq, $orgseq\
, $fname, $sout);\n    $seq=$hseq{$id}{'seq'};\n  \
  \n    $fname = basename($fmsqin) . \"_$id.fa\";\\
n    # replace funnies in file/id name (e.g. \"/\"\
 \" \" etc)\n    $fname =~ s,[/ ],_,g;\n    open (\
PF, \">$fname\");\n    print (PF \">$id\\n$seq\\n\\
");\n    close (PF);\n\n    push(@sepseqfiles, $fn\
ame);\n}\n\nmy ($f1, $f2, $fout);\n$f1 = $sepseqfi\
les[0];\n$f2 = $sepseqfiles[1];\n$fout = $wd . bas\
ename($fmsqin) . \".out.fa\";\nif (sfold_wrapper($\
f1, $f2, $fmodel, \"$fout\") != 0) {\n    printf S\
TDERR \"ERROR: See logs in $wd\\n\";\n    exit(1);\
\n} else {\n    chdir $orgwd;\n    copy($fout, $fm\
saout);\n    rmtree($wd);\n   exit(0);\n}\n","\nus\
e Env qw(HOST);\nuse Env qw(HOME);\nuse Env qw(USE\
R);\n\n\n$tmp=clean_cr ($ARGV[0]);\nopen (F, $tmp)\
;\n\nwhile ( <F>)\n  {\n    my $l=$_;\n    if ( $l\
=~/^# STOCKHOLM/){$stockholm=1;}\n    elsif ( $sto\
ckholm && $l=~/^#/)\n      {\n	$l=~/^#(\\S+)\\s+(\\
\S+)\\s+(\\S*)/g;\n	$l=\"_stockholmhasch_$1\\_stoc\
kholmspace_$2 $3\\n\";\n      }\n    $file.=$l;\n \
 }\nclose (F);\nunlink($tmp);\n$file1=$file;\n\n$f\
ile=~s/\\#/_hash_symbol_/g;\n$file=~s/\\@/_arobase\
_symbol_/g;\n\n\n$file=~s/\\n[\\.:*\\s]+\\n/\\n\\n\
/g;\n\n$file=~s/\\n[ \\t\\r\\f]+(\\b)/\\n\\1/g;\n\\
n\n$file=~s/(\\n\\S+)(\\s+)(\\S)/\\1_blank_\\3/g;\\
n\n$file=~s/[ ]//g;\n$file=~s/_blank_/ /g;\n\n\n\n\
$file =~s/\\n\\s*\\n/#/g;\n\n$file.=\"#\";\n$file \
=~s/\\n/@/g;\n\n\n\n\n@blocks=split /\\#/, $file;\\
nshift (@blocks);\n@s=split /\\@/, $blocks[0];\n$n\
seq=$#s+1;\n\n\n\n$file=join '@', @blocks;\n@lines\
=split /\\@/,$file;\n\n$c=0;\n\nforeach $l (@lines\
)\n  {\n    if (!($l=~/\\S/)){next;}\n    elsif ($\
stockholm && ($l=~/^\\/\\// || $l=~/STOCKHOLM/)){n\
ext;}#get read of STOCHOLM Terminator\n   \n    $l\
=~/(\\S+)\\s+(\\S*)/g;\n    $n=$1; $s=$2;\n    \n \
   $seq[$c].=$s;\n    $name[$c]=$n;\n    $c++;\n  \
  \n    if ( $c==$nseq){$c=0;}\n    \n  } \n\nif (\
 $c!=0)\n      {\n	print STDERR \"ERROR: $ARGV[0] \
is NOT an MSA in Clustalw format: make sure there \
is no blank line within a block [ERROR]\\n\";\n	ex\
it (EXIT_FAILURE);\n      }\n\nfor ($a=0; $a< $nse\
q; $a++)\n  {\n    $name[$a]=cleanstring ($name[$a\
]);\n    $seq[$a]=cleanstring ($seq[$a]);\n    $se\
q[$a]=breakstring($seq[$a], 60);\n    \n    $line=\
\">$name[$a]\\n$seq[$a]\\n\";\n    \n    print \"$\
line\";\n  }\nexit (EXIT_SUCCESS);\n\nsub cleanstr\
ing\n  {\n    my $s=@_[0];\n    $s=~s/_hash_symbol\
_/\\#/g;\n    $s=~s/_arobase_symbol_/\\@/g;\n    $\
s=~s/[ \\t]//g;\n    return $s;\n  }\nsub breakstr\
ing\n  {\n    my $s=@_[0];\n    my $size=@_[1];\n \
   my @list;\n    my $n,$ns, $symbol;\n    \n    @\
list=split //,$s;\n    $n=0;$ns=\"\";\n    foreach\
 $symbol (@list)\n      {\n	if ( $n==$size)\n	  {\\
n	    $ns.=\"\\n\";\n	    $n=0;\n	  }\n	$ns.=$symb\
ol;\n	$n++;\n      }\n    return $ns;\n    }\n\nsu\
b clean_cr\n  {\n    my $f=@_[0];\n    my $file;\n\
    \n    $tmp=\"f$.$$\";\n    \n    \n    open (I\
N, $f);\n    open (OUT, \">$tmp\");\n    \n    whi\
le ( <IN>)\n      {\n	$file=$_;\n	$file=~s/\\r\\n/\
\\n/g;\n	$file=~s/\\n\\r/\\n/g;\n	$file=~s/\\r\\r/\
\\n/g;\n	$file=~s/\\r/\\n/g;\n	print OUT \"$file\"\
;\n      }\n    \n    close (IN);\n    close (OUT)\
;\n    return $tmp;\n  }\n","use strict;\nuse File\
Handle;\nuse Env qw(HOST);\nuse Env qw(HOME);\nuse\
 Env qw(USER);\n\nmy $format=file2format ($ARGV[0]\
);\n\nif    ($format eq \"clustalw\"){clustalw2fas\
ta($ARGV[0]);}\nelsif ($format eq \"fasta\")   {fa\
sta2fasta($ARGV[0]);}\nelsif ($format eq \"msf\") \
  {msf2fasta($ARGV[0]);}\nelsif ($format eq \"phyl\
ip\")   {phylip2fasta($ARGV[0]);}\nelsif ($format \
eq \"nameseq\") {display_file ($ARGV[0]);}\n \nexi\
t (0);\n\nsub file2format\n  {\n    my $f=shift;\n\
    \n    my $l=file2n_lines($f,2);\n    \n    if \
( $l=~/^CLUSTAL/){return \"clustalw\";}\n    elsif\
 ($l=~/^SAGA/){return \"clustalw\";}\n    elsif ($\
l=~/^>/){return \"fasta\";}\n    elsif ($l=~/^Pile\
Up/){return \"msf\";}\n    elsif ($l=~/\\s+\\d+\\s\
+\\d+\\s/){return \"phylip\";}\n    elsif ($l=~/\\\
#NAMESEQ_01/){return \"nameseq\";}\n    else \n   \
   {\n	print STDERR \"ERROR: $f FILE is NOT a supp\
orted format [ERROR]\\n\";\n	system (\"cp $f /User\
s/cnotredame/cedric1.txt\");\n	exit (1);\n      }\\
n  }\nsub display_file\n    {\n       my $file=shi\
ft;\n       my $F= new FileHandle;\n       open ($\
F, $file);\n       while (<$F>){print \"$_\";}\n  \
     close ($F);\n     }\nsub phylip2fasta\n    {\\
n      my $file=shift;\n      my $F= new FileHandl\
e;\n      my ($seq, $name,$seq);\n      my $query_\
start=-1;\n      my $query_end=-1;\n      my $in_a\
ln=0;\n      my %list;\n      my ($first,$seq,$nam\
e, $cn, $nseq, $l,%len);\n      \n      open ($F, \
$file);\n      <$F>;\n      $l=$_;\n      $l=~/\\s\
*(\\d+)\\s*(\\d+)/;\n      $first=1;\n      $cn=0;\
\n      while (<$F>)\n	{\n	  my $l=$_;\n	  if (!($\
l=~/\\S/))\n	    {\n	      $cn=0;\n	      $first=0\
;\n	    }\n	  elsif ($first==1)\n	    {\n	      $l\
=~/\\s*(\\S+)(.*)/;\n	      my $name=$1;\n	      m\
y $seq=$2;\n	      chomp ($seq);\n	      $seq=~s/\\
\s//g;\n	      $list{$cn}{'name'}=$name;\n	      $\
list{$cn}{'seq'}.=$seq;\n	      $cn++;\n	      $ns\
eq++;\n	    }\n	  else\n	    {\n	      chomp ($l);\
\n	      $l=~s/\\s//g;\n	      $list{$cn}{'seq'}.=\
$l;\n	      $cn++;\n	    }\n	}\n      close ($F);\\
n      \n      for (my $a=0; $a<$nseq; $a++)\n	{\n\
	  print \">$list{$a}{'name'}\\n$list{$a}{'seq'}\\\
n\";\n	}\n    }\n      \nsub msf2fasta\n    {\n   \
   my $file=shift;\n      my $F= new FileHandle;\n\
      my ($seq, $name,$seq);\n      my $query_star\
t=-1;\n      my $query_end=-1;\n      my $in_aln=0\
;\n      my %list;\n      my ($seq,$name, $n, $nse\
q, $l,%len);\n      \n      open ($F, $file);\n   \
   while (<$F>)\n	{\n	  if ( /\\/\\//){$in_aln=1;}\
\n	  elsif ( $in_aln && /(\\S+)\\s+(.*)/)\n	    {\\
n	      $name=$1;\n	      $seq=$2;\n	      $seq=~s\
/\\s//g;\n	      $seq=~s/\\~/\\-/g;\n	      $seq=~\
s/\\./\\-/g;\n	      if ( $list{$n}{'name'} && $li\
st{$n}{'name'} ne $name)\n		{\n		  print \"$list{$\
n}{'name'} Vs $name\";\n		  \n		  exit (1);\n		}\n\
	      else\n		{\n		  $list{$n}{'name'}= $name;\n	\
	}\n	      \n	      $list{$n}{'seq'}=$list{$n}{'se\
q'}.$seq;\n	      \n	      $nseq=++$n;\n	      \n	\
    }\n	  else\n	    {$n=0;}\n	}\n      close ($F)\
;\n      \n      for (my $a=0; $a<$nseq; $a++)\n	{\
\n	  my $nl=length ($list{$a}{'name'});\n	  my $sl\
=length ($list{$a}{'seq'});\n	  print \">$list{$a}\
{'name'}\\n$list{$a}{'seq'}\\n\";\n	}\n    }\n    \
\nsub fasta2fasta\n    {\n      my $file=shift;\n \
     my $F= new FileHandle;\n      my ($seq, $name\
,$n,$l,%len);\n      my $started=0;\n      open ($\
F, $file);\n      while (<$F>)\n	{\n	  if ( /^>(\\\
S+)/){$n++;$seq=\"\";$name=$1;}\n	  else\n	    {\n\
	      $l=$_;\n	      chomp ($l);\n	      \n	     \
 $seq.=$l;\n	      $len{$name}=length($seq);\n	   \
 }\n	}\n      close ($F);\n      \n      open ($F,\
 $file);\n      while (<$F>)\n	{\n	  my $l=$_;\n	 \
 $l=~s/\\r[\\n]*/\\n/gm;\n	  if ( ($l=~/^>(\\S+)(.\
*)\\n/))\n	    {\n	      my $name=$1;\n	      my $\
comment=$2;\n	      my $nl=length ($name);\n	     \
 my $sl=$len{$name};\n	      if ($comment)\n		{\n	\
	  $comment=~s/^\\s+//g;\n		  my $cl=length ($comm\
ent);\n		}\n	      if (!$started){$started=1;print\
 \">$name\\n\";}\n	      else {print \"\\n>$name\\\
n\"}\n	    }\n	  else\n	    {\n	      $l=$_;\n	   \
   chomp ($l);\n	      $l=~s/\\W//g;\n	      print\
 \"$l\";\n	    }\n	}\n      print \"\\n\";\n      \
close ($F);\n    }\nsub clustalw2fasta\n  {\n    m\
y $fname=shift;\n    my ($file1, $file);\n    my (\
@blocks, @lines,@s, $n,$nseq, $c);\n    my (@name,\
 @seq);\n    my $F= new FileHandle;\n    my $stock\
holm;\n   \n    \n    open ($F, $fname);\n    \n  \
  while ( <$F>)\n      {\n	my $l=$_;\n	$l=clean_cr\
($l);\n	if ( $l=~/^# STOCKHOLM/){$stockholm=1;}\n	\
elsif ( $stockholm && $l=~/^#/)\n	  {\n	    $l=~/^\
#(\\S+)\\s+(\\S+)\\s+(\\S*)/g;\n	    $l=\"_stockho\
lmhasch_$1\\_stockholmspace_$2 $3\\n\";\n	  }\n	$f\
ile.=$l;\n      }\n    close ($F);\n        \n    \
#Protect # and @\n    $file=~s/\\#/_hash_symbol_/g\
;\n    $file=~s/\\@/_arobase_symbol_/g;\n    \n   \
 \n    #Remove annotation\n    $file=~s/\\n[\\.:*\\
\s]+\\n/\\n\\n/g;\n    \n    #Remove White spaces \
before the sequence name\n    $file=~s/\\n[ \\t\\r\
\\f]+(\\b)/\\n\\1/g;\n    \n    \n    #Remove Inte\
rnal Blanks\n    $file=~s/(\\n\\S+)(\\s+)(\\S)/\\1\
_blank_\\3/g;\n    \n    $file=~s/[ ]//g;\n    $fi\
le=~s/_blank_/ /g;\n    \n    \n    #Identify Doub\
le Blank lines\n    \n    $file =~s/\\n\\s*\\n/#/g\
;\n    \n    $file.=\"#\";\n    $file =~s/\\n/@/g;\
\n    \n    \n    \n    \n    #count nseq\n    @bl\
ocks=split /\\#/, $file;\n    shift (@blocks);\n  \
  @s=split /\\@/, $blocks[0];\n    $nseq=$#s+1;\n \
   \n    #Merge all the sequences and split every \
Nseq\n    \n    \n    $file=join '@', @blocks;\n  \
  @lines=split /\\@/,$file;\n    \n    $c=0;\n    \
\n    foreach my $l (@lines)\n      {\n	my ($n, $s\
);\n	\n	if (!($l=~/\\S/)){next;}\n	elsif ($stockho\
lm && ($l=~/^\\/\\// || $l=~/STOCKHOLM/)){next;}#g\
et read of STOCHOLM Terminator\n	\n	$l=~/(\\S+)\\s\
+(\\S*)/g;\n	$n=$1; $s=$2;\n	\n	$seq[$c].=$s;\n	$n\
ame[$c]=$n;\n	$c++;\n	\n	if ( $c==$nseq){$c=0;}\n	\
\n      } \n    \n    if ( $c!=0)\n      {\n	print\
 STDERR \"ERROR: $fname is NOT an MSA in Clustalw \
format: make sure there is no blank line within a \
block [ERROR]\\n\";\n	exit (1);\n      }\n    \n  \
  \n    for (my $a=0; $a< $nseq; $a++)\n      {\n	\
$name[$a]=cleanstring ($name[$a]);\n	$seq[$a]=clea\
nstring ($seq[$a]);\n	print \">$name[$a]\\n$seq[$a\
]\\n\";\n      }\n  }\nsub cleanstring\n    {\n   \
   my $s=@_[0];\n      $s=~s/_hash_symbol_/\\#/g;\\
n      $s=~s/_arobase_symbol_/\\@/g;\n      $s=~s/\
[ \\t]//g;\n      return $s;\n    }\n\nsub clean_c\
r\n  {\n    my $f=shift;\n    $f=~s/\\r\\n/\\n/g;\\
n    $f=~s/\\n\\r/\\n/g;\n    $f=~s/\\r\\r/\\n/g;\\
n    $f=~s/\\r/\\n/g;\n    return $f;\n  }\n\nsub \
file2n_lines\n    {\n      my $file=shift;\n      \
my $nl=shift;\n      my $ret;\n      my $F=new Fil\
eHandle;\n      my $n=0;\n      open ($F, $file);\\
n\n      while (<$F>)\n	{\n	  $ret.=$_;\n	  $n++;\\
n	  \n	  if ($n>=$n){close ($F); return $ret;}\n	}\
\n      close ($F);\n      return $ret;\n    }\n",\
"use strict;\nuse FileHandle;\nuse Env qw(HOST);\n\
use Env qw(HOME);\nuse Env qw(USER);\nmy %name;\nm\
y $nseq;\nmy $fasta;\nif ($ARGV[2] eq \"-fasta\"){\
$fasta=1;}\nmy $F= new FileHandle;\n\nopen ($F, $A\
RGV[1]);\nwhile(<$F>)\n  {\n    my $l=$_;\n    if \
($l=~/^#/){;}\n    elsif (($l=~/\\d+\\s+\\d+\\s+(\\
\S+)\\s+(\\S+)/))\n      {\n	my $n=$1;\n	$name{$1}\
++;\n      }\n  }\nclose ($F);\n\nopen ($F, $ARGV[\
0]);\nwhile(<$F>)\n  {\n    my $l=$_;\n    if ($l=\
~/^#/){;}\n    elsif ($l=~/\\d+\\s+\\d+\\s+(\\S+)\\
\s+(\\S+)/)\n      {\n	my $n=$1;\n	$name{$n}++;\n	\
if ($name{$n}==2){$nseq++;}\n      }\n  }\nclose (\
$F);\n\nif (!$fasta && $nseq>0)\n  {\n    print \"\
#NAMESEQ_01\\n\";\n    print \"# $nseq\\n\";\n  }\\
nopen ($F, $ARGV[0]);\nwhile(<$F>)\n  {\n    my $l\
=$_;\n    if ($l=~/^#/){;}\n    elsif ($l=~/.\\d+\\
\s+\\d+\\s+(\\S+)\\s+(\\S+)/)\n      {\n	my $n=$1;\
\n	my $s=$2;\n	if ($name{$n}==2)\n	  {\n	    if ($\
fasta)\n	      {\n		print \">$n\\n$s\\n\";\n	     \
 }\n	    else\n	      {\n		print \"$l\";\n	      }\
\n	  }\n      }\n  }\nclose ($F);\nexit (0);\n\n\n\
","use Env qw(HOST);\nuse Env qw(HOME);\nuse Env q\
w(USER);\n\n\n$query_start=-1;\n$query_end=-1;\n\n\
while (<>)\n  {\n    if ( /\\/\\//){$in_aln=1;}\n \
   elsif ( $in_aln && /(\\S+)\\s+(.*)/)\n      {\n\
\n\n	$name=$1;\n	\n\n	$seq=$2;\n	$seq=~s/\\s//g;\n\
        $seq=~s/\\~/\\-/g;\n	$seq=~s/\\./\\-/g;\n	\
if ( $list{$n}{'name'} && $list{$n}{'name'} ne $na\
me)\n	  {\n	    print \"$list{$n}{'name'} Vs $name\
\";\n	    \n	    exit (EXIT_FAILURE);\n	  }\n	else\
\n	  {\n	    $list{$n}{'name'}= $name;\n	  }\n\n	$\
list{$n}{'seq'}=$list{$n}{'seq'}.$seq;\n	\n	$nseq=\
++$n;\n	\n      }\n    else\n      {$n=0;}\n  }\n\\
n\nfor ($a=0; $a<$nseq; $a++)\n  {\n    print \">$\
list{$a}{'name'}\\n$list{$a}{'seq'}\\n\";\n  }\n  \
    \n","$run_anyway=2;\nmy $msaf=\"msa.in.tmp.$$\\
";\nmy $msaoutf=\"msa.out.tmp.$$\";\nmy $err=\"msa\
.out.err.$$\";\nopen  (F, $ARGV[0]);\nopen  (OUT, \
\">$msaf\");\n$nseq=0;\nwhile (<F>)\n  {\n    $l=$\
_;\n    if ( $l=~/^>(\\S+)/)\n      {\n	$s=$seqnam\
e{$nseq++}=$1;\n	print OUT \"$l\";\n	\n      }\n  \
  else \n      {\n	$l=uc($l);\n	print OUT \"$l\";\\
n      }\n  }\n\nclose (F);\nclose(OUT);\n\nsystem\
 (\"msa $msaf > $msaoutf 2>$err\");\nopen (F, \"$m\
saoutf\");\n$read=0;\n$cn=0;\nwhile (<F>)\n  {\n  \
  $l=$_;\n    if ($read)\n      {\n	if ($l=~/End g\
aps not penalized/){$read=0;}\n	elsif (!($l=~/\\S/\
))\n	  {\n	    $cn=0;\n	  }\n	else\n	  {\n	    \n	\
    chomp ($l);\n	    $seqal{$cn++}.=$l;\n	    $to\
t++;\n	  }\n      }\n    elsif ($l=~/Optimal Multi\
ple Alignment/)\n      {\n	$read=1;\n      }\n  }\\
nclose (F);\n\nif ($tot<1 && $run_anyway==1)\n  {\\
n    print STDERR \"\\nWarning: MSA returned a NUL\
L file -- Use T-Coffee instead\\n\";\n    open (F,\
$err);\n    while (<F>){print \"$_\";}\n      \n  \
  system (\"t_coffee -seq $msaf -outfile $ARGV[1] \
 -quiet\");\n  }\nelsif ($tot<1 && $run_anyway==2)\
\n  {\n    \n    \n    $nseq/=2;\n    $nseq=int ($\
nseq);\n    if ($nseq<2){$nseq=2;}\n    print \"RU\
N MSA with NSeq=$nseq\\n\";\n    #print (\"t_coffe\
e -dpa -dpa_nseq $nseq -seq $ARGV[0] -dpa_tree cod\
nd -outfile $ARGV[1] -dpa_method msa_msa\");\n    \
system (\"t_coffee -dpa -dpa_nseq $nseq -seq $ARGV\
[0] -dpa_tree codnd -outfile $ARGV[1] -dpa_method \
msa_msa>/dev/null\");\n\n  }\nelsif ($tot<1)\n  {\\
n    exit (EXIT_FAILURE);\n  }\nelse\n  {\n    ope\
n (OUT, \">$ARGV[1]\");\n    for ($a=0; $a<$nseq;$\
a++)\n      {\n	print OUT \">$seqname{$a}\\n$seqal\
{$a}\\n\";\n      }\n    close (OUT);\n  }\n\n\n\n\
unlink ($msaf);\nunlink ($msaoutf);\nunlink ($err)\
;\n","use strict;\nuse Cwd;\nuse File::Basename;\n\
my $test=0;\n\nmy $tmpdir=\"/tmp/tco/aligners/upp/\
\";\nmymkdir ($tmpdir);\n\n\n\nif ($ARGV[0] eq \"o\
ne\")\n  {\n    seq2msa ($ARGV[1], $ARGV[2]);\n  }\
\nelsif ($ARGV[0] eq \"all\")\n  {\n    listseq2li\
stmsa ($ARGV[1]);\n  }\n\nsub listseq2listmsa\n  {\
\n    my $list=shift;\n    my $cdir = getcwd;\n   \
 my $dir=random_string(10);\n    $dir=\"$tmpdir/$d\
ir/\";\n    my %h;\n    my $n;\n    mkdir  ($dir);\
\n\n    open (F, $list);\n    while (<F>)\n      {\
\n        my $l=$_;\n\n        chomp($l);\n       \
 my @f=split (/\\s+/, $l);\n	if ( -e $f[0])\n     \
     {\n            $h{$n}{in}=$f[0];\n           \
 ($h{$n}{name},$h{$n}{path})=fileparse ($f[0]);\n \
           $h{$n}{NFin}= \"$dir/$h{$n}{name}.seq\"\
;\n	    \n            $h{$n}{NFout}=\"$dir/$h{$n}{\
name}.aln\";\n\n            $h{$n}{out}=$f[1];\n\n\
            fasta2fastaupp ($h{$n}{in}, $h{$n}{NFi\
n});\n            $n++;\n          }\n      }\n   \
 close (F);\n    chdir ($dir);\n    \n    if (!$te\
st)\n      {\n	system (\"fbname=\\$(basename `ls *\
.seq` .seq); \\\n             run_upp.py -s \\${fb\
name}.seq -m amino --cpu 1 -d outdir -o \\${fbname\
}.aln; \\\n             mv outdir/\\${fbname}.aln_\
alignment.fasta \\${fbname}.aln;\");\n      }\n   \
 \n    foreach my $n (keys (%h))\n      {\n	if ($t\
est)\n	  {\n	    system (\"cp $h{$n}{NFin} $h{$n}{\
NFout}\");\n	    print \"$h{$n}{NFin} $h{$n}{NFout\
} $h{$n}{out}\\n\";\n	  }\n        fastaupp2fasta \
($h{$n}{NFout},$h{$n}{out});\n      }\n    chdir (\
$cdir);\n  }\n\nsub seq2msa\n    {\n      my ($in,\
 $out)=@_;\n      my $cdir=getcwd;\n      \n      \
\n      if (!($in=~/\\//)){$in=$cdir.\"/\".$in;}\n\
      if (!($out=~/\\//)){$out=$cdir.\"/\".$out;}\\
n      \n      my $file=random_string(10);\n      \
$file=\"$tmpdir/$file\";\n      open (F, \">$file\\
");\n      print F \"$in $out\\n\";\n      close (\
F);\n      \n      return listseq2listmsa ($file);\
\n    }\n	\nsub fasta2fastaupp\n  {\n    my ($in, \
$out)=@_;\n    my ($name, $seq, $n);\n    \n    if\
 (!-e $in){return;}\n    \n    open (IN, \"$in\");\
\n    open (OUT, \">$out\");\n    local $/ = \"\\n\
>\";  # read by FASTA record\n    \n    while (<IN\
>)\n      {\n	my $l=$_;\n	$l=~s/>//g;\n	$l=\">\".$\
l;\n	\n	$l=~/^>(.*)/;\n	$name=$1;\n	\n	$l=~s/^>*.+\
\\n//;\n	$l=~s/\\n//g;\n	$seq=$l;\n	\n	$seq=~s/u/x\
/g;\n	$seq=~s/U/X/g;\n	print OUT \">$name\\n$seq\\\
n\";\n	$n++;\n      }\n    if ($n==2)\n      {\n	p\
rint OUT \">fake_seq4upp\\n$seq\\n\";\n      }\n  \
  close (IN);\n    close (OUT);\n    local $/=\"\\\
n\";\n  }\n\nsub fastaupp2fasta\n  {\n    my ($in,\
 $out)=@_;\n    my ($name, $seq, $n);\n    \n    i\
f (!-e $in){return;}\n    \n    open (IN, \"$in\")\
;\n    open (OUT, \">$out\");\n    local $/ = \"\\\
n>\";  # read by FASTA record\n    \n    while (<I\
N>)\n      {\n	my $l=$_;\n	$l=~s/>//g;\n	$l=\">\".\
$l;\n	\n	$l=~/^>(.*)/;\n	$name=$1;\n	\n	$l=~s/^>*.\
+\\n//;\n	$l=~s/\\n//g;\n	$seq=$l;\n	\n	$seq=~s/x/\
u/g;\n	$seq=~s/X/U/g;\n	\n	if (!($name=~/fake_seq4\
upp/))\n	  {\n	    print OUT \">$name\\n$seq\\n\";\
\n	  }\n      }\n    close (IN);\n    close (OUT);\
\n    local $/=\"\\n\";\n  }\n\nsub random_string\\
n    {\n      my $len=shift;\n      my @chars = (\\
"A\"..\"Z\", \"a\"..\"z\");\n      my $string;\n  \
    $string .= $chars[rand @chars] for 1..$len;\n \
     return $string;\n    }\n\nsub mymkdir\n      \
{\n	my $d=shift;\n	my $cd='/';\n	\n	foreach my $e \
(split (/\\//, $d))\n	  {\n	    $cd.=\"$e/\";\n	  \
  if ( !-d $cd){mkdir ($cd);}\n	  }\n	return;\n   \
   }\n      \n			  \n      \n","use strict;\nuse C\
wd;\nuse File::Basename;\n\n\nmy $tmpdir=\"/tmp/tc\
o/aligners/clustalo/\";\nmymkdir ($tmpdir);\n\n\n\\
nif ($ARGV[0] eq \"one\")\n  {\n    seq2msa ($ARGV\
[1], $ARGV[2]);\n  }\nelsif ($ARGV[0] eq \"all\")\\
n  {\n    listseq2listmsa ($ARGV[1]);\n  }\n\n\n\n\
sub listseq2listmsa\n  {\n    my $list=shift;\n   \
 my $cdir = getcwd;\n    my $dir=random_string(10)\
;\n    $dir=\"$tmpdir/$dir/\";\n    my %h;\n    my\
 $n;\n    mkdir  ($dir);\n    \n    open (F, $list\
);\n    while (<F>)\n      {\n	my $l=$_;\n\n	chomp\
($l);\n	my @f=split (/\\s+/, $l);\n	#print \"$l: 0\
:$f[0], 1:$f[1]\\n\";\n	if ( -e $f[0])\n	  {\n	   \
 $h{$n}{in}=$f[0];\n	    ($h{$n}{name},$h{$n}{path\
})=fileparse ($f[0]);\n	    $h{$n}{NFin}= \"$dir/$\
h{$n}{name}.seq4nf\";\n	    $h{$n}{NFout}=\"$dir/$\
h{$n}{name}.aln\";\n	    \n	    $h{$n}{out}=$f[1];\
\n	    \n	    translate_fasta_seq (\"uU\", \"X\",$\
h{$n}{in}, $h{$n}{NFin});\n	    $n++;\n	  }\n     \
 }\n    close (F);\n    \n    \n    chdir ($dir);\\
n    dump_nf (\"nf\");\n    dump_config ();\n   \n\
    #system (\"nextflow run nf  --name \\'*.seq4nf\
\\' >/dev/null 2>/dev/null\");\n    system (\"next\
flow run nf  --name \\'*.seq4nf\\'\");\n    foreac\
h my $n (keys (%h))\n      {\n	translate_fasta_seq\
 (\"uU\", \"X\",$h{$n}{NFout},$h{$n}{out});\n     \
 }\n    chdir ($cdir);\n  }\nsub seq2msa\n    {\n \
     my ($in, $out)=@_;\n      my $cdir=getcwd;\n \
     \n      \n      if (!($in=~/\\//)){$in=$cdir.\
\"/\".$in;}\n      if (!($out=~/\\//)){$out=$cdir.\
\"/\".$out;}\n      \n      my $file=random_string\
(10);\n      $file=\"$tmpdir/$file\";\n      open \
(F, \">$file\");\n      print F \"$in $out\\n\";\n\
      close (F);\n      \n      return listseq2lis\
tmsa ($file);\n    }\n	\nsub seq2msa_old\n  {\n   \
 my ($in, $out)=@_;\n    my $cdir = getcwd;\n    m\
y $dir=random_string(10);\n    $dir=\"/tmp/upp.nf4\
tcoffee/$dir\";\n    my $seq=random_string(10);\n \
   $seq.=\".fa\";\n    my $aln=$seq;\n    $aln.=\"\
.aln\";\n    \n    mkdir ($dir);\n    translate_fa\
sta_seq (\"uU\", \"X\",$in, \"$dir/$seq\");\n    c\
hdir ($dir);\n    \n    dump_nf (\"nf\");\n    dum\
p_config ();\n    print \"IN: $in OUT: $cdir/$out\\
\nDIR: $dir\\nnextflow run nf  --name \\'*.fa\\' \\
\n\";\n    system (\"nextflow run nf  --name \\'*.\
fa\\' \");\n    print \"$dir/$aln $cdir/$out\\n\";\
\n    translate_fasta_seq (\"xX\", \"U\",$aln, \"$\
cdir/$out\");\n    chdir ($cdir);\n   } \nsub tran\
slate_fasta_seq\n  {\n    my ($from, $to, $in, $ou\
t)=@_;\n    my $n;\n    my $skip;\n    my $l;\n   \
 my $cseq;\n    if (!-e $in){return;}\n    \n    o\
pen (IN, \"$in\");\n    open (OUT, \">$out\");\n  \
 \n    while (<IN>)\n      {\n	$l=$_;\n	if ($l=~\"\
>\"){$n++;$cseq=\"\";}\n	else { $l=~s/[$from]/$to/\
;$cseq.=$l;}\n\n	if ($skip){$skip=0;}\n	elsif ($l=\
~/>fake_seq/){$skip=1;}\n	else\n	  {\n	    print O\
UT \"$l\";\n	  }\n      }\n    if ($n==2 && $from \
eq \"uU\")\n      {\n	print OUT \">fake_seq\\n$cse\
q\\n\";\n      }\n    close (IN);\n    close (OUT)\
;\n  }\n\nsub dump_config\n    {\n      open (F, \\
">nextflow.config\");\n\n      print F \"docker.en\
abled = true\\n\";\n      print F \"process.contai\
ner = \\'cbcrg/benchfam_large_scale\\'\\n\";\n    \
  close (F);\n    }\n\nsub dump_nf\n  {\n    my $n\
ff=shift;\n    open (F,\">$nff\");\n    print F \"\
#!/usr/bin/env nextflow\\n\";\n    print F \"param\
s.base_dir=\\\"./\\\"\\n\";\n    print F \"params.\
out_dir=\\\"./\\\"\\n\";\n    print F \"Channel.fr\
omPath(params.name)\\n\";\n    print F \"\\t.map{ \
tuple(it.baseName, it) }\\n\";\n    \n    print F \
\"\\t.set{ file_names_1 }\\n\";\n    print F \"pro\
cess clustalo_align{\\n\";\n    print F \"\\tpubli\
shDir params.out_dir, mode: \\\"copy\\\"\\n\";\n  \
  print F \"tag \\\"\\${name}\\\"\";\n    print F \
\"\\n\";\n    print F \"\\tinput:\\n\";\n    print\
 F \"\\tset name, file(seq_file) from file_names_1\
\\n\";\n    print F \"\\toutput:\\n\";\n    print \
F \"\\tfile \\\"\\${name}.aln\\\"\\n\";\n    print\
 F \"\\n\";\n    print F \" \\\"\\\"\\\"\\n\";\n  \
  print F \" clustalo -i \\$seq_file -o \\${name}.\
aln\\n\";\n    print F \"\\\"\\\"\\\"\\n\\n\";\n  \
  print F \"}\\n\";\n    close (F);\n  }\n\nsub ra\
ndom_string\n    {\n      my $len=shift;\n      my\
 @chars = (\"A\"..\"Z\", \"a\"..\"z\");\n      my \
$string;\n      $string .= $chars[rand @chars] for\
 1..$len;\n      return $string;\n    }\n\nsub mym\
kdir\n      {\n	my $d=shift;\n	my $cd='/';\n	\n	fo\
reach my $e (split (/\\//, $d))\n	  {\n	    $cd.=\\
"$e/\";\n	    if ( !-d $cd){mkdir ($cd);}\n	  }\n	\
return;\n      }\n      \n			  \n      \n","\nmy $\
msaf=\"msa.in.tmp.$$\";\nmy $msaoutf=\"msa.out.tmp\
.$$\";\nmy $cost=\"blosum62.tmp.$$\";\n\nopen  (F,\
 $ARGV[0]);\nopen  (OUT, \">$msaf\");\n$nseq=0;\nw\
hile (<F>)\n  {\n    $l=$_;\n    if ( $l=~/^>(\\S+\
)/)\n      {\n	my $simple=\"Seq$nseq\";\n	$s=$seqn\
ame{$nseq++}=$1;\n	$translate{$simple}=$s;\n	\n	pr\
int OUT \">$simple\\n\";\n	\n      }\n    else\n  \
    {\n	$l=uc($l);\n	print OUT \"$l\";\n      }\n \
 }\nclose (F);\nclose(OUT);\n\ndump_blosum ($cost)\
;\nsystem (\"dca -c $cost -q $msaf> $msaoutf 2>/de\
v/null\");\nopen (F, \"$msaoutf\");\nopen (OUT, \"\
>$ARGV[1]\");\n\n$read=0;\nwhile (<F>)\n  {\n    $\
l=$_;\n    if ($l=~/^>(\\S+)/)\n      {\n	$read=1;\
\n	$name=$translate{$1};\n	print OUT \">$name\\n\"\
;\n      }\n    elsif ($read && ($l=~/\\S/))\n    \
  {\n	print OUT \"$l\";\n      }\n    else\n      \
{\n	$read=0;\n      }\n  }\nclose (F);\n\nunlink (\
$cost);\nunlink ($msaf);\nunlink ($msaoutf);\n\nsu\
b dump_blosum\n  {\n    my $f=shift;\n    open (F,\
 \">$f\");\n\n    print F \"6\\n\";\n    print F \\
"- -   0\\n\";\n    print F \"W W   0\\n\";\n    p\
rint F \"Y Y   4\\n\";\n    print F \"F F   5\\n\"\
;\n    print F \"V V   7\\n\";\n    print F \"L L \
  7\\n\";\n    print F \"I I   7\\n\";\n    print \
F \"M M   6\\n\";\n    print F \"K K   6\\n\";\npr\
int F \"R R   6\\n\";\n    print F \"H H   3\\n\";\
\n    print F \"Q Q   6\\n\";\n    print F \"E E  \
 6\\n\";\n    print F \"D D   5\\n\";\n    print F\
 \"N N   5\\n\";\n    print F \"G G   5\\n\";\n   \
 print F \"A A   7\\n\";\n    print F \"P P   4\\n\
\";\n    print F \"T T   6\\n\";\n    print F \"S \
S   7\\n\";\n    print F \"C C   2\\n\";\n    prin\
t F \"- C  10 \\n\";\n    print F \"- S  10\\n\";\\
n    print F \"- T  10 \\n\";\n    print F \"- P  \
10\\n\";\n    print F \"- A  10 \\n\";\n    print \
F \"- G  10\\n\";\n    print F \"- N  10 \\n\";\n \
   print F \"- D  10\\n\";\n    print F \"- E  10 \
\\n\";\n    print F \"- Q  10\\n\";\nprint F \"- H\
  10 \\n\";\n    print F \"- R  10\\n\";\n    prin\
t F \"- K  10 \\n\";\n    print F \"- M  10\\n\";\\
n    print F \"- I  10 \\n\";\n    print F \"- L  \
10\\n\";\n    print F \"- V  10 \\n\";\n    print \
F \"- F  10\\n\";\n    print F \"- Y  10 \\n\";\n \
   print F \"- W  10\\n\";\n    print F \"W C  13 \
\\n\";\n    print F \"W S  14\\n\";\n    print F \\
"W T  13 \\n\";\n    print F \"W P  15\\n\";\n    \
print F \"W A  14 \\n\";\n    print F \"W G  13\\n\
\";\n    print F \"W N  15 \\n\";\n    print F \"W\
 D  15\\n\";\n    print F \"W E  14 \\n\";\n    pr\
int F \"W Q  13\\n\";\n    print F \"W H  13 \\n\"\
;\n    print F \"W R  14\\n\";\n    print F \"W K \
 14 \\n\";\n    print F \"W M  12\\n\";\n    print\
 F \"W I  14 \\n\";\n    print F \"W L  13\\n\";\n\
    print F \"W V  14 \\n\";\n    print F \"W F  1\
0\\n\";\n    print F \"W Y   9 \\n\";\n    print F\
 \"Y C  13\\n\";\n    print F \"Y S  13 \\n\";\n  \
  print F \"Y T  13\\n\";\n    print F \"Y P  14 \\
\n\";\n    print F \"Y A  13\\n\";\n    print F \"\
Y G  14 \\n\";\n    print F \"Y N  13\\n\";\n    p\
rint F \"Y D  14 \\n\";\n    print F \"Y E  13\\n\\
";\n    print F \"Y Q  12 \\n\";\n    print F \"Y \
H   9\\n\";\n    print F \"Y R  13 \\n\";\n    pri\
nt F \"Y K  13\\n\";\n    print F \"Y M  12 \\n\";\
\n    print F \"Y I  12\\n\";\n    print F \"Y L  \
12 \\n\";\n    print F \"Y V  12\\n\";\n    print \
F \"Y F   8 \\n\";\n    print F \"F C  13\\n\";\np\
rint F \"F S  13 \\n\";\n    print F \"F T  13\\n\\
";\n    print F \"F P  15 \\n\";\n    print F \"F \
A  13\\n\";\n    print F \"F G  14 \\n\";\n    pri\
nt F \"F N  14\\n\";\n    print F \"F D  14 \\n\";\
\n    print F \"F E  14\\n\";\n    print F \"F Q  \
14 \\n\";\n    print F \"F H  12\\n\";\n    print \
F \"F R  14 \\n\";\n    print F \"F K  14\\n\";\n \
   print F \"F M  11 \\n\";\n    print F \"F I  11\
\\n\";\n    print F \"F L  11 \\n\";\n    print F \
\"F V  12\\n\";\n    print F \"V C  12 \\n\";\n   \
 print F \"V S  13\\n\";\n    print F \"V T  11 \\\
n\";\n    print F \"V P  13\\n\";\n    print F \"V\
 A  11 \\n\";\n    print F \"V G  14\\n\";\n    pr\
int F \"V N  14 \\n\";\n    print F \"V D  14\\n\"\
;\nprint F \"V E  13 \\n\";\nprint F \"V Q  13\\n\\
";\nprint F \"V H  14 \\n\";\nprint F \"V R  14\\n\
\";\nprint F \"V K  13 \\n\";\nprint F \"V M  10\\\
n\";\nprint F \"V I   8 \\n\";\nprint F \"V L  10\\
\n\";\nprint F \"L C  12 \\n\";\nprint F \"L S  13\
\\n\";\nprint F \"L T  12 \\n\";\nprint F \"L P  1\
4\\n\";\nprint F \"L A  12 \\n\";\nprint F \"L G  \
15\\n\";\nprint F \"L N  14 \\n\";\nprint F \"L D \
 15\\n\";\nprint F \"L E  14 \\n\";\nprint F \"L Q\
  13\\n\";\nprint F \"L H  14 \\n\";\nprint F \"L \
R  13\\n\";\nprint F \"L K  13 \\n\";\nprint F \"L\
 M   9\\n\";\nprint F \"L I   9 \\n\";\nprint F \"\
I C  12\\n\";\nprint F \"I S  13 \\n\";\nprint F \\
"I T  12\\n\";\nprint F \"I P  14 \\n\";\nprint F \
\"I A  12\\n\";\nprint F \"I G  15 \\n\";\nprint F\
 \"I N  14\\n\";\nprint F \"I D  14 \\n\";\nprint \
F \"I E  14\\n\";\nprint F \"I Q  14 \\n\";\nprint\
 F \"I H  14\\n\";\nprint F \"I R  14 \\n\";\nprin\
t F \"I K  14\\n\";\nprint F \"I M  10 \\n\";\npri\
nt F \"M C  12\\n\";\nprint F \"M S  12 \\n\";\npr\
int F \"M T  12\\n\";\nprint F \"M P  13 \\n\";\np\
rint F \"M A  12\\n\";\nprint F \"M G  14 \\n\";\n\
print F \"M N  13\\n\";\nprint F \"M D  14 \\n\";\\
nprint F \"M E  13\\n\";\nprint F \"M Q  11 \\n\";\
\nprint F \"M H  13\\n\";\nprint F \"M R  12 \\n\"\
;\nprint F \"M K  12\\n\";\nprint F \"K C  14 \\n\\
";\nprint F \"K S  11\\n\";\nprint F \"K T  12 \\n\
\";\nprint F \"K P  12\\n\";\nprint F \"K A  12 \\\
n\";\nprint F \"K G  13\\n\";\nprint F \"K N  11 \\
\n\";\nprint F \"K D  12\\n\";\nprint F \"K E  10 \
\\n\";\nprint F \"K Q  10\\n\";\nprint F \"K H  12\
 \\n\";\nprint F \"K R   9\\n\";\nprint F \"R C  1\
4 \\n\";\nprint F \"R S  12\\n\";\nprint F \"R T  \
12 \\n\";\nprint F \"R P  13\\n\";\nprint F \"R A \
 12 \\n\";\nprint F \"R G  13\\n\";\nprint F \"R N\
  11 \\n\";\nprint F \"R D  13\\n\";\nprint F \"R \
E  11 \\n\";\nprint F \"R Q  10\\n\";\nprint F \"R\
 H  11 \\n\";\nprint F \"H C  14\\n\";\nprint F \"\
H S  12 \\n\";\nprint F \"H T  13\\n\";\nprint F \\
"H P  13 \\n\";\nprint F \"H A  13\\n\";\nprint F \
\"H G  13 \\n\";\nprint F \"H N  10\\n\";\nprint F\
 \"H D  12 \\n\";\nprint F \"H E  11\\n\";\nprint \
F \"H Q  11 \\n\";\nprint F \"Q C  14\\n\";\nprint\
 F \"Q S  11 \\n\";\nprint F \"Q T  12\\n\";\nprin\
t F \"Q P  12 \\n\";\nprint F \"Q A  12\\n\";\npri\
nt F \"Q G  13 \\n\";\nprint F \"Q N  11\\n\";\npr\
int F \"Q D  11 \\n\";\nprint F \"Q E   9\\n\";\np\
rint F \"E C  15 \\n\";\nprint F \"E S  11\\n\";\n\
print F \"E T  12 \\n\";\nprint F \"E P  12\\n\";\\
nprint F \"E A  12 \\n\";\nprint F \"E G  13\\n\";\
\nprint F \"E N  11 \\n\";\nprint F \"E D   9\\n\"\
;\nprint F \"D C  14 \\n\";\nprint F \"D S  11\\n\\
";\nprint F \"D T  12 \\n\";\nprint F \"D P  12\\n\
\";\nprint F \"D A  13 \\n\";\nprint F \"D G  12\\\
n\";\nprint F \"D N  10 \\n\";\nprint F \"N C  14\\
\n\";\nprint F \"N S  10 \\n\";\nprint F \"N T  11\
\\n\";\nprint F \"N P  13 \\n\";\nprint F \"N A  1\
3\\n\";\nprint F \"N G  11 \\n\";\nprint F \"G C  \
14\\n\";\nprint F \"G S  11 \\n\";\nprint F \"G T \
 13\\n\";\nprint F \"G P  13 \\n\";\nprint F \"G A\
  11\\n\";\nprint F \"A C  11 \\n\";\nprint F \"A \
S  10\\n\";\nprint F \"A T  11 \\n\";\nprint F \"A\
 P  12\\n\";\nprint F \"P C  14 \\n\";\nprint F \"\
P S  12\\n\";\nprint F \"P T  12 \\n\";\nprint F \\
"T C  12\\n\";\nprint F \"T S  10 \\n\";\nprint F \
\"S C  12\\n\";\nclose (F);\n    return;\n  }\n   \
 \n","\nuse Env qw(HOST);\nuse Env qw(HOME);\nuse \
Env qw(USER);\n\n                                 \
                       \nuse strict;              \
                               \nuse warnings;\nus\
e diagnostics;\n\nmy $in_hit_list, my $in_aln=0, m\
y(%name_list)=(),my (%list)=(),my $n_seq=0; my $te\
st=0;\nmy($j)=0, my $n=0, my $nom, my $lg_query, m\
y %vu=();\n\nopen (F, \">tmp\");\n\n$/=\"\\n\";\nw\
hile (<>)\n{\n    print F $_;\n    if($_ =~ /Query\
=\\s*(.+?)\\s/i) { $nom=$1;}\n\n    if ( /Sequence\
s producing significant alignments/){$in_hit_list=\
1;}\n    \n    if ($_=~ /^pdb\\|/i) { $_=~ s/pdb\\\
|//g; }\n    if ($_=~ /^(1_\\d+)\\s+\\d+/) { $_=~ \
s/$1/QUERY/;}\n      \n    if ( /^(\\S+).+?\\s+[\\\
d.]+\\s+([\\de.-]+)\\s+$/ && $in_hit_list)	\n    {\
\n	my($id)=$1; # \n	$id=~ s/\\|/_/g; #\n	if ($id =\
~ /.+_$/) { chop($id) }; #\n	$name_list{$n_seq++}=\
$id;\n	$name_list{$n_seq-1}=~ s/.*\\|//g;     \n  \
  }\n  \n    if (/query/i) {$in_aln=1;}\n    if ( \
/^(\\S+)\\s+(\\d+)\\s+([a-zA-Z-]+)\\s+(\\d+)/ || /\
^(\\S+)(\\s+)(\\-+)(\\s+)/ && ($in_aln == 1))\n   \
 {\n	my $name=$1;\n	my $start=$2;\n	my $seq=$3;\n	\
my $end=$4;\n		\n	if ($name =~ /QUERY/i) { $lg_que\
ry=length($seq); }\n\n	unless ($test > $n) #m\n	{\\
n	    my(@seqq)= split('',$seq);\n	    my($gap_mis\
sing)= scalar(@seqq);\n	    \n	    while ($gap_mis\
sing != $lg_query)  { unshift (@seqq,\"-\"); $gap_\
missing= scalar(@seqq); }\n	    $seq=join('',@seqq\
);  #m\n	}\n	\n	if ($name =~ /QUERY/i)\n	{\n	    $\
n=0; %vu=(); $j=0;\n	    $list{$n}{'real_name'}=\"\
$nom\";\n	}	\n	else\n	{\n	    unless (exists $vu{$\
name}) { ++$j;}	\n	    $list{$n}{'real_name'}=$nam\
e_list{$j-1};\n	}\n		\n	$list{$n}{'name'}=$name;\n\
\n	$seq=~tr/a-z/A-Z/;\n	$list{$n}{'seq'}=$list{$n}\
{'seq'};\n	$list{$n}{'seq'}.=$seq;\n\n	$n++;\n	$vu\
{$name}++;\n	$test++;\n   } \n    \n}\n\nmy @numer\
o=();\n\nfor (my $a=0; $a<$n; $a++) #m\n{\n    my \
$long=length($list{0}{'seq'});  \n    my $long1= l\
ength($list{$a}{'seq'});\n  \n    while ($long1 ne\
 $long)\n    {\n	$list{$a}{'seq'}.=\"-\";\n	$long1\
= length ($list{$a}{'seq'});\n    } \n \n    push \
(@numero,\"$list{$a}{'name'} $list{$a}{'real_name'\
}\\n\");\n}\n\nmy %dejavu=();\n\n\nfor (my $i=0; $\
i<=$#numero; $i++)\n{\n    my $s=\">$list{$i}{'rea\
l_name'}\\n$list{$i}{'seq'}\\n\";\n    my $k=0;\n \
   \n    if (exists $dejavu{$numero[$i]}) {next;}\\
n    else\n    {	\n	for ($j=0; $j<$n ; $j++)\n	{\n\
	    if (\"$numero[$i]\" eq \"$numero[$j]\" && $j \
!= $i )\n	    {\n		++$k;\n		$s .=\">$list{$j}{'rea\
l_name'}\\n$list{$j}{'seq'}\\n\";\n	    }\n	}	\n  \
  }\n    \n    if ($k>0) \n    {\n	my $cons;\n	ope\
n (SOR,\">tempo_aln2cons\"); print SOR $s;  close \
SOR ;\n	open (COM,\"t_coffee -other_pg seq_reforma\
t -in tempo_aln2cons -action +aln2cons +upper |\")\
 ; \n     	while (<COM>)\n	{	\n	    if (/^>/) { $c\
ons =\">$list{$i}{'real_name'}\\n\"; next;}\n	    \
$_=~ s/\\n//g;\n	    $cons .=$_;\n	}\n	close COM; \
unlink (\"tempo_aln2cons\");\n	print $cons,\"\\n\"\
; print F $cons,\"\\n\";\n    }	\n    else  { prin\
t $s;  print F $s; }\n    \n    $dejavu{$numero[$i\
]}++;\n} #m\n\nexit;\n\n\n\n\n\n\n\n\n\n\n\n","use\
 Env;\n\n\n$tmp_dir=\"\";\n$init_dir=\"\";\n$progr\
am=\"tc_generic_method.pl\";\n\n$blast=@ARGV[0];\n\
\n$name=\"query\";$seq=\"\";\n%p=blast_xml2profile\
($name,$seq,100, 0, 0, $blast);\n&output_profile (\
%p);\n\n\nsub output_profile\n  {\n    my (%profil\
e)=(@_);\n    my ($a);\n    for ($a=0; $a<$profile\
{n}; $a++)\n      {\n	\n	print \">$profile{$a}{nam\
e} $profile{$a}{comment}\\n$profile{$a}{seq}\\n\";\
\n      }\n    return;\n  }\nsub file_contains \n \
 {\n    my ($file, $tag, $max)=(@_);\n    my ($n);\
\n    $n=0;\n    \n    if ( !-e $file && ($file =~\
/$tag/)) {return 1;}\n    elsif ( !-e $file){retur\
n 0;}\n    else \n      {\n	open (FC, \"$file\");\\
n	while ( <FC>)\n	  {\n	    if ( ($_=~/$tag/))\n	 \
     {\n		close (FC);\n		return 1;\n	      }\n	   \
 elsif ($max && $n>$max)\n	      {\n		close (FC);\\
n		return 0;\n	      }\n	    $n++;\n	  }\n      }\\
n    close (FC);\n    return 0;\n  }\n	    \n	  \n\
sub file2string\n  {\n    my $f=@_[0];\n    my $st\
ring, $l;\n    open (F,\"$f\");\n    while (<F>)\n\
      {\n\n	$l=$_;\n	#chomp ($l);\n	$string.=$l;\n\
      }\n    close (F);\n    $string=~s/\\r\\n//g;\
\n    $string=~s/\\n//g;\n    return $string;\n  }\
\n\n\n\nsub tag2value \n  {\n    \n    my $tag=(@_\
[0]);\n    my $word=(@_[1]);\n    my $return;\n   \
 \n    $tag=~/$word=\"([^\"]+)\"/;\n    $return=$1\
;\n    return $return;\n  }\n      \nsub hit_tag2p\
dbid\n  {\n    my $tag=(@_[0]);\n    my $pdbid;\n \
      \n    $tag=~/id=\"(\\S+)\"/;\n    $pdbid=$1;\
\n    $pdbid=~s/_//;\n    return $pdbid;\n  }\nsub\
 id2pdbid \n  {\n    my $id=@_[0];\n  \n    if ($i\
d =~/pdb/)\n      {\n	$id=~/pdb(.*)/;\n	$id=$1;\n \
     }\n    $id=~s/[|_]//g;\n    return $id;\n  }\
\nsub set_blast_type \n  {\n    my $file =@_[0];\n\
    if (&file_contains ($file,\"EBIApplicationResu\
lt\",100)){$BLAST_TYPE=\"EBI\";}\n    elsif (&file\
_contains ($file,\"NCBI_BlastOutput\",100)) {$BLAS\
T_TYPE=\"NCBI\";}\n    else\n      {\n	$BLAST_TYPE\
=\"\";\n      }\n    return $BLAST_TYPE;\n  }\nsub\
 blast_xml2profile \n  {\n    my ($name,$seq,$maxi\
d, $minid, $mincov, $file)=(@_);\n    my (%p, $a, \
$string, $n);\n    \n\n\n    if ($BLAST_TYPE eq \"\
EBI\" || &file_contains ($file,\"EBIApplicationRes\
ult\",100)){%p=ebi_blast_xml2profile(@_);}\n    el\
sif ($BLAST_TYPE eq \"NCBI\" || &file_contains ($f\
ile,\"NCBI_BlastOutput\",100)){%p=ncbi_blast_xml2p\
rofile(@_);}\n    else \n      {\n	print \"*******\
***** ERROR: Blast Returned an unknown XML Format \
**********************\";\n	die;\n      }\n    for\
 ($a=0; $a<$p{n}; $a++)\n      {\n	my $name=$p{$a}\
{name};\n	$p{$name}{seq}=$p{$a}{seq};\n      }\n  \
  return %p;\n  }\nsub ncbi_blast_xml2profile \n  \
{\n    my ($name,$seq,$maxid, $minid, $mincov, $st\
ring)=(@_);\n    my ($L,$l, $a,$b,$c,$d,$nhits,@id\
entifyerL);\n    \n    \n    $seq=~s/[^a-zA-Z]//g;\
\n    $L=length ($seq);\n    \n    %hit=&xml2tag_l\
ist ($string, \"Hit\");\n    \n    \n    for ($nhi\
ts=0,$a=0; $a<$hit{n}; $a++)\n      {\n	my ($ldb,$\
id, $identity, $expectation, $start, $end, $covera\
ge, $r);\n	my (%ID,%DE,%HSP);\n	\n	$ldb=\"\";\n\n	\
%ID=&xml2tag_list ($hit{$a}{body}, \"Hit_id\");\n	\
$identifyer=$ID{0}{body};\n	\n	%DE=&xml2tag_list (\
$hit{$a}{body}, \"Hit_def\");\n	$definition=$DE{0}\
{body};\n	\n	%HSP=&xml2tag_list ($hit{$a}{body}, \\
"Hsp\");\n	for ($b=0; $b<$HSP{n}; $b++)\n	  {\n	  \
  my (%START,%END,%E,%I,%Q,%M);\n\n	 \n	    %START\
=&xml2tag_list ($HSP{$b}{body}, \"Hsp_query-from\"\
);\n	    %HSTART=&xml2tag_list ($HSP{$b}{body}, \"\
Hsp_hit-from\");\n	    \n	    %LEN=  &xml2tag_list\
 ($HSP{$b}{body}, \"Hsp_align-len\");\n	    %END= \
 &xml2tag_list ($HSP{$b}{body}, \"Hsp_query-to\");\
\n	    %HEND=  &xml2tag_list ($HSP{$b}{body}, \"Hs\
p_hit-to\");\n	    %E=&xml2tag_list     ($HSP{$b}{\
body}, \"Hsp_evalue\");\n	    %I=&xml2tag_list    \
 ($HSP{$b}{body}, \"Hsp_identity\");\n	    %Q=&xml\
2tag_list     ($HSP{$b}{body}, \"Hsp_qseq\");\n	  \
  %M=&xml2tag_list     ($HSP{$b}{body}, \"Hsp_hseq\
\");\n	    \n	    for ($e=0; $e<$Q{n}; $e++)\n\n	 \
     {\n		$qs=$Q{$e}{body};\n		$ms=$M{$e}{body};\n\
		if ($seq eq\"\"){$seq=$qs;$L=length($seq);}\n		\\
n		$expectation=$E{$e}{body};\n		$identity=($LEN{$\
e}{body}==0)?0:$I{$e}{body}/$LEN{$e}{body}*100;\n	\
	$start=$START{$e}{body};\n		$end=$END{$e}{body};\\
n		$Hstart=$HSTART{$e}{body};\n		$Hend=$HEND{$e}{b\
ody};\n	\n		$coverage=(($end-$start)*100)/$L;\n\n	\
\n		if ($identity>$maxid || $identity<$minid || $c\
overage<$mincov){next;}\n		@lr1=(split (//,$qs));\\
n		@lr2=(split (//,$ms));\n		$l=$#lr1+1;\n		for ($\
c=0;$c<$L;$c++){$p[$nhits][$c]=\"-\";}\n		for ($d=\
0,$c=0; $c<$l; $c++)\n		  {\n		    $r=$lr1[$c];\n	\
	    if ( $r=~/[A-Za-z]/)\n		      {\n			\n			$p[$\
nhits][$d + $start-1]=$lr2[$c];\n			$d++;\n		     \
 }\n		  }\n		$Qseq[$nhits]=$qs;\n		$Hseq[$nhits]=$\
ms;\n		$QstartL[$nhits]=$start;\n		$HstartL[$nhits\
]=$Hstart;\n		$identityL[$nhits]=$identity;\n		$en\
dL[$nhits]=$end;\n		$definitionL[$nhits]=$definiti\
on;\n		$identifyerL[$nhits]=$identifyer;\n		$comme\
nt[$nhits]=\"$ldb|$identifyer [Eval=$expectation][\
id=$identity%][start=$Hstart end=$Hend]\";\n		$nhi\
ts++;\n	      }\n	  }\n      }\n    \n    $profile\
{n}=0;\n    $profile{$profile{n}}{name}=$name;\n  \
  $profile{$profile{n}}{seq}=$seq;\n    $profile {\
n}++;\n    \n    for ($a=0; $a<$nhits; $a++)\n    \
  {\n	$n=$a+1;\n	\n	$profile{$n}{name}=\"$name\\_$\
a\";\n	$profile{$n}{seq}=\"\";\n	$profile{$n}{Qseq\
}=$Qseq[$a];\n	$profile{$n}{Hseq}=$Hseq[$a];\n	$pr\
ofile{$n}{Qstart}=$QstartL[$a];\n	$profile{$n}{Hst\
art}=$HstartL[$a];\n	$profile{$n}{identity}=$ident\
ityL[$a];\n	$profile{$n}{definition}=$definitionL[\
$a];\n	$profile{$n}{identifyer}=$identifyerL[$a];\\
n	$profile{$n}{comment}=$comment[$a];\n	for ($b=0;\
 $b<$L; $b++)\n	  {\n	    if ($p[$a][$b])\n	      \
{\n		$profile{$n}{seq}.=$p[$a][$b];\n	      }\n	  \
  else\n	      {\n		$profile{$n}{seq}.=\"-\";\n	  \
    }\n	  }\n      }\n    \n    $profile{n}=$nhits\
+1;\n    return %profile;\n  }\nsub ebi_blast_xml2\
profile \n  {\n    my ($name,$seq,$maxid, $minid, \
$mincov, $string)=(@_);\n    my ($L,$l, $a,$b,$c,$\
d,$nhits,@identifyerL,$identifyer);\n    \n\n    \\
n    $seq=~s/[^a-zA-Z]//g;\n    $L=length ($seq);\\
n    %hit=&xml2tag_list ($string, \"hit\");\n    \\
n    for ($nhits=0,$a=0; $a<$hit{n}; $a++)\n      \
{\n	my ($ldb,$id, $identity, $expectation, $start,\
 $end, $coverage, $r);\n	my (%Q,%M,%E,%I);\n	\n	$l\
db=&tag2value ($hit{$a}{open}, \"database\");\n	$i\
dentifyer=&tag2value ($hit{$a}{open}, \"id\");\n\n\
	$description=&tag2value ($hit{$a}{open}, \"descri\
ption\");\n	\n	%Q=&xml2tag_list ($hit{$a}{body}, \\
"querySeq\");\n	%M=&xml2tag_list ($hit{$a}{body}, \
\"matchSeq\");\n	%E=&xml2tag_list ($hit{$a}{body},\
 \"expectation\");\n	%I=&xml2tag_list ($hit{$a}{bo\
dy}, \"identity\");\n	\n\n	for ($b=0; $b<$Q{n}; $b\
++)\n	  {\n	    \n	    \n	    $qs=$Q{$b}{body};\n	\
    $ms=$M{$b}{body};\n	    if ($seq eq\"\"){$seq=\
$qs;$L=length($seq);}\n\n	    $expectation=$E{$b}{\
body};\n	    $identity=$I{$b}{body};\n	    \n	    \
	    \n	    $start=&tag2value ($Q{$b}{open}, \"sta\
rt\");\n	    $end=&tag2value ($Q{$b}{open}, \"end\\
");\n	    $startM=&tag2value ($M{$b}{open}, \"star\
t\");\n	    $endM=&tag2value ($M{$b}{open}, \"end\\
");\n	    $coverage=(($end-$start)*100)/$L;\n	    \
\n	   # print \"$id: ID: $identity COV: $coverage \
[$start $end]\\n\";\n	    \n	    \n	    if ($ident\
ity>$maxid || $identity<$minid || $coverage<$minco\
v){next;}\n	    # print \"KEEP\\n\";\n\n	    \n	  \
  @lr1=(split (//,$qs));\n	    @lr2=(split (//,$ms\
));\n	    $l=$#lr1+1;\n	    for ($c=0;$c<$L;$c++){\
$p[$nhits][$c]=\"-\";}\n	    for ($d=0,$c=0; $c<$l\
; $c++)\n	      {\n		$r=$lr1[$c];\n		if ( $r=~/[A-\
Za-z]/)\n		  {\n		    \n		    $p[$nhits][$d + $sta\
rt-1]=$lr2[$c];\n		    $d++;\n		  }\n	      }\n	  \
\n	    \n	    $identifyerL[$nhits]=$identifyer;\n	\
    $comment[$nhits]=\"$ldb|$identifyer [Eval=$exp\
ectation][id=$identity%][start=$startM end=$endM]\\
";\n	    $nhits++;\n	  }\n      }\n    \n    $prof\
ile{n}=0;\n    $profile{$profile{n}}{name}=$name;\\
n    $profile{$profile{n}}{seq}=$seq;\n    $profil\
e {n}++;\n    \n    for ($a=0; $a<$nhits; $a++)\n \
     {\n	$n=$a+1;\n	$profile{$n}{name}=\"$name\\_$\
a\";\n	$profile{$n}{seq}=\"\";\n	$profile{$n}{iden\
tifyer}=$identifyerL[$a];\n	\n	$profile{$n}{commen\
t}=$comment[$a];\n	for ($b=0; $b<$L; $b++)\n	  {\n\
	    if ($p[$a][$b])\n	      {\n		$profile{$n}{seq\
}.=$p[$a][$b];\n	      }\n	    else\n	      {\n		$\
profile{$n}{seq}.=\"-\";\n	      }\n	  }\n      }\\
n    $profile{n}=$nhits+1;\n    \n    return %prof\
ile;\n  }\n\nsub blast_xml2hit_list\n  {\n    my $\
string=(@_[0]);\n    return &xml2tag_list ($string\
, \"hit\");\n  }\nsub xml2tag_list  \n  {\n    my \
($string_in,$tag)=@_;\n    my $tag_in, $tag_out;\n\
    my %tag;\n    \n    if (-e $string_in)\n      \
{\n	$string=&file2string ($string_in);\n      }\n \
   else\n      {\n	$string=$string_in;\n      }\n \
   $tag_in1=\"<$tag \";\n    $tag_in2=\"<$tag>\";\\
n    $tag_out=\"/$tag>\";\n    $string=~s/>/>##1/g\
;\n    $string=~s/</##2</g;\n    $string=~s/##1/<#\
/g;\n    $string=~s/##2/#>/g;\n    @l=($string=~/(\
\\<[^>]+\\>)/g);\n    $tag{n}=0;\n    $in=0;$n=-1;\
\n  \n \n\n    foreach $t (@l)\n      {\n\n	$t=~s/\
<#//;\n	$t=~s/#>//;\n	\n	if ( $t=~/$tag_in1/ || $t\
=~/$tag_in2/)\n	  {\n	 \n	    $in=1;\n	    $tag{$t\
ag{n}}{open}=$t;\n	    $n++;\n	    \n	  }\n	elsif \
($t=~/$tag_out/)\n	  {\n	    \n\n	    $tag{$tag{n}\
}{close}=$t;\n	    $tag{n}++;\n	    $in=0;\n	  }\n\
	elsif ($in)\n	  {\n	   \n	    $tag{$tag{n}}{body}\
.=$t;\n	  }\n      }\n  \n    return %tag;\n  }\n\\
n\n\n\n","use Env qw(HOST);\nuse Env qw(HOME);\nus\
e Env qw(USER);\nwhile (<>)\n  {\n    if ( /^>(\\S\
+)/)\n      {\n	if ($list{$1})\n	  {\n	    print \\
">$1_$list{$1}\\n\";\n	    $list{$1}++;\n	  }\n	el\
se\n	  {\n	    print $_;\n	    $list{$1}=1;\n	  }\\
n      }\n    else\n      {\n	print $_;\n      }\n\
  }\n      \n","\n\n\nuse Env qw(HOST);\nuse Env q\
w(HOME);\nuse Env qw(USER);\n\n\nopen (F,$ARGV[0])\
;\nwhile ( <>)\n  {\n    @x=/([^:,;\\)\\(\\s]+):[^\
:,;\\)\\(]*/g;\n    @list=(@list,@x);\n  }\n$n=$#l\
ist+1;\nforeach $n(@list){print \">$n\\nsequence\\\
n\";}\n\n\nclose (F);\n","\nopen (F, $ARGV[0]);\n\\
nwhile ( <F>)\n  {\n    @l=($_=~/(\\S+)/g);\n    \\
n    $name=shift @l;\n    \n    print STDOUT \"\\n\
>$name\\n\";\n    foreach $e (@l){$e=($e eq \"0\")\
?\"O\":\"I\";print \"$e\";}\n  }\nclose (F);\n\n		\
       \n    \n","use strict;\nuse FileHandle;\nus\
e Env qw(HOST);\nuse Env qw(HOME);\nuse Env qw(USE\
R);\nmy %name;\nmy $nseq;\nmy $F= new FileHandle;\\
nopen ($F, $ARGV[0]);\nwhile(<$F>)\n  {\n    \n   \
 my $l=$_;\n    if ($l=~/^#/){;}\n    elsif (($l=~\
/\\d+\\s+\\d+\\s+(\\S+)\\s+(\\S+)/))\n      {\n	my\
 $name=$1;\n	my $seq=$2;\n	print \">$name\\n$seq\\\
n\";\n      }\n  }\nclose ($F);\nexit (0);\n\n\n",\
"use Env qw(HOST);\nuse Env qw(HOME);\nuse Env qw(\
USER);\n\n$tmp=\"$ARGV[0].$$\";\nopen (IN, $ARGV[0\
]);\nopen (OUT, \">$tmp\");\n\nwhile ( <IN>)\n  {\\
n    $file=$_;\n    $file=~s/\\r\\n/\\n/g;\n    $f\
ile=~s/\\n\\r/\\n/g;\n    $file=~s/\\r\\r/\\n/g;\n\
    $file=~s/\\r/\\n/g;\n    print OUT \"$file\";\\
n  }\nclose (IN);\nclose (OUT);\n\nopen (OUT, \">$\
ARGV[0]\");\nopen (IN, \"$tmp\");\n\nwhile ( <IN>)\
\n{\n  print OUT \"$_\";\n}\nclose (IN);\nclose (O\
UT);\nunlink ($tmp);\n\n"};
