/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import music.cpp.client.PopupUtil;

public class ClipboardUtil {
    public static JPopupMenu addCopyMenu(JPopupMenu jPopupMenu, JTextComponent jTextComponent) {
        if (jPopupMenu == null) {
            jPopupMenu = new JPopupMenu();
        } else {
            jPopupMenu.addSeparator();
        }
        JPopupMenu jPopupMenu2 = ClipboardUtil.createPopupMenu(jTextComponent);
        MenuElement[] menuElementArray = jPopupMenu2.getSubElements();
        jPopupMenu.add((JMenuItem)menuElementArray[1]);
        return jPopupMenu;
    }

    public static void addMenu(final JTextComponent jTextComponent) {
        jTextComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                String string = jTextComponent.getSelectedText();
                if (SwingUtilities.isRightMouseButton(mouseEvent) && jTextComponent.isEnabled() && (jTextComponent.isEditable() || string != null) && (jPopupMenu = ClipboardUtil.createPopupMenu(jTextComponent)) != null) {
                    PopupUtil.show(jPopupMenu, jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public static JPopupMenu createPopupMenu(final JTextComponent jTextComponent) {
        jTextComponent.requestFocus();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jPopupMenu.getSubElements().length > 0) {
            jPopupMenu.addSeparator();
        }
        final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        final String string = jTextComponent.getSelectedText();
        JMenuItem jMenuItem = new JMenuItem("Cut");
        if (!(jTextComponent instanceof JPasswordField)) {
            if (string == null || !jTextComponent.isEditable()) {
                jMenuItem.setEnabled(false);
            } else {
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jTextComponent.hasFocus()) {
                            StringSelection stringSelection = new StringSelection(string);
                            clipboard.setContents(stringSelection, null);
                            jTextComponent.replaceSelection("");
                        } else {
                            jTextComponent.addFocusListener(new FocusAdapter(this){
                                private final /* synthetic */ 2 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public synchronized void focusGained(FocusEvent focusEvent) {
                                    StringSelection stringSelection = new StringSelection(2.access$000(this.this$0));
                                    2.access$100(this.this$0).setContents(stringSelection, null);
                                    2.access$200(this.this$0).replaceSelection("");
                                    2.access$200(this.this$0).removeFocusListener(this);
                                }
                            });
                        }
                    }

                    static /* synthetic */ String access$000(2 var0) {
                        return var0.string;
                    }

                    static /* synthetic */ Clipboard access$100(2 var0) {
                        return var0.clipboard;
                    }

                    static /* synthetic */ JTextComponent access$200(2 var0) {
                        return var0.jTextComponent;
                    }
                });
            }
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Copy");
            if (string == null) {
                jMenuItem.setEnabled(false);
            } else {
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jTextComponent.hasFocus()) {
                            StringSelection stringSelection = new StringSelection(string);
                            clipboard.setContents(stringSelection, null);
                        } else {
                            jTextComponent.addFocusListener(new FocusAdapter(this){
                                private final /* synthetic */ 4 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public synchronized void focusGained(FocusEvent focusEvent) {
                                    StringSelection stringSelection = new StringSelection(4.access$300(this.this$0));
                                    4.access$400(this.this$0).setContents(stringSelection, null);
                                    4.access$500(this.this$0).removeFocusListener(this);
                                }
                            });
                        }
                    }

                    static /* synthetic */ String access$300(4 var0) {
                        return var0.string;
                    }

                    static /* synthetic */ Clipboard access$400(4 var0) {
                        return var0.clipboard;
                    }

                    static /* synthetic */ JTextComponent access$500(4 var0) {
                        return var0.jTextComponent;
                    }
                });
            }
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Paste");
        Transferable transferable = clipboard.getContents(jTextComponent);
        if (transferable == null) {
            jMenuItem.setEnabled(false);
        } else {
            String string2 = null;
            try {
                string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (string2 != null && jTextComponent instanceof JTextField && (string2.indexOf(10) >= 0 || string2.indexOf(13) >= 0)) {
                    string2 = ClipboardUtil.cleanup(string2);
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            if (string2 == null || string2.length() == 0 || !jTextComponent.isEditable()) {
                jMenuItem.setEnabled(false);
            } else {
                final String string3 = string2;
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jTextComponent.hasFocus()) {
                            jTextComponent.replaceSelection(string3);
                        } else {
                            jTextComponent.addFocusListener(new FocusAdapter(this){
                                private final /* synthetic */ 6 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public synchronized void focusGained(FocusEvent focusEvent) {
                                    6.access$700(this.this$0).replaceSelection(6.access$600(this.this$0));
                                    6.access$700(this.this$0).removeFocusListener(this);
                                }
                            });
                        }
                    }

                    static /* synthetic */ String access$600(6 var0) {
                        return var0.string3;
                    }

                    static /* synthetic */ JTextComponent access$700(6 var0) {
                        return var0.jTextComponent;
                    }
                });
            }
        }
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        if (string == null || !jTextComponent.isEditable()) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTextComponent.hasFocus()) {
                        jTextComponent.replaceSelection("");
                    } else {
                        jTextComponent.addFocusListener(new FocusAdapter(this){
                            private final /* synthetic */ 8 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public synchronized void focusGained(FocusEvent focusEvent) {
                                8.access$800(this.this$0).replaceSelection("");
                                8.access$800(this.this$0).removeFocusListener(this);
                            }
                        });
                    }
                }

                static /* synthetic */ JTextComponent access$800(8 var0) {
                    return var0.jTextComponent;
                }
            });
        }
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    static String cleanup(String string) {
        int n = 0;
        int n2 = -1;
        while (n < string.length()) {
            char c;
            int n3;
            boolean bl = false;
            for (n3 = n; n3 < string.length() && (c = string.charAt(n3)) != '\n' && c != '\r'; ++n3) {
                if (Character.isWhitespace(c)) continue;
                bl = true;
            }
            if (bl) {
                return string.substring(n, n3);
            }
            if (n2 < 0) {
                n2 = n3;
            }
            n = n3 + 1;
        }
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }
}

