/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import music.cpp.client.ConditionPanel;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeEngine;
import music.cpp.client.SongFilter;
import music.cpp.client.StringUtil;

public class FiltersDialog
extends JDialog {
    static final String iAddCondition = StringUtil.replace(MusicClient.STRINGS.get("IDSTR_F_ADD_CONDITION"), "&", "");
    static final String iClear = StringUtil.replace(MusicClient.STRINGS.get("IDSTR_F_CLEAR"), "&", "");
    static final String iAll = MusicClient.STRINGS.get("IDSTR_F_ALL");
    static final String iAny = MusicClient.STRINGS.get("IDSTR_F_ANY");
    static final String iFilter = MusicClient.STRINGS.get("IDSTR_F_FILTER");
    static final String iMatch = MusicClient.STRINGS.get("IDSTR_F_MATCH");
    static final String iOf = MusicClient.STRINGS.get("IDSTR_F_OF_THE");
    static final String iUntitled = MusicClient.STRINGS.get("IDSTR_F_UNTITLED");
    MusicClient client;
    SongFilter filter;
    boolean showName;
    JTextField nameField;
    JComboBox logic;
    Vector conditions = new Vector();
    JButton addCondition;
    JButton clear;
    JButton ok;
    JButton cancel;
    JPanel mainPanel;
    JPanel conditionsPanel;

    public FiltersDialog(MusicClient musicClient, String string, SongFilter songFilter, boolean bl) {
        super(musicClient, string, true);
        JLabel jLabel;
        this.client = musicClient;
        this.filter = songFilter;
        this.showName = bl;
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (this.showName) {
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.bottom = 20;
            jLabel = new JLabel(iFilter);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.nameField = new JTextField(this.filter == null ? this.getUniqueName(null) : this.filter.getName());
            gridBagLayout.setConstraints(this.nameField, gridBagConstraints);
            this.mainPanel.add(this.nameField);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 20;
        jLabel = new JLabel(iMatch);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mainPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        this.logic = new JComboBox<String>(new String[]{iAll, iAny});
        if (this.filter != null && !this.filter.all) {
            this.logic.setSelectedIndex(1);
        } else {
            this.logic.setSelectedIndex(0);
        }
        gridBagLayout.setConstraints(this.logic, gridBagConstraints);
        this.mainPanel.add(this.logic);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        jLabel = new JLabel(iOf);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mainPanel.add(jLabel);
        if (this.filter == null) {
            this.conditions.add(new ConditionPanel(this.client, this, 0, 0, "", ""));
        } else {
            for (int i = 0; i < this.filter.nConditions; ++i) {
                this.conditions.add(new ConditionPanel(this.client, this, this.filter.idx1[i], this.filter.idx2[i], this.filter.v1[i], this.filter.v2[i]));
            }
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.bottom = 2;
        this.conditionsPanel = new JPanel(new GridLayout(this.conditions.size(), 1));
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            this.conditionsPanel.add((ConditionPanel)iterator.next());
        }
        gridBagLayout.setConstraints(this.conditionsPanel, gridBagConstraints);
        this.mainPanel.add(this.conditionsPanel);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 20;
        JPanel jPanel = new JPanel();
        this.addCondition = new JButton(iAddCondition);
        this.addCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersDialog.this.addCondition();
            }
        });
        this.addCondition.setEnabled(this.conditions.size() < 12);
        jPanel.add(this.addCondition);
        this.clear = new JButton(iClear);
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersDialog.this.clear();
            }
        });
        jPanel.add(this.clear);
        this.ok = new JButton(MusicClient.iOK);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersDialog.this.apply();
                FiltersDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.ok);
        this.cancel = new JButton(MusicClient.iCancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.cancel);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.mainPanel.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.mainPanel);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setLocationRelativeTo(this.client);
        this.setResizable(false);
        this.setVisible(true);
    }

    void addCondition() {
        Rectangle rectangle = this.getBounds();
        Dimension dimension = this.conditionsPanel.getSize();
        this.conditions.add(new ConditionPanel(this.client, this, 0, 0, "", ""));
        this.addCondition.setEnabled(this.conditions.size() < 12);
        this.mainPanel.invalidate();
        this.conditionsPanel.removeAll();
        this.conditionsPanel.setLayout(new GridLayout(this.conditions.size(), 1));
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            this.conditionsPanel.add((ConditionPanel)iterator.next());
        }
        Dimension dimension2 = this.conditionsPanel.getPreferredSize();
        rectangle.height += dimension2.height - dimension.height;
        rectangle.width = this.getContentPane().getPreferredSize().width;
        this.setBounds(rectangle);
        this.validate();
    }

    void clear() {
        Rectangle rectangle = this.getBounds();
        Dimension dimension = this.conditionsPanel.getSize();
        this.conditions.clear();
        if (this.filter != this.client.addFilter && this.filter != this.client.processFilter && this.filter != this.client.mixFilter) {
            this.conditions.add(new ConditionPanel(this.client, this, 0, 0, "", ""));
        }
        this.addCondition.setEnabled(this.conditions.size() < 12);
        this.mainPanel.invalidate();
        this.conditionsPanel.removeAll();
        this.conditionsPanel.setLayout(new GridLayout(this.conditions.size(), 1));
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            this.conditionsPanel.add((ConditionPanel)iterator.next());
        }
        Dimension dimension2 = this.conditionsPanel.getPreferredSize();
        rectangle.height += dimension2.height - dimension.height;
        this.setBounds(rectangle);
        this.validate();
    }

    void removeCondition(ConditionPanel conditionPanel) {
        Rectangle rectangle = this.getBounds();
        Dimension dimension = this.conditionsPanel.getSize();
        this.conditions.remove(conditionPanel);
        this.addCondition.setEnabled(this.conditions.size() < 12);
        this.mainPanel.invalidate();
        this.conditionsPanel.invalidate();
        this.conditionsPanel.removeAll();
        this.conditionsPanel.setLayout(new GridLayout(this.conditions.size(), 1));
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            this.conditionsPanel.add((ConditionPanel)iterator.next());
        }
        Dimension dimension2 = this.conditionsPanel.getPreferredSize();
        rectangle.height += dimension2.height - dimension.height;
        this.setBounds(rectangle);
        this.validate();
    }

    String getUniqueName(String string) {
        Vector vector = this.client.getFilters();
        if (string != null) {
            boolean bl = true;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                SongFilter songFilter = (SongFilter)iterator.next();
                if (!string.equals(songFilter.getName())) continue;
                bl = false;
                break;
            }
            if (bl) {
                return string;
            }
        }
        String string2 = iFilter + " ";
        for (int i = 1; i <= vector.size() + 1; ++i) {
            string = string2 + i;
            boolean bl = true;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                SongFilter songFilter = (SongFilter)iterator.next();
                if (!string.equals(songFilter.getName())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return string;
        }
        return string;
    }

    void apply() {
        Object object;
        int n;
        int n2 = this.conditions.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            object = (ConditionPanel)this.conditions.elementAt(n);
            nArray[n] = ((ConditionPanel)object).getCategoryIndex();
            nArray2[n] = ((ConditionPanel)object).condition.getSelectedIndex();
            stringArray[n] = ConditionPanel.fieldTypes[nArray[n]] == 3 ? (String)((ConditionPanel)object).combo.getSelectedItem() : ((ConditionPanel)object).text1.getText();
            stringArray2[n] = ((ConditionPanel)object).text2.getText();
        }
        int n3 = n = this.logic.getSelectedIndex() == 0 ? 1 : 0;
        if (this.showName) {
            object = this.nameField.getText();
            if (this.filter == null) {
                this.client.addFilter((String)object, n2, nArray, nArray2, stringArray, stringArray2, n != 0);
            } else {
                this.client.updateFilter(this.filter, (String)object, n2, nArray, nArray2, stringArray, stringArray2, n != 0);
            }
        } else if (this.filter == this.client.addFilter) {
            this.filter.setData(n2, nArray, nArray2, stringArray, stringArray2, n != 0);
            NativeEngine.setExclusion(0, this.filter);
        } else if (this.filter == this.client.processFilter) {
            this.filter.setData(n2, nArray, nArray2, stringArray, stringArray2, n != 0);
            NativeEngine.setExclusion(1, this.filter);
        } else if (this.filter == this.client.mixFilter) {
            this.filter.setData(n2, nArray, nArray2, stringArray, stringArray2, n != 0);
            this.filter.negate = true;
            NativeEngine.setExclusion(2, this.filter);
        } else {
            this.client.customFilter(n2, nArray, nArray2, stringArray, stringArray2, n != 0);
        }
    }
}

