/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import music.cpp.client.Album;
import music.cpp.client.AlbumProvider;
import music.cpp.client.AlbumProxy;
import music.cpp.client.App;
import music.cpp.client.Artist;
import music.cpp.client.CheckBox2;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;
import music.cpp.client.RadioButton2;
import music.cpp.client.ResizableWindow;
import music.cpp.client.Skin;
import music.cpp.client.Song;
import music.cpp.client.SongProvider;
import music.cpp.client.SongProxy;
import music.cpp.client.Sorter;
import music.cpp.client.StringUtil;
import music.cpp.client.Util;
import music.cpp.client.VectorUtil;

public class Search
extends JDialog
implements ResizableWindow {
    static final String iArtists = MusicClient.STRINGS.get("IDSTR_SRCH_ARTISTS");
    static final String iAlbums = MusicClient.STRINGS.get("IDSTR_SRCH_ALBUMS");
    static final String iSongs = MusicClient.STRINGS.get("IDSTR_SRCH_SONGS");
    static final String iRestrict = MusicClient.STRINGS.get("IDSTR_RESTRICT_SEARCH");
    static final String iName = MusicClient.STRINGS.get("IDSTR_SRCH_NAME");
    static final String iSearch = MusicClient.STRINGS.get("IDSTR_SD_SEARCH");
    static final String iAdd = MusicClient.STRINGS.get("IDSTR_SD_ADD");
    static final String iReplace = MusicClient.STRINGS.get("IDSTR_SD_REPLACE");
    static final String iPlaylist = MusicClient.STRINGS.get("IDSTR_PLAYLIST");
    static final int ARTISTS = 0;
    static final int ALBUMS = 1;
    static final int SONGS = 2;
    static int last = 2;
    MusicClient client;
    JTextField name;
    DefaultListModel matches;
    JList matchList;
    JButton add;
    JButton replace;
    CheckBox2 restrict;
    RadioButton2 bArtists;
    RadioButton2 bAlbums;
    RadioButton2 bSongs;
    boolean resizing = false;
    boolean snapped = false;

    Search(MusicClient musicClient) {
        this(musicClient, last, null);
    }

    Search(MusicClient musicClient, int n, Vector vector) {
        super(musicClient);
        this.client = musicClient;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.setOpaque(false);
        jPanel2.add("West", new Label2(iName));
        this.name = new JTextField();
        this.name.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.search();
            }
        });
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel3.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        jPanel3.add(this.name);
        jPanel2.add(jPanel3);
        JButton jButton = new JButton(iSearch);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.search();
            }
        });
        jPanel2.add("East", jButton);
        jPanel.add("Center", jPanel2);
        this.bArtists = new RadioButton2(iArtists);
        this.bAlbums = new RadioButton2(iAlbums);
        this.bSongs = new RadioButton2(iSongs);
        if (n == 1 && !this.client.showAlbumsView) {
            n = 0;
        }
        switch (n) {
            case 0: {
                this.bArtists.setSelected(true);
                break;
            }
            case 1: {
                this.bAlbums.setSelected(true);
                break;
            }
            case 2: {
                this.bSongs.setSelected(true);
            }
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bArtists);
        if (this.client.showAlbumsView) {
            buttonGroup.add(this.bAlbums);
        }
        buttonGroup.add(this.bSongs);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (Search.this.bArtists.isSelected() && last == 0) {
                    return;
                }
                if (Search.this.bAlbums.isSelected() && last == 1) {
                    return;
                }
                if (Search.this.bSongs.isSelected() && last == 2) {
                    return;
                }
                Search.this.matchList.clearSelection();
                Search.this.matches.clear();
                Search.this.setButtons();
                if (Search.this.bArtists.isSelected()) {
                    last = 0;
                }
                if (Search.this.bAlbums.isSelected()) {
                    last = 1;
                }
                if (Search.this.bSongs.isSelected()) {
                    last = 2;
                }
            }
        };
        this.bArtists.addChangeListener(changeListener);
        this.bAlbums.addChangeListener(changeListener);
        this.bSongs.addChangeListener(changeListener);
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 0));
        this.bArtists.setOpaque(false);
        this.bAlbums.setOpaque(false);
        this.bSongs.setOpaque(false);
        jPanel4.setOpaque(false);
        jPanel4.add(this.bArtists);
        if (this.client.showAlbumsView) {
            jPanel4.add(this.bAlbums);
        }
        jPanel4.add(this.bSongs);
        jPanel.add("South", jPanel4);
        this.matches = new DefaultListModel();
        this.matchList = new JList(this.matches);
        JScrollPane jScrollPane = new JScrollPane(this.matchList, 22, 30);
        this.matchList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                Search.this.setButtons();
            }
        });
        jPanel3 = new JPanel(new FlowLayout(1, 5, 0));
        jPanel3.setOpaque(false);
        this.restrict = new CheckBox2(iRestrict);
        this.restrict.setOpaque(false);
        if (this.client.showGenresView) {
            jPanel3.add(this.restrict);
        }
        JPanel jPanel5 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel5.setBorder(new EmptyBorder(0, 0, 5, 0));
        jPanel5.setOpaque(false);
        this.add = new JButton(iAdd);
        this.replace = new JButton(iReplace);
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.update(false);
            }
        });
        this.add.setEnabled(false);
        jPanel5.add(this.add);
        this.replace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.update(true);
            }
        });
        this.replace.setEnabled(false);
        jPanel5.add(this.replace);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setOpaque(false);
        jPanel6.add("North", jPanel3);
        jPanel6.add("Center", jPanel5);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.setBorder(new EmptyBorder(Skin.getSkin().infoInsets));
        jPanel7.add((Component)jPanel, "North");
        jPanel7.add((Component)jScrollPane, "Center");
        jPanel7.add((Component)jPanel6, "South");
        this.getContentPane().add(jPanel7);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Search.this.cleanup();
            }
        });
        if (vector != null) {
            this.set(n, vector);
        }
        this.pack();
        this.setBounds(this.client.getSearchBounds());
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Search.this.validate();
            }
        });
    }

    public void setButtons() {
        if (this.matchList.getSelectedIndex() < 0) {
            this.add.setEnabled(false);
            this.replace.setEnabled(false);
        } else {
            boolean bl = true;
            if (this.bArtists.isSelected() && this.client.artistList.isSelectedIndex(0)) {
                bl = false;
            }
            if (this.bAlbums.isSelected() && this.client.albumList.isSelectedIndex(0)) {
                bl = false;
            }
            this.add.setEnabled(bl);
            boolean bl2 = true;
            if (this.bArtists.isSelected() && this.client.artistList.getSelectedIndex() == -1) {
                bl2 = false;
            } else if (this.bAlbums.isSelected()) {
                if (this.client.albumList.getSelectedIndex() == -1) {
                    bl2 = false;
                }
            } else if (this.bSongs.isSelected() && this.client.model.getRowCount() == 0) {
                bl2 = false;
            }
            this.replace.setEnabled(bl2);
        }
    }

    public void close() {
        this.cleanup();
        this.dispose();
    }

    public void search() {
        if (this.bArtists.isSelected()) {
            this.searchArtists();
        }
        if (this.bAlbums.isSelected()) {
            this.searchAlbums();
        }
        if (this.bSongs.isSelected()) {
            this.searchSongs();
        }
    }

    public void searchArtists() {
        String string = Util.clean(this.name.getText().trim());
        this.matchList.clearSelection();
        this.matches.clear();
        if (string.length() > 0) {
            Iterator iterator = this.client.getArtists(null, this.restrict.isSelected()).iterator();
            while (iterator.hasNext()) {
                Artist artist;
                String string2;
                Object e = iterator.next();
                if (!(e instanceof Artist) || Util.indexOfIgnorePunctuation(string2 = (artist = (Artist)e).toString(), string) < 0) continue;
                this.matches.addElement(artist);
            }
        }
        this.setButtons();
    }

    public void searchAlbums() {
        String string = Util.clean(this.name.getText().trim());
        this.matchList.clearSelection();
        this.matches.clear();
        if (string.length() > 0) {
            Vector<Album> vector = new Vector<Album>();
            Iterator iterator = this.client.getAlbums(null, this.restrict.isSelected()).iterator();
            while (iterator.hasNext()) {
                Album album = (Album)iterator.next();
                String string2 = album.toString();
                if (Util.indexOfIgnorePunctuation(string2, string) < 0) continue;
                vector.add(album);
            }
            VectorUtil.sort(vector, new Sorter(){

                public int compare(Object object, Object object2) {
                    return StringUtil.compareToIgnorePunctuation(object.toString(), object2.toString());
                }
            });
            for (int i = 0; i < vector.size(); ++i) {
                this.matches.addElement(new AlbumProxy((Album)vector.elementAt(i)));
            }
        }
        this.setButtons();
    }

    public void searchSongs() {
        String string = Util.clean(this.name.getText().trim());
        this.matchList.clearSelection();
        this.matches.clear();
        if (string.length() > 0) {
            Vector vector = this.client.getSongs(string, this.restrict.isSelected());
            VectorUtil.sort(vector, new Sorter(){

                public int compare(Object object, Object object2) {
                    return StringUtil.compareToIgnorePunctuation(object.toString(), object2.toString());
                }
            });
            for (int i = 0; i < vector.size(); ++i) {
                this.matches.addElement(new SongProxy((Song)vector.elementAt(i)));
            }
        }
        this.setButtons();
    }

    void cleanup() {
        this.client.searchAny = null;
        this.client.setSearchBounds(this.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(boolean bl) {
        Object[] objectArray = this.matchList.getSelectedValues();
        if (this.bArtists.isSelected()) {
            boolean bl2;
            this.client.suppressArtists = true;
            try {
                bl2 = false;
                if (bl) {
                    this.client.artistList.clearSelection();
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    Artist artist = (Artist)objectArray[i];
                    int n = Util.indexOf(this.client.artists, (Object)artist);
                    if (n < 0 || this.client.artistList.isSelectedIndex(n)) continue;
                    this.client.artistList.addSelectionInterval(n, n);
                    if (!bl2) {
                        this.client.artistList.ensureIndexIsVisible(n);
                    }
                    bl2 = true;
                }
            }
            finally {
                this.client.suppressArtists = false;
            }
            if (bl2) {
                this.client.setSelectedArtists();
            }
        } else if (this.bAlbums.isSelected()) {
            Album[] albumArray = new Album[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Album) {
                    albumArray[i] = (Album)objectArray[i];
                    continue;
                }
                if (objectArray[i] instanceof AlbumProvider) {
                    albumArray[i] = ((AlbumProvider)objectArray[i]).getAlbum();
                    continue;
                }
                throw new IllegalArgumentException();
            }
            this.client.selectAlbums(albumArray, null, bl);
        } else if (this.bSongs.isSelected()) {
            Vector vector = new Vector();
            if (!bl && this.client.tableSource != null) {
                Vector vector2 = this.client.tableSource.getSongs(this.client);
                for (int i = 0; i < vector2.size(); ++i) {
                    vector.add(vector2.elementAt(i));
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Song song = null;
                if (objectArray[i] instanceof Song) {
                    song = (Song)objectArray[i];
                } else if (objectArray[i] instanceof SongProvider) {
                    song = ((SongProvider)objectArray[i]).getSong();
                } else {
                    App.firewall("Bad argument");
                }
                if (song == null || vector.contains(song)) continue;
                vector.add(song);
            }
            this.client.setList(vector, false, iPlaylist);
        }
        this.close();
    }

    void set(int n, Vector vector) {
        if (n == 1 && !this.client.showAlbumsView) {
            n = 0;
        }
        switch (n) {
            case 0: {
                this.bArtists.setSelected(true);
                break;
            }
            case 1: {
                this.bAlbums.setSelected(true);
                break;
            }
            case 2: {
                this.bSongs.setSelected(true);
            }
        }
        this.matchList.clearSelection();
        this.matches.clear();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.matches.addElement(iterator.next());
        }
        this.setButtons();
    }

    public boolean isResizing() {
        return this.resizing;
    }

    public void setResizing(boolean bl) {
        this.resizing = bl;
    }

    public boolean isSnapped() {
        return this.snapped;
    }

    public void setSnapped(boolean bl) {
        this.snapped = bl;
    }

    public void validate() {
        if (!this.resizing) {
            super.validate();
        }
    }

    public void paint(Graphics graphics) {
        if (!this.resizing) {
            super.paint(graphics);
        }
    }
}

