/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import music.cpp.client.ConditionPanel;
import music.cpp.client.MusicClient;
import music.cpp.client.StringUtil;
import music.cpp.client.UnsupportedVersion;

public class SongFilter {
    static final int ADD_FILTER = 0;
    static final int PROCESS_FILTER = 1;
    static final int MIX_FILTER = 2;
    static final int VERSION = 4;
    static final String iWhere = MusicClient.STRINGS.get("IDSTR_WHERE");
    static final String iAnd = MusicClient.STRINGS.get("IDSTR_AND");
    static final String iOr = MusicClient.STRINGS.get("IDSTR_OR");
    static final String iFTo = MusicClient.STRINGS.get("IDSTR_F_TO");
    String name;
    int nConditions;
    int[] idx1;
    int[] idx2;
    String[] v1;
    String[] v2;
    boolean all;
    boolean negate = false;
    boolean _showOnMix = true;
    private long id;

    private SongFilter() {
    }

    public SongFilter(String string, int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, boolean bl, long l) {
        this.name = string;
        this.nConditions = n;
        this.idx1 = nArray;
        this.idx2 = nArray2;
        this.v1 = stringArray;
        this.v2 = stringArray2;
        this.all = bl;
        this.id = l;
    }

    public void setData(int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, boolean bl) {
        this.nConditions = n;
        this.idx1 = nArray;
        this.idx2 = nArray2;
        this.v1 = stringArray;
        this.v2 = stringArray2;
        this.all = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public long getID() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SongFilter)) {
            return false;
        }
        return this.id == ((SongFilter)object).id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void reset() {
        this.id = 0L;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.nConditions == 0) {
            return stringBuffer.toString();
        }
        block7: for (int i = 0; i < this.nConditions; ++i) {
            int n;
            if (i > 0) {
                stringBuffer.append(" ");
                if (this.all) {
                    stringBuffer.append(iAnd);
                } else {
                    stringBuffer.append(iOr);
                }
                stringBuffer.append(" ");
            }
            String string = (n = this.idx1[i]) >= 0 ? MusicClient.fields[n].toLowerCase() : "";
            stringBuffer.append(string + " ");
            int n2 = this.idx2[i];
            int n3 = n < 0 ? -1 : ConditionPanel.fieldTypes[n];
            switch (n3) {
                case 0: {
                    stringBuffer.append(ConditionPanel.stringTypeConditions[n2] + " \"" + this.v1[i] + "\"");
                    continue block7;
                }
                case 1: {
                    String string2 = StringUtil.l2ac(Integer.parseInt(this.v1[i]));
                    stringBuffer.append(ConditionPanel.numberTypeConditions[n2] + " " + string2);
                    if (n2 == 4) {
                        stringBuffer.append(" " + iFTo + " " + this.v2[i]);
                    }
                    if (ConditionPanel.fieldUnits[n].length() <= 0) continue block7;
                    stringBuffer.append(" " + ConditionPanel.fieldUnits[n]);
                    continue block7;
                }
                case 2: {
                    stringBuffer.append(ConditionPanel.dateTypeConditions[n2] + " " + this.v1[i]);
                    if (n2 != 6) continue block7;
                    stringBuffer.append(" " + iFTo + " " + this.v2[i]);
                    continue block7;
                }
                case 3: {
                    stringBuffer.append(ConditionPanel.filterTypeConditions[n2] + " " + this.v1[i]);
                    continue block7;
                }
                case 4: {
                    stringBuffer.append(ConditionPanel.boolTypeConditions[n2]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(4);
        dataOutput.writeBoolean(this.negate);
        dataOutput.writeBoolean(this._showOnMix);
        dataOutput.writeUTF(this.name);
        dataOutput.writeBoolean(this.all);
        dataOutput.writeInt(this.nConditions);
        for (int i = 0; i < this.nConditions; ++i) {
            dataOutput.writeInt(this.idx1[i]);
            dataOutput.writeInt(this.idx2[i]);
            dataOutput.writeUTF(this.v1[i]);
            dataOutput.writeUTF(this.v2[i]);
        }
    }

    public static SongFilter readFrom(DataInput dataInput) throws IOException {
        SongFilter songFilter = new SongFilter();
        byte by = dataInput.readByte();
        switch (by) {
            case 4: {
                songFilter.negate = dataInput.readBoolean();
            }
            case 3: {
                songFilter._showOnMix = dataInput.readBoolean();
            }
            case 2: {
                songFilter.name = dataInput.readUTF();
            }
            case 1: {
                songFilter.all = dataInput.readBoolean();
                songFilter.nConditions = dataInput.readInt();
                songFilter.idx1 = new int[songFilter.nConditions];
                songFilter.idx2 = new int[songFilter.nConditions];
                songFilter.v1 = new String[songFilter.nConditions];
                songFilter.v2 = new String[songFilter.nConditions];
                for (int i = 0; i < songFilter.nConditions; ++i) {
                    songFilter.idx1[i] = dataInput.readInt();
                    songFilter.idx2[i] = dataInput.readInt();
                    songFilter.v1[i] = dataInput.readUTF();
                    songFilter.v2[i] = dataInput.readUTF();
                }
                break;
            }
            default: {
                throw new UnsupportedVersion(by);
            }
        }
        return songFilter;
    }
}

