/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import music.cpp.client.MusicClient;
import music.cpp.client.Song;
import music.cpp.client.SongTableHeader;
import music.cpp.client.Sorter;
import music.cpp.client.StringUtil;

public class SongTableSorter
implements Sorter {
    int column;
    boolean reversed;
    SongTableHeader header;

    public SongTableSorter(SongTableHeader songTableHeader, int n, boolean bl, boolean bl2) {
        this.header = songTableHeader;
        this.column = n;
        this.reversed = bl;
    }

    public int compare(Object object, Object object2) {
        int n;
        Object object3 = this.header.getColumnModel().getColumn(this.column).getIdentifier();
        if (object3.equals(MusicClient.iFieldTitle)) {
            n = this.byName((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldLength)) {
            n = this.byLength((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldArtist)) {
            n = this.byArtist((Song)object, (Song)object2);
            if (n == 0 && (n = this.byAlbum((Song)object, (Song)object2)) == 0) {
                n = this.byTrack((Song)object, (Song)object2);
            }
        } else if (object3.equals(MusicClient.iFieldTrack)) {
            n = this.byTrack((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldAlbum)) {
            n = this.byAlbum((Song)object, (Song)object2);
            if (n == 0) {
                n = this.byTrack((Song)object, (Song)object2);
            }
        } else if (object3.equals(MusicClient.iFieldYear)) {
            n = this.byYear((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldSize)) {
            n = this.bySize((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldStatus)) {
            n = this.byStatus((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldGenre)) {
            n = this.byGenre((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldFile)) {
            n = this.byFile((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldDateAdded)) {
            n = this.byDateAdded((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldArtistType)) {
            n = this.byField((Song)object, (Song)object2, 11);
        } else if (object3.equals(MusicClient.iFieldComposer)) {
            n = this.byField((Song)object, (Song)object2, 14);
        } else if (object3.equals(MusicClient.iFieldConductor)) {
            n = this.byField((Song)object, (Song)object2, 15);
        } else if (object3.equals(MusicClient.iFieldOrchestra)) {
            n = this.byField((Song)object, (Song)object2, 16);
        } else if (object3.equals(MusicClient.iFieldLyricist)) {
            n = this.byField((Song)object, (Song)object2, 17);
        } else if (object3.equals(MusicClient.iFieldBitrate)) {
            n = this.byBitrate((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldRating)) {
            n = this.byRating((Song)object, (Song)object2);
        } else if (object3.equals(MusicClient.iFieldLastModified)) {
            n = this.byDateModified((Song)object, (Song)object2);
        } else {
            return 1;
        }
        return this.reversed ? -n : n;
    }

    int byName(Song song, Song song2) {
        return StringUtil.compareToIgnorePunctuation(song.name(), song2.name());
    }

    int byArtist(Song song, Song song2) {
        return StringUtil.compareToIgnorePunctuation(song.artist().name(), song2.artist().name());
    }

    int byAlbum(Song song, Song song2) {
        return StringUtil.compareToIgnorePunctuation(song.album().name(), song2.album().name());
    }

    int byLength(Song song, Song song2) {
        double d = song.seconds();
        double d2 = song2.seconds();
        if (d2 > d) {
            return -1;
        }
        if (d2 < d) {
            return 1;
        }
        return 0;
    }

    int byTrack(Song song, Song song2) {
        return song.track() - song2.track();
    }

    int byYear(Song song, Song song2) {
        return song.year() - song2.year();
    }

    int bySize(Song song, Song song2) {
        long l = song.mp3().length();
        long l2 = song2.mp3().length();
        return (int)(l - l2);
    }

    static int getStatus(Song song) {
        if (song.hasAnalysis()) {
            if (song.isProcessed()) {
                return 0;
            }
            return 1;
        }
        if (song.isDead()) {
            return 4;
        }
        if (song.getInsufficientResources()) {
            return 3;
        }
        return 2;
    }

    int byStatus(Song song, Song song2) {
        return SongTableSorter.getStatus(song) - SongTableSorter.getStatus(song2);
    }

    int byGenre(Song song, Song song2) {
        String string = song.genre().name();
        String string2 = song2.genre().name();
        return StringUtil.compareToIgnorePunctuation(string, string2);
    }

    int byDateAdded(Song song, Song song2) {
        return (int)(song.added().getTime() / 1000L - song2.added().getTime() / 1000L);
    }

    int byDateModified(Song song, Song song2) {
        return (int)(song.lastModified().getTime() / 1000L - song2.lastModified().getTime() / 1000L);
    }

    int byFile(Song song, Song song2) {
        String string = song.mp3().toString();
        String string2 = song2.mp3().toString();
        return StringUtil.compareToIgnorePunctuation(string, string2);
    }

    int byField(Song song, Song song2, int n) {
        String string = song.getField(n);
        String string2 = song2.getField(n);
        return StringUtil.compareToIgnorePunctuation(string, string2);
    }

    int byBitrate(Song song, Song song2) {
        return song.getBitrate() - song2.getBitrate();
    }

    int byRating(Song song, Song song2) {
        return song.getRating() - song2.getRating();
    }
}

