/*****************************************************************************
 *
 *   drawbar.cpp
 *
 *   Simulation of an electronic organ like Vox Continental
 *   with JACK MIDI input and JACK audio output
 *
 *   Copyright (C) 2009,2010 Martin Homuth-Rosemann
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; version 2 of the License
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 ******************************************************************************/

#include <QtGui>

#include "drawbar.h"

Drawbar::Drawbar(int *value, const QString &title, QWidget *parent)
    : QGroupBox(title, parent)
{
    extValue = value;
    mix1 = 0;
    mix2 = 0;
    mix3 = 0;
    mix4 = 0;

    label = new QLabel;
    label->setAlignment( Qt::AlignCenter );

    slider = new QSlider();
    slider->setFocusPolicy(Qt::StrongFocus);
    slider->setTickPosition(QSlider::TicksBothSides);
    slider->setTickInterval(1);
    slider->setSingleStep(1);
    slider->setMaximum( 8 );
    slider->setInvertedAppearance(true);
    slider->setInvertedControls(true);

    connect(slider, SIGNAL(valueChanged(int)), label, SLOT(setNum(int)));
    connect(slider, SIGNAL(valueChanged(int)), this, SLOT(exportValue(int)));
    connect(slider, SIGNAL(valueChanged(int)), this, SIGNAL(valueChanged(int)));


    QVBoxLayout *drawbarLayout = new QVBoxLayout();
    drawbarLayout->addWidget(label);
    drawbarLayout->addWidget(slider);
    setLayout(drawbarLayout);

    timer = new QTimer( this );
    connect( timer, SIGNAL( timeout() ), this, SLOT( update() ) );
    timer->start( 50 );
}


void Drawbar::addMix( int *value1, int *value2, int *value3, int *value4 )
{
    mix1 = value1;
    mix2 = value2;
    mix3 = value3;
    mix4 = value4;
}


void Drawbar::setValue(int value)
{
    slider->setValue(value);
    label->setNum(value);
}


void Drawbar::update()
{
    if ( *extValue == slider->value() )
        return;
    slider->setValue(*extValue);
}


void Drawbar::exportValue( int value )
{
    *extValue = value;
    if ( mix1 )
        *mix1 = value;
    if ( mix2 )
        *mix2 = value;
    if ( mix3 )
        *mix3 = value;
    if ( mix4 )
        *mix4 = value;
}
