/*

  Copyright (C) 2011 Grame

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  Grame Research Laboratory, 9 rue du Garet, 69001 Lyon - France
  research@grame.fr

*/

#include <sstream>
#include "htmlpage.h"

using namespace std;

namespace httpdfaust
{

//--------------------------------------------------------------------------
htmlpage::htmlpage(const char *name, const char* address, int port) 
					: fName(name), fAddress(address), fPort(port)
{
}

//--------------------------------------------------------------------------
string htmlpage::getUrl() const
{
	stringstream url;
	url << "http://" << fAddress << ":" << fPort;
	return url.str();
}

//--------------------------------------------------------------------------
void htmlpage::print(std::ostream& out) const
{
	out << "<html>\n<head>\n";
	out << "	<link id='css' rel='stylesheet' type='text/css' href='css/style1.css' />\n";
	out << "	<script src='js/faustuihtml.js' language='javascript'></script>\n";
	out << "	<script src='js/jquery-1.7.1.min.js' language='javascript'></script>\n";
	out << "	<title id=titre>" << fName << "</title>";
	out << "</head>\n<body>\n";
	out << "<script>function setStyle(num) { $(\"#css\").attr('href','css/style'+num+'.css');} </script>\n";
	out << "<center>\n\n";

	out << "<table class='ui'>\n";
	out << "<tr><td class='name'>karplus</td>\n";
	out << "<td class='url'>" << fAddress << "</td>\n";
	out << "<td class='port'>" << fPort << "</td>\n";
	out << "</tr>\n";
	out << "<tr><td colspan=3 class='sep'><hr/></td></tr>\n";

	out << this->str();		// the ui itself, generated byt htmlfactory

	out << "<tr><td colspan=3 class='sep'><hr/></td></tr>\n";
	out << "</table>\n\n";
	
	out << "<div id='style'>Style:\n";
	out << "	<input type='radio' id='style1' name='style' value=1 checked onclick= setStyle(this.value) >\n";
	out << "	<input type='radio' id='style2' name='style' value=2 onclick= setStyle(this.value) >\n";
	out << "</div>\n";
	out << "</center></body>\n</html>\n";
}

} // end namespoace
