#!/usr/bin/env python

import mpdclient2, time
from kdeui import KMainWindow, KPushButton, KListBox, KTabCtl
from qt import QGridLayout, QWidget, QListView, QListViewItem, SIGNAL, SLOT

class KanolaPlaylist(KMainWindow):
	def __init__(self, *args):
		KMainWindow.__init__(self)
		tabctl = KTabCtl(self)
		self.resize(500, 600)
		self.setCaption("Kanola Playlist Manager")
		tabctl.setGeometry(0, 0, 500, 600)
		tabctl.addTab(KTabPlaylist(tabctl), "Playlist")
		tabctl.addTab(KTabLibrary(tabctl), "Library")
		tabctl.show()
		self.show()

	def hello(self):
		print "Hello"

	def resizeEvent(self, event):
		self.resize(500,600)


class KTabPlaylist(QWidget):
	def __init__(self, parent, name = ""):
		QWidget.__init__(self, parent, name)
		self.mpd = mpdclient2.connect()
		self.setGeometry(0, 0, 490, 545)
		self.lv = QListView (self)
		self.lv.setSelectionMode(QListView.Extended)
		self.lv.setSorting (-1)
		self.lv.addColumn ("Track", 1000)
		self.lv.setGeometry (5, 5, 490, 525)
		self.lv.setAllColumnsShowFocus (1)
		self.lv.show()
		time.sleep(1)
		self.refreshPlaylist()

		# Start a timer to have info updated every 5000ms
		self.startTimer(5000)

		btnRemove = KPushButton("Remove", self)
		btnRemove.setGeometry (5, 535, 80, 25)
		btnRemove.show()
		self.connect(btnRemove, SIGNAL("clicked()"), self.removeFromPlaylist)

		btnRefresh = KPushButton("Refresh", self)
		btnRefresh.setGeometry (90, 535, 80, 25)
		btnRefresh.show()
		self.connect(btnRefresh, SIGNAL("clicked()"), self.refreshPlaylist)

		btnClear = KPushButton("Clear", self)
		btnClear.setGeometry (175, 535, 80, 25)
		btnClear.show()
		self.connect(btnClear, SIGNAL("clicked()"), self.clearPlaylist)

		btnShuffle = KPushButton("Shuffle", self)
		btnShuffle.setGeometry (260, 535, 75, 25)
		btnShuffle.show()
		self.connect(btnShuffle, SIGNAL("clicked()"), self.shufflePlaylist)
	
	def refreshPlaylist(self):
		self.lv.clear()
		for song in self.mpd.playlistinfo():
			QListViewItem(self.lv, str(song.file))

	def clearPlaylist(self):
		self.mpd.clear()
		time.sleep(1)
		self.refreshPlaylist()

	def shufflePlaylist(self):
		self.mpd.shuffle()
		time.sleep(1)
		self.refreshPlaylist()


	def removeFromPlaylist(self):
		selectedLVIList = []
		listViewItem = self.lv.firstChild()
		self.index = 0
		self.scanRem(listViewItem, selectedLVIList)
		time.sleep(1)
		self.refreshPlaylist()

	def scanRem(self, listViewItem, selectedLVIList):
		while listViewItem:
			if listViewItem.isSelected():
				self.mpd.delete(self.index)

		        self.scanRem(listViewItem.firstChild(), selectedLVIList)

			listViewItem = listViewItem.nextSibling()
			self.index = self.index + 1

	def timerEvent(self, event):
		# Called every 5000ms to update the display details
		self.refreshPlaylist()



class KTabLibrary(QWidget):
	def __init__(self, parent, name = ""):
		QWidget.__init__(self, parent, name)
		self.mpd = mpdclient2.connect()
		self.setGeometry(0, 0, 490, 545)
		self.lv = QListView (self)
		self.lv.setSelectionMode(QListView.Extended)
		self.lv.setSorting (-1)
		self.lv.addColumn ("Track", 1000)
		self.lv.setGeometry (5, 5, 490, 525)
		self.lv.setAllColumnsShowFocus (1)
		library = self.mpd.listall()
		for song in library:
			QListViewItem(self.lv, str(song.file))
		self.lv.show()

		btnAdd = KPushButton("Add", self)
		btnAdd.setGeometry (5, 535, 80, 25)
		btnAdd.show()
		self.connect(btnAdd, SIGNAL("clicked()"), self.addToPlaylist)

		btnRefresh = KPushButton("Refresh", self)
		btnRefresh.setGeometry (90, 535, 80, 25)
		btnRefresh.show()
		self.connect(btnRefresh, SIGNAL("clicked()"), self.refreshLib)

		btnSelect = KPushButton("Select All", self)
		btnSelect.setGeometry (175, 535, 80, 25)
		btnSelect.show()
		self.connect(btnSelect, SIGNAL("clicked()"), self.selectAll)
		
		btnInvert = KPushButton("Invert", self)
		btnInvert.setGeometry (260, 535, 80, 25)
		btnInvert.show()
		self.connect(btnInvert, SIGNAL("clicked()"), self.invertSelection)

	def refreshLib(self):
		self.mpd.update()
		time.sleep(1)
		library = self.mpd.listall()
		self.lv.clear()
		for song in library:
			QListViewItem(self.lv, str(song.file))


	def selectAll(self):
		self.lv.selectAll(True)

	def invertSelection(self):
		self.lv.invertSelection()

	def addToPlaylist(self):
		selectedLVIList = []
		listViewItem = self.lv.firstChild()

		self.scanAdd(listViewItem, selectedLVIList)

	def scanAdd(self, listViewItem, selectedLVIList):
		while listViewItem:
			if listViewItem.isSelected():
				self.mpd.add(listViewItem.text(0))

		        self.scanAdd(listViewItem.firstChild(), selectedLVIList)

			listViewItem = listViewItem.nextSibling()
