.\" $NCDId: @(#)AuRdEl.man,v 1.1 1994/09/27 00:33:57 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuReadElement 3 "1.2" "audiolib - read from element"
.SH \fBName\fP
\fBAuReadElement\fP \- read data from an ExportClient element in a flow
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
void \fBAuReadElement\fP(\fIserver\fP, \fIflow\fP, \fIelement\fP, \fInum_bytes\fP, \fIdata\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuFlowID\fP \fIflow\fP;
.br
    int \fIelement\fP;
.br
    \fBAuUint32\fP \fInum_bytes\fP;
.br
    \fBAuPointer\fP \fIdata\fP;
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIflow\fP 1i
Specifies the ID of the flow.
.IP \fIelement\fP 1i
Specifies the index of the ExportClient element to read the data from.
.IP \fInum_bytes\fP 1i
Specifies the number of bytes of audio data to read.
.IP \fIdata\fP 1i
Specifies the buffer to read the audio data into.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuReadElement\fP transfers audio data from the server to the client application, reading \fInum_bytes\fP from the ExportClient specified by \fIelement\fP in audio flow \fIflow\fP into \fIdata\fP.
.SH \fBNote\fP
If the flow is "trivial" (consisting only of an ExportClient and an ImportBucket), the \fInum_samples\fP fields in the ExportClient and ImportBucket are ignored.
.SH \fBErrors\fP
\fBAuBadFlow\fP,
\fBAuBadElement\fP.
.SH \fBSee Also\fP
\fBAuWriteElement\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
