/*
  sfc - a oriented MIDI router 

  SFSmi.h  -  Veriable and functions definitions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/




#ifndef SFSMI_H
#define SFSMI_H
#include <pthread.h>
#include <alsa/asoundlib.h>



struct VumetrosIn
{
  int vumvum, ulvum;
};

struct VumetrosOut
{
  int uvo, uluvo;
};


extern pthread_mutex_t mutex;
extern int Pexitprogram, espera, UndoCount, programa, hubofile;
extern const char *FilePreset;
extern VumetrosIn vumi[3];
extern VumetrosOut vumo[8];




class SFS
{



public:
  SFS ();
  ~SFS ();

  void midievents (int i);
  void enviomidi (int i);
  void enviocontrol (int i, int numcontrol);
  void panico ();
  void nuevo ();
  void savefile (char *filename);
  void loadfile (char *filename);
  void savebank (char *filename);
  void loadbank (char *filename);
  void semipanico(int i);
  void metemidi();
  int mirabanco(int i);

  //parameters
  char *Combiname;
  char Cname[24];
  char *Comentario;
  char Comment[256];
  char temporal[16];
  int propchan;
  int numeroOUT, numeroIN;
  unsigned int startp[16], endp[16], progch[16], volume[16], BankLSB[16],
    BankMSB[16], pan[16], Pon[16];
  unsigned int chout[16], onoff[16], reverb[16], chorus[16], PBon[16],
    EXon[16], MOon[16], Ptime[16], OUT1[16], OUT2[16];
  signed int oct[16], transp[16], velo[16];
  char BankFilename[128];


  struct PuertoMidiIn
  {
    int YOIN, SettingsIN;
    char *SMidiIn;
    char pMIDIIN[256];
    char SetMidiIn[40];
    int Ports;
    snd_seq_t *midi_in;
    unsigned int IN[16];
  }
  MidiInPuerto[3];


  struct PuertoMidiOut
  {
    int YOOUT, SettingsOUT;
    char *SMidiOut;
    char SetMidiOut[40];
    int Ports;
    snd_seq_t *midi_out;
    unsigned int OUT[16];
    char pMIDIOUT[128];

  }
  MidiOutPuerto[7];






  struct DataBanco
  {
    unsigned int startp[16], endp[16], progch[16], volume[16], BankLSB[16],
      BankMSB[16], pan[16], Pon[16];
    unsigned int chout[16], onoff[16], reverb[16], chorus[16], PBon[16],
      EXon[16], MOon[16], Ptime[16];
    signed int oct[16], transp[16], velo[16];
    PuertoMidiIn MidiInPuerto[3];
    PuertoMidiOut MidiOutPuerto[8];
    char Cname[24];
    char Comment[256];
  }
  Banco[45], Undo[100], Prim[2];

  struct PMidiOut
  {
    int Client, Port;
    char Nombre[40], Info[40];
    const char *CName, *CInfo;

  }
  CPOMidiS[48];

  struct PMidiIn
  {
    int Client, Port;
    char Nombre[40], Info[40];
    const char *CName, *CInfo;

  }
  CPIMidiS[48];

  struct PBList
  {
    int Prog;
    char ProgName[50];
  };

  struct PPList
  {
    int Banco;
    PBList PBanco[129];
  }
  PresetList[129];

};


#endif
