/*
  sfc - a oriented MIDI router 

  sfsFileIO.C  -  File I/O functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include "SFSmi.h"


void
SFS::savefile (char *filename)
{
  int i;
  FILE *fn;
  char buf[256];
  fn = fopen (filename, "w");
  for (i = 1; i <= 8; i++)
    {

      bzero (buf, sizeof (buf));
      sprintf (buf, "%d,%d,%d,%d,%d,%d,%d,%d,%d,", onoff[i], chout[i], oct[i],
	       transp[i], velo[i], startp[i], endp[i], reverb[i], chorus[i]);

      fputs (buf, fn);
      bzero (buf, sizeof (buf));
      sprintf (buf, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,", progch[i],
	       BankMSB[i], BankLSB[i], pan[i], volume[i], PBon[i], EXon[i],
	       MOon[i], Pon[i], Ptime[i], MidiInPuerto[1].IN[i],
	       MidiInPuerto[2].IN[i]);
      fputs (buf, fn);
      bzero (buf, sizeof (buf));

      sprintf (buf, "%d,%d,%d,%d,%d,%d\n", MidiOutPuerto[1].OUT[i],
	       MidiOutPuerto[2].OUT[i], MidiOutPuerto[3].OUT[i],
	       MidiOutPuerto[4].OUT[i], MidiOutPuerto[5].OUT[i],
	       MidiOutPuerto[6].OUT[i]);
      fputs (buf, fn);
    }
  for (i = 0; i <= 24; i++)
    buf[i] = Cname[i];
  fputs (buf, fn);
  bzero (buf, sizeof (buf));
  fputs ("\n", fn);
  for (i = 0; i <= 256; i++)
    buf[i] = Comment[i];
  fputs (buf, fn);
  bzero (buf, sizeof (buf));
  fputs ("\n", fn);

  fclose (fn);

};

void
SFS::loadfile (char *filename)
{
  int i;
  int k = 1;
  FILE *fn;
  char buf[512];

  if ((fn = fopen (filename, "r")) == NULL)
    return;


  while (k <= 8)

    {
      fgets (buf, sizeof buf, fn);


      sscanf
(buf,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",
	       &onoff[k], &chout[k], &oct[k], &transp[k], &velo[k], &startp[k],
	      &endp[k], &reverb[k], &chorus[k], &progch[k], &BankMSB[k],
	      &BankLSB[k], &pan[k], &volume[k], &PBon[k], &EXon[k], &MOon[k],
	      &Pon[k], &Ptime[k], &MidiInPuerto[1].IN[k],
	      &MidiInPuerto[2].IN[k], &MidiOutPuerto[1].OUT[k],
	      &MidiOutPuerto[2].OUT[k], &MidiOutPuerto[3].OUT[k],
	      &MidiOutPuerto[4].OUT[k], &MidiOutPuerto[5].OUT[k],
	      &MidiOutPuerto[6].OUT[k]);

      bzero (buf, sizeof (buf));
      k = k + 1;

    }
  bzero (Cname, sizeof (Cname));
  fgets (buf, sizeof buf, fn);

  for (i = 0; i <= 24; i++)
    if (buf[i] > 20)
      Cname[i] = buf[i];
  Combiname = Cname;
  bzero (buf, sizeof (buf));
  bzero (Comment, sizeof (Comment));
  k = 0;
  while (fgets (buf, sizeof buf, fn) != NULL)
    {
      for (i = 0; i <= (int) strlen (buf); i++)
	Comment[i + k] = buf[i];
      k = k + strlen (buf);
    }
  Comentario = Comment;
  fclose (fn);
};

void
SFS::loadbank (char *filename)
{
  int i,j;
  int k = 1;
  int salir = 0;
  FILE *fn;
  char buf[512];

  fn = fopen (filename, "r");

  for (j = 1; j <= 44; j++)
    {
      k = 1;
      while (k <= 8)

	{
	  bzero (buf, sizeof (buf));
	  fgets (buf, sizeof buf, fn);


	  sscanf
(buf,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",
		  &Banco[j].onoff[k], &Banco[j].chout[k], &Banco[j].oct[k],
		  &Banco[j].transp[k], &Banco[j].velo[k], &Banco[j].startp[k],
		  &Banco[j].endp[k], &Banco[j].reverb[k], &Banco[j].chorus[k],
		  &Banco[j].progch[k], &Banco[j].BankMSB[k],
		  &Banco[j].BankLSB[k], &Banco[j].pan[k], &Banco[j].volume[k],
		  &Banco[j].PBon[k], &Banco[j].EXon[k], &Banco[j].MOon[k],
		  &Banco[j].Pon[k], &Banco[j].Ptime[k],
		  &Banco[j].MidiInPuerto[1].IN[k],
		  &Banco[j].MidiInPuerto[2].IN[k],
		  &Banco[j].MidiOutPuerto[1].OUT[k],
		  &Banco[j].MidiOutPuerto[2].OUT[k],
		  &Banco[j].MidiOutPuerto[3].OUT[k],
		  &Banco[j].MidiOutPuerto[4].OUT[k],
		  &Banco[j].MidiOutPuerto[5].OUT[k],
		  &Banco[j].MidiOutPuerto[6].OUT[k]);

	  k = k + 1;

	}
      bzero (buf, sizeof (buf));
      fgets (buf, sizeof buf, fn);
      bzero (Banco[j].Cname, sizeof (Banco[j].Cname));
      for (i = 0; i <= 24; i++)
	if (buf[i] > 20)
	  Banco[j].Cname[i] = buf[i];


      k = 0;
      salir = 0;
      bzero (Banco[j].Comment, sizeof (Banco[j].Comment));
      while (salir == 0)
	{
	  bzero (buf, sizeof (buf));
	  fgets (buf, sizeof buf, fn);
	  if (buf[0] == '-' && buf[1] == '-')
	    {
	      salir = 1;
	    }
	  else
	    {
	      for (i = 0; i <= (int) strlen (buf); i++)
		Banco[j].Comment[i + k] = buf[i];
	      k = k + strlen (buf);
	    }
	}

    }
  fclose (fn);
};

void
SFS::savebank (char *filename)
{
  int i,j;
  FILE *fn;
  char buf[256];
  fn = fopen (filename, "w");
  for (j = 1; j <= 44; j++)
    {
      for (i = 1; i <= 8; i++)
	{

	  bzero (buf, sizeof (buf));
	  sprintf (buf, "%d,%d,%d,%d,%d,%d,%d,%d,%d,", Banco[j].onoff[i],
		   Banco[j].chout[i], Banco[j].oct[i], Banco[j].transp[i],
		   Banco[j].velo[i], Banco[j].startp[i], Banco[j].endp[i],
		   Banco[j].reverb[i], Banco[j].chorus[i]);

	  fputs (buf, fn);
	  bzero (buf, sizeof (buf));
	  sprintf (buf, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,",
		   Banco[j].progch[i], Banco[j].BankMSB[i],
		   Banco[j].BankLSB[i], Banco[j].pan[i], Banco[j].volume[i],
		   Banco[j].PBon[i], Banco[j].EXon[i], Banco[j].MOon[i],
		   Banco[j].Pon[i], Banco[j].Ptime[i],
		   Banco[j].MidiInPuerto[1].IN[i],
		   Banco[j].MidiInPuerto[2].IN[i]);
	  fputs (buf, fn);
	  bzero (buf, sizeof (buf));

	  sprintf (buf, "%d,%d,%d,%d,%d,%d\n",
		   Banco[j].MidiOutPuerto[1].OUT[i],
		   Banco[j].MidiOutPuerto[2].OUT[i],
		   Banco[j].MidiOutPuerto[3].OUT[i],
		   Banco[j].MidiOutPuerto[4].OUT[i],
		   Banco[j].MidiOutPuerto[5].OUT[i],
		   Banco[j].MidiOutPuerto[6].OUT[i]);
	  fputs (buf, fn);


	}
      for (i = 0; i <= 24; i++)
	buf[i] = Banco[j].Cname[i];
      fputs (buf, fn);
      bzero (buf, sizeof (buf));
      fputs ("\n", fn);
      for (i = 0; i <= 256; i++)
	buf[i] = Banco[j].Comment[i];
      fputs (buf, fn);
      bzero (buf, sizeof (buf));
      fputs ("\n", fn);
      fputs ("---\n", fn);
    }
  fclose (fn);

};
