/*
  sfc - a oriented MIDI router 

  sfsMidiOut.C  -  MIDI Output functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include "SFSmi.h"

void
SFS::enviomidi (int i)
{
  int j;
  snd_seq_event_t midievent;
  snd_seq_ev_clear (&midievent);


  enviocontrol (i, 0);
  enviocontrol (i, 32);
  snd_seq_ev_set_pgmchange (&midievent, chout[i] - 1, progch[i]);

  snd_seq_ev_set_subs (&midievent);
  snd_seq_ev_set_direct (&midievent);

  for (j = 1; j <= 6; j++)
    {
      if (MidiOutPuerto[j].OUT[i] == 1)
	snd_seq_event_output_direct (MidiOutPuerto[j].midi_out, &midievent);
    }
};


void
SFS::enviocontrol (int i, int j)
{
  int k;
  int qcontrol = 123;
  snd_seq_event_t midievent;
  snd_seq_ev_clear (&midievent);

  switch (j)
    {
    case 0:
      qcontrol = BankMSB[i];
      break;
    case 5:
      qcontrol = Ptime[i];
      break;
    case 7:
      qcontrol = volume[i];
      break;
    case 10:
      qcontrol = pan[i];
      break;
    case 32:
      qcontrol = BankLSB[i];
      break;
    case 37:
      qcontrol = Ptime[i];
      break;
    case 42:
      qcontrol = pan[i];
      break;
    case 65:
      qcontrol = Pon[i];
      break;
    case 91:
      qcontrol = reverb[i];
      break;
    case 93:
      qcontrol = chorus[i];
      break;
    case 123:
      qcontrol = 0;
    }

  snd_seq_ev_set_controller (&midievent, chout[i] - 1, j, qcontrol);

  snd_seq_ev_set_subs (&midievent);
  snd_seq_ev_set_direct (&midievent);
  for (k = 1; k <= 6; k++)
    {
      if (MidiOutPuerto[k].OUT[i] == 1)
	snd_seq_event_output_direct (MidiOutPuerto[k].midi_out, &midievent);
    }

};

void
SFS::panico ()
{

  int i,j,k;
  snd_seq_event_t midievent;
  snd_seq_ev_clear (&midievent);

  for (i = 0; i <= 127; i++)
    {
      for (j = 0; j <= 15; j++)
	{
	  enviocontrol (j, 123);
	  snd_seq_ev_set_noteoff (&midievent, j, i, 80);
	  snd_seq_ev_set_subs (&midievent);
	  snd_seq_ev_set_direct (&midievent);
	  for (k = 1; k <= 6; k++)
	    snd_seq_event_output_direct (MidiOutPuerto[k].midi_out,
					 &midievent);
	}
    }

};

void
SFS::semipanico (int canal)
{

  int i,j,k;
  snd_seq_event_t midievent;
  snd_seq_ev_clear (&midievent);

  for (i = 0; i <= 127; i++)
    {
      j = chout[canal];
          	
	  snd_seq_ev_set_noteoff (&midievent, j, i, 80);
	  snd_seq_ev_set_subs (&midievent);
	  snd_seq_ev_set_direct (&midievent);
	  for (k = 1; k <= 6; k++)
          if (MidiOutPuerto[k].OUT[canal] == 1)
                 {
            vumo[k].uvo = 0;
	    snd_seq_event_output_direct (MidiOutPuerto[k].midi_out,
					 &midievent);
	          }
    }

};


void
SFS::metemidi()
{

int i;

for(i=1; i<=8; i++)
{
 enviomidi(i);
 enviocontrol(i,7);
 enviocontrol(i,10);
 enviocontrol(i,91);
 enviocontrol(i,93);
 enviocontrol(i,65);
 enviocontrol(i,5);
 enviocontrol(i,37);
}
};

