// Licensed GNU LGPL v3 or later: http://www.gnu.org/licenses/lgpl.html

#include "smmain.hh"
#include "smmath.hh"

#include <assert.h>
#include <stdio.h>
#include <unistd.h>

using namespace SpectMorph;

using std::max;

/*
import scipy.special

for i in range (0, 100):
  print "  %.17g," % scipy.special.i0(i)
*/

static const double expect[101] = {
  1,
  1.2660658777520082,
  2.2795853023360668,
  4.8807925858650236,
  11.301921952136331,
  27.239871823604442,
  67.23440697647797,
  168.59390851028968,
  427.56411572180474,
  1093.5883545113745,
  2815.716628466254,
  7288.489339821248,
  18948.925349296311,
  49444.489582217575,
  129418.56270064856,
  339649.37329791381,
  893446.22792010498,
  2354970.223168293,
  6218412.4207810033,
  16446190.440611707,
  43558282.559553534,
  115513961.92215805,
  306692993.64036477,
  815142122.51289237,
  2168619088.2413764,
  5774560606.4663105,
  15388976705.660812,
  41042005854.75795,
  109534604731.75725,
  292520631785.69086,
  781672297823.97754,
  2089962966491.9038,
  5590908381350.8721,
  14963796904156.906,
  40068575042540.711,
  107338818494514.08,
  287666777811244.06,
  771245522292810.5,
  2068504714851044.5,
  5549742955314183,
  14894774793419900,
  39988262828314352,
  1.0738954136804509e+17,
  2.8848025485906643e+17,
  7.7515595378429888e+17,
  2.0834140751773143e+18,
  5.6010647603574528e+18,
  1.506154051104215e+19,
  4.0510499585618813e+19,
  1.0898358416028087e+20,
  2.9325537838493355e+20,
  7.8925739148647465e+20,
  2.1245926548766065e+21,
  5.7202341983522338e+21,
  1.540387598056586e+22,
  4.1487895607331774e+22,
  1.1175971029086805e+23,
  3.0110572854027507e+23,
  8.1137237420377479e+23,
  2.186686615847541e+24,
  5.8940770556098001e+24,
  1.5889342066111658e+25,
  4.2840534014893512e+25,
  1.1552096317012172e+26,
  3.1154579181878971e+26,
  8.4030398456254331e+26,
  2.2667455045804026e+27,
  6.1153222283296973e+27,
  1.650002782141142e+28,
  4.4524323179703616e+28,
  1.2015889579125461e+29,
  3.2430912977468466e+29,
  8.7539852709446127e+29,
  2.3631682191624834e+30,
  6.3800561429185961e+30,
  1.7226390780358043e+31,
  4.6516064020860766e+31,
  1.2561730580974085e+32,
  3.3926015793256834e+32,
  9.163305649751019e+32,
  2.4751784043341698e+33,
  6.6864405781056842e+33,
  1.8064118728576966e+34,
  4.8805758438185049e+34,
  1.3187335938259854e+35,
  3.5634776304081241e+35,
  9.6298881117164486e+35,
  2.6025434044228732e+36,
  7.0340196973223031e+36,
  1.9012419299064899e+37,
  5.1392383455086636e+37,
  1.3892714060989622e+38,
  3.7557943574056018e+38,
  1.015412047323623e+39,
  2.7454153889471684e+39,
  7.4233258618753486e+39,
  2.007304126311214e+40,
  5.4281459646010072e+40,
  1.4679560674074193e+41,
  3.9700623517729635e+41,
};

void
kaiser (int N, double beta)
{
  for (int i = 0; i < N; i++)
    {
      // https://en.wikipedia.org/wiki/Kaiser_window
      printf ("%.17g\n", sm_bessel_i0 (M_PI * beta * sqrt (1 - pow ((2.0*i / (N-1) - 1), 2))) / sm_bessel_i0 (M_PI * beta));
    }
}

int
main (int argc, char **argv)
{
  Main main (&argc, &argv);

  double max_diff = 0;
  for (int i = 0; i < 100; i++)
    {
      double diff = (sm_bessel_i0 (i) - expect[i]) / expect[i];
      max_diff = max (fabs (diff), max_diff);
      //printf ("%d %.17g %.17g\n", i, sm_bessel_i0 (i), diff);
    }
  //kaiser (511, 3.4);
  //kaiser (1024, 3.4);
  printf ("# sm_bessel_i0: max_diff = %.17g\n", max_diff);
  assert (max_diff < 1e-14);
}
