// vim: colorcolumn=80 ts=4 sw=4

#pragma once 

#include <gtk/gtk.h>

#include "common.h"

typedef enum {
	GFI_LIST_ITEM_ACTION_BUTTON_TYPE_REMOVE,
	GFI_LIST_ITEM_ACTION_BUTTON_TYPE_UPGRADE,
	GFI_LIST_ITEM_ACTION_BUTTON_TYPE_CUSTOM
} GfiListItemActionButtonType;

#define GFI_TYPE_LIST_ITEM gfi_list_item_get_type()
G_DECLARE_FINAL_TYPE (GfiListItem, gfi_list_item, GFI, LIST_ITEM,
		GtkWidget)

/* Method declarations */

GtkWidget *		gfi_list_item_new (void);
void			gfi_list_item_set_label (GfiListItem *self, const char *text);
void			gfi_list_item_set_icon_name (GfiListItem *self,
		const char *icon_name);
void			gfi_list_item_set_app_desc (GfiListItem *self, const char *text);
void			gfi_list_item_set_action_button_text (GfiListItem *self,
		GfiListItemActionButtonType type, const char *text);
void			gfi_list_item_set_parent_list_item (GfiListItem *self, GtkListItem *item);
GtkListItem *	gfi_list_item_get_parent_list_item (GfiListItem *self);
GfiListItemActionButtonType
				gfi_list_item_get_action_button_type (GfiListItem *self);
