/* matrixgl - Cross-platform matrix screensaver
 *
 * Copyright (C) 2003 Alexander Zolotov, Eugene Zolotov
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, 2014 Vincent Launchbury
 *
 * See AUTHORS for a full list of contributors.
 *
 * -------------------------------------------
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
 */

#ifndef MATRIX_IMAGES_H
#define MATRIX_IMAGES_H

/* Image data for 3D images and credits. Each set of 6300 characters represents
 * Z values for each of the 90*70 on-screen characters.
 *
 * Tips for creating a new image:
 *    - Z-values must be in the range 0-255, higher numbers being further back
 *    - In the GIMP, if you set an image to indexed mode, scale it to 90x70
 *    pixels and export to a .h file, the header_data[] array will contain the
 *    Z-values. Setting to grayscale may be required.
 *    - The image should smoothly merge to 0's at the left/right edges, so that
 *    it works with the widescreen additions. In the GIMP, inverting an image
 *    could help with this.
 *    - Most photos/images will translate extremely poorly, because of the low
 *    resolution. The images below were very extensively modified before being
 *    exported, and most images just don't work.
 *
 * To add a new image (without messing up the credits):
 *    - Add the new data just BEFORE the first credit image (search for #C1)
 *    - Increment num_pics in src/matrix.c
 *
 *  If you make something cool, send a patch to <vincent@doublecreations.com>!
 */
unsigned char pic[]={

/* #1: Neo, Morp, Trin pose (redone by Vince) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,6,11,
18,22,24,25,24,22,17,9,3,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,3,2,2,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,4,24,52,91,118,154,176,192,195,192,176,150,97,49,11,
0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
0,4,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,38,127,200,255,255,
255,255,255,255,255,254,250,216,172,91,42,30,20,7,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,13,59,156,244,255,254,255,255,255,255,254,253,253,253,253,255,252,
225,189,146,83,34,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,29,112,199,248,252,255,255,254,
255,255,254,255,254,254,254,255,254,253,244,236,231,200,130,38,3,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,4,9,8,4,0,0,3,5,5,3,2,2,2,2,2,9,
25,59,142,234,240,247,255,255,254,255,255,255,255,254,255,255,255,255,254,253,
249,238,237,242,225,142,31,3,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,17,55,76,70,59,48,33,
18,13,12,8,4,1,2,6,14,39,100,201,255,253,253,255,255,254,255,255,
255,255,255,255,255,255,255,254,255,255,255,254,254,254,255,245,109,12,3,0,
0,0,0,0,0,0,0,2,14,25,19,9,5,2,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,33,98,143,153,147,158,153,139,111,93,97,104,104,95,69,32,42,56,
126,239,251,250,250,255,255,255,255,255,255,255,255,255,255,255,255,255,254,255,
254,252,252,252,252,255,212,23,6,0,0,0,0,0,0,0,6,37,67,88,
75,54,42,39,39,41,38,21,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,52,139,181,179,174,184,207,209,212,
223,231,239,249,254,249,213,126,68,87,180,252,249,250,251,254,255,255,255,255,
255,255,255,255,255,255,255,255,255,254,254,252,252,253,253,253,253,79,14,3,
0,0,0,0,0,3,45,100,105,96,84,76,71,71,75,85,92,79,42,3,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
66,169,214,206,204,208,220,220,211,191,185,216,224,225,236,241,244,217,140,157,
223,252,250,251,253,254,255,255,255,255,255,255,255,255,255,255,254,255,255,254,
253,253,253,252,253,252,252,182,51,9,4,4,3,2,8,47,96,102,87,78,
69,61,57,54,50,51,61,78,86,45,3,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,4,70,182,232,227,231,235,236,239,212,186,180,
185,211,222,220,227,242,242,243,227,210,223,247,251,251,253,253,255,254,255,255,
255,254,255,255,255,255,255,254,254,253,253,254,253,253,253,250,243,243,89,14,
10,9,8,19,60,103,110,93,80,76,69,62,57,54,53,52,54,55,68,80,
46,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,98,189,
237,234,233,238,238,238,228,187,164,191,211,226,235,235,224,238,244,234,220,218,
215,241,253,252,253,252,254,255,255,255,255,255,255,255,255,254,254,254,253,252,
253,254,253,254,253,247,239,249,117,26,10,9,26,75,111,110,103,88,81,76,
66,61,61,55,53,52,54,55,56,60,72,29,0,0,0,0,0,0,0,0,
0,0,0,0,0,14,73,141,202,240,236,238,243,247,247,249,227,191,182,211,
231,232,237,242,240,240,241,228,225,222,214,235,251,253,254,253,253,254,254,254,
254,253,247,243,242,243,247,251,254,254,254,254,253,253,250,245,238,243,170,65,
31,38,91,127,117,103,97,89,80,74,66,61,58,52,50,50,51,52,54,56,
59,58,5,0,0,0,0,0,0,0,0,0,0,0,30,118,196,217,234,227,
228,242,248,249,251,254,228,197,207,225,242,244,242,248,248,242,239,233,228,228,
226,232,245,249,252,254,254,253,252,252,252,252,246,240,239,242,243,245,245,248,
250,251,249,249,247,247,240,238,214,101,75,130,154,141,120,99,92,89,77,73,
65,59,53,48,45,44,44,46,47,52,58,58,38,2,0,0,0,0,0,0,
0,0,0,18,103,209,232,237,237,219,230,242,243,247,247,242,223,204,215,233,
243,250,252,253,253,244,245,244,230,237,246,240,242,246,248,251,252,251,249,249,
250,250,246,243,244,247,247,243,241,239,239,241,243,244,244,245,242,241,231,115,
131,188,169,144,120,100,92,87,77,72,65,60,52,44,39,38,39,40,41,45,
53,60,61,30,0,0,0,0,0,0,0,0,4,40,180,228,228,243,233,217,
227,237,245,251,242,222,218,222,233,244,249,252,254,254,254,247,244,243,235,240,
250,249,246,248,248,249,249,249,250,247,245,244,242,245,247,248,247,243,242,242,
239,239,239,240,241,241,241,247,232,148,182,197,170,145,117,101,95,87,78,74,
66,59,49,38,34,33,34,34,36,39,48,57,62,53,2,0,0,0,0,0,
0,0,1,69,219,238,234,244,226,217,228,236,251,250,223,194,209,234,244,250,
254,254,254,254,254,246,233,236,238,241,252,250,247,247,250,247,245,245,247,245,
242,237,243,250,248,247,250,247,244,245,245,244,242,238,239,235,236,245,235,193,
208,197,172,148,120,103,98,88,78,75,66,55,44,36,34,31,30,31,31,34,
41,52,61,69,33,1,0,0,0,0,0,0,16,87,175,235,241,243,227,224,
234,241,240,203,150,142,192,237,249,252,253,254,254,255,254,243,232,232,242,237,
213,196,202,222,238,243,240,237,232,226,227,230,240,246,243,246,251,250,248,244,
243,245,245,238,235,233,234,241,238,220,215,197,175,152,128,108,100,90,79,74,
61,48,39,33,31,30,29,29,29,31,38,49,55,61,84,19,0,0,0,0,
0,4,39,91,227,253,250,246,238,234,238,228,175,103,64,73,133,205,245,255,
255,254,254,253,254,244,236,234,231,181,108,83,96,130,179,224,235,225,197,165,
162,184,208,228,229,229,238,246,248,244,242,243,244,243,236,228,228,236,239,227,
213,199,181,158,136,115,102,87,78,70,51,39,33,31,31,31,30,33,35,32,
43,50,51,51,60,68,4,0,0,0,0,23,42,226,255,255,255,249,243,234,
239,217,118,35,27,39,69,124,181,221,244,255,255,253,252,242,233,226,184,78,
27,16,22,43,90,154,203,196,140,90,86,107,134,164,182,190,203,218,231,237,
242,244,245,248,243,228,221,236,240,228,214,201,188,169,144,124,108,86,73,60,
43,33,29,30,34,38,44,49,43,35,48,50,51,51,51,68,19,0,0,0,
2,29,132,255,255,255,255,244,195,154,216,238,163,76,36,22,26,51,94,133,
157,190,226,249,252,242,233,212,104,20,7,4,8,19,41,81,125,124,80,53,
56,71,83,100,126,148,162,177,196,216,236,246,247,250,249,240,232,236,236,229,
221,206,191,175,150,129,113,90,70,49,38,33,29,31,37,42,52,59,51,43,
49,50,51,51,51,52,47,1,0,0,1,28,241,255,255,255,254,213,129,57,
146,241,233,189,150,119,102,95,103,109,103,106,142,202,243,244,232,178,38,8,
6,4,8,19,31,46,59,62,52,48,53,62,69,81,100,120,134,146,163,193,
231,244,243,246,246,243,242,240,230,230,228,217,198,180,156,132,113,95,76,57,
49,42,39,40,44,45,50,54,53,48,50,51,51,51,51,51,53,2,0,0,
0,20,251,255,255,255,244,143,121,28,75,189,255,247,229,204,200,199,188,183,
178,171,164,193,229,245,233,133,14,6,6,8,13,20,29,36,43,45,45,53,
61,66,73,84,95,107,115,125,141,174,219,236,235,239,244,240,232,233,232,232,
229,221,205,184,166,142,121,100,80,71,68,61,57,62,63,58,57,57,55,58,
63,51,51,51,51,51,51,1,0,0,0,20,247,253,253,252,226,96,148,43,
46,105,200,241,243,232,224,223,210,197,182,164,152,175,225,246,234,113,11,8,
10,13,18,25,32,43,49,49,52,62,67,73,84,91,95,103,107,115,131,163,
202,224,231,238,239,236,234,228,234,237,230,215,201,186,172,153,134,108,78,64,
70,72,68,72,71,66,69,72,75,83,93,59,51,51,51,51,51,1,0,0,
0,22,243,253,253,252,227,86,166,71,44,62,114,174,195,199,223,246,225,169,
117,97,101,130,168,212,232,117,11,11,16,21,26,34,42,55,58,58,68,79,
82,89,100,101,101,104,105,112,125,154,194,219,232,237,235,232,237,242,211,208,
224,212,195,184,176,160,141,119,81,60,59,62,62,56,57,67,73,76,79,76,
79,54,51,51,51,51,50,2,0,0,0,21,244,253,253,252,227,85,166,103,
47,54,67,100,129,151,167,181,188,192,200,181,132,107,109,145,213,133,13,16,
24,29,33,46,58,70,77,76,86,95,100,110,116,114,106,102,107,113,122,146,
183,213,231,235,230,236,247,232,122,116,200,207,190,184,178,169,147,117,83,58,
48,43,42,41,43,53,61,58,50,43,40,50,51,51,51,51,50,4,0,0,
0,5,236,253,253,252,227,82,145,131,53,54,59,65,71,83,101,110,122,159,
197,191,136,95,82,97,188,158,14,16,29,38,44,63,83,90,97,100,99,105,
118,126,125,118,110,109,112,111,116,138,173,208,224,233,239,246,245,156,95,131,
196,202,187,180,178,172,149,113,77,60,52,47,39,37,39,42,44,39,34,32,
35,51,51,51,51,51,50,5,0,0,0,0,167,253,253,253,251,128,129,157,
93,59,66,69,78,89,116,160,198,206,178,158,147,129,82,82,170,169,17,15,
30,38,46,66,87,96,102,100,104,116,128,129,122,114,114,113,113,109,113,128,
152,183,215,232,241,220,169,137,104,104,174,200,183,173,175,167,135,105,71,55,
54,63,66,47,37,37,39,43,39,40,65,55,51,51,51,52,49,6,0,0,
0,0,60,253,253,253,251,204,144,155,153,92,80,95,134,184,227,237,222,213,
217,226,227,224,163,139,149,164,16,12,28,39,44,56,74,87,98,100,102,116,
125,119,114,114,113,112,113,109,107,109,116,133,175,224,237,211,148,112,101,89,
143,196,181,166,171,168,135,109,87,78,71,56,67,80,72,63,72,74,74,90,
98,66,52,51,55,82,49,4,0,0,0,0,20,222,252,253,249,233,234,231,
220,164,109,121,181,216,215,230,247,250,250,249,244,242,229,106,73,126,34,8,
23,31,36,45,61,79,98,94,94,109,112,103,105,105,99,99,99,97,93,92,
96,100,127,198,225,207,148,164,187,126,129,194,180,169,175,178,177,186,192,195,
182,159,152,152,153,150,156,156,165,168,147,149,174,185,194,157,47,2,0,0,
0,0,7,154,251,249,237,229,226,215,234,222,149,123,165,205,239,253,253,251,
250,251,243,238,220,75,66,92,30,7,16,24,29,43,57,72,87,75,77,92,
102,97,97,93,98,109,111,107,94,80,79,87,108,164,219,164,131,152,170,160,
140,191,175,157,182,202,197,171,163,184,217,241,246,245,238,208,182,196,233,245,
236,222,226,226,194,157,36,2,0,0,0,0,0,75,209,234,228,237,240,243,
238,241,225,191,210,245,252,249,247,248,249,248,239,235,166,74,70,93,42,15,
20,27,37,55,61,80,93,79,86,102,111,100,99,120,153,172,182,188,172,134,
103,87,91,128,203,137,91,129,143,142,162,196,176,158,155,199,222,211,221,244,
240,233,235,247,245,177,115,173,240,234,231,237,244,254,255,182,23,7,0,0,
0,0,0,13,160,237,233,236,241,240,246,238,209,208,236,243,243,246,246,247,
247,245,239,181,94,76,105,112,83,90,93,70,57,75,91,112,129,121,136,135,
125,132,170,200,217,233,243,243,242,230,205,140,78,102,177,128,70,103,133,112,
183,210,185,146,118,143,206,251,255,252,238,225,227,242,234,137,79,167,236,232,
225,226,237,248,255,201,17,8,0,0,0,0,0,0,32,181,227,238,240,240,
243,232,152,115,194,242,239,240,244,242,241,235,179,99,81,91,178,222,215,202,
193,186,168,143,144,168,164,152,175,184,184,198,224,248,255,252,245,247,249,247,
243,181,74,95,150,116,91,123,103,97,203,223,191,150,116,93,147,247,252,251,
242,230,231,236,224,168,122,161,221,234,234,233,243,252,255,170,12,7,0,0,
0,0,0,0,6,58,145,209,231,234,236,217,156,96,113,173,211,227,229,219,
206,167,106,95,89,83,120,201,204,211,246,252,246,245,240,226,168,158,197,211,
227,255,255,255,252,250,250,250,248,247,227,146,82,90,93,86,109,134,93,128,
221,231,203,165,124,104,127,231,254,252,246,240,244,239,186,91,21,62,182,239,
241,249,253,248,215,131,10,7,0,0,0,0,0,0,1,5,27,78,158,199,
195,166,96,48,65,97,128,147,147,131,105,85,89,96,99,94,79,145,208,202,
230,246,255,254,245,229,182,153,186,236,255,254,253,252,251,251,251,250,249,240,
183,105,88,87,79,92,112,118,104,175,236,237,218,186,153,135,136,188,243,249,
247,243,232,180,111,76,41,31,98,180,216,224,220,196,146,129,9,8,0,0,
0,0,0,0,0,3,6,20,44,76,98,103,65,27,40,70,101,103,78,66,
66,75,91,103,107,97,78,70,147,199,223,240,247,248,249,233,160,111,154,222,
249,253,253,252,253,253,253,249,238,190,121,98,94,92,82,94,118,118,131,219,
245,236,225,204,177,166,157,156,182,210,218,214,179,115,86,65,32,21,45,109,
137,126,111,120,152,102,4,0,0,0,0,0,0,0,0,1,4,14,37,44,
50,62,49,30,41,57,93,112,81,62,71,86,101,112,108,97,80,64,57,134,
201,231,243,248,246,200,97,70,116,183,229,244,249,250,250,247,239,221,180,128,
111,104,98,93,81,96,138,125,167,243,244,236,227,217,193,173,155,132,129,133,
145,165,152,109,89,53,24,20,36,92,110,89,91,117,162,42,0,0,0,0,
0,0,0,0,0,0,2,4,24,60,60,61,51,45,65,98,126,104,65,57,
71,89,101,106,106,96,82,70,51,39,106,164,203,216,208,141,52,45,91,143,
183,209,220,219,217,212,194,165,136,131,126,119,111,102,88,95,134,144,193,245,
242,238,227,220,203,185,159,136,128,123,134,160,130,78,85,72,36,34,47,84,
134,133,131,148,181,5,0,0,0,0,0,0,0,0,0,0,1,2,9,49,
66,56,50,71,114,146,135,79,43,46,65,84,94,96,93,86,78,73,65,40,
33,68,106,119,118,78,30,42,86,124,146,162,171,166,160,163,160,156,153,150,
143,131,124,115,100,104,137,186,236,246,243,239,229,218,211,198,170,151,149,139,
130,119,128,151,151,135,105,99,113,111,111,122,146,173,136,0,0,0,0,0,
0,0,0,0,0,0,0,2,5,27,62,45,30,58,109,116,78,50,44,53,
65,75,79,81,81,75,74,79,83,77,46,43,42,47,60,43,23,44,85,115,
134,149,155,149,140,142,153,159,158,159,149,137,133,125,113,128,173,225,245,240,
243,239,228,216,211,206,189,171,155,127,98,78,107,172,198,204,201,187,160,106,
70,82,137,178,35,0,0,0,0,0,0,0,0,0,0,0,0,1,4,16,
49,43,33,47,77,89,80,75,78,92,93,77,68,71,71,71,77,90,112,115,
60,33,39,51,69,48,20,40,79,106,123,144,163,156,143,138,145,151,157,157,
149,143,138,127,127,159,207,238,243,235,242,242,228,216,209,207,201,182,155,122,
96,77,77,97,126,160,186,168,120,76,62,84,138,169,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,3,9,30,51,75,105,122,132,140,144,142,132,
117,93,77,74,71,76,88,119,134,123,82,30,41,62,89,47,10,39,79,96,
96,119,166,175,158,149,147,147,150,152,151,148,141,134,150,192,228,244,242,233,
236,244,232,217,208,206,205,190,165,144,126,99,80,84,98,110,113,110,106,93,
95,120,153,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
14,50,97,143,158,159,156,159,152,128,113,97,88,84,81,89,120,149,131,118,
99,43,33,70,98,43,14,58,98,108,104,116,155,183,178,162,151,146,146,150,
152,148,147,157,185,218,240,244,241,235,231,242,238,221,208,203,204,199,179,169,
166,154,147,161,170,167,156,156,166,171,169,163,175,59,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,9,39,70,109,139,147,145,141,126,107,
95,85,89,95,101,123,157,149,124,117,106,63,27,66,81,43,37,99,148,166,
173,166,156,165,182,175,158,149,146,151,154,155,165,186,217,236,245,244,240,237,
231,233,241,231,210,203,204,203,190,180,186,198,205,196,176,168,168,157,161,180,
182,172,185,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,26,53,67,95,110,111,103,87,74,73,77,93,111,139,164,167,141,125,119,
110,76,38,53,49,30,44,111,180,205,206,188,162,152,168,180,170,155,149,157,
166,173,189,216,240,247,247,244,240,237,232,227,235,241,220,208,206,205,198,183,
176,176,178,169,150,142,144,140,141,146,147,163,160,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,9,33,46,52,53,53,52,52,57,
72,91,119,151,176,177,159,135,123,121,114,90,56,43,35,28,43,93,170,193,
185,169,164,167,168,178,179,164,157,167,178,190,213,238,250,250,248,245,242,237,
233,227,226,238,237,218,206,207,207,190,173,163,164,168,172,174,178,174,167,160,
157,169,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,7,26,45,52,49,57,73,87,107,134,167,190,187,172,151,130,122,115,
105,93,66,42,39,35,38,73,141,152,154,153,160,178,192,190,181,170,165,176,
186,208,236,250,251,248,246,246,244,239,235,232,226,227,237,234,211,205,210,200,
186,184,184,179,184,193,196,187,172,177,181,172,169,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,6,30,71,97,112,128,143,
161,178,193,194,181,164,146,130,114,112,141,148,105,53,71,93,100,134,160,164,
185,197,207,211,216,212,190,175,176,184,198,229,249,252,251,247,245,245,244,240,
237,235,230,225,230,245,228,207,204,201,193,192,189,180,165,154,153,158,162,174,
179,178,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,8,50,105,136,156,168,169,174,184,182,172,158,144,127,135,192,
226,220,183,118,88,88,110,178,208,219,232,235,225,213,205,202,197,187,186,194,
219,247,253,252,250,246,245,243,241,240,237,234,232,234,239,246,244,228,211,203,
191,184,173,153,134,128,128,129,141,158,167,198,177,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,24,86,126,139,149,
140,148,162,167,162,156,138,149,218,228,165,113,103,107,77,47,65,107,148,177,
189,193,196,193,183,184,195,193,193,207,239,253,251,250,247,244,243,241,239,240,
237,236,239,246,246,244,245,246,235,216,195,180,170,155,150,157,157,149,154,159,
189,218,155,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,13,71,117,124,121,109,123,141,150,154,148,165,219,216,122,
61,41,39,52,50,45,60,94,142,167,179,191,196,189,182,189,200,200,204,228,
251,253,249,248,246,243,241,239,239,238,237,245,249,250,248,249,244,243,248,242,
222,200,189,187,184,181,184,190,189,192,228,234,150,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,63,110,119,105,
89,103,126,138,143,165,224,224,101,49,41,38,37,38,40,36,65,126,187,211,
215,218,210,195,191,196,198,203,223,247,254,253,248,245,243,240,239,237,237,241,
247,252,252,251,250,250,247,242,244,251,248,238,229,226,225,225,227,231,226,226,
244,247,175,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,12,59,102,113,98,76,88,112,125,154,221,218,103,40,40,
43,41,40,39,43,71,57,82,139,175,186,194,194,187,189,193,197,219,245,253,
252,250,245,242,240,238,237,236,243,250,252,253,253,252,251,251,249,245,242,245,
252,252,249,249,249,239,233,241,237,236,245,252,222,63,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,50,92,109,101,
80,83,92,139,203,167,70,29,33,39,43,42,40,44,111,169,81,39,67,106,
136,158,165,172,183,194,213,241,253,252,249,244,242,239,236,233,236,242,251,250,
249,250,250,251,250,247,246,242,239,238,244,252,252,251,246,233,236,245,236,234,
243,251,251,203,79,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,8,44,86,112,111,85,57,114,185,113,40,22,25,32,37,
37,47,76,132,196,223,138,51,76,122,145,162,175,187,197,214,239,253,253,249,
245,241,236,233,229,230,242,248,248,244,242,242,241,240,240,241,241,239,238,239,
241,247,252,252,251,250,249,243,233,230,241,251,252,237,200,19,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,48,88,115,118,
66,102,177,96,31,24,27,28,31,53,125,162,175,198,220,238,219,97,116,160,
173,190,205,214,222,232,246,252,250,246,242,237,231,227,228,240,249,247,243,239,
235,234,234,231,234,234,232,233,233,235,239,243,248,250,245,239,243,239,230,222,
235,250,251,248,225,137,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,14,48,87,112,92,113,171,119,36,23,24,28,36,83,187,
201,193,204,216,228,238,241,140,75,148,204,221,226,209,192,214,247,253,246,242,
236,231,224,222,235,247,245,240,236,232,230,230,232,230,225,228,230,230,233,235,
239,242,243,246,233,194,194,225,228,221,228,246,251,249,238,214,66,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,72,89,109,132,
166,125,35,18,20,22,57,142,228,220,195,202,213,222,235,244,253,212,64,45,
116,184,188,172,167,211,249,246,239,232,225,219,221,234,245,239,231,228,229,228,
228,228,228,225,225,227,228,228,231,236,237,240,242,239,224,186,178,220,234,221,
219,241,251,250,248,234,174,17,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,16,95,115,102,140,156,144,47,13,18,19,21,76,144,130,146,
202,203,218,231,236,242,250,234,127,71,103,145,167,152,165,227,245,235,229,224,
218,216,230,241,235,225,221,223,224,225,226,227,226,227,225,225,225,227,228,230,
232,233,235,235,224,190,180,223,243,226,215,229,248,251,249,249,241,190,22,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,123,170,175,159,163,
85,22,19,20,20,23,22,22,36,125,188,163,201,226,230,243,241,214,139,64,
95,106,129,131,186,234,229,225,221,217,215,203,199,218,220,220,222,223,224,226,
227,230,228,228,229,228,226,226,226,227,228,230,230,236,239,204,180,218,246,230,
214,219,242,248,253,254,254,252,164,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,20,93,167,200,177,156,151,59,18,21,22,23,24,23,26,53,156,
204,182,208,222,238,234,212,193,101,48,109,102,106,155,213,221,219,214,212,212,
225,202,170,203,218,221,225,228,231,231,233,237,235,235,232,230,228,224,224,226,
226,228,229,233,237,208,177,207,247,242,221,215,239,240,254,255,255,254,232,3,

/* #2: Neo Guns (By Alex) */
0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,9,23,29,29,29,29,29,30,29,28,
28,27,28,28,29,29,28,27,27,27,27,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,27,29,28,28,29,30,29,29,28,29,30,30,30,29,10,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
18,26,28,28,29,31,33,32,31,29,28,28,26,28,28,27,27,27,28,28,
29,29,28,27,27,28,28,28,28,28,28,26,26,26,28,28,28,27,27,28,
28,28,28,28,28,29,28,28,25,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,2,8,18,28,34,36,33,30,36,68,86,34,29,
29,28,27,27,26,27,27,27,28,28,28,28,28,27,27,27,28,27,28,28,
26,26,26,26,28,26,26,26,26,26,26,26,26,26,28,29,26,26,21,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,10,16,23,30,
37,46,57,67,59,56,121,169,115,38,28,28,26,26,27,28,28,28,28,28,
28,28,28,28,28,27,27,27,28,28,26,25,25,25,28,28,25,26,26,25,
25,28,28,28,28,28,25,26,19,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,7,18,25,28,29,33,75,127,167,185,182,186,167,183,189,152,92,
40,31,28,28,28,28,28,28,28,28,28,28,28,28,28,26,26,26,28,28,
26,25,25,26,26,26,26,26,26,28,26,28,28,28,26,28,25,26,18,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,7,9,18,21,27,29,43,110,117,127,179,
177,186,195,200,202,198,176,200,200,169,83,55,30,28,28,25,25,26,26,26,
26,26,28,28,28,26,26,26,26,26,26,25,25,25,25,25,25,25,26,28,
26,25,25,26,25,26,25,26,20,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,28,32,
32,46,60,73,117,161,195,204,206,206,201,206,208,210,210,208,198,206,202,198,
177,99,42,28,28,25,25,25,25,25,25,25,26,26,26,25,25,25,26,26,
25,25,25,25,25,25,25,25,25,26,25,25,25,25,24,25,25,26,21,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,23,31,31,50,86,121,174,183,203,207,210,210,203,212,
208,211,210,208,208,200,200,208,207,196,194,121,61,29,25,25,25,26,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,25,25,26,
25,25,25,25,25,25,25,25,23,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,31,31,41,97,
137,174,206,210,211,213,212,211,211,211,212,211,211,210,210,200,194,210,207,191,
196,132,55,33,24,25,28,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,25,25,25,25,25,26,25,25,26,25,25,25,24,28,24,25,25,24,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,21,31,33,38,96,186,208,210,212,213,212,212,215,215,215,
215,215,212,212,212,202,203,210,204,194,152,144,97,73,30,41,28,22,23,24,
25,24,24,23,23,23,23,23,24,24,24,24,24,25,26,26,26,26,25,25,
25,24,24,24,26,26,25,25,24,4,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,28,31,38,91,182,
204,210,210,210,211,212,215,215,215,215,215,215,212,212,212,200,204,212,206,198,
136,133,99,108,71,45,33,26,24,23,25,24,23,23,23,23,23,23,24,24,
24,24,24,24,25,25,25,25,25,25,25,24,24,24,25,25,25,26,25,8,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,9,27,30,58,171,206,207,211,211,212,215,211,211,215,215,215,
215,215,212,212,211,211,212,211,211,194,172,124,137,175,119,90,68,37,25,22,
23,23,23,23,23,23,23,23,24,24,24,24,24,24,25,25,24,24,25,25,
25,24,24,23,25,25,25,25,25,14,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,2,20,29,42,101,198,210,
211,211,212,212,215,215,212,215,215,215,215,215,215,212,211,211,212,213,212,206,
185,172,169,194,172,174,107,53,31,23,23,23,23,23,23,24,23,23,23,25,
24,24,24,25,26,26,25,25,25,25,25,25,24,24,24,24,24,24,24,20,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,5,26,29,48,163,207,211,211,212,212,215,215,212,215,215,215,215,
215,215,215,215,211,211,212,212,213,207,201,194,189,198,206,194,128,67,33,33,
23,23,23,23,23,24,23,23,23,23,24,24,24,24,25,25,24,24,24,24,
24,24,23,23,24,24,24,24,24,22,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,19,28,31,89,206,211,211,
212,212,215,215,213,213,215,213,213,213,213,215,213,213,211,211,210,210,210,207,
206,201,176,206,210,195,152,112,56,36,23,23,22,22,22,23,23,23,23,23,
23,24,23,23,24,24,23,24,23,23,23,23,23,23,24,23,24,24,24,24,
9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,25,29,34,143,211,211,212,215,215,215,215,213,213,211,211,212,212,
213,213,212,212,210,210,207,203,203,206,198,202,194,186,194,194,181,132,98,38,
28,23,22,21,22,23,23,23,23,24,24,23,23,23,23,23,24,25,23,23,
23,23,23,23,24,23,23,24,25,24,15,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,11,29,32,38,176,210,212,215,
215,215,215,215,215,212,207,207,206,206,206,207,210,204,207,206,200,189,170,185,
191,200,207,204,195,206,201,185,122,89,39,25,21,21,22,23,23,23,23,24,
23,23,23,23,23,23,24,25,23,23,23,23,23,23,24,23,23,24,24,23,
19,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,18,28,30,44,198,211,213,215,215,215,215,215,212,207,198,195,187,191,
192,185,170,159,165,169,168,132,106,139,174,189,203,203,203,204,201,171,149,134,
89,48,21,21,21,22,23,23,23,23,23,23,23,23,23,23,24,24,23,23,
23,23,23,23,23,23,23,23,23,23,20,12,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,24,28,29,73,210,211,212,215,
215,215,215,213,206,198,194,185,174,172,168,159,137,111,91,86,89,49,28,41,
79,121,167,191,201,207,203,189,179,135,110,76,25,21,21,22,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
21,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,24,26,30,113,210,211,213,215,215,215,215,213,198,189,191,176,169,163,
159,139,105,70,41,31,34,28,17,18,18,29,62,159,195,201,200,179,181,141,
76,49,23,21,21,22,23,23,22,22,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,21,17,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,28,28,31,143,210,211,213,213,
216,215,213,208,194,183,179,164,164,163,158,133,89,66,40,25,20,19,14,10,
5,8,17,69,168,187,182,136,174,155,65,44,20,20,21,21,21,21,21,21,
21,21,21,21,21,22,23,23,23,23,23,23,23,22,23,23,23,23,23,23,
21,18,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,28,29,35,176,210,211,213,213,216,215,212,206,189,174,168,161,159,157,
152,140,96,62,44,28,18,17,10,5,3,4,9,15,123,177,181,170,177,144,
57,33,20,21,21,21,21,21,21,21,21,21,21,21,21,22,23,23,23,23,
23,23,23,22,23,23,23,23,23,23,21,18,4,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,26,28,45,198,210,211,212,213,
215,212,207,200,181,165,158,156,154,154,153,145,117,67,42,26,17,15,7,5,
3,3,8,9,70,169,167,181,144,131,42,21,19,22,21,21,21,21,21,21,
21,21,21,21,21,22,23,23,23,23,23,23,23,22,23,23,23,23,23,23,
21,18,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,25,24,66,206,210,211,213,213,212,213,206,194,172,163,163,155,155,154,
159,150,131,83,47,28,17,14,8,7,4,5,3,7,46,123,141,169,131,84,
23,21,20,20,21,20,20,20,21,21,21,21,22,21,21,22,23,23,22,22,
22,23,23,23,23,23,23,23,23,23,21,18,9,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,25,24,83,206,211,212,215,215,
215,212,206,189,169,161,159,159,159,156,159,155,136,82,59,41,24,20,13,8,
6,5,4,5,35,99,128,160,114,32,21,19,21,20,21,20,20,20,21,21,
21,21,22,21,21,22,23,23,22,22,22,23,23,23,23,23,23,23,23,23,
21,18,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,25,28,108,210,213,212,215,216,215,210,201,185,170,160,160,160,159,160,
156,150,132,72,41,44,26,23,14,12,5,2,3,5,28,97,130,143,100,28,
20,20,19,19,20,20,20,20,21,21,21,21,21,21,21,22,22,21,21,21,
21,22,22,22,22,22,22,22,22,22,20,17,14,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,25,28,131,185,208,213,215,212,
207,187,168,164,160,160,163,160,159,159,155,145,112,62,32,36,26,18,10,8,
3,2,3,5,28,101,137,149,59,25,18,19,20,19,21,20,20,20,21,21,
21,21,21,21,20,21,22,21,21,21,21,21,21,21,21,21,21,21,21,21,
19,16,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,24,28,149,168,179,208,215,213,191,158,152,152,156,159,163,161,161,160,
153,139,90,58,28,24,31,20,8,3,2,2,3,5,32,126,116,106,47,21,
20,18,20,20,22,20,20,20,21,21,21,21,21,21,20,21,22,21,21,21,
21,20,20,20,20,20,20,20,20,20,18,16,13,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,23,28,164,156,168,186,210,210,
185,152,154,158,163,171,174,168,168,163,158,134,83,63,35,21,33,23,8,4,
2,2,5,5,41,135,69,44,25,17,19,18,20,20,20,20,20,20,21,21,
21,20,21,20,20,21,21,21,20,20,20,20,20,20,20,20,20,20,20,20,
17,15,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,23,41,161,163,167,185,210,206,172,176,179,203,210,213,213,210,204,194,
168,131,121,109,46,23,28,22,12,5,2,2,5,7,65,149,42,23,20,18,
19,19,20,20,20,20,20,20,21,21,21,20,21,21,21,21,21,21,20,20,
20,20,20,20,20,20,20,20,20,20,17,15,13,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,2,22,54,168,195,196,177,206,196,
154,163,206,212,213,215,216,212,213,213,203,140,140,147,75,57,36,41,18,10,
3,2,6,6,101,140,25,20,20,18,18,18,19,19,19,20,20,20,21,21,
21,20,21,22,23,22,21,21,21,21,21,21,21,21,21,21,20,20,20,20,
17,15,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,4,23,71,189,203,186,160,202,185,150,159,206,213,215,216,216,216,215,215,
213,211,195,170,113,64,51,97,49,59,68,75,71,67,131,78,18,21,20,19,
18,18,19,20,19,22,21,20,21,20,22,24,24,34,53,30,21,21,21,21,
21,21,21,21,21,21,19,20,22,21,17,16,14,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,5,23,82,189,186,172,152,191,169,
147,156,200,215,216,218,217,217,216,216,217,218,213,192,169,83,117,177,189,198,
198,192,174,152,167,90,19,22,20,20,23,30,25,24,23,25,25,24,25,26,
31,38,58,109,133,63,23,19,19,19,19,20,20,20,20,20,19,20,23,22,
18,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,5,23,60,165,187,169,146,172,159,146,155,175,210,213,217,217,217,217,215,
219,218,212,207,177,157,181,198,192,211,208,202,191,156,159,121,25,21,20,21,
39,105,92,89,73,77,64,59,69,84,95,119,160,186,181,136,39,19,19,18,
19,19,20,19,19,20,19,23,23,23,19,16,13,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,6,22,37,149,179,182,150,152,149,
146,150,168,189,210,213,216,217,218,217,217,217,210,189,121,89,169,210,210,211,
208,201,194,152,149,81,20,19,28,66,121,174,179,179,185,174,158,158,165,172,
182,194,204,202,182,153,50,20,20,20,20,20,20,20,20,21,20,23,26,35,
25,16,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,5,23,24,119,163,176,155,150,152,149,152,165,169,185,206,215,217,218,217,
216,213,198,159,81,25,122,200,210,210,201,192,171,137,123,31,19,21,52,175,
200,198,195,195,200,194,189,194,194,200,203,206,210,210,177,112,44,28,26,28,
23,23,23,21,22,23,23,28,50,104,74,26,12,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,7,22,21,69,158,168,153,152,156,
155,158,161,164,168,174,187,200,210,208,206,196,168,145,86,22,61,174,207,207,
201,189,158,110,35,17,20,29,114,206,213,211,210,206,204,204,206,207,206,207,
211,210,207,196,176,116,50,107,106,99,59,61,54,44,49,58,66,88,140,177,
148,52,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,8,21,21,24,144,169,153,147,152,153,159,165,168,168,168,170,169,172,176,
175,168,155,144,86,18,26,112,165,176,167,132,65,24,13,16,18,47,169,201,
212,213,212,208,210,210,210,211,211,211,215,212,207,183,159,121,113,179,179,181,
179,175,163,149,159,168,175,183,201,195,174,87,15,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,13,21,23,26,124,158,149,145,150,
156,163,171,170,169,168,168,168,164,169,174,168,157,139,91,15,8,20,28,34,
22,12,6,8,15,19,18,68,185,200,212,216,216,211,216,215,215,213,213,212,
212,216,211,194,149,164,200,189,189,200,208,200,194,196,196,200,206,208,211,200,
175,112,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,12,20,23,28,105,150,140,149,155,161,172,175,174,170,169,168,168,168,175,
177,169,164,144,96,16,14,18,7,5,7,8,5,7,18,19,23,88,176,181,
203,216,212,210,216,212,211,211,213,212,213,218,208,198,168,200,211,210,208,210,
211,210,208,208,210,210,211,210,207,200,173,114,25,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,9,18,21,26,90,153,143,147,155,
163,179,176,174,169,168,169,168,174,183,179,161,159,143,101,16,22,31,12,4,
6,9,6,10,16,17,30,137,179,183,210,213,211,211,212,212,215,216,215,206,
182,164,145,111,144,212,217,216,215,215,213,212,213,213,213,212,211,210,206,193,
167,98,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,10,18,21,24,75,155,146,152,159,168,177,179,169,167,167,169,171,179,186,
179,181,189,159,110,22,20,44,19,8,10,8,7,21,39,48,64,152,175,191,
208,212,213,217,216,215,215,212,207,137,55,40,35,36,122,211,215,215,216,215,
215,215,216,215,213,212,211,210,208,193,138,59,15,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,11,20,23,24,46,139,150,156,161,
169,176,176,171,167,165,168,172,174,176,181,196,189,169,110,76,88,59,26,12,
10,8,23,84,136,152,155,167,169,175,194,206,216,217,216,213,213,210,144,49,
24,21,22,28,111,206,210,213,215,213,215,215,215,212,216,215,212,211,210,188,
132,43,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,11,21,22,22,40,156,159,165,169,172,174,172,171,164,165,171,171,170,172,
182,185,172,134,45,30,23,38,23,8,5,14,62,143,159,158,161,163,167,169,
185,202,212,215,217,215,213,200,71,24,23,23,23,30,143,201,204,210,213,213,
212,212,212,212,212,207,201,194,185,157,83,25,12,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,11,22,22,25,57,152,163,169,176,
174,179,175,171,164,169,174,175,179,185,186,181,130,50,18,12,10,16,16,6,
9,32,107,156,165,164,161,160,165,171,185,200,208,210,203,206,213,200,72,23,
24,23,23,36,159,206,211,217,216,215,213,213,211,212,211,201,123,68,59,45,
25,14,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,11,23,28,73,181,176,159,174,179,179,179,176,169,165,169,179,189,192,186,
185,167,73,45,26,13,8,8,12,8,12,76,144,163,170,174,174,172,176,183,
192,202,206,204,198,206,213,200,77,23,22,32,72,115,186,210,217,216,215,213,
213,210,208,210,206,149,39,13,18,19,16,14,11,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,13,31,106,172,207,176,163,176,186,
181,181,174,169,168,175,189,201,196,195,196,179,128,70,48,23,10,7,10,8,
37,127,160,172,177,181,186,194,200,204,207,210,208,206,200,210,212,194,71,23,
24,112,191,202,210,211,213,213,215,208,185,159,149,198,195,82,17,8,15,17,
15,15,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
4,12,82,132,198,213,172,161,169,187,191,185,176,172,174,185,198,204,208,203,
195,170,146,144,145,117,40,14,10,14,91,152,163,177,187,185,185,194,201,210,
215,212,206,206,206,212,213,202,94,22,40,172,200,200,206,213,213,212,186,145,
110,63,50,164,181,52,17,6,12,16,15,13,7,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,6,19,126,195,216,212,170,168,169,179,
194,187,172,174,179,187,189,186,189,185,165,97,50,48,59,54,48,26,9,51,
140,168,174,183,185,182,182,185,189,198,206,213,216,213,211,206,194,194,103,24,
41,175,196,200,207,215,210,189,116,70,69,44,33,141,171,52,15,5,15,15,
14,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
10,85,191,213,212,211,179,168,169,177,189,189,176,176,182,189,191,186,186,189,
185,159,105,59,31,28,21,20,29,105,160,181,191,194,189,183,182,187,191,191,
194,201,206,204,189,170,88,71,40,19,41,176,206,206,210,215,213,170,89,45,
60,53,44,152,165,39,8,3,11,14,6,4,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,18,65,193,213,213,213,215,191,169,172,177,
181,181,182,181,186,194,195,192,189,194,196,185,168,108,34,23,28,44,97,137,
164,181,194,194,192,189,185,187,194,194,191,191,191,159,97,105,90,26,19,19,
30,155,210,210,212,213,211,183,109,76,98,90,82,171,149,22,5,5,10,3,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,23,62,128,
194,209,213,214,212,217,206,181,177,181,181,177,185,194,194,195,191,185,185,186,
164,116,98,47,51,106,136,132,131,137,156,175,185,189,191,196,194,191,194,195,
195,187,149,80,88,153,131,30,20,22,28,135,210,212,210,213,213,206,170,158,
169,176,152,169,81,12,6,8,4,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,5,37,96,149,192,206,210,212,215,207,205,211,193,185,183,
181,181,185,200,200,192,185,186,185,177,125,57,30,62,168,196,150,139,143,144,
163,176,181,183,185,187,189,191,192,200,200,187,139,109,163,179,100,24,19,22,
25,128,208,210,207,212,208,203,203,204,203,176,110,56,15,9,8,4,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,44,92,141,184,198,
205,210,209,209,210,201,204,204,194,189,185,185,189,200,204,201,195,194,191,187,
154,92,129,194,212,191,146,141,149,157,174,191,191,189,187,189,191,189,191,191,
192,185,170,170,170,112,34,18,19,20,22,105,206,206,204,206,202,195,194,195,
191,144,41,14,10,8,8,4,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,3,36,76,125,168,191,205,209,210,211,208,208,205,202,203,201,194,
187,189,194,202,208,208,206,206,206,211,206,201,216,216,215,179,145,146,155,165,
181,196,198,198,198,198,196,196,194,189,174,160,147,123,95,49,14,17,19,19,
20,75,200,206,206,203,201,194,196,198,185,143,42,16,14,9,10,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,1,2,24,57,99,144,174,195,206,
210,210,211,209,208,206,204,204,205,201,194,191,198,203,206,213,215,217,218,220,
218,217,218,220,212,169,149,150,153,161,174,191,200,206,206,202,200,200,196,189,
145,99,68,33,23,31,16,17,19,20,18,42,171,210,208,206,204,202,202,200,
185,149,53,23,15,10,7,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,1,11,31,71,111,152,180,197,207,210,210,211,211,209,208,208,208,207,207,
205,199,198,206,212,216,218,220,220,220,219,218,220,220,206,163,152,149,157,160,
170,185,191,195,194,191,192,194,187,169,143,81,47,41,53,37,17,19,20,20,
20,22,91,194,206,210,206,203,202,194,176,122,40,21,13,7,7,0,0,0,
0,0,0,0,0,0,0,0,0,0,3,3,18,40,82,120,158,184,198,208,
211,211,212,213,213,211,211,214,215,215,216,211,211,217,217,219,220,220,220,218,
219,219,220,220,194,154,155,152,161,169,181,196,200,198,191,187,185,182,156,107,
100,84,52,38,36,16,16,19,21,22,19,21,30,131,196,200,194,189,187,181,
160,77,23,16,12,7,7,3,0,0,0,0,0,0,0,0,0,0,0,0,
3,4,23,42,85,123,157,186,199,209,213,213,215,216,215,217,217,218,219,218,
218,219,219,219,220,219,220,219,219,219,220,220,219,217,181,156,164,168,168,179,
196,210,210,207,204,202,200,194,165,96,48,32,19,12,14,17,18,21,22,23,
22,23,22,117,198,194,185,185,185,181,169,105,28,18,13,9,7,5,0,0,
0,0,0,0,0,0,0,0,0,0,3,4,21,44,84,127,158,188,203,210,
214,215,216,217,218,218,218,218,218,218,219,219,219,219,220,220,220,220,220,219,
220,221,220,218,194,179,182,183,179,185,198,212,215,213,211,211,210,204,179,111,
65,46,33,33,65,50,29,20,21,21,21,20,29,168,206,203,198,198,200,191,
177,124,46,26,17,14,13,7,0,0,0,0,0,0,0,0,0,0,0,0,
4,4,27,68,125,164,192,203,211,214,215,216,217,217,217,217,218,218,218,219,
219,219,219,220,220,220,220,220,220,219,220,220,220,220,210,198,195,201,200,196,
200,210,216,217,218,217,216,215,207,187,152,108,105,131,198,198,174,105,33,19,
22,21,66,195,210,210,207,200,194,182,161,101,39,19,10,8,9,12,2,0,
0,0,0,0,0,0,0,0,0,0,4,11,57,95,145,176,196,206,213,214,
216,216,216,217,217,218,218,218,219,219,219,219,220,220,220,220,220,220,220,219,
220,220,220,220,217,208,206,212,211,212,211,217,216,218,218,217,219,219,217,210,
150,110,187,210,211,215,213,206,172,95,44,68,187,213,207,203,200,182,159,144,
137,84,23,14,13,13,17,20,3,0,0,0,0,0,0,0,0,0,0,0,
7,29,57,98,136,166,188,201,210,213,215,216,216,217,217,218,218,218,219,219,
219,220,220,220,220,220,220,220,220,220,219,219,220,220,220,217,217,217,217,217,
218,220,219,220,219,218,220,220,220,216,176,160,210,217,217,213,215,213,211,210,
164,189,215,217,212,206,200,187,176,165,165,121,30,19,20,26,31,28,6,0,
0,0,0,0,0,0,0,0,0,0,8,22,39,74,102,140,162,187,200,209,
213,215,217,217,218,218,218,219,219,218,220,219,219,220,220,220,220,220,220,220,
220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
219,219,220,218,216,206,204,208,211,212,212,220,220,218,216,211,206,206,198,191,
185,140,47,26,23,32,23,15,8,0,0,0,0,0,0,0,0,0,0,0,
10,18,31,62,83,129,146,181,193,208,213,215,217,217,218,218,219,219,219,220,
220,219,219,219,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
220,220,220,220,220,220,220,220,220,220,220,216,219,217,212,211,215,215,215,217,
220,220,216,219,217,216,216,213,212,208,198,158,109,61,30,58,14,15,13,0,
0,0,0,0,0,0,0,0,0,0,11,19,33,63,85,129,146,178,191,206,
211,214,216,217,217,218,218,219,219,219,220,219,219,219,220,220,220,220,220,220,
220,220,220,220,220,220,220,221,221,220,220,220,220,220,220,220,220,220,222,220,
220,215,220,210,212,220,220,220,220,220,217,220,219,219,219,217,218,216,216,213,
198,170,168,111,102,150,26,18,16,0,0,0,0,0,0,0,0,0,0,0,
12,19,31,58,81,118,142,170,188,202,210,212,215,217,217,218,218,219,218,218,
219,219,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
220,220,220,219,220,220,220,220,220,220,220,212,217,216,219,220,220,220,220,220,
220,220,220,219,219,218,216,215,215,206,181,130,67,145,194,185,55,18,17,0,
0,0,0,0,0,0,0,0,0,0,11,18,28,49,75,103,135,159,183,196,
205,208,212,214,215,216,216,217,217,218,218,219,219,220,220,220,220,220,220,220,
220,220,220,220,220,220,220,220,220,220,220,220,220,219,216,217,220,220,220,220,
220,215,220,220,220,220,220,220,220,220,220,220,220,219,219,218,217,215,213,201,
155,107,130,208,198,202,93,20,17,1,0,0,0,0,0,0,0,0,0,0,
12,16,26,42,67,94,125,151,173,190,195,204,208,211,213,214,215,216,216,217,
217,217,218,219,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
220,220,219,212,217,220,220,219,220,220,220,220,219,220,220,219,219,220,220,220,
220,220,220,219,219,219,218,217,216,206,189,202,216,208,203,204,126,21,17,3,
0,0,0,0,0,0,0,0,0,0,13,14,24,35,55,82,108,137,159,171,
180,191,196,205,207,212,213,216,217,217,219,216,217,219,220,220,220,220,220,220,
220,220,220,220,220,220,220,220,220,220,220,220,217,220,220,220,220,217,220,220,
220,220,220,220,220,220,220,220,220,220,220,220,220,219,219,219,219,216,217,216,
216,215,215,210,213,208,146,25,19,9,0,0,0,0,0,0,0,0,0,0,

/* #3: Trinity face shot (originally by Alex) */
4,7,10,15,23,23,23,24,25,25,26,28,28,28,29,30,30,30,32,34,
34,50,67,38,35,33,35,36,36,36,35,37,40,39,38,38,38,38,36,37,
37,37,37,38,38,40,39,36,47,65,103,111,85,39,24,23,23,22,23,22,
22,22,23,23,23,26,28,28,26,31,29,29,29,29,25,25,20,15,8,1,
1,1,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,32,36,54,52,34,35,35,36,37,37,38,
37,38,40,40,37,39,38,38,35,36,36,39,46,49,60,101,117,106,73,76,
106,112,78,35,23,23,25,24,23,23,23,23,23,25,26,26,28,26,25,1,
1,1,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,25,26,28,28,29,30,30,32,33,34,33,
44,58,44,33,37,37,38,39,39,39,38,39,40,41,42,40,44,46,45,44,
40,49,84,134,201,236,250,252,239,180,137,124,88,40,29,26,25,25,26,26,
26,24,23,24,28,28,28,26,26,1,1,1,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,25,
26,26,28,29,30,29,30,31,35,45,64,61,38,39,38,38,38,41,41,41,
39,41,44,44,51,96,134,143,136,98,95,84,99,159,203,203,207,249,250,252,
246,194,132,72,37,31,28,28,29,29,28,28,28,29,30,30,28,28,28,1,
1,1,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,28,28,28,28,30,31,31,32,36,44,70,
89,68,38,39,40,40,41,44,44,45,44,48,61,124,188,205,182,109,116,150,
185,194,164,192,229,234,198,207,252,252,252,249,234,158,83,49,38,34,35,34,
35,31,34,31,31,30,30,29,29,1,1,1,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,28,
28,28,29,31,32,32,32,37,48,81,90,67,42,41,44,42,44,44,44,47,
52,114,204,188,155,129,146,153,161,195,225,194,190,240,207,209,245,249,249,254,
252,252,252,245,185,145,103,102,100,108,93,63,46,35,33,30,33,31,30,1,
1,1,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,28,30,29,29,31,33,32,34,36,48,72,
83,79,82,84,85,88,87,79,68,74,160,222,222,211,183,190,182,182,221,234,
240,236,216,177,180,243,241,249,240,250,254,252,254,254,252,236,230,229,219,229,
190,102,53,37,32,33,33,32,31,1,1,1,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,28,
30,29,29,31,33,32,34,36,41,63,79,119,155,151,153,151,155,143,153,219,
244,239,240,240,229,236,243,240,247,252,229,164,160,147,141,166,215,207,195,225,
254,254,254,254,254,252,252,254,254,252,192,96,47,34,33,32,32,32,32,1,
1,1,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,29,30,30,30,31,33,34,35,37,41,61,
79,117,138,138,136,137,153,220,249,244,246,250,250,252,252,254,250,250,254,252,
174,120,155,150,160,212,243,243,249,243,250,254,254,254,254,254,252,252,254,246,
185,86,47,35,34,33,33,33,33,1,1,1,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,30,
30,31,31,32,34,35,36,36,41,60,77,105,121,115,113,150,236,252,247,247,
252,254,254,254,254,254,254,250,244,226,124,103,149,212,230,237,249,254,254,243,
207,246,254,254,254,254,254,254,249,229,171,81,45,35,34,33,33,33,33,1,
1,1,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,30,30,31,32,33,34,35,36,37,39,52,
68,88,102,93,155,243,252,252,254,254,252,254,254,255,254,254,254,252,249,177,
98,108,130,203,227,220,249,254,254,249,247,250,254,254,254,254,254,254,246,194,
149,76,44,35,33,33,33,33,33,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,31,
30,32,33,33,33,34,35,37,41,53,71,60,64,149,245,252,250,254,254,254,
254,254,254,254,254,255,255,250,254,196,150,143,201,246,249,243,233,243,252,250,
252,252,254,254,254,254,254,254,250,220,143,79,44,37,33,33,33,33,33,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,30,31,33,33,33,34,35,36,40,44,60,
85,52,121,243,254,254,254,254,254,254,254,254,254,254,254,254,254,252,254,204,
126,158,155,209,252,252,241,233,252,252,254,254,254,254,254,254,254,254,252,249,
158,74,50,42,35,35,35,34,34,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,30,
31,33,33,33,34,36,38,38,44,71,89,94,232,249,252,255,254,254,254,254,
254,254,254,254,254,254,252,252,252,205,118,163,163,219,252,254,252,250,252,252,
254,254,254,254,254,254,254,254,252,254,219,73,47,42,38,36,37,36,35,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,30,31,32,33,33,34,37,38,40,46,78,
116,216,252,254,252,255,255,254,254,254,254,254,254,254,254,252,252,240,254,219,
192,215,226,236,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,
249,119,42,39,37,34,36,35,35,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,30,
31,32,34,35,37,38,38,41,44,73,171,249,252,254,252,255,255,254,254,254,
254,254,254,254,254,254,252,212,246,240,229,243,252,252,252,254,254,254,254,254,
254,254,254,254,254,254,254,254,254,252,252,175,48,37,36,34,36,35,34,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,29,31,32,34,35,37,38,38,38,46,87,
232,250,254,252,254,254,254,254,254,254,254,254,255,255,255,254,232,167,198,246,
254,252,254,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
252,241,106,33,34,34,36,35,32,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,28,
31,32,33,35,35,36,36,39,47,125,246,254,254,254,254,254,254,254,254,254,
254,254,254,255,254,245,190,134,196,240,255,255,254,254,254,254,254,254,254,254,
254,254,254,254,254,254,254,254,254,254,252,250,177,42,33,34,36,35,31,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,28,31,32,33,35,34,35,37,40,52,177,
254,254,254,255,254,254,254,254,254,254,254,254,254,254,234,158,120,118,171,231,
255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
252,252,241,97,39,37,34,33,31,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,29,
31,33,33,35,34,35,37,39,56,221,254,254,254,254,254,254,254,254,254,254,
254,254,252,219,143,87,72,89,140,215,252,254,252,254,254,254,254,254,254,254,
254,254,254,254,254,254,254,254,254,254,254,254,252,207,54,38,35,32,33,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,29,31,33,33,35,35,36,37,40,76,246,
254,254,254,254,254,254,254,254,254,254,252,254,210,111,60,45,45,49,73,134,
215,252,254,254,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
254,254,250,244,108,39,35,35,33,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,30,
31,33,33,35,36,37,38,42,122,254,254,254,254,254,254,254,254,254,254,254,
252,252,145,49,41,39,37,41,49,73,113,177,237,252,254,255,255,254,254,254,
254,254,254,254,254,254,254,254,254,254,254,254,252,247,217,58,37,34,33,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,31,32,33,33,36,37,39,40,40,171,254,
254,255,254,255,252,254,252,240,227,247,252,250,167,52,38,35,36,36,41,50,
65,96,124,174,209,239,252,252,254,254,254,254,254,254,254,254,254,254,254,254,
254,254,254,254,252,136,38,34,33,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,33,
34,35,34,37,36,38,39,42,209,252,254,255,254,254,252,252,247,146,74,219,
252,252,239,119,50,42,40,38,39,46,54,68,78,92,99,108,159,220,249,252,
254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,203,41,35,31,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,35,35,35,35,37,38,39,42,53,236,254,
254,254,254,252,240,249,203,78,41,93,240,249,250,245,182,113,64,45,42,45,
46,57,70,76,72,80,85,100,188,247,254,254,254,254,254,254,254,254,254,254,
254,254,254,254,254,246,103,35,30,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,35,
35,36,36,36,37,39,39,63,247,254,254,254,254,252,185,249,159,57,35,40,
130,245,252,252,254,249,222,200,162,145,136,128,122,111,104,93,85,95,110,177,
247,254,254,254,254,254,254,254,254,254,254,254,254,254,255,236,175,41,30,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,33,34,36,36,35,35,39,38,64,249,254,
254,254,254,245,191,252,178,60,42,38,48,195,254,255,254,250,236,219,210,241,
252,240,225,207,194,174,160,147,150,188,239,255,254,254,254,254,254,254,254,254,
254,254,254,254,255,229,130,77,32,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,32,
35,35,35,37,37,38,38,62,250,254,254,254,254,241,150,243,219,76,47,44,
45,74,228,240,249,252,236,203,194,216,230,204,194,188,190,186,177,158,155,188,
245,252,254,254,254,254,254,254,254,254,254,254,252,254,254,236,142,69,31,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,33,35,35,35,37,38,40,39,60,249,252,
254,254,255,240,155,188,236,104,53,45,45,51,93,198,178,230,245,249,252,252,
249,229,198,155,113,94,88,92,101,125,185,236,252,252,254,254,254,254,254,254,
254,244,249,252,254,240,174,44,29,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,33,
36,35,35,38,41,40,40,55,244,252,254,254,254,241,170,145,215,141,63,50,
48,48,58,95,179,134,143,191,220,246,252,231,156,111,85,82,79,79,84,94,
108,134,204,254,254,254,254,254,252,254,250,150,213,252,254,244,141,28,29,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,33,36,37,40,45,49,49,47,55,224,254,
254,254,254,240,177,134,175,163,76,52,50,52,52,56,78,137,128,108,113,143,
177,215,229,217,185,155,126,93,93,85,80,90,130,232,254,254,254,252,249,252,
252,167,210,254,254,221,108,26,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,34,
35,38,41,46,51,52,52,58,215,254,254,254,254,243,177,143,132,194,95,57,
52,51,50,53,60,63,76,99,110,114,103,98,106,131,172,200,188,134,85,71,
68,70,100,190,252,254,254,252,249,249,244,167,240,254,254,194,66,26,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,33,34,38,39,45,51,51,53,60,221,243,
236,252,252,252,182,147,102,194,129,61,53,52,52,53,53,54,57,60,67,79,
83,92,128,171,219,215,166,126,100,79,65,60,74,153,244,252,252,220,182,185,
219,118,207,254,250,191,49,28,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,32,
31,39,44,47,50,51,53,52,192,243,229,250,252,252,192,156,94,147,205,83,
60,60,56,57,58,61,66,69,80,99,149,191,227,213,162,124,119,119,106,79,
71,63,63,132,226,250,252,231,185,127,151,114,198,249,246,190,36,26,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,33,34,38,42,47,49,51,52,55,115,247,
244,252,252,254,230,167,108,96,204,150,80,70,65,63,68,77,97,121,170,221,
249,254,229,191,204,228,229,229,234,212,110,71,115,166,203,254,254,252,188,198,
195,166,196,219,210,192,32,26,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,34,
34,39,44,48,50,51,52,54,63,227,243,243,252,254,252,225,177,120,125,216,
134,92,84,73,88,110,175,219,250,254,254,254,252,254,252,254,254,252,249,243,
229,163,131,70,117,229,252,236,213,194,166,182,227,167,185,167,29,28,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,34,34,39,44,48,48,49,51,54,51,177,
249,232,254,254,254,250,249,233,213,243,233,156,112,84,98,128,225,252,254,254,
254,254,254,254,254,254,255,254,254,252,252,140,52,49,74,158,236,207,195,155,
134,150,180,99,204,119,28,28,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,32,
34,39,44,47,49,49,51,53,57,134,252,244,254,254,254,252,254,252,252,254,
252,240,153,92,92,134,213,249,254,254,254,254,254,254,254,254,254,254,252,252,
249,101,50,48,63,112,180,166,153,113,120,113,110,77,212,65,30,26,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,31,33,37,41,44,47,49,50,53,57,85,
243,252,254,255,254,254,254,254,254,254,255,254,230,155,124,158,236,254,254,254,
254,254,254,254,254,254,254,252,249,250,237,76,57,51,56,95,137,131,111,102,
106,82,83,95,180,31,26,28,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,34,
34,37,42,45,47,53,53,53,57,62,188,246,254,254,255,254,255,254,254,254,
255,254,249,234,163,170,249,254,254,255,254,254,254,254,254,254,254,252,247,224,
174,66,55,52,56,78,122,106,89,117,71,55,56,150,95,25,24,28,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,35,35,40,44,46,48,51,52,52,54,52,
103,229,250,250,254,254,254,254,254,254,254,254,249,212,243,234,249,252,255,254,
254,254,254,254,254,252,254,254,240,158,82,63,60,51,55,63,103,87,79,93,
71,58,77,168,65,25,28,28,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,35,
35,40,45,48,51,53,53,54,55,54,69,117,207,246,249,255,254,254,254,254,
254,254,233,110,129,219,249,252,254,254,254,254,254,254,254,252,252,247,155,77,
66,65,60,52,50,53,80,76,78,87,73,60,150,129,87,35,30,28,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,34,35,40,46,50,52,54,53,55,54,52,
62,63,115,217,252,255,254,254,254,254,254,254,222,92,54,101,195,249,254,254,
254,254,254,255,254,254,243,153,78,70,71,66,69,60,52,50,54,58,74,71,
63,151,211,129,97,42,31,28,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,33,
34,41,46,51,53,54,51,52,53,52,53,58,83,113,203,246,252,252,254,252,
250,252,239,180,111,105,108,151,219,249,254,252,252,254,245,207,129,84,72,70,
74,71,74,64,60,53,50,51,83,97,152,243,246,216,128,54,32,29,29,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,35,35,42,45,51,56,54,49,53,52,52,
51,58,74,73,99,108,209,249,252,252,254,207,141,83,42,61,81,92,103,136,
175,196,195,149,116,89,76,72,73,73,76,76,78,67,60,50,51,52,104,219,
249,254,252,201,140,88,47,29,26,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,36,
36,44,46,54,57,57,52,51,51,50,53,58,67,68,71,35,51,140,182,207,
175,161,114,57,29,37,57,74,85,92,86,83,76,74,61,56,60,67,72,79,
79,79,78,67,56,51,51,49,94,215,252,254,252,240,137,99,58,29,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,36,44,46,49,58,60,60,55,55,53,51,
54,60,69,69,62,31,37,42,60,73,82,92,94,45,28,33,45,56,87,95,
85,66,56,50,49,52,57,66,76,83,85,83,79,68,58,54,52,47,76,194,
249,245,249,252,232,150,44,31,29,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,38,
44,47,53,61,60,56,54,53,50,50,55,62,67,74,67,26,34,37,41,42,
47,58,63,42,26,28,41,54,57,77,97,69,52,46,47,54,62,76,84,89,
90,85,81,70,62,56,52,47,70,164,213,177,188,249,196,77,30,28,29,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,39,45,49,54,62,60,57,51,50,50,52,
58,63,69,76,69,28,29,42,44,44,42,52,56,33,28,31,42,39,46,57,
96,72,54,51,48,57,71,80,82,87,94,92,78,69,63,57,50,49,67,140,
171,106,145,209,73,30,28,29,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,40,
45,51,54,61,58,53,49,50,50,51,57,64,70,74,70,29,28,41,47,45,
44,50,52,33,26,34,50,63,101,92,96,54,44,48,51,63,74,84,82,83,
88,88,79,70,64,58,53,48,70,128,141,86,113,158,41,25,28,26,28,15,
10,5,1,1,3,2,1,1,0,1,1,1,1,1,3,2,1,1,0,1,
4,7,10,15,23,23,23,24,25,42,44,51,54,60,57,50,48,50,51,53,
60,62,67,74,73,30,28,33,48,54,49,48,47,51,49,56,71,108,156,124,
87,42,36,42,50,63,69,71,76,74,78,76,71,65,62,61,56,51,80,124,
115,76,61,49,28,28,28,28,28,15,10,5,1,1,3,2,1,1,0,1,
1,1,1,1,3,2,1,1,0,1,4,7,10,15,23,23,23,24,25,42,
45,51,56,60,53,51,47,52,55,56,58,62,69,77,77,32,28,25,44,54,
52,51,38,40,60,92,100,125,115,80,54,42,38,40,48,62,69,73,73,71,
71,70,67,62,61,64,60,54,103,126,115,53,21,23,26,28,28,28,28,28,
28,29,30,29,29,29,30,30,29,29,31,33,33,30,25,22,17,13,6,1,
5,10,15,36,41,50,46,33,36,44,44,49,60,61,53,50,50,52,56,56,
61,63,71,79,81,36,26,25,33,52,60,46,31,33,39,63,106,111,80,57,
44,40,42,46,51,60,62,66,63,62,63,63,60,57,58,62,62,73,109,118,
97,34,25,24,28,28,28,28,28,28,28,29,30,29,29,29,30,31,29,29,
31,33,33,30,25,22,17,13,6,1,5,10,15,40,52,78,93,44,37,40,
41,46,55,53,51,48,45,50,54,55,56,61,65,77,80,39,28,29,28,41,
53,42,31,32,35,44,69,69,55,46,45,42,44,56,60,64,55,55,60,56,
56,60,60,61,61,68,74,101,114,104,84,37,30,28,28,28,28,28,28,28,
28,28,28,29,30,29,31,31,29,29,31,33,33,30,25,22,17,13,6,1,
5,10,15,36,47,63,83,44,37,39,41,47,52,53,50,46,46,48,49,51,
54,54,54,65,78,56,53,49,39,38,46,44,37,33,34,40,51,51,61,62,
58,61,62,77,90,77,64,55,60,58,58,56,60,64,68,77,100,108,112,95,
82,54,40,28,25,25,24,28,28,28,28,28,28,29,30,29,31,31,29,29,
31,33,33,30,25,22,17,13,6,1,5,10,15,34,44,53,70,46,33,36,
39,45,49,55,50,46,44,46,44,42,44,40,40,45,60,92,150,137,92,55,
40,44,44,45,71,93,92,103,117,125,137,149,149,136,106,85,70,64,63,60,
61,60,61,67,77,106,118,100,103,90,80,53,40,29,26,28,26,28,28,28,
28,28,28,29,30,29,31,30,28,29,31,33,33,30,25,22,17,13,6,1,
5,10,15,34,42,52,62,47,32,36,39,44,45,46,44,44,42,38,34,33,
33,31,31,32,37,63,121,130,94,58,41,44,64,104,140,149,156,177,180,180,
166,153,136,94,76,71,71,74,71,65,63,60,68,76,102,128,106,102,96,90,
80,57,36,31,28,28,28,28,28,28,28,29,30,29,29,29,29,29,28,29,
31,34,34,36,30,25,20,12,5,1,5,10,15,34,44,56,60,50,33,36,
39,44,44,42,39,36,36,35,33,32,32,30,29,28,28,28,31,44,48,49,
44,41,57,70,106,119,115,120,110,96,106,108,98,80,70,68,71,73,76,76,
71,76,77,101,142,122,102,99,96,90,81,62,41,33,30,28,28,28,28,28,
28,29,30,29,29,29,30,29,28,28,30,33,33,36,30,25,20,12,5,1,
5,10,15,20,44,56,64,53,31,37,38,40,40,37,35,31,32,33,33,32,
31,30,28,28,30,28,26,28,26,29,31,33,46,58,79,101,112,110,105,109,
109,95,84,67,60,66,64,73,76,77,79,86,102,143,140,114,101,93,93,92,
82,65,51,42,31,29,29,29,28,28,29,29,29,29,29,29,29,28,28,28,
28,29,30,32,35,28,20,15,10,1,5,10,15,29,34,45,55,52,31,36,
37,38,39,34,33,30,32,33,33,33,30,30,29,29,29,28,28,26,26,26,
28,29,36,49,56,79,103,112,110,106,97,80,68,55,48,52,60,68,76,82,
95,113,149,155,132,112,102,94,92,95,83,70,54,44,37,30,30,31,29,29,
29,29,29,29,29,29,29,29,28,26,25,26,28,28,36,25,19,12,4,1,
5,10,15,22,23,26,28,32,30,35,36,37,37,32,31,29,32,33,33,33,
30,30,29,29,29,28,28,28,28,28,30,29,28,36,42,50,63,62,60,54,
52,48,44,42,47,55,62,73,85,101,114,164,162,146,128,110,104,100,96,98,
85,76,62,44,36,34,32,30,29,28,29,29,29,29,29,29,29,29,28,26,
25,25,25,26,25,22,15,9,5,1,5,10,15,24,24,23,24,28,26,33,
37,35,33,31,30,29,30,32,33,33,32,31,30,30,29,29,29,29,29,29,
29,29,28,30,39,42,37,36,38,39,40,38,38,44,50,62,71,88,106,126,
167,174,156,145,124,108,101,99,98,94,88,82,70,53,36,33,32,29,28,28,
29,29,29,29,29,29,29,29,28,26,25,25,24,25,23,22,13,9,4,1,
5,10,15,24,24,23,24,25,28,36,42,38,31,32,31,30,30,32,33,33,
32,31,30,30,30,30,30,29,29,29,29,29,29,29,31,40,38,40,42,39,
40,42,51,56,64,76,89,111,143,186,185,166,149,131,115,104,102,93,92,94,
95,85,72,57,44,34,33,33,28,31,30,30,30,30,30,30,30,30,29,28,
26,26,24,25,23,21,15,10,5,1,5,10,15,23,24,24,25,28,25,37,
42,37,33,31,31,31,30,32,33,33,32,31,30,30,31,31,30,29,29,29,
29,29,29,28,28,33,50,51,50,47,53,64,76,85,89,104,119,163,198,192,
175,158,140,125,108,103,102,97,98,93,88,79,74,65,49,42,37,33,29,32,
31,31,31,31,31,31,32,32,30,28,28,26,25,24,23,22,21,15,7,1,
5,10,15,23,24,23,24,25,26,37,49,34,32,30,31,30,30,30,32,31,
31,31,31,32,32,32,30,30,30,30,30,30,30,28,28,28,42,77,85,80,
89,101,108,113,124,145,175,188,188,178,168,146,132,124,113,108,102,93,86,101,
143,153,130,104,83,68,127,112,103,36,31,32,32,31,31,32,34,33,31,29,
28,26,25,24,23,22,20,15,9,1,5,10,15,22,24,23,24,26,28,31,
51,44,34,31,33,31,30,30,31,31,31,31,32,34,33,33,31,31,31,31,
32,32,32,31,29,29,28,53,88,113,121,127,134,146,155,162,158,167,175,164,
150,142,132,124,113,108,99,104,171,231,252,216,149,124,103,116,137,160,185,65,
34,34,33,33,33,33,34,32,31,29,28,28,26,25,24,23,21,15,9,1,
5,10,15,22,25,25,26,28,28,28,28,44,44,37,34,30,31,32,33,32,
32,32,32,33,33,33,32,31,31,31,32,32,33,32,30,30,28,38,62,88,
103,120,134,137,140,128,130,145,150,150,143,143,132,126,114,108,136,221,252,252,
234,207,178,170,174,131,116,136,180,203,44,33,32,33,33,34,34,32,31,29,
28,28,26,26,25,24,22,15,9,1,5,10,15,25,32,35,32,30,28,28,
28,29,45,48,40,35,32,32,32,32,33,33,34,34,32,31,30,31,31,31,
31,31,33,32,30,29,28,36,58,85,97,101,106,116,118,108,115,125,132,136,
137,136,132,119,115,145,240,252,227,136,58,45,45,53,94,153,149,103,131,155,
41,35,34,33,33,34,34,32,31,29,28,28,26,26,25,24,23,15,9,1,
5,10,15,29,45,65,77,78,65,48,37,34,32,51,51,45,39,35,34,34,
34,34,33,32,34,32,31,31,31,30,30,30,33,32,30,29,29,31,51,76,
93,100,103,103,99,87,100,109,118,121,130,127,126,124,153,239,252,196,76,44,
41,41,40,44,44,46,100,158,109,89,80,32,34,33,33,34,34,32,31,29,
28,28,26,25,24,24,23,15,9,1,5,10,15,29,44,58,83,104,119,130,
136,108,74,54,64,58,46,40,37,37,36,37,38,38,36,34,32,33,31,32,
31,31,31,31,31,29,29,28,47,65,87,98,99,96,85,76,83,102,106,119,
116,124,122,149,240,249,182,60,40,35,34,36,37,39,44,44,44,63,158,140,
95,55,36,33,32,33,33,32,31,29,28,28,26,25,24,24,23,22,22,1,

/* #4: Ghosts (originally by Alex) */
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0,0,3,2,3,3,3,5,3,8,12,12,
16,17,23,21,17,13,16,20,20,10,4,2,3,1,1,2,2,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,4,4,2,4,16,20,31,39,34,37,41,31,28,28,25,28,26,26,25,
18,12,5,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,2,2,2,2,6,8,35,47,23,32,48,32,25,
24,22,22,22,25,21,19,23,22,24,24,25,23,14,5,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,2,1,0,0,1,1,1,1,1,1,0,0,
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,2,
5,12,41,57,29,70,60,22,23,28,24,24,25,21,26,21,19,23,21,22,
24,31,32,31,16,2,1,2,1,0,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,2,
3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,2,2,14,50,48,46,79,55,25,38,33,30,
26,25,25,21,20,17,12,14,12,16,19,19,22,34,33,18,4,2,2,2,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,2,3,5,3,1,1,2,2,2,1,2,2,
2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,7,
60,45,36,82,46,29,57,39,20,24,20,19,17,20,16,14,10,12,12,13,
13,10,12,14,25,29,16,6,0,2,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,2,2,1,2,2,5,4,6,12,20,30,
37,28,12,7,19,26,17,14,4,6,2,2,2,2,2,2,1,1,1,2,
1,1,1,1,1,1,2,3,5,22,42,26,85,52,33,56,25,19,21,18,
20,21,19,19,12,10,9,9,8,12,9,12,13,12,12,22,28,18,2,3,
2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,
2,2,4,3,9,29,53,58,52,49,46,34,33,32,41,53,53,39,35,19,
5,3,5,3,2,2,1,1,2,2,2,1,1,1,1,2,3,4,7,36,
23,60,71,33,56,16,25,46,22,17,16,19,18,14,12,12,9,9,9,9,
7,7,7,12,12,13,19,22,8,3,1,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,2,2,2,3,1,12,42,53,54,50,44,41,
42,38,34,35,39,46,44,36,47,52,36,12,3,4,2,2,1,1,2,2,
2,1,1,1,1,2,3,6,41,56,62,48,61,44,18,22,15,26,20,17,
16,15,12,9,8,12,12,9,9,9,9,8,7,12,12,12,12,17,16,5,
0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,
2,2,13,33,33,28,21,15,15,16,26,35,35,36,34,34,26,25,20,47,
49,39,7,6,3,2,2,1,2,2,2,1,1,1,1,2,3,14,74,62,
36,77,49,35,28,15,12,16,18,17,21,16,12,12,9,12,12,9,9,9,
8,9,9,12,12,12,8,13,17,12,2,1,2,1,1,1,1,1,1,1,
1,1,1,1,1,0,1,2,2,3,6,20,37,28,17,15,15,14,13,14,
14,21,31,22,31,34,37,38,50,44,79,55,44,12,4,5,3,2,2,1,
2,1,1,1,2,4,2,32,61,37,68,95,38,33,28,15,20,18,17,17,
15,13,12,12,12,12,12,8,7,9,9,9,9,12,12,12,8,12,14,18,
14,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,4,12,
30,40,28,15,16,16,13,13,13,12,12,12,22,23,22,28,37,47,42,50,
35,61,51,46,13,6,3,3,2,1,2,1,1,1,1,4,13,44,29,37,
95,55,47,40,17,39,26,21,18,18,12,9,9,12,12,12,12,8,7,8,
7,7,7,9,9,9,9,12,12,13,23,8,1,1,1,1,1,1,1,1,
1,1,1,1,1,2,3,4,8,36,39,25,19,15,13,12,12,12,12,12,
12,10,9,20,21,28,30,26,22,28,48,53,53,69,38,9,2,2,2,1,
2,1,1,1,5,4,23,47,71,55,95,31,54,18,38,32,22,17,16,15,
14,13,12,12,9,9,9,8,7,8,7,7,7,8,8,8,9,9,12,9,
19,15,3,1,1,1,1,1,1,1,1,1,0,1,2,3,5,7,33,48,
28,18,18,14,13,12,12,12,12,12,12,10,8,14,25,28,29,32,44,53,
39,67,87,76,56,23,6,2,2,2,2,1,2,2,2,7,33,45,70,105,
103,44,34,23,32,29,26,21,15,15,13,12,9,9,9,8,8,8,8,8,
8,8,8,8,8,8,9,8,9,10,17,22,4,1,1,1,1,1,1,1,
1,1,0,0,2,3,3,22,54,32,19,19,17,17,13,12,10,9,12,12,
12,12,12,13,19,28,22,28,44,47,37,56,63,36,92,63,29,4,3,3,
3,1,2,2,5,15,34,85,57,127,51,51,24,22,53,64,29,24,29,19,
12,12,7,9,8,7,7,8,8,8,8,8,8,8,8,8,8,8,7,10,
14,24,5,1,1,1,1,1,1,1,1,1,0,0,2,3,5,52,47,26,
22,19,18,17,13,12,9,8,10,10,10,12,12,12,18,28,22,21,34,15,
64,69,70,48,71,76,50,12,2,3,2,1,2,2,4,15,44,111,65,124,
35,72,23,42,55,50,25,19,20,12,12,12,8,9,8,7,7,8,8,8,
8,8,8,8,8,8,8,8,7,10,10,26,6,1,1,1,1,1,1,1,
1,1,0,1,3,4,14,76,41,28,20,18,20,16,12,9,9,9,9,9,
9,8,12,12,14,20,29,22,26,28,53,99,83,79,72,89,64,24,2,4,
1,2,2,2,4,23,60,99,96,106,39,61,23,55,39,16,28,22,15,17,
14,14,10,10,8,7,7,8,8,8,8,8,8,9,9,9,8,9,8,12,
7,28,7,1,1,1,1,1,1,1,1,1,1,2,3,3,22,79,34,28,
21,18,17,15,10,10,10,10,10,9,8,9,12,12,13,19,30,29,30,28,
30,115,81,80,79,92,74,33,5,3,3,3,2,2,6,54,62,73,106,92,
90,62,32,30,30,23,28,30,15,12,17,14,12,10,7,7,9,8,8,8,
8,6,7,7,10,12,9,7,8,12,8,25,12,1,2,2,1,1,1,1,
1,1,1,2,4,3,36,60,31,24,20,18,15,15,12,12,12,12,12,10,
9,9,12,13,14,22,29,28,35,57,19,117,89,114,70,104,88,46,7,2,
3,4,3,2,13,79,82,56,116,86,102,44,28,44,32,38,36,40,22,13,
15,14,12,12,10,7,12,9,8,9,7,7,9,8,9,9,10,10,12,12,
8,25,16,0,2,2,1,1,1,1,1,1,1,2,3,3,54,40,25,23,
23,19,14,14,12,10,10,10,12,12,10,12,13,13,12,14,28,33,45,109,
46,96,109,109,66,134,115,61,8,2,3,5,5,2,34,73,76,52,137,72,
74,28,33,99,77,28,21,19,17,14,12,12,10,9,8,12,9,9,8,6,
6,5,9,12,13,12,12,12,10,12,10,19,13,4,2,2,1,1,1,1,
1,1,2,2,3,12,67,42,26,25,28,18,13,13,13,10,9,9,13,12,
12,12,13,14,16,20,33,41,44,82,67,114,132,92,69,108,136,99,31,4,
3,3,7,4,60,69,109,70,150,61,62,24,28,74,84,62,52,37,68,94,
97,96,104,108,126,186,190,186,168,143,125,118,128,160,94,24,13,12,49,78,
82,78,71,40,2,4,2,1,1,1,1,2,2,2,3,81,141,97,60,32,
39,47,23,15,9,9,9,9,12,13,14,10,14,16,19,23,36,41,44,106,
95,126,143,126,58,65,112,108,56,6,4,2,5,5,60,44,136,82,141,60,
42,20,19,25,58,34,35,46,63,70,70,73,92,108,175,249,246,252,247,249,
249,240,233,236,209,143,28,30,136,190,227,236,232,114,4,3,1,1,1,1,
1,1,2,2,13,167,240,198,175,63,28,103,171,126,69,32,18,9,5,8,
12,16,20,20,16,22,37,38,40,113,94,110,180,129,124,102,102,96,64,8,
4,3,4,10,82,50,124,71,117,44,36,13,12,17,22,34,31,25,19,15,
16,15,12,8,117,247,247,249,252,252,250,249,246,233,215,229,129,52,116,200,
252,249,250,98,6,1,1,1,1,1,1,1,1,3,23,198,245,232,198,61,
92,204,246,246,232,201,186,163,145,102,31,10,12,12,17,18,28,36,38,109,
92,119,104,122,147,77,109,108,76,7,4,4,3,18,92,63,124,96,95,67,
57,18,12,34,23,58,40,28,25,22,21,19,14,8,79,200,234,252,252,249,
252,252,246,231,244,245,126,19,150,249,249,243,236,77,7,2,1,1,1,1,
1,1,1,3,23,185,196,243,178,76,227,250,252,252,252,254,250,252,252,243,
183,114,88,51,29,19,26,42,57,120,77,122,84,138,162,73,145,121,89,8,
4,4,4,40,92,71,112,90,78,76,64,20,18,150,44,35,30,33,29,25,
24,21,18,15,14,54,121,188,232,245,247,249,250,252,252,179,25,10,106,249,
250,186,167,31,8,2,2,1,1,1,1,1,2,3,16,117,150,237,87,17,
161,252,249,250,250,254,254,252,252,250,158,64,93,108,113,98,72,88,102,134,
63,126,108,177,158,108,178,152,93,9,4,3,3,57,98,81,117,60,89,74,
70,23,12,109,52,14,28,29,29,26,26,22,18,17,12,6,14,52,124,167,
188,191,200,207,185,51,10,12,50,232,250,175,74,7,3,2,1,1,1,1,
1,1,2,3,7,29,170,163,14,12,76,240,252,252,252,254,254,252,244,219,
76,12,12,10,13,28,38,52,88,111,54,132,108,168,155,118,170,163,100,14,
3,5,4,62,67,98,118,51,114,66,73,22,7,52,44,16,26,31,33,31,
28,24,17,12,13,12,12,8,19,47,83,96,86,62,26,8,12,7,16,190,
217,72,7,4,4,3,2,1,1,1,1,1,1,2,7,18,183,63,10,15,
16,109,203,236,222,203,170,150,112,60,19,20,18,21,24,28,60,73,86,99,
61,150,108,175,159,92,146,158,108,17,3,4,9,98,60,115,111,44,95,57,
54,19,12,34,34,12,26,29,31,32,32,29,20,15,12,10,12,10,9,8,
12,17,15,8,7,10,12,10,8,58,92,30,8,2,1,1,1,1,1,1,
1,2,2,2,5,25,81,15,15,12,13,13,28,85,67,40,18,12,8,6,
9,17,21,22,25,26,62,114,130,136,92,158,131,186,158,120,136,170,119,17,
5,5,17,121,40,129,105,31,98,48,44,23,18,13,68,30,23,28,28,30,
31,31,25,18,12,12,10,9,10,10,10,9,8,14,14,10,7,12,8,14,
33,31,3,2,1,1,1,1,1,1,1,1,1,2,7,14,21,10,9,16,
13,12,8,8,10,8,7,10,12,13,14,19,24,28,33,36,45,47,175,155,
58,171,126,186,190,155,142,161,128,18,5,2,24,87,30,99,78,37,131,56,
44,12,8,21,26,32,35,26,28,23,22,28,26,20,14,12,12,10,10,9,
6,7,5,10,5,5,10,7,12,6,28,48,8,2,1,1,1,1,1,1,
1,1,2,3,4,35,41,14,52,39,10,12,13,14,15,15,14,12,12,12,
16,22,28,26,33,35,44,23,121,106,61,167,112,175,190,150,134,177,171,44,
5,2,37,68,30,143,61,62,124,55,26,32,19,12,12,39,44,31,25,22,
21,25,24,18,14,12,10,9,10,9,7,5,7,23,42,80,79,33,12,17,
41,54,9,2,1,1,1,1,1,1,1,1,2,3,4,68,103,40,119,131,
41,19,16,15,12,10,12,12,12,15,17,25,28,28,32,37,35,63,76,72,
92,150,102,172,158,162,118,164,151,37,5,4,45,47,31,152,41,79,101,44,
25,55,37,134,54,23,54,41,25,23,21,23,19,16,15,12,10,12,9,7,
6,7,5,26,76,127,158,84,35,31,80,72,3,2,1,1,1,1,1,1,
1,1,2,4,5,87,209,152,19,23,23,18,14,14,13,12,12,12,16,17,
20,28,28,32,34,46,41,89,58,105,79,150,100,188,155,167,105,182,167,33,
5,7,55,36,44,129,55,92,55,57,19,93,20,203,229,190,87,42,29,23,
15,17,18,17,15,12,12,10,9,8,9,10,9,8,6,8,39,141,88,39,
116,58,3,2,1,1,1,1,1,1,1,1,2,5,12,114,159,76,19,10,
12,8,12,12,12,13,14,16,20,18,24,29,28,33,35,50,71,42,28,110,
81,159,113,194,164,205,110,172,161,38,5,10,65,38,71,152,48,81,66,60,
20,109,21,195,156,131,126,52,30,23,16,17,17,15,13,13,14,8,12,12,
10,10,10,10,12,9,20,73,76,65,167,46,6,1,1,1,1,1,1,1,
1,2,2,5,18,132,86,13,12,10,9,8,10,10,10,13,16,18,19,16,
22,28,28,30,37,72,47,21,95,215,89,129,102,163,163,229,110,145,159,33,
3,14,87,31,52,104,29,93,61,60,29,128,28,158,58,41,141,67,31,30,
16,14,15,12,12,13,14,12,13,9,10,6,7,8,7,8,15,16,34,108,
168,26,5,2,1,2,1,1,1,1,1,2,2,3,31,138,171,119,82,36,
10,7,12,12,12,12,15,17,18,18,21,23,24,34,49,85,132,203,243,183,
65,127,93,150,166,232,111,124,167,41,3,29,81,20,48,108,23,120,56,69,
17,110,20,108,50,37,122,110,34,28,19,16,17,14,12,13,15,13,12,9,
12,8,4,8,14,22,9,13,18,152,132,22,3,2,1,2,1,1,1,1,
1,2,2,2,42,156,170,190,195,170,111,70,30,12,10,12,14,16,17,18,
20,24,28,34,57,110,143,152,177,177,99,136,86,166,170,231,112,119,156,51,
6,35,78,13,50,95,23,145,39,76,20,150,29,108,60,28,100,147,52,31,
20,16,18,14,13,15,21,18,13,12,23,63,104,143,185,185,151,162,85,155,
145,30,4,2,1,2,1,1,1,1,1,2,2,3,44,177,150,94,54,46,
74,95,60,15,13,16,18,16,14,16,18,25,31,38,65,143,115,73,143,188,
77,143,114,190,151,234,120,108,127,29,6,31,58,16,68,77,25,129,35,76,
32,205,30,111,73,29,66,175,102,32,23,20,20,16,14,17,28,28,16,14,
15,60,101,110,131,175,207,221,106,164,143,15,5,2,1,2,1,1,1,1,
1,2,2,4,44,201,167,71,50,19,9,7,16,16,15,19,19,18,17,17,
23,25,25,35,106,167,79,63,166,203,74,143,131,183,129,229,117,96,143,26,
7,64,57,24,82,55,34,85,37,64,37,203,30,128,80,30,38,131,175,86,
32,22,20,18,14,14,24,28,20,17,19,18,18,20,46,90,104,141,86,203,
129,26,12,2,1,2,1,1,1,1,1,3,4,4,77,200,186,74,36,29,
21,15,17,12,17,16,18,19,16,17,21,28,29,57,180,114,39,72,191,213,
108,131,126,163,142,210,99,102,188,42,10,89,51,35,76,44,60,108,36,48,
73,203,28,141,84,40,29,74,178,175,86,32,24,21,14,10,17,20,17,14,
17,18,24,32,44,63,89,128,92,216,111,23,13,2,1,2,1,1,1,2,
3,3,5,9,111,190,195,70,21,16,22,17,13,16,16,15,17,20,20,25,
28,34,53,150,192,52,38,88,207,217,108,134,79,143,177,210,117,63,180,50,
22,70,34,51,54,21,70,80,40,56,81,190,24,132,92,45,37,52,127,188,
171,98,45,25,13,9,14,18,18,15,17,19,18,19,18,26,60,128,81,210,
122,17,18,1,2,2,1,1,1,3,3,4,7,16,131,186,203,44,23,12,
9,9,12,13,19,18,18,22,29,37,45,80,145,219,108,32,53,117,209,231,
117,128,77,151,170,185,120,51,150,46,39,64,25,60,53,16,63,63,44,52,
83,177,31,153,87,53,38,40,85,150,178,179,128,65,26,20,12,16,18,13,
12,12,10,5,12,23,50,168,49,190,170,26,20,4,2,1,1,1,1,3,
3,4,6,32,85,158,219,64,29,21,12,15,15,17,25,26,32,40,57,71,
108,150,171,134,46,35,60,142,210,232,129,130,109,175,177,151,143,56,171,47,
30,60,19,52,23,23,60,60,53,46,83,150,32,160,87,52,44,40,55,112,
150,163,170,155,85,33,23,25,21,13,10,8,7,12,18,16,65,211,38,136,
175,23,22,5,2,1,1,1,1,2,3,3,10,50,86,163,219,143,50,42,
24,21,26,34,30,30,34,39,40,53,60,66,92,78,35,31,66,156,209,236,
134,111,92,170,151,108,164,64,182,79,36,60,34,60,13,31,74,45,39,40,
94,126,33,198,115,50,45,42,42,73,118,146,150,168,167,113,60,39,28,16,
12,12,12,12,14,15,138,209,34,82,103,14,25,6,3,1,1,1,1,1,
3,3,28,60,94,151,175,225,196,138,99,105,119,108,80,82,88,100,94,73,
83,99,87,54,30,35,78,164,200,234,122,83,68,151,162,108,190,51,142,98,
36,44,41,73,17,32,92,41,67,48,116,141,35,153,136,60,44,36,34,44,
71,100,113,141,170,177,150,105,62,34,19,20,22,25,28,49,211,183,33,56,
76,8,23,4,4,1,1,1,1,2,3,4,38,53,97,167,159,210,252,247,
240,243,244,240,234,231,222,143,88,49,54,61,50,39,32,36,87,166,198,234,
115,76,78,116,190,102,182,66,112,67,61,29,44,57,12,20,76,34,102,52,
145,112,50,95,82,66,50,33,32,32,39,48,45,58,103,170,195,179,150,109,
71,58,55,60,80,164,241,146,32,65,81,6,28,12,4,3,1,1,1,4,
3,9,45,57,89,143,120,182,252,252,252,249,250,252,252,230,190,73,26,23,
33,39,44,40,33,44,99,172,201,185,113,64,57,78,207,132,168,68,150,62,
87,23,44,51,15,15,50,24,79,36,151,71,55,124,45,40,51,42,31,36,
44,41,31,28,38,98,182,229,233,212,192,177,156,150,190,236,244,159,38,72,
54,5,32,23,2,2,1,1,1,3,6,19,44,70,62,121,71,138,249,246,
252,252,247,236,198,92,66,77,48,39,48,50,47,37,40,60,108,175,100,159,
151,69,54,60,183,150,150,54,100,52,64,13,50,48,17,16,76,26,71,28,
152,78,94,155,81,32,30,35,30,33,38,46,40,29,22,39,112,216,252,250,
252,249,228,172,201,198,240,155,23,45,50,9,24,24,7,1,2,1,2,5,
16,26,32,98,55,145,76,124,240,236,247,243,220,153,80,49,36,39,48,50,
48,48,45,42,48,67,106,74,97,210,166,74,70,28,150,143,143,76,63,31,
54,12,61,51,12,12,39,22,104,30,161,66,128,172,120,69,35,20,24,28,
38,46,41,33,26,21,95,209,237,243,244,236,198,170,188,161,229,158,17,21,
26,6,17,14,5,2,2,1,2,17,41,41,41,112,45,128,64,110,143,166,
209,207,146,73,44,40,53,44,40,38,53,47,49,48,61,65,41,51,110,185,
164,66,72,36,160,137,124,108,35,76,76,10,97,54,14,10,28,19,104,40,
175,53,150,118,116,108,94,80,47,29,37,44,48,48,41,72,143,127,151,180,
195,191,163,164,177,114,180,130,14,25,24,12,17,15,6,6,2,1,2,1,
31,60,31,101,33,100,62,64,65,85,136,146,92,53,50,50,47,48,48,40,
40,62,56,50,50,55,73,85,116,207,167,66,78,41,151,146,128,106,32,101,
108,17,87,40,17,17,44,16,92,51,153,35,198,134,53,60,69,79,89,70,
49,37,42,44,50,87,70,52,95,120,134,131,108,164,151,68,141,111,13,28,
28,15,12,16,12,20,12,5,4,1,31,60,15,60,21,110,44,39,63,32,
61,93,76,60,54,60,55,45,48,40,46,40,46,54,50,73,78,92,142,228,
160,53,100,41,175,141,143,106,34,131,96,26,70,25,26,20,48,16,68,57,
118,25,201,209,87,35,35,28,32,44,47,36,34,42,70,58,32,61,62,76,
78,76,70,166,92,29,84,96,26,31,22,14,7,12,17,13,20,28,20,1,
36,54,24,53,28,128,33,38,58,31,39,68,66,65,50,48,44,50,48,37,
22,10,13,47,54,67,87,122,175,236,175,60,115,58,166,145,143,81,51,153,
76,34,67,28,28,16,28,26,96,60,101,18,159,236,188,99,64,47,37,30,
34,40,35,19,39,83,60,30,35,35,38,44,61,160,53,24,44,117,28,32,
18,5,12,13,8,23,13,15,25,1,57,36,38,41,34,108,20,25,38,34,
21,74,53,67,58,48,49,44,44,19,14,16,14,22,53,85,128,159,177,227,
203,51,79,81,117,136,101,29,76,143,55,34,61,26,30,22,26,39,114,39,
58,44,210,201,211,171,132,95,57,49,38,32,13,7,9,13,50,47,28,35,
35,41,74,158,26,18,38,143,28,34,25,5,12,13,9,30,20,20,14,1,
78,15,32,25,44,82,13,33,23,47,12,65,64,55,63,58,45,84,110,15,
17,12,17,17,104,108,151,170,180,228,194,85,95,108,85,65,38,20,85,136,
32,37,51,16,44,26,22,65,119,25,30,47,229,191,161,159,155,122,82,58,
50,21,7,8,5,6,6,44,32,34,41,40,99,103,13,14,23,99,21,28,
30,8,14,15,9,22,52,15,19,1,52,17,44,22,52,73,17,47,19,42,
13,34,70,50,69,62,52,196,195,54,14,14,14,36,194,124,160,175,182,201,
170,119,92,68,39,28,29,37,120,136,14,39,41,14,30,31,26,71,109,29,
28,53,209,225,136,130,120,113,87,68,81,24,13,12,4,12,10,60,89,30,
44,47,128,37,12,9,19,74,22,23,25,16,22,80,13,15,49,44,14,1,
33,29,31,44,37,47,21,37,19,35,24,18,71,57,64,50,159,229,228,114,
20,13,23,103,234,138,158,178,145,127,111,82,54,36,16,22,25,72,150,77,
10,58,44,23,30,34,18,69,63,28,21,60,163,175,172,116,113,110,102,92,
136,37,12,4,6,8,15,85,190,37,34,85,116,19,12,8,18,53,22,17,
16,12,16,137,47,9,14,69,41,1,21,62,31,48,16,31,25,26,25,25,
29,9,50,76,50,132,203,109,161,186,31,20,29,171,228,172,158,145,108,77,
61,39,25,17,15,21,23,122,108,32,17,62,25,50,44,38,13,50,28,26,
13,40,124,104,158,156,125,116,112,101,226,100,7,12,7,8,14,155,245,83,
38,125,53,18,8,7,18,36,20,19,21,5,8,41,130,19,12,28,111,1,
17,46,38,50,20,29,23,20,20,18,35,18,24,61,76,210,94,87,128,121,
62,21,76,170,166,150,124,93,63,44,38,29,19,15,8,28,45,172,46,34,
24,72,13,52,39,29,10,69,19,25,10,35,96,96,88,164,134,132,116,114,
233,195,26,9,8,12,41,183,229,136,66,108,25,21,12,12,22,38,16,17,
30,9,9,8,85,21,20,15,35,1,6,12,52,47,25,22,17,19,24,18,
28,44,12,51,163,131,51,121,113,24,90,81,153,155,128,106,81,64,49,39,
28,22,15,12,15,21,76,132,23,49,81,86,14,53,31,36,9,64,25,19,
14,40,64,96,79,118,162,112,122,120,236,227,51,66,30,15,82,131,180,195,
119,71,24,28,25,12,18,41,26,10,22,8,9,6,21,22,34,8,19,1,
5,12,60,28,38,16,12,19,26,19,23,41,28,35,126,55,67,97,35,71,
105,166,128,112,86,70,63,60,54,33,20,17,10,5,19,12,92,72,28,60,
117,70,28,92,12,26,9,52,18,40,13,51,35,76,68,76,150,156,104,142,
227,175,19,20,8,6,38,93,121,225,147,28,17,21,15,49,195,207,40,19,
29,13,12,12,7,18,53,19,19,1,4,12,51,12,30,15,12,22,29,26,
30,28,40,14,24,60,72,46,74,158,68,114,85,77,61,54,58,66,85,28,
14,13,6,5,26,22,90,28,23,60,136,60,76,81,9,29,12,52,16,29,
14,40,34,62,62,63,72,166,159,143,102,76,17,4,5,2,10,57,86,183,
101,17,16,15,18,20,143,231,76,12,34,17,7,13,16,26,42,47,13,1,
5,11,55,21,34,16,14,15,12,24,21,20,34,20,13,77,67,35,124,108,
26,78,70,52,49,44,58,94,106,14,12,8,3,9,24,44,87,12,20,60,
128,47,77,55,16,40,17,76,15,40,17,32,45,50,62,56,62,85,145,44,
8,12,15,3,8,5,6,35,110,145,44,18,16,17,13,19,23,122,82,21,
46,9,6,21,16,31,18,76,17,1,6,10,37,30,32,33,143,159,122,31,
16,15,19,30,9,44,61,50,150,97,20,52,60,38,39,35,48,108,87,10,
10,5,3,15,18,97,35,12,21,45,82,21,70,30,31,33,19,72,19,42,
15,31,83,36,64,56,70,78,60,33,25,15,9,13,7,5,5,26,143,90,
23,20,14,21,28,19,10,39,65,45,61,12,8,23,12,20,10,71,52,1,
3,12,14,21,30,82,175,137,188,38,12,12,12,28,13,12,55,58,158,84,
15,28,48,33,32,37,52,112,63,10,6,1,5,16,31,84,13,13,19,28,
46,15,53,19,56,29,23,60,15,28,44,36,92,58,57,61,68,100,63,35,
34,15,20,37,37,12,7,30,136,38,20,28,30,36,19,10,46,182,105,26,
53,13,12,19,20,12,8,56,162,1,6,12,16,23,26,84,53,10,30,21,
23,26,23,22,29,10,41,70,155,69,13,15,42,28,31,39,61,94,44,10,
5,2,12,16,44,37,13,10,13,20,22,17,44,9,72,28,37,54,28,50,
129,95,78,98,46,73,81,120,51,25,23,7,12,28,54,30,6,28,83,22,
32,48,34,19,15,92,201,236,78,16,32,13,12,23,33,5,12,17,45,1,
5,10,15,20,15,74,38,22,37,13,34,50,39,24,25,16,16,92,145,50,
13,8,28,30,36,42,80,61,37,12,4,5,12,17,44,15,12,14,15,15,
22,14,71,16,36,15,51,50,32,52,36,48,105,108,64,66,90,124,41,21,
15,7,14,28,17,15,5,23,54,41,41,44,17,31,153,212,143,185,81,12,
35,14,12,17,30,8,13,12,7,3,6,11,15,20,19,65,39,16,156,155,
50,30,58,61,39,29,16,97,115,38,19,5,14,37,38,44,85,33,46,17,
5,5,12,22,37,5,7,12,12,16,20,23,146,33,35,15,60,36,23,30,
105,82,37,89,98,60,92,111,26,14,7,7,20,35,7,14,12,31,64,47,
28,18,70,201,200,70,26,110,65,14,44,14,12,14,29,7,9,13,12,1,
5,10,15,20,25,65,40,12,119,240,227,150,60,46,76,65,25,95,84,37,
23,6,9,31,35,54,68,20,53,15,5,8,18,52,21,8,8,15,14,29,
19,37,158,24,44,15,50,29,26,39,143,229,117,42,84,73,93,92,14,14,
8,5,13,32,9,10,13,44,49,28,33,134,220,183,60,13,14,81,74,9,
33,13,28,29,24,12,14,9,9,1,5,10,15,20,22,55,29,12,22,143,
220,241,228,127,54,95,64,98,56,35,28,9,5,28,38,69,53,19,52,14,
3,7,29,67,10,6,12,15,21,30,21,48,77,12,46,13,33,22,21,30,
155,247,243,158,39,76,99,69,12,12,8,4,2,6,7,7,29,61,21,66,
166,185,137,60,8,9,15,72,66,10,30,24,65,44,25,21,16,8,8,0,

/* #5: Morp w/ submachine gun (originally by Alex) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,3,3,113,233,167,226,17,92,160,5,3,4,3,3,2,0,
5,1,7,160,120,13,14,17,18,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,159,254,249,207,
182,161,203,167,128,9,3,2,4,4,3,8,151,254,158,10,46,58,18,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,3,1,178,196,241,243,243,224,243,252,203,9,6,2,5,4,
6,150,254,185,102,6,136,227,21,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,207,244,244,241,
185,211,249,249,166,1,5,3,3,10,163,252,200,200,106,18,14,51,25,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,1,1,1,1,241,249,254,240,222,200,252,252,146,4,4,3,28,178,
252,200,190,228,113,14,12,15,24,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,1,2,0,15,254,252,245,243,
207,192,249,252,115,2,3,53,207,254,191,185,215,222,117,125,128,124,108,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,
2,106,232,145,100,73,254,250,249,130,183,200,252,252,87,12,117,241,254,191,
170,203,215,232,128,19,24,42,56,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,1,4,136,239,120,212,122,252,249,247,79,
60,71,195,233,112,188,252,244,177,171,192,211,236,150,15,62,67,71,28,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,
3,156,245,103,215,120,252,250,250,252,195,185,155,177,227,252,227,159,175,180,
203,236,155,17,18,22,25,15,6,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,1,7,170,234,143,236,158,252,252,254,231,
145,240,222,252,246,178,146,177,180,196,228,146,14,19,22,15,14,1,2,0,
0,0,0,0,0,0,2,3,5,4,4,4,3,5,4,5,4,3,4,3,
2,2,2,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,
14,212,232,217,228,175,254,254,246,240,166,249,244,194,134,163,156,177,188,227,
115,7,17,18,18,9,3,1,0,0,0,0,0,0,0,0,1,1,1,2,
3,4,19,41,62,71,72,68,57,40,23,9,7,3,3,3,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,3,14,200,231,207,195,203,252,254,236,229,
174,240,158,143,153,170,163,188,219,92,12,17,28,28,4,2,1,0,0,0,
0,0,0,0,0,0,2,1,4,4,25,73,101,110,105,102,100,102,102,98,
94,83,52,14,2,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,
4,114,247,194,203,227,254,254,232,229,145,233,145,150,155,162,191,203,50,15,
10,15,9,3,8,1,0,0,0,0,0,0,0,0,0,0,4,4,19,76,
113,110,108,97,96,97,92,86,83,93,103,109,105,103,64,17,4,3,2,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,3,12,153,234,188,221,229,254,254,201,231,
147,227,134,142,155,203,147,18,16,10,7,3,2,2,1,1,0,0,0,0,
0,0,1,1,3,3,5,44,101,121,108,100,93,92,85,78,76,74,76,77,
85,95,106,112,118,110,51,4,3,5,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,2,3,2,4,
33,207,252,215,229,236,255,254,180,229,149,222,131,182,232,231,31,12,14,5,
1,3,0,0,0,0,0,0,0,0,0,0,1,1,1,12,69,116,125,116,
102,92,80,74,70,70,66,66,69,70,76,79,84,102,111,119,121,54,5,3,
1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,2,1,4,4,2,49,217,254,239,229,234,252,252,225,170,
166,232,240,254,254,220,7,5,2,2,1,1,0,0,0,0,0,0,0,0,
0,0,4,3,14,86,122,127,121,108,95,85,76,61,53,47,50,48,52,57,
64,69,76,83,96,112,120,127,57,3,2,1,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,2,4,3,
68,231,212,240,232,237,250,252,240,246,247,254,249,252,254,130,7,5,2,1,
0,1,0,0,0,0,0,0,0,0,0,0,4,5,76,136,130,119,115,108,
90,74,68,54,41,32,29,34,44,47,55,62,68,81,89,97,118,120,128,32,
3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,3,58,136,90,113,92,246,249,239,231,244,250,243,143,167,
177,207,254,252,254,207,18,6,1,1,0,0,0,0,0,0,0,0,0,0,
1,3,2,54,127,129,132,119,122,100,81,60,48,37,28,25,29,29,33,36,
44,55,60,72,83,95,111,124,132,109,2,2,4,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,7,162,178,192,217,
166,245,244,240,237,247,252,222,215,142,194,246,252,241,243,219,55,4,1,1,
2,0,0,0,0,0,0,0,0,0,0,2,12,113,141,137,134,112,113,95,
73,50,42,31,28,28,28,29,33,32,33,38,46,56,67,87,94,111,130,159,
24,2,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,2,7,207,147,151,213,145,243,252,229,236,252,252,236,229,209,
183,227,249,229,236,233,63,7,2,1,1,1,0,0,0,0,0,0,0,0,
0,0,42,149,146,145,136,113,108,90,76,55,34,35,29,29,28,26,32,34,
33,36,41,54,65,83,90,108,131,163,89,4,2,2,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,183,146,167,252,
236,175,247,203,234,252,254,236,219,217,185,126,217,252,167,205,121,46,7,3,
1,3,0,0,0,0,0,0,0,0,0,0,93,155,151,146,136,118,102,84,
77,60,36,32,28,25,29,28,34,37,36,38,41,54,61,81,96,114,141,168,
142,2,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,3,16,194,190,158,229,229,182,136,201,249,254,250,237,227,234,
172,175,131,234,211,243,137,49,15,2,2,3,0,0,0,0,0,0,0,1,
3,6,130,170,166,146,150,124,101,84,74,62,44,37,37,25,26,29,34,34,
37,44,51,56,65,78,95,120,141,164,170,8,5,2,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,14,88,155,175,190,
209,200,220,207,254,252,229,245,237,226,170,233,175,194,204,233,121,71,32,2,
3,3,0,0,0,0,0,0,0,1,1,12,146,170,177,162,147,126,111,92,
76,66,56,47,42,35,40,40,44,44,46,44,52,57,60,76,95,127,155,146,
174,16,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,3,9,142,207,207,219,194,207,246,244,254,254,221,240,240,215,
178,249,247,185,183,192,108,81,63,2,2,2,0,0,0,0,0,0,0,1,
1,15,150,149,182,170,162,143,116,100,81,63,47,48,40,41,37,46,45,44,
42,48,46,51,57,76,94,117,156,158,155,22,3,2,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,12,140,225,212,241,
198,190,239,249,252,255,217,240,236,212,191,236,252,227,132,147,145,76,88,4,
1,2,0,0,0,0,0,0,0,1,1,13,136,124,185,178,161,150,127,103,
80,71,56,36,30,34,33,36,31,34,42,48,42,41,69,101,98,97,146,152,
143,28,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,4,18,205,226,255,249,192,185,249,252,252,254,213,240,229,200,
211,241,249,240,34,23,153,82,94,7,2,4,0,0,0,0,0,0,0,0,
0,0,112,116,185,185,166,136,108,80,69,74,73,39,42,34,54,82,67,79,
92,97,137,182,166,122,143,164,147,147,146,35,2,3,2,2,2,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,23,211,236,247,234,
179,175,240,244,250,255,211,236,222,190,220,243,236,241,56,38,146,62,82,9,
5,3,0,0,0,0,0,0,0,0,0,0,120,124,186,182,156,131,125,100,
101,79,97,92,104,71,78,125,116,179,162,188,207,175,53,48,73,109,175,138,
142,50,16,28,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,4,45,204,237,252,240,207,194,239,243,245,254,213,237,222,182,
236,243,233,227,115,119,188,42,69,16,1,3,0,0,0,0,0,0,0,0,
0,0,104,130,180,167,170,188,161,156,178,170,192,195,158,81,45,79,71,131,
203,228,232,249,210,132,30,48,150,150,129,118,53,143,14,3,0,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,6,65,194,221,222,150,
227,219,222,243,254,246,211,232,219,172,232,239,241,209,120,145,190,39,56,42,
2,2,0,0,0,0,0,0,0,0,0,0,77,141,171,177,183,126,178,225,
229,205,203,229,237,190,55,49,37,191,230,240,244,246,243,249,233,170,167,145,
110,147,89,209,12,5,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,4,12,57,72,42,72,207,188,212,243,254,250,239,228,224,163,
233,172,172,211,129,150,182,58,51,74,2,4,0,0,0,0,0,0,0,3,
25,14,37,143,164,190,151,203,254,249,245,240,243,249,252,204,101,69,60,159,
236,243,252,246,247,246,249,249,219,79,115,150,145,141,10,4,2,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,3,3,62,
147,124,143,240,254,247,241,229,215,177,239,180,141,185,129,158,182,80,55,109,
5,4,1,0,0,0,0,0,0,14,142,115,95,158,147,182,203,254,252,254,
249,244,245,250,249,229,80,41,35,145,246,247,249,252,252,252,252,246,194,57,
89,142,137,82,29,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,1,4,3,3,3,68,236,254,237,249,230,216,192,
241,244,227,188,127,174,153,66,53,136,2,4,1,0,0,0,0,0,0,24,
200,177,116,150,143,138,196,252,250,252,254,252,250,254,249,166,77,39,46,35,
190,252,252,254,252,254,249,250,177,92,92,142,155,50,47,3,2,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,
5,2,92,246,254,226,220,198,205,201,244,247,249,170,124,170,134,42,38,106,
3,4,1,0,0,0,0,0,0,10,120,180,177,156,134,102,119,250,252,252,
252,252,249,254,245,97,62,35,40,42,80,234,255,254,252,252,250,219,145,84,
96,143,158,49,45,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,4,2,2,4,118,241,252,194,145,166,195,228,
247,252,252,190,155,200,134,37,30,101,2,4,1,0,0,0,0,0,0,7,
61,82,175,160,138,102,124,236,250,252,252,252,246,253,156,68,47,41,48,35,
47,95,185,247,252,252,212,102,78,72,112,158,160,70,46,3,1,2,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,
3,5,149,237,252,185,166,141,155,99,191,195,175,233,200,196,175,39,44,87,
2,5,0,0,0,0,0,0,0,6,62,78,160,160,159,122,134,210,249,254,
252,252,209,122,149,111,42,29,34,50,68,80,28,30,66,61,45,56,66,98,
115,170,182,96,71,5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,1,6,4,180,245,252,216,31,9,23,124,
200,241,231,146,52,46,74,60,60,97,2,4,0,0,0,0,0,0,0,4,
44,69,99,153,171,146,132,147,182,180,147,92,26,72,101,108,38,17,17,52,
65,53,53,31,37,44,50,45,69,101,128,185,195,92,56,3,2,2,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,
7,96,226,252,254,166,26,22,39,112,207,151,56,47,64,35,33,95,112,96,
2,3,0,0,0,0,0,0,0,5,23,64,61,136,180,155,138,106,89,66,
46,50,33,98,90,127,73,67,70,112,77,62,71,35,29,47,55,67,96,103,
129,195,207,161,28,5,3,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,1,50,178,230,254,252,117,36,24,41,88,
112,45,39,34,36,34,52,88,78,108,3,3,0,0,0,0,0,0,0,3,
7,112,108,136,185,166,153,106,98,78,57,48,51,138,212,230,196,185,190,231,
244,219,88,21,32,42,66,77,94,100,129,196,204,166,6,4,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,
34,140,236,252,240,79,35,28,42,68,52,46,17,23,54,63,87,70,56,76,
54,5,3,4,4,2,0,0,0,3,1,74,122,145,194,182,155,145,113,96,
77,57,50,119,210,201,209,222,190,93,85,96,55,38,36,53,72,83,101,103,
155,190,204,63,2,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,3,2,86,136,249,250,190,81,51,56,81,56,
39,19,51,82,64,35,53,88,81,79,94,60,16,3,3,4,0,0,0,2,
2,9,146,158,194,198,177,164,151,105,95,62,60,73,92,92,57,57,52,44,
58,67,65,58,52,58,79,81,103,122,171,183,203,17,3,6,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,1,6,
118,150,252,254,151,94,68,111,82,54,49,65,41,45,55,40,44,74,67,92,
104,103,106,24,4,4,0,0,0,5,2,3,79,179,175,207,186,170,152,124,
101,63,79,90,97,78,57,53,55,55,54,65,70,74,78,77,87,97,115,137,
156,177,200,18,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,3,4,6,96,146,252,243,142,108,124,138,96,69,
70,38,25,21,28,44,54,48,41,55,96,100,94,92,8,4,0,0,0,0,
0,3,12,48,172,209,194,194,170,143,130,102,106,112,87,92,89,89,95,102,
104,88,61,73,78,94,102,114,137,155,149,182,194,8,3,1,1,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,3,
30,170,249,229,131,136,152,155,136,113,55,36,14,8,18,22,28,40,40,47,
64,72,77,57,48,7,1,0,0,0,0,3,6,10,145,196,192,190,188,158,
138,118,111,121,132,150,203,195,195,188,188,203,164,97,84,100,122,134,152,160,
158,175,177,7,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,4,79,200,249,198,126,114,66,115,145,56,
50,30,39,56,30,13,8,23,26,29,71,86,67,56,77,28,2,1,0,0,
0,3,5,5,105,195,190,180,190,177,162,132,112,194,215,158,78,46,44,32,
31,73,155,150,103,102,129,151,155,155,158,190,166,17,5,4,3,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,4,
69,222,250,145,101,103,73,87,163,68,62,79,101,73,18,9,12,12,19,28,
70,115,110,68,92,31,2,2,1,0,0,3,4,2,56,200,191,177,186,185,
172,143,122,143,115,92,86,92,108,113,89,99,105,104,101,108,131,170,161,162,
160,201,237,243,122,18,3,4,3,2,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,20,230,186,85,89,143,182,158,198,103,
111,45,90,85,55,38,28,33,36,55,84,98,126,113,99,33,1,2,2,0,
0,1,1,3,16,177,195,188,182,196,172,149,125,141,142,146,155,142,145,131,
122,121,87,112,93,120,136,170,166,160,188,233,240,237,221,175,60,4,4,5,
3,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,
13,200,134,50,30,63,142,221,196,158,155,88,69,79,74,156,145,163,177,158,
145,134,121,109,106,80,1,2,2,0,0,1,4,3,3,105,207,195,188,200,
178,155,145,132,118,126,104,102,110,115,93,92,106,124,117,136,155,171,175,183,
213,245,252,232,200,215,192,109,10,5,2,3,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,3,1,1,22,104,58,49,30,65,188,145,152,
215,237,159,166,215,195,185,221,209,237,209,194,132,108,145,92,1,2,2,0,
0,1,2,6,4,30,200,203,188,209,198,175,166,156,152,140,90,109,129,120,
92,97,143,145,145,152,172,180,175,195,240,252,254,239,233,196,207,200,145,23,
3,6,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,1,
2,70,147,79,42,26,33,90,128,174,240,249,252,245,216,220,254,252,236,243,
168,86,87,130,177,47,1,1,1,0,0,1,4,5,3,87,194,209,203,196,
204,183,182,171,160,126,83,63,55,53,70,79,108,116,138,146,172,182,188,227,
249,252,252,250,239,211,225,185,194,160,22,5,3,1,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,2,4,7,68,58,105,53,38,29,33,145,241,
249,247,243,224,224,252,252,254,228,243,130,39,36,134,170,8,0,0,0,2,
2,5,3,12,119,246,245,229,207,194,196,194,172,168,151,129,76,58,60,53,
48,66,92,115,136,149,177,190,213,249,250,252,254,246,236,244,213,188,194,168,
143,22,4,2,2,1,0,0,0,1,0,0,0,0,0,0,0,0,2,3,
12,68,10,106,70,52,35,33,113,230,246,243,236,222,243,254,255,254,241,159,
112,89,39,172,82,1,1,0,0,5,4,4,12,119,225,240,252,247,234,205,
201,198,172,177,160,116,93,76,72,85,77,74,99,124,136,175,213,224,246,252,
247,254,254,249,239,236,215,216,195,177,177,119,19,3,2,5,1,0,0,0,
0,0,0,0,0,0,0,0,1,0,2,37,83,125,92,57,49,42,81,200,
243,240,234,231,254,254,255,252,233,58,16,23,93,190,7,4,1,0,0,2,
6,14,138,203,209,230,250,254,249,226,215,216,178,179,167,147,134,124,119,103,
100,124,134,143,168,216,237,243,252,249,250,254,254,252,240,230,204,225,164,175,
186,162,125,26,7,4,1,0,0,0,0,0,0,0,0,0,0,0,0,2,
3,2,2,71,124,80,57,40,48,101,160,241,236,243,254,255,254,249,188,21,
50,62,201,99,4,3,1,0,0,4,23,145,191,205,209,211,254,254,252,249,
234,234,219,185,168,162,162,161,147,161,160,180,174,190,224,245,252,254,254,252,
254,252,254,249,244,243,210,183,170,194,168,158,185,131,29,7,2,1,0,0,
0,0,0,0,0,0,0,0,1,1,3,4,7,29,146,92,57,44,40,51,
84,211,244,249,252,255,254,236,71,23,30,101,207,23,3,2,1,0,0,1,
132,183,198,167,198,236,244,255,252,254,249,240,246,229,209,196,200,200,210,225,
233,232,233,245,254,254,255,252,252,254,252,252,252,252,252,249,224,210,203,143,
188,170,160,168,138,46,3,3,0,2,1,0,0,1,0,0,0,0,0,0,
1,2,4,6,147,101,74,62,51,44,73,134,241,249,252,250,240,115,19,20,
52,152,152,2,2,3,0,0,0,1,185,207,195,149,191,244,252,254,252,254,
255,252,249,250,247,247,249,250,254,254,252,252,254,254,254,254,254,252,255,252,
252,252,252,254,252,250,220,185,201,194,179,163,170,178,183,140,55,2,9,5,
1,1,1,1,0,0,0,0,0,0,1,1,1,3,92,150,114,84,60,61,
78,72,180,249,179,220,114,12,18,38,109,186,66,2,3,2,0,0,0,1,
231,192,134,143,175,221,255,252,254,252,254,255,255,250,250,254,252,252,252,253,
254,255,255,254,252,249,252,252,252,249,249,250,249,254,254,246,236,180,150,194,
195,158,203,178,170,182,175,86,8,4,0,1,1,0,0,0,0,0,0,0,
0,0,2,2,12,186,152,86,74,76,74,49,101,195,126,46,12,20,41,76,
150,177,16,3,1,2,0,0,0,1,210,128,136,203,246,229,252,254,254,252,
252,252,254,254,254,254,254,254,254,255,255,255,254,254,254,254,252,252,243,247,
252,250,252,252,249,252,250,177,177,201,191,209,178,203,198,179,180,182,100,18,
1,3,3,1,0,0,0,0,0,0,0,0,1,5,4,31,180,131,95,70,
86,55,65,48,24,28,33,53,64,108,163,111,2,3,2,1,0,0,0,1,
153,103,233,194,241,240,254,254,254,252,254,252,254,254,255,255,255,255,255,255,
255,255,254,254,252,250,249,244,243,246,250,249,249,245,244,254,245,209,171,209,
217,191,190,185,185,198,194,190,194,141,40,1,4,5,5,3,3,4,2,1,
2,2,3,2,1,1,57,191,141,108,95,56,40,34,36,52,57,69,113,166,
209,44,3,2,3,1,0,0,0,1,118,186,198,249,237,234,255,254,254,250,
252,252,254,254,254,255,254,252,252,254,254,254,254,252,245,245,246,243,246,252,
246,252,247,244,243,249,243,198,221,207,234,196,196,191,194,200,210,209,209,213,
200,129,69,25,12,9,2,6,7,2,5,4,1,3,4,0,2,76,230,164,
124,70,52,58,82,103,109,145,188,211,201,9,1,1,3,1,0,0,0,1,
106,179,236,239,244,239,254,254,254,249,249,249,252,252,252,250,247,244,245,243,
246,243,243,245,240,239,241,243,247,250,249,250,244,249,245,245,250,243,174,203,
219,191,188,207,188,209,219,225,226,220,213,230,198,127,56,29,31,22,9,5,
3,4,2,2,1,3,1,3,145,229,192,121,90,86,92,132,198,213,225,228,
192,15,3,1,2,1,0,0,0,1,110,190,233,236,252,252,252,252,254,249,
243,243,246,249,249,249,249,245,249,249,241,243,240,239,231,234,241,245,249,245,
241,249,239,245,246,239,250,245,211,217,224,180,203,219,221,211,217,222,236,234,
232,231,243,240,167,128,76,70,68,63,52,35,12,1,3,1,3,2,42,232,
232,203,160,140,129,152,185,220,227,194,171,110,5,3,3,0,0,0,0,1,
111,228,230,246,254,252,249,252,252,249,240,239,241,246,243,155,104,102,119,182,
224,233,229,227,222,227,243,245,243,241,243,240,243,237,246,237,250,249,224,219,
229,225,179,205,220,243,233,243,246,243,236,215,204,204,166,136,145,149,138,145,
225,240,212,170,129,54,2,4,48,239,229,239,229,228,219,185,152,166,172,158,
143,194,50,3,7,4,0,0,0,1,179,213,232,249,247,247,246,250,254,252,
243,243,241,237,216,98,62,68,73,97,228,217,220,219,219,224,240,241,239,241,
241,245,239,240,233,236,247,252,247,229,216,230,213,194,175,191,229,217,205,203,
216,244,254,254,246,230,240,219,234,116,219,243,241,243,249,252,219,132,188,245,
237,240,237,227,205,215,215,194,171,153,155,211,209,51,6,2,0,0,0,1,
166,220,245,241,232,236,244,247,252,250,244,241,243,231,250,207,85,62,96,120,
224,236,212,215,219,222,239,243,237,240,249,245,231,241,219,237,252,252,249,252,
243,237,215,198,215,198,201,233,254,254,252,254,252,254,246,237,219,213,230,94,
146,237,246,234,245,243,244,216,236,252,236,237,249,243,209,172,174,179,178,167,
166,236,205,161,6,3,0,0,0,1,177,236,234,225,228,233,243,246,252,252,
244,249,233,252,254,252,136,76,124,150,250,252,236,205,219,224,234,239,236,244,
247,239,240,228,220,240,254,252,252,247,252,244,243,215,222,249,254,254,252,252,
252,254,254,252,234,212,231,236,230,115,159,236,243,236,234,231,243,227,232,255,
243,229,231,239,220,151,158,150,170,175,210,230,200,227,30,2,0,0,0,1,
205,231,222,216,224,229,241,245,252,250,250,245,243,254,254,252,215,57,110,162,
252,252,254,227,211,227,229,231,233,249,247,236,239,221,222,243,250,252,252,252,
254,247,201,170,24,45,126,158,198,194,228,247,254,254,236,203,231,240,195,101,
190,212,246,230,237,236,244,246,229,233,249,215,216,209,194,120,93,124,143,174,
219,231,194,252,162,9,1,3,1,1,226,225,211,213,219,219,240,245,250,252,
252,240,249,252,249,252,227,141,79,162,240,232,227,252,229,224,231,231,240,247,
241,236,226,224,222,245,250,252,249,250,247,249,217,170,151,143,119,132,141,149,
150,120,124,153,145,166,126,177,192,151,192,201,244,229,219,236,243,244,244,226,
231,221,198,186,198,115,80,89,112,156,209,225,213,254,245,48,2,2,4,1,
229,213,213,211,215,215,243,240,247,252,247,247,243,236,237,245,174,104,71,69,
158,219,220,236,227,220,215,231,243,245,234,232,215,222,228,252,246,246,245,249,
246,252,183,140,53,94,117,182,131,125,194,220,145,162,134,134,111,111,124,150,
137,209,243,224,201,243,240,249,240,249,249,243,229,215,207,190,160,145,149,151,
198,227,215,252,237,102,1,3,1,1,212,207,207,204,209,204,245,230,243,252,
243,252,239,229,240,241,158,112,81,60,103,222,234,225,220,236,211,229,244,241,
233,219,215,217,229,252,245,249,246,252,249,250,226,198,77,102,39,44,209,207,
156,194,240,227,211,162,149,192,180,211,166,190,236,204,236,200,234,247,249,239,
244,252,252,252,254,254,252,252,249,227,186,229,222,243,200,177,5,2,1,0,

/* #6: Trinity face pic? (originally by Alex) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,2,2,3,1,2,1,2,1,0,
3,1,5,1,5,2,2,2,3,1,1,5,1,1,0,2,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,2,1,2,2,1,3,7,21,37,73,85,80,26,23,82,121,127,96,
50,14,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,4,4,67,145,221,
243,247,250,250,207,183,247,247,243,252,249,195,95,16,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,7,2,3,8,60,164,232,249,245,240,241,245,246,249,247,249,244,245,243,
245,250,241,198,84,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,1,1,0,0,2,18,131,240,254,249,246,245,
243,243,246,252,249,249,249,249,245,245,244,247,249,250,240,134,7,2,1,5,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,2,4,
1,3,52,185,249,250,250,250,249,246,245,243,243,244,249,249,247,250,249,247,
244,243,246,247,250,247,166,35,5,2,3,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,2,2,2,5,44,215,249,250,250,249,252,252,249,
246,244,243,245,250,249,246,252,252,247,244,245,247,252,252,249,252,198,44,3,
5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,6,
55,212,252,254,250,252,250,252,252,252,249,244,240,241,246,249,244,247,254,250,
249,243,245,245,250,254,252,252,216,69,4,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,2,2,1,2,25,192,249,252,249,252,252,252,252,252,252,
250,245,240,240,244,252,243,243,252,254,252,249,243,249,247,250,254,254,252,210,
63,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,18,156,
252,252,252,252,249,254,254,254,252,254,250,244,243,246,245,249,249,243,249,252,
252,252,252,250,249,252,252,252,254,254,216,38,4,2,2,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,3,8,124,246,254,252,252,252,252,252,252,254,252,254,
247,243,243,249,250,252,252,243,249,249,245,246,252,254,254,254,252,252,254,254,
254,167,13,4,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,66,236,252,
252,252,252,252,252,252,252,254,250,252,249,245,245,237,240,240,233,225,210,207,
191,215,239,252,254,254,254,254,254,254,254,239,87,2,2,4,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,2,31,200,252,254,252,252,252,252,252,252,252,252,252,255,
247,230,215,186,153,126,104,113,87,94,108,131,171,220,249,250,254,254,254,254,
254,254,203,12,3,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,131,249,252,250,
254,252,252,252,252,252,254,254,250,236,200,158,119,93,68,51,53,49,57,65,
74,92,116,166,228,252,254,254,254,254,254,254,249,61,2,6,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,1,70,233,254,250,254,252,254,254,254,252,252,254,249,229,179,
120,90,70,55,39,37,32,38,44,48,55,70,86,108,161,231,254,254,254,254,
254,252,254,166,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,1,2,6,166,252,252,252,254,
254,254,254,254,252,254,252,229,177,120,86,68,55,44,35,29,26,28,32,37,
41,58,69,86,115,182,243,254,252,254,255,254,254,215,40,3,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,2,62,250,252,252,252,254,254,254,254,252,252,253,221,162,117,82,
71,60,48,39,28,20,24,23,25,31,36,50,61,71,88,120,195,241,254,252,
254,254,254,250,76,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,3,13,162,254,252,252,252,252,
254,254,254,249,254,234,159,103,95,78,70,60,48,38,26,21,23,25,28,31,
34,46,57,68,85,102,143,186,241,254,252,254,252,254,109,4,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,53,220,254,252,252,254,252,252,252,254,252,245,177,110,90,81,74,
71,63,50,42,28,24,23,26,30,33,34,46,57,69,83,97,116,132,196,246,
254,254,254,254,159,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,2,3,116,254,249,252,252,254,254,
254,254,254,249,215,121,93,78,79,72,68,62,52,45,29,24,25,28,31,35,
38,46,57,68,79,92,99,119,149,207,252,254,254,254,215,3,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,4,182,254,252,250,252,252,254,254,254,254,237,167,106,86,83,80,72,
66,62,53,41,32,26,30,31,31,34,37,44,50,66,77,83,100,109,126,162,
232,254,252,254,232,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,2,60,241,254,252,250,252,252,252,
254,254,247,194,126,100,80,77,73,72,64,60,51,40,29,26,33,37,35,39,
44,42,55,67,76,88,94,103,117,134,196,252,254,252,234,9,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,127,249,254,252,252,252,252,252,254,254,222,162,115,101,84,76,76,66,
65,62,54,47,39,39,42,44,40,44,48,49,60,71,80,89,102,118,119,122,
174,250,252,252,230,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,19,185,254,254,254,254,252,252,254,
254,250,185,140,115,103,106,142,142,136,104,96,71,60,54,56,55,53,50,56,
60,55,76,124,166,196,219,234,220,156,145,244,249,252,229,3,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,47,241,252,254,255,254,252,252,254,254,243,163,134,118,149,191,212,217,229,
230,225,215,196,142,87,72,66,63,71,71,106,192,234,246,243,236,217,216,215,
132,241,252,249,230,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,97,255,252,252,254,254,254,252,252,
254,225,158,136,136,198,174,112,111,128,163,209,234,241,221,140,90,79,76,85,
88,155,226,243,213,166,127,108,137,180,143,236,250,252,227,2,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,174,254,254,254,254,237,241,252,254,252,200,134,127,155,155,105,89,92,92,
88,92,143,196,210,177,116,80,69,93,140,215,222,182,127,121,141,160,164,150,
124,213,254,249,195,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,15,211,254,254,252,254,236,232,252,254,
252,183,114,115,145,137,128,151,182,207,194,200,190,152,175,204,141,72,51,78,
174,222,191,198,220,237,245,244,229,172,119,172,249,243,170,3,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
51,227,252,252,252,239,228,244,246,254,243,156,100,98,116,142,182,239,252,252,
228,243,231,240,155,182,151,60,39,72,194,188,229,232,236,240,244,247,243,204,
118,136,247,247,126,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,83,241,250,254,252,233,174,213,239,250,
236,143,104,88,95,136,203,245,249,231,221,220,100,186,164,104,130,72,41,72,
138,117,164,155,205,216,143,231,240,183,124,121,245,254,92,2,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,
125,249,254,249,254,241,127,178,221,243,226,146,100,84,70,83,88,177,219,180,
162,127,102,94,57,60,97,72,35,60,102,53,64,93,132,182,201,209,178,143,
113,116,231,254,87,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,2,0,6,150,250,249,246,249,249,134,145,215,243,
226,145,100,87,68,60,68,87,114,109,111,87,60,44,48,68,90,70,39,54,
104,70,57,67,92,113,115,111,124,115,103,108,226,254,79,2,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,1,12,
177,250,247,245,249,249,177,103,188,207,217,151,106,92,74,58,49,54,44,44,
46,40,39,44,54,76,86,77,47,58,102,96,66,56,66,74,84,92,96,99,
104,112,228,254,74,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,1,0,14,201,249,246,245,249,246,221,89,119,143,
213,171,121,95,83,69,57,53,51,39,36,38,40,48,69,81,87,81,51,60,
92,111,89,65,63,68,72,77,92,100,105,118,234,249,70,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,20,
226,249,245,243,247,250,241,120,96,150,196,188,134,101,92,76,64,64,57,44,
40,39,42,46,70,83,89,74,50,50,82,110,100,73,61,62,68,74,92,108,
117,134,237,240,63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,25,247,249,246,243,247,249,249,227,137,85,
180,203,155,117,93,81,73,73,68,54,41,40,41,44,62,97,105,70,45,38,
76,120,104,77,66,71,76,85,102,115,124,132,241,219,46,2,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,
250,249,249,244,247,250,250,225,188,161,179,212,166,125,99,84,78,73,65,54,
44,42,37,46,72,108,102,73,44,36,65,112,103,76,65,73,80,93,110,125,
125,149,243,198,28,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,50,250,252,252,246,249,252,247,252,185,113,
124,203,168,132,106,89,83,76,70,61,55,52,53,58,87,108,117,119,71,65,
101,136,105,83,77,80,90,101,119,132,124,185,249,188,22,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,64,
250,250,252,247,249,250,246,249,243,177,112,180,174,138,112,99,89,83,76,69,
62,56,58,70,82,156,215,224,166,158,207,212,131,92,84,89,98,109,130,130,
124,226,254,174,18,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,72,252,250,250,249,249,249,247,250,249,252,
212,226,185,143,131,113,102,90,81,71,67,65,71,65,47,129,210,219,219,228,
240,229,127,98,93,95,108,115,132,130,151,246,254,159,12,3,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,90,
252,252,252,250,250,246,247,250,246,252,255,254,207,160,146,132,114,95,87,82,
69,64,61,52,47,55,92,122,185,209,209,166,97,81,92,110,128,136,146,132,
174,252,254,143,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,2,3,103,254,250,252,252,252,249,247,247,243,249,
254,255,221,170,155,145,131,110,97,86,76,71,56,54,60,56,54,49,83,95,
119,110,87,79,92,108,136,146,149,138,190,255,254,120,3,2,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,113,
254,252,252,252,252,250,252,249,245,249,254,254,236,182,166,155,146,129,110,92,
81,77,74,76,57,55,68,71,61,68,106,115,95,92,99,116,145,156,155,146,
216,254,254,70,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,2,0,124,254,254,252,252,250,250,252,250,247,250,
254,255,244,194,163,149,146,136,117,95,92,97,87,83,100,134,124,127,145,168,
166,182,168,111,100,129,150,161,150,145,241,254,254,29,2,2,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,132,
254,252,252,252,252,252,252,252,250,252,254,255,253,212,166,140,134,134,115,90,
89,98,138,195,226,212,210,225,227,229,222,216,237,209,130,136,145,151,140,158,
252,254,237,6,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,2,150,254,254,254,254,252,252,254,254,254,254,
254,254,255,236,185,145,126,130,116,88,79,89,140,166,182,160,156,166,178,182,
178,200,209,182,143,136,141,143,132,196,254,254,201,6,1,2,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,145,
254,254,254,254,252,252,254,254,254,254,254,255,254,249,215,163,130,128,115,97,
76,74,78,79,121,136,78,41,31,38,88,155,141,113,110,128,142,145,140,227,
254,254,152,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,4,149,254,254,254,254,252,252,254,254,254,254,
254,255,252,254,240,200,152,136,129,110,83,73,73,76,108,149,161,160,147,158,
175,168,134,108,110,134,156,147,177,250,252,252,108,2,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,4,155,
254,254,254,254,252,252,254,254,254,254,254,255,254,254,246,232,191,155,138,124,
97,82,79,78,78,109,163,201,207,198,174,143,120,111,118,142,163,146,227,254,
250,241,77,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,1,12,175,254,254,254,254,252,252,254,254,254,254,
254,254,255,255,249,245,231,190,171,136,113,97,84,81,63,73,77,79,82,80,
87,97,108,124,137,162,164,201,252,252,252,220,45,3,1,3,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,18,191,
254,254,254,254,252,252,254,254,254,254,254,255,254,254,246,241,243,225,194,164,
134,110,95,83,66,51,47,45,50,55,67,83,101,122,147,167,183,243,255,254,
252,203,20,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,2,2,31,207,254,254,254,254,254,252,254,254,254,254,
254,254,254,254,245,236,241,240,222,204,178,141,112,97,71,58,49,45,46,52,
69,90,112,136,155,170,243,255,252,254,252,183,6,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,2,53,227,
254,254,254,254,254,254,254,254,254,254,254,255,255,254,243,224,231,243,237,227,
209,185,145,121,94,83,72,74,73,76,90,116,138,151,188,243,254,254,254,254,
254,155,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,2,2,76,243,254,254,254,254,254,254,254,254,254,254,
254,255,255,252,240,210,213,232,240,236,228,219,194,170,142,117,109,113,116,124,
138,161,166,194,245,252,254,255,252,252,255,119,2,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,92,252,
254,254,254,252,254,254,254,254,254,254,254,255,254,245,228,195,194,215,231,237,
237,231,225,213,204,188,177,179,180,186,194,201,219,233,249,254,252,254,254,254,
254,65,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,3,3,111,250,254,254,252,252,252,254,254,254,255,254,
254,254,250,226,219,175,160,190,217,229,233,236,236,236,231,228,221,220,217,221,
228,239,240,236,249,255,255,254,252,254,254,34,0,1,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,137,254,
250,254,252,252,252,252,254,254,254,254,254,254,227,183,198,158,131,136,164,212,
227,231,232,236,236,237,241,240,240,241,244,240,239,232,249,255,255,255,254,254,
227,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,4,158,254,252,254,254,252,252,252,252,252,252,252,
252,233,172,147,170,138,110,112,128,177,209,228,234,236,237,239,241,241,240,241,
240,239,233,230,249,254,255,255,254,254,182,13,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,216,254,
252,254,254,254,254,254,254,252,254,249,219,178,111,108,118,118,96,90,97,130,
175,211,228,231,233,234,239,236,237,240,241,234,229,227,249,254,255,254,255,254,
136,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,10,247,254,252,254,254,254,254,254,250,252,222,170,
153,132,78,82,82,97,83,77,83,104,134,178,207,222,231,234,236,236,236,237,
237,230,227,222,243,255,254,254,254,249,104,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,2,1,1,1,1,1,1,2,2,1,1,1,0,1,1,52,252,254,
252,254,252,254,254,252,240,200,140,113,115,104,60,61,65,76,74,69,72,87,
106,141,179,204,222,226,232,232,236,233,231,229,227,221,240,254,254,254,252,237,
68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,2,1,2,5,3,1,1,1,1,
1,1,0,1,1,3,4,120,252,254,255,254,254,236,209,158,104,96,98,95,
103,88,49,47,53,63,66,64,68,70,82,108,149,185,207,215,224,230,232,230,
229,222,224,215,236,254,254,254,254,221,23,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,3,2,2,1,1,4,3,2,2,3,2,3,21,180,255,255,
252,203,164,131,77,83,86,82,87,93,89,77,37,38,44,49,58,61,63,64,
73,92,125,164,188,200,210,225,226,222,222,220,219,210,225,252,254,254,254,194,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,2,2,1,2,5,12,19,26,29,
32,28,29,29,37,30,52,122,112,93,96,83,87,83,70,87,77,79,86,82,
83,70,31,37,38,40,48,55,56,58,63,77,104,134,168,177,190,205,210,217,
219,217,207,207,209,243,252,252,254,119,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,7,20,37,44,52,60,64,63,64,61,65,69,86,74,85,97,84,71,
84,78,86,71,77,87,81,77,78,85,80,69,32,38,36,36,40,46,53,60,
65,78,98,119,143,151,167,179,190,209,213,207,194,190,192,220,252,254,249,65,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,4,30,54,67,65,58,58,61,67,69,
71,66,72,76,80,72,89,92,83,73,79,76,84,76,85,79,83,83,82,76,
76,65,32,37,34,34,36,41,44,52,57,70,87,108,120,129,143,151,166,198,
198,190,175,161,164,188,219,254,215,37,2,2,2,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,
39,67,67,60,54,50,49,52,60,62,60,66,72,86,76,81,87,84,71,72,
76,71,78,76,84,83,83,81,80,80,74,66,37,36,37,36,36,38,42,52,
56,70,79,94,106,109,108,118,140,177,168,160,158,141,142,170,147,186,156,14,
2,2,2,3,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,5,8,12,25,37,30,28,25,26,31,48,
49,68,72,87,68,83,80,77,72,78,72,66,70,71,81,84,83,79,80,80,
76,79,49,35,38,36,40,39,45,52,51,62,74,78,87,83,82,90,122,158,
145,127,141,125,120,137,143,85,88,30,5,2,1,3,3,2,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
8,12,25,37,30,28,25,26,31,40,45,53,72,79,67,74,71,71,76,81,
69,67,66,66,74,76,76,77,79,79,72,72,60,61,55,49,50,53,57,56,
53,55,68,69,71,64,58,65,103,136,119,118,124,118,101,104,142,92,71,71,
40,8,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,5,8,12,25,37,30,28,25,26,31,35,
42,50,71,69,57,58,62,66,76,78,61,69,65,64,66,70,72,76,76,76,
72,66,44,48,51,55,53,53,53,48,49,55,64,69,65,57,46,52,88,115,
105,108,108,110,98,89,115,105,73,69,72,54,23,4,1,2,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

/* #7: Neo face pic (originally by Alex) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,9,19,33,14,2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,1,0,1,1,2,2,3,13,20,43,55,64,114,150,149,71,31,6,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,7,4,3,5,4,4,2,2,4,30,70,128,
191,200,197,214,237,226,209,203,185,131,79,11,2,0,1,1,2,2,1,2,
2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,4,
5,2,2,3,6,5,47,133,145,222,228,241,251,253,253,253,245,254,242,230,
204,123,73,46,11,6,3,3,2,3,5,2,3,1,3,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,3,2,4,3,2,4,11,5,39,153,184,225,251,
250,249,253,251,251,252,251,253,253,251,253,248,229,197,126,97,45,6,4,2,
5,3,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,9,81,
115,96,97,122,86,142,191,224,248,250,253,251,248,251,251,250,251,248,253,253,
250,252,253,244,222,221,190,132,92,19,3,3,2,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,2,2,3,3,54,200,224,215,224,247,240,221,223,248,252,252,
247,242,253,253,251,251,251,253,250,254,253,254,248,252,253,250,240,240,242,151,
34,2,2,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,2,3,4,4,7,94,201,
204,227,241,251,252,245,242,244,245,249,244,242,253,254,253,252,249,253,253,254,
254,254,250,252,250,250,254,252,251,242,154,27,1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,1,1,4,29,157,245,238,248,250,248,252,251,249,246,244,248,
244,241,252,253,253,252,252,254,253,253,252,253,252,254,254,252,252,251,248,250,
248,130,9,1,4,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,3,15,137,235,253,
251,252,250,243,245,252,246,249,249,250,246,244,251,254,253,251,253,253,251,251,
253,252,252,252,254,254,252,254,251,250,248,231,85,5,3,2,1,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,3,2,3,69,233,251,250,251,253,251,246,244,244,240,243,246,251,
246,242,243,250,251,250,250,253,252,252,251,251,250,249,252,254,252,252,251,250,
240,241,168,20,1,3,1,1,1,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,3,1,25,184,251,246,252,
252,250,253,249,251,243,238,242,238,245,245,242,242,243,239,223,194,192,202,238,
243,252,253,251,252,254,254,252,253,250,245,246,227,78,3,1,2,3,1,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,1,3,3,92,240,250,250,252,253,253,253,252,245,237,212,183,167,196,
212,223,229,229,193,134,78,62,77,146,190,234,252,252,254,254,253,251,253,251,
253,244,248,146,3,3,2,3,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,0,1,14,151,249,250,253,254,
253,253,251,250,228,176,119,80,58,78,99,124,143,151,99,45,22,18,30,63,
107,163,207,224,245,254,251,251,250,250,252,252,252,214,17,2,1,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,2,39,201,244,251,253,250,254,252,234,190,130,89,60,52,46,36,
32,34,37,50,40,25,21,23,23,23,28,48,88,118,176,227,248,251,249,247,
252,252,252,253,64,2,0,2,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,51,222,249,253,252,252,
250,231,190,138,95,79,61,48,46,37,34,29,26,28,25,19,16,19,20,14,
16,22,40,57,79,159,235,249,250,248,251,251,251,251,105,2,2,2,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,2,1,46,211,252,252,254,251,234,209,164,123,92,76,59,48,44,33,
34,27,21,21,21,13,10,15,15,16,21,19,22,28,40,88,174,227,244,246,
249,249,252,252,160,13,1,1,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,2,2,49,216,254,254,254,233,
204,200,166,129,98,79,56,46,40,32,33,25,24,26,13,7,7,7,6,10,
17,20,20,21,34,38,76,152,220,243,248,249,251,251,216,54,2,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,1,0,76,237,254,251,249,220,188,189,161,133,107,82,58,46,39,34,
31,24,23,24,13,7,7,7,5,8,11,18,22,24,29,31,40,92,188,243,
251,251,250,251,240,89,3,1,1,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,94,244,252,251,249,218,
189,193,165,138,119,97,70,51,38,32,33,29,24,24,16,9,7,5,4,7,
10,16,21,25,27,30,33,61,149,235,246,253,252,253,249,126,8,2,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,0,92,245,250,251,247,223,198,200,176,149,129,109,79,53,44,41,
39,34,32,31,23,15,12,9,8,9,12,16,21,24,26,28,35,46,106,212,
237,248,252,252,251,175,18,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,1,2,106,249,249,251,247,228,
206,201,181,152,133,123,99,67,52,45,43,39,37,36,26,18,16,16,15,14,
14,16,21,24,26,28,37,46,82,187,236,244,250,251,251,209,26,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,124,252,250,251,246,232,210,195,177,150,131,129,112,78,61,49,
45,41,37,36,26,19,20,22,21,18,15,15,20,24,29,33,38,46,75,166,
234,250,251,251,253,235,47,2,1,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,2,1,2,138,252,254,251,243,235,
214,188,172,145,127,126,113,79,62,49,46,43,39,39,31,24,25,24,19,17,
12,14,19,24,32,36,39,47,79,158,221,252,250,252,252,249,76,2,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,1,1,3,176,252,253,251,241,237,212,184,169,153,128,121,103,78,55,44,
41,44,43,43,26,26,20,19,16,13,11,19,19,28,30,37,40,48,76,169,
221,249,251,253,249,253,105,2,1,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,1,4,210,255,251,249,243,234,
215,182,154,141,121,115,89,61,48,38,30,36,41,40,20,16,11,14,9,13,
17,23,29,34,31,38,40,52,82,176,227,249,247,253,253,254,122,2,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,1,7,213,251,254,249,243,235,219,181,139,126,116,106,79,53,45,35,
30,28,36,33,18,12,11,16,11,14,16,20,28,30,34,39,42,56,95,190,
235,248,251,253,249,252,136,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,1,2,181,242,248,245,239,238,
208,160,121,97,100,107,91,67,57,40,36,30,41,39,27,19,13,14,9,12,
10,15,23,27,35,42,48,57,96,202,247,246,251,253,252,254,152,1,1,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,3,163,252,244,233,238,242,223,196,178,158,144,129,111,102,97,66,
59,53,64,56,46,44,23,22,24,41,51,72,82,78,58,53,47,47,75,177,
242,251,251,252,250,252,170,1,1,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,2,4,156,247,244,237,248,251,
252,252,253,254,245,230,206,183,152,94,87,76,82,74,65,101,111,143,170,199,
221,235,238,236,210,186,145,85,55,141,234,251,251,252,250,252,178,1,1,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,3,6,123,242,251,248,253,253,254,255,254,254,254,255,254,251,237,183,
129,91,88,100,133,216,239,250,255,255,254,254,255,255,253,251,240,214,134,102,
218,251,252,251,251,251,188,6,3,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,3,1,5,4,69,193,245,252,249,254,
254,252,254,255,254,254,253,253,254,245,197,141,114,140,229,253,253,254,254,254,
254,254,254,254,252,249,246,243,238,193,208,245,253,252,251,251,206,18,2,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,2,6,43,181,242,254,254,254,254,254,254,254,252,254,254,252,245,250,
205,122,80,127,247,250,250,254,254,254,254,254,254,254,253,254,252,240,242,216,
171,229,250,247,253,252,184,4,1,0,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,2,2,3,49,210,253,250,252,254,
254,254,254,254,254,254,254,253,250,251,205,97,33,96,249,248,253,254,254,254,
254,254,254,254,254,252,252,244,241,205,152,239,247,251,248,250,178,8,1,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,4,111,243,250,253,254,254,254,254,254,254,254,254,254,254,252,250,
181,61,16,62,245,252,254,253,254,254,254,254,254,254,253,254,252,247,242,202,
139,237,250,246,252,235,127,4,3,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,1,2,3,116,241,248,251,252,253,
253,254,254,255,252,252,255,255,252,246,176,61,21,35,208,252,254,253,254,254,
254,254,254,255,255,254,251,249,248,140,107,232,250,250,204,102,50,9,2,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,1,1,2,91,225,243,237,251,253,253,253,254,253,252,254,254,252,247,236,
150,54,19,25,120,243,252,250,248,250,251,253,252,252,251,252,251,246,169,48,
77,219,253,244,64,67,126,28,2,2,3,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,2,0,0,3,89,234,234,227,244,251,
254,255,252,250,253,251,252,240,224,221,145,54,24,31,66,189,247,247,252,251,
251,251,254,253,251,250,244,197,90,37,55,199,247,186,48,130,182,53,2,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,2,3,93,243,233,234,245,243,248,250,251,254,249,248,232,173,171,218,
143,56,20,30,39,89,208,245,241,247,249,250,252,250,247,236,204,124,54,44,
48,184,222,86,48,51,134,61,3,2,3,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,0,2,2,119,238,218,232,244,242,
238,234,228,220,220,210,152,106,174,227,135,49,17,21,41,28,65,151,209,213,
207,196,185,169,140,106,70,43,40,48,51,178,195,66,30,21,50,47,3,2,
3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,1,5,173,236,213,233,236,220,201,171,138,112,104,97,83,111,189,218,
136,47,17,21,39,37,22,15,44,62,52,34,28,23,19,17,21,33,36,54,
58,180,166,69,132,61,31,28,3,2,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,2,2,2,13,226,240,208,225,224,201,
170,141,117,94,74,73,78,137,205,212,122,46,13,23,39,39,23,9,7,6,
9,17,13,16,18,16,25,32,44,54,64,194,131,110,212,123,39,19,3,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,2,2,65,244,240,202,211,221,190,170,145,110,92,82,69,79,156,204,199,
100,35,12,22,42,43,35,17,13,12,9,15,21,26,31,34,40,44,54,69,
80,170,69,53,116,128,68,15,3,2,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,1,3,85,245,236,212,202,223,206,
183,147,113,96,82,73,92,151,138,165,103,40,18,27,36,35,41,29,14,17,
12,15,24,31,38,43,48,58,71,79,85,88,34,19,20,65,66,10,3,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,1,65,237,235,219,195,220,217,207,174,135,115,89,80,102,167,150,190,
142,68,56,62,43,28,42,44,21,14,14,18,27,36,47,57,67,75,86,90,
80,58,28,22,6,22,31,10,1,2,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,3,8,144,240,235,187,217,216,
218,199,155,127,88,80,115,186,189,212,184,128,128,158,135,86,54,51,43,21,
21,23,31,40,58,71,84,87,94,87,70,49,26,12,13,31,41,11,2,1,
2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,3,8,77,196,216,187,212,216,219,212,171,133,90,85,146,211,217,249,
220,171,195,240,239,199,92,42,55,33,26,29,35,47,63,78,88,93,94,78,
67,42,33,17,20,48,68,15,2,1,3,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,2,2,3,58,173,189,185,207,218,
224,217,181,134,95,106,196,242,237,241,235,202,201,225,235,217,85,25,51,45,
31,34,41,53,69,78,86,93,95,76,64,39,31,43,64,64,28,6,3,1,
3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,2,2,25,163,231,196,201,218,228,220,186,138,106,146,229,247,249,248,
246,221,152,111,120,95,23,14,31,51,32,35,45,53,67,81,94,102,96,77,
62,57,30,30,44,33,7,2,3,0,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,5,6,61,145,151,196,220,
228,219,188,143,131,168,220,234,244,246,221,154,76,43,36,22,19,16,21,44,
38,38,45,56,65,80,101,105,92,79,62,112,113,42,28,14,5,2,1,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,2,5,5,15,59,187,218,226,218,188,161,163,182,205,211,219,199,
138,102,83,35,23,27,23,29,28,37,46,46,47,58,72,88,103,101,91,81,
70,171,172,48,9,4,5,3,2,0,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,2,4,3,5,3,46,189,219,
224,217,192,188,191,190,194,183,164,120,67,56,62,31,15,16,28,42,45,41,
52,53,48,60,84,103,108,96,90,75,82,198,141,20,5,3,3,1,1,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,2,1,5,2,34,177,220,223,216,200,207,203,194,186,179,182,172,
132,86,103,115,91,63,38,52,59,59,57,52,46,60,85,103,100,88,85,79,
94,198,98,6,4,2,2,1,0,1,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,1,2,2,4,1,5,18,160,221,
220,212,207,215,204,200,196,209,221,218,220,214,216,217,217,207,170,114,112,110,
74,63,60,70,88,103,94,87,86,89,83,141,46,6,3,3,1,2,1,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,2,10,129,227,216,209,207,204,198,210,232,236,230,210,
207,193,157,142,156,174,204,217,211,186,108,64,63,79,96,108,96,91,96,94,
71,94,17,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,2,4,85,225,
211,208,204,199,222,238,235,205,163,120,102,81,56,48,54,64,79,111,152,205,
141,76,69,86,103,110,101,99,97,98,71,60,4,1,3,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,2,31,185,207,200,200,206,221,219,205,204,192,172,
163,155,142,129,109,100,89,72,52,93,115,84,82,105,110,108,115,116,113,106,
78,38,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,7,116,
197,197,200,205,210,202,199,207,208,210,218,220,216,199,163,128,85,62,58,64,
95,86,98,116,115,119,135,139,143,119,73,26,2,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,1,2,2,44,142,188,201,205,210,202,194,193,200,199,
199,208,213,199,149,113,89,78,87,83,98,106,123,122,121,138,156,168,177,102,
79,19,2,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,3,6,
59,164,204,217,212,204,191,181,168,136,129,133,124,105,99,89,90,92,90,88,
101,124,138,130,141,168,192,206,191,80,101,19,3,3,1,2,1,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,2,2,5,11,111,206,216,216,209,190,163,126,85,
57,44,36,24,35,49,65,79,82,86,98,123,133,138,168,192,216,219,146,150,
151,50,4,2,2,3,2,2,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,
5,54,174,211,217,215,192,145,110,89,67,52,42,25,26,39,50,62,71,77,
94,120,137,172,206,227,235,214,182,181,157,104,18,3,2,2,3,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,0,1,3,4,45,135,160,223,220,199,164,125,102,
81,76,62,48,48,48,57,68,72,81,113,148,193,229,236,240,224,217,210,186,
167,153,60,5,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,
2,33,157,119,178,227,209,191,146,116,100,88,83,83,77,72,78,81,82,112,
160,202,237,250,235,225,215,216,202,191,168,162,99,11,2,2,1,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,1,1,2,3,20,155,152,107,184,216,206,180,154,
152,142,133,130,119,109,111,117,137,188,223,244,248,242,232,230,218,218,210,195,
183,175,134,28,3,3,2,3,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,
3,12,124,204,137,126,168,193,201,199,205,204,201,196,196,188,185,198,217,244,
251,252,244,233,228,229,211,215,209,193,186,180,146,48,4,2,2,4,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,2,2,4,5,4,87,213,196,160,141,163,203,214,
220,226,227,228,233,233,235,243,248,252,251,246,235,225,226,224,218,217,210,190,
181,173,164,103,4,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,3,
1,20,124,211,219,217,200,191,204,215,222,225,227,229,236,243,246,250,253,253,
248,236,229,225,229,230,221,219,205,194,185,189,187,163,20,2,3,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,1,2,2,85,233,235,226,227,224,223,212,213,
213,216,226,233,242,249,252,253,252,247,241,232,231,231,234,230,218,210,200,190,
189,201,191,178,66,4,7,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,4,
5,106,252,242,233,230,229,225,224,212,214,227,240,248,253,255,254,252,250,245,
240,236,235,235,232,224,215,208,200,194,195,201,185,172,104,11,4,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

/* #8 Agent Smith Face & Shoulders (by Vince) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,6,24,41,60,59,44,11,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,25,125,198,
225,238,249,225,215,194,86,43,2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,28,63,167,214,227,241,249,246,245,238,228,242,202,169,112,12,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,47,116,194,224,250,248,247,250,
252,250,247,247,249,232,233,228,232,207,11,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
11,117,233,252,251,253,244,239,241,249,245,233,216,217,233,242,242,237,224,243,
164,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,18,133,235,244,246,246,205,193,191,196,203,
184,167,155,129,143,183,199,213,164,143,200,130,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,
234,243,235,226,164,138,137,132,128,113,96,83,83,79,78,90,101,124,124,103,
121,195,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,19,246,252,230,221,140,123,109,95,90,87,78,
74,61,59,58,59,65,69,78,91,91,94,104,206,172,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,
250,217,168,131,115,100,89,79,75,69,66,58,50,48,50,55,67,71,75,79,
86,98,128,233,164,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,149,251,243,209,144,127,114,104,87,76,71,63,
57,56,50,51,53,52,64,67,68,78,85,94,110,175,245,78,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,252,
243,193,145,131,113,104,91,82,73,67,57,57,59,57,56,60,66,59,66,78,
84,97,103,153,224,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,18,246,252,248,202,151,143,112,106,97,86,76,69,
62,59,67,73,69,71,72,67,69,76,87,102,111,130,218,104,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,251,252,
253,217,166,164,120,112,110,94,80,73,71,70,74,74,79,77,77,71,66,71,
89,101,108,132,219,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,7,132,252,252,253,229,189,168,147,120,117,107,85,74,
69,65,67,74,78,74,71,63,65,71,90,106,111,142,214,169,3,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,202,253,251,
250,248,206,168,165,143,127,114,88,64,53,50,54,65,67,67,64,57,56,67,
86,102,118,156,203,206,6,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,108,234,252,252,251,251,212,162,166,154,139,125,110,79,
66,57,53,58,61,62,63,60,63,73,89,101,130,164,213,244,19,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,178,250,253,251,
251,251,202,170,153,140,138,134,110,100,86,75,67,68,63,59,63,66,75,79,
93,101,132,149,221,248,158,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,38,202,250,252,252,252,238,189,168,137,103,106,111,109,110,
105,100,98,88,76,77,83,91,103,96,105,112,116,116,227,253,181,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,208,249,251,252,
253,225,179,167,131,107,123,148,146,157,139,132,124,120,112,115,129,133,141,169,
196,207,194,182,208,244,171,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,77,207,248,251,251,253,223,170,163,182,216,230,244,253,253,
253,253,245,221,178,177,191,232,253,253,253,253,253,253,251,230,171,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,209,246,252,251,
252,234,201,206,241,253,224,227,202,251,251,249,252,235,171,125,185,207,236,250,
251,251,251,250,241,243,176,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,80,189,196,245,249,252,227,164,205,246,251,235,233,191,251,
251,251,251,253,156,71,134,232,248,251,251,251,247,244,248,242,176,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,218,202,173,211,
251,231,178,195,228,249,251,253,253,251,251,250,251,241,97,66,58,234,251,250,
252,251,250,249,251,228,173,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,77,236,228,239,207,246,220,174,180,184,242,252,247,252,251,
252,252,253,183,94,54,63,153,253,252,251,251,251,253,252,195,178,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,199,195,186,236,
244,212,178,168,148,185,230,243,248,249,249,248,239,125,89,54,59,99,230,225,
225,219,203,183,218,178,178,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,100,158,176,195,148,222,217,177,171,154,131,155,186,210,227,
225,211,199,120,83,52,48,85,199,196,203,173,152,146,209,166,88,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,151,158,182,171,
221,240,178,174,170,159,153,176,202,200,173,176,178,124,82,56,48,74,179,197,
181,173,166,172,220,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,50,160,142,176,229,247,190,190,191,185,178,170,152,144,
139,165,148,146,185,155,150,173,160,190,190,183,173,196,199,78,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,197,175,
186,240,203,201,199,201,197,174,145,144,146,164,196,236,252,237,230,250,193,160,
177,190,184,203,202,120,3,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,18,165,191,192,229,212,204,200,203,196,179,155,162,
149,128,166,247,243,243,242,242,112,112,137,172,188,215,178,196,8,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,202,
176,228,210,204,203,193,184,169,165,165,115,90,115,203,224,236,213,156,111,85,
115,151,178,209,224,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,121,233,242,250,216,214,207,200,185,169,184,149,
109,102,115,130,166,195,180,123,109,103,109,138,180,207,221,44,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,
230,243,216,209,208,201,195,191,179,134,118,133,137,134,168,169,161,176,130,117,
115,131,178,212,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,204,224,235,222,212,210,213,202,195,174,154,
173,192,194,227,241,232,216,211,213,203,177,137,194,218,4,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,
216,230,226,225,222,215,207,197,176,192,231,235,226,197,135,114,102,112,123,126,
150,176,210,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,137,195,228,219,242,238,228,222,212,193,208,
211,165,163,170,187,188,195,194,199,173,171,197,196,42,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,
192,221,210,242,244,239,233,234,235,228,211,220,234,239,246,244,246,246,245,236,
221,216,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,91,212,213,212,231,245,239,240,231,238,234,
235,238,240,244,244,243,244,244,240,238,236,215,81,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,
186,186,220,214,246,244,241,237,232,231,231,224,221,212,186,172,166,140,156,186,
207,212,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,126,184,215,210,231,246,244,239,239,235,
223,198,181,161,176,189,169,138,134,151,219,201,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
63,192,206,209,221,238,244,243,237,235,238,228,199,208,219,230,233,217,204,200,
221,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,89,224,207,204,208,224,237,244,241,232,
235,234,233,233,230,223,225,227,226,224,214,172,141,5,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,
224,238,164,198,194,209,225,239,241,240,235,230,229,230,231,228,227,225,231,214,
216,107,179,82,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,2,141,220,245,244,128,105,187,196,209,231,240,240,
237,238,238,235,233,237,235,237,217,202,203,99,191,116,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,207,228,237,
245,239,115,124,99,164,196,212,226,238,239,237,236,233,237,236,233,231,209,193,
177,105,175,201,130,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,120,232,233,230,247,247,236,142,114,117,106,123,178,222,229,
235,234,238,239,240,234,232,225,207,203,119,123,149,211,193,169,74,14,5,3,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,7,183,235,231,223,240,247,
247,236,176,102,112,114,122,108,129,214,227,240,240,240,238,242,233,222,213,119,
101,113,134,211,196,183,182,171,186,219,137,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,75,211,227,210,208,232,242,245,245,241,225,101,104,106,109,108,110,117,
172,222,234,239,241,238,226,213,145,97,103,102,147,212,201,198,181,180,182,169,
172,134,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,54,188,218,212,212,212,228,237,244,246,
246,240,243,150,91,101,102,103,103,107,121,141,201,241,238,232,215,124,106,96,
92,99,138,210,198,200,187,176,179,193,186,177,166,128,25,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,50,113,205,
220,206,212,220,216,207,234,236,241,243,243,240,235,236,89,103,109,107,103,96,
100,112,130,174,211,206,209,111,82,84,90,96,133,217,203,196,193,185,174,174,
190,190,184,179,174,164,155,165,84,5,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,30,129,191,210,212,209,207,206,212,220,208,224,229,237,240,242,
240,239,232,237,163,97,101,103,105,98,95,92,81,191,249,248,245,236,81,79,
84,96,126,223,204,202,198,188,180,168,166,191,192,185,186,184,184,176,167,133,
25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,7,25,84,173,209,210,210,215,205,205,
208,205,220,211,215,226,232,236,236,239,237,239,231,231,208,91,91,98,98,103,
101,96,73,253,239,237,235,246,150,76,82,95,119,233,204,204,206,191,186,175,
200,207,191,198,196,192,189,185,184,187,176,73,16,14,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,111,
174,212,221,212,212,211,210,210,205,205,204,212,208,210,217,220,230,230,235,236,
237,236,230,231,240,102,80,84,81,82,84,71,140,253,237,224,228,246,206,71,
80,91,102,230,206,206,213,217,198,189,235,206,195,194,200,194,195,198,195,192,
196,191,167,155,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,3,146,219,225,218,223,216,209,211,207,208,208,202,203,
208,206,205,213,210,215,227,223,228,235,234,231,231,229,226,188,45,70,69,70,
68,53,214,249,247,211,229,245,225,69,80,87,85,198,210,197,207,217,219,204,
237,223,200,197,195,199,194,206,202,203,203,205,204,198,179,145,3,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,224,230,220,
208,217,214,210,211,211,208,208,206,204,206,204,210,212,215,222,228,224,221,226,
232,229,233,228,222,238,56,56,57,57,56,74,221,245,250,226,238,198,133,123,
69,82,76,146,219,202,205,213,212,217,214,199,206,206,200,198,209,213,211,210,
202,208,208,214,212,188,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,118,206,216,219,205,208,215,216,217,211,205,206,206,205,
205,206,203,208,216,234,247,241,227,225,230,229,228,231,223,224,150,44,56,54,
53,100,140,193,251,227,244,107,94,162,56,69,63,88,228,199,211,206,211,219,
218,217,185,191,201,205,216,223,222,214,218,213,214,222,221,221,213,80,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,180,213,205,218,
206,208,216,217,213,209,208,200,207,208,209,202,199,208,215,219,236,250,248,236,
229,230,228,229,224,213,209,87,45,52,42,105,118,136,241,211,244,103,63,108,
81,59,48,52,218,200,203,207,210,217,208,217,212,194,197,211,223,226,228,219,
218,219,221,229,224,227,220,182,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,52,228,221,209,212,217,206,214,220,217,209,207,205,217,222,
221,209,203,211,215,213,209,228,246,236,235,225,228,226,227,217,201,113,80,43,
45,40,70,110,234,206,243,107,49,48,90,58,33,35,181,209,199,204,211,216,
212,206,214,203,205,216,228,228,229,222,223,228,231,234,232,234,220,229,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,118,240,235,217,207,
213,210,213,219,219,212,208,211,217,217,220,211,209,209,211,210,211,220,217,217,
231,227,225,229,226,219,211,101,98,58,60,39,30,140,223,205,244,118,38,48,
76,66,26,31,127,215,197,212,204,213,209,202,206,209,208,222,230,229,227,223,
222,231,238,240,238,240,231,239,14,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,14,192,244,238,222,215,214,212,212,221,222,214,212,211,217,216,
220,215,209,208,205,209,212,217,216,212,224,227,227,227,228,221,213,195,7,77,
64,46,15,194,210,213,236,231,52,35,65,51,26,26,83,218,198,201,210,207,
207,209,198,203,209,225,230,228,229,226,227,231,243,245,244,244,228,245,92,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,228,242,240,231,218,
211,218,215,226,228,218,215,214,222,219,224,224,216,208,206,215,217,212,212,213,
219,224,225,230,229,225,213,224,53,13,27,50,17,199,199,217,234,237,170,29,
48,31,20,22,53,205,191,203,208,199,201,197,197,194,209,225,231,229,230,227,
227,237,246,247,246,245,236,245,74,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,135,243,237,241,236,222,217,216,214,219,225,217,218,216,217,217,
220,224,218,208,204,224,216,210,210,211,212,219,222,226,227,228,223,206,171,7,
20,39,28,185,199,222,234,243,241,89,30,29,16,19,35,183,194,197,208,204,
203,196,198,193,210,225,231,228,230,229,228,239,246,248,247,243,239,245,24,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,242,231,238,238,226,
218,215,216,222,222,222,214,218,219,218,220,225,228,218,203,201,239,208,207,207,
213,215,224,223,226,227,226,208,206,36,20,25,42,163,210,226,233,239,236,233,
29,21,15,19,30,160,192,200,207,205,197,198,199,199,206,228,229,229,228,227,
232,241,246,247,246,240,243,245,78,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,233,245,229,234,239,232,218,228,221,221,226,222,219,217,218,217,
219,226,229,225,211,203,216,225,204,209,211,213,219,220,224,227,226,214,200,95,
26,19,34,137,218,226,231,239,243,218,150,19,25,26,27,139,191,200,210,206,
200,197,193,204,213,230,231,229,227,229,231,242,246,247,248,239,245,244,150,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,3,236,245,231,236,239,242,
230,216,229,226,227,224,219,219,216,215,215,224,225,229,219,210,199,227,206,207,
210,209,214,215,222,223,228,219,214,150,23,23,28,115,219,224,229,237,240,231,
207,40,37,32,28,122,190,194,208,200,196,197,189,194,214,230,229,231,232,229,
233,242,245,248,248,238,248,246,244,58,0,0,0,0,0,0,0,0,0,0,

/* #9: Tank (by Vince) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,210,217,212,225,213,209,208,212,210,195,196,212,214,203,
208,211,196,216,223,194,193,206,216,207,182,189,201,206,217,212,213,217,200,185,
185,215,210,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,224,221,212,224,
218,200,208,222,215,182,209,210,212,195,214,209,204,199,191,218,206,218,212,207,
209,218,217,205,213,222,210,211,215,214,199,215,219,211,25,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,150,222,225,175,190,215,208,205,193,169,205,207,201,198,214,180,
207,216,197,183,151,203,204,225,218,214,220,217,218,212,210,216,206,197,209,216,
219,189,206,214,221,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,222,208,210,166,215,
193,173,209,218,213,193,199,176,215,207,208,200,207,221,211,223,193,180,212,192,
202,186,217,220,217,199,208,195,177,208,218,209,214,214,213,209,221,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,224,217,221,209,182,195,205,200,208,199,211,211,212,223,175,160,208,
218,193,178,220,210,222,203,194,220,207,209,212,155,163,211,182,195,216,202,204,
186,194,181,210,220,217,200,224,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,211,217,221,225,209,216,214,217,
210,210,181,199,219,223,220,215,186,182,181,209,185,171,225,224,150,223,223,225,
220,205,223,207,218,224,215,212,211,216,202,214,203,205,219,222,219,212,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,219,200,217,56,210,214,180,220,201,184,184,203,224,218,206,180,180,222,222,
216,220,223,223,216,213,191,200,210,222,223,203,216,224,225,224,225,198,211,206,
210,208,214,204,185,206,211,218,205,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,224,217,188,201,210,193,212,221,217,217,
212,206,183,217,200,184,211,222,210,220,203,224,224,150,224,188,189,218,210,204,
212,213,211,225,218,217,209,213,210,207,196,211,216,208,186,212,212,215,202,215,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,
218,210,220,217,214,213,210,222,216,224,222,210,217,205,222,220,179,212,222,202,
199,212,210,218,203,205,222,223,180,208,204,217,218,212,210,210,178,211,222,216,
210,194,221,183,194,212,191,218,194,216,224,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,220,216,180,214,221,221,220,215,219,211,217,
218,221,210,215,221,223,224,205,210,222,216,215,215,210,221,222,225,219,212,223,
219,225,213,193,191,212,197,218,217,213,218,184,210,213,206,194,183,222,220,217,
208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,
215,225,218,196,185,217,208,217,209,214,203,208,220,217,223,214,203,224,219,220,
210,221,224,223,221,224,220,224,211,190,203,222,222,222,219,212,220,210,188,213,
182,204,219,189,224,216,199,206,218,220,196,219,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,150,225,221,221,219,215,25,210,210,223,221,225,
212,220,209,180,220,220,224,219,221,225,224,218,219,206,210,220,221,224,223,220,
212,224,222,223,216,213,221,202,186,223,211,186,211,222,205,223,210,219,198,220,
185,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,220,
224,205,201,210,191,220,211,210,119,119,224,222,220,220,224,220,210,222,217,224,
150,208,200,215,217,218,203,221,222,223,222,220,200,192,176,163,202,219,203,212,
222,218,220,215,221,209,216,206,205,212,212,216,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,180,223,221,223,217,216,225,205,219,225,217,223,210,
150,224,214,200,216,207,208,220,222,223,221,222,219,216,209,204,200,207,218,215,
198,153,129,104,97,72,93,167,170,186,218,225,221,221,214,209,207,207,217,212,
217,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,217,220,
223,197,188,221,216,223,224,217,215,212,217,224,180,218,211,213,212,221,215,195,
213,220,215,199,182,133,127,111,138,121,107,97,78,75,55,43,54,82,106,134,
191,222,219,223,201,206,205,213,220,197,206,208,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,222,221,225,221,216,224,211,220,224,220,218,218,214,
213,218,215,203,211,197,204,205,188,194,168,204,193,141,100,68,66,50,43,48,
58,58,62,48,39,41,40,65,81,99,153,165,211,221,186,200,207,176,211,209,
202,201,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,210,225,
223,210,223,217,218,222,222,199,203,170,173,179,157,158,161,181,173,203,167,185,
155,171,148,93,53,30,31,21,16,19,25,28,41,44,37,38,42,54,57,101,
145,164,148,189,214,213,192,169,203,204,213,206,88,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,222,219,223,221,223,223,209,212,225,207,207,189,148,
113,108,98,89,99,122,137,150,156,152,111,77,64,17,13,16,15,13,14,14,
17,25,27,35,36,36,39,49,56,97,156,174,202,169,166,180,214,195,214,217,
217,213,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,215,
211,210,224,188,192,197,197,207,171,117,84,83,75,66,70,72,77,93,123,90,
50,22,10,7,5,7,9,8,11,16,16,22,28,33,35,34,39,52,57,81,
188,155,208,185,200,212,222,209,217,214,216,214,207,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,221,211,222,223,217,194,197,224,208,207,198,149,84,
73,70,71,62,51,50,48,47,52,47,31,14,4,3,6,6,6,8,11,14,
16,20,29,33,34,41,44,57,63,87,145,204,214,218,216,221,210,215,214,219,
215,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,220,223,
224,220,220,214,223,225,213,192,132,80,72,71,68,53,45,36,33,28,27,23,
21,11,7,6,5,6,7,6,9,14,15,19,27,31,32,40,42,60,69,98,
167,191,217,215,216,214,211,206,216,212,216,220,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,56,220,221,213,210,225,221,219,219,217,206,124,76,
72,69,67,53,50,38,29,23,22,19,20,14,9,8,8,8,10,9,10,13,
18,21,25,31,37,42,57,72,73,91,173,196,177,164,211,202,208,206,212,215,
214,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,221,215,
223,225,225,222,199,221,199,188,129,88,71,70,64,53,47,38,30,26,20,22,
20,17,11,11,8,7,10,8,11,12,13,18,24,33,40,46,65,72,68,88,
135,199,195,207,211,215,215,211,213,212,214,214,25,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,219,224,218,216,218,211,218,221,204,195,143,100,
76,70,62,57,56,45,33,27,24,30,21,17,12,12,9,8,8,8,8,8,
7,12,24,31,43,57,64,67,73,73,97,159,196,212,217,216,217,214,211,215,
208,198,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,225,
223,222,222,225,223,210,206,205,155,100,79,75,73,61,52,48,38,33,29,23,
23,18,12,10,7,7,6,3,4,4,5,12,23,30,48,53,51,58,67,69,
86,121,179,203,215,217,218,211,212,210,207,193,199,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,224,223,210,222,225,223,225,212,220,221,183,114,
91,84,72,64,50,44,38,31,25,19,18,15,11,11,8,8,6,5,2,3,
5,12,19,21,27,34,37,48,47,71,83,99,144,187,211,214,213,215,209,198,
209,193,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,210,
224,180,225,224,223,225,224,223,189,132,98,91,80,69,51,36,30,23,22,18,
17,18,13,10,9,7,8,4,3,4,2,5,11,13,29,51,70,62,60,61,
73,88,110,141,188,207,210,215,215,195,192,180,225,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,119,221,180,210,219,223,88,178,180,224,200,133,
109,91,75,68,54,35,28,19,18,18,18,14,14,15,14,8,6,6,5,3,
3,2,16,48,96,135,113,95,103,115,102,87,90,96,138,202,210,214,214,191,
161,152,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,
180,225,219,221,222,225,180,222,181,120,101,81,68,56,52,33,25,15,14,15,
16,17,14,16,11,9,7,9,7,6,22,76,103,136,167,149,107,107,108,106,
120,104,87,78,104,157,207,199,202,186,149,115,213,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,180,223,225,180,223,213,119,225,220,183,118,
93,73,60,43,37,29,21,21,15,14,22,19,16,21,20,12,10,10,14,28,
81,125,165,182,168,120,97,87,94,105,111,114,87,77,85,125,181,208,208,202,
179,113,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
210,221,225,150,180,223,221,225,198,130,116,132,123,72,49,34,33,23,21,21,
16,23,18,19,19,17,16,30,65,95,172,191,194,152,95,89,98,104,102,114,
119,112,91,77,76,95,170,197,200,192,150,95,116,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,224,221,222,150,225,215,215,180,161,
173,184,202,186,137,111,87,78,54,31,25,24,23,30,31,26,48,72,116,178,
196,179,167,151,143,152,155,171,187,153,118,101,76,69,64,75,148,204,198,116,
91,68,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,222,221,223,225,225,220,163,181,179,163,187,204,204,199,181,128,121,113,
68,41,39,51,55,61,139,159,164,183,168,183,175,200,192,207,159,120,162,144,
107,72,58,56,63,69,115,194,169,110,65,74,121,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,150,222,222,223,210,224,165,179,
147,126,119,134,158,186,207,211,202,169,178,131,74,75,92,96,142,188,170,161,
179,175,202,207,207,207,205,47,89,81,48,45,42,50,51,60,97,176,150,103,
82,73,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,220,222,215,210,221,160,181,161,124,125,153,153,169,189,200,181,178,
203,205,124,56,38,51,101,153,164,174,204,203,207,207,208,121,84,54,80,53,
34,28,30,38,47,62,101,180,129,122,38,106,122,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,25,220,215,213,212,147,156,
171,185,183,176,203,208,206,206,203,193,176,171,118,38,14,14,32,99,136,118,
70,166,207,208,143,150,59,77,74,29,24,24,25,36,48,57,118,176,120,99,
39,80,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,221,210,175,204,134,128,148,201,222,127,201,208,208,205,188,209,
188,169,106,30,8,7,19,43,58,41,18,48,71,109,72,102,101,64,32,18,
17,16,20,34,50,63,141,174,122,77,63,78,113,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,205,178,203,128,108,
110,136,154,106,114,203,194,168,140,99,108,103,69,27,10,6,15,26,20,20,
17,28,32,36,41,31,20,16,15,16,16,17,25,43,57,75,160,170,118,80,
46,81,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,202,154,189,117,98,82,81,123,99,81,63,67,62,63,60,
49,57,54,28,12,9,20,26,20,16,13,12,19,24,21,17,14,14,15,14,
18,20,32,50,63,99,168,165,94,48,86,202,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,155,178,119,89,
64,58,84,108,101,97,87,77,60,40,31,33,52,30,9,9,20,22,21,20,
17,12,8,11,14,18,15,16,18,22,23,29,41,61,79,118,172,170,101,116,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,217,172,154,124,92,59,41,49,60,69,68,53,46,40,26,
28,36,53,30,12,8,18,23,23,25,24,15,12,9,9,9,13,14,22,24,
30,36,52,70,97,155,168,174,206,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,208,100,121,93,
60,41,34,41,37,35,35,35,25,18,28,44,52,26,12,9,17,24,29,30,
32,22,13,9,10,9,7,14,25,25,30,44,57,86,126,169,166,185,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,25,208,125,137,116,80,53,39,31,30,30,27,22,18,18,
30,54,44,21,7,3,12,22,29,35,42,34,15,10,6,8,8,12,18,22,
39,60,78,104,150,166,163,189,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,131,111,142,
100,72,54,44,36,29,24,17,20,20,39,65,42,18,8,3,9,19,30,32,
30,49,18,10,8,7,7,11,18,25,46,68,83,115,163,151,156,189,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,88,197,93,133,133,96,73,53,44,30,21,18,17,22,
51,55,50,18,13,10,13,27,40,24,28,46,18,8,10,8,9,13,19,29,
52,61,82,130,149,146,155,188,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,181,150,
160,123,88,63,42,31,21,20,17,18,42,50,74,25,20,17,25,66,85,51,
55,73,16,6,9,9,11,15,20,31,51,64,90,137,141,142,152,190,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,219,218,193,144,107,83,51,38,26,22,19,17,
43,74,124,86,39,35,60,141,213,186,123,102,8,7,9,10,13,15,23,37,
55,79,105,136,137,136,144,192,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,
203,178,129,89,61,42,32,25,18,16,24,129,179,208,123,109,120,208,155,128,
141,39,9,8,10,12,13,20,27,45,60,82,117,144,133,134,147,199,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,212,190,157,102,71,49,38,29,22,20,
23,107,180,177,192,173,165,109,58,42,26,17,10,9,12,15,20,23,34,50,
75,103,139,141,132,133,164,200,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
221,194,185,127,82,62,46,40,31,29,31,54,90,104,134,158,114,56,24,23,
16,20,14,13,18,20,26,34,49,66,90,127,147,149,140,138,181,197,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,207,176,163,106,74,55,45,38,33,
29,32,47,56,60,60,55,34,17,17,17,17,15,22,30,28,41,56,69,88,
109,143,147,149,143,153,190,194,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,217,181,175,137,95,76,59,46,43,33,37,46,44,29,24,28,24,12,13,
12,16,20,30,39,53,66,72,81,106,121,154,152,158,143,174,188,188,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,216,190,169,167,125,98,79,64,55,
45,45,46,38,17,12,13,14,10,14,15,17,23,36,57,95,115,112,99,117,
140,157,160,158,163,193,189,185,208,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,
219,210,215,182,175,155,123,112,80,74,61,51,43,39,39,28,14,20,59,104,
131,141,148,154,159,187,181,126,110,126,149,160,169,164,185,208,181,193,223,222,
212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,225,219,224,210,150,119,197,179,177,139,134,111,119,
95,73,105,149,153,147,133,133,161,170,195,193,194,191,176,162,100,108,121,133,
152,169,162,181,210,195,178,197,220,218,210,207,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,218,221,210,
150,180,150,211,193,184,165,135,131,159,181,184,189,189,194,193,188,192,171,106,
40,32,60,63,75,115,76,97,110,138,167,174,174,206,212,191,181,199,219,219,
219,219,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,225,222,222,220,220,222,224,224,210,210,210,208,195,189,149,121,134,
160,197,174,120,92,72,66,66,47,36,40,62,67,95,138,106,103,116,130,152,
175,170,204,217,201,183,179,195,218,217,217,218,214,208,150,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,218,217,219,219,221,219,223,222,223,
210,223,225,216,201,209,199,178,134,116,98,123,116,94,78,59,41,34,44,55,
62,81,132,155,137,137,131,126,125,142,163,192,217,215,196,179,177,202,217,218,
217,215,219,207,207,211,74,33,6,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,220,
216,218,216,215,217,219,219,216,222,210,222,223,210,220,191,205,208,205,172,115,
106,106,143,154,134,115,125,159,174,179,172,175,177,157,141,156,123,107,103,131,
179,215,216,208,187,176,176,199,216,215,216,211,209,208,208,208,194,157,80,6,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,25,217,219,215,214,217,215,217,217,212,210,216,225,221,
219,221,223,221,184,186,212,212,201,167,140,127,133,166,187,190,188,188,185,181,
180,178,151,125,112,89,73,77,91,149,209,216,212,192,181,165,174,199,215,214,
212,208,208,208,208,208,208,208,197,136,44,6,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,57,211,208,208,209,
211,214,216,214,213,206,214,210,223,218,220,221,222,219,181,172,189,216,212,190,
167,165,172,166,163,170,177,175,165,147,131,122,104,81,74,67,57,71,106,189,
212,212,201,186,173,171,178,200,216,211,209,208,208,208,208,208,208,208,208,206,
162,74,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,35,125,208,208,208,208,208,208,208,212,211,208,204,221,225,216,217,
218,220,222,217,178,161,170,194,213,210,182,145,134,127,123,132,130,103,62,56,
61,53,49,65,63,65,62,91,164,212,210,206,190,174,172,165,174,197,215,209,
208,208,208,208,208,208,208,208,208,208,208,177,81,7,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,44,176,208,208,208,208,208,208,
208,208,209,199,197,208,224,222,217,214,217,219,220,218,180,152,156,172,194,210,
198,129,100,93,94,73,64,58,55,60,67,55,57,59,72,76,87,153,206,211,
202,194,181,170,163,167,172,191,212,207,208,208,208,208,208,208,208,208,208,208,
208,208,171,52,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,47,178,207,208,208,208,208,208,208,208,208,207,198,191,212,225,213,215,212,
214,217,220,219,188,149,143,153,170,189,209,183,115,102,91,82,72,62,69,55,
65,65,82,96,110,118,165,211,213,211,197,182,174,166,162,164,167,192,218,207,
208,208,208,208,208,208,208,208,208,208,208,208,208,148,17,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,17,143,208,208,208,208,208,208,208,208,
208,208,208,205,190,215,221,210,216,207,214,219,220,218,197,151,144,136,155,170,
191,203,180,133,107,97,96,95,82,88,89,94,129,167,178,190,212,216,215,206,
187,175,170,161,157,163,157,196,219,207,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,95,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
87,208,208,208,208,208,208,208,208,208,208,208,208,207,196,220,211,210,212,207,
214,215,219,215,211,136,135,140,138,155,175,188,205,196,170,161,146,125,121,135,
158,180,194,196,204,211,213,215,211,195,182,174,166,158,154,155,151,209,210,210,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,166,29,0,0,0,0,
0,0,0,0,0,0,0,0,0,17,141,208,208,208,208,208,208,208,208,208,
208,208,208,207,192,221,210,205,214,204,213,216,215,214,180,133,129,127,133,140,
148,172,191,206,204,200,191,189,182,184,190,191,194,200,205,208,212,210,202,190,
177,169,163,161,153,149,165,217,205,206,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,68,0,0,0,0,0,0,0,0,0,0,0,0,0,35,
208,208,208,208,208,208,208,208,208,208,208,208,207,203,193,217,208,201,211,202,
209,214,215,214,220,158,124,123,129,136,143,152,175,193,203,202,198,193,192,186,
188,191,197,199,205,209,208,205,193,183,178,164,163,163,157,162,191,210,206,203,
208,207,208,208,208,208,208,208,208,208,208,208,208,208,208,100,0,0,0,0,
0,0,0,0,0,0,0,0,0,35,208,208,208,208,208,208,208,208,208,208,
208,208,206,205,200,212,206,194,210,204,207,208,213,211,211,198,122,118,121,129,
136,147,162,177,189,199,198,199,196,192,188,187,199,204,204,204,205,193,188,178,
175,167,164,158,155,150,202,211,205,204,210,205,208,208,208,208,208,208,208,208,
208,208,208,208,208,120,0,0,0,0,0,0,0,0,0,0,0,0,0,33,
189,208,208,208,208,208,208,208,208,208,208,207,193,208,193,209,199,198,207,202,
201,208,207,209,204,217,143,118,120,128,133,143,154,168,183,195,196,198,200,197,
184,188,206,202,202,198,196,188,180,175,173,167,164,152,145,146,207,206,206,208,
211,211,206,208,208,208,208,208,208,208,208,208,208,208,208,110,0,0,0,255,

/* #10 Dodge this! (by Chris_C) */
0,0,0,0,0,0,0,0,0,6,15,44,55,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,181,181,181,175,169,99,4,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,181,180,
173,170,164,163,139,106,57,5,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,181,181,181,181,181,181,179,172,165,162,157,
136,130,124,96,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,181,181,181,181,179,179,179,181,171,158,158,150,135,127,125,121,
116,71,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,73,71,69,60,34,18,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,
181,181,181,178,179,181,181,174,156,149,144,139,134,131,127,126,120,98,69,
17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,60,93,96,105,136,139,103,58,123,24,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,181,181,181,181,180,179,178,
179,181,181,181,154,131,126,127,126,129,129,132,128,118,108,85,54,21,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,82,74,65,124,164,171,
176,179,180,166,145,181,22,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,173,181,181,181,181,180,178,178,179,181,181,181,181,
159,112,99,97,101,107,115,119,124,126,122,111,97,77,46,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,30,133,80,93,123,170,181,181,180,181,179,170,139,
155,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,178,181,181,181,181,180,179,178,178,177,180,181,181,181,166,139,120,103,
87,76,82,94,107,117,121,120,116,112,121,61,28,140,169,122,0,0,13,
4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,149,151,166,113,161,178,181,181,181,181,181,175,142,130,181,79,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,181,181,
181,180,178,177,176,176,178,181,181,181,181,168,169,167,161,146,123,99,80,
76,93,113,123,125,110,124,143,160,181,180,153,58,105,125,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,181,169,129,179,
126,181,181,181,181,181,181,181,161,161,181,180,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,181,181,181,180,181,179,177,176,174,
175,176,179,181,181,179,168,165,165,164,164,164,164,160,142,114,91,91,112,
124,126,115,108,170,181,129,149,117,177,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,170,175,168,181,160,181,181,181,181,181,
181,181,173,176,181,180,181,50,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,181,181,181,180,180,179,178,176,174,173,174,177,178,181,
179,167,167,166,165,164,162,161,159,157,158,156,147,133,128,126,135,138,138,
181,131,116,127,137,132,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,93,181,180,181,175,181,181,181,181,181,181,181,175,174,181,181,
164,166,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
181,181,181,180,179,178,176,173,173,172,172,174,175,179,175,168,168,167,167,
167,164,162,158,157,154,152,149,149,145,142,137,135,143,140,142,130,120,113,
134,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,169,
181,169,181,181,181,177,174,168,153,155,156,168,181,181,174,157,167,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,181,179,179,
178,175,173,172,170,170,171,173,177,173,169,169,172,170,169,170,165,164,160,
159,155,152,149,147,143,140,135,129,127,137,144,131,136,133,120,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,9,150,181,167,181,181,161,141,
138,140,140,138,135,130,146,178,167,161,166,174,10,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,181,181,181,180,178,177,174,172,171,168,
168,169,171,174,171,169,170,171,171,170,170,170,167,166,164,162,157,152,149,
146,143,139,134,129,123,175,150,128,136,138,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,25,159,181,176,181,145,130,124,127,135,136,136,132,
121,119,144,167,162,167,181,28,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,181,181,181,179,178,177,173,171,167,166,166,167,168,170,167,
168,169,170,169,168,166,167,166,165,164,162,163,164,162,157,150,142,138,130,
125,174,173,174,168,127,40,0,0,0,0,0,0,0,0,0,0,0,0,
0,16,177,173,181,142,130,116,121,126,131,132,128,122,110,103,107,126,168,
165,181,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,
181,181,181,181,181,180,172,167,161,163,165,165,167,167,169,169,170,168,168,
165,165,166,163,161,160,158,156,153,154,151,150,151,147,130,171,173,169,172,
131,99,0,0,0,0,0,0,0,0,0,0,0,0,0,38,177,167,181,
135,124,116,120,123,127,129,121,112,96,89,90,104,152,165,176,60,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,171,181,181,181,181,181,
181,181,181,181,165,161,161,164,165,167,171,170,169,169,168,168,167,164,163,
161,160,158,155,154,148,144,138,137,128,169,174,171,171,137,108,0,0,0,
0,0,0,0,0,0,0,0,0,0,15,177,158,181,134,123,119,122,122,
126,126,121,112,97,91,89,94,144,154,154,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,171,181,181,181,181,181,181,181,181,181,181,
181,181,171,160,164,171,171,170,168,168,168,167,164,164,162,158,157,154,151,
146,143,138,132,127,165,175,171,172,141,143,4,0,0,0,0,0,0,0,
0,0,0,0,0,36,130,137,175,154,129,116,123,124,128,130,123,113,110,
104,95,81,131,153,66,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,172,181,181,181,181,181,181,181,181,181,181,181,181,181,181,175,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,174,159,
177,181,180,181,162,146,34,0,0,0,0,0,0,0,0,0,0,0,0,
19,105,145,162,168,181,170,139,128,129,135,147,165,174,161,119,91,148,133,
75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,181,
181,181,181,181,178,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,178,181,181,170,175,181,181,153,181,150,156,
170,27,0,0,0,0,0,0,0,0,0,0,0,0,0,88,150,161,181,
181,181,171,138,138,155,180,181,181,181,163,105,141,152,33,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,173,181,179,178,175,172,172,
176,179,179,179,178,181,181,180,179,179,178,179,178,176,175,173,173,172,169,
168,165,164,161,169,161,153,161,181,181,136,181,155,148,181,52,0,0,0,
0,0,0,0,0,0,0,0,0,0,73,119,156,173,177,145,181,160,155,
181,181,181,181,181,109,77,127,126,5,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,172,181,174,174,173,172,171,170,172,177,175,176,
181,181,174,176,175,175,173,173,172,173,174,172,175,170,174,173,175,166,166,
150,155,172,181,172,165,181,177,135,169,73,0,0,0,0,0,0,0,0,
0,0,0,0,0,64,53,139,158,139,169,178,136,160,181,181,181,180,154,
161,132,99,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,177,181,174,173,171,170,170,168,169,173,175,173,181,181,172,174,178,
180,179,181,175,180,178,175,174,170,174,167,165,161,160,166,156,181,170,180,
181,163,147,131,137,102,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,71,106,126,134,159,117,118,112,143,180,181,167,155,108,82,96,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,174,
173,170,168,167,166,169,172,173,173,181,181,173,175,181,178,176,174,171,170,
169,165,165,165,162,163,161,161,153,176,170,181,156,181,181,181,140,130,128,
135,76,3,0,0,0,0,0,0,0,0,0,0,0,0,58,97,109,118,
114,99,115,110,88,126,148,138,103,88,72,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,181,181,172,171,169,170,167,166,
166,167,170,171,175,181,176,171,173,170,169,168,169,169,168,167,166,166,165,
165,163,163,161,178,181,181,153,180,181,181,177,137,132,104,0,8,47,0,
0,0,0,0,0,0,0,0,0,0,72,81,103,114,112,103,114,103,97,
132,120,113,93,88,40,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,179,181,170,170,170,167,167,166,166,166,166,165,166,
181,179,170,171,170,169,169,169,167,167,166,166,166,165,163,161,181,181,159,
181,181,153,181,181,177,153,142,143,101,0,14,20,3,0,0,0,0,0,
0,0,0,0,0,56,74,98,111,111,106,105,93,108,120,111,101,87,89,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,177,181,171,167,167,165,164,163,161,161,160,157,158,181,181,171,171,171,
169,168,169,169,168,166,166,166,165,165,163,181,178,165,181,181,162,181,181,
181,160,148,167,142,5,8,30,47,0,0,0,0,0,0,0,0,0,0,
0,90,96,101,106,112,135,118,106,102,98,90,87,50,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,173,165,
161,158,156,155,153,157,161,165,173,181,181,170,172,170,170,168,169,168,167,
166,166,164,164,163,163,181,170,164,181,181,167,181,181,181,163,165,181,151,
36,11,39,89,0,0,0,0,0,0,0,0,0,0,0,68,89,114,125,
143,144,142,116,114,99,84,93,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,181,181,165,155,152,152,153,156,163,
168,173,178,181,181,181,169,171,174,175,176,176,178,178,180,181,181,181,181,
181,105,181,181,181,181,181,181,181,181,165,181,181,151,51,37,57,89,0,
0,0,0,0,0,0,0,0,0,0,11,83,103,104,147,164,164,120,104,
97,95,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,181,181,156,152,158,161,167,174,178,181,181,181,181,181,
181,180,181,181,181,181,181,181,181,181,181,181,181,181,72,30,181,180,181,
181,181,181,181,181,168,181,181,162,136,119,74,94,0,0,0,0,0,0,
0,0,0,0,0,60,97,95,116,120,132,121,105,99,87,84,18,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,181,170,167,174,179,181,181,181,181,180,178,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,140,37,102,181,181,181,181,181,181,181,181,
174,181,181,171,168,155,99,90,0,0,0,0,0,0,0,0,0,0,50,
108,113,105,106,130,136,128,103,92,84,90,73,64,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,179,181,
181,181,180,174,165,145,162,181,181,181,178,176,174,170,172,179,181,180,170,
167,165,168,127,61,143,181,181,181,181,181,181,181,181,181,181,181,175,169,
163,117,73,0,0,0,0,0,0,0,0,15,87,168,153,114,122,118,122,
125,112,107,89,84,86,95,105,121,52,25,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,179,173,161,154,75,0,
23,181,181,181,166,165,159,152,146,91,44,100,151,181,166,166,167,126,82,
155,181,181,181,181,181,181,181,181,181,181,176,174,171,161,122,48,0,0,
0,0,0,0,16,80,117,122,142,99,159,129,136,136,112,96,127,94,86,
91,103,130,142,134,27,40,66,82,45,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,181,151,104,
40,27,3,0,0,0,0,132,170,181,164,163,126,99,153,173,168,181,181,
181,181,181,181,181,181,175,171,165,156,121,16,0,0,0,0,3,49,100,
131,133,136,125,144,140,176,144,146,123,87,117,113,89,100,134,164,150,158,
157,109,90,78,85,81,4,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,15,31,0,0,0,0,0,0,0,
0,0,104,172,181,168,161,103,119,149,168,175,161,181,181,181,181,181,181,
181,176,173,158,142,111,33,8,0,0,10,19,10,11,33,76,113,115,133,
148,174,181,163,143,90,123,134,104,119,129,141,171,156,176,149,115,110,105,
112,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,181,181,
181,151,78,138,151,166,173,150,181,181,181,181,181,181,172,175,172,156,125,
107,57,52,51,19,12,23,40,53,58,49,41,62,86,149,150,181,181,181,
138,122,149,143,128,132,165,181,159,165,178,127,114,112,109,100,89,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,181,181,181,111,98,134,158,
167,168,160,153,181,181,181,181,181,168,156,133,152,110,104,67,65,64,57,
21,8,22,64,83,53,36,19,82,178,175,176,181,181,181,181,181,166,147,
174,181,180,178,163,176,170,107,108,103,91,90,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,164,181,181,113,91,136,161,165,170,166,129,181,
181,181,181,181,170,152,137,126,111,103,82,76,79,74,63,34,19,35,98,
107,108,106,121,181,180,181,180,181,181,181,181,179,181,181,181,181,181,164,
173,181,148,102,101,88,87,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,146,181,181,131,53,142,162,169,171,174,134,178,181,181,181,181,169,
155,133,113,113,97,91,88,86,84,83,71,41,26,70,110,102,100,125,181,
181,181,181,181,181,181,181,172,181,181,181,176,181,172,169,179,180,118,96,
90,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,181,181,
152,35,124,165,152,142,172,147,150,181,181,181,181,165,157,130,113,109,93,
93,92,87,85,90,90,83,58,54,114,106,97,155,181,181,181,181,181,181,
178,181,181,181,181,181,171,181,181,161,176,181,159,99,93,44,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,69,181,181,178,46,89,162,154,
143,164,154,136,181,181,181,181,170,157,126,113,99,92,94,93,94,92,94,
94,92,94,81,110,115,107,181,181,181,181,181,173,181,181,177,181,181,181,
181,181,181,181,167,175,181,169,133,90,38,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,43,181,181,181,60,85,141,153,153,164,152,129,181,
181,181,181,170,157,104,112,94,92,92,94,94,96,95,93,94,95,91,109,
119,150,181,181,181,181,181,180,181,181,181,181,181,181,181,181,181,181,181,
174,179,171,134,98,33,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,24,181,181,181,111,80,149,159,153,169,143,131,179,170,175,181,181,154,
111,104,99,99,94,94,95,95,95,95,92,96,91,121,143,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,178,174,127,105,
13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,181,181,
164,103,162,171,165,161,140,145,181,172,166,169,171,157,122,127,96,97,99,
97,95,95,96,95,95,95,88,137,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,177,144,99,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,181,181,181,163,176,159,167,181,
131,139,164,176,173,163,146,121,126,108,149,101,103,100,99,98,97,98,98,
96,95,103,170,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,178,155,101,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,181,181,181,157,164,169,173,176,158,146,178,176,172,
158,132,105,107,138,142,101,102,101,101,101,100,99,100,100,94,168,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,168,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,155,181,181,146,83,131,169,173,163,163,172,176,173,156,119,108,125,130,
121,102,102,104,104,100,102,101,102,115,174,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,176,156,59,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,30,0,
0,50,169,170,166,160,161,166,171,155,120,118,138,126,119,108,109,108,114,
113,100,141,161,181,181,180,181,179,178,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,176,162,111,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,152,159,
161,163,168,174,151,116,138,130,129,109,63,49,53,13,0,12,172,168,173,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,173,155,131,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,116,142,173,155,160,165,167,146,
121,161,131,119,88,0,0,0,0,0,0,147,171,179,181,181,181,181,181,
179,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
178,165,146,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,80,149,176,181,166,155,152,139,164,150,121,103,122,
0,0,0,0,0,0,110,176,181,181,181,181,181,181,178,178,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,178,173,164,156,120,96,137,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,55,150,173,177,178,179,176,179,171,147,112,105,145,0,0,0,0,0,
0,81,165,172,176,180,181,181,181,181,180,181,181,181,181,181,181,181,181,
181,181,181,181,180,168,148,133,130,139,97,78,133,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,152,172,176,
176,172,174,175,171,144,109,133,165,0,0,0,0,0,0,50,170,175,179,
178,177,178,179,181,181,181,181,181,181,181,181,181,181,181,181,176,162,149,
140,145,150,147,136,92,72,91,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,124,174,174,174,172,173,173,171,
143,112,161,161,0,0,0,0,0,0,6,155,170,177,181,181,181,180,181,
181,181,181,181,181,181,181,181,181,175,167,162,162,169,168,156,139,120,120,
106,127,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,57,174,169,169,168,170,172,169,136,120,156,145,0,
0,0,0,0,0,0,135,165,168,168,177,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,180,174,163,157,158,167,174,162,139,35,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,21,143,158,158,158,162,161,147,139,127,139,92,0,0,0,0,0,0,
0,86,171,176,179,178,179,177,177,180,181,181,181,181,181,181,181,181,181,
176,169,165,164,168,174,179,172,159,135,110,99,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,125,152,176,
176,174,171,166,162,114,157,0,0,0,0,0,0,0,0,42,159,170,180,
181,181,181,181,181,181,181,181,181,181,181,181,173,174,178,181,181,181,181,
181,181,181,181,122,135,116,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,129,141,160,168,172,174,160,140,
131,126,0,0,0,0,0,0,0,0,0,153,162,169,177,179,180,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
150,133,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,133,142,145,155,167,166,136,119,169,40,0,0,0,
0,0,0,0,0,0,86,163,165,171,178,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,152,129,64,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,140,154,147,145,160,154,124,116,172,0,0,0,0,0,0,0,0,0,
0,27,167,172,177,180,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,154,129,99,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,161,147,147,
160,141,112,174,115,0,0,0,0,0,0,0,0,0,0,0,153,171,178,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,155,127,106,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,56,162,151,141,153,132,127,181,24,
0,0,0,0,0,0,0,0,0,0,0,85,164,170,178,180,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,156,
124,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,41,135,152,131,165,70,0,0,0,0,0,0,
0,0,0,0,0,0,58,170,174,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,157,128,108,17,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,32,161,175,179,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,136,105,34,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,152,168,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,146,108,58,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,20,167,167,177,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,150,
112,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,23,154,168,169,178,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,152,123,76,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
81,154,175,181,181,179,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,81,147,132,73,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,165,181,178,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,157,174,181,150,62,0,0,0,0,0,

/* #11: Seraph (by Chris_C) */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,0,0,0,0,0,0,11,12,12,13,14,17,2,0,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,32,29,
41,105,175,207,207,210,206,209,219,205,168,139,108,50,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,19,86,160,224,244,244,244,244,244,244,244,244,
244,243,244,244,244,244,244,244,244,218,114,35,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,25,
152,207,223,244,244,244,242,243,243,242,243,241,242,241,241,243,242,242,242,
241,241,241,242,244,244,243,192,71,23,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,25,119,210,244,242,240,239,241,
241,241,241,241,241,242,243,243,242,242,243,242,242,241,241,241,240,242,242,
242,242,244,238,174,95,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,4,119,228,243,241,240,239,239,240,241,241,241,243,242,240,
240,241,241,241,242,241,241,240,240,243,243,241,242,243,242,240,242,239,236,
244,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,66,184,
233,236,237,237,240,241,241,242,242,242,241,242,241,240,240,238,232,233,238,
240,239,239,240,242,242,241,241,240,241,242,242,241,241,242,234,167,28,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,11,90,136,196,223,236,239,240,241,242,243,
240,240,241,237,238,235,232,231,227,224,222,222,225,227,228,230,234,238,240,
241,241,240,239,241,243,242,241,239,241,242,239,212,77,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,120,194,226,238,241,239,240,242,243,241,242,238,229,221,219,216,
214,213,212,208,205,198,205,209,205,209,219,224,229,235,236,237,240,241,240,
241,241,242,240,239,242,242,243,213,49,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,209,228,
238,238,239,241,242,241,242,239,228,210,195,188,189,187,186,190,190,192,190,
177,190,197,196,202,209,215,221,223,229,236,240,240,241,241,242,241,241,242,
241,242,242,239,174,8,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,119,238,230,238,237,235,237,239,234,
221,210,198,180,171,171,172,173,178,180,176,174,180,175,169,183,190,193,204,
207,210,217,220,227,235,238,239,240,239,239,239,239,240,241,240,239,238,244,
107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,21,220,224,231,238,240,235,217,203,185,164,159,160,160,161,
161,163,168,171,171,170,174,175,174,176,187,189,191,201,206,208,215,219,224,
233,237,239,241,240,239,238,239,241,240,239,240,238,240,229,40,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,76,
224,226,231,239,235,192,160,155,151,148,150,152,153,154,157,158,164,168,173,
178,184,187,188,192,197,195,195,201,204,206,213,219,224,230,235,238,240,241,
239,237,240,240,239,239,239,238,240,237,132,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,2,0,123,238,230,235,233,188,
144,141,146,146,145,145,144,146,152,154,156,164,170,181,190,194,196,196,197,
198,197,198,201,204,204,212,219,223,228,234,239,241,241,242,240,240,241,241,
241,240,240,240,244,214,54,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,9,192,238,231,236,189,136,130,139,141,141,138,
137,139,144,151,155,159,165,172,182,188,193,198,199,198,197,197,199,204,206,
205,211,216,220,227,234,239,241,241,241,242,243,242,242,242,242,242,241,242,
244,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,40,212,238,239,209,135,119,124,129,133,133,134,136,138,140,149,158,
162,166,170,178,187,190,192,194,197,200,198,201,206,206,206,209,212,215,224,
231,236,240,241,242,243,243,243,243,242,242,241,241,242,244,168,10,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,211,241,
233,154,109,115,115,121,123,123,125,129,135,137,145,154,161,162,166,174,181,
185,190,194,198,204,204,204,203,205,207,208,209,212,217,223,232,237,240,243,
243,244,243,243,242,242,241,242,241,240,229,34,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,15,193,244,198,118,107,101,96,
110,118,120,125,128,133,139,142,147,156,164,169,176,184,185,186,186,189,197,
199,200,204,206,207,211,210,208,212,219,226,233,237,242,242,242,243,242,242,
242,242,242,242,240,239,38,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,3,0,171,244,167,108,102,87,95,113,120,126,131,131,
131,136,137,142,155,169,177,183,186,185,182,182,185,192,194,195,201,205,205,
209,212,210,212,217,222,227,231,238,241,241,243,242,242,244,244,243,241,239,
244,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,0,164,233,139,106,100,88,109,121,121,133,142,137,123,122,129,143,161,
173,183,189,190,196,205,209,215,216,211,211,212,211,209,210,211,210,212,217,
219,223,230,235,240,239,241,243,243,243,243,243,244,239,244,53,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,163,216,127,
110,106,99,110,115,123,137,148,141,114,109,123,143,156,164,185,205,215,225,
232,228,226,226,224,223,220,217,215,213,212,211,213,216,220,223,227,232,238,
241,243,243,244,243,243,243,244,239,244,75,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,3,0,163,209,119,108,106,101,101,104,
115,132,150,149,115,98,114,140,171,185,213,231,233,230,217,202,205,208,211,
215,216,216,216,215,214,214,215,217,218,220,224,230,239,243,243,242,240,242,
240,240,242,243,244,181,5,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,3,0,149,204,113,108,112,102,93,92,101,121,139,149,137,
116,127,159,193,204,214,207,189,177,171,163,160,186,213,214,219,220,217,214,
212,213,216,218,215,216,224,233,238,240,244,223,199,239,244,241,238,224,202,
224,128,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
0,91,198,114,107,116,86,64,72,93,111,124,147,151,145,150,170,200,205,
186,193,221,207,174,153,116,130,199,221,221,195,206,224,220,221,224,223,221,
222,226,232,238,241,242,242,240,243,243,239,226,214,216,223,209,48,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,55,190,116,117,
141,136,138,143,152,153,141,152,157,160,172,189,198,170,207,238,244,128,56,
70,59,152,194,162,224,219,224,230,225,219,220,221,221,222,223,217,215,227,
237,243,243,241,239,234,232,232,234,230,238,143,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,32,185,117,156,197,214,209,188,179,
183,174,156,149,154,178,206,175,172,240,237,240,205,153,141,169,221,217,188,
229,232,225,216,215,213,212,213,215,217,218,218,221,219,229,240,241,238,234,
233,235,237,236,235,226,223,45,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,31,192,163,190,177,158,143,148,152,166,169,144,119,108,
158,208,170,197,244,239,239,244,243,235,235,243,206,174,227,227,223,214,210,
210,209,208,211,212,213,213,217,222,229,239,243,239,235,233,234,237,237,235,
231,232,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
30,209,199,155,124,160,200,212,203,173,168,176,120,125,149,181,136,195,244,
239,239,238,234,231,236,243,188,188,233,229,220,212,207,205,205,206,208,209,
212,213,214,220,226,235,241,239,236,235,236,238,238,236,231,229,218,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,215,156,153,200,
225,238,221,184,140,105,149,147,159,149,174,191,194,235,244,242,241,236,232,
244,224,171,210,229,220,206,200,200,202,206,208,209,210,214,214,215,220,226,
233,240,238,232,231,236,241,240,237,232,231,208,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,49,186,146,204,227,237,219,142,63,75,
112,164,177,144,116,163,194,194,192,227,244,243,240,235,214,177,194,211,201,
188,186,191,197,201,205,206,209,214,216,218,220,224,227,233,239,239,233,229,
233,241,242,234,229,227,211,2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,155,188,171,212,219,222,200,215,198,208,229,168,170,111,115,
171,191,210,203,185,188,200,201,194,201,207,197,188,176,176,183,190,196,200,
204,206,210,215,218,222,223,224,227,230,236,236,231,231,236,240,238,235,226,
224,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,140,130,
142,220,209,208,209,208,223,232,244,235,162,178,94,116,179,194,211,218,208,
200,200,199,192,183,179,179,180,179,178,181,192,199,201,205,207,210,214,217,
222,225,225,226,231,234,234,229,232,238,228,220,229,218,231,117,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,13,50,83,172,189,217,214,217,
220,227,232,241,211,157,177,84,101,166,193,206,216,213,208,203,197,189,178,
174,176,180,181,183,185,194,199,202,207,207,209,212,215,220,225,224,225,227,
228,229,227,231,233,225,221,216,208,223,36,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,33,162,201,198,194,194,209,227,207,159,
158,149,85,103,151,188,204,215,219,216,213,202,183,175,175,176,180,183,187,
191,195,199,203,205,206,207,209,213,217,221,223,225,225,224,226,228,228,224,
212,206,205,224,143,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,5,147,140,154,165,171,153,110,114,157,142,82,98,151,
191,203,205,195,194,211,222,209,188,180,178,184,188,191,197,200,200,203,206,
207,207,206,212,215,216,219,222,224,224,225,227,229,225,217,215,222,212,51,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
0,53,104,72,58,64,89,85,84,112,92,77,84,136,182,201,205,194,183,
198,220,230,215,187,185,190,192,196,199,203,204,205,207,205,205,206,210,212,
215,218,220,223,225,223,222,223,226,224,224,239,207,34,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,116,82,66,
62,85,80,107,111,78,77,88,128,176,198,198,202,211,203,196,220,222,193,
189,190,192,196,202,205,205,205,205,205,205,207,208,208,212,215,217,224,226,
225,224,216,226,230,224,243,215,39,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,7,91,94,83,66,73,81,106,111,
79,77,112,137,175,195,215,229,224,209,194,208,209,196,190,192,195,198,201,
204,205,206,207,205,205,205,205,205,207,210,217,225,225,226,222,211,226,234,
224,242,202,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,72,105,94,86,83,85,100,108,91,132,194,192,174,
182,209,199,197,206,208,204,203,200,197,196,197,200,205,209,210,210,208,208,
208,207,206,206,207,209,215,219,223,224,220,214,225,233,229,244,176,0,7,
4,4,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,47,126,95,98,94,90,98,104,97,148,208,164,107,107,131,135,181,195,
202,206,208,206,204,204,204,205,206,211,216,214,210,210,210,208,208,206,205,
207,210,216,221,222,219,215,225,233,230,241,177,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,111,104,
107,104,98,93,72,64,88,75,74,120,131,113,175,196,202,206,209,212,213,
211,206,202,201,203,207,209,211,211,209,206,206,207,204,203,206,212,219,221,
220,216,221,230,233,227,222,186,178,208,216,219,109,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,87,115,109,109,103,87,73,
67,73,84,86,123,172,106,131,200,207,207,206,204,206,209,205,199,195,197,
203,209,213,209,207,205,204,205,203,201,204,208,214,218,217,218,226,232,233,
228,212,206,209,208,197,190,191,48,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,24,119,107,110,112,96,77,74,82,91,80,91,
135,136,170,211,211,209,209,213,217,221,216,206,195,194,196,201,207,207,206,
200,202,204,203,201,202,206,211,213,215,221,229,233,233,231,214,211,222,206,
189,187,187,176,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,46,116,107,109,103,93,88,91,95,86,124,170,193,219,224,221,
222,229,233,228,221,211,205,200,196,195,198,204,206,201,200,202,203,202,199,
200,205,207,208,217,224,232,237,235,231,223,206,193,187,185,183,178,182,187,
16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,
114,106,106,100,103,113,96,131,203,213,191,179,174,181,209,225,218,213,210,
208,205,203,198,195,197,202,204,201,201,203,201,198,197,198,200,204,209,220,
228,234,238,237,237,218,195,192,186,182,169,165,174,195,115,0,3,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,7,95,113,105,104,121,
146,149,171,143,101,117,137,171,203,207,204,202,205,207,205,205,205,202,197,
200,203,205,201,201,201,198,196,193,196,198,205,217,226,232,233,238,243,224,
191,191,190,180,166,164,167,171,181,175,35,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,54,119,105,104,111,145,143,98,94,112,
152,180,190,200,193,194,199,199,199,201,204,204,204,201,203,206,207,205,200,
198,195,196,196,198,204,214,224,228,231,231,237,225,191,187,188,184,175,168,
166,169,170,171,199,91,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,72,121,105,106,111,101,91,93,103,137,166,173,180,176,
178,190,197,199,200,202,204,205,203,204,206,206,202,198,195,191,192,198,209,
220,225,225,225,226,232,218,189,187,186,182,177,175,165,166,165,169,173,191,
135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,76,118,108,107,100,96,94,96,114,137,145,146,155,165,178,185,192,199,
200,200,203,204,203,202,200,197,193,192,192,199,211,219,225,222,220,222,225,
212,183,182,181,179,175,176,168,165,166,168,171,180,165,179,161,27,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,120,109,
106,101,98,99,108,115,117,123,135,152,172,184,193,200,201,200,200,199,197,
196,193,190,189,192,200,213,223,224,223,219,218,217,197,183,182,178,174,176,
174,170,164,161,163,166,175,160,184,201,178,175,39,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,6,101,119,107,99,93,97,101,
96,94,109,127,152,181,190,197,201,198,196,194,194,191,188,187,186,190,201,
214,225,226,223,219,217,213,196,181,181,177,172,174,172,167,167,164,159,163,
164,156,184,213,178,156,182,158,18,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,22,120,121,110,96,88,91,86,86,111,139,158,
182,194,199,198,195,191,187,187,186,185,187,191,201,216,226,229,223,219,216,
211,195,180,176,176,172,169,169,171,165,161,161,160,163,156,169,202,175,151,
163,159,165,149,49,7,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,13,102,134,112,94,88,91,105,132,154,171,187,194,196,193,188,
183,180,181,183,186,192,202,216,226,230,223,213,211,202,188,180,176,172,168,
168,170,169,166,163,158,163,162,154,168,201,191,147,147,144,146,151,147,165,
138,63,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
59,135,112,99,105,122,147,169,178,184,186,186,184,181,179,181,183,188,195,
206,217,222,225,215,202,199,198,187,170,166,167,169,169,169,171,164,159,155,
162,161,148,160,192,198,155,143,140,144,160,145,144,146,146,158,132,81,55,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,101,114,127,
149,177,197,195,184,177,178,178,180,182,182,187,194,206,214,217,215,204,193,
189,187,176,167,165,163,165,167,168,167,164,159,154,158,159,153,154,175,194,
154,135,139,140,158,145,137,150,147,141,143,144,153,158,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,11,26,35,38,36,51,103,
154,165,184,184,186,190,195,202,210,208,202,195,186,173,169,170,165,159,159,
162,162,164,165,166,161,157,158,151,148,156,170,185,157,135,140,131,152,156,
132,137,149,145,136,141,142,136,136,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,127,147,143,158,
191,197,194,187,171,153,130,111,123,154,160,159,161,160,159,160,160,158,158,
151,153,143,131,141,174,169,144,125,138,136,123,154,136,108,124,141,142,132,
127,123,127,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,4,87,98,91,128,177,172,160,155,150,
122,87,114,155,160,157,159,158,156,156,157,151,150,141,134,109,113,136,155,
140,116,101,91,132,98,107,145,91,70,112,131,128,115,108,112,126,131,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,61,139,87,95,128,164,161,160,164,146,105,118,155,162,160,
153,147,143,139,146,143,144,137,140,103,83,142,159,111,91,106,63,91,119,
69,114,126,57,67,105,120,128,123,111,112,110,112,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,145,
166,122,88,126,171,179,165,154,122,122,158,158,153,143,141,138,129,140,136,
141,137,133,101,95,131,157,98,61,118,86,59,118,87,81,133,86,44,79,
109,131,140,131,113,103,97,95,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,2,0,56,137,161,167,152,114,123,178,
183,155,139,119,150,162,153,141,132,123,130,138,131,135,129,135,87,70,137,
142,87,61,102,132,70,93,116,70,103,124,62,48,89,119,138,140,134,113,
93,83,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,101,162,166,160,169,160,119,149,172,152,133,123,159,
152,144,137,127,123,135,127,129,125,130,89,79,117,123,77,56,78,129,118,
63,109,94,79,126,102,43,59,103,132,138,141,141,103,71,72,81,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
48,138,171,171,168,172,188,158,112,133,141,129,118,154,151,137,124,113,123,
112,125,117,128,91,79,124,99,81,65,68,107,138,91,77,105,74,97,126,
64,39,71,119,138,138,139,122,78,62,76,86,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,131,176,177,175,
176,191,195,131,111,130,124,111,150,154,137,119,109,116,119,108,115,101,80,
114,80,67,91,60,95,139,125,68,96,97,71,107,101,44,45,86,126,140,
142,132,92,63,69,78,82,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,16,106,167,175,176,184,188,202,177,113,
110,117,111,135,154,132,108,112,119,101,103,117,85,82,73,59,74,69,76,
126,137,87,71,111,78,81,112,79,37,50,101,138,143,144,102,61,63,68,
70,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,0,52,140,167,175,180,185,188,191,161,108,119,114,105,149,
144,119,118,104,96,109,95,72,67,69,73,63,65,110,142,115,57,89,105,
69,89,98,64,39,58,115,141,144,119,70,56,60,75,103,107,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,25,116,160,177,180,183,191,208,140,100,119,106,110,140,134,125,102,96,
77,70,71,75,80,64,50,91,133,136,80,63,106,87,68,90,78,58,42,
67,128,140,137,95,55,72,104,138,129,82,


/* #C1 KNOPPIX.RU credit (by Alex) */
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,178,151,252,255,252,158,155,246,186,151,240,255,255,185,160,255,
255,255,195,143,153,215,255,255,255,152,151,158,174,190,249,255,255,178,151,155,
170,185,234,255,255,255,175,151,151,151,151,252,255,175,151,231,255,255,205,151,
200,255,255,255,255,255,255,255,255,255,178,151,153,171,195,240,255,255,200,151,
229,255,255,153,172,255,255,255,255,255,255,255,255,255,64,0,244,252,84,4,
166,255,86,0,102,255,255,78,21,255,255,94,0,16,8,3,142,255,255,0,
3,14,3,0,32,207,255,64,0,15,5,0,12,163,255,255,67,12,0,3,
8,247,255,190,2,70,254,236,24,24,231,255,255,255,255,255,255,255,255,255,
64,0,12,0,0,14,207,255,119,0,191,255,255,2,50,255,255,255,255,255,
255,255,255,255,64,0,240,84,6,175,255,255,86,0,1,195,255,78,21,255,
167,0,98,255,240,44,4,219,255,0,52,255,255,153,0,84,255,64,0,244,
255,211,5,21,255,255,255,188,0,124,255,255,255,255,131,0,146,82,3,191,
255,255,255,255,255,255,255,255,255,255,64,0,244,234,134,0,106,255,119,0,
191,255,255,2,50,255,255,255,255,255,255,255,255,255,64,0,76,0,177,255,
255,255,86,20,31,41,249,78,21,255,92,0,213,255,255,146,0,155,255,0,
52,255,255,200,0,78,255,64,0,244,255,243,19,14,255,255,255,188,0,124,
255,255,255,255,254,72,3,0,136,255,255,255,255,255,255,255,255,255,255,255,
64,0,243,230,145,0,109,255,119,0,191,255,255,2,50,255,255,255,255,255,
255,255,255,255,64,0,6,0,124,255,255,255,86,12,174,0,129,78,21,255,
60,0,240,255,255,174,0,127,255,0,12,54,28,0,8,188,255,64,0,53,
37,4,0,134,255,255,255,188,0,124,255,255,255,255,255,194,0,14,243,255,
255,255,255,255,255,255,255,255,255,255,64,0,4,0,1,68,233,255,119,0,
191,255,255,2,50,255,255,255,255,255,255,255,255,255,64,0,194,83,2,190,
255,255,86,12,255,78,7,60,21,255,82,0,221,255,255,153,0,155,255,0,
24,124,142,159,226,255,255,64,0,116,136,153,203,255,255,255,255,188,0,124,
255,255,255,255,241,38,23,4,88,255,255,255,255,255,255,255,255,255,255,255,
64,0,143,25,46,222,255,255,125,0,186,255,252,1,57,255,255,255,255,255,
255,255,255,255,64,0,244,234,21,25,234,255,86,12,255,228,13,1,21,255,
140,0,125,255,252,62,5,220,255,0,52,255,255,255,255,255,255,64,0,244,
255,255,255,255,255,255,255,188,0,124,255,255,255,255,82,2,191,129,0,145,
255,255,255,255,239,232,255,255,255,255,64,0,244,204,9,35,236,255,159,0,
134,255,209,0,90,255,255,255,255,255,255,255,255,255,64,0,244,255,174,0,
74,254,86,12,255,255,145,0,21,255,246,47,0,56,37,1,137,255,255,0,
52,255,255,255,255,255,255,64,0,244,255,255,255,255,255,255,86,29,0,23,
48,249,255,138,0,118,255,252,58,5,196,255,255,255,71,4,255,255,255,255,
64,0,244,255,155,0,70,254,243,28,6,58,22,3,196,255,255,255,255,255,
255,255,255,255,155,120,250,255,255,146,120,219,166,126,255,255,254,129,131,255,
255,249,151,101,114,191,255,255,255,120,149,255,255,255,255,255,255,155,120,250,
255,255,255,255,255,255,150,120,120,120,120,252,244,124,126,249,255,255,222,120,
146,255,255,255,158,122,255,255,255,255,155,120,250,255,255,143,120,213,255,237,
137,102,124,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,

/* #C2 Double Creations Credit (by Vince) */
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,
255,255,0,0,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,
255,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,0,
255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,0,
255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,0,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,0,255,255,255,255,0,255,255,255,255,255,255,255,255,255,
255,255,255,0,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,
0,255,255,0,0,0,255,255,0,255,255,0,255,0,0,0,0,255,255,0,
255,255,255,0,0,0,255,255,255,0,255,255,255,255,255,0,0,0,0,255,
0,0,0,255,255,0,0,0,0,255,0,0,0,255,0,0,255,255,255,0,
0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,255,255,255,255,255,
255,255,255,255,255,0,255,255,255,255,0,255,0,0,255,0,0,255,0,255,
255,0,255,0,255,255,255,0,255,0,255,255,0,255,255,255,0,255,255,0,
255,255,255,255,255,255,0,255,0,0,255,255,255,0,255,255,255,255,0,255,
255,0,255,255,255,0,255,255,0,0,255,0,0,255,255,0,255,255,0,255,
255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,
0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,
255,255,0,0,0,0,0,255,255,0,255,255,255,255,255,255,0,255,255,0,
0,0,0,0,255,0,0,0,0,255,255,0,255,255,255,0,255,255,0,255,
255,255,0,255,255,0,255,255,0,255,255,255,0,0,255,255,255,255,255,255,
255,255,255,255,255,0,255,255,255,0,255,255,0,0,255,0,0,255,0,255,
255,0,255,0,255,255,255,0,255,0,255,255,0,255,255,255,255,255,255,255,
0,255,255,255,255,255,0,255,255,0,255,255,255,255,255,0,255,255,0,255,
255,0,255,255,255,0,255,255,0,0,255,0,0,255,255,0,255,255,0,255,
255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,
255,255,255,0,0,0,255,255,0,0,0,0,255,0,0,0,0,255,255,0,
0,255,255,0,0,0,0,255,255,255,255,0,0,0,255,0,0,0,255,255,
0,0,0,0,255,0,0,0,0,0,255,0,0,255,0,0,0,255,255,0,
0,0,255,255,0,0,255,255,0,0,255,0,0,0,0,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};

#endif /* MATRIX_IMAGES_H */
