#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/* */
/*  Copyright (C)  1999-2011 Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; 
*/
//////    do diff
#define notUNIFIED_DIFF
static gint
configure_event (GtkWidget * widget, GdkEventConfigure * event, gpointer data);

void *
hideshow_menus (gpointer data);

polygon_t *
pushPolygon (diff_t *diff_p, int *top, int *bottom, int *current_line);


static GdkPixbuf *
get_application_pixbuf(gint size){
    GdkPixbuf *pixbuf = rfm_get_pixbuf("rodent-diff", size);
    if (!pixbuf){
	gchar *file = g_build_filename(PREFIX, "share", "pixmaps", "rodent-diff.png", NULL);
	pixbuf = rfm_get_pixbuf(file, size);
	g_free(file);
    }
    return pixbuf;
}

void
insert_void (GtkTextBuffer * buffer) {
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=4
    GdkRGBA gray={0.85, 0.85, 0.85, 1.0};
    const gchar *bg = "background-rgba";
#else
    GdkColor gray={2,40000,40000,40000};
    const gchar *bg = "background_gdk";
#endif
    GtkTextIter start, end;
    int i;
    char *space = " ";
    GtkTextTag *tag;

    tag = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "void");
    if(!tag) {
        gtk_text_buffer_create_tag (buffer, "void", bg, &gray, NULL);
    }
    gtk_text_buffer_get_iter_at_offset (buffer, &end, 0);
    gtk_text_iter_forward_to_end (&end);
    for(i = 0; i < 255; i++)
        gtk_text_buffer_insert (buffer, &end, space, 1);
    space = "\n";
    gtk_text_buffer_insert (buffer, &end, space, 1);

    start = end;
    gtk_text_iter_backward_chars (&start, 256);
    gtk_text_buffer_apply_tag_by_name (buffer, "void", &start, &end);
}


void
utf8_insert (GtkTextBuffer * buffer, char *line) {
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=4
    GdkRGBA fore={0.6, 0.6, 0.6, 1.0};
    GdkRGBA back={1.0, 1.0, 1.0, 1.0};
    const gchar *fg = "foreground-rgba";
    const gchar *bg = "background-rgba";
#else
    GdkColor fore={2,40000,40000,40000};
    GdkColor back={1,65000,65000,65000};
    const gchar *fg = "foreground_gdk";
    const gchar *bg = "background_gdk";
#endif
    GtkTextIter end;
    GtkTextTag *tag;
    GtkTextTag *tags[]={NULL,NULL,NULL};
    tag = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "nfore");
    if(!tag) {
        /*TRACE("dbg:creating tag %s\n",tag_id); */
	gtk_text_buffer_create_tag (buffer, "nfore", fg, &(fore), NULL);
	gtk_text_buffer_create_tag (buffer, "nback", bg, &(back), NULL);
        gtk_text_buffer_create_tag (buffer, "italic", "style", PANGO_STYLE_ITALIC, NULL);
        //gtk_text_buffer_create_tag (buffer, "weight", "weight", PANGO_WEIGHT_BOLD, NULL);
    }
    tags[0] = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "nfore");
    tags[1] = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "nback");
    tags[2] = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "italic");

    gtk_text_buffer_get_iter_at_offset (buffer, &end, 0);
    gtk_text_iter_forward_to_end (&end);
    gchar *q = rfm_utf_string (line);
    gtk_text_buffer_insert_with_tags (buffer, &end, q, -1, tags[0], tags[1], tags[2],  NULL);
    g_free (q);
    /*gchar *q = rfm_utf_string (line);
    gtk_text_buffer_insert_at_cursor (buffer, q, -1);
    g_free (q);*/
}

//FIXME: do the gtk2 compatibility...
void
utf8_insert_tag (GtkTextBuffer * buffer, char *line) {
	
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=4
    GdkRGBA fore={0.2, 0.2, 0.9, 1.0};
    GdkRGBA back={1.0, 1.0, 1.0, 1.0};
    const gchar *fg = "foreground-rgba";
    const gchar *bg = "background-rgba";
#else
    GdkColor fore={2,12000,12000,64000};
    GdkColor back={1,65000,65000,65000};
    const gchar *fg = "foreground_gdk";
    const gchar *bg = "background_gdk";
#endif

    GtkTextIter end;
    GtkTextTag *tag;
    GtkTextTag *tags[]={NULL,NULL,NULL};
    tag = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "fore");
    if(!tag) {
        /*TRACE("dbg:creating tag %s\n",tag_id); */
	gtk_text_buffer_create_tag (buffer, "fore", "foreground-rgba", &(fore), NULL);
	gtk_text_buffer_create_tag (buffer, "back", "background-rgba", &(back), NULL);
        gtk_text_buffer_create_tag (buffer, "weight", "weight", PANGO_WEIGHT_BOLD, NULL);
    }
    tags[0] = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "fore");
    tags[1] = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "back");
    tags[2] = gtk_text_tag_table_lookup (gtk_text_buffer_get_tag_table (buffer), "weight");
    gtk_text_buffer_get_iter_at_offset (buffer, &end, 0);
    gtk_text_iter_forward_to_end (&end);
    gchar *q = rfm_utf_string (line);
    gtk_text_buffer_insert_with_tags (buffer, &end, q, -1, tags[0], tags[1], tags[2],  NULL);
    g_free (q);
}


static void
advance_buffers (diff_t *diff_p, int *file_line_number, int *file_skiplines) {
    int i;
    char skip_line[256 * 256];
    for(i = 0; i < 2; i++)
        if(diff_p->skip_file[i]) {
            int j;
            /* equal lines */
            for(; diff_p->current_line[i] < diff_p->file_line_number[i] && !feof (diff_p->skip_file[i]); diff_p->current_line[i]++) {
                if(fgets (skip_line, 256 * 256 - 1, diff_p->skip_file[i]) == NULL)
                    DBG ("fgets:%s\n", strerror (errno));
                utf8_insert (diff_p->text_buffer[i], skip_line);
                if(i)
                    diff_p->current_buffer_line++;
            }
            /* skip diff sector */
            for(j = 0; j < diff_p->file_skiplines[i] && !feof (diff_p->skip_file[i]); j++) {
                if(fgets (skip_line, 256 * 256 - 1, diff_p->skip_file[i]) == NULL)
                    DBG ("fgets:%s\n", strerror (errno));
            }
        }
}

static void
add_different_line (diff_t *diff_p, char *line, int i) {
    diff_p->diff_subsection = TRUE;
    utf8_insert_tag (diff_p->text_buffer[i], line);
    diff_p->current_line[i]++;
    diff_p->bottom_bufferline[i]++;
}

static void
add_synchronization_lines (diff_t *diff_p) {
    int i;
    if(diff_p->sync_count == 0)
        return;
    if(diff_p->sync_count < 0) {
        for(i = 0; i > diff_p->sync_count; i--) {
            insert_void (diff_p->text_buffer[1]);
        }
    } else {
        diff_p->current_buffer_line += diff_p->sync_count;
        for(i = 0; i < diff_p->sync_count; i++) {
            insert_void (diff_p->text_buffer[0]);
        }
    }
    diff_p->sync_count = 0;
}

static void
add_previous_polygon (diff_t *diff_p) {
    //widgets_t *widgets_p=&(diff_p->widgets);
    if(!diff_p->polygon_current) {
        int value;
        diff_p->polygon_current = pushPolygon (diff_p, diff_p->top_bufferline, diff_p->bottom_bufferline, diff_p->current_line);
         value = (diff_p->polygon_current->topR < diff_p->polygon_current->topL) ?
	    diff_p->polygon_current->topR : diff_p->polygon_current->topL;
        if(value >= diff_p->lineH)
            value -= diff_p->lineH;
        else
            value = 0;
        gtk_adjustment_set_value (GTK_ADJUSTMENT (diff_p->adj), value);
        configure_event (diff_p->drawA, NULL, diff_p);

    } else {
        pushPolygon (diff_p, diff_p->top_bufferline, diff_p->bottom_bufferline, diff_p->current_line);
    }
}


static int
pre_diff (diff_t *diff_p) {
    return TRUE;
}

static void show_current_polygon(diff_t *diff_p);
static void
post_diff (diff_t *diff_p) {
    if(diff_p->patchmake_flags & SILENT) return;
    // This function is within the GDK MUTEX
    widgets_t *widgets_p=&(diff_p->widgets);
    //if(patchO) return;
    gchar *active_left=NULL;
    if (rfm_g_file_test(diff_p->left_file, G_FILE_TEST_IS_DIR)) {
	GtkTreeIter iter;
	
	gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_left), &iter); 
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_left), &iter,
	    BASENAME_COLUMN, &active_left,
	    -1);
    } else {
	active_left = g_strdup(diff_p->left_file);
    }
    gchar *active_right=NULL;
    if (rfm_g_file_test(diff_p->right_file, G_FILE_TEST_IS_DIR)) {
	GtkTreeIter iter;

	gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_right), &iter); 
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_right), &iter,
	    BASENAME_COLUMN, &active_right,
	    -1);
    } else {
	active_right = g_strdup(diff_p->right_file);
    }
    

    gchar *f = g_strdup_printf (_("Differences of %s and %s"), active_left, active_right);
    rfm_diagnostics(widgets_p, "rodent-diff", " ", f, "\n", NULL);
    rfm_diagnostics(widgets_p, "rodent-diff", " ",NULL);
    g_free(f);
    g_free(active_left);
    g_free(active_right);
    if(diff_p->diffC) {           
	gchar *g =
	    g_strdup_printf (
		    ngettext("%d difference", "%d differences", diff_p->diffC),
			     diff_p->diffC);
	rfm_diagnostics(widgets_p, "xffm_tag/red", _("Found"), ": ", g, "\n", NULL);
	g_free (g);
    } else {
	rfm_diagnostics(widgets_p, "xffm_tag/green", _("The files are identical."),
		"(", _("No Differences Found"),")\n",NULL);
    }
    while (gtk_events_pending())gtk_main_iteration();
    show_current_polygon(diff_p);
}

gboolean diff_stdout_f(gpointer data){
    void **arg = data;
    diff_t *diff_p=arg[0];
    char *line=arg[1];
    g_free(arg);
    widgets_t *widgets_p=&(diff_p->widgets);
   
    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
        gchar *string = rfm_diagnostics_exit_string(line);
        rfm_threaded_diagnostics(widgets_p, "xffm/stock_stop", string);
        goto done;

    }
// normal GNU diff output
    const gchar *tag=NULL;
    if (line[0]=='>'){
	tag="xffm_tag/green";
    } else if (line[0]=='<') {
	tag="xffm_tag/red";
    } else if (isdigit(line[0]) || strncmp(line,"---",strlen("---"))==0) {
	tag="xffm_tag/cyan";
    } 

    rfm_diagnostics(widgets_p,tag, line, NULL);
    if (isdigit(line[0])) {
        gchar mode=0;
	diff_p->diffC++;
	add_synchronization_lines (diff_p);

        if(diff_p->diff_subsection) {
	    add_previous_polygon (diff_p);
	    configure_event (diff_p->drawA, NULL, diff_p);
	} else {
	    diff_p->diff_subsection=TRUE;
	}
	TRACE("got %s\n", line);
	if (strchr(line,'c')){
	    *strchr(line,'c')=0;
	    mode='c';
	} else if (strchr(line,'a')){
	    *strchr(line,'a')=0;
	    mode='a';
	} else if (strchr(line,'d')){
	    *strchr(line,'d')=0;
	    mode='d';
	}
	gchar *left=line;
	gchar *right=line+strlen(line)+1;
	TRACE("mode=%c left=%s right=%s\n", mode, left, right);
	if (strchr(left,',')) {
	    *strchr(left,',')=0;
	    diff_p->file_line_number[0]=atoi(left)-1;
	    left=left+strlen(left)+1;
	    diff_p->file_skiplines[0] = atoi(left)-diff_p->file_line_number[0];
	} else {
	    if (mode=='a') {
		diff_p->file_line_number[0]=atoi(left);
		diff_p->file_skiplines[0] = 0;
	    } else if (mode) {
		diff_p->file_line_number[0]=atoi(left)-1;
		diff_p->file_skiplines[0] = 1;
	    } else g_warning("diff_stdout_f(): undefined mode variable [1]\n");
	}
	if (strchr(right,',')) {
	    *strchr(right,',')=0;
	    diff_p->file_line_number[1]=atoi(right)-1;
	    right=right+strlen(right)+1;
	    diff_p->file_skiplines[1] = atoi(right)-diff_p->file_line_number[1];
	} else {
	    if (mode=='d') {
		diff_p->file_line_number[1]=atoi(right);
		diff_p->file_skiplines[1] = 0;
	    } else if (mode) {
		diff_p->file_line_number[1]=atoi(right)-1;
		diff_p->file_skiplines[1] = 1;
	    } else g_warning("diff_stdout_f(): undefined mode variable [1]\n");
	}
	gchar *g=g_strdup_printf("--> %d,%d %c %d,%d\n",
		diff_p->file_line_number[0], diff_p->file_skiplines[0],
		mode?mode:'?',
		diff_p->file_line_number[1], diff_p->file_skiplines[1]);
	TRACE("%s", g);
	g_free(g);

        advance_buffers (diff_p, diff_p->file_line_number, diff_p->file_skiplines);
	int i; for(i = 0; i < 2; i++) {
	    diff_p->top_bufferline[i] = 
		diff_p->bottom_bufferline[i] = 
		diff_p->current_buffer_line;
	    diff_p->file_skiplines[i] = 0;
	}
        diff_p->diff_section = TRUE;
        goto done;
   } else if (strncmp(line,"---",strlen("---"))==0) {
   } else {
      switch (line[0]) {
        case '>':
            diff_p->sync_count++;
            add_different_line (diff_p, line + 2, 1);
            break;
        case '<':
            diff_p->current_buffer_line++;
            diff_p->sync_count--;
            add_different_line (diff_p, line + 2, 0);
            break;
      }
    }

done:
    g_free(line);
    return FALSE;
}

static void
operate_stdout (void *user_data, void *data, int childFD) {
 
    char *line = (char *)data;
    TRACE ("Diff: (operate_stdout) %s\n", line);
    if (!line || strlen(line)==0) {
        return;
    }
    diff_t *diff_p=user_data;
    //widgets_t *widgets_p=&(diff_p->widgets);

    void **arg = (void **)malloc(2*sizeof (void *));
    if (!arg) g_error("malloc: %s\n", strerror(errno));
    arg[0] = diff_p;
    arg[1] = g_strdup(line);
    g_main_context_invoke(NULL, diff_stdout_f, arg);
    return;
}


static gboolean
fork_finished_function_f (void *data) {
    diff_t *diff_p=data;
    if (!diff_p->left_file || !diff_p->right_file) return FALSE;
    if (!rfm_g_file_test(diff_p->left_file, G_FILE_TEST_EXISTS)){
	return FALSE;
    }
    if (!rfm_g_file_test(diff_p->right_file, G_FILE_TEST_EXISTS)){
	return FALSE;
    }
// non unified diff:
    gtk_widget_set_sensitive(diff_p->button_stop, FALSE);
	add_synchronization_lines (diff_p);

        if(diff_p->diff_subsection) {
	    add_previous_polygon (diff_p);
	    configure_event (diff_p->drawA, NULL, diff_p);
	} else {
	    diff_p->diff_subsection=TRUE;
	}
    gchar buffer[256*256];
    int i; for(i = 0; i < 2; i++) {
	while (diff_p->skip_file[i] && !feof(diff_p->skip_file[i]) && 
		fgets (buffer, 256 * 256 - 1, diff_p->skip_file[i])){
	    utf8_insert (diff_p->text_buffer[i], buffer);
	    diff_p->current_buffer_line++;   
	}
    }
// this is the same as unified diff:    
    GtkTextBuffer *text_buffer=
	gtk_text_view_get_buffer (GTK_TEXT_VIEW (diff_p->view_right));
    GtkTextIter start, end;
    gtk_text_buffer_get_bounds (text_buffer, &start, &end);
    GtkTextMark *mark = 
	gtk_text_buffer_create_mark (text_buffer, "scrollmark", &start, FALSE);
    gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (diff_p->view_right), 
	    mark, 0.2,    /*gdouble within_margin, */
            FALSE, 0.0, 0.0);
    gtk_text_buffer_delete_mark (text_buffer, mark);
    for(i = 0; i < 2; i++) {
        if(diff_p->skip_file[i]) {
            fclose (diff_p->skip_file[i]);
            diff_p->skip_file[i] = NULL;
        }
    }

    configure_event (diff_p->drawA, NULL, diff_p);

    post_diff (diff_p);
    gdk_window_set_cursor (gtk_widget_get_window(diff_p->window), NULL);
    gtk_widget_set_sensitive(diff_p->clear_button, TRUE);
    gtk_widget_set_sensitive(diff_p->button_patchmake, TRUE);
    gtk_widget_set_sensitive(diff_p->button_apply, TRUE);
    if (diff_p->tubo_pid == 0) {
	widgets_t *widgets_p=&(diff_p->widgets);
	rfm_diagnostics (widgets_p, NULL, "\n", NULL);
	rfm_diagnostics (widgets_p, "xffm/stock_dialog-warning", NULL);
	rfm_diagnostics (widgets_p, "xffm_tag/stderr", _("Operation interrupted"), NULL);
	rfm_diagnostics (widgets_p, NULL, "\n", NULL);
    }
    diff_p->diff_flags |= DIFF_IS_DONE;
    diff_p->diff_flags &= (DIFF_RUNNING^0xffffffff);
    hideshow_menus(data);
    return FALSE;
}

static void
fork_finished_function (void *data) {
    g_main_context_invoke(NULL, fork_finished_function_f, data);
}

static void
fork_function (void *data) {
    char **argument = (char **)data;

#if 0
    char **p=argument;
    for (; p && *p; p++){
	fprintf(stdout, " %s", *p);
    }
    fprintf(stdout, "\n"); fflush(stdout);
#endif
    execvp (argument[0], argument);
    fprintf(stderr, "CHILD could not execvp: this should not happen\n");
    fprintf(stderr, "Do you have %s in your path?\n", argument[0]);
    fflush (stderr);
    struct timespec thread_wait = {
        0, 100000000
    };
    nanosleep (&thread_wait, NULL);
    _exit (123);
}


static int
do_diff (diff_t *diff_p) {
    int argc = 0;
    char *arguments[64];
    int i;

    diff_p->diffC = 0; 
    if(!pre_diff (diff_p))  return FALSE;
    diff_p->addedR = diff_p->addedL = 0;
    /* prepare command line */
    arguments[argc++] = "diff";

    gchar *active_left=NULL;
    if (rfm_g_file_test(diff_p->left_file, G_FILE_TEST_IS_DIR)) {
	GtkTreeIter iter;
	
	gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_left), &iter); 
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_left), &iter,
	    PATH_COLUMN, &active_left,
	    -1);
    } else {
	active_left = g_strdup(diff_p->left_file);
    }
    gchar *active_right=NULL;
    if (rfm_g_file_test(diff_p->right_file, G_FILE_TEST_IS_DIR)) {
	GtkTreeIter iter;

	gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_right), &iter); 
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_right), &iter,
	    PATH_COLUMN, &active_right,
	    -1);
    } else {
	active_right = g_strdup(diff_p->right_file);
    }

    widgets_t *widgets_p=&(diff_p->widgets);
    const gchar *diff=" diff ";
    rfm_diagnostics(widgets_p, "rodent-diff",NULL);
    rfm_diagnostics(widgets_p, "xffm_tag/command",diff,
	    active_left, " ",
	    active_right, "\n",NULL);


    arguments[argc++] = active_left;
    arguments[argc++] = active_right;
        

    if (diff_p->diff_flags & IGNORE_CASE) arguments[argc++] = "--ignore-case";
    if (diff_p->diff_flags & IGNORE_TAB_EXPANSION) arguments[argc++] = "--ignore-tab-expansion";
    if (diff_p->diff_flags & IGNORE_SPACE_CHANGE) arguments[argc++] = "--ignore-space-change";
    if (diff_p->diff_flags & IGNORE_ALL_SPACE) arguments[argc++] = "--ignore-all-space";
    if (diff_p->diff_flags & IGNORE_BLANK_LINES) arguments[argc++] = "--ignore-blank-lines";
    if (diff_p->diff_flags & MINIMAL) arguments[argc++] = "--minimal";
    if (diff_p->diff_flags & SPEED_LARGE_FILES) arguments[argc++] = "--speed-large-files";
    if (diff_p->diff_flags & STRIP_TRAILING_CR) arguments[argc++] = "--strip-trailing-cr";
    if (diff_p->diff_flags & EXPAND_TABS) arguments[argc++] = "--expand-tabs";
    if (diff_p->diff_flags & INITIAL_TAB) arguments[argc++] = "--initial-tab";

    arguments[argc++] = (char *)0;

    diff_p->skip_file[0] = fopen (active_left, "r");
    diff_p->skip_file[1] = fopen (active_right, "r");
    
    /* execute... */
    diff_p->diff_subsection=FALSE;
    diff_p->current_buffer_line = 0;
    for(i = 0; i < 2; i++) {
        diff_p->current_line[i] = 
	    diff_p->top_bufferline[i] = 
	    diff_p->bottom_bufferline[i] = 0;
    }
    diff_p->polygon_current = NULL;
    diff_p->diff_section = FALSE;
    diff_p->diff_flags &= (DIFF_IS_DONE^0xffffffff);
    TRACE ("Diff: Tubo_threads\n");
    diff_p->diff_flags |= DIFF_RUNNING;

    static GdkCursor *watch=NULL;
    watch=gdk_cursor_new_for_display (gdk_display_get_default(),GDK_WATCH);
    gdk_window_set_cursor (gtk_widget_get_window(diff_p->window), watch);
    gtk_widget_set_sensitive(diff_p->clear_button, FALSE);
    gtk_widget_set_sensitive(diff_p->button_patchmake, FALSE);
    gtk_widget_set_sensitive(diff_p->button_previous_file, FALSE);
    gtk_widget_set_sensitive(diff_p->button_next_file, FALSE);
    gtk_widget_set_sensitive(diff_p->button_apply, FALSE);
    gtk_widget_set_sensitive(diff_p->button_stop, TRUE);
    gchar *current_dir=g_get_current_dir();
    diff_p->tubo_pid =
	Tubo_fork (fork_function, 
		  (void *)arguments, 
		  NULL,       //stdin fd
                  operate_stdout,       //stdout
                  NULL,         //stderr,
                  fork_finished_function, 
		  diff_p, 
		  TUBO_EXIT_TEXT|TUBO_VALID_ANSI|TUBO_CONTROLLER_PID);
    g_free(active_left);
    g_free(active_right);

    if (chdir(current_dir) < 0) {
	DBG("chdir %s: %s\n", current_dir, strerror(errno));
    }
    g_free(current_dir);
	   
    return TRUE;
}

#ifdef PATCHMODE
/////   unified diff functions (used for processing patch files) //////
// (currently disabled...)

static void
add_equal_line (diff_t *diff_p, char *line) {
    int i;
    diff_p->diff_subsection = FALSE;
    diff_p->current_buffer_line++;
    for(i = 0; i < 2; i++) {
        diff_p->current_line[i]++;
        diff_p->top_bufferline[i] = diff_p->bottom_bufferline[i] = diff_p->current_buffer_line;
        utf8_insert (diff_p->text_buffer[i], line);
    }
}

static int
get_block_info (diff_t *diff_p, char *line, int *file_line_number, int *file_skiplines) {
    gchar *p;
    int n1, n2, s1, s2;
    if(!line || !strlen (line)) return FALSE;
    if(line[0] != '@' || line[1] != '@') return FALSE;

    p = strtok (line + 2, ",");
    if(!p) return FALSE;
    n1 = 0 - atoi (p);
    n1--;
    p = strtok (NULL, "+");
    if(!p) return FALSE;
    s1 = atoi (p);
    p = strtok (NULL, ",");
    if(!p) return FALSE;
    n2 = atoi (p);
    n2--;
    p = strtok (NULL, "@");
    if(!p) return FALSE;
    s2 = atoi (p);
    diff_p->file_line_number[0] = n1;
    diff_p->file_line_number[1] = n2;
    diff_p->file_skiplines[0] = s1;
    diff_p->file_skiplines[1] = s2;
    /*TRACE("got_block_info: -%d,%d +%d,%d",n1,s1,n2,s2); */
    return TRUE;
}

static gboolean
stdout_unified_f (gpointer data) {
    void **arg = data;
    diff_t *diff_p=arg[0];
    char *line=arg[1];
    g_free(arg);
    widgets_t *widgets_p=&(diff_p->widgets);

    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
            if(strchr (line, '\n')) *strchr (line, '\n') = 0;
            rfm_diagnostics (widgets_p, "xffm/emblem_redball", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", strchr (line, ':') + 1, ".", NULL);
            rfm_diagnostics (widgets_p, NULL, "\n", NULL);
	    g_free(line);
	    return FALSE;
    }
// diff -u output (deprecated, but should still be available for 
// 		   patch files or non GNU diff)	    

    const gchar *tag=NULL;
    if (line[0]=='+'){
	tag="xffm_tag/green";
    } else if (line[0]=='-') {
	tag="xffm_tag/red";
    } else if (line[0]=='@') {
	tag="xffm_tag/cyan";
    } 

    rfm_diagnostics(widgets_p,tag, line, NULL);
    switch (line[0]) {
    case '@':
        if(!get_block_info (diff_p, line, diff_p->file_line_number, diff_p->file_skiplines)) {
	    rfm_diagnostics(widgets_p, "rodent-diff",  
		    "> error: get_block_info failed...", "\n", NULL);
	    g_free(line);
            return FALSE;
        } else {
	    diff_p->diffC++;
#ifdef DEBUG
	    // message for debugging purposes for now...
	   gchar *g = g_strdup_printf ("differences : -%d,%d +%d,%d",
                    diff_p->file_line_number[0], 
		    diff_p->file_skiplines[0],
                    diff_p->file_line_number[1], 
		    diff_p->file_skiplines[1]);
	    rfm_diagnostics(widgets_p, "rodent-diff",  " ", g, "\n", NULL);
            g_free (g);
#endif
        }
        advance_buffers (diff_p, diff_p->file_line_number, diff_p->file_skiplines);
        diff_p->diff_section = TRUE;
	g_free(line);
        return FALSE;
    default:
        if(!diff_p->diff_section){
	    g_free(line);
            return FALSE;
	}
        switch (line[0]) {
        case ' ':
            if(diff_p->diff_subsection) {
                add_previous_polygon (diff_p);
                add_synchronization_lines (diff_p);
                configure_event (diff_p->drawA, NULL, diff_p);
                //while (gtk_events_pending()) gtk_main_iteration();
            }
            add_equal_line (diff_p, line + 1);
            break;
        case '+':
            diff_p->sync_count++;
            add_different_line (diff_p, line + 1, 1);
            break;
        case '-':
            diff_p->current_buffer_line++;
            diff_p->sync_count--;
            add_different_line (diff_p, line + 1, 0);
            break;
        }
    }
    g_free(line);
    return FALSE;
}

static void
stdout_unified_diff (void *user_data, void *data, int childFD) {
    diff_t *diff_p=user_data;
    if (!diff_p->tubo_pid) return;
    widgets_t *widgets_p=&(diff_p->widgets);
    char *line;

    line = (char *)data;

    TRACE ("Diff: (operate_stdout) %s\n", line);
    if (!line || strlen(line)==0) return;
    void **arg = (void **)malloc(2*sizeof (void *));
    if (!arg) g_error("malloc: %s\n", strerror(errno));
    arg[0] = diff_p;
    arg[1] = g_strdup(line);
    g_main_context_invoke(NULL, stdout_unified_f, arg);
}

static gboolean
fork_finished_function_unified_diff_f (gpointer data) {
    diff_t *diff_p=data;

    GtkTextBuffer *text_buffer=
	gtk_text_view_get_buffer (GTK_TEXT_VIEW (diff_p->view_right));
    GtkTextIter start, end;
    gtk_text_buffer_get_bounds (text_buffer, &start, &end);
    GtkTextMark *mark = 
	gtk_text_buffer_create_mark (text_buffer, "scrollmark", &start, FALSE);
    gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (diff_p->view_right), 
	    mark, 0.2,    /*gdouble within_margin, */
            FALSE, 0.0, 0.0);
    gtk_text_buffer_delete_mark (text_buffer, mark);
    diff_p->diff_flags |= DIFF_IS_DONE;
    diff_p->diff_flags &= (DIFF_RUNNING^0xffffffff);
    hideshow_menus(data);
    return FALSE;
}

static void
fork_finished_function_unified_diff_f (void *data) {
    g_main_context_invoke(NULL, fork_finished_function_unified_diff_f, data);
}


#endif

//////////////////////////////
static gboolean
func_gtk_8(gpointer data){
    void **arg = data;
    diff_t *diff_p = arg[0];
    list_t *list_p = arg[1];
    gint left = GPOINTER_TO_INT(arg[2]);
    gchar *composite_id = arg[3];
    GtkListStore *list_store=
	GTK_LIST_STORE(gtk_combo_box_get_model(
		    GTK_COMBO_BOX((left)?diff_p->combo_left:diff_p->combo_right)));
    list_p->pixbuf = rfm_get_pixbuf (composite_id, SIZE_BUTTON);
    GtkTreeIter iter;
    if (gtk_tree_model_get_iter(GTK_TREE_MODEL(list_store), &iter, list_p->treepath)){
	gtk_list_store_set (list_store, &iter, 
	    PIXBUF_COLUMN, list_p->pixbuf,
	    -1);
    }
    g_object_unref(list_p->pixbuf);
    g_free(composite_id);
    g_free(arg);
    return FALSE;    
}
static gboolean
func_gtk_9(gpointer data){
    void **arg = data;
    diff_t *diff_p = arg[0];
    list_t *list_p = arg[1];
    list_t *opposite_list_p = arg[2];
    gchar *composite_id = arg[3];
    GtkListStore *list_store;
    list_store = GTK_LIST_STORE(gtk_combo_box_get_model(
		    GTK_COMBO_BOX(diff_p->combo_left)));
    list_p->pixbuf = rfm_get_pixbuf (composite_id, SIZE_BUTTON);
    GtkTreeIter iter;
    if (gtk_tree_model_get_iter(GTK_TREE_MODEL(list_store), &iter, list_p->treepath)){
	gtk_list_store_set (list_store, &iter, 
	    PIXBUF_COLUMN, list_p->pixbuf,
	    -1);
    }
    g_object_unref(list_p->pixbuf);
    list_store = GTK_LIST_STORE(gtk_combo_box_get_model(
		    GTK_COMBO_BOX(diff_p->combo_right)));
    opposite_list_p->pixbuf = rfm_get_pixbuf (composite_id, SIZE_BUTTON);
    if (gtk_tree_model_get_iter(GTK_TREE_MODEL(list_store), &iter, opposite_list_p->treepath)){
	gtk_list_store_set (list_store, &iter, 
	    PIXBUF_COLUMN, opposite_list_p->pixbuf,
	    -1);
    }
    g_object_unref(opposite_list_p->pixbuf);
    g_free(composite_id);
    g_free(arg);
    return FALSE;    
}


static void
fast_reset_icon(diff_t *diff_p, list_t *list_p, gboolean left){
	gchar *composite_id = NULL;
	if (!diff_p->hash[(left)?1:0]) {
	    TRACE( "no opposite hash for %s\n", list_p->name);
	    return;
	}
	list_t *opposite_list_p = 
	    g_hash_table_lookup(diff_p->hash[(left)?1:0], list_p->name);
	if (opposite_list_p){
	    if (opposite_list_p->size != list_p->size) {
		composite_id = 
		    g_strconcat(list_p->mimetype, "/compositeNE/emblem_redball", NULL);
		gchar *ns = g_strdup_printf("%ld != %ld", 
			(glong) list_p->size, (glong) opposite_list_p->size);
		gchar *size= g_strdup_printf(_("Size: %s"), ns);
		widgets_t *widgets_p=&(diff_p->widgets);
		rfm_threaded_diagnostics(widgets_p, composite_id, NULL);
		rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strconcat(list_p->name," (", size, ")\n", NULL));
		g_free(ns);
		g_free(size);
	        TRACE( "left/right DIFFER: %s\n", list_p->name);
	    } else {
		// Further test is necessary here...
		// (put in question mark?)
	        TRACE( "left/right further test... %s\n", list_p->name);
		composite_id = 
		    g_strconcat(list_p->mimetype, "/compositeNE/stock_dialog-question", NULL);
	    }
	} else {
	    composite_id = 
		g_strconcat(list_p->mimetype, "/compositeNE/emblem_redball", NULL);
	        TRACE( "only in %s DIFFER: %s\n", (left)?"left":"right", list_p->name);
	}
	if (composite_id) {
	    void **arg = (void *)malloc(4*sizeof(void *));
	    if (!arg) g_error("malloc: %s\n", strerror(errno));
	    arg[0] = diff_p;
	    arg[1] = list_p;
	    arg[2] = GINT_TO_POINTER(left);
	    arg[3] = g_strdup(composite_id);

	    g_main_context_invoke(NULL, func_gtk_8, arg);
	    g_free(composite_id);
	}
}

static void
not_so_fast_reset_icon(diff_t *diff_p, list_t *list_p, gboolean left){
	gchar *composite_id = NULL;
	if (!diff_p->hash[(left)?1:0]) {
	    TRACE( "no opposite hash for %s\n", list_p->name);
	    return;
	}
	list_t *opposite_list_p = 
	    g_hash_table_lookup(diff_p->hash[(left)?1:0], list_p->name);
	if (opposite_list_p){
	    if (opposite_list_p->size == list_p->size) {
		// Further test is necessary here...
		// (put in question mark?)
	        TRACE( "left/right testing %s\n", list_p->name);
		gboolean is_diff=FALSE;
		gchar *cmd=g_strdup_printf("diff -q \"%s\" \"%s\"", list_p->path, opposite_list_p->path);
		FILE *pipe = popen(cmd, "r");
		g_free(cmd);
		if (pipe){
		    gchar buf[256];
		    if (fgets(buf, 255, pipe)) is_diff=TRUE;
		    while (fgets(buf, 255, pipe) && !feof(pipe)); 
		    pclose(pipe);
		}
		if (is_diff) {
		    composite_id = 
		       g_strconcat(list_p->mimetype, "/compositeNE/emblem_redball", NULL);
		} else {
		    composite_id = 
		       g_strconcat(list_p->mimetype, "/compositeNE/emblem_greenball", NULL);
		}
		TRACE( "tested %d\n", is_diff);
	    }
	} 
	if (composite_id) {
	    void **arg = (void *)malloc(4*sizeof(void *));
	    if (!arg) g_error("malloc: %s\n", strerror(errno));
	    arg[0] = diff_p;
	    arg[1] = list_p;
	    arg[2] = opposite_list_p;
	    arg[3] = g_strdup(composite_id);
	    g_main_context_invoke(NULL, func_gtk_9, arg);
	    g_free(composite_id);
	}
}


static void *
do_quick_diff (gpointer data){
    diff_t *diff_p = data;
    gint serial = diff_p->serial;
    // Condition check, Load serial, when this changes, abort thread
    // Load serial changes whenever file or directory is loaded.
    TRACE( "Starting thread do_quick_diff: %d\n", diff_p->serial);
    //
    // for each item on left, see if present on right.
    // If not present, put in redball on left.
    // If present, do a quick diff. If equal, 
    // put in green ball on left and right

    // Do the same for right, except that md5 comparison
    // should be skipped (already done).

    // ACCESS to lists must be thread protected XXX
    GList *list;
    g_mutex_lock(diff_p->serial_mutex);
    if (diff_p->serial != serial){
	g_mutex_unlock(diff_p->serial_mutex);
	return NULL;
    }

    list = diff_p->left_list;
    for (; list && list->data; list = list->next){
	fast_reset_icon(diff_p, list->data, TRUE);
    }
    list = diff_p->right_list;
    for (; list && list->data; list = list->next){
	fast_reset_icon(diff_p, list->data, FALSE);
    }
    g_mutex_unlock(diff_p->serial_mutex);

    g_mutex_lock(diff_p->serial_mutex);
    if (diff_p->serial != serial){
	g_mutex_unlock(diff_p->serial_mutex);
	return NULL;
    }

    list = diff_p->left_list;
    for (; list && list->data; list = list->next){
	not_so_fast_reset_icon(diff_p, list->data, TRUE);
    }
    g_mutex_unlock(diff_p->serial_mutex);

    return NULL;
}
    
