#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/* */
/*  Copyright (C) 2002-2011 Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; */

// item types for shortcut_menu()
enum SHORTCUT_MENU_TYPE {
    RIGHT_MENU,
    MENUBAR,
    SUBMENU,
    EMPTY_SUBMENU,
    TOGGLE_ON,
    TOGGLE_OFF
};

static GtkWidget *
shortcut_menu (
	gint item_type,  // item type, from SHORTCUT_MENU_TYPE enum.
	GtkWidget * parent, // parent of menu item to be created
	const gchar *label, // label of menu item to be created
	gpointer func, // callback function or NULL
	gpointer data // callback function data  or NULL
	) {
    GtkWidget *menuitem;
    GtkWidget *menu;

    switch (item_type) {
      case TOGGLE_ON:
      case TOGGLE_OFF:
        menuitem = rfm_create_checkmenuitem (label, (item_type==TOGGLE_ON)?TRUE:FALSE);
        break;
      case EMPTY_SUBMENU:
        menuitem = gtk_menu_item_new ();
        break;
      case RIGHT_MENU:
        menuitem = gtk_menu_item_new_with_label (label);
        break;
      case SUBMENU:
      case MENUBAR:
      default:
        menuitem = gtk_menu_item_new_with_label (label);
        break;
    }
    gtk_menu_shell_append (GTK_MENU_SHELL (parent), menuitem);

    if(item_type != MENUBAR && item_type != RIGHT_MENU) {
        if(func && (item_type != EMPTY_SUBMENU)){
            g_signal_connect (G_OBJECT (menuitem), "activate", 
		    G_CALLBACK (func), (gpointer) data);
	}
    } else {
        menu = gtk_menu_new ();
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
	g_object_set_data(G_OBJECT(menu), "menuitem", menuitem);
        return menu;

    }
    return menuitem;
}

static void *
create_menu (gpointer data) {
    diff_t *diff_p=data;
    // initial menu bar
    GtkWidget *menubar = gtk_menu_bar_new ();
    /* Create "File" menu */
    GtkWidget *menu = shortcut_menu (MENUBAR, menubar, 
	    _("File"), NULL, NULL);
    // populate file item
    gchar *g=g_strdup_printf("%s (%s)", _("Select File"), _("Left"));
    diff_p->diffM[SELECT_LEFT_FILE] = shortcut_menu (SUBMENU, menu, 
	    g, (gpointer) cb_get_left_file, diff_p);
    g_free(g);
    g=g_strdup_printf("%s (%s)", _("Select File"), _("Right"));
    diff_p->diffM[SELECT_RIGHT_FILE] = shortcut_menu (SUBMENU, menu, 
	    g, (gpointer) cb_get_right_file, diff_p);
    g_free(g);

    g=g_strdup_printf("%s (%s)", _("Select folder"), _("Left"));
    diff_p->diffM[SELECT_LEFT_DIRECTORY] = shortcut_menu (SUBMENU, menu, 
	    g, (gpointer) cb_get_left_dir, diff_p);
    g_free(g);
    g=g_strdup_printf("%s (%s)", _("Select folder"), _("Right"));
    diff_p->diffM[SELECT_RIGHT_DIRECTORY] = shortcut_menu (SUBMENU, menu, 
	    g, (gpointer) cb_get_right_dir, diff_p);
    g_free(g);

    diff_p->diffM[CREATE_PATCH_FILE] = shortcut_menu (SUBMENU, menu, 
	    _("Create Patch"), 
	    (gpointer) cb_patchmake, diff_p);
    
    diff_p->diffM[SHOW_DIFFERENCES] = shortcut_menu (SUBMENU, menu, 
	    _("Show Differences"), 
	    (gpointer) cb_do_patch, diff_p);


    shortcut_menu (EMPTY_SUBMENU, menu, NULL, NULL, NULL);
    shortcut_menu (SUBMENU, menu, 
	    _("Exit"), (gpointer) delete_event, NULL);

    /* Create "Settings" menu */
    menu = shortcut_menu (MENUBAR, menubar, 
	    _("Diff Settings"), NULL, NULL);
    diff_p->diffM[DIFF_SETTINGS] = g_object_get_data(G_OBJECT(menu), "menuitem");
/*
  --strip-trailing-cr  Strip trailing carriage return on input.
  -t  --expand-tabs  Expand tabs to spaces in output.
  -T  --initial-tab  Make tabs line up by prepending a tab.
  --tabsize=NUM  Tab stops are every NUM (default 8) print columns.
  -I RE  --ignore-matching-lines=RE  Ignore changes whose lines all match RE.


*/
#if 0
    // I never use this, so now it is unmaintained...
    shortcut_menu (SUBMENU, menu, 
	    _("Highlight text color"), 
	    (gpointer) cb_select_fgcolor, diff_p);
    shortcut_menu (SUBMENU, menu, 
	    _("Highlight background color"), 
	    (gpointer) cb_select_bgcolor, diff_p);
    
     
    shortcut_menu ((diff_p->diff_flags & FILLEDP)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("Fill transparent areas"), 
	    (gpointer) cb_toggle_filledP, diff_p);

    shortcut_menu ((diff_p->diff_flags & SHOW_LINEN)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("Show line numbers"), 
	    (gpointer) cb_toggle_show_lineN, diff_p);

    shortcut_menu (EMPTY_SUBMENU, menu, NULL, NULL, NULL);
#endif

    shortcut_menu ((diff_p->diff_flags & IGNORE_CASE)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-i  --ignore-case  Ignore case differences in file contents."), 
	    (gpointer) cb_toggle_ignore_case, diff_p);

    shortcut_menu ((diff_p->diff_flags & IGNORE_TAB_EXPANSION)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-E  --ignore-tab-expansion  Ignore changes due to tab expansion."), 
	    (gpointer) cb_toggle_ignore_tab_expansion, diff_p);

    shortcut_menu ((diff_p->diff_flags & IGNORE_SPACE_CHANGE)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-b  --ignore-space-change  Ignore changes in the amount of white space."), 
	    (gpointer) cb_toggle_ignore_space_change, diff_p);

    shortcut_menu ((diff_p->diff_flags & IGNORE_ALL_SPACE)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-w  --ignore-all-space  Ignore all white space."), 
	    (gpointer) cb_toggle_ignore_all_space, diff_p);

    shortcut_menu ((diff_p->diff_flags & IGNORE_BLANK_LINES)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-B  --ignore-blank-lines  Ignore changes whose lines are all blank."), 
	    (gpointer) cb_toggle_ignore_blank_lines, diff_p);

/*// this item requires an entry box for input of the regular expression
    shortcut_menu ((diff_p->diff_flags & IGNORE_MATCHING_LINES)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-I RE  --ignore-matching-lines=RE  Ignore changes whose lines all match RE."), 
	    (gpointer) cb_toggle_, diff_p);*/

    shortcut_menu ((diff_p->diff_flags & MINIMAL)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-d  --minimal  Try hard to find a smaller set of changes."), 
	    (gpointer) cb_toggle_minimal, diff_p);

    shortcut_menu ((diff_p->diff_flags & SPEED_LARGE_FILES)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("--speed-large-files  Assume large files and many scattered small changes."), 
	    (gpointer) cb_toggle_speed_large_files, diff_p);

    shortcut_menu ((diff_p->diff_flags & STRIP_TRAILING_CR)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("--strip-trailing-cr  Strip trailing carriage return on input."), 
	    (gpointer) cb_toggle_strip_trailing_cr, diff_p);

    shortcut_menu ((diff_p->diff_flags & EXPAND_TABS)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-t  --expand-tabs  Expand tabs to spaces in output."), 
	    (gpointer) cb_toggle_expand_tabs, diff_p);

    shortcut_menu ((diff_p->diff_flags & INITIAL_TAB)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _("-T  --initial-tab  Make tabs line up by prepending a tab."), 
	    (gpointer) cb_toggle_initial_tab, diff_p);

    /*
     // this item requires a spinbox set to the default 8 for changing the tabsize
    shortcut_menu ((diff_p->diff_flags & TABSIZE)?
	    TOGGLE_ON:TOGGLE_OFF, menu, 
	    _(), 
	    (gpointer) cb_toggle_tabsize, diff_p);*/


    /* Create "Help" menu */
    menu = shortcut_menu (MENUBAR, menubar, 
	    _("Help"), 
	    NULL, NULL);
    shortcut_menu (SUBMENU, menu, 
	    _("About"), 
	    (gpointer) cb_about, diff_p);


    return menubar;
}

static gint 
compare_func (GtkTreeModel *model, GtkTreeIter *a_iter, GtkTreeIter *b_iter, gpointer user_data){
    gchar *a;
    gchar *b;
    gtk_tree_model_get (GTK_TREE_MODEL(model), a_iter,
	    BASENAME_COLUMN, &a,
	    -1);
    gtk_tree_model_get (GTK_TREE_MODEL(model), b_iter,
	    BASENAME_COLUMN, &b,
	    -1);
    gint retval=strcmp(a, b);
    g_free(a);
    g_free(b);
    return retval;
}

// combo box creator function
static void
create_combo_box(GtkWidget **combo, GtkListStore **list_store){
    *list_store=gtk_list_store_new (COMBO_COLUMNS,
	    G_TYPE_POINTER,
	    GDK_TYPE_PIXBUF, 
	    G_TYPE_STRING, 
	    G_TYPE_STRING, 
	    G_TYPE_STRING);
    gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE(*list_store),
                                                 BASENAME_COLUMN,GTK_SORT_ASCENDING);
    gtk_tree_sortable_set_sort_func     (GTK_TREE_SORTABLE(*list_store),
                                          BASENAME_COLUMN,
                                          compare_func,
                                          NULL, NULL);
    *combo = 
	gtk_combo_box_new_with_model(GTK_TREE_MODEL(*list_store));
    // Create pixbuf cell renderer 
    GtkCellRenderer *cell;

    cell = gtk_cell_renderer_pixbuf_new();
    // Add cell renderer to combo box 
    gtk_cell_layout_pack_start( GTK_CELL_LAYOUT(*combo), cell, FALSE );
    // Connect cell renderer with data from store 
    gtk_cell_layout_set_attributes( GTK_CELL_LAYOUT(*combo), cell,
            "pixbuf", PIXBUF_COLUMN, NULL ); 

    // Create text cell renderer 
    cell = gtk_cell_renderer_text_new();
    // Add cell renderer to combo box 
    gtk_cell_layout_pack_start( GTK_CELL_LAYOUT(*combo), cell, FALSE );
    // Connect cell renderer with data from store 
    gtk_cell_layout_set_attributes( GTK_CELL_LAYOUT(*combo), cell,
            "text", BASENAME_COLUMN, NULL ); 
    // Create text cell renderer 
    cell = gtk_cell_renderer_text_new();
#if 0
    // This column is not very useful if you cannot compare at the
    // same time with the analogous information on the opposite side.
    // Add cell renderer to combo box 
    gtk_cell_layout_pack_end( GTK_CELL_LAYOUT(*combo), cell, FALSE );
    // Connect cell renderer with data from store 
    gtk_cell_layout_set_attributes( GTK_CELL_LAYOUT(*combo), cell,
            "text", DATE_COLUMN, NULL ); 
#endif
}

// convenience function to make buttons
static GtkWidget *
make_button (const gchar *icon_id, const gchar *text, const gchar *tooltip_text) {
    GtkWidget *button = rfm_dialog_button(icon_id, text);
    GdkPixbuf *tooltip_pixbuf = NULL;
    if (icon_id){
	tooltip_pixbuf = rfm_get_pixbuf(icon_id, SIZE_DIALOG);
    }
    if (tooltip_text) rfm_add_custom_tooltip(button, tooltip_pixbuf, tooltip_text);

    return button;
}

static void *
make_all_buttons(gpointer data){
    diff_t *diff_p=data;
    
    // create file select buttons
    diff_p->label_button_left = 
	make_button(NULL, NULL, NULL);
    diff_p->label_button_right = 
	make_button(NULL, NULL, NULL);

    // create directory/file toggle buttons to define behaviour
    // of file select buttons
    // left
    diff_p->left_select_dir_button = make_button("xffm/stock_directory", NULL, NULL);

    // right
    diff_p->right_select_dir_button = make_button("xffm/stock_directory", NULL, NULL); 

    diff_p->button_stop = 
	make_button("xffm/emblem_cancel", _("Stop"), _("Stop Parser"));
    gtk_widget_set_sensitive(diff_p->button_stop, FALSE);

    diff_p->button_apply = 
	make_button("xffm/stock_ok", _("Show Differences"), _("Compare Files..."));
    
    diff_p->button_patchmake = 
	make_button("xffm/stock_index", _("Create Patch"), _("Create Patch"));

    diff_p->exit_button = 
	make_button("xffm/stock_close", _("Close"), _("Close"));
    diff_p->clear_button =
	make_button("xffm/stock_clear", _("Clear"), _("Clear"));
    diff_p->button_down = 
	make_button("xffm/stock_go-down", NULL, _("Next Difference"));
    diff_p->button_up = 
	make_button("xffm/stock_go-up", NULL, _("Previous Difference"));
    diff_p->button_next_file = 
	make_button("xffm/stock_go-last", NULL, _("Next File"));
    diff_p->button_previous_file = 
	make_button("xffm/stock_go-first", NULL, _("Previous File"));

    g_signal_connect (G_OBJECT (diff_p->label_button_left), "clicked", 
	    G_CALLBACK (cb_get_left_file), diff_p);
    g_signal_connect (G_OBJECT (diff_p->label_button_right), "clicked", 
	    G_CALLBACK (cb_get_right_file), diff_p);

    g_signal_connect (G_OBJECT (diff_p->left_select_dir_button), "clicked", 
	    G_CALLBACK (cb_get_left_dir), diff_p);
    g_signal_connect (G_OBJECT (diff_p->right_select_dir_button), "clicked", 
	    G_CALLBACK (cb_get_right_dir), diff_p);
    gchar *gg=g_strdup_printf("%s (%s)", _("Select folder"), _("Left"));
    gtk_widget_set_tooltip_text (diff_p->left_select_dir_button, gg);
    g_free(gg);
    gg=g_strdup_printf("%s (%s)", _("Select folder"), _("Right"));
    gtk_widget_set_tooltip_text (diff_p->right_select_dir_button, gg);
    g_free(gg);



    g_signal_connect (G_OBJECT (diff_p->combo_left), "changed", 
	    G_CALLBACK (cb_changed_left), diff_p);
    g_signal_connect (G_OBJECT (diff_p->combo_right), "changed", 
	    G_CALLBACK (cb_changed_right), diff_p);




    g_signal_connect (G_OBJECT (diff_p->button_stop), "clicked", 
	    G_CALLBACK (cb_stop), diff_p);
    g_signal_connect (G_OBJECT (diff_p->button_apply), "clicked", 
	    G_CALLBACK (cb_do_patch), diff_p);
    g_signal_connect (G_OBJECT (diff_p->button_patchmake), "clicked", 
	    G_CALLBACK (cb_patchmake), diff_p);
    g_signal_connect (G_OBJECT (diff_p->exit_button), "clicked", 
	    G_CALLBACK (delete_event), diff_p);
    g_signal_connect (G_OBJECT (diff_p->clear_button), "clicked", 
	    G_CALLBACK (on_clear_show_diag),diff_p);
    g_signal_connect (G_OBJECT (diff_p->button_down), "clicked",
	    G_CALLBACK (cb_next_diff), diff_p);
    g_signal_connect (G_OBJECT (diff_p->button_up), "clicked", 
	    G_CALLBACK (cb_previous_diff), diff_p);

    g_signal_connect (G_OBJECT (diff_p->button_next_file), "clicked", 
	    G_CALLBACK (cb_next_file), diff_p);
    g_signal_connect (G_OBJECT (diff_p->button_previous_file), "clicked", 
	    G_CALLBACK (cb_previous_file), diff_p);

    return NULL;
}

	
static void *
create_diff_window (void *data) {
    diff_t *diff_p=data;
    rfm_mutex_init(diff_p->serial_mutex);
    diff_p->serial = 1;       

    // create main widgets and boxes
    //
    diff_p->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    // create main vertical box
    GtkWidget *main_vbox = rfm_vbox_new (FALSE, 0);
    // create menu box
    GtkWidget *menubox = rfm_hbox_new (FALSE, 0);
    // create vertical pane view
    GtkWidget *vpane = rfm_vpaned_new ();
    g_object_set_data(G_OBJECT(diff_p->window), "vpane", vpane);
    // hack:
    diff_p->widgets.paper = diff_p->window;
    
    // create pane boxes
    GtkWidget *top_pane_hbox = rfm_hbox_new (FALSE, 0);
    GtkWidget *bottom_pane_box = rfm_hbox_new (TRUE, 0);
    // create top pane text view boxes
    GtkWidget *top_vbox = rfm_vbox_new (FALSE, 0);
    diff_p->label_box=rfm_hbox_new (TRUE, 0);
    GtkWidget *box_left=rfm_hbox_new (FALSE, 0);
    GtkWidget *box_center=rfm_hbox_new (FALSE, 0);
    GtkWidget *box_right=rfm_hbox_new (FALSE, 0);
    diff_p->combo_box = rfm_hbox_new (TRUE, 0);
    create_combo_box(&(diff_p->combo_left), &(diff_p->list_store_left));
    GtkWidget *combo_box_center=rfm_hbox_new (FALSE, 0);
    create_combo_box(&(diff_p->combo_right), &(diff_p->list_store_right));

    GtkWidget *folder_box = rfm_hbox_new (TRUE, 0);
    GtkWidget *folder_box_right = rfm_hbox_new (FALSE, 0);
    GtkWidget *folder_box_left = rfm_hbox_new (FALSE, 0);
    diff_p->folder_label_right = gtk_label_new("");
    diff_p->folder_label_left = gtk_label_new("");
    gtk_box_pack_end (GTK_BOX (folder_box_right), diff_p->folder_label_right, 
	    TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (folder_box_left), diff_p->folder_label_left, 
	    TRUE, FALSE, 0);
    

        
    //this is the good place to figure out line height and width characteristics
    PangoLayout *layout = gtk_widget_create_pango_layout (diff_p->combo_left, "W");
    PangoRectangle logical_rect;
    pango_layout_get_pixel_extents (layout, NULL, &logical_rect);
    diff_p->lineH = logical_rect.height;
    diff_p->lineW = 3 * logical_rect.width / 4;
    g_object_unref (layout);


    // create top pane text view boxes
    GtkWidget *top_hbox = rfm_vbox_new (FALSE, 0);
    diff_p->adj = GTK_ADJUSTMENT(gtk_adjustment_new (0, 0, 0, 0, 0, 0));
    diff_p->adjR = GTK_ADJUSTMENT(gtk_adjustment_new (0, 0, 0, 0, 0, 0));
    GtkWidget *text_box = rfm_hbox_new (FALSE, 0);
    // left scrolled window
    GtkWidget *scrolled_window_left = 
	gtk_scrolled_window_new (NULL, GTK_ADJUSTMENT (diff_p->adj));
    diff_p->view_left = gtk_text_view_new ();
    diff_p->text_buffer[0] = 
	gtk_text_view_get_buffer (GTK_TEXT_VIEW (diff_p->view_left));
    // right scrolled window
    GtkWidget *scrolled_window_right = 
	gtk_scrolled_window_new (NULL, GTK_ADJUSTMENT (diff_p->adjR));
    diff_p->view_right = gtk_text_view_new ();
    diff_p->text_buffer[1] = 
	gtk_text_view_get_buffer (GTK_TEXT_VIEW (diff_p->view_right));
    // center drawing area
    diff_p->drawA = gtk_drawing_area_new ();
    gtk_widget_add_events (diff_p->drawA, GDK_BUTTON_PRESS_MASK);
    
    // diagnostics output
    GtkWidget *diagnostics_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    diff_p->view_diag = gtk_text_view_new ();
    (diff_p->widgets.diagnostics) = diff_p->view_diag;
    gint size = 8;

#if GTK_MAJOR_VERSION==2
    PangoFontDescription *desc = pango_font_description_new ();
    pango_font_description_set_family (desc, "monospace");
    pango_font_description_set_size (desc, size * PANGO_SCALE);
    gtk_widget_modify_font ((diff_p->widgets.diagnostics), desc);
    pango_font_description_free (desc); 
#else
    GtkStyleContext *style_context = gtk_widget_get_style_context (diff_p->widgets.diagnostics);
    gtk_style_context_add_class(style_context, GTK_STYLE_CLASS_VIEW );
    GtkCssProvider *css_provider = gtk_css_provider_new();
    GError *error=NULL;
    gchar *dat = g_strdup_printf("* {\
font-family: %s;\
font-size: %dpx;\
}", "monospace", size);
    gtk_css_provider_load_from_data (css_provider, dat, -1, &error);
    if (error){
        fprintf(stderr, "gerror: %s\n", error->message);
        g_error_free(error);
    }
    gtk_style_context_add_provider (style_context, GTK_STYLE_PROVIDER(css_provider),
                            GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
    g_free(dat);
//	gtk_widget_override_font ((diff_p->widgets.diagnostics), desc);
#endif


    // last box on bottom 
    GtkWidget *button_box = rfm_hbox_new (FALSE, 2);


    gtk_container_add (GTK_CONTAINER (diff_p->window), main_vbox);
    gtk_box_pack_start (GTK_BOX (main_vbox), menubox, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (menubox), 0);


    // create folder box
    gtk_box_pack_start (GTK_BOX (main_vbox), folder_box, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (folder_box), folder_box_left, TRUE, FALSE, 0);
    //gtk_box_pack_start (GTK_BOX (folder_box), folder_box_center, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (folder_box), folder_box_right, TRUE, FALSE, 0);
    // create label box
    //gtk_box_pack_start (GTK_BOX (main_vbox), diff_p->label_box, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (diff_p->label_box), box_left, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (diff_p->label_box), box_center, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (diff_p->label_box), box_right, TRUE, TRUE, 0);

    // create combo box
    gtk_box_pack_start (GTK_BOX (main_vbox), diff_p->combo_box, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (diff_p->combo_box), diff_p->combo_left, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (diff_p->combo_box), combo_box_center, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (diff_p->combo_box), diff_p->combo_right, TRUE, TRUE, 0);

    g_object_set_data (G_OBJECT (diff_p->window), "pane_view", vpane);
    gtk_box_pack_start (GTK_BOX (main_vbox), vpane, TRUE, TRUE, 0);

    gtk_paned_pack1 (GTK_PANED (vpane), top_pane_hbox, TRUE, TRUE);
    gtk_paned_pack2 (GTK_PANED (vpane), bottom_pane_box, TRUE, TRUE);

    /* text boxes : */
    //gtk_box_pack_start (GTK_BOX (top_pane_hbox), top_hbox, TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (top_pane_hbox), top_vbox, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (top_vbox), top_hbox, TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (top_hbox), text_box, TRUE, TRUE, 0);


    // divide top pane box
    //



    gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (scrolled_window_left), GTK_CORNER_TOP_RIGHT);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_left), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    // left text view
    gtk_text_view_set_cursor_visible ((GtkTextView *) diff_p->view_left, FALSE);
    gtk_text_view_set_editable ((GtkTextView *) diff_p->view_left, FALSE);
    gtk_text_view_set_wrap_mode ((GtkTextView *) diff_p->view_left, GTK_WRAP_NONE);
    gtk_widget_set_size_request (diff_p->view_left, diff_p->sizeL * diff_p->lineW, diff_p->sizeH * diff_p->lineH);
    gtk_container_add (GTK_CONTAINER (scrolled_window_left), diff_p->view_left);

    gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (scrolled_window_right), GTK_CORNER_TOP_LEFT);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_right), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_text_view_set_cursor_visible ((GtkTextView *) diff_p->view_right, FALSE);
    gtk_text_view_set_editable ((GtkTextView *) diff_p->view_right, FALSE);
    gtk_text_view_set_wrap_mode ((GtkTextView *) diff_p->view_right, GTK_WRAP_NONE);
    gtk_widget_set_size_request (diff_p->view_right, diff_p->sizeL * diff_p->lineW, diff_p->sizeH * diff_p->lineH);
    gtk_container_add (GTK_CONTAINER (scrolled_window_right), diff_p->view_right);

    gtk_box_pack_start (GTK_BOX (text_box), scrolled_window_left, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (text_box), diff_p->drawA, FALSE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (text_box), scrolled_window_right, TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (bottom_pane_box), diagnostics_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (diagnostics_scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	
    gtk_text_view_set_cursor_visible ((GtkTextView *) diff_p->view_diag, FALSE);
    gtk_text_view_set_editable ((GtkTextView *) diff_p->view_diag, FALSE);
    gtk_text_view_set_wrap_mode ((GtkTextView *) diff_p->view_diag, GTK_WRAP_NONE);
    gtk_container_add (GTK_CONTAINER (diagnostics_scrolled_window), diff_p->view_diag);




    gtk_drag_dest_set (diff_p->view_left, GTK_DEST_DEFAULT_ALL, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
    gtk_drag_dest_set (diff_p->view_right, GTK_DEST_DEFAULT_ALL, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    
    g_signal_connect (G_OBJECT (diff_p->view_left), "drag_motion", 
	    G_CALLBACK (on_drag_motion), NULL);
    g_signal_connect (G_OBJECT (diff_p->view_right), "drag_motion",
	    G_CALLBACK (on_drag_motion), NULL);
    g_signal_connect (G_OBJECT (diff_p->view_left), "drag_data_received", 
	    G_CALLBACK (on_drag_data_received), (gpointer) diff_p);
    g_signal_connect (G_OBJECT (diff_p->view_right), "drag_data_received", 
	    G_CALLBACK (on_drag_data_received), (gpointer) diff_p);
    g_signal_connect (G_OBJECT (diff_p->drawA), "configure_event", 
	    G_CALLBACK (configure_event), (gpointer) diff_p);

    g_signal_connect (G_OBJECT (diff_p->adj), 
	    "value_changed", G_CALLBACK (cb_adjust), (gpointer)diff_p);
    g_signal_connect (G_OBJECT (diff_p->adjR), 
	    "value_changed", G_CALLBACK (cb_adjustR), (gpointer)diff_p);
    g_signal_connect (G_OBJECT (diff_p->drawA), "scroll_event", 
	    G_CALLBACK (cb_wheel), (gpointer) diff_p);

#if GTK_MAJOR_VERSION==2
    g_signal_connect (G_OBJECT (diff_p->drawA), 
	    "expose_event", G_CALLBACK (expose_event), (gpointer) diff_p);
#else
    g_signal_connect (G_OBJECT (diff_p->drawA), 
	    "draw", G_CALLBACK (draw_event), (gpointer) diff_p);
#endif
    
    g_signal_connect (G_OBJECT (diff_p->window), "delete_event",
	    G_CALLBACK (delete_event), (gpointer) diff_p);
    g_signal_connect (G_OBJECT (diff_p->window), "destroy", 
	    G_CALLBACK (delete_event), (gpointer) diff_p);
    g_signal_connect (G_OBJECT (diff_p->window), "destroy_event", 
	    G_CALLBACK (delete_event), (gpointer) diff_p);


    
 
    // populate menu 
    GtkWidget *menubar = create_menu((void *)diff_p);
    gtk_container_add (GTK_CONTAINER (menubox), menubar);

    // make all buttons 
    make_all_buttons((void *) diff_p);
 
    gtk_box_pack_start (GTK_BOX (box_left), diff_p->left_select_dir_button, 
	    FALSE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (box_left), diff_p->label_button_left, 
	    TRUE, TRUE, 0);
    gtk_box_pack_end (GTK_BOX (box_right), diff_p->right_select_dir_button, 
	    FALSE, TRUE, 0);
    gtk_box_pack_end (GTK_BOX (box_right), diff_p->label_button_right, 
	    TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (main_vbox), button_box, 
	    FALSE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (button_box), diff_p->exit_button, 
	    TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (button_box), diff_p->clear_button, 
	    TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (combo_box_center), diff_p->button_previous_file, 
	    TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (combo_box_center), diff_p->button_up, 
	    TRUE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (combo_box_center), diff_p->button_next_file,
	    TRUE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (combo_box_center), diff_p->button_down, 
	    TRUE, FALSE, 0);
        
    gtk_box_pack_start (GTK_BOX (button_box), diff_p->button_patchmake, 
	    TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (button_box), diff_p->button_apply, 
	    TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (button_box), diff_p->button_stop, 
	    TRUE, FALSE, 0);
    
    

    gtk_widget_set_size_request (diff_p->drawA, 75, diff_p->sizeH * diff_p->lineH);

    gtk_widget_set_size_request (diff_p->window, -1, 2 *(diff_p->sizeH * diff_p->lineH));
    gtk_window_set_icon (
	    GTK_WINDOW (diff_p->window), get_application_pixbuf(48));
    gtk_window_set_position (GTK_WINDOW (diff_p->window), GTK_WIN_POS_MOUSE);
    gtk_window_set_title (GTK_WINDOW (diff_p->window), "Rodent-diff");
    gtk_widget_show_all (diff_p->window);


    return NULL;
}
