/**********************************************************************/
/* Copyright Edscott Wilson Garcia 2005-2011 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

#define RFM_DESKVIEW_C

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent.h"
#include "deskview.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE 

static view_t *deskview_pointer;

GtkWidget *create_desktop ( void);

/* static code */

#include "deskview_desktop.i"
#include "deskview_callbacks.i"
#include "deskview_main.i"

/* exportable symbols: */

G_MODULE_EXPORT GtkWidget *
create_desktop ( void) {
    rfm_global_t *rfm_global_p = rfm_global();
    rfm_global_p->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    view_t *view_p;
    int i;

    //gboolean rodent_root=FALSE;

    for(i = 0; i < rfm_global_p->argc; i++) {
        if(strcmp ("--id", rfm_global_p->argv[i]) == 0 || strcmp ("-id", rfm_global_p->argv[i]) == 0) {
            if(!rodent_running ())
                DBG ("%s not running\n", rfm_global_p->argv[0]);
            exit (0);
        }
    }

    rfm_global_p->thread_queue = rfm_thread_queue_new(rodent_queue_f, NULL, 1);
    desktop_main ();
    gchar *deskdir = NULL;
    record_entry_t *en = NULL;

    deskview_pointer = view_p = create_deskview ();
    const gchar *deskimage = getenv ("RFM_DESKTOP_IMAGE");

    if(deskimage && g_file_test(deskimage, G_FILE_TEST_EXISTS)){
	recreate_bg_surface(view_p, deskimage);
    }


    view_p->module = NULL;
    if (getenv ("RFM_DESKTOP_DIR")) {
        deskdir = g_strdup (getenv ("RFM_DESKTOP_DIR"));
    }
    else {
	// No desktop dir defined (not ""). Do the default directory.
	// (rodent root)
    } 
    if (!deskdir){
	// Deskdir is set to "", which means the Rodent root.
	// This is Ok.
	// rodent_root=TRUE;
	//goto default_deskdir;
    } else if (strncmp("module:", deskdir, strlen("module:"))!=0){ 
	// Normal directory specified by user configuration.
	if (!rfm_g_file_test(deskdir, G_FILE_TEST_IS_DIR)){
	    DBG("%s does not exist\n", deskdir);
	    g_free(deskdir);
   // default_deskdir:
	    TRACE("No desktop dir defined. Do the default directory.\n");
	    deskdir = g_build_filename (DEFAULT_DESKTOP_DIR, NULL);
	    if (!rfm_g_file_test(deskdir, G_FILE_TEST_IS_DIR)){
		NOOP("Creating desktop dir: %s",deskdir);
		g_mkdir_with_parents (deskdir, 0700);
		if (!rfm_g_file_test(deskdir, G_FILE_TEST_IS_DIR)){
		    g_error ("Desktop directory does not exist: %s", deskdir);
		}
	    }
	    if ((en = rfm_stat_entry (deskdir, 0))==NULL){
		g_error ("deskview.c: Cannot create entry for %s deskdir", deskdir);
	    }
	    //goto default_deskdir;
	}
	if ((en = rfm_stat_entry (deskdir, 0))==NULL){
	    g_error ("deskview.c: Cannot create entry for %s deskdir", deskdir);
	}
    } else { // "module:" means a module is defined as the desktop directory
	gchar *module_name=deskdir+strlen("module:");
	en = rfm_mk_entry(0);
	en->module=g_strdup(module_name);
	en->path=rfm_void(PLUGIN_DIR, module_name, "module_label");
    }
    g_free(view_p->desktop_dir);
    view_p->desktop_dir=deskdir;
    view_p->en = en;
    rodent_create_popup_bythread();
    
    rfm_add_view(view_p);
    
    if(getenv ("RFM_NAVIGATE_DESKTOP")
       && strlen (getenv ("RFM_NAVIGATE_DESKTOP"))) {
        view_p->child_constructor = NULL;
    } else {
        view_p->child_constructor = child_constructor;
    }
    
    view_preferences_t *view_preferences_p = rfm_get_view_preferences (DESKVIEW_TYPE, view_p->en);
    rfm_set_view_preferences (view_p, view_preferences_p);
    g_free(view_preferences_p);
    
    rfm_layout_set_vpane_allocation(view_p);
    rfm_layout_configure(view_p, MAX_ELEMENTS(view_p));    


#if 0  
    // FIXME: set environment variables before calling first refresh
    TRACE( "create_desktop calling rodent_full_reload_view\n");
    if (!rodent_refresh(&(view_p->widgets), en)){
	rodent_refresh(&(view_p->widgets), NULL);
    }
#endif	
    //rodent_full_reload_view ((gpointer) view_p, en);
    //if (rodent_root) rodent_refresh(&(view_p->widgets), NULL);


    // This will reload on certain environment changes, 
    // environment should be fully defined before this
    // timeout is added.
    g_timeout_add_seconds (1, watch_root, view_p);


    return rfm_global_p->window;
}

