#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
// cifs submodule option dialog window y anexas.
/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */


gchar*
accept (fuse_data_t *fuse_data_p, const gchar *url){
    // url is the keyfile group
    fuse_data_p->url = url;
    if (!FUSE_get_login_info (fuse_data_p)) {
	return NULL;
    }

    // FLAG_0 is done.

    // FLAG_1: fuse options.    
    // FLAG_2: module options
    // FLAG_3:
    // FLAG_4: ftp options (submodule specific)
    // FLAG_5: curlftpfs options (submodule specific)
    //
    // FLAG_6: mount options 
    fuse_data_p->flag_id = 6;
    fuse_data_p->options_p = mount_options;
    fuse_data_p->options_keys_p = &mount_option_keys;
    FUSE_set_options(fuse_data_p);   
    // FLAG_7: nfs options 
    // FLAG_8: nfs v23 options 
     // FLAG_9: nfs v4 options 
      // FLAG_10: cifs options 
    fuse_data_p->flag_id = 10;
    fuse_data_p->options_p = cifs_options;
    fuse_data_p->options_keys_p = &cifs_option_keys;
    FUSE_set_options(fuse_data_p);
   
    return FUSE_save_keyfile(fuse_data_p);
}



static
fuse_data_t *
confirm_cifs_host_dialog (const gchar *url) {
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    fuse_data_t *fuse_data_p = (fuse_data_t *)FUSE_data_new(NULL);
    if (!fuse_data_p) g_error("cannot allocate fuse_data_p\n");

    fuse_data_p->widgets_p = widgets_p;
    fuse_data_p->url = url;
    fuse_data_p->info1 = CIFS_INFO1;
    fuse_data_p->info2 = CIFS_INFO2;

    fuse_data_p->dialog = FUSE_init_dialog(fuse_data_p);

    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "fuse_data_p", fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "url_template", "cifs");

    GtkWidget *hbox;

    fuse_data_p->item_string = FUSE_COMPUTER;
    fuse_data_p->item_id = "FUSE_COMPUTER";
    FUSE_add_entry(fuse_data_p);

    fuse_data_p->item_string = FUSE_REMOTE_PATH;
    fuse_data_p->item_id = "FUSE_REMOTE_PATH";
    FUSE_add_entry(fuse_data_p);

    fuse_data_p->item_string = FUSE_LOGIN;
    fuse_data_p->item_id = "FUSE_LOGIN";
    FUSE_add_entry(fuse_data_p);

    fuse_data_p->item_string = FUSE_MOUNT_POINT;
    fuse_data_p->item_id = "FUSE_MOUNT_POINT";
    hbox =
	FUSE_add_entry(fuse_data_p);
    if (rfm_void(PLUGIN_DIR, "fstab", "module_active")) {
	gtk_widget_set_sensitive(hbox, FALSE);
    }


    fuse_data_p->item_string = FUSE_URL;
    fuse_data_p->item_id = "FUSE_URL";
    FUSE_add_entry(fuse_data_p);
    GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FUSE_URL");

    const gchar *url_template = g_object_get_data(G_OBJECT(fuse_data_p->dialog),"url_template");
    gchar *u =g_strconcat(url_template, "://", NULL);
    gtk_entry_set_text(GTK_ENTRY(entry), u);
    g_free(u);

    gtk_widget_set_sensitive(entry, FALSE);


    
    fuse_data_p->extra_text = FUSE_CAUTION;
    fuse_data_p->item_string = FUSE_MONITOR;
    fuse_data_p->item_id = "FUSE_MONITOR";
    FUSE_add_check(fuse_data_p);

    fuse_data_p->item_string = FUSE_BROADBAND;
    fuse_data_p->item_id = "FUSE_BROADBAND";
    FUSE_add_check(fuse_data_p);

    fuse_data_p->label = _("Mount");
    fuse_data_p->options_p = mount_options;
    fuse_data_p->flag_id = 6;
    FUSE_add_option_page(fuse_data_p);

    fuse_data_p->label = _("CIFS");
    fuse_data_p->options_p = cifs_options;
    fuse_data_p->flag_id = 10;
    FUSE_add_option_page(fuse_data_p);
 
    FUSE_reset_url_field(fuse_data_p);
                                                     
    return fuse_data_p;
}

#if 0

static gboolean
confirm_cifs_host (const gchar *url) {
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    GCond *signal = fuse_hold_monitor();
    fuse_data_t *fuse_data_p = confirm_cifs_host_dialog (url);
    if(!fuse_data_p || !fuse_data_p->dialog){
        return FALSE;
    }
    gint response;
    gboolean retval;
retry:
    response = rfm_dialog_run_response(fuse_data_p->dialog);
    gtk_widget_hide (fuse_data_p->dialog);

    if(response == GTK_RESPONSE_YES || response == GTK_RESPONSE_APPLY){
	gchar *new_url = accept(fuse_data_p, url);
	if (!new_url) {
	    gtk_widget_show (fuse_data_p->dialog);
	    goto retry;
	}
	if(response == GTK_RESPONSE_YES) {
	    mount_url(new_url);
	}
	gtk_widget_destroy (fuse_data_p->dialog);
	view_t *view_p = widgets_p->view_p;
	record_entry_t *t_en = rfm_copy_entry(view_p->en);
	if(!rodent_refresh (widgets_p, t_en)) {
	    rfm_destroy_entry(t_en);
	}
	g_free(new_url);
        retval = TRUE;
    } else {
	gtk_widget_destroy (fuse_data_p->dialog);
        retval = FALSE;
    }
    g_cond_signal(signal);
    return retval;
}
#endif
//////////////////////////////////////////////////////////////////////////////////

