/*
 * Edscott Wilson Garcia Copyright 2011
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent.h"
#include "fuse-group_options.h"
#define FLAG_KEY(x)  g_strdup_printf("FLAG_%d", x)


gchar *
fuse_get_option_id(gchar **argv){
    gchar **p;
    gchar *id=g_strdup("");
    for (p=argv; p && *p; p++){
	gchar *q=id;
	id = g_strconcat(q, *p, NULL);
	g_free(q);
    }
    while (strchr(id, '=')) *strchr(id, '=') = '_';
    while (strchr(id, '-')) *strchr(id, '-') = '_';
    return id;
}

static void 
option_toggle(GtkToggleButton *togglebutton , gpointer data){
    return;
#if 0
    //GtkWidget *dialog = g_object_get_data(G_OBJECT(togglebutton), "dialog");
    gint i = GPOINTER_TO_INT(data);
    gboolean active = gtk_toggle_button_get_active(togglebutton);

    guint64 flags=0;
    if (active){
	flags |= ((guint64)0x01 << i); 
    } else {
	flags &= ~((guint64)0x01 << i); 
    }
#endif
}
// Send flag, this will determine if box is checked or not
// (mandatory, may be zero)
// If entry available, check from keyfile, if keyfile is not NULL.
G_MODULE_EXPORT 
GtkWidget *
group_options_box(GtkWidget *dialog, group_options_t *options_p,
	GKeyFile *key_file, const gchar *group, gint flag_id) {
    guint64 ui=0x01;
    GtkWidget *vbox = rfm_vbox_new(0, FALSE);
    GtkWidget *sw = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw), GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), 
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    guint64 flag = 0;
    if (key_file && group && strlen(group)) {
	// Get the flag set in the file...
	NOOP(stderr, "check options from keyfile for group=%s...\n", group);
	gchar *flag_key = FLAG_KEY(flag_id);
#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<26
	flag = g_key_file_get_integer(key_file, group, flag_key, NULL);
#else
	flag = g_key_file_get_uint64(key_file, group, flag_key, NULL);
#endif
	g_free(flag_key);
    } else {
	// Set a new default flag...
	gint i=0;
	group_options_t *p;
	for (p=options_p; p && p->flag; p++,i++){
#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<26
	    if (i>=31) {
		continue;
	    }
#endif
	    // Set checkbox on...
	    if (p->sensitive > 1 || p->sensitive < 0) {
		NOOP(stderr, "setting check on for %s\n", p->id);
		flag |= (ui<<i);
	    } else {
		NOOP(stderr, "check off for %s\n", p->id);
	    }
	    // Special case, uid and gid, default values
	    if (p->id && strcmp(p->id,"uid=")==0){
		uid_t uid=geteuid();
		NOOP("%d: uid is now %d\n",i, uid);
		p->entry = g_strdup_printf("%d", (gint)uid);
		continue;
	    }
	    if (p->id && strcmp(p->id,"gid=")==0){
		gid_t gid=getegid();
		p->entry = g_strdup_printf("%d", (gint)gid);
	    }
	}
    }

	
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=8
    gtk_container_add(GTK_CONTAINER(sw), vbox);

#else
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw), vbox);
#endif

    gint i=0;
    for (; options_p && options_p->flag; options_p++){

     GtkWidget *hbox = rfm_hbox_new(0, FALSE);
      gtk_widget_show(hbox);
      GtkWidget *check;
      GtkWidget *entry=NULL;
      gchar *check_text;
      if (options_p->entry){
	  check_text = 
	    g_strdup_printf("%s %s",  options_p->flag,
		    options_p->id);
      } else {
	  check_text = g_strdup_printf("%s %s",  options_p->flag,
		    (options_p->id)?options_p->id:"");
      }

	check = 
	    gtk_check_button_new_with_label(check_text);
	if (options_p->tip){
	    rfm_add_custom_tooltip(check, NULL, options_p->tip);
	} else if (options_p->text && options_p->entry){
	    rfm_add_custom_tooltip(check, NULL, options_p->text);
	}
	g_free(check_text);
	gtk_widget_show(check);
	gtk_box_pack_start (GTK_BOX (hbox), check, FALSE, FALSE, 0);

      GtkWidget *label=NULL;
      if (options_p->entry)  {
	entry = gtk_entry_new();
	gtk_widget_show(entry);
	gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
      }
      else if (options_p->text) {
	  // not for entries...
	gchar *g = g_strdup_printf(" <i>(%s)</i>", _(options_p->text));
	label=gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(label), g);
	g_free(g);
	gtk_widget_show(label);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
      }

        gtk_widget_set_sensitive(hbox, (options_p->sensitive > 0));
        gchar *id_a[]={(gchar *)options_p->flag, (gchar *)options_p->id, NULL};
	gchar *id = fuse_get_option_id(id_a);
        if (g_object_get_data(G_OBJECT(dialog), id)) {
	    DBG("Duplicate option: %s\n", id);
	}
       g_object_set_data(G_OBJECT(dialog), id, check);
       if (entry){
	    gchar *idd_a[]={(gchar *)options_p->flag, (gchar *)options_p->id, "Entry", NULL};
	    gchar *idd = fuse_get_option_id(idd_a);
	    NOOP( "++ setting entry idd to %s\n", idd);
	    if (g_object_get_data(G_OBJECT(dialog), idd)) {
		DBG("Duplicate entry: %s\n", idd);
	    }
	    g_object_set_data(G_OBJECT(dialog), idd, entry);
	    g_free(idd);
       }
    
       if (key_file) {
	   if (entry) {
	        gchar *value = g_key_file_get_value(key_file, group, id, NULL);
	        if (value) {
		    gtk_entry_set_text(GTK_ENTRY(entry), value);
		    g_free(value);
		} else {
		    // Value is not found in key file (as for a new group)
		    gtk_entry_set_text(GTK_ENTRY(entry), options_p->entry);
		}
	    } 
       } else if (entry) {
	    gtk_entry_set_text(GTK_ENTRY(entry), options_p->entry);
       }
#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<26
	if (i>=31) {
	    TRACE("FUSE option unavailable: %s (to enable, please update to glib >= 2.26.0)\n", (options_p->id)?options_p->id:options_p->text );
	    ;
	    if (label) gtk_widget_set_sensitive(GTK_WIDGET(label), FALSE);
	    gtk_widget_set_sensitive(GTK_WIDGET(check), FALSE);
	    if (entry) gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
	    gtk_widget_set_sensitive(GTK_WIDGET(hbox), FALSE);
	}
#else
       if (flag & (ui << i)){
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
       }
       g_signal_connect (check, "toggled", G_CALLBACK (option_toggle), 
	       GINT_TO_POINTER(i));
#endif
       g_free(id);
       i++;

      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);      
    }
    gtk_widget_show(vbox);
    gtk_widget_set_size_request(sw, -1, 300);
    return sw;
}


G_MODULE_EXPORT 
gchar **
group_option_keys(group_options_t *options_p){
    gint count = 0;
    for (;(options_p+count)->flag; count++);
    // add null terminating string
    count++;
    gchar **option_keys = (gchar **)malloc(count * sizeof(gchar*));
    if (!option_keys) g_error("malloc: %s", strerror(errno));
    memset (option_keys, 0, count * sizeof(gchar*));
    gint i=0;
    for (i=0; options_p+i && (options_p+i)->flag; i++){
	NOOP("flag=%s, id=%s\n",(options_p+i)->flag, (options_p+i)->id);
	option_keys[i] = 
	    g_strconcat((options_p+i)->flag, 
		    (options_p+i)->id,
		    NULL);
	while (strchr(option_keys[i], '=')) *strchr(option_keys[i], '=') = '_';
	while (strchr(option_keys[i], '-')) *strchr(option_keys[i], '-') = '_';
    }
    return option_keys;
}

    
G_MODULE_EXPORT 
GHashTable *
group_options_get_option_hash(GtkWidget *dialog, gchar **option_keys, guint64 *flag_p)
{
    if (flag_p) *flag_p = 0;
    if (!dialog || !option_keys || !flag_p) return NULL;
    gint i=0;
    GHashTable *hash = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free); 


    guint64 ui=0x01;
    guint64 flag = 0;
    for (i=0; option_keys[i] && i<63; i++){
#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<26
	if (i>=31) {
	    continue;
	}
#endif
	GtkWidget *check = g_object_get_data(G_OBJECT(dialog), option_keys[i]);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))){
	    NOOP("%d: option %s = ", i, option_keys[i]);
	    NOOP("TRUE... ");
	    flag |= (ui << i);
	    gchar *idd = g_strconcat(option_keys[i], "Entry", NULL);
	    GtkWidget *entry = g_object_get_data(G_OBJECT(dialog), idd);
	    if (entry){
	       NOOP( "-- got entry id from %s\n", idd);
		const gchar *entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
		if (entry_text) { 
		    NOOP("putting in hash  --> %s", entry_text);
		    g_hash_table_insert(hash, 
			    g_strdup(option_keys[i]), g_strdup(entry_text));
		} else {
		    //NOOP("\n");
		}

	    } 
	    g_free(idd);
	} else {
	}
	NOOP("\n");
    }
    *flag_p = flag;
    return hash;
}


static GMutex *
get_key_file_mutex(void){
    static GMutex *mutex = NULL;
    static gsize initialized = 0;
    if (g_once_init_enter (&initialized)){
	rfm_mutex_init(mutex);
      g_once_init_leave (&initialized, 1);
    }
    return mutex;
}

void
group_options_write_keyfile(GKeyFile *key_file){
    gchar *file = g_build_filename(FUSE_KEY_FILE, NULL);
    TRACE( "group_options_write_keyfile: %s\n", file);
    // Write out key_file:
    gsize file_length;
    gchar *file_string = g_key_file_to_data (key_file, &file_length, NULL);
    GMutex *key_file_mutex = get_key_file_mutex();
    g_mutex_lock (key_file_mutex);
    gchar *config_directory = g_path_get_dirname(file);
    if (!g_file_test(config_directory, G_FILE_TEST_IS_DIR)){
	TRACE( "creating directory %s\n", config_directory);
	g_mkdir_with_parents(config_directory, 0700);
    }

    g_free(config_directory);
    gint fd = creat(file, O_WRONLY | S_IRWXU);

    if (fd >= 0){
	// lock file for write
	if (write(fd, file_string, file_length) < 0){
	    DBG("write_keyfile(): cannot write to %s: %s\n", file, strerror(errno));
	}
	close(fd);
    } else {
	DBG("write_keyfile(): cannot open %s for write: %s\n", file, strerror(errno));
    }
	// unlock file
    g_mutex_unlock (key_file_mutex);
    g_free(file);
}

G_MODULE_EXPORT 
gchar **
group_options_get_key_options(const gchar *group, 
	gint flag_id, 
	group_options_t *group_options_p,
        gint group_options_size)
{
    gchar *file = g_build_filename(FUSE_KEY_FILE, NULL);
    // Load file
    GKeyFile *key_file = g_key_file_new ();
    if (!g_key_file_load_from_file (key_file, file, 0, NULL)){
	g_free(file);
	g_key_file_free(key_file);
	return NULL;
    }
    g_free(file);

    guint64 flag;
    gchar *flag_key;
    flag_key = FLAG_KEY(flag_id);
#if GLIB_MAJOR_VERSION==2 && GLIB_MINOR_VERSION<26
    flag = g_key_file_get_integer(key_file, group, flag_key, NULL);
#else
    flag = g_key_file_get_uint64(key_file, group, flag_key, NULL);
#endif
    g_free(flag_key);

    
    guint64 ui = 0x01;
    gint i;
    gint j = 0;
    gboolean anything = FALSE;
    // XXX 129 seems overkill. Why not 64? 
    gchar **options = (gchar **)malloc(129 * sizeof(gchar *));
    if (!options) g_error("malloc: %s", strerror(errno));
    memset(options, 0, 129 * sizeof(gchar *));
    gchar **option_keys = group_option_keys(group_options_p);
    for (i=0; i<group_options_size && i < 63; i++){
	if (flag & (ui << i)){
	    anything = TRUE;
	    options[j++] = g_strdup((group_options_p+i)->flag);
	    if ((group_options_p+i)->id) {
		gchar *value = g_key_file_get_value (key_file, group,
			option_keys[i], NULL);
		options[j++] = g_strconcat((group_options_p+i)->id, value, NULL);
		g_free(value);
	    }
	}
    }
    if (!anything){
	g_free(options);
	options = NULL;
    }
    g_strfreev(option_keys);
    g_key_file_free(key_file);

    return options;
}


G_MODULE_EXPORT 
gchar *
group_options_get_key_value(const gchar *group, const gchar *key){
    NOOP(stderr, "getting: %s --> %s\n", group, key);
    if (!group) {
	NOOP(stderr, "group_options_get_key_value: group is NULL\n");
	return NULL;
    }
   gchar *file = g_build_filename(FUSE_KEY_FILE, NULL);

    // Load file
    GKeyFile *key_file = g_key_file_new ();
    if (!g_key_file_load_from_file (key_file, file, 0, NULL)){
	g_free(file);
	g_key_file_free(key_file);
	NOOP(stderr, "!g_key_file_load_from_file\n");
	return NULL;
    }
    g_free(file);
    gchar *value = g_key_file_get_value (key_file, group, key, NULL);
	NOOP(stderr, "load: %s --> %s\n", key, value);
    g_key_file_free(key_file);

    return value;
}

G_MODULE_EXPORT 
gchar *
group_options_set_key_value(const gchar *group, const gchar *key, gchar *value){
   gchar *file = g_build_filename(FUSE_KEY_FILE, NULL);

    // Load file
    GKeyFile *key_file = g_key_file_new ();
    if (!g_key_file_load_from_file (key_file, file, G_KEY_FILE_KEEP_COMMENTS|G_KEY_FILE_KEEP_TRANSLATIONS, NULL)){
	g_free(file);
	g_key_file_free(key_file);
	return NULL;
    }
    g_free(file);
    g_key_file_set_value (key_file, group, key, value);

    group_options_write_keyfile(key_file);    
    g_key_file_free(key_file);

    return value;
}


G_MODULE_EXPORT 
gboolean
group_options_get_key_boolean(const gchar *group, const gchar *key){
   gchar *file = g_build_filename(FUSE_KEY_FILE, NULL);

    // Load file
    GKeyFile *key_file = g_key_file_new ();
    if (!g_key_file_load_from_file (key_file, file, 0, NULL)){
	g_free(file);
	g_key_file_free(key_file);
	return FALSE;
    }
    g_free(file);
    gboolean value = g_key_file_get_boolean (key_file, group, key, NULL);
    g_key_file_free(key_file);

    return value;
}

G_MODULE_EXPORT 
gboolean
group_options_remove_group(const gchar *group){
    gchar *file = g_build_filename(FUSE_KEY_FILE, NULL);

    // Load file
    GKeyFile *key_file = g_key_file_new ();
    if (!g_key_file_load_from_file (key_file, file, 0, NULL)){
	g_key_file_free(key_file);
	g_free(file);
	return FALSE;
    }
    g_free(file);
    // Remove group
    if (!g_key_file_remove_group (key_file, group, NULL)){
	DBG("WTF: cannot remove group %s\n", group);
	g_key_file_free(key_file);
	return FALSE;
    }
    // Save file

    group_options_write_keyfile(key_file);
    g_key_file_free(key_file);
    return TRUE;

}




