#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
#include <config.h>
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
//
//
static gchar **module_option_keys = NULL;
static  GroupOptions module_options[]={
// Module options:

    {
        .sensitive =0, .flag = "-o", .id = "subdir=", 
        .tip = N_("Prepend this directory to all paths (mandatory)."), 
	.entry = ""},
    {
        .sensitive = 1, .flag = "-o", .id = "rellinks", 
        .tip = N_("Transform absolute symlinks to relative."),
	.entry = NULL },//?
    {
	.sensitive = 1, .flag = "-o", .id = "from_code=", 
	.tip = N_("Original encoding of file names (default: UTF-8)."), 
	.entry = "UTF-8"},
    {
	.sensitive = 1, .flag = "-o", .id = "to_code=", 
	.tip = N_("New encoding of the file names (default: ISO-8859-1)."), 
	.entry = "ISO-8859-15"},
    {
	.sensitive = 1, NULL, NULL, NULL, .entry = NULL
    }
  };

static gchar **fuse_option_keys = NULL;
static  GroupOptions fuse_options[]={
// FUSE options:

    {
	.sensitive =0, .flag = "-o", .id = "debug", 
	.text = N_("enable debug output (implies -f)"), 
	.entry = NULL
    },
    {
	.sensitive =1, .flag = "-f", .id = NULL,
	.text = N_("foreground operation"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-s", .id = NULL, 
	.text = N_("disable multi-threaded operation"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "allow_other",
	.text = N_("allow access to other users"),
	.tip = N_("Allow access to other users. By default the  mount  point is  only  accessible  to the user that mounted it and not even to root."),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "allow_root", 
	.text = N_("allow access to root"),
	.tip = N_("Allow access to root user. By default the mount point  is only  accessible to the user that mounted it and not even to root."),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "nonempty",
	.text = N_("allow mounts over non-empty file/dir"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "default_permissions",
	.text = N_("enable permission checking by kernel"),
	.entry = NULL },
    {
	 .sensitive = 1, .flag = "-o", .id = "fsname=",
	 .text = N_("set filesystem name"), 
	.entry = "<name>"},
    {
	.sensitive = 1, .flag = "-o", .id = "subtype=",
	.text = N_("set filesystem type"), 
	.entry = "<name>"},
   {
       .sensitive =0, .flag = "-o", .id = "large_read", 
       .text = N_("issue large read requests (2.4 only)"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "max_read=", 
	.text = N_("set maximum size of read requests"), 
	.entry = "65536"},
    {
	.sensitive = 1, .flag = "-o", .id = "hard_remove", 
	.text = N_("immediate removal (don\'t hide files)"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "use_ino", 
	.text = N_("let filesystem set inode numbers"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "readdir_ino",
	.text = N_("try to fill in d_ino in readdir"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "direct_io",
	.text = N_("use direct I/O"),
	.entry = NULL },
    {
	.sensitive = 2, .flag = "-o", .id = "kernel_cache", 
	.text = N_("cache files in kernel"),
	.entry = NULL },
    {
	.sensitive = 2, .flag = "-o", .id = "auto_cache",
	.text = N_("enable caching based on modification times"), 
	.entry = NULL },

    {
	.sensitive = 1, .flag = "-o", .id = "umask=", 
	.text = N_("set file permissions (octal)"), 
	.entry = "M"},
    {
	.sensitive = 2, .flag = "-o", .id = "uid=",
	.text = N_("set file owner"), 
	.entry = "N"},
    {
	.sensitive = 2, .flag = "-o", .id = "gid=",
	.text = N_("set file group"), 
	.entry = "N"},
    {
	.sensitive = 1, .flag = "-o", .id = "entry_timeout=",
	.text = N_("cache timeout for names (1.0s)"), 
	.entry = "1.0"},
    {
	.sensitive = 1, .flag = "-o", .id = "negative_timeout=",
	.text = N_("cache timeout for deleted names (0.0s)"), 
	.entry = "0.0"},
    {
	.sensitive = 1, .flag = "-o", .id = "attr_timeout=",
	.text = N_(" cache timeout for attributes (1.0s)"), 
	.entry = "1.0"},
    {
	.sensitive = 1, .flag = "-o", .id = "ac_attr_timeout=", 
	.text = N_("auto cache timeout for attributes (attr_timeout)"), 
	.entry = "1.0"},

    
    {
	.sensitive = 2, .flag = "-o", .id = "intr", 
	.text = N_("allow requests to be interrupted"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "intr_signal=",
	.text = N_("signal to send on interrupt (10)"), 
	.entry = "10"},
    {
	.sensitive = 1, .flag = "-o", .id = "modules=",
	.text = N_("names of modules to push onto filesystem stack"), 
	.entry = "M1[:M2...]"},
    {
	.sensitive = 1, .flag = "-o", .id = "max_write=",
	.text = N_("set maximum size of write requests"), 
	.entry = "N"},
    {
	.sensitive = 1, .flag = "-o", .id = "max_readahead=",
	.text = N_("set maximum readahead"), 
	.entry = "N"},



    {
	.sensitive = 1, .flag = "-o", .id = "sync_read", 
	.text = N_("perform reads synchronously"),  // linked
	.entry = NULL }
	,
    {
#ifdef THIS_IS_LINUX
	.sensitive = 1, 
#else
	.sensitive = 0,
#endif
	.flag = "-o", .id = "atomic_o_trunc", 
	.text = N_(" enable atomic open+truncate support"), 
	.entry = NULL },
    {
#ifdef THIS_IS_LINUX
	.sensitive = 1, 
#else
	.sensitive = 0,
#endif
	.flag = "-o", .id = "big_writes",
	.text = N_("enable larger than 4kB writes"), 
	.entry = NULL },
    {
#ifdef THIS_IS_LINUX
	.sensitive = 2, 
#else
	.sensitive = 0,
#endif
	.flag = "-o", .id = "no_remote_lock",
	.text = N_("disable remote file locking"), 
	.entry = NULL },
    {
#ifdef THIS_IS_LINUX
	.sensitive = 1, 
#else
	.sensitive = 0,
#endif
	NULL, NULL, NULL, .entry = NULL }
  };


