/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent.h"
#include "fuse-group_options.h"

//#define FUSE_IS_PARENT_MODULE 1
#include "fuse-common.h"

/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "sftp"
//Not applicable:
//#define SUBMODULE_NAME "fuse"
#define MODULE_LABEL _("Secure FTP (SSH)")
#define MODULE_ICON_ID "xffm/emblem_atom/compositeC/emblem_ssh"
//#define MODULE_ICON_ID "rodent-sshfs"
#define MODULE_ENTRY_TIP _("View files on the volume using a SFTP network share")
#define MODULE_PLUGIN_INFO _("SSH (sshfs FUSE)")
#define PARENT_MODULE_NAME "fuse"
#define MODULE_PREFERENCES_KEY "RODENT-SSH"

#define SSH_AUTHORIZATION _("SSH Authorization")
#define SSH_TIP _("Set Up Computer for SSH Connection")

#include "module-skeleton.h"

// Skeleton definitions

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY(MODULE_PREFERENCES_KEY)
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(FALSE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(MODULE_PLUGIN_INFO)
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(TRUE)
G_MODULE_EXPORT RFM_MODULE_RELOAD(TRUE)
G_MODULE_EXPORT RFM_MODULE_SKIPWAIT(TRUE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(TRUE)

// Superceded:
// G_MODULE_EXPORT RFM_ITEM_ICON_ID
// G_MODULE_EXPORT RFM_G_MODULE_CHECK_INIT
// g_module_check_init is now located at fuse-common.c

#define SSH_SECURE_SHELL_KEY_INFO1 _("A Secure Shell (SSH) key lets you connect securely to trusted computers using SSH, without entering a different password for each of them.")
#define SSH_SECURE_SHELL_KEY_INFO2 _("To use your Secure Shell key with another computer that uses SSH, you must already have a login account on that computer.")


#define SSH_OPTIONS _("SSH Options")

// unions:
#define EN_COMPUTER 	tag
#define EN_SCHEME	encoding
#define EN_REMOTE_PATH 	filetype
#define EN_LOGIN	mimetype

#define FLAG_KEY(x)  g_strdup_printf("FLAG_%d", x)

// option dialogs:
#include "fuse-options.i"    
#include "sftp-options.i"
#include "sftp-dialog.i"

#include "sftp-submodule.i"

// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
G_MODULE_EXPORT
xfdir_t *
module_xfdir_get (void *p) {
    void *argv[] = {
	p,
	(void *)"sshfs",
	(void *)"sftp://",
	(void *)"FUSE_MOUNT_POINT",
	(void *)MODULE_NAME,
	(void *)SSH_AUTHORIZATION,
	NULL
    };
    return FUSE_xfdir(argv);
}



G_MODULE_EXPORT
const gchar *
item_icon_id (void *p){
    void *argv[] = {
	p,
	(void *)MODULE_LABEL,
	(void *)module_icon_id(),
	(void *)SSH_AUTHORIZATION,
	NULL
    };
    return FUSE_icon(argv);
}

// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    record_entry_t *en = q;
    if (!en) return NULL;
    const gchar *url = en->pseudo_path;
    return FUSE_click((void *)confirm_ssh_host_dialog, url, en, MODULE_NAME);

}

// gboolean
// This function is to generate a module specific popup menu, either on
// icon click or on void space click . 
// If this function will generate a popup menu, return value should be TRUE,
// otherwise return FALSE so Rodent will generate the default popup menu.
// Popup menu for modules should be set as view data on the paper object
// identified by "private_popup_menu".
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
     void *argv[] = {
	(void *)SSH_OPTIONS,
	(void *)do_properties,
	(void *)mount_host,
	NULL
    };
    TRACE( "sftp_private_popup...\n");
   return FUSE_popup(argv);
}


//  gchar *  
// This function returns a newly allocated string with the general information
// of the entry (parameter p). Rodent uses this to construct the popup tip.
// Returned value should be freed when no longer used.
G_MODULE_EXPORT
void *
item_entry_tip(void *p){
    if (!p) return NULL;
    record_entry_t *en = p;
    if (!en->path) return NULL;
    if (strcmp(en->path, SSH_AUTHORIZATION)==0){
	return g_strdup(SSH_TIP);
    }
    if (en->module  && strcmp(en->module, MODULE_NAME)){
	const gchar *text = rfm_void(PLUGIN_DIR, en->module, "module_entry_tip");
	return g_strdup(text);
    } else if (en->path) {
 	gchar *text =  g_strdup_printf("\n%s\n\n%s\n",
		en->path,
		_("The mount point used for the media device connection."));
	return text;
   }
    return g_strdup("fixme: sftp-submodule.c");
}

// gint
// This function returns the count of elements in the module's
// view. This value is compared with current value to determine
// whether a reload is necessary.
// Parameter p is the view's widgets_p.
// Parameter p is the view's view_p record entry.
G_MODULE_EXPORT 
void *
module_count (void *p) {
    return fuse_test_ini_file(p);
}

