#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
#ifdef HAVE_SYS_SYSCTL_H
#include <sys/sysctl.h>
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
//
//
// Helper functions to sshfs-fuse module.
/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static void 
do_properties (GtkMenuItem * menuitem, gpointer user_data) {
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    const gchar *url = en->pseudo_path;
    FUSE_click((void *)confirm_ssh_host_dialog, url, NULL, MODULE_NAME);

    return ;
}


void *
mount_url (widgets_t * widgets_p, const gchar *url) {
#ifdef THIS_IS_BSD
    int old_p=0;
    size_t size=sizeof(int);
    if (sysctlbyname("vfs.usermount", &old_p, &size, NULL, 0) < 0){
	DBG("sysctlbyname: %s\n", strerror(errno));
    }
    if (old_p != 1){
	rfm_show_text(widgets_p);
	rfm_diagnostics(widgets_p, "xffm/stock_dialog-warning", NULL);
	rfm_diagnostics(widgets_p, "xffm_tag/stderr", "sysctl vfs.usermount=0", "\n", NULL);
	rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	rfm_diagnostics(widgets_p, "xffm_tag/green", 
		    _("Use sysctl or add this line to \"/etc/sysctl.conf\":"),"\n", NULL);
	rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		"   ","vfs.usermount=1","\n", NULL);
	return NULL;
    } else {
	struct stat st;
	const gchar *mnt_src="/dev/fuse0";
	stat(mnt_src, &st);
	if (!(st.st_mode & S_IWGRP)){
	    rfm_show_text(widgets_p);
	    rfm_diagnostics(widgets_p, "xffm/stock_dialog-warning", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/stderr", _("No write access to "),
		    mnt_src, "\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/green", 
		    _("Add these lines to /etc/devfs.rules:"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    "[localrules=5]","\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    _("add path 'fuse*' mode 0660 group operator"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/green", 
		    _("Add this line to /etc/rc.conf:"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    "   ","devfs_system_ruleset=\"localrules\"","\n", NULL);
	    return NULL;
	}
    }  
#endif 
    
    gchar **options_ssh = NULL;
    gchar **options_fuse = NULL;
    gchar **options_module = NULL;
 
    gchar *mount_point = group_options_get_key_value (url, "FUSE_MOUNT_POINT");

    NOOP(stderr, "mount point is %s\n", mount_point);

    if (!fuse_mkdir(mount_point)){
	g_free(mount_point);
	return NULL;
    }
    gchar *computer = group_options_get_key_value (url, "FUSE_COMPUTER");
    gchar *remote_path = group_options_get_key_value (url, "FUSE_REMOTE_PATH");
    gchar *login = group_options_get_key_value (url, "FUSE_LOGIN");
    gboolean ssh_key = group_options_get_key_boolean (url, "FUSE_SECURE_SHELL_KEY");
    gboolean empty_passphrase = group_options_get_key_boolean (url, "FUSE_ALLOW_EMPTY_PASSPHRASE");
    gboolean broadband = group_options_get_key_boolean (url, "FUSE_BROADBAND");
    gboolean monitor = group_options_get_key_boolean (url, "FUSE_MONITOR");
    gchar *argv[MAX_COMMAND_ARGS];
    gchar *remote = g_strdup_printf("%s@%s:%s", 
	    (login)?login:g_get_user_name(), computer, remote_path);
    if (strncmp(remote, "sftp://", strlen("sftp://"))==0) {
	remote += strlen("sftp://");
    }
    gchar *fsname=NULL;
    gint i=0;
    argv[i++] = "sshfs";
    argv[i++] = remote;
    argv[i++] = mount_point;
    // options from standard option pages...

    // fuse options is FLAG_1
    gint flag_id=1;
    options_fuse = 
	group_options_get_key_options(url, flag_id, 
	    fuse_options, sizeof(fuse_options)/sizeof(group_options_t));
    // module options is FLAG_2
    flag_id=2;
    options_module =
	group_options_get_key_options(url, flag_id, 
	    module_options, sizeof(module_options)/sizeof(group_options_t));
    // sshfs options is FLAG_3
    flag_id=3;
    options_ssh =
	group_options_get_key_options(url, flag_id, 
	    sshfs_options, sizeof(sshfs_options)/sizeof(group_options_t));
    gchar **o;
    for (o=options_ssh; o && *o; o++) {
        if (i+1 >= 100){
            g_warning("mount_url(): This should never happen\n");
            break;
        }
	argv[i++] = *o;
    }
    for (o=options_fuse; o && *o; o++) {
        if (i+1 >= 200){
            g_warning("mount_url(): This should never happen\n");
            break;
        }
	argv[i++] = *o;
    }
    for (o=options_module; o && *o; o++) {
        if (i+1 >= 300){
            g_warning("mount_url(): This should never happen\n");
            break;
        }
	argv[i++] = *o;
    }
    // other options which may override option page settings
    argv[i++] = "-o";
    argv[i++] = "KbdInteractiveAuthentication=no";
    if (broadband){
	NOOP(stderr, "%s: broadband\n", mount_point);
	rfm_set_local_type(mount_point);
 /*	argv[i++] = "-o";
	fsname =  g_strdup_printf("fsname=broadsshfs-%s",remote);
	argv[i++] = fsname;*/
    } else if (monitor) {
	NOOP(stderr, "%s: monitor\n", mount_point);
	rfm_set_monitor_type(mount_point);
 /*	argv[i++] = "-o";
	fsname =  g_strdup_printf("fsname=monitor-%s",remote);
	argv[i++] = fsname;*/
    } else {
	rfm_set_remote_type(mount_point);
    }
    if (ssh_key) {
 	argv[i++] = "-o";
	argv[i++] = "PubkeyAuthentication=yes";
 	argv[i++] = "-o";
	argv[i++] = "PasswordAuthentication=no";

    } else {
 	argv[i++] = "-o";
	argv[i++] = "PasswordAuthentication=yes";
 	argv[i++] = "-o";
	argv[i++] = "PubkeyAuthentication=no";
   }

    gchar *text = NULL;
    if (ssh_key && !empty_passphrase) {
	
	text = g_strdup_printf("\n<b>%s</b>\n\n(<i>%s@%s</i>)", _("Please supply the passphrase for your SSH private key."), 
		g_get_user_name(), g_get_host_name());
    } else if (!ssh_key) {
	gchar *account = g_strdup_printf("<i>%s@%s</i>", (login)?login:g_get_user_name(), computer);
	text = g_strdup_printf(_("Enter your password for account\n%s"), 
		account);
	g_free(account);
    }
    gchar *passwd=NULL;
    if (ssh_key && empty_passphrase) {
	passwd = g_strdup("");
    } else if (ssh_key){
	passwd = rfm_get_response (widgets_p, text, NULL, TRUE);
    }
    if (ssh_key){
	argv[i++] = "-o";
	argv[i++] = "ChallengeResponseAuthentication=no";
	argv[i++] = "-o";
	argv[i++] = "BatchMode=yes";

    } else {
	argv[i++] = "-o";
	argv[i++] = "ChallengeResponseAuthentication=yes";
    }

    g_free(text);


    argv[i++] = NULL;

     rfm_show_text(widgets_p);
    if (passwd) {
	gint fd;
	rfm_thread_run_argv_with_stdin (widgets_p, argv, FALSE, &fd);
	
	if (write(fd, passwd, strlen(passwd)) < 0){
	    NOOP("error writing passphrase to stdin...\n");
	}
    // flush
	if (write(fd, "\n", strlen("\n")) < 0){
	    NOOP("error writing passphrase to stdin...\n");
	}
	memset(passwd, 0, strlen(passwd));
	g_free(passwd);
	close(fd);
    } else {
	rfm_thread_run_argv (widgets_p, argv, FALSE);
    }
//done:
    g_free(fsname);
    g_free(remote);
    g_free(login);
    g_free(computer);
    g_free(remote_path);
    g_free(mount_point);

    g_strfreev(options_ssh);
    g_strfreev(options_fuse);
    g_strfreev(options_module);
    return GINT_TO_POINTER(TRUE);
}



static void
mount_host (GtkMenuItem * menuitem, gpointer user_data) {
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    if (!en) return;
    widgets_t *widgets_p = rfm_get_widget("widgets_p");;
    mount_url(widgets_p, en->pseudo_path);
}
