
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <dirent.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "rfm.h"

#include "rodent-mime_callbacks.h"
#include "rodent-mime_gui.h"
#include "rodent-mime_support.h"
extern gchar *icon_theme_name;
GtkWidget *
create_xfmime_edit (gchar * name) {
    GtkWidget *xfmime_edit;
    GtkWidget *vbox1;
    GtkWidget *hpaned1;
    GtkWidget *scrolledwindow3;
    GtkWidget *treeview1;
    GtkWidget *scrolledwindow2;
    GtkWidget *treeview2;
    GtkWidget *hbox3;
    GtkWidget *hbuttonbox1;
    GtkWidget *save;
    GtkWidget *quit;
//"Custom:""Select Custom Icon""Use custom &icons:"
    xfmime_edit = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_size_request (xfmime_edit, 400, 537);
    gchar *string=g_strdup_printf("%s: %s", _("Select Custom Icon"), icon_theme_name); 
    gtk_window_set_title (GTK_WINDOW (xfmime_edit), string);
    g_free(string);
    gtk_window_set_default_size (GTK_WINDOW (xfmime_edit), 640, 480);

    vbox1 = rfm_vbox_new (FALSE, 0);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (xfmime_edit), vbox1);

    hpaned1 = rfm_hpaned_new ();
    gtk_widget_show (hpaned1);
    gtk_box_pack_start (GTK_BOX (vbox1), hpaned1, TRUE, TRUE, 0);
    gtk_paned_set_position (GTK_PANED (hpaned1), 345);

    scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scrolledwindow3);
    gtk_paned_pack1 (GTK_PANED (hpaned1), scrolledwindow3, FALSE, TRUE);

    treeview1 = gtk_tree_view_new ();
    gtk_widget_show (treeview1);
    gtk_container_add (GTK_CONTAINER (scrolledwindow3), treeview1);

    scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scrolledwindow2);
    gtk_paned_pack2 (GTK_PANED (hpaned1), scrolledwindow2, TRUE, TRUE);

    treeview2 = gtk_tree_view_new ();
    gtk_widget_show (treeview2);
    gtk_container_add (GTK_CONTAINER (scrolledwindow2), treeview2);

    hbox3 = rfm_hbox_new (FALSE, 0);
    gtk_widget_show (hbox3);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 0);

    GtkWidget *hbox4 = rfm_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, FALSE, 0);
    GtkWidget *moving_label = (GtkWidget *)
        gtk_label_new (_("Please drag just one image to set a custom icon."));
    gtk_box_pack_start (GTK_BOX (hbox4), moving_label, FALSE, FALSE, 0);
    gtk_widget_show_all (hbox4);

    hbuttonbox1 = rfm_hbutton_box_new ();
    gtk_widget_show (hbuttonbox1);
    gtk_box_pack_start (GTK_BOX (hbox3), hbuttonbox1, FALSE, FALSE, 0);

    save =  rfm_dialog_button ("xffm/stock_save", _("Save"));

    gtk_container_add (GTK_CONTAINER (hbuttonbox1), save);
    gtk_widget_set_can_default(save, TRUE);
    gtk_widget_show(save);

    quit =  rfm_dialog_button ("xffm/stock_close", _("Close"));
    
    gtk_container_add (GTK_CONTAINER (hbuttonbox1), quit);
    gtk_widget_set_can_default(quit, TRUE);
    gtk_widget_show(quit);


    /*g_signal_connect ((gpointer) treeview1, "drag_data_get",
       G_CALLBACK (on_treeview1_drag_data_get), NULL); */

    g_signal_connect ((gpointer) treeview1, "drag_data_received", G_CALLBACK (on_drag_data), NULL);
    g_signal_connect ((gpointer) treeview1, "drag_drop", G_CALLBACK (on_treeview1_drag_drop), NULL);

    g_signal_connect ((gpointer) treeview1, "drag_motion", G_CALLBACK (on_drag_motion), NULL);

    g_signal_connect ((gpointer) treeview2, "drag_data_get", G_CALLBACK (on_treeview2_drag_data_get), NULL);

    g_signal_connect ((gpointer) treeview2, "drag_motion", G_CALLBACK (on_drag_motion), NULL);
    g_signal_connect ((gpointer) treeview2, "drag_drop", G_CALLBACK (on_treeview1_drag_drop), NULL);

    g_signal_connect ((gpointer) save, "clicked", G_CALLBACK (on_save_clicked), NULL);
    g_signal_connect ((gpointer) quit, "clicked", G_CALLBACK (on_quit_clicked), NULL);

    /* Store pointers to all widgets, for use by lookup_widget(). */
    GLADE_HOOKUP_OBJECT_NO_REF (xfmime_edit, xfmime_edit, "xffm-mime");
    GLADE_HOOKUP_OBJECT (xfmime_edit, vbox1, "vbox1");
    GLADE_HOOKUP_OBJECT (xfmime_edit, hpaned1, "hpaned1");
    GLADE_HOOKUP_OBJECT (xfmime_edit, scrolledwindow3, "scrolledwindow3");
    GLADE_HOOKUP_OBJECT (xfmime_edit, treeview1, "treeview1");
    GLADE_HOOKUP_OBJECT (xfmime_edit, scrolledwindow2, "scrolledwindow2");
    GLADE_HOOKUP_OBJECT (xfmime_edit, treeview2, "treeview2");
    GLADE_HOOKUP_OBJECT (xfmime_edit, hbox3, "hbox3");
    GLADE_HOOKUP_OBJECT (xfmime_edit, hbuttonbox1, "hbuttonbox1");
    GLADE_HOOKUP_OBJECT (xfmime_edit, save, "save");
    GLADE_HOOKUP_OBJECT (xfmime_edit, quit, "quit");

    return xfmime_edit;
}
