#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
static gchar *apt;
static gchar *dpkg;

static GSList *add_apt_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){
    //fprintf(stderr, "add_apt_search_item(): %s", line); return pkg_list;
	if (!strchr(line,'\n')) return pkg_list;
	/*if (!strchr(line,'|')){
	    //rfm_threaded_diagnostics(widgets_p, "xffm/emblem_package", NULL);
	    rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	    return pkg_list;
	}    */
	//rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	NOOP("line=%s",line);
	
	*(strchr(line,'\n'))=0;
	g_strchug(line);

	gchar **split = g_strsplit(line, " ", 3);
	DBG("%s|%s|%s\n", split[0], split[1], split[2]);
	g_strstrip(split[0]);
	g_strstrip(split[2]);
	record_entry_t *en=rfm_mk_entry(0);
	en->path = g_strdup(split[0]);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));
	// Is it installed already?
        gchar *com = g_strdup_printf("dpkg --status %s", en->path);
        FILE *p = popen(com, "r");
        gchar *tt = NULL;
        if (p) {
            gchar buffer[1024];
            while (fgets(buffer, 1024, p)){
                if (strstr(buffer, "Status:") && !strstr(buffer, "deinstall")) {
                    SET_LOCAL_TYPE(en->type);
                }
                gchar *g = g_strconcat((tt)?tt:"", buffer, NULL);
                g_free(tt);
                tt = g;
            }
            pclose(p);
        }
	g_hash_table_replace(installed_hash, g_strdup(en->path), 
                    (tt)?tt:g_strdup_printf("%s\n", split[2]));
        
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
        g_strfreev(split);
    return pkg_list;
}

static GSList *add_apt_item(GSList *pkg_list, gchar *line){
    if (strncmp(line, "ii", strlen("ii"))!=0) return pkg_list;
    if (!strchr(line,'\n')) return pkg_list;
    *(strchr(line,'\n'))=0;
    //collapse whitespace
    g_strchug(line);
    gchar *p = line;
    while (p && *p) {
        if (*p == ' ' && *(p+1) ==' ') g_strchug(p+1);
        else p++;
    }
    gchar **split = g_strsplit(line, " ", 5);
    gchar **pp = split;
    /*gint i=0;
    for (; pp && *pp; pp++) {
        fprintf(stderr, "%d) %s\n", i++, *pp);
    }*/
    record_entry_t *en=rfm_mk_entry(0);
    en->type=0; /* remove local-type attributes */
    en->st = (struct stat *)malloc(sizeof(struct stat));
    if (!en->st) g_error("malloc: %s\n", strerror(errno));
    memset(en->st,0,sizeof(struct stat));
    NOOP("line=%s",line);
    en->path = g_strdup(split[1]);
    SET_LOCAL_TYPE(en->type);
    gchar *desc = g_strdup_printf("%s-%s (%s)\n%s\n", split[1], split[2], split[3], split[4]); 
    g_hash_table_replace(installed_hash, g_strdup(en->path), desc);
    en->module=MODULE_NAME;
    pkg_list=g_slist_prepend(pkg_list,en);
    g_strfreev(split);

    //    fprintf(stderr, "add_apt_item(): \"%s\"\n", line); return pkg_list;
    return pkg_list;
}

