#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif

static gchar *pacman=NULL;


static GSList *add_pacman_item(GSList *pkg_list, gchar *line){
    if (!strchr(line,'\n')) return pkg_list;
    NOOP(stderr, "DBG:%s", line);
    *strchr(line,'\n')=0;
    gchar **a = g_strsplit(line, " ", -1);
    if (!a[1]) {
        NOOP(stderr, "no vector...\n");
        g_strfreev(a);
        return pkg_list;
    }

    record_entry_t *en=rfm_mk_entry(0);

    en->path = g_strdup(a[0]);
    NOOP(stderr, "a0=%s, version=%s\n",a[0], a[1]);
    
    en->type=0; /* remove local-type attributes */
    SET_LOCAL_TYPE(en->type);
    en->st = (struct stat *)malloc(sizeof(struct stat));
    if (!en->st) g_error("malloc: %s\n", strerror(errno));
    memset(en->st,0,sizeof(struct stat));

//    g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n(%s)\n", a[5], a[4]));
    en->module=MODULE_NAME;
    pkg_list=g_slist_prepend(pkg_list,en);
    g_strfreev(a);
    return pkg_list;
}

static GSList *add_pacman_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){
    if (!strchr(line,'\n')) return pkg_list;
 //   fprintf(stderr, "DBG:%s", line);
//     rfm_threaded_diagnostics(widgets_p,NULL,g_strdup(line));
    //*strchr(line,'\n')=0;
    if (*line != ' '){
        record_entry_t *en=rfm_mk_entry(0);
        gchar **a = g_strsplit(line, " ", -1);
        // check a
        gchar *p = strchr(a[0], '/');
        // check p
        p++;
        en->path = g_strdup(p);
        en->type=0; /* remove local-type attributes */
        en->st = (struct stat *)malloc(sizeof(struct stat));
        if (!en->st) g_error("malloc: %s\n", strerror(errno));
        memset(en->st,0,sizeof(struct stat));
        en->module=MODULE_NAME;
        pkg_list=g_slist_prepend(pkg_list,en);
        // local or remote?
        gchar *c = g_strdup_printf("pacman -Q %s", p);
        FILE *pipe = popen(c, "r");
        g_free(c);
        if (pipe){
            gchar line[256];
            memset (line, 0, 256);
            if (fgets(line, 255, pipe)) SET_LOCAL_TYPE(en->type);
            fclose(pipe);
        }
        g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(line));
        g_strfreev(a);
    } else {
        //the rest is tooltip material   
        record_entry_t *en = pkg_list->data;
        gchar *tip = g_hash_table_lookup(installed_hash, en->path);
        gchar *new_tip = g_strconcat ((tip)?tip:"", line, NULL);
        g_hash_table_replace(installed_hash, g_strdup(en->path), new_tip);
    }
    return pkg_list;
}

