#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
static gchar *yum;

static GSList *add_yum_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){

	if (!strchr(line,'\n')) return pkg_list;
	if (*line == ' '){
	    //rfm_threaded_diagnostics(widgets_p, "xffm/emblem_package", NULL);
	    rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	    return pkg_list;
	}    
	//rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	NOOP("line=%s",line);
	
	*(strchr(line,'\n'))=0;
	g_strchug(line);
	if (!strstr(line, " : ")) return pkg_list;

	gchar **split = g_strsplit(line, " : ", -1);
	DBG("%s|%s\n", split[0], split[1]);
	g_strstrip(split[0]);
	g_strstrip(split[1]);
        if (strlen(split[0]) ==0){
            g_strfreev(split);
            return pkg_list;
        }

	record_entry_t *en=rfm_mk_entry(0);
	en->path = g_strdup(split[0]);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));

	g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n", split[1]));
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
        g_strfreev(split);
        // Is it installed?
        gchar *command = g_strdup_printf("yum list installed %s", en->path);
        FILE *p = popen(command, "r");
        if (p) {
            gchar buffer[2096];
            memset(buffer, 0, 2096);
            while (fgets(buffer, 2095, p) && !feof(p)){
                if (strstr(buffer, en->path)){
                    SET_LOCAL_TYPE(en->type);
                    break;
                }
            }
            pclose(p);
        }
        g_free(command);
    
    return pkg_list;
}
