#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
static gchar *zypper;

static GSList *add_zypper_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){
	if (!strchr(line,'\n')) return pkg_list;
	if (!strchr(line,'|')){
	    //rfm_threaded_diagnostics(widgets_p, "xffm/emblem_package", NULL);
	    rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	    return pkg_list;
	}    
	//rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	NOOP("line=%s",line);
	
	*(strchr(line,'\n'))=0;
	g_strchug(line);
	if (line[0] == 'E')  return pkg_list;

	gchar **split = g_strsplit(line, "|", -1);
	DBG("%s|%s|%s\n", split[0], split[1], split[2]);
	g_strstrip(split[1]);
	g_strstrip(split[2]);
	record_entry_t *en=rfm_mk_entry(0);
	en->path = g_strdup(split[1]);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));
	if (*(split[0]) == 'i') SET_LOCAL_TYPE(en->type);
	g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n", split[2]));
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
        g_strfreev(split);
    return pkg_list;
}

static GSList *add_rpm_item(GSList *pkg_list, gchar *line){
	// XXX item 2: update-po not working in fbsd...
	if (!strchr(line,'\n')) return pkg_list;
	*(strchr(line,'\n'))=0;
	g_strchug(line);
	record_entry_t *en=rfm_mk_entry(0);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));
	NOOP("line=%s",line);
	{
            en->path = package_name(line);
            //en->tag = g_strdup(line);
            SET_LOCAL_TYPE(en->type);
            g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(""));
	} 
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
    return pkg_list;
}

