#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Edscott Wilson Garcia Copyright 2011
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stdout_nmb_ip (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    view_t *view_p = widgets_p->view_p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n')
        return;

    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
        gchar *string = rfm_diagnostics_exit_string(line);
        rfm_threaded_diagnostics(widgets_p, "xffm/stock_stop", string);
        if (mastersIP == NULL) {
            rfm_threaded_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
            rfm_threaded_diagnostics (widgets_p, "xffm_tag/stderr", g_strconcat("Is NMB daemon active?", NULL));
	    rfm_threaded_diagnostics (widgets_p, "xffm_tag/green",g_strconcat(" ", "(maybe: /etc/init.d/samba start)", "\n", NULL));
	    rfm_threaded_diagnostics (widgets_p, "xffm_tag/blue", g_strconcat("Queries performed with nmblookup will be send to the given broadcast address. Without this option the default behavior is to send the queries to the broadcast address of the network interface that was either auto-detected or defined in the \"interfaces\" parameter of the smb.conf file.", "\n", NULL));
	} 
	NOOP(stderr, "Now signalling...\n");
	    g_mutex_lock(smb_data_p->mutex);
	    smb_data_p->condition = TRUE;
	    g_mutex_unlock(smb_data_p->mutex);
	    g_cond_signal(smb_data_p->signal);

    
    } else {
          rfm_threaded_diagnostics (widgets_p, NULL, g_strconcat(line, NULL));
	if (strstr (line, "__MSBROWSE__") && strstr (line, "<01>")) {
	  gchar *buffer = g_strdup(line);
	  if (strchr(buffer,' ')) {
	      *strchr(buffer,' ') = 0;
	      rfm_threaded_diagnostics(widgets_p, "xffm_tag/red", g_strconcat(_("Found:"), " ", NULL));
	      rfm_threaded_diagnostics(widgets_p, "xffm_tag/green", g_strconcat(buffer, "\n", NULL));
	      g_mutex_lock(mastersIP_mutex);
	      GSList *tmp = mastersIP;
	      gboolean found = FALSE;
	      for (; tmp && tmp->data; tmp=tmp->next){
		  if (strcmp(buffer, (gchar *)tmp->data)==0) {
		      found = TRUE;
		      break;
		  }
	      }
	      if (!found) {
		  mastersIP = 
		    g_slist_prepend(mastersIP, g_strdup(buffer));
	      }
	      g_mutex_unlock(mastersIP_mutex);
	  } 
	  g_free(buffer);

	}
    }
    return;
}

static
void *
query_masters(void *data){
    smb_data_t *smb_data_p = data;
	     
    NOOP(stderr, "query_masters...\n");

  gchar *argument[5];
  argument[0]=  "nmblookup";
  argument[1]=  "-M";
  argument[2]=  "--";
  argument[3]=  "-";
  argument[4]=  0;

  widgets_t *widgets_p = &(smb_data_p->view_p->widgets);
  rfm_threaded_show_text(widgets_p);
#ifdef DEBUG
  rfm_threaded_diagnostics(widgets_p, NULL, g_strconcat("Looking for master browsers...\n", NULL)); 
#endif

  rfm_threaded_diagnostics (widgets_p, "xffm/emblem_network/compositeSE/stock_go-forward", NULL);
  rfm_threaded_diagnostics (widgets_p, "xffm_tag/command", g_strconcat(" nmblookup -M -- -\n", NULL));

  rfm_thread_run_argv_with_stdout (widgets_p, argument, FALSE, stdout_nmb_ip);
  
  return NULL;

}

