/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent.h"
#include "rfm_modules.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "workgroup"
#define SUBMODULE_NAME "shares" 
#define MODULE_LABEL _("Windows workgroup")
//#define MODULE_ICON_ID "xffm/emblem_network/compositeNE/stock_go-forward"

#define MODULE_ENTRY_TIP _("SMB workgroup")
#define PARENT_MODULE_NAME "smb"
#define MODULE_DATA_ID "smb_wg_data_p"

#include "module-skeleton.h"
// Skeleton definitions

G_MODULE_EXPORT RFM_BLOCKING_LOAD(TRUE)
G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
//G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY("RODENT-WORKGROUP")
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(FALSE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(_("Windows workgroup"))
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(FALSE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(TRUE)

#define WORKGROUP_MODULE_C
#include "passfile.i"
#include "samba-common.i"


// This is a hashtable-mutex combo for server netbios names. Data item
// is a GSList for server netbios names listed in the workgroup.
// The key to access each list is the netbios name of the workgroup
// master browser.
static GMutex *
get_list_mutex(void){
    static GMutex *mutex = NULL;
    static gsize initialized = 0;
    if (g_once_init_enter (&initialized)){
	rfm_mutex_init(mutex);
      g_once_init_leave (&initialized, 1);
    }
    return mutex;
}


G_MODULE_EXPORT
void *
module_icon_id(void){
    return "xffm/emblem_network/compositeC/emblem_smb";
/*    static gchar *icon=NULL;
    if (icon == NULL){
	icon = g_strdup_printf("%s/pixmaps/rodent-workgroup.svg", PACKAGE_DATA_DIR);
    }
    return icon;*/
}

void *    
g_module_check_init (GModule * module) {
    BIND_TEXT_DOMAIN;
    common_init(module);
    return NULL;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stdout_smb_wg (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    view_t *view_p = widgets_p->view_p;
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID); 
    const gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    rfm_global_t *rfm_global_p = rfm_global();
    if (!smb_server) smb_server = g_object_get_data(G_OBJECT(rfm_global_p->window), 
	    "smb_server");
    gchar *server_list = g_strconcat(smb_server, "List", NULL);
    g_free(server_list);

    NOOP(stderr, "LOCK/LOCKOK for %s\n", smb_server);

    if(line[0] == '\n') return;
    if (strstr (line, "NT_STATUS_LOGON_FAILURE") ||
        strstr (line, "NT_STATUS_UNSUCCESSFUL"))  {
      //  clear smb-user here.
	gchar *user = 
	    g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-user");  
	g_free(user);
	g_object_set_data(G_OBJECT(widgets_p->paper), 
		"smb-user", NULL);
      rfm_threaded_diagnostics (widgets_p,  "xffm_tag/stderr", g_strconcat(line, "\n",NULL));
      rfm_threaded_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL); 
      rfm_threaded_diagnostics (widgets_p, "xffm_tag/stderr", 
	      g_strconcat(_("Temporary authentication failure"), "\n",NULL));
      rfm_threaded_diagnostics (widgets_p, NULL, 
	      g_strconcat("This probably means that your server requires you to specify the Windows domain name \nas part of your username (eg, quot;DOMAIN\\userquot;).\n\nOr you might have just typed your password wrong.",
	      "\n",NULL)); 
	return ;
    } 

    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {

      GSList *list = smb_data_p->list;

      for (;list && list->data; list = list->next){
            rfm_threaded_diagnostics (widgets_p, "xffm_tag/command_id", g_strconcat("list: ", (gchar *)list->data, "\n", NULL));
      }
        gchar *string = rfm_diagnostics_exit_string(line);
        rfm_threaded_diagnostics(widgets_p, "xffm/stock_stop", string);


      g_mutex_lock(smb_data_p->mutex);
      smb_data_p->condition = TRUE; 
      g_mutex_unlock(smb_data_p->mutex);
      g_cond_signal(smb_data_p->signal);
      return;
    } 

      gchar *server=NULL;

//#ifdef DEBUG
    rfm_threaded_diagnostics (widgets_p, NULL, g_strconcat(line, NULL));
//#endif
    if ( (strstr (line, "Workgroup") && strstr (line, "Master")) ||
       (strstr (line, "Sharename") && strstr (line, "Comment")) ) {
      
      smb_data_p->parse = FALSE;
      return;
    }
    if (strstr (line, "Server") && strstr (line, "Comment"))  {
      smb_data_p->parse = TRUE;
        // By default, the Master Browser should also be in the
        // WG, but buggy windows XP under VBOX might warp this.
        // So we go ahead and add it now.
      server = smb_data_p->xfdir_p->en->path;
      goto master_browser;
    }
    if (strstr (line, "--------")) return;

    GMutex *list_mutex = get_list_mutex();

    if (smb_data_p->parse){
      g_strstrip(line);
      if (strchr(line, ' ')) *strchr(line, ' ') = 0;
      if (strchr(line, '\n')) *strchr(line, '\n') = 0;
      if (strchr(line, '\t')) *strchr(line, '\t') = 0;
      /* workaround IS~ stuff */
      if (strncmp(line,"IS~",strlen("IS~"))==0) server = line + strlen("IS~");
      else server = line;

master_browser:
      if (!server || !strlen(server)) return;
      g_mutex_lock(list_mutex);


      GSList *list = smb_data_p->list;
      gboolean found = FALSE;
      for (; list && list->data; list=list->next){
	  if (strcmp((gchar *)list->data, server)==0){
	      found = TRUE;
	      break;
	  }
      }
      if (!found) {
	NOOP(stderr, "adding %s to list 0x%x\n", server, GPOINTER_TO_INT(smb_data_p->list));
	smb_data_p->list = g_slist_prepend(smb_data_p->list, g_strdup(server));
      }
      
      g_mutex_unlock(list_mutex);
      
      rfm_threaded_diagnostics(widgets_p, "xffm_tag/red", g_strconcat(_("Server:"), " ", NULL));
      rfm_threaded_diagnostics(widgets_p, "xffm_tag/green", g_strconcat(server, "\n", NULL));

    }

    return;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stderr_smb_wg (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n') return;

    rfm_threaded_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
    rfm_threaded_diagnostics (widgets_p, "xffm_tag/stderr", g_strconcat(line, NULL));
    rfm_threaded_diagnostics (widgets_p, NULL, g_strconcat("\n", NULL));
    return;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static
void
fork_finished_function (void *user_data) {
    widgets_t *widgets_p = user_data;

    gchar *passfile = g_object_get_data(G_OBJECT(widgets_p->paper), "passfile");
    g_object_set_data(G_OBJECT(widgets_p->paper), "passfile", NULL);
    g_free(passfile);

    gchar *g = g_strdup_printf ("%d> (%d).", Tubo_id () - 1, getpid());
    if(rfm_threaded_diagnostics_is_visible (widgets_p)) {
        rfm_threaded_diagnostics (widgets_p, "xffm_tag/command_id", g_strconcat(g, NULL));
        rfm_threaded_diagnostics (widgets_p, "xffm/stock_no", g_strconcat("\n", NULL));
    }
    g_free (g);

}


static
void *
query_workgroup(void *data){
  void **p=data;
  widgets_t *widgets_p = p[0];
  gchar *server = p[1];
  gchar *passfile = p[2];



  gchar *argument[20];
  
  NOOP(stderr, "****** query workgroup\n");

  gint i=0;
  argument[i++]=  "smbclient";
  argument[i++]=  "-N";
  if (passfile) {
    argument[i++]=  "-A";
    argument[i++]=  passfile;
  } else {
      NOOP(stderr, "XXXX smb_data_p->authentication_file==NULL\n");
  }
  argument[i++]=  "-L";
  argument[i++]=  server;
  argument[i++]=  0;

  rfm_threaded_show_text(widgets_p);
  rfm_threaded_diagnostics (widgets_p, "xffm/emblem_network/compositeNE/stock_go-forward", NULL);
  for (i=0; argument[i]; i++) {
      rfm_threaded_diagnostics (widgets_p, "xffm_tag/command", g_strconcat(" ", argument[i], NULL));
  }
  rfm_threaded_diagnostics (widgets_p, "xffm_tag/command",g_strconcat("\n", NULL));
 
  //rfm_thread_run_argv_with_stdout (widgets_p, argument, FALSE, stdout_smb_wg);
  rfm_thread_run_argv_full (widgets_p, argument, FALSE, NULL, stdout_smb_wg, stderr_smb_wg, fork_finished_function);
  if (passfile) {
      view_t *view_p = widgets_p->view_p;
    rfm_view_thread_create(view_p, zap_passfile, g_strdup(passfile), "zap_passfile");
  }
  g_free(p);
  return NULL;

}


static 
void cache_xfdir_setup(smb_data_t *smb_data_p) {
    if (!smb_data_p){
	g_error("this is broken: smb_data_p==NULL\n");
    }
    xfdir_t *xfdir_p = smb_data_p->xfdir_p;
    rfm_global_t *rfm_global_p = rfm_global();

    view_t *view_p = smb_data_p->view_p;
	
    gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    g_free(smb_server);
    smb_server = g_object_get_data(G_OBJECT(rfm_global_p->window), 
	    "smb_server");
    g_free(smb_server);

    smb_server = g_strdup(xfdir_p->en->path);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "smb_server", smb_server);
    g_object_set_data(G_OBJECT(rfm_global_p->window), "smb_server", g_strdup(smb_server));

       
    gchar *tag = g_object_get_data(G_OBJECT(view_p->widgets.paper), "tag");
    g_free(tag);
    tag = g_strdup(xfdir_p->en->tag);
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "tag", tag);

    gchar *wg = g_object_get_data(G_OBJECT(view_p->widgets.paper), "smb_workgroup");
    g_free(wg);
    wg = g_object_get_data(G_OBJECT(rfm_global_p->window), "smb_workgroup");
    g_free(wg);

    if (xfdir_p->en->pseudo_path){
	wg = g_strdup(xfdir_p->en->pseudo_path);
    } else {
	DBG("pseudo_path not set\n");
    }
    g_object_set_data(G_OBJECT(view_p->widgets.paper), "smb_workgroup", wg);
    g_object_set_data(G_OBJECT(rfm_global_p->window), "smb_workgroup", (wg)?
	    g_strdup(wg):NULL);
    GMutex *list_mutex = get_list_mutex();
    
    g_mutex_lock(list_mutex);
    gint load_count = g_slist_length(smb_data_p->list);
    NOOP(stderr, "list length count load = %d\n", load_count);

    xfdir_p->pathc = load_count + 1;	
    xfdir_p->gl = (dir_t *)malloc(xfdir_p->pathc*sizeof(dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s", strerror(errno));
    memset(xfdir_p->gl,0,xfdir_p->pathc*sizeof(dir_t));
    set_up_item(xfdir_p);
    if (load_count==0) {
	g_mutex_unlock(list_mutex);
	return;
    }

    GSList *tmp = smb_data_p->list;
    gint i = 1;
    for (; tmp && tmp->data; tmp=tmp->next, i++){
	xfdir_p->gl[i].en=rfm_mk_entry(0);
	xfdir_p->gl[i].en->st = NULL;
	xfdir_p->gl[i].en->parent_module = MODULE_NAME;
	 xfdir_p->gl[i].en->module = "shares"; 
	
	// get share info from list data
	xfdir_p->gl[i].en->path= g_strdup((gchar *)tmp->data);
	xfdir_p->gl[i].en->tag = g_strdup_printf("%s //%s",
	    _("Server:"),(gchar *)tmp->data);
	xfdir_p->gl[i].pathv = g_strdup((gchar *)tmp->data);
	//xfdir_p->gl[i].en->path= g_strdup("XXX");
	//xfdir_p->gl[i].en->tag = g_strdup("XXXx");
	//xfdir_p->gl[i].pathv = g_strdup("XXXxx");
	NOOP(stderr, "count adding %s as %s (%s)\n", 
		xfdir_p->gl[i].en->tag, (gchar *)tmp->data, xfdir_p->gl[i].en->module);
    }
    g_mutex_unlock(list_mutex);
    return;
}

// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
G_MODULE_EXPORT
void *
module_xfdir_get (void *p) {
    NOOP(stderr, "workgroup module: module_xfdir_get\n");
    view_t *view_p = ((xfdir_t *)p)->view_p;
    // Check whether necessary program is installed or not.
    if (!smb_check_program(&(view_p->widgets), "smbclient")) {
	return NULL;
    }

    smb_data_t *smb_data_p = (smb_data_t *)malloc(sizeof(smb_data_t));
    if (!smb_data_p) g_error("malloc: %s", strerror(errno));
    memset(smb_data_p, 0, sizeof(smb_data_t));	
    rfm_mutex_init(smb_data_p->mutex);
    rfm_cond_init(smb_data_p->signal);
    smb_data_p->xfdir_p = p;
    smb_data_p->view_p = smb_data_p->xfdir_p->view_p;
    g_object_set_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID, smb_data_p);
    
    NOOP(stderr, "THREAD 0x%x condition=0x%x\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
    
	// rodent reload thread enters here.
	// Set initial load items:

	// Create passfile, either from memory data or dialogs
	passfile_double_click(&(view_p->widgets), view_p->en);
	gchar *passfile = g_object_get_data(G_OBJECT(view_p->widgets.paper),
		"passfile");

	NOOP(stderr, "THREAD 0x%x creating query_workgroup thread\n",
		GPOINTER_TO_INT(g_thread_self()));
	void **arg=(void *)malloc(3*sizeof(void *));
	if (!arg) g_error("malloc: %s", strerror(errno));
	arg[0] = &(view_p->widgets);
	arg[1] = smb_data_p->xfdir_p->en->path;
	arg[2] = passfile;
	query_workgroup(arg);
	g_mutex_lock(smb_data_p->mutex);
	if (!smb_data_p->condition){
	    g_cond_wait(smb_data_p->signal, smb_data_p->mutex);
	}
	g_mutex_unlock(smb_data_p->mutex);
	cache_xfdir_setup(smb_data_p);

	rfm_mutex_free(smb_data_p->mutex);
	rfm_cond_free(smb_data_p->signal);
	GSList *list = smb_data_p->list;
	for (;list && list->data; list=list->next) g_free(list->data);
	g_slist_free(smb_data_p->list);
	g_free(smb_data_p);
	g_object_set_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID, NULL);
	return smb_data_p->xfdir_p;
}

// const gchar * 
// This function returns a const pointer to the entry's icon
// identifier. 
// Parameter p is the item's entry pointer. 
// Identifier may be returned as a mimetype or an absolute path.
G_MODULE_EXPORT
void *
item_icon_id (void *p) {
    record_entry_t *en = p;
    if (!en) return "xffm/emblem_broken"; //error
    if (IS_UP_TYPE(en->type)) return "xffm/emblem_network/compositeC/emblem_smb";
    if (en->module && strcmp(en->module, "workgroup")==0 ){
	return "xffm/emblem_network/compositeC/emblem_smb";
    }
    // shares
    return "xffm/emblem_display/compositeC/emblem_smb";
}

// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    passfile_double_click(p, q);

    return GINT_TO_POINTER(FALSE);
}


