
#ifndef _pixmaps_h_
#define _pixmaps_h_

#define CHAR_WIDTH	5
#define CHAR_SPACE	6
#define CHAR_HEIGHT	7

#define SPACE		32
#define DASH		45
#define PERIOD		46
#define ZERO		48
#define PIPE		124

#define PCNT		37
#define GIGS		71
#define MEGS		77
#define KEYS		75

/*
 * Don't use the gimp and friends to edit these.
 *
 * They're xpm's all right, but the char names
 * ".", "c" and "#" are hard coded into salmon.
 */

static char *foreground_xpm[] = {
/* use hex for the colors just in case the names aren't in rgb.txt */
"100 49 3 1",
".	c #303030",		/* gray19 background */
"c	c #8b4c39",		/* salmon4 darker foreground color */
"#	c #ff8c69",		/* salmon1 brighter foreground color */

/* 0 v  1 v  2 v  3 v  4 v  5 v  6 v  7 v  8 v  9 v 10 v 11 v 12 v 13 v 14 v 15 v 16 v 17 v 18 v 19 v */
/*NULL                                    ASC       DEC                                               */
"..........#####..........c###c#####.......#.........#..#....................###.c###c......#........",
"......c#c........#.......#....#...#..#....#...c##.#.#.#.#.........#..........#..#...#c###c#....c##c.",
"......#.#.#...#.#...c#c.#####c#.....###..#.#..#...#...#..#..#...##.#.#....#c###c#...##...#.#...#....",
"......c#c..#.#.######..#.#...##.....###..#.#.c###c.#.#..#.#.#...#.#.#..###.#.#.#######...#c###c###..",
"............#...#...#..#.#.##c#....######...##...#.#.#.#...##...##.#.##.#..c###c#...##...##...##....",
"...........#.#...#..#..#.#....#....######.#.##...#..#..#...#####....#...#....#..#...#.#.#.#...#c##c.",
"..........#...#.....c#c.##....#......#....#..c###c..#..#...##...#.......#...###.c###c#...#c###c.....",

/*20 v 21 v 22 v 23 v 24 v 25 v 26 v 27 v 28 v 29 v 30 v 31 v 32 v 33 v 34 v 35 v 36 v 37 v 38 v 39 v */
/*                                                      aspc  spc   !    "    #    $    %    &    '   */
"......#.#...............................#####.......##.#c#c#.......#...#.#........#..##....c#c...#..",
".....c###c.#.#..#.#..#.#..#.#..#.#.......#......#..#..#c#c#c.......#...#.#..#.#.c###c##..##...#..#..",
"######...#......c#c.......................#..#####.#...#c#c#.......#.......######.#.....#..#.#..c...",
".#.#.#...#c###c#...#c###c#...##...#........#...#..####.c#c#c.......#........#.#.c###c..#....#.......",
".#.#.######...##...##...##...##...#.......#..#####.#...#c#c#.......#.......#####..#.#.#...c#.#......",
".#.#.#...##..###...##...##...##..##......#....#....#...c#c#c................#.#.c###c#..###..##.....",
"c.c..#...#c#c.#c###cc###cc###cc#c.#.....#####.....####.#c#c#.......#..............#.....##c#c.#.....",

/*40 v 41 v 42 v 43 v 44 v 45 v 46 v 47 v 48 v 49 v 50 v 51 v 52 v 53 v 54 v 55 v 56 v 57 v 58 v 59 v */
/* (    )    *    +    ,    -    .    /    0    1    2    3    4    5    6    7   8    9    :    ;    */
"..c#..#c.................................c##c...#..c##c.c##c.#..#.###c.c##c.c##c.c##c.c##c..........",
".c......c.#.#.#..#.....................#.#..#..##.....#....#.#..#.#....#.......#.#..#.#..#..........",
".#......#..c#c...#....................#..#..#...#.....#....#.#..#.#....#.......#.#..#.#..#..##...##.",
".#......#.##c#######......####.......#...#..#...#..c##c.c##c.c###.c##c.###c...#..c##c.c###..........",
".#......#..c#c...#..................#....#..#...#..#.......#....#....#.#..#...#..#..#....#..........",
".c......c.#.#.#..#...c#............#.....#..#...#..#.......#....#....#.#..#..#...#..#....#..##...c#.",
"..c#..#c..............#........##........c##c..###.###c.c##c....#.c##c.c##c..#...c##c.c##c........#.",

/*60 v 61 v 62 v 63 v 64 v 65 v 66 v 67 v 68 v 69 v 70 v 71 v 72 v 73 v 74 v 75 v 76 v 77 v 78 v 79 v */
/* <    =    >    ?    @    A    B    C    D    E    F    G    H    I    J    K    L    M    N    O   */
"...#.......#...c###c.....c###c####cc###c####c##########c###c#...#.###..#####...##....#...##...#c###c",
"..#.........#..#...#c###c#...##...##...##...##....#....#...##...#..#.....#.#..#.#....##.####..##...#",
".#...####....#...c#c#.c.##...##...##....#...##....#....#....#...#..#.....#.#.#..#....#.#.##.#.##...#",
"#.............#..#..#.##c#########c#....#...#####.####.#....#####..#.....#.##...#....#...##.#.##...#",
".#...####....#...#..#....#...##...##....#...##....#....#..#c#...#..#.....#.#.#..#....#...##..###...#",
"..#.........#.......#...##...##...##...##...##....#....#...##...#..#..#..#.#..#.#....#...##...##...#",
"...#.......#.....#..c###c#...#####cc###c####c######....c###c#...#.###.c##c.#...#######...##...#c###c",

/*80 v 81 v 82 v 83 v 84 v 85 v 86 v 87 v 88 v 89 v 90 v 91 v 92 v 93 v 94 v 95 v 96 v 97 v 98 v 99 v */
/* P    Q    R    S    T    U    V    W    X    Y    Z    [    \    ]    ^    _    `    a    b    c   */
"####cc###c####cc###c######...##...##...##...##...######.###.......###...#.........#.......#.........",
"#...##...##...##...#..#..#...##...##...##...##...#....#.#...#.......#..#.#........#.......#.........",
"#...##...##...##......#..#...##...##...#.#.#..#.#....#..#....#......#.#...#........c.c###c#....c###c",
"####c#...#####cc###c..#..#...#.#.#.#...#..#...#.#...#...#.....#.....#................#...#####c#...c",
"#....#.#.##.#......#..#..#...#.#.#.#.#.#.#.#...#...#....#......#....#................#...##...##....",
"#....#..###..#.#...#..#..#...#.#.#.##.###...#..#..#.....#.......#...#................#..###...##...c",
"#....c###c#...#c###c..#..c###c..#..#...##...#..#..#####.###.......###......#####.....c#c.#####cc###c",

/*100v 101v 102v 103v 104v 105v 106v 107v 108v 109v 110v 111v 112v 113v 114v 115v 116v 117v 118v 119v */
/* d    e    f    g    h    i    j    k    l    m    n    o    p    q    r    s    t    u    v    w   */
"....#.......##......#.............##.....##.........................................................",
"....#......#..#.....#......#.......#......#.......................................#.................",
"....#c###c.#...c###c#.............##...#..#..#cc#c#.c#cc###c####cc#####.c#cc###c######...##...##...#",
"c#####...####c.#...##.c#c..#......##..#...#..#.#.###..##...##...##...###..##......#..#...##...##...#",
"#...#####c.#...c######..#..#..c...##.#....#..#.#.##...##...#####cc#####....c###c..#..#...#.#.#.#.#.#",
"#...##.....#.......##...#..#..#...###.#...#..#.#.##...##...##........##........#..#..#..##.#.#.##.##",
"c####c###c.#...c###c#...#..#..c###c#...#.###.#.#.##...#c###c#........##....c###c..#..c#c.#..#..#...#",

/*120v 121v 122v 123v 124v 125v 126v 127v                                                            */
/* x    y    z    {    |    }    ~                                                                   */
".................##...#...##........................................................................",
"................#.....#.....#..#....................................................................",
"#...##...######.#.....#.....#.#.#.##................................................................",
".#.#.#...#...#.#......#......#...#.####.............................................................",
"..#...#.#...#...#.....#.....#......#................................................................",
".#.#...#...#....#.....#.....#.......................................................................",
"#...#..#..#####..##...#...##........................................................................",
};

/*
 * Don't bother trying to get more room here,
 * the wharf will chop it to 64x64 anyway.
 */
static char *background_xpm[] = {
"64 64 2 1",
".	c #303030",
"c	c #8b4c39",
"cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"c..............................................................c",
"cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc",
};

#endif

