.TH salmon 1 "10 July 2004" "Version 1.2.2"
.UC
.SH NAME
\fBsalmon\fP \- a resource utilization monitor
.SH SYNOPSIS
.B salmon
[-\fIv\fP] [-\fIh\fP]
       [-\fIi\fPconic] [-\fIw\fPithdrawn] [-\fIs\fPtandout]
       [-\fIt\fPwelve hour] [-\fIu\fPsed] [-\fI%\fP percent]
       [-\fIk\fPbytes] [-\fIm\fPbytes] [-\fIg\fPbytes]
       [-\fIp\fPosition \fI[+|-]x[+|-]y\fP]
       [-\fIn\fPame \fIname\fP]
       [-\fId\fPisplay \fIname:number\fP]
       [-\fIb\fPackground \fIcolor\fP]
       [-\fIf\fPoreground \fIcolor\fP]
       [-\fIr\fPefresh \fIsec\fP]
       [-\fIo\fPptions]
            [\fI1\fP minute] [\fI5\fP minute] [\fIf\fPifteen minute]
            [\fIm\fPemory] [\fIs\fPwap] [\fIc\fPache] [\fIb\fPuffers] [sh\fIa\fPred]
            [\fIt\fPime] [\fId\fPate] [\fIT\fPime] [\fID\fPate]
            [us\fIe\fPr] [\fIn\fPice] [s\fIy\fPs] [\fIi\fPdle]
            [\fIp\fProcess counts] [\fIu\fPptime] [\fIh\fPost name]
            [\fIo\fPs type] [os \fIv\fPersion] [\fIM\fPoon phase]

.SH DESCRIPTION
\fBSalmon\fP, (\fBs\fP)till (\fBa\fP)nother (\fBl\fP)oad (\fBmon\fP)itor,
is an X11 resource utilization monitor.  It can display the current load
averages, the amount of free or used memory and swap space, memory in cache,
buffers, and shared, the number of running and active processes, the load
split between user, nice, system, and idle, the uptime, the current local
and universal times, the date based on local and universal time, the OS
type, the OS or kernel version, the name of the local host and the phase
of the moon.  The 64x64 pixel applet can be used in the Afterstep Wharf
or the WindowMaker dock, or \fBsalmon\fP can be run in daemon mode to
act as a monitor for a remote server.

The salmon display consists of up to six lines.  The default arrangement is:

    (line #1)	the one minute load average,
    (line #2)	free memory,
    (line #3)	free swap space,
    (line #4)	time since boot,
    (line #5)	local time,

The \fI-f\fPoreground and \fI-b\fPackground colors may be specified
on invocation.  The default foreground colors are (what else) salmon1
(#ff8c69) and salmon4 (#8b4c39).  The colors may be specified by name
or by hex value in the form "#rrbbgg".  The double quotes and hash
mark are required when using hex values, case is ignored.

If not specified on invocation, the \fI-r\fPefresh interval will be
determined by which information lines are to be displayed.  Lines that
are likely to change more rapidly will cause the refresh interval to
be set to one second.  That includes memory amounts, cpu loads and
the local and universal clocks.  The uptime refresh interval defaults
to once per minute, host, os type, dates and moon phase every ten
minutes.  A user specified refresh interval will override the
automatically selected rate.  If specified, the value must be between
1 and 3600 seconds.

The local and universal times are displayed by default in twenty-four
hour format with up to the first three characters of the time zone name
to the right.  The \fI-t\fPwelve switch will cause the local time to be
displayed in twelve hour format, and \fI-T\fPwelve will do the same for
universal time.  If the times are displayed in twelve hour format and the
refresh rate is set slower than once per second, the letters AM or PM as
appropriate will replace the colon and seconds between the time and the
time zone name.  The \fI-y\fPear and \fI-Y\fPear switches will include the
year in the local and universal date formats.  That is, display the date
as [abbreviated month date, year] rather than the default of
[abbreviated day of the week, abbreviated month date].

Free memory and swap space are shown by default in the smallest units
that can be displayed in no more than six digits.  The \fI-u\fPsed
option changes from showing free to used memory and swap, \fI-%\fP
changes the displayed units to percentages.  The \fI-k\fPilo, \fI-m\fPeg
and \fI-g\fPig switches force the minimum units to go no smaller than
requested, they will still change to larger units if required to fit
in the display.

The daemoni\fIz\fPe switch causes \fBsalmon\fP to operate in daemon
mode.  This mode is intended to be used with the \fI-d\fPisplay option
when \fBsalmon\fP is acting as a monitor on a remote server.  \fBSalmon\fP
will daemonize and fork and the child process will wait for its remote
display to become available.  The X server must be set to allow access
to the remote unit using xhost.  If the X display should become
inaccessible, \fBsalmon\fP will fork a new child process which will
then wait until the display returns.

The \fI-n\fPame switch will change the name that \fBsalmon\fP gives
to the X server from the default.  This permits the use of two or
more instances to be used in versions of the Afterstep Wharf that
would otherwise only accept one.  Names that are 50 characters or
longer will be silently ignored.

The \fI-o\fPption switch permits changing the information displayed
and the order of display from the default.  The argument can be
a comma separated or double quoted, space separated list.  The
order of the options selected will determine where they appear
in the display.  The selected lines, up to six, will be spaced evenly
in the display.  Selecting an option more than once will cause an error,
requests for more than six lines are silently ignored.



.SH CONFIGURATION OPTIONS
.IP "-v"
.RS
Print the version of the program.
.RE
.IP "-h"
.RS
Print description and usage message.
.RE
.IP "-i"
.RS
Starts \fBsalmon\fP in the iconized mode.  The icon has the
same appearance as the main window.  When this option is given,
the -p(osition) refers to the position of the icon window as well
as the main window.
.RE
.IP "-w"
.RS
Starts \fBsalmon\fP in the withdrawn mode.  This option is
necessary to be able to dock \fBsalmon\fP in the WindowMaker
dock.  When this option is given, -p(osition) refers to the
position of the icon window as well as the main window.
\fBSalmon\fP ignores the -i(conic) option when started in
withdrawn mode.
.RE
.IP "-s"
.RS
This changes the appearance of \fBsalmon\fP display from
"pushed-in" to "stand-out".  The first is the default look.
The "popped-out" applets look much better in WindowMaker's dock
according to some opinions. Give it a try in any case.
.RE
.IP "-r <seconds>"
.RS
Specify the screen refresh rate in seconds.  The minimum is one
second which is the default for information that may change rapidly.
The maximum rate is one hour or 3600 seconds.
.RE
.IP "-p <[+|-]x[+|-]y>"
.RS
Displays the window at the specified location
on the screen. This works like the standard X Windows
geometry option. (See XParseGeometry (3x)).
.RE
.IP "-n <name>"
.RS
Change the name presented to the X server from the default
\fBsalmon\fP.
.RE
.IP "-d <name:number>"
.RS
The name and number of the X server to open the window in.  It
works like the X Windows display option.  Use this when running
\fBsalmon\fP as a remote server monitor.  It may also be required
with older X library versions.
.RE
.IP "-b <color>"
.RS
Change the color of the background of the applet.
The default color is gray19 (#303030).
.RE
.IP "-f <color>"
.RS
Change the primary foreground color of the applet.  The
default colors are salmon1 (#ff8c69) and salmon4 (#8b4c39).
.RE
.IP "-z"
.RS
Daemonize and display a child process on a specified remote
X server.  Not for use in the Afterstep Wharf.
.RE
.IP "-u"
.RS
By default \fBsalmon\fP displays the amount of free memory
or swap space. This option tells \fBsalmon\fP to display
the amounts of memory and swap space already in use.
.RE
.IP "-%"
.RS
Display memory and swap as percentages.
.RE
.IP "-k"
.RS
Force the memory display in KBytes even if smaller units would
fit into the window.  Applies to memory, swap, shared, buffer
and cache values.
.RE
.IP "-m"
.RS
Force the memory display in MBytes even if smaller units would
fit into the window.
.RE
.IP "-g"
.RS
Force the memory display in GBytes even if smaller units would
fit into the window.
.RE
.IP "-t"
.RS
Display local time in twelve hour format.
.RE
.IP "-T"
.RS
Display universal time in twelve hour format.
.RE
.IP "-y"
.RS
Display year with local date.
.RE
.IP "-Y"
.RS
Display year with universal date.
.RE
.IP "-o <options>"
.RS
Select what information is to be displayed and in what order.
The available options are:
.RE
.IP "1"
.RS
Display the one minute load average.
.RE
.IP "5"
.RS
Display the five minute load average.
.RE
.IP "f"
.RS
Display the fifteen minute load average.
.RE
.IP "m"
.RS
Display the free or used memory.
.RE
.IP "s"
.RS
Display the free or used swap space.
.RE
.IP "a"
.RS
Display the shared memory.
.RE
.IP "b"
.RS
Display the buffer memory.
.RE
.IP "c"
.RS
Display the cache memory.
.RE
.IP "p"
.RS
Display the running and active process counts.
.RE
.IP "u"
.RS
Display time since boot.
.RE
.IP "e"
.RS
Display user cpu percentage.
.RE
.IP "n"
.RS
Display nice cpu percentage.
.RE
.IP "y"
.RS
Display system cpu percentage.
.RE
.IP "i"
.RS
Display idle cpu percentage.
.RE
.IP "t"
.RS
Display the local time.
.RE
.IP "d"
.RS
Display the date based on local time.
.RE
.IP "T"
.RS
Display the universal time.
.RE
.IP "D"
.RS
Display the date based on universal time.
.RE
.IP "h"
.RS
Display the local host name.
.RE
.IP "o"
.RS
Display the operating system type.
.RE
.IP "v"
.RS
Display the operating system or kernel version.
.RE
.IP "M"
.RS
Display the phase of the moon.
.RE
.SH INVOCATION
\fBSalmon\fP can be called in different ways.  The most 
common invocation is the command line:
.nf

	user@host[1]% salmon -b blue -f white &

.fi
Another way to call \fBsalmon\fP is from the window manager:
.nf

	*Wharf "salmon" nil Swallow "salmon" salmon -f "#98FB98" &

.fi
This line, when placed in the \fIwharf\fP file in the user's Afterstep
configuration directory will cause \fBsalmon\fP to be a
button on the \fBWharf(1)\fP button bar under the \fBAfterstep(1)\fP
window manager.

If you run WindowMaker then you should use the "-w(ithdrawn)"
option:
.nf

	user@host[1]% salmon -ws &

.fi
and then drag the icon to the dock.

To use \fBsalmon\fP across a slow link and display the remote host
name and OS type, the phase of the moon, the host uptime and the
local date and time in twelve hour format at a refresh rate of
ten seconds:
.nf

	user@remote-host$ salmon -r 10 -to h,o,M,u,d,t &

.fi
To moniter a remote FreeBSD server with minimum cpu loading and
display the server host name and a summary stochastic analysis
of near term managerial performance probabilities, add this line
to the server's /usr/local/etc/rc.d/guesswork.sh:
.nf

	/usr/X11R6/bin/salmon -zd yourdesktop:0 -p +1+1 -o h,M

.fi
and execute "/usr/X11R6/bin/xhost +remoteservername" in your
desktop startx scripts.
.SH FILES
Linux
.br
.I    /proc/uptime
.br
.I    /proc/loadavg
.br
.I    /proc/stat
.br
.I    /proc/version
.br
.I    /proc/meminfo
.SH BUGS
(1) "Tigr"

My programs do not have bugs, they just develop random
features ;-)

Well, there are limitations. All the strings for the
color names, display name, and the geometry have the
length limit of 50 characters (terminating zero included). 
The string copying routine cuts the names that are longer.

(2) "Tricia"

The characters are hard to read at higher screen resolutions.

The default colors aren't on my list of favorites.  I like
salmon ok, but I prefer it fresh caught and broiled or in sushi.

There are so many options that it should probably be called
\fBemacsalmon\fP.
.SH "SEE ALSO"
.BR pom(6)
.br
Linux
.BR proc(5)
.br
FreeBSD
.BR sysctl(8)
.SH COPYRIGHTS
Copyright (c) 2004 Tricia Kirk <grania@mthoodcards.com>

Distributed under GNU General Public License v2 ; 
see LICENSE and COPYING files for more informations.
.SH AUTHORS
    Albert "Tigr" Dorofeev <albert@tigr.net>
    Tricia Kirk <grania@mthoodcards.com>

See the README file for credits.
.sp
