/*
 * Copyright (c) 1999  Albert Dorofeev <Albert@mail.dma.be>
 * For the updates see http://bewoner.dma.be/Albert/
 *
 * This software is distributed under GPL. For details see LICENSE file.
 */

#ifndef _state_h_
#define _state_h_

struct options {
	int load[3];
	int mem;
	int swap;
	int upt;
	int lct;
	int gmt;
	int host;
	int proc;
	int cache;
	int buffer;
	int share;
	int states[4];
	int date;
	int udate;
	int ostype;
	int version;
	int luna;
};

/* The structure that contains all of the information we collect */
struct meminfo {
	long uptime;			/* time in minutes since boot */
	double total;			/* total memory available */
	double used;			/* the total of used memory */
	double free;			/* free memory */
	double shared;			/* shared memory */
	double buffers;			/* buffers memory */
	double cached;			/* cached memory */
	double swap_total;		/* total swap space */
	double swap_used;		/* used swap space */
	double swap_free;		/* free swap space */
	int procs[2];			/* number of running and active processes */
	float loadavg[3];		/* load average */
	float times[4];			/* cpu times */
	long cur_time;
};

struct salmon_state {
	long refresh;			/* interval (sec) to check the statistics */
	int show_key;			/* display swap and memory in KBytes */
	int show_meg;			/* display swap and memory in MBytes */
	int show_gig;			/* display swap and memory in GBytes */
	int show_used;			/* show used memory and swap instead of free */
	int percent;			/* show memory as percentage instead of amount */
	int twelve;			/* show local time in 12 hour format */
	int utwelve;			/* show universal time in 12 hour format */
	int year;			/* include year in local date display */
	int uyear;			/* include year in universal date display */
	int lines[6];			/* six lines in the display */
	int daemonize;
	char *app_name;
	char osname[12];
	char osvers[12];
	char bgcolor[50];
	char fgcolor[50];
	struct options opt;		/* the data to be displayed */
	struct meminfo last;		/* the old data */
	struct meminfo fresh;		/* the new data */
};

#endif

