/* filelist.h

Copyright (C) 1999-2003 Tom Gilbert.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
imPLIED, INCLUDING BUT NOT LimITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAim, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

//aug 10 2017

Modifactions made by me.
Same permissions are passed on as formentioned pertaining to the
modifactions made by me.
Copyright (C) 2017 - ... Michael Hearas.

*/

#ifndef FILELIST_H
#define FILELIST_H



#include <dirent.h>
#include </usr/include/Imlib2.h>


#ifndef PATH_MAX
#define PATH_MAX 1024
#endif // PATH_MAX

typedef struct TheList mylist;

typedef int (compare_fn) (mylist *name1, mylist *name2);

typedef int (secret_fn) (mylist *secret_name1, mylist *secret_name2);

struct TheList
{
char *filename;
int listcount;
mylist *next;
mylist *prev;
};


enum filelist_recurse { FILELIST_FIRST, FILELIST_CONTINUE, FILELIST_LAST };

void add_2_front(mylist** filelist, char *filename);
void remove_link(mylist** head, char *value_to_remove);
char *get_number_in_list(int numberfile);

void display_list(mylist* head);
char *get_next_name_in_list(void);
char *get_im_name(void);
mylist * list_randomize(mylist * list);
void prepare_filelist(void);
int list_length(mylist * l);
void get_length(void);
void add_file_to_filelist_recursively(char *origpath, unsigned char level);
char *get_absolute_path(char *path);
int check_file_ext(char *name1);

mylist * list_move_down_by_one(mylist * root, mylist * l);
mylist* list_unlink(mylist * root, mylist * l);
mylist * list_add_end(mylist * root, char *filename, int c);
mylist * list_last(mylist * l);




void sort_list(void);
void insertNode(mylist** head, char *filename, int c);
void add_file_count(mylist* filelist);

char *get_file_name(void);
mylist *list_time_jump(mylist *l, int num);
void check_image_err(void);

mylist *list_sort_merge(mylist * l1, mylist * l2 , compare_fn cmp);

int secret_cmp_filename(mylist *file1, mylist *file2);
mylist *secret_list_sort(mylist * list, secret_fn cmp);
mylist *secret_sort_murge(mylist * l1, mylist * l2 , secret_fn cmp);


mylist *list_sort(mylist * list, compare_fn cmp);
int cmp_filename(mylist *file1, mylist *file2);


mylist *  list_bubble_sort(mylist * list);

char *remove_ext (char* mystr, char dot, char sep) ;
char *remove_back(char *front);
char *removeChar( char * string, char letter );

extern mylist* filelist;
extern mylist *current_file;
extern int filelist_len;

#endif

