.TH "XtraScreenHacks" "1" "" "X Version 11" ""
.SH "NAME"
berlinuhr \- the Berlin quantity didactics clock
.SH "SYNOPSIS"
.B berlinuhr
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-size \fInumber\fP]
[\-mono]
[\-fog]
[\-fps]
.SH "DESCRIPTION"
Berlinuhr shows the Berlin Quantity Didactics Clock,
a.k.a. Berlin\-Uhr(R), invented by Dieter Binninger.

The clock shows 24\-hour time. To read it, 
add the numbers represented by the lit lamps:

Each top row lamp (red) represents five hours,
Each second row lamp (red) represents one hour,
Each third row lamp (yellow and red, small)
represents five minutes,
Each bottom row lamp (yellow) represents one minute.

For more information see:

http://www.surveyor.in\-berlin.de/berlin/uhr/indexe.html
http://de.wikipedia.org/wiki/Mengenlehreuhr
.SH "OPTIONS"
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly\-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per\-frame delay, in microseconds.  Default: 50000 (0.05 seconds.).
.TP 8
.B \-mono
Draw the clock in greyscale. 
.TP 8
.B \-size \fInumber\fP
The relative size of the clock in the frame, i.e. how far away it should be. Smaller values mean the clock is smaller (farther away). Legal values are from 0 to 10.  Default: 10.
.TP 8
.B \-fog
Make the clock be darker when it is farther away.
.TP 8
.B \-fps | \-no\-fps
Whether to show a frames\-per\-second display at the bottom of the screen.
.SH "ENVIRONMENT"
.PP 
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
.BR X (1),
.BR xscreensaver (1),
.BR bitmap (1)
.SH "COPYRIGHT"
Copyright \(co 2009 by Kelley Nielsen.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH "AUTHOR"
Kelley Nielsen <shegeek\-dev@comcast.net>
