/* boomerangs.h
 *
 * sets of control points that generate boomerang shapes 
 * for the skylark screen hack
 *
 * by Kelley Nielsen shegeek-dev@comcast.net
 */



#define NPOINTS2 13
#define kStride 4
#define NUMBOOMS 10

int order2 = 5;
int nKnots2 = 18;
GLfloat Knots2[18] = {0, 0, 0, 0, 0,  1, 2, 3, 4, 5, 6, 7, 8, 9, 9, 9, 9, 9};

/* int order2 = 4; */
/* int nKnots2 = 17; */
/* GLfloat Knots2[17] = {0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10}; */

GLfloat pointsWeights2[NUMBOOMS][NPOINTS2][4] = {
{ {0., -0.5, 0., 1.},
  {0.1, -0.5, 0., 1.},
  {0.3, -0.2, 0., 1.},
  {0.4, 0., 0., 1.},


  {0.4, 0.2, 0., 1.},
  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.1, 0.4, 0., 1.},
  {-0.15, 0.2, 0., 1.},
  {0.1, 0., 0., 1.},
  
  {-0.1, -0.3, 0., 1.},
  {-0.2, -0.5, 0., 1.},
  {0., -0.5, 0., 1.}},


/* ==================================== */
/* a skinnier one  #1*/ 

{ {0.29, -0.2, 0., 1.},
  {0.4, 0., 0., 1.},


  {0.4, 0.2, 0., 1.},
  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.1, 0.4, 0., 1.},
  {0.05, 0.2, 0., 1.},
  {0.2, 0., 0., 1.},
  
  {0.1, -0.3, 0., 1.},
  {-0.2, -0.5, 0., 1.},
  {0., -0.5, 0., 1.},
  {0.1, -0.5, 0., 1.},
  {0.29, -0.2, 0., 1.}},



/* ====================================== */
/* a pointed one #2 */
{  {0., -0.5, 0., 1.},
  {0.2, -0.3, 0., 1.},
  {0.3, -0.2, 0., 1.},
  {0.4, 0., 0., 1.},


  {0.4, 0.2, 0., 1.},
  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.1, 0.4, 0., 1.},
  {0.05, 0.2, 0., 1.},
  {0.2, 0., 0., 1.},
  
  {0.1, -0.1, 0., 1.},
  {0.1, -0.3, 0., 1.},
   {0., -0.5, 0., 1.}},

/* ========================================= */
/* a fatter pointed one #3 */
{  {0., -0.5, 0., 1.},
  {0.2, -0.3, 0., 1.},
  {0.3, -0.2, 0., 1.},
  {0.4, 0., 0., 1.},


  {0.4, 0.2, 0., 1.},
  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.2, 0.4, 0., 1.},
  {-0.05, 0.2, 0., 1.},
  {0.1, 0., 0., 1.},
  
  {0., -0.1, 0., 1.},
  {0., -0.3, 0., 1.},
   {0., -0.5, 0., 1.}},

/* ========================================== */
/* an even fatter pointed one (3 pointeds ) #4 */
{  {0., -0.5, 0., 1.},
  {0.2, -0.45, 0., 1.},
  {0.3, -0.3, 0., 1.},
  {0.4, -0.1, 0., 1.},


  {0.4, 0.2, 0., 1.},
  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.2, 0.4, 0., 1.},
  {-0.05, 0.2, 0., 1.},
  {0.1, -0.1, 0., 1.},
  
  {0., -0.2, 0., 1.},
  {0., -0.45, 0., 1.},
   {0., -0.5, 0., 1.}},


/* ================================ */
/* a fat broad one */
{  {0., -0.5, 0., 1.},
  {0.2, -0.5, 0., 1.},
  {0.4, -0.3, 0., 1.},
  {0.5, -0.1, 0., 1.},


  {0.5, 0.2, 0., 1.},
  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.2, 0.4, 0., 1.},
  {-0.05, 0.2, 0., 1.},
  {0.1, -0.1, 0., 1.},
  
  {-0.1, -0.2, 0., 1.},
  {-0.2, -0.5, 0., 1.},
   {0., -0.5, 0., 1.}},

/* ============================ */
/* a kind of average one #6 */ 
{  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.2, 0.4, 0., 1.},
  {0.05, 0.2, 0., 1.},
  {0.2, -0.1, 0., 1.},
  
  {0.0, -0.2, 0., 1.},
  {-0.2, -0.5, 0., 1.},


  {0., -0.5, 0., 1.},
  {0.2, -0.5, 0., 1.},
  {0.4, -0.3, 0., 1.},
  {0.5, -0.1, 0., 1.},


  {0.5, 0.2, 0., 1.},
   {0.2, 0.4, 0., 1.}},


  /*============================= */
/* a deeply curved one #7 */
{  {-0.1, -0.5, 0., 1.},
  {0.1, -0.5, 0., 1.},
  {0.4, -0.3, 0., 1.},
  {0.5, -0.1, 0., 1.},


  {0.5, 0.2, 0., 1.},
  {0.1, 0.4, 0., 1.},
  {-0.1, 0.5, 0., 1.},

  {-0.3, 0.4, 0., 1.},
  {0.05, 0.2, 0., 1.},
  {0.2, -0.1, 0., 1.},
  
  {0.0, -0.2, 0., 1.},
  {-0.3, -0.5, 0., 1.},
   {-0.1, -0.5, 0., 1.}},

/* ================================= */
/* a deeply curved and fat one #8 */
{  {-0.1, -0.5, 0., 1.},
  {0.1, -0.5, 0., 1.},
  {0.4, -0.3, 0., 1.},
  {0.5, -0.1, 0., 1.},


  {0.5, 0.2, 0., 1.},
  {0.1, 0.4, 0., 1.},
  {-0.1, 0.5, 0., 1.},

  {-0.3, 0.4, 0., 1.},
  {-0.05, 0.2, 0., 1.},
  {0.1, -0.1, 0., 1.},
  
  {-0.1, -0.2, 0., 1.},
  {-0.3, -0.5, 0., 1.},
   {-0.1, -0.5, 0., 1.}},



/* ================================== */
/* one with offset tips #9  */
{  {0.2, 0.4, 0., 1.},
  {0., 0.5, 0., 1.},

  {-0.2, 0.4, 0., 1.},
  {0.05, 0.2, 0., 1.},
  {0.2, -0.1, 0., 1.},
  
  {-0.15, -0.2, 0., 1.},
  {-0.35, -0.5, 0., 1.},


  {-0.15, -0.5, 0., 1.},
  {0.05, -0.5, 0., 1.},
  {0.25, -0.3, 0., 1.},
  {0.5, -0.1, 0., 1.},


  {0.5, 0.2, 0., 1.},
   {0.2, 0.4, 0., 1.}},


};




