/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultiMap<K, V>
implements Map<K, Entry<V>> {
    private List<String> names = new ArrayList<String>();
    private TreeMap<K, Entry<V>> map = new TreeMap();

    int getColumns() {
        return this.names.size();
    }

    String getColumnName(int n) {
        return this.names.get(n);
    }

    int addColumn(String string) {
        this.names.add(string);
        return this.names.size() - 1;
    }

    void addColumn(String string, Map<K, V> map) {
        this.addColumn(string, map.entrySet());
    }

    void addColumn(String string, Iterable<Map.Entry<K, V>> iterable) {
        int n = this.addColumn(string);
        for (Map.Entry<K, V> entry : iterable) {
            this.addRow(n, entry.getKey(), entry.getValue());
        }
    }

    void addRow(int n, K k, V v) {
        Entry<V> entry = this.get(k);
        if (entry == null) {
            entry = new Entry<V>(this);
            this.put(k, entry);
        }
        entry.put(n, v);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Entry<V> get(Object object) {
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Entry<V> put(K k, Entry<V> entry) {
        return this.map.put(k, entry);
    }

    @Override
    public Entry<V> remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Entry<V>> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Map.Entry<K, Entry<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Entry<V>> values() {
        return this.map.values();
    }

    public static class Entry<V> {
        private List<V> list;
        private MultiMap<?, ?> table;

        private Entry(MultiMap<?, ?> multiMap) {
            this.table = multiMap;
        }

        V get(int n) {
            return n < this.list.size() ? (V)this.list.get(n) : null;
        }

        int getSize() {
            return this.table.getColumns();
        }

        void put(int n, V v) {
            if (n >= this.table.getColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (this.list == null) {
                this.list = new ArrayList<V>(n);
            }
            if (n < this.list.size()) {
                this.list.set(n, v);
            } else {
                while (n > this.list.size()) {
                    this.list.add(null);
                }
                this.list.add(v);
            }
        }

        boolean allEqual(Comparator<V> comparator) {
            if (this.list.size() == 0) {
                return true;
            }
            int n = this.table.getColumns();
            V v = this.list.get(0);
            for (int i = 1; i < n; ++i) {
                V v2 = this.get(i);
                if (comparator.compare(v2, v) == 0) continue;
                return false;
            }
            return true;
        }
    }
}

