/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

public class AStatus {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int NUM_STATES = 4;
    private final int type;
    private final String reason;
    public static final String EXIT_PREFIX = "STATUS:";
    private static final String[] texts = new String[]{"Passed.", "Failed.", "Error.", "Not run."};
    public static final int[] exitCodes = new int[]{95, 97, 98, 99};
    private static final String ENC_PREFFIX = "<EncodeD>";
    private static final String ENC_SUFFFIX = "</EncodeD>";
    private static final String ENC_SEPARATOR = " ";

    public static AStatus passed(String string) {
        return new AStatus(0, string);
    }

    public static AStatus failed(String string) {
        return new AStatus(1, string);
    }

    public static AStatus error(String string) {
        return new AStatus(2, string);
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public boolean isFailed() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type == 2;
    }

    public boolean isNotRun() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        if (this.reason == null || this.reason.length() == 0) {
            return texts[this.type];
        }
        return texts[this.type] + ENC_SEPARATOR + this.reason;
    }

    public void exit() {
        if (System.err != null) {
            System.err.print(EXIT_PREFIX);
            System.err.print(texts[this.type]);
            System.err.println(AStatus.encode(this.reason));
            System.err.flush();
        }
        System.exit(exitCodes[this.type]);
    }

    public AStatus(int n, String string) throws IllegalArgumentException {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.type = n;
        this.reason = AStatus.normalize(string);
    }

    private static String normalize(String string) {
        char c;
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; bl && i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (bl2 || c != ' ' || i == 0) {
                    bl = false;
                    break;
                }
                bl2 = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            bl = false;
        }
        if (bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                if (stringBuilder.length() <= 0) continue;
                c = '\u0001';
                continue;
            }
            if (c != '\u0000') {
                stringBuilder.append(' ');
            }
            stringBuilder.append(c2);
            c = '\u0000';
        }
        return stringBuilder.toString();
    }

    private static final boolean isPrintable(char c) {
        return ' ' <= c && c < '\u007f';
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (AStatus.isPrintable(string.charAt(i))) continue;
            bl = false;
            break;
        }
        if (bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ENC_PREFFIX);
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(AStatus.encodeChar(string.charAt(i)));
            stringBuilder.append(ENC_SEPARATOR);
        }
        stringBuilder.append(ENC_SUFFFIX);
        return stringBuilder.toString();
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(ENC_PREFFIX);
        if (n < 0 || !string.endsWith(ENC_SUFFFIX)) {
            return string;
        }
        String string2 = string.substring(n + ENC_PREFFIX.length(), string.length() - ENC_SUFFFIX.length());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string, 0, n);
        int n2 = 0;
        int n3 = string2.indexOf(ENC_SEPARATOR);
        while (n3 >= 0) {
            stringBuilder.append(AStatus.decodeChar(string2.substring(n2, n3)));
            n2 = n3 + ENC_SEPARATOR.length();
            n3 = string2.indexOf(ENC_SEPARATOR, n2);
        }
        stringBuilder.append(string2.substring(n2));
        return stringBuilder.toString();
    }

    private static String encodeChar(char c) {
        return Integer.toString(c, 16);
    }

    private static char decodeChar(String string) {
        return (char)Integer.parseInt(string, 16);
    }
}

