/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.NewJavaTestSecurityManager;
import java.io.FileDescriptor;
import java.net.InetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTestSecurityManager
extends SecurityManager {
    private static boolean allowExit = false;
    private static boolean allowPropertiesAccess = Boolean.getBoolean("javatest.security.allowPropertiesAccess");
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public static void install() {
        block6: {
            try {
                if (Boolean.getBoolean("javatest.security.noSecurityManager")) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JT Harness did not install its own Security Manager");
                    System.err.println("because the property javatest.security.noSecurityManager was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    try {
                        Class.forName("java.security.Permission");
                        System.setSecurityManager(new NewJavaTestSecurityManager());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.setSecurityManager(new JavaTestSecurityManager());
                    }
                }
            }
            catch (SecurityException securityException) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof JavaTestSecurityManager) break block6;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JT Harness could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + securityException);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    @Override
    public void checkAccept(String string, int n) {
    }

    @Override
    public void checkAccess(Thread thread) {
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
    }

    @Override
    public void checkConnect(String string, int n) {
    }

    @Override
    public void checkConnect(String string, int n, Object object) {
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkDelete(String string) {
    }

    @Override
    public void checkExec(String string) {
    }

    @Override
    public void checkExit(int n) {
        if (!allowExit) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": System.exit() forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("System.exit() forbidden by JT Harness");
        }
    }

    @Override
    public void checkLink(String string) {
    }

    @Override
    public void checkListen(int n) {
    }

    @Override
    public void checkPackageAccess(String string) {
    }

    @Override
    public void checkPackageDefinition(String string) {
    }

    @Override
    public synchronized void checkPropertiesAccess() {
        if (!allowPropertiesAccess) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": properties access forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Action forbidden by JT Harness: checkPropertiesAccess");
        }
    }

    @Override
    public void checkPropertyAccess(String string) {
    }

    @Override
    public void checkRead(FileDescriptor fileDescriptor) {
    }

    @Override
    public void checkRead(String string) {
    }

    @Override
    public void checkRead(String string, Object object) {
    }

    @Override
    public void checkSetFactory() {
    }

    public boolean checkTopLevelWindow(Object object) {
        return true;
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
    }

    @Override
    public void checkWrite(String string) {
    }

    public void checkAwtEventQueueAccess() {
    }

    public void checkMemberAccess(Class<?> clazz, int n) {
    }

    @Override
    public void checkMulticast(InetAddress inetAddress) {
    }

    @Override
    public void checkMulticast(InetAddress inetAddress, byte by) {
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkSecurityAccess(String string) {
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean setAllowExit(boolean bl) {
        boolean bl2 = allowExit;
        allowExit = bl;
        return bl2;
    }

    public boolean setAllowPropertiesAccess(boolean bl) {
        boolean bl2 = allowPropertiesAccess;
        allowPropertiesAccess = bl;
        return bl2;
    }
}

