/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.util.GraphUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupManager {
    public static final String GROUP_PREFIX = ":";
    public static final String EXCLUDE_PREFIX = "-";
    final PrintWriter out;
    final File root;
    final Map<String, Group> groups = new HashMap<String, Group>();
    private Collection<String> ignoreDirs = Collections.emptySet();
    private Collection<String> allowExtns = Collections.emptySet();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(GroupManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... stringArray) throws Exception {
        File file = new File(stringArray[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        PrintWriter printWriter = new PrintWriter(System.err);
        try {
            GroupManager groupManager = new GroupManager(printWriter, file, arrayList);
            groupManager.setIgnoredDirectories(Arrays.asList("SCCS"));
            groupManager.setAllowedExtensions(Arrays.asList(".java", ".sh", ".html"));
            for (Group group : groupManager.groups.values()) {
                System.err.println(group.name + ": " + group.getFiles());
            }
        }
        finally {
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupManager(PrintWriter printWriter, File file, List<String> list) throws IOException {
        this.out = printWriter;
        this.root = file;
        for (String string : list) {
            FileInputStream fileInputStream;
            boolean bl;
            if (string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
                bl = true;
            } else {
                bl = false;
            }
            File file2 = new File(file, string);
            try {
                fileInputStream = new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) continue;
                throw fileNotFoundException;
            }
            try {
                Properties properties = new Properties();
                properties.load(new BufferedInputStream(fileInputStream));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string2 = (String)entry.getKey();
                    String string3 = (String)entry.getValue();
                    Group group = this.getGroup(string2);
                    group.addEntry(new Entry(file2, file, string3));
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        this.validate();
    }

    void setAllowedExtensions(Collection<String> collection) {
        this.allowExtns = new HashSet<String>(collection);
    }

    void setIgnoredDirectories(Collection<String> collection) {
        this.ignoreDirs = new HashSet<String>(collection);
    }

    public Set<File> getFiles(String string) throws InvalidGroup {
        Group group = this.getGroup(string);
        if (group.invalid) {
            throw new InvalidGroup();
        }
        return group.getFiles();
    }

    private Group getGroup(String string) {
        Group group = this.groups.get(string);
        if (group == null) {
            group = new Group(string);
            this.groups.put(string, group);
        }
        return group;
    }

    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    public boolean invalid() {
        return this.groups.values().stream().anyMatch(group -> group.invalid);
    }

    private void validate() {
        Object object;
        for (Group set2 : this.groups.values()) {
            if (!set2.name.matches("(?i)[a-z][a-z0-9_]*")) {
                this.error(set2, i18n.getString("gm.invalid.name.for.group"));
            }
            for (Entry entry : set2.entries) {
                object = Arrays.asList(entry.includeFiles, entry.excludeFiles);
                Iterator<Object> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Set set = iterator.next();
                    for (File file : set) {
                        if (file.exists()) continue;
                        URI uRI = this.root.toURI().relativize(file.toURI());
                        this.error(entry.origin, set2, i18n.getString("gm.file.not.found", (Object)uRI.getPath()));
                    }
                }
                for (Group group : entry.includeGroups) {
                    if (group.isEmpty()) {
                        this.error(entry.origin, set2, i18n.getString("gm.group.not.found", (Object)group.name));
                    }
                    if (group != set2) continue;
                    this.error(entry.origin, set2, i18n.getString("gm.group.includes.itself"));
                }
            }
        }
        final HashMap hashMap = new HashMap();
        for (Group group : this.groups.values()) {
            hashMap.put(group, new GraphUtils.TarjanNode<Group>(group){

                @Override
                public Iterable<? extends GraphUtils.TarjanNode<Group>> getDependencies() {
                    ArrayList arrayList = new ArrayList();
                    for (Entry entry : ((Group)this.data).entries) {
                        for (Group group : entry.includeGroups) {
                            arrayList.add(hashMap.get(group));
                        }
                    }
                    return arrayList;
                }

                @Override
                public String printDependency(GraphUtils.Node<Group> node) {
                    return ((Group)node.data).name;
                }
            });
        }
        Set set = GraphUtils.tarjan(hashMap.values());
        for (Set set2 : set) {
            if (set2.size() <= 1) continue;
            object = set2.stream().map(tarjanNode -> ((Group)tarjanNode.data).name).collect(Collectors.joining(", "));
            set2.stream().map(tarjanNode -> (Group)tarjanNode.data).forEach(arg_0 -> this.lambda$validate$3((String)object, arg_0));
        }
    }

    private void error(Group group, String string) {
        if (group.entries.isEmpty()) {
            this.out.println(i18n.getString("gm.group.prefix", group.name, string));
            group.invalid = true;
        } else {
            this.error(group.entries.get((int)0).origin, group, string);
        }
    }

    private void error(File file, Group group, String string) {
        this.out.println(i18n.getString("gm.file.group.prefix", file, group.name, string));
        group.invalid = true;
    }

    private /* synthetic */ void lambda$validate$3(String string, Group group) {
        this.error(group, i18n.getString("gm.cycle.detected", (Object)string));
    }

    class Entry {
        final File origin;
        final Set<File> includeFiles = new LinkedHashSet<File>();
        final Set<File> excludeFiles = new LinkedHashSet<File>();
        final Set<Group> includeGroups = new LinkedHashSet<Group>();
        final Set<Group> excludeGroups = new LinkedHashSet<Group>();

        Entry(File file, File file2, String string) {
            this.origin = file;
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            for (String string2 : string.split("\\s+")) {
                String string3;
                boolean bl = string2.startsWith(GroupManager.EXCLUDE_PREFIX);
                if (bl) {
                    string2 = string2.substring(1);
                }
                if (string2.startsWith(GroupManager.GROUP_PREFIX)) {
                    string3 = string2.substring(1);
                    (bl ? this.excludeGroups : this.includeGroups).add(GroupManager.this.getGroup(string3));
                    continue;
                }
                string3 = string2;
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                File file3 = string3.equals("") ? file2 : new File(file2, string3);
                (bl ? this.excludeFiles : this.includeFiles).add(file3);
            }
        }

        public String toString() {
            return "Entry[origin:" + this.origin + "inclFiles:" + this.includeFiles + ",exclFiles:" + this.excludeFiles + ",inclGroups:" + this.includeGroups + ",exclGroups:" + this.excludeGroups + "]";
        }
    }

    private class Group {
        final String name;
        final List<Entry> entries;
        private Set<File> files;
        boolean invalid;

        Group(String string) {
            this.name = string;
            this.entries = new ArrayList<Entry>();
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        void addEntry(Entry entry) {
            this.entries.add(entry);
        }

        Set<File> getFiles() {
            if (this.files == null) {
                this.files = new LinkedHashSet<File>();
                HashSet<File> hashSet = new HashSet<File>();
                HashSet<File> hashSet2 = new HashSet<File>();
                for (Entry entry : this.entries) {
                    hashSet.addAll(entry.includeFiles);
                    for (Group group : entry.includeGroups) {
                        hashSet.addAll(group.getFiles());
                    }
                    hashSet2.addAll(entry.excludeFiles);
                    for (Group group : entry.excludeGroups) {
                        hashSet2.addAll(group.getFiles());
                    }
                }
                this.addFiles(this.files, hashSet, hashSet2);
            }
            return this.files;
        }

        private void addFiles(Collection<File> collection, Collection<File> collection2, Collection<File> collection3) {
            for (File file : collection2) {
                if (this.contains(collection, file) || this.contains(collection3, file)) continue;
                if (file.isFile()) {
                    this.addFile(collection, file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                Set<File> set = this.filter(file, collection3);
                if (set.isEmpty()) {
                    this.addFile(collection, file);
                    continue;
                }
                this.addFiles(collection, this.list(file), set);
            }
        }

        private void addFile(Collection<File> collection, File file) {
            Iterator<File> iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (!this.contains(file, file2)) continue;
                iterator.remove();
            }
            collection.add(file);
        }

        private boolean contains(Collection<File> collection, File file) {
            for (File file2 : collection) {
                if (!file2.equals(file) && !this.contains(file2, file)) continue;
                return true;
            }
            return false;
        }

        private boolean contains(File file, File file2) {
            String string = file.getPath();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            return file2.getPath().startsWith(string);
        }

        private Set<File> filter(File file, Collection<File> collection) {
            LinkedHashSet<File> linkedHashSet = null;
            String string = file.getPath();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            for (File file2 : collection) {
                String string2 = file2.getPath();
                if (!string2.startsWith(string)) continue;
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<File>();
                }
                linkedHashSet.add(file2);
            }
            return linkedHashSet == null ? Collections.emptySet() : linkedHashSet;
        }

        private List<File> list(File file) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file2 : file.listFiles()) {
                String string = file2.getName();
                if ((!file2.isDirectory() || GroupManager.this.ignoreDirs.contains(string)) && (!file2.isFile() || !GroupManager.this.allowExtns.contains(this.getExtension(string)))) continue;
                arrayList.add(file2);
            }
            return arrayList;
        }

        private String getExtension(String string) {
            int n = string.lastIndexOf(".");
            return n == -1 ? null : string.substring(n);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class InvalidGroup
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

