/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class Locations {
    private final RegressionTestSuite testSuite;
    private final Set<String> systemModules;
    private final SearchPath jtpath;
    private final JDK testJDK;
    private final File absTestFile;
    private final File absBaseSrcDir;
    private final File absTestSrcDir;
    private final File absBaseClsDir;
    private final File absTestClsDir;
    private final File absTestPatchDir;
    private final File absTestModulesDir;
    private final File absTestWorkDir;
    private final String relLibDir;
    private final List<LibLocn> libList;
    private static final String[] extns = new String[]{".java", ".jasm", ".jcod"};
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> uniqueNum = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return uniqueId.getAndIncrement();
        }
    };
    public static final String CANT_FIND_CLASS = "Can't find source for class: ";
    public static final String LIB_LIST = " in directory-list: ";
    public static final String PATH_TESTCLASS = "Unable to locate test class directory!?";
    public static final String CANT_FIND_LIB = "Can't find library: ";
    public static final String BAD_LIB = "Bad file for library: ";
    public static final String BAD_FILE_IN_LIB = "Bad file in library: ";
    public static final String MIXED_LIB = "Can't mix packages, user modules, and patches for system module in library: ";

    public Locations(RegressionParameters regressionParameters, TestDescription testDescription, Consumer<String> consumer) throws Fault {
        this.testSuite = regressionParameters.getTestSuite();
        this.systemModules = regressionParameters.getTestJDK().getSystemModules(regressionParameters, consumer);
        this.jtpath = regressionParameters.getJavaTestClassPath();
        this.testJDK = regressionParameters.getTestJDK();
        Version version = this.testSuite.getRequiredVersion();
        boolean bl = version.version != null && version.compareTo(new Version("4.2 b08")) >= 0;
        this.absTestFile = testDescription.getFile().getAbsoluteFile();
        File file = testDescription.getRootRelativeFile();
        String string = file.getParent();
        if (string == null) {
            string = "";
        }
        String string2 = file.getName();
        String string3 = testDescription.getId();
        String string4 = string2.replaceAll("(?i)\\.[a-z]+$", (string3 == null ? "" : "_" + string3) + ".d");
        String string5 = testDescription.getParameter("packageRoot");
        this.relLibDir = string5 != null ? string5 : string;
        String string6 = this.relLibDir;
        this.absBaseSrcDir = regressionParameters.getTestSuite().getRootDir();
        this.absTestSrcDir = new File(this.absBaseSrcDir, string6);
        File file2 = new File(string, string4);
        this.absTestWorkDir = regressionParameters.getWorkDirectory().getFile(file2.getPath());
        this.absBaseClsDir = this.getThreadSafeDir(regressionParameters.getWorkDirectory().getFile("classes"), regressionParameters.getConcurrency());
        String string7 = string5 != null ? string5 : (bl ? new File(string, string4).getPath() : string);
        this.absTestClsDir = new File(this.absBaseClsDir, string7);
        this.absTestPatchDir = new File(this.absTestClsDir, "patches");
        this.absTestModulesDir = new File(this.absTestClsDir, "modules");
        this.libList = new ArrayList<LibLocn>();
        String string8 = testDescription.getParameter("library");
        for (String string9 : StringUtils.splitWS(string8)) {
            this.libList.add(this.getLibLocn(testDescription, string9));
        }
    }

    public List<LibLocn> getLibs() {
        return this.libList;
    }

    private LibLocn getLibLocn(TestDescription testDescription, String string) throws Fault {
        if (string.startsWith("/")) {
            String string2 = string.substring(1);
            this.checkLibPath(string2);
            if (new File(this.absBaseSrcDir, string2).exists()) {
                return this.createLibLocn(string, this.absBaseSrcDir, this.absBaseClsDir);
            }
            try {
                for (File file : this.testSuite.getExternalLibRoots(testDescription)) {
                    if (!new File(file, string2).exists()) continue;
                    return this.createLibLocn(string, file, this.absBaseClsDir);
                }
            }
            catch (TestSuite.Fault fault) {
                throw new Fault(CANT_FIND_LIB + fault);
            }
        } else if (string.startsWith("${") && string.endsWith(".jar")) {
            int n = string.indexOf("}/");
            if (n != -1) {
                String string3;
                File file;
                String string4 = string.substring(2, n);
                File file2 = null;
                if (string4.equals("java.home")) {
                    file2 = this.testJDK.getAbsoluteFile();
                } else if (string4.equals("jtreg.home")) {
                    file2 = this.jtpath.asList().get(0).getParentFile().getParentFile();
                }
                if (file2 != null && (file = new File(file2, string3 = string.substring(n + 2))).exists()) {
                    return new LibLocn(string, null, file, LibLocn.Kind.PRECOMPILED_JAR);
                }
            }
        } else {
            this.checkLibPath(this.relLibDir.replace(File.separatorChar, '/') + "/" + string);
            if (new File(this.absTestSrcDir, string).exists()) {
                return this.createLibLocn(string, this.absTestSrcDir, new File(this.absBaseClsDir, this.relLibDir));
            }
        }
        throw new Fault(CANT_FIND_LIB + string);
    }

    private void checkLibPath(String string) throws Fault {
        try {
            String string2 = new URI(string).normalize().toString();
            if (string2.equals("..") || string2.startsWith("../")) {
                throw new Fault("effective library path is outside the test suite: " + string2);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Fault("invalid library path: " + string);
        }
    }

    private LibLocn createLibLocn(String string, File file, File file2) throws Fault {
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        File file3 = Locations.normalize(new File(file, string2));
        if (file3.isFile() && file3.getName().endsWith(".jar")) {
            return new LibLocn(string, null, file3, LibLocn.Kind.PRECOMPILED_JAR);
        }
        if (!file3.isDirectory()) {
            throw new Fault(BAD_LIB + string);
        }
        File file4 = file3;
        File file5 = Locations.normalize(new File(file2, string));
        LibLocn.Kind kind = this.getDirKind(file4);
        return new LibLocn(string, file4, file5, kind);
    }

    public Set<LibLocn.Kind> getDirKinds(File file) {
        EnumSet<LibLocn.Kind> enumSet = EnumSet.noneOf(LibLocn.Kind.class);
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            if (this.isSystemModule(file2.getName())) {
                enumSet.add(LibLocn.Kind.SYS_MODULE);
                continue;
            }
            if (new File(file2, "module-info.java").exists()) {
                enumSet.add(LibLocn.Kind.USER_MODULE);
                continue;
            }
            enumSet.add(LibLocn.Kind.PACKAGE);
        }
        return enumSet;
    }

    public LibLocn.Kind getDirKind(File file) throws Fault {
        Set<LibLocn.Kind> set = this.getDirKinds(file);
        switch (set.size()) {
            case 0: {
                return LibLocn.Kind.PACKAGE;
            }
            case 1: {
                return set.iterator().next();
            }
        }
        throw new Fault(MIXED_LIB + file);
    }

    boolean isSystemModule(String string) {
        return this.systemModules != null && this.systemModules.contains(string);
    }

    public File absTestFile() {
        return this.absTestFile;
    }

    public File absTestSrcDir() {
        return this.absTestSrcDir;
    }

    public File absTestSrcDir(String string) {
        return this.getFile(this.absTestSrcDir, string);
    }

    public File absTestSrcFile(String string, File file) {
        if (file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return this.getFile(this.absTestSrcDir, string, file.getPath());
    }

    public List<File> absTestSrcPath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.absTestSrcDir);
        for (LibLocn libLocn : this.libList) {
            if (libLocn.kind != LibLocn.Kind.PACKAGE) continue;
            arrayList.add(libLocn.absSrcDir);
        }
        return arrayList;
    }

    public List<File> absLibSrcList(LibLocn.Kind kind) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (LibLocn libLocn : this.libList) {
            if (libLocn.kind != kind) continue;
            arrayList.add(libLocn.absSrcDir);
        }
        return arrayList;
    }

    public List<File> absLibSrcJarList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (LibLocn libLocn : this.libList) {
            File file;
            if (libLocn.kind != LibLocn.Kind.PRECOMPILED_JAR || !(file = libLocn.absClsDir).isFile() || !file.getName().endsWith(".jar") || !file.exists()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public File absBaseClsDir() {
        return this.absBaseClsDir;
    }

    public File absTestClsDir() {
        return this.absTestClsDir;
    }

    public File absTestClsDir(String string) {
        if (string == null) {
            return this.absTestClsDir;
        }
        if (this.isSystemModule(string)) {
            return new File(this.absTestPatchDir(), string);
        }
        return new File(this.absTestModulesDir(), string);
    }

    public List<File> absTestClsPath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.absTestClsDir);
        for (LibLocn libLocn : this.libList) {
            switch (libLocn.kind) {
                case PACKAGE: 
                case PRECOMPILED_JAR: {
                    arrayList.add(libLocn.absClsDir);
                }
            }
        }
        return arrayList;
    }

    public List<File> absLibClsList(LibLocn.Kind kind) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (LibLocn libLocn : this.libList) {
            if (libLocn.kind != kind) continue;
            arrayList.add(libLocn.absClsDir);
        }
        return arrayList;
    }

    public File absTestWorkFile(String string) {
        return new File(this.absTestWorkDir, string);
    }

    public File absTestModulesDir() {
        return this.absTestModulesDir;
    }

    public File absTestPatchDir() {
        return this.absTestPatchDir;
    }

    public List<ClassLocn> locateClasses(String string) throws Fault {
        ArrayList<LibLocn> arrayList;
        List<Object> list;
        String string2;
        String string3;
        int n = string.indexOf("/");
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            list = this.getModuleLocn(string3);
            if (list.isEmpty()) {
                throw new Fault("can't find module " + string3 + " in test directory or libraries");
            }
            arrayList = list;
        } else {
            string3 = null;
            string2 = string;
            arrayList = new ArrayList<LibLocn>();
            arrayList.add(new LibLocn(null, this.absTestSrcDir, this.absTestClsDir, LibLocn.Kind.PACKAGE));
            for (LibLocn object : this.libList) {
                if (object.kind != LibLocn.Kind.PACKAGE) continue;
                arrayList.add(object);
            }
        }
        if (string2.equals("*")) {
            list = this.locateClassesInPackage(arrayList, string3, null);
        } else if (string2.endsWith(".*")) {
            String string4 = string2.substring(0, string2.length() - 2);
            list = this.locateClassesInPackage(arrayList, string3, string4);
        } else {
            list = this.locateClass(arrayList, string3, string2);
        }
        if (list.isEmpty()) {
            if (string3 == null) {
                throw new Fault("can't find " + string2 + " in test directory or libraries");
            }
            throw new Fault("can't find " + string2 + " in module " + string3 + " in " + ((LibLocn)arrayList.get((int)0)).absSrcDir);
        }
        return list;
    }

    List<LibLocn> getModuleLocn(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.isSystemModule(string)) {
            ArrayList<LibLocn> arrayList = new ArrayList<LibLocn>();
            if (this.getFile(this.absTestSrcDir, string).exists()) {
                arrayList.add(new LibLocn(null, this.absTestSrcDir, this.absTestPatchDir(), LibLocn.Kind.SYS_MODULE));
            }
            for (LibLocn libLocn : this.libList) {
                if (libLocn.kind != LibLocn.Kind.SYS_MODULE || !this.getFile(libLocn.absSrcDir, string).exists()) continue;
                arrayList.add(libLocn);
            }
            return arrayList;
        }
        if (this.getFile(this.absTestSrcDir, string).exists()) {
            return Collections.singletonList(new LibLocn(null, this.absTestSrcDir, this.absTestModulesDir(), LibLocn.Kind.USER_MODULE));
        }
        for (LibLocn libLocn : this.libList) {
            if (libLocn.kind != LibLocn.Kind.USER_MODULE || !this.getFile(libLocn.absSrcDir, string).exists()) continue;
            return Collections.singletonList(libLocn);
        }
        return Collections.emptyList();
    }

    private List<ClassLocn> locateClass(List<LibLocn> list, String string, String string2) {
        for (LibLocn libLocn : list) {
            ClassLocn classLocn = this.locateClass(libLocn, string, string2);
            if (classLocn == null) continue;
            return Collections.singletonList(classLocn);
        }
        return Collections.emptyList();
    }

    private ClassLocn locateClass(LibLocn libLocn, String string, String string2) {
        for (String string3 : extns) {
            String string4;
            int n;
            String string5 = string2.replace('.', File.separatorChar) + string3;
            String string6 = string2.replace('.', File.separatorChar) + ".class";
            File file = this.getFile(libLocn.absSrcDir, string, string5);
            if (file.exists()) {
                File file2 = this.getFile(libLocn.absClsDir, string, string6);
                return new ClassLocn(libLocn, string, string2, file, file2);
            }
            if (libLocn.name != null || string != null || (n = string5.lastIndexOf(File.separatorChar)) < 0 || !(file = new File(this.absTestSrcDir, string4 = string5.substring(n + 1))).exists()) continue;
            File file3 = new File(this.absTestClsDir, string6);
            return new ClassLocn(libLocn, null, string2, file, file3);
        }
        return null;
    }

    private List<ClassLocn> locateClassesInPackage(List<LibLocn> list, String string, String string2) throws Fault {
        ArrayList<ClassLocn> arrayList = new ArrayList<ClassLocn>();
        boolean bl = string != null && string2 == null;
        for (LibLocn libLocn : list) {
            this.locateClassesInPackage(libLocn, string, string2, bl, arrayList);
        }
        return arrayList;
    }

    private void locateClassesInPackage(LibLocn libLocn, String string, String string2, boolean bl, List<ClassLocn> list) throws Fault {
        File file;
        File file2;
        if (string2 == null) {
            file2 = this.getFile(libLocn.absSrcDir, string);
            file = this.getFile(libLocn.absClsDir, string);
        } else {
            File[] fileArray = string2.replace('.', File.separatorChar);
            file2 = this.getFile(libLocn.absSrcDir, string, (String)fileArray);
            file = this.getFile(libLocn.absClsDir, string, (String)fileArray);
        }
        if (!file2.isDirectory()) {
            return;
        }
        for (File file3 : file2.listFiles()) {
            String string3;
            String string4 = file3.getName();
            if (file3.isDirectory()) {
                if (!bl) continue;
                string3 = string2 == null ? string4 : string2 + "." + string4;
                this.locateClassesInPackage(libLocn, string, string3, true, list);
                continue;
            }
            if (!file3.isFile() || !this.hasExtn(string4, extns)) continue;
            string3 = string4.substring(0, string4.lastIndexOf("."));
            String string5 = string2 == null ? string3 : string2 + "." + string3;
            File file4 = new File(file, string3 + ".class");
            list.add(new ClassLocn(libLocn, string, string5, file3, file4));
        }
    }

    private File getFile(File file, String string) {
        return string == null ? file : new File(file, string);
    }

    private File getFile(File file, String string, String string2) {
        return new File(this.getFile(file, string), string2);
    }

    private static File normalize(File file) {
        return new File(file.toURI().normalize());
    }

    private boolean hasExtn(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private File getThreadSafeDir(File file, int n) {
        return n == 1 ? file : new File(file, String.valueOf(Locations.getCurrentThreadId()));
    }

    private static int getCurrentThreadId() {
        return uniqueNum.get();
    }

    public static class ClassLocn {
        public final LibLocn lib;
        public final String optModule;
        public final String className;
        public final File absSrcFile;
        public final File absClsFile;

        ClassLocn(LibLocn libLocn, String string, String string2, File file, File file2) {
            this.lib = libLocn;
            this.optModule = string;
            this.className = string2;
            this.absSrcFile = file;
            this.absClsFile = file2;
        }

        public boolean isUpToDate() {
            return this.absClsFile.exists() && this.absClsFile.canRead() && this.absClsFile.lastModified() > this.absSrcFile.lastModified();
        }

        public String toString() {
            return "ClassLocn(" + this.lib.name + "," + this.optModule + "," + this.className + "," + this.absSrcFile + "," + this.absClsFile + ")";
        }
    }

    public static class LibLocn {
        public final String name;
        public final File absSrcDir;
        public final File absClsDir;
        public final Kind kind;

        LibLocn(String string, File file, File file2, Kind kind) {
            this.name = string;
            this.absSrcDir = file;
            this.absClsDir = file2;
            this.kind = kind;
        }

        public boolean equals(Object object) {
            if (object instanceof LibLocn) {
                LibLocn libLocn = (LibLocn)object;
                return this.name == null ? libLocn.name == null : this.name.equals(libLocn.name) && this.absSrcDir.equals(libLocn.absSrcDir) && this.absClsDir.equals(libLocn.absClsDir) && this.kind == libLocn.kind;
            }
            return false;
        }

        public int hashCode() {
            return ((this.name == null ? 0 : this.name.hashCode()) << 7) + (this.absSrcDir.hashCode() << 5) + (this.absClsDir.hashCode() << 3) + this.kind.hashCode();
        }

        public String toString() {
            return "LibLocn(" + this.name + ",src:" + this.absSrcDir + ",cls:" + this.absClsDir + "," + (Object)((Object)this.kind) + ")";
        }

        public static enum Kind {
            PACKAGE,
            PRECOMPILED_JAR,
            SYS_MODULE,
            USER_MODULE;

        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Fault(String string) {
            super(string);
        }
    }
}

