/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.CachingTestFilter;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.IgnoreKind;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.RegressionContext;
import com.sun.javatest.regtest.config.RegressionEnvironment;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.exec.TimeoutHandlerProvider;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class RegressionParameters
extends BasicInterviewParameters
implements Parameters.EnvParameters {
    private final Consumer<String> logger;
    public Map<String, String> filterFaults = new HashMap<String, String>();
    private Expr.Context exprContext;
    TestFilter relevantTestFilter = UNSET;
    private CachingTestFilter excludeListFilter = UNSET;
    private TestFilter matchListFilter = UNSET;
    private KeywordsTestFilter keywordsFilter = UNSET_KEYWORDS_FILTER;
    private static final CachingTestFilter UNSET = new CachingTestFilter("", "", ""){

        @Override
        public String getCacheKey(TestDescription testDescription) {
            throw new IllegalStateException();
        }

        @Override
        public boolean getCacheableValue(TestDescription testDescription) {
            throw new IllegalStateException();
        }
    };
    private static KeywordsTestFilter UNSET_KEYWORDS_FILTER = new KeywordsTestFilter(UNSET);
    private CachingTestFilter priorStatusFilter = UNSET;
    private static final String ENVVARS = ".envVars";
    private static final String CHECK = ".check";
    private static final String COMPILE_JDK = ".compilejdk";
    private static final String TEST_JDK = ".testjdk";
    private static final String EXEC_MODE = ".execMode";
    private static final String TEST_VM_OPTIONS = ".testVMOpts";
    private static final String TEST_COMPILER_OPTIONS = ".testCompilerOpts";
    private static final String TEST_JAVA_OPTIONS = ".testJavaOpts";
    private static final String IGNORE = ".ignore";
    private static final String RETAIN_ARGS = ".retain";
    private static final String JUNIT = ".junit";
    private static final String TESTNG = ".testng";
    private static final String ASMTOOLS = ".asmtools";
    private static final String TIMELIMIT = ".timeLimit";
    private static final String REPORTDIR = ".reportDir";
    private static final String EXCLUSIVE_LOCK = ".exclLock";
    private static final String NATIVEDIR = ".nativeDir";
    private static final String TIMEOUT_HANDLER = ".timeoutHandler";
    private static final String TIMEOUT_HANDLER_PATH = ".timeoutHandlerPath";
    private static final String TIMEOUT_HANDLER_TIMEOUT = ".timeoutHandlerTimeout";
    private Map<String, String> envVars;
    private boolean check;
    ExecMode execMode;
    IgnoreKind ignoreKind = IgnoreKind.ERROR;
    int timeLimit;
    private JDK compileJDK;
    private JDK testJDK;
    private SearchPath junitPath;
    private SearchPath testngPath;
    private SearchPath asmToolsPath;
    private SearchPath javaTestClassPath;
    private List<String> testVMOpts;
    private List<String> testCompilerOpts;
    private List<String> testJavaOpts;
    private List<String> testDebugOpts;
    private File reportDir;
    private File exclusiveLock;
    private File nativeDir;
    private String timeoutHandlerClassName;
    private List<File> timeoutHandlerPath;
    private long timeoutHandlerTimeout;
    private List<File> matchLists;
    private boolean useWindowsSubsystemForLinux;
    private static Pattern UNSET_PATTERN = Pattern.compile("");
    private Pattern refIgnoreLinesPattern = UNSET_PATTERN;
    private TimeoutHandlerProvider timeoutHandlerProvider;
    private Map<String, String> basicTestProperties;
    private List<String> retainArgs;
    private final Set<Integer> retainStatusSet = new HashSet<Integer>(4);
    private Pattern retainFilesPattern;

    public RegressionParameters(String string, RegressionTestSuite regressionTestSuite, Consumer<String> consumer) throws Interview.Fault {
        super(string, regressionTestSuite);
        this.logger = consumer;
        this.setTitle("jtreg Configuration Editor");
        this.setEdited(false);
    }

    @Override
    public RegressionTestSuite getTestSuite() {
        return (RegressionTestSuite)super.getTestSuite();
    }

    public void setTests(Collection<String> collection) {
        this.setTests(collection == null ? null : collection.toArray(new String[collection.size()]));
    }

    public void setTests(String[] stringArray) {
        Parameters.MutableTestsParameters mutableTestsParameters = (Parameters.MutableTestsParameters)this.getTestsParameters();
        mutableTestsParameters.setTests(stringArray);
    }

    public void setKeywordsExpr(String string) {
        Parameters.MutableKeywordsParameters mutableKeywordsParameters = (Parameters.MutableKeywordsParameters)this.getKeywordsParameters();
        mutableKeywordsParameters.setKeywords(3, string);
    }

    @Override
    protected int getMaxConcurrency() {
        return 256;
    }

    public void setConcurrency(int n) {
        Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)this.getConcurrencyParameters();
        mutableConcurrencyParameters.setConcurrency(n);
    }

    public void setTimeoutFactor(float f) {
        Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)this.getTimeoutFactorParameters();
        mutableTimeoutFactorParameters.setTimeoutFactor(f);
    }

    public void setExcludeLists(File[] fileArray) {
        Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)this.getExcludeListParameters();
        mutableExcludeListParameters.setExcludeFiles(fileArray);
    }

    public void setPriorStatusValues(boolean[] blArray) {
        Parameters.MutablePriorStatusParameters mutablePriorStatusParameters = (Parameters.MutablePriorStatusParameters)this.getPriorStatusParameters();
        mutablePriorStatusParameters.setPriorStatusValues(blArray);
    }

    @Override
    public TestEnvironment getEnv() {
        try {
            return new RegressionEnvironment(this);
        }
        catch (TestEnvironment.Fault fault) {
            return null;
        }
    }

    @Override
    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    @Override
    protected Question getEnvFirstQuestion() {
        return this.getEnvSuccessorQuestion();
    }

    public void initExprContext() throws JDK.Fault {
        this.exprContext = new RegressionContext(this, this.logger);
    }

    public Expr.Context getExprContext() {
        return this.exprContext;
    }

    @Override
    public TestFilter getRelevantTestFilter() {
        if (this.relevantTestFilter == UNSET) {
            TestFilter testFilter;
            ArrayList<TestFilter> arrayList = new ArrayList<TestFilter>();
            TestFilter testFilter2 = this.getModulesFilter();
            if (testFilter2 != null) {
                arrayList.add(testFilter2);
            }
            TestFilter testFilter3 = this.getRequiresFilter();
            arrayList.add(testFilter3);
            TestFilter testFilter4 = this.getTimeLimitFilter();
            if (testFilter4 != null) {
                arrayList.add(testFilter4);
            }
            if ((testFilter = this.getMatchListFilter()) != null) {
                arrayList.add(testFilter);
            }
            final CompositeFilter compositeFilter = new CompositeFilter(arrayList.toArray(new TestFilter[arrayList.size()]));
            return new CachingTestFilter(((TestFilter)compositeFilter).getName(), ((TestFilter)compositeFilter).getDescription(), ((TestFilter)compositeFilter).getReason()){

                @Override
                protected String getCacheKey(TestDescription testDescription) {
                    return testDescription.getRootRelativeURL();
                }

                @Override
                protected boolean getCacheableValue(TestDescription testDescription) throws TestFilter.Fault {
                    return compositeFilter.accepts(testDescription);
                }
            };
        }
        return this.relevantTestFilter;
    }

    TestFilter getModulesFilter() {
        JDK jDK = this.getTestJDK();
        if (jDK == null || jDK.getVersion(this, this.logger).compareTo(JDK_Version.V9) == -1) {
            return null;
        }
        final Set<String> set = jDK.getSystemModules(this, this.logger);
        if (set.isEmpty()) {
            return null;
        }
        return new CachingTestFilter("ModulesFilter", "Select tests for which all required modules are available", "A required module is not available"){
            private static final String MODULES = "modules";

            @Override
            protected String getCacheKey(TestDescription testDescription) {
                return testDescription.getParameter(MODULES);
            }

            @Override
            public boolean getCacheableValue(TestDescription testDescription) {
                String string = testDescription.getParameter(MODULES);
                if (string == null) {
                    return true;
                }
                for (String string2 : string.split(" ")) {
                    String string3;
                    if (string2.length() == 0) continue;
                    int n = string2.indexOf("/");
                    String string4 = string3 = n == -1 ? string2 : string2.substring(0, n);
                    if (set.contains(string3)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    TestFilter getRequiresFilter() {
        return new CachingTestFilter("RequiresFilter", "Select tests that satisfy a given set of platform requirements", "The platform does not meet the specified requirements"){
            private static final String REQUIRES = "requires";

            @Override
            protected String getCacheKey(TestDescription testDescription) {
                return testDescription.getParameter(REQUIRES);
            }

            @Override
            public boolean getCacheableValue(TestDescription testDescription) {
                try {
                    String string = testDescription.getParameter(REQUIRES);
                    if (string == null) {
                        return true;
                    }
                    return Expr.parse(string, RegressionParameters.this.exprContext).evalBoolean(RegressionParameters.this.exprContext);
                }
                catch (Expr.Fault fault) {
                    RegressionParameters.this.filterFaults.put(testDescription.getRootRelativeURL(), "Error evaluating expression: " + fault.getMessage());
                    return true;
                }
            }
        };
    }

    TestFilter getTimeLimitFilter() {
        if (this.timeLimit <= 0) {
            return null;
        }
        return new CachingTestFilter("TestLimitFilter", "Select tests that do not exceed a specified timeout value", "Test declares a timeout which exceeds the requested time limit"){
            final String MAX_TIMEOUT = "maxTimeout";
            {
                this.MAX_TIMEOUT = "maxTimeout";
            }

            @Override
            protected String getCacheKey(TestDescription testDescription) {
                return testDescription.getParameter("maxTimeout");
            }

            @Override
            public boolean getCacheableValue(TestDescription testDescription) {
                String string = testDescription.getParameter("maxTimeout");
                if (string != null) {
                    try {
                        int n = Integer.parseInt(string);
                        if (n == 0 || n > RegressionParameters.this.timeLimit) {
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
    }

    @Override
    public CachingTestFilter getExcludeListFilter() {
        if (this.excludeListFilter == UNSET) {
            final ExcludeList excludeList = this.getExcludeList();
            this.excludeListFilter = excludeList == null ? null : new CachingTestFilter("jtregExcludeListFilter", "Select tests which are not excluded on any exclude list", "Test has been excluded by an exclude list"){
                final TestListWithPlatforms list;
                {
                    super(string, string2, string3);
                    this.list = new TestListWithPlatforms(excludeList, RegressionParameters.this.getTestOS());
                }

                @Override
                protected String getCacheKey(TestDescription testDescription) {
                    return testDescription.getRootRelativeURL();
                }

                @Override
                public boolean getCacheableValue(TestDescription testDescription) {
                    return !this.list.match(testDescription);
                }
            };
        }
        return this.excludeListFilter;
    }

    private TestFilter getMatchListFilter() {
        if (this.matchListFilter == UNSET) {
            List<File> list = this.getMatchLists();
            if (list.isEmpty()) {
                this.matchListFilter = null;
            } else {
                ExcludeList excludeList;
                try {
                    excludeList = new ExcludeList(list.toArray(new File[0]));
                }
                catch (ExcludeList.Fault | IOException exception) {
                    throw new Error(exception);
                }
                this.matchListFilter = new CachingTestFilter("jtregMatchListFilter", "Select tests which are in a match list", "Test has not been matched by a match list"){
                    final TestListWithPlatforms list;
                    {
                        super(string, string2, string3);
                        this.list = new TestListWithPlatforms(excludeList, RegressionParameters.this.getTestOS());
                    }

                    @Override
                    protected String getCacheKey(TestDescription testDescription) {
                        return testDescription.getRootRelativeURL();
                    }

                    @Override
                    public boolean getCacheableValue(TestDescription testDescription) {
                        return this.list.match(testDescription);
                    }
                };
            }
        }
        return this.matchListFilter;
    }

    @Override
    public KeywordsTestFilter getKeywordsFilter() {
        if (this.keywordsFilter == UNSET_KEYWORDS_FILTER) {
            TestFilter testFilter = super.getKeywordsFilter();
            this.keywordsFilter = testFilter == null ? null : new KeywordsTestFilter(testFilter);
        }
        return this.keywordsFilter;
    }

    @Override
    public TestFilter getPriorStatusFilter() {
        if (this.priorStatusFilter == UNSET) {
            final TestFilter testFilter = super.getPriorStatusFilter();
            this.priorStatusFilter = testFilter == null ? null : new CachingTestFilter("jtregPriorStatusFilter", "Select tests which match a specified status", "Test did not match a specified status"){

                @Override
                protected String getCacheKey(TestDescription testDescription) {
                    return testDescription.getRootRelativeURL();
                }

                @Override
                public boolean getCacheableValue(TestDescription testDescription) throws TestFilter.Fault {
                    return testFilter.accepts(testDescription);
                }
            };
        }
        return this.priorStatusFilter;
    }

    public void load(Map map, boolean bl) throws Interview.Fault {
        super.load((Map<String, String>)map, bl);
        this.load0(map, bl);
    }

    private void load0(Map<String, String> map, boolean bl) throws Interview.Fault {
        String string = this.getTag();
        String string2 = map.get(string + ENVVARS);
        if (string2 != null) {
            this.setEnvVars(this.deserializeEnv(string2, "\n"));
        }
        if ((string2 = map.get(string + CHECK)) != null) {
            this.setCheck(string2.equals("true"));
        }
        if ((string2 = map.get(string + EXEC_MODE)) != null) {
            this.setExecMode(ExecMode.valueOf(string2));
        }
        if ((string2 = map.get(string + IGNORE)) != null) {
            this.setIgnoreKind(IgnoreKind.valueOf(string2));
        }
        if ((string2 = map.get(string + COMPILE_JDK)) != null) {
            this.setCompileJDK(JDK.of(string2));
        }
        if ((string2 = map.get(string + TEST_JDK)) != null) {
            this.setTestJDK(JDK.of(string2));
        }
        if ((string2 = map.get(string + TEST_VM_OPTIONS)) != null && string2.length() > 0) {
            this.setTestVMOptions(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = map.get(string + TEST_COMPILER_OPTIONS)) != null && string2.length() > 0) {
            this.setTestCompilerOptions(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = map.get(string + TEST_JAVA_OPTIONS)) != null && string2.length() > 0) {
            this.setTestJavaOptions(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = map.get(string + RETAIN_ARGS)) != null && string2.length() > 0) {
            this.setRetainArgs(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = map.get(string + JUNIT)) != null) {
            this.setJUnitPath(new SearchPath(string2));
        }
        if ((string2 = map.get(string + TESTNG)) != null) {
            this.setTestNGPath(new SearchPath(string2));
        }
        if ((string2 = map.get(string + ASMTOOLS)) != null) {
            this.setAsmToolsPath(new SearchPath(string2));
        }
        if ((string2 = map.get(string + TIMELIMIT)) != null) {
            this.setTimeLimit(Integer.parseInt(string2));
        }
        if ((string2 = map.get(string + REPORTDIR)) != null) {
            this.setReportDir(new File(string2));
        }
        if ((string2 = map.get(string + EXCLUSIVE_LOCK)) != null) {
            this.setExclusiveLock(new File(string2));
        }
        if ((string2 = map.get(string + NATIVEDIR)) != null) {
            this.setNativeDir(new File(string2));
        }
        if ((string2 = map.get(string + TIMEOUT_HANDLER)) != null) {
            this.setTimeoutHandler(string2);
        }
        if ((string2 = map.get(string + TIMEOUT_HANDLER_PATH)) != null) {
            this.setTimeoutHandlerPath(string2);
        }
        if ((string2 = map.get(string + TIMEOUT_HANDLER_TIMEOUT)) != null) {
            this.setTimeoutHandlerTimeout(string2);
        }
    }

    public void save(Map map) {
        this.save0(map);
        super.save(map);
    }

    private void save0(Map<String, String> map) {
        String string = this.getTag();
        if (this.envVars != null) {
            map.put(string + ENVVARS, this.serializeEnv(this.envVars, "\n"));
        }
        map.put(string + CHECK, String.valueOf(this.check));
        map.put(string + EXEC_MODE, String.valueOf((Object)this.execMode));
        map.put(string + IGNORE, String.valueOf((Object)this.ignoreKind));
        if (this.testJDK != null) {
            map.put(string + TEST_JDK, this.testJDK.getPath());
        }
        if (this.compileJDK != null) {
            map.put(string + COMPILE_JDK, this.compileJDK.getPath());
        }
        if (this.retainArgs != null && this.retainArgs.size() > 0) {
            map.put(string + RETAIN_ARGS, StringUtils.join(this.retainArgs, "\n"));
        }
        if (this.testVMOpts != null && this.testVMOpts.size() > 0) {
            map.put(string + TEST_VM_OPTIONS, StringUtils.join(this.testVMOpts, "\n"));
        }
        if (this.testCompilerOpts != null && this.testCompilerOpts.size() > 0) {
            map.put(string + TEST_COMPILER_OPTIONS, StringUtils.join(this.testCompilerOpts, "\n"));
        }
        if (this.testJavaOpts != null && this.testJavaOpts.size() > 0) {
            map.put(string + TEST_JAVA_OPTIONS, StringUtils.join(this.testJavaOpts, "\n"));
        }
        if (this.junitPath != null) {
            map.put(string + JUNIT, this.junitPath.toString());
        }
        if (this.testngPath != null) {
            map.put(string + TESTNG, this.testngPath.toString());
        }
        if (this.asmToolsPath != null) {
            map.put(string + ASMTOOLS, this.asmToolsPath.toString());
        }
        if (this.timeLimit > 0) {
            map.put(string + TIMELIMIT, String.valueOf(this.timeLimit));
        }
        if (this.reportDir != null) {
            map.put(string + REPORTDIR, this.reportDir.getPath());
        }
        if (this.exclusiveLock != null) {
            map.put(string + EXCLUSIVE_LOCK, this.exclusiveLock.getPath());
        }
        if (this.nativeDir != null) {
            map.put(string + NATIVEDIR, this.nativeDir.getPath());
        }
        if (this.timeoutHandlerClassName != null) {
            map.put(string + TIMEOUT_HANDLER, this.timeoutHandlerClassName);
        }
        if (this.timeoutHandlerPath != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            for (File file : this.timeoutHandlerPath) {
                stringBuilder.append(string2).append(file);
                string2 = File.pathSeparator;
            }
            map.put(string + TIMEOUT_HANDLER_PATH, stringBuilder.toString());
        }
        if (this.timeoutHandlerTimeout != -1L) {
            map.put(string + TIMEOUT_HANDLER_TIMEOUT, String.valueOf(this.timeoutHandlerTimeout));
        }
    }

    private Map<String, String> deserializeEnv(String string, String string2) {
        if (string != null && string.length() != 0) {
            String[] stringArray;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string3 : stringArray = StringUtils.splitSeparator(string2, string)) {
                String[] stringArray2 = StringUtils.splitSeparator("=", string3);
                linkedHashMap.put(stringArray2[0], stringArray2[1]);
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
        return Collections.emptyMap();
    }

    private String serializeEnv(Map<String, String> map, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = map.size();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
            if (--n == 0) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getEnvVars() {
        if (this.envVars == null) {
            String string = System.getProperty("envVars");
            this.envVars = this.deserializeEnv(string, ",");
        }
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> map) {
        this.envVars = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(map));
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean bl) {
        this.check = bl;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setIgnoreKind(IgnoreKind ignoreKind) {
        ((Object)((Object)ignoreKind)).getClass();
        this.ignoreKind = ignoreKind;
    }

    public IgnoreKind getIgnoreKind() {
        return this.ignoreKind;
    }

    public void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    int getTimeLimit() {
        return this.timeLimit;
    }

    public void setCompileJDK(JDK jDK) {
        jDK.getClass();
        this.compileJDK = jDK;
    }

    public JDK getCompileJDK() {
        return this.compileJDK;
    }

    public void setTestJDK(JDK jDK) {
        jDK.getClass();
        this.testJDK = jDK;
    }

    public JDK getTestJDK() {
        return this.testJDK;
    }

    public void setJUnitPath(SearchPath searchPath) {
        searchPath.getClass();
        this.junitPath = searchPath;
    }

    public SearchPath getJUnitPath() {
        return this.junitPath;
    }

    public boolean isJUnitAvailable() {
        return this.junitPath != null && !this.junitPath.isEmpty();
    }

    public void setTestNGPath(SearchPath searchPath) {
        searchPath.getClass();
        this.testngPath = searchPath;
    }

    public SearchPath getTestNGPath() {
        return this.testngPath;
    }

    public boolean isTestNGAvailable() {
        return this.testngPath != null && !this.testngPath.isEmpty();
    }

    public void setAsmToolsPath(SearchPath searchPath) {
        searchPath.getClass();
        this.asmToolsPath = searchPath;
    }

    public SearchPath getAsmToolsPath() {
        return this.asmToolsPath;
    }

    public SearchPath getJavaTestClassPath() {
        if (this.javaTestClassPath == null) {
            File file = ProductInfo.getJavaTestClassDir();
            this.javaTestClassPath = new SearchPath(file);
            if (file.getName().equals("javatest.jar")) {
                File file2 = file.getParentFile();
                this.javaTestClassPath.append(new File(file2, "jtreg.jar"));
            }
        }
        return this.javaTestClassPath;
    }

    public List<String> getTestVMOptions() {
        if (this.testVMOpts == null) {
            this.testVMOpts = Collections.emptyList();
        }
        return this.testVMOpts;
    }

    public void setTestVMOptions(List<String> list) {
        this.testVMOpts = Collections.unmodifiableList(new ArrayList<String>(list));
    }

    public List<String> getTestToolVMOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getTestVMOptions()) {
            arrayList.add("-J" + string);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<String> getTestVMJavaOptions() {
        if ((this.testVMOpts == null || this.testVMOpts.isEmpty()) && this.nativeDir == null) {
            return this.getTestJavaOptions();
        }
        if ((this.testJavaOpts == null || this.testJavaOpts.isEmpty()) && this.nativeDir == null) {
            return this.getTestVMOptions();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getTestVMOptions());
        arrayList.addAll(this.getTestJavaOptions());
        if (this.nativeDir != null) {
            arrayList.add("-Djava.library.path=" + this.nativeDir.getAbsolutePath());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<String> getTestCompilerOptions() {
        if (this.testCompilerOpts == null) {
            this.testCompilerOpts = Collections.emptyList();
        }
        return this.testCompilerOpts;
    }

    public void setTestCompilerOptions(List<String> list) {
        this.testCompilerOpts = Collections.unmodifiableList(new ArrayList<String>(list));
    }

    public List<String> getTestJavaOptions() {
        if (this.testJavaOpts == null) {
            this.testJavaOpts = Collections.emptyList();
        }
        return this.testJavaOpts;
    }

    public void setTestJavaOptions(List<String> list) {
        this.testJavaOpts = Collections.unmodifiableList(new ArrayList<String>(list));
    }

    public List<String> getTestDebugOptions() {
        if (this.testDebugOpts == null) {
            this.testDebugOpts = Collections.emptyList();
        }
        return this.testDebugOpts;
    }

    public void setTestDebugOptions(List<String> list) {
        this.testDebugOpts = Collections.unmodifiableList(new ArrayList<String>(list));
    }

    List<String> getRetainArgs() {
        return this.retainArgs;
    }

    public void setRetainArgs(List<String> list) {
        this.retainStatusSet.clear();
        if (list == null || list.contains("lastRun")) {
            this.retainFilesPattern = null;
            return;
        }
        this.retainArgs = Collections.unmodifiableList(new ArrayList<String>(list));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (string.equals("all")) {
                this.retainStatusSet.add(0);
                this.retainStatusSet.add(1);
                this.retainStatusSet.add(2);
                continue;
            }
            if (string.equals("pass")) {
                this.retainStatusSet.add(0);
                continue;
            }
            if (string.equals("fail")) {
                this.retainStatusSet.add(1);
                continue;
            }
            if (string.equals("error")) {
                this.retainStatusSet.add(2);
                continue;
            }
            if (string.equals("none") || string.length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            boolean bl = false;
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '*': {
                        if (bl) {
                            stringBuilder.append("\\E");
                            bl = false;
                        }
                        stringBuilder.append(".*");
                        continue block4;
                    }
                    default: {
                        if (!bl) {
                            stringBuilder.append("\\Q");
                            bl = true;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            if (!bl) continue;
            stringBuilder.append("\\E");
        }
        this.retainFilesPattern = stringBuilder.length() == 0 ? null : Pattern.compile(stringBuilder.toString());
    }

    public boolean isRetainEnabled() {
        return this.retainArgs != null;
    }

    public Set<Integer> getRetainStatus() {
        return this.retainStatusSet;
    }

    public Pattern getRetainFilesPattern() {
        return this.retainFilesPattern;
    }

    public void setReportDir(File file) {
        file.getClass();
        this.reportDir = file;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setExclusiveLock(File file) {
        file.getClass();
        this.exclusiveLock = file;
    }

    public File getExclusiveLock() {
        return this.exclusiveLock;
    }

    public void setNativeDir(File file) {
        this.nativeDir = file;
    }

    public File getNativeDir() {
        return this.nativeDir;
    }

    public void setTimeoutHandler(String string) {
        string.getClass();
        this.timeoutHandlerClassName = string;
    }

    String getTimeoutHandler() {
        return this.timeoutHandlerClassName;
    }

    void setTimeoutHandlerPath(String string) {
        string.getClass();
        this.timeoutHandlerPath = new ArrayList<File>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            this.timeoutHandlerPath.add(new File(string2));
        }
    }

    public void setTimeoutHandlerPath(List<File> list) {
        list.getClass();
        this.timeoutHandlerPath = list;
    }

    List<File> getTimeoutHandlerPath() {
        return this.timeoutHandlerPath;
    }

    public void setTimeoutHandlerTimeout(long l) {
        this.timeoutHandlerTimeout = l;
    }

    private void setTimeoutHandlerTimeout(String string) {
        this.timeoutHandlerTimeout = Long.parseLong(string);
    }

    long getTimeoutHandlerTimeout() {
        return this.timeoutHandlerTimeout;
    }

    public void setMatchLists(File[] fileArray) {
        this.matchLists = Arrays.asList(fileArray);
    }

    List<File> getMatchLists() {
        return Collections.unmodifiableList(this.matchLists);
    }

    public void setUseWindowsSubsystemForLinux(boolean bl) {
        this.useWindowsSubsystemForLinux = bl;
    }

    public boolean useWindowsSubsystemForLinux() {
        return this.useWindowsSubsystemForLinux;
    }

    public Pattern getRefIgnoreLinesPattern() {
        if (this.refIgnoreLinesPattern == UNSET_PATTERN) {
            String string2;
            String string3 = System.getenv("JTREG_REF_IGNORE_LINES");
            if (string3 != null) {
                string2 = Arrays.asList(string3.trim().split("\\s+")).stream().map(string -> "(" + string + ")").collect(Collectors.joining("|"));
            } else {
                Map<String, String> map = this.getEnvVars();
                string2 = Arrays.asList("JAVA_TOOL_OPTIONS", "_JAVA_OPTIONS").stream().filter(map::containsKey).map(string -> "(Picked up " + string + ":.*)").collect(Collectors.joining("|"));
            }
            try {
                this.refIgnoreLinesPattern = string2.isEmpty() ? null : Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.refIgnoreLinesPattern = null;
                throw patternSyntaxException;
            }
        }
        return this.refIgnoreLinesPattern;
    }

    public TimeoutHandlerProvider getTimeoutHandlerProvider() throws MalformedURLException {
        if (this.timeoutHandlerProvider == null) {
            this.timeoutHandlerProvider = new TimeoutHandlerProvider();
            this.timeoutHandlerProvider.setClassName(this.timeoutHandlerClassName);
            if (this.timeoutHandlerPath != null && !this.timeoutHandlerPath.isEmpty()) {
                this.timeoutHandlerProvider.setClassPath(this.timeoutHandlerPath);
            }
            if (this.timeoutHandlerTimeout != -1L) {
                this.timeoutHandlerProvider.setTimeout(this.timeoutHandlerTimeout);
            }
        }
        return this.timeoutHandlerProvider;
    }

    public Map<String, String> getBasicTestProperties() {
        if (this.basicTestProperties == null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            this.put(linkedHashMap, "test.vm.opts", this.getTestVMOptions(), list -> StringUtils.join(list, " "));
            this.put(linkedHashMap, "test.tool.vm.opts", this.getTestToolVMOptions(), list -> StringUtils.join(list, " "));
            this.put(linkedHashMap, "test.compiler.opts", this.getTestCompilerOptions(), list -> StringUtils.join(list, " "));
            this.put(linkedHashMap, "test.java.opts", this.getTestJavaOptions(), list -> StringUtils.join(list, " "));
            this.put(linkedHashMap, "test.jdk", this.getTestJDK(), JDK::getAbsolutePath);
            this.put(linkedHashMap, "compile.jdk", this.getCompileJDK(), JDK::getAbsolutePath);
            this.put(linkedHashMap, "test.timeout.factor", Float.valueOf(this.getTimeoutFactor()), String::valueOf);
            this.put(linkedHashMap, "test.nativepath", this.getNativeDir(), File::getAbsolutePath);
            this.put(linkedHashMap, "test.root", this.getTestSuite().getRootDir(), File::getAbsolutePath);
            this.basicTestProperties = linkedHashMap;
        }
        return this.basicTestProperties;
    }

    private <T> void put(Map<String, String> map, String string, T t, Function<T, String> function) {
        if (t != null) {
            map.put(string, function.apply(t));
        }
    }

    private OS getTestOS() {
        JDK jDK = this.getTestJDK();
        if (jDK == null) {
            return OS.current();
        }
        try {
            return OS.forProps(this.testJDK.getProperties(this, this.logger));
        }
        catch (JDK.Fault fault) {
            throw new IllegalStateException(fault);
        }
    }

    public static class KeywordsTestFilter
    extends TestFilter {
        private final TestFilter delegate;
        public final Set<String> ignored = new HashSet<String>();

        KeywordsTestFilter(TestFilter testFilter) {
            this.delegate = testFilter;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public String getReason() {
            return this.delegate.getReason();
        }

        @Override
        public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
            boolean bl = this.delegate.accepts(testDescription);
            if (!bl && testDescription.getKeywordTable().contains("ignore")) {
                this.ignored.add(testDescription.getRootRelativeURL());
            }
            return bl;
        }
    }

    private static class TestListWithPlatforms {
        private final ExcludeList el;
        private final Set<String> osPlatforms;

        private static Set<String> getPlatforms(OS oS) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : Arrays.asList(oS.name, oS.name.replaceAll("\\s", ""), oS.family, "generic")) {
                for (String string2 : Arrays.asList(null, oS.arch, oS.simple_arch, oS.version, oS.simple_version, "all")) {
                    String string3 = string2 == null ? string : string + "-" + string2;
                    hashSet.add(string3.toLowerCase());
                }
            }
            return hashSet;
        }

        TestListWithPlatforms(ExcludeList excludeList, OS oS) {
            this.el = excludeList;
            this.osPlatforms = TestListWithPlatforms.getPlatforms(oS);
        }

        public boolean match(TestDescription testDescription) {
            String[] stringArray;
            ExcludeList.Entry entry = this.el.getEntry(testDescription.getRootRelativeURL());
            if (entry == null) {
                return false;
            }
            String[] stringArray2 = entry.getPlatforms();
            if ((stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0) && (stringArray = entry.getBugIdStrings()).length > 0 && !stringArray[0].matches("0|([1-9][0-9,]*)")) {
                stringArray2 = stringArray;
            }
            if (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0) {
                return true;
            }
            for (String string : stringArray2) {
                if (!this.osPlatforms.contains(string.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }
}

