/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.CompileAction;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import java.io.File;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BuildAction
extends Action {
    public static final String NAME = "build";
    private static final String IGNORE_CASE = "(?i)";
    private static final String OPT_MODULE = "([a-z_][.a-z0-9_$]*/)?";
    private static final String PKG_CLASS = "(([a-z_][.a-z0-9_$]*)(\\.\\*|\\.package-info)?)";
    private static final String PKG_CLASS_OR_OTHER = "((([a-z_][.a-z0-9_$]*)(\\.\\*|\\.package-info)?)|\\*|module-info)";
    static final Pattern BUILD_PTN = Pattern.compile("(?i)([a-z_][.a-z0-9_$]*/)?((([a-z_][.a-z0-9_$]*)(\\.\\*|\\.package-info)?)|\\*|module-info)");
    private String implicitOpt;

    @Override
    public String getName() {
        return NAME;
    }

    public Status build(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws TestRunException {
        this.init(map, list, string, regressionScript);
        return this.run();
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        super.init(map, list, string, regressionScript);
        for (Map.Entry<String, String> object : map.entrySet()) {
            String string2 = object.getKey();
            String string3 = object.getValue();
            if (string2.equals("implicit") && string3.equals("none")) {
                this.implicitOpt = "-implicit:none";
                continue;
            }
            throw new ParseException("Unexpected options for `build'");
        }
        if (list.isEmpty()) {
            throw new ParseException("No classname(s) provided for `build'");
        }
        for (String string4 : list) {
            if (BUILD_PTN.matcher(string4).matches()) continue;
            throw new ParseException("Bad classname provided for `build': " + string4);
        }
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String string : this.args) {
            try {
                for (Locations.ClassLocn classLocn : this.script.locations.locateClasses(string)) {
                    linkedHashSet.add(classLocn.absSrcFile);
                }
            }
            catch (Locations.Fault fault) {
            }
        }
        return linkedHashSet;
    }

    @Override
    public Set<String> getModules() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.args) {
            int n = string.indexOf("/");
            if (n <= 0) continue;
            linkedHashSet.add(string.substring(0, n));
        }
        return linkedHashSet;
    }

    @Override
    public Status run() throws TestRunException {
        Object object;
        this.startAction(false);
        PrintWriter printWriter = this.section.getMessageWriter();
        long l = System.currentTimeMillis();
        LinkedHashMap<Locations.LibLocn, ArrayList<Locations.ClassLocn>> linkedHashMap = new LinkedHashMap<Locations.LibLocn, ArrayList<Locations.ClassLocn>>();
        for (Iterator iterator : this.args) {
            try {
                for (Locations.ClassLocn classLocn : this.script.locations.locateClasses((String)((Object)iterator))) {
                    if (classLocn.absSrcFile.lastModified() > l) {
                        printWriter.println(String.format("WARNING: file %s has a modification time in the future: %s", classLocn.absSrcFile, DateFormat.getDateTimeInstance().format(new Date(classLocn.absSrcFile.lastModified()))));
                        printWriter.println("Unexpected results may occur");
                    }
                    if (classLocn.isUpToDate()) continue;
                    ArrayList<Locations.ClassLocn> arrayList = (ArrayList<Locations.ClassLocn>)linkedHashMap.get(classLocn.lib);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Locations.ClassLocn>();
                        linkedHashMap.put(classLocn.lib, arrayList);
                    }
                    arrayList.add(classLocn);
                }
            }
            catch (Locations.Fault fault) {
                throw new TestRunException(fault.getMessage());
            }
        }
        if (linkedHashMap.isEmpty()) {
            object = RStatus.passed("All files up to date");
        } else {
            object = null;
            for (File file : this.script.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE)) {
                file.mkdirs();
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Status status;
                if (((Locations.LibLocn)entry.getKey()).name == null || (status = this.compileLibrary((Locations.LibLocn)entry.getKey(), (List)entry.getValue())).isPassed()) continue;
                object = status;
                break;
            }
            if (object == null) {
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    Status status;
                    if (((Locations.LibLocn)entry.getKey()).name != null || (status = this.compileLibrary((Locations.LibLocn)entry.getKey(), (List)entry.getValue())).isPassed()) continue;
                    object = status;
                    break;
                }
            }
            if (object == null) {
                object = RStatus.passed("Build successful");
            }
        }
        this.endAction((Status)object);
        return object;
    }

    private Status compileLibrary(Locations.LibLocn libLocn, List<Locations.ClassLocn> list) throws TestRunException {
        this.showClasses(libLocn, list);
        switch (libLocn.kind) {
            case PACKAGE: {
                return this.compileFiles(libLocn, false, null, this.getSrcFiles(list));
            }
            case USER_MODULE: {
                return this.compileFiles(libLocn, true, null, this.getSrcFiles(list));
            }
            case SYS_MODULE: {
                Object object;
                LinkedHashMap<String, ArrayList<File>> linkedHashMap = new LinkedHashMap<String, ArrayList<File>>();
                for (Locations.ClassLocn object2 : list) {
                    object = (ArrayList<File>)linkedHashMap.get(object2.optModule);
                    if (object == null) {
                        object = new ArrayList<File>();
                        linkedHashMap.put(object2.optModule, (ArrayList<File>)object);
                    }
                    object.add(object2.absSrcFile);
                }
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    object = this.compileFiles(libLocn, false, (String)entry.getKey(), (List)entry.getValue());
                    if (((Status)object).isPassed()) continue;
                    return object;
                }
                return RStatus.passed("Build successful");
            }
        }
        throw new AssertionError();
    }

    private Status compileFiles(Locations.LibLocn libLocn, boolean bl, String string, List<File> list) throws TestRunException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (bl) {
            linkedHashMap.put("modules", null);
        }
        if (string != null) {
            linkedHashMap.put("module", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.script.getCompileJDK().hasOldSymbolFile()) {
            arrayList.add("-XDignore.symbol.file=true");
        }
        if (this.implicitOpt != null) {
            arrayList.add(this.implicitOpt);
        }
        for (File file : list) {
            arrayList.add(file.getPath());
        }
        CompileAction compileAction = new CompileAction();
        return compileAction.compile(libLocn, linkedHashMap, arrayList, ".class file out of date or does not exist", this.script);
    }

    private List<File> getSrcFiles(List<Locations.ClassLocn> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Locations.ClassLocn classLocn : list) {
            arrayList.add(classLocn.absSrcFile);
        }
        return arrayList;
    }

    private void showClasses(Locations.LibLocn libLocn, List<Locations.ClassLocn> list) {
        PrintWriter printWriter = this.section.getMessageWriter();
        if (libLocn.name == null) {
            printWriter.println("Test directory:");
        } else {
            printWriter.println("Library " + libLocn.name + ":");
        }
        String string = "  compile: ";
        for (Locations.ClassLocn classLocn : list) {
            printWriter.print(string);
            if (classLocn.optModule != null) {
                printWriter.print(classLocn.optModule);
                printWriter.print("/");
            }
            printWriter.print(classLocn.className);
            string = ", ";
        }
        printWriter.println();
    }
}

