/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.regtest.config.RegressionParameters;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Lock {
    static Map<RegressionParameters, Lock> locks = new WeakHashMap<RegressionParameters, Lock>();

    public static synchronized Lock get(RegressionParameters regressionParameters) {
        Lock lock = locks.get(regressionParameters);
        if (lock == null) {
            File file = regressionParameters.getExclusiveLock();
            lock = file == null ? new SimpleLock() : new MultiVMLock(file);
            locks.put(regressionParameters, lock);
        }
        return lock;
    }

    public abstract void lock();

    public abstract void unlock();

    public void close() {
    }

    private static class MultiVMLock
    extends SimpleLock {
        private File file;
        private RandomAccessFile raf;
        private FileLock fileLock;

        MultiVMLock(File file) {
            try {
                this.file = file;
                while (!file.exists()) {
                    file.createNewFile();
                }
                this.raf = new RandomAccessFile(file, "rw");
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }

        @Override
        public void lock() {
            super.lock();
            boolean bl = false;
            try {
                this.fileLock = this.raf.getChannel().lock();
                bl = true;
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
            finally {
                if (!bl) {
                    super.unlock();
                }
            }
        }

        @Override
        public void unlock() {
            try {
                this.fileLock.release();
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
            finally {
                super.unlock();
            }
        }

        @Override
        public void close() {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
    }

    private static class SimpleLock
    extends Lock {
        ReentrantLock lock = new ReentrantLock();

        private SimpleLock() {
        }

        @Override
        public void lock() {
            this.lock.lock();
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }
    }
}

