/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.agent.ActionHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestNGReporter {
    private static final Map<WorkDirectory, TestNGReporter> instanceMap = new WeakHashMap<WorkDirectory, TestNGReporter>();
    Map<String, Info> infoMap = new TreeMap<String, Info>();
    static final String testsPrefix = "Total tests run:";
    static final Pattern testsPattern = Pattern.compile("[^0-9]+([0-9]+)[^0-9]+([0-9]+)[^0-9]+([0-9]+)[^0-9]*");
    static final String configPrefix = "Configuration Failures:";
    static final Pattern configPattern = Pattern.compile("[^0-9]+([0-9]+)[^0-9]+([0-9]+)[^0-9]*");

    public static TestNGReporter instance(WorkDirectory workDirectory) {
        TestNGReporter testNGReporter = instanceMap.get(workDirectory);
        if (testNGReporter == null) {
            testNGReporter = new TestNGReporter();
            instanceMap.put(workDirectory, testNGReporter);
        }
        return testNGReporter;
    }

    boolean isEmpty() {
        return this.infoMap.isEmpty();
    }

    public synchronized void add(TestResult testResult, TestResult.Section section) {
        try {
            String string;
            Info info;
            TestDescription testDescription = testResult.getDescription();
            String string2 = testDescription.getParameter("packageRoot");
            if (string2 == null) {
                string2 = testDescription.getRootRelativePath();
            }
            if ((info = this.infoMap.get(string2)) == null) {
                info = new Info();
                this.infoMap.put(string2, info);
            }
            if ((string = section.getOutput(ActionHelper.OutputHandler.OutputKind.STDOUT.name)) != null) {
                Matcher matcher;
                Matcher matcher2 = this.getMatcher(string, testsPrefix, testsPattern);
                if (matcher2 != null && matcher2.matches()) {
                    info.count += Integer.parseInt(matcher2.group(1));
                    info.failureCount += Integer.parseInt(matcher2.group(2));
                    info.skippedCount += Integer.parseInt(matcher2.group(3));
                }
                if ((matcher = this.getMatcher(string, configPrefix, configPattern)) != null && matcher.matches()) {
                    info.configFailureCount += Integer.parseInt(matcher.group(1));
                    info.configSkippedCount += Integer.parseInt(matcher.group(2));
                }
            }
        }
        catch (TestResult.Fault fault) {
            // empty catch block
        }
    }

    private Matcher getMatcher(String string, String string2, Pattern pattern) {
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("\n", n);
        if (n2 == -1) {
            return null;
        }
        return pattern.matcher(string.substring(n, n2));
    }

    public void writeReport(File file) throws IOException {
        File file2 = new File(file, "text");
        file2.mkdirs();
        File file3 = new File(file2, "testng.txt");
        try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file3)));){
            for (Map.Entry<String, Info> entry : this.infoMap.entrySet()) {
                printWriter.println(entry.getKey() + " " + entry.getValue());
            }
        }
    }

    static class Info {
        int count;
        int failureCount;
        int skippedCount;
        int configFailureCount;
        int configSkippedCount;

        Info() {
        }

        public String toString() {
            return "total: " + this.count + ", passed: " + (this.count - this.failureCount - this.skippedCount) + ", failed: " + this.failureCount + ", skipped: " + this.skippedCount + ", config failed: " + this.configFailureCount + ", config skipped: " + this.configSkippedCount;
        }
    }
}

