/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Harness;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.regtest.report.Verbose;
import java.io.PrintWriter;

public class VerboseHandler {
    private static final String VERBOSE_TEST_SEP = "--------------------------------------------------";
    private static final String LINESEP = System.getProperty("line.separator");
    private final Verbose verbose;
    private final PrintWriter out;
    private final PrintWriter err;
    private boolean doneSeparator;

    public VerboseHandler(Verbose verbose, PrintWriter printWriter, PrintWriter printWriter2) {
        this.verbose = verbose;
        this.out = printWriter;
        this.err = printWriter2;
    }

    public void register(Harness harness) {
        harness.addObserver(new BasicObserver(){

            @Override
            public synchronized void startingTest(TestResult testResult) {
                VerboseHandler.this.startingTest(testResult);
            }

            @Override
            public synchronized void finishedTest(TestResult testResult) {
                VerboseHandler.this.finishedTest(testResult);
            }
        });
    }

    private void startingTest(TestResult testResult) {
        if (this.verbose.isDefault()) {
            try {
                TestDescription testDescription = testResult.getDescription();
                this.out.println("runner starting test: " + testDescription.getRootRelativeURL());
            }
            catch (TestResult.Fault fault) {
                fault.printStackTrace(System.err);
            }
        }
    }

    private void finishedTest(TestResult testResult) {
        Verbose.Mode mode;
        switch (testResult.getStatus().getType()) {
            case 0: {
                mode = this.verbose.passMode;
                break;
            }
            case 1: {
                mode = this.verbose.failMode;
                break;
            }
            case 2: {
                mode = this.verbose.errorMode;
                break;
            }
            default: {
                mode = Verbose.Mode.NONE;
            }
        }
        switch (mode) {
            case NONE: {
                break;
            }
            case DEFAULT: {
                try {
                    TestDescription testDescription = testResult.getDescription();
                    if (this.verbose.time) {
                        this.printElapsedTimes(testResult);
                    }
                    this.out.println("runner finished test: " + testDescription.getRootRelativeURL());
                    this.out.println(testResult.getStatus());
                }
                catch (TestResult.Fault fault) {
                    fault.printStackTrace(System.err);
                }
                break;
            }
            case SUMMARY: {
                this.printSummary(testResult, this.verbose.time);
                break;
            }
            case BRIEF: {
                this.printBriefOutput(testResult, this.verbose.time);
                break;
            }
            case FULL: {
                this.printFullOutput(testResult);
            }
        }
    }

    private void printSummary(TestResult testResult, boolean bl) {
        try {
            TestDescription testDescription = testResult.getDescription();
            String string = testResult.getStatus().isPassed() ? "Passed: " : (testResult.getStatus().isFailed() ? "FAILED: " : (testResult.getStatus().isError() ? "Error:  " : "Unexpected status: "));
            string = string + testDescription.getRootRelativeURL();
            this.out.println(string);
            if (bl) {
                this.printElapsedTimes(testResult);
            }
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace(System.err);
        }
    }

    private void printBriefOutput(TestResult testResult, boolean bl) {
        if (!this.doneSeparator) {
            this.out.println(VERBOSE_TEST_SEP);
            this.doneSeparator = true;
        }
        try {
            TestDescription testDescription = testResult.getDescription();
            this.out.println("TEST: " + testDescription.getRootRelativeURL());
            if (bl) {
                this.printElapsedTimes(testResult);
            }
            this.out.println("TEST RESULT: " + testResult.getStatus());
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace(System.err);
        }
        this.out.println(VERBOSE_TEST_SEP);
    }

    private void printFullOutput(TestResult testResult) {
        if (!this.doneSeparator) {
            this.out.println(VERBOSE_TEST_SEP);
            this.doneSeparator = true;
        }
        try {
            TestDescription testDescription = testResult.getDescription();
            this.out.println("TEST: " + testDescription.getRootRelativeURL());
            String string = this.getTestJDK(testResult);
            if (string != null) {
                this.out.println("TEST JDK: " + string);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < testResult.getSectionCount(); ++i) {
                String[] stringArray;
                TestResult.Section section = testResult.getSection(i);
                stringBuilder.append(LINESEP);
                stringBuilder.append("ACTION: ").append(section.getTitle());
                stringBuilder.append(" -- ").append(section.getStatus()).append(LINESEP);
                stringBuilder.append("REASON: ").append(this.getReason(section)).append(LINESEP);
                stringBuilder.append("TIME:   ").append(this.getElapsedTime(section));
                stringBuilder.append(" seconds").append(LINESEP);
                block11: for (String string2 : stringArray = section.getOutputNames()) {
                    String string3 = section.getOutput(string2);
                    switch (string2) {
                        case "System.out": {
                            stringBuilder.append("STDOUT:").append(LINESEP).append(string3);
                            continue block11;
                        }
                        case "System.err": {
                            stringBuilder.append("STDERR:").append(LINESEP).append(string3);
                            continue block11;
                        }
                        default: {
                            stringBuilder.append(string2).append(":").append(LINESEP).append(string3);
                        }
                    }
                }
            }
            this.out.println(stringBuilder.toString());
            this.out.println("TEST RESULT: " + testResult.getStatus());
            this.out.println(VERBOSE_TEST_SEP);
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace(System.err);
        }
    }

    private void printElapsedTimes(TestResult testResult) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (int i = 1; i < testResult.getSectionCount(); ++i) {
                TestResult.Section section = testResult.getSection(i);
                stringBuilder.append("  ").append(section.getTitle()).append(": ");
                stringBuilder.append(this.getElapsedTime(section)).append(" seconds").append(LINESEP);
            }
            this.out.print(stringBuilder.toString());
        }
        catch (TestResult.ReloadFault reloadFault) {
            reloadFault.printStackTrace(System.err);
        }
    }

    private String getReason(TestResult.Section section) {
        String string = section.getOutput("messages");
        int n = string.indexOf("reason: ") + "reason: ".length();
        int n2 = string.indexOf(LINESEP, n);
        return string.substring(n, n2);
    }

    private String getElapsedTime(TestResult.Section section) {
        String string = section.getOutput("messages");
        int n = string.indexOf("elapsed time (seconds): ") + "elapsed time (seconds): ".length();
        int n2 = string.indexOf(LINESEP, n);
        return string.substring(n, n2);
    }

    private String getTestJDK(TestResult testResult) {
        try {
            return testResult.getProperty("testJDK");
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace(System.err);
            return null;
        }
    }
}

