/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.regtest.report.XPrintStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class XMLWriter {
    static final String PASSED = "Passed.";
    static final String FAILED = "Failed.";
    public final TestResult tr;
    private final XPrintStream xps;
    private final String classname;
    private final Date start;
    private final double duration;
    private final Status status;
    private final File xmlFile;
    private final boolean verify;
    private final PrintWriter harnessOut;
    private final PrintWriter harnessErr;
    private final SimpleDateFormat defDateFmt;
    private final DateFormat isoDateFmt;

    XMLWriter(TestResult testResult, boolean bl, PrintWriter printWriter, PrintWriter printWriter2) throws ParseException, UnsupportedEncodingException, TestResult.Fault {
        String string = Charset.defaultCharset().name();
        this.defDateFmt = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy", Locale.US);
        this.isoDateFmt = new SimpleDateFormat("yyyy-MM-DD'T'HH:mm:ssZ");
        this.harnessOut = printWriter;
        this.harnessErr = printWriter2;
        this.xps = new XPrintStream(this.harnessOut, this.harnessErr, string);
        this.tr = testResult;
        this.verify = bl;
        this.status = testResult.getStatus();
        this.classname = testResult.getProperty("test");
        this.xmlFile = new File(testResult.getFile().getAbsolutePath() + ".xml");
        this.start = this.defDateFmt.parse(testResult.getProperty("start"));
        this.duration = this.getElapsedTime();
        this.process(string);
    }

    private double getElapsedTime() throws TestResult.Fault {
        String string = this.tr.getProperty("elapsed");
        if (string == null) {
            string = this.tr.getProperty("totalTime");
        }
        if (string == null) {
            return 0.0;
        }
        String[] stringArray = string.split("\\s");
        double d = Double.parseDouble(stringArray[0]);
        return d / 1000.0;
    }

    private void createHeader(String string) {
        this.xps.println("<?xml version=\"1.0\" encoding=\"" + string + "\" ?>");
    }

    private void startTestSuite() throws TestResult.Fault {
        this.xps.print("<testsuite");
        this.xps.print(" errors=\"");
        this.xps.print(this.status.isError() ? "1" : "0");
        this.xps.print("\"");
        this.xps.print(" failures=\"");
        this.xps.print(this.status.isFailed() ? "1" : "0");
        this.xps.print("\"");
        this.xps.print(" tests=\"1\"");
        this.xps.print(" hostname=\"");
        this.xps.print(this.tr.getProperty("hostname"));
        this.xps.print("\"");
        this.xps.print(" name=\"");
        this.xps.print(this.classname);
        this.xps.print("\"");
        this.xps.print(" time=\"");
        this.xps.print(this.duration);
        this.xps.print("\"");
        this.xps.print(" timestamp=\"");
        this.xps.print(this.isoDateFmt.format(this.start));
        this.xps.print("\"");
        this.xps.println(">");
    }

    private void endTestSuite() {
        this.xps.println("</testsuite>");
    }

    private void insertProperties() throws TestResult.Fault {
        Object object;
        this.xps.indent();
        this.xps.println("<properties>");
        TestDescription testDescription = this.tr.getDescription();
        Iterator<String> iterator = testDescription.getParameterKeys();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.xps.indent(2);
            this.xps.print("<property name=\"");
            this.xps.print((String)object);
            this.xps.print("\"");
            this.xps.print(" value=\"");
            this.xps.sanitize(testDescription.getParameter((String)object));
            this.xps.println("\" />");
        }
        object = this.tr.getPropertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            this.xps.indent(2);
            this.xps.print("<property name=\"");
            this.xps.print(string);
            this.xps.print("\"");
            this.xps.print(" value=\"");
            this.xps.sanitize(this.tr.getProperty(string));
            this.xps.println("\" />");
        }
        this.xps.indent();
        this.xps.println("</properties>");
    }

    private String getOutput(String string) throws TestResult.Fault {
        String[] stringArray = this.tr.getSectionTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            TestResult.Section section;
            String[] stringArray2;
            int n;
            int n2;
            if (!stringArray[i].equals("main") || (n2 = 0) >= (n = (stringArray2 = (section = this.tr.getSection(i)).getOutputNames()).length)) continue;
            String string2 = stringArray2[n2];
            return section.getOutput(string);
        }
        return "";
    }

    private void insertSystemOut() throws TestResult.Fault {
        this.xps.indent();
        this.xps.print("<system-out>");
        this.xps.sanitize(this.getOutput("System.out"));
        this.xps.indent();
        this.xps.println("</system-out>");
    }

    private void insertSystemErr() throws TestResult.Fault {
        this.xps.indent();
        this.xps.print("<system-err>");
        this.xps.sanitize(this.getOutput("System.err"));
        this.xps.indent();
        this.xps.println("</system-err>");
    }

    private void insertFailure() {
        if (this.status.isPassed()) {
            return;
        }
        this.xps.indent();
        this.xps.print("<failure type=\"");
        this.xps.print(FAILED);
        this.xps.println("\">");
        this.xps.sanitize(this.status.getReason());
        this.xps.indent();
        this.xps.println("");
        this.xps.println("</failure>");
    }

    private void insertTestCase() throws TestResult.Fault {
        this.xps.indent();
        this.xps.print("<testcase ");
        this.xps.print("classname=\"");
        this.xps.print(this.classname);
        this.xps.print("\"");
        this.xps.print(" name=\"");
        this.xps.print(this.tr.getDescription().getName());
        this.xps.print("\"");
        this.xps.print(" time=\"");
        this.xps.print(this.duration);
        this.xps.print("\"");
        this.xps.println(" >");
        this.insertFailure();
        this.xps.indent();
        this.xps.println("</testcase>");
    }

    private void process(String string) throws ParseException, TestResult.Fault {
        this.createHeader(string);
        this.startTestSuite();
        this.insertProperties();
        this.insertTestCase();
        this.insertSystemOut();
        this.insertSystemErr();
        this.endTestSuite();
    }

    public String toString() {
        return this.xps.toString();
    }

    public void toXML() throws IOException {
        File file = this.xmlFile.getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.xmlFile);){
            this.xps.writeTo(fileOutputStream);
        }
        if (this.verify) {
            this.xps.verifyXML(this.xmlFile);
        }
    }

    private static void usage(PrintStream printStream, String string) {
        if (string != null) {
            printStream.println(string);
        }
        printStream.println("Usage:");
        printStream.println("  java -cp jtreg.jar com.sun.javatest.regtest.XMLWriter -@list");
        printStream.println("      where list is a file containing the .jtr files to be processed");
        printStream.println("  java -cp jtreg.jar com.sun.javatest.regtest.XMLWriter dir");
        printStream.println("      where dir is a JTwork dir containing the .jtr files to be processed");
        printStream.println("  java -cp jtreg.jar com.sun.javatest.regtest.XMLWriter 1.jtr 2.jtr.. n.jtr");
        printStream.println("      where args are a list of .jtr files to be processed");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> fileToList(String string) throws Exception {
        BufferedReader bufferedReader = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string2 = string.replaceFirst("^\\-@|^@", "");
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                arrayList.add(new File(string3));
                string3 = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return arrayList;
    }

    private static void scan(File file, List<File> list) {
        if (file.isFile() && file.getName().endsWith(".jtr")) {
            list.add(file);
        } else if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                XMLWriter.scan(file2, list);
            }
        }
    }

    private static List<File> dirToList(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        XMLWriter.scan(file, arrayList);
        return arrayList;
    }

    private static void translateList(List<File> list) throws Exception {
        if (list == null || list.isEmpty()) {
            XMLWriter.usage(System.out, "Warning: nothing to process");
            return;
        }
        for (File file : list) {
            if (file.exists() && file.isFile() && file.getName().endsWith(".jtr")) {
                XMLWriter xMLWriter = new XMLWriter(new TestResult(file), true, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
                xMLWriter.toXML();
                continue;
            }
            System.out.println("Warning: skipping file " + file);
        }
    }

    private static List<File> argsToList(String ... stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length < 1) {
                XMLWriter.usage(System.err, "Error: insufficent arguments");
            }
            if (stringArray[0].startsWith("-@") || stringArray[0].startsWith("@")) {
                XMLWriter.translateList(XMLWriter.fileToList(stringArray[0]));
            } else {
                File file = new File(stringArray[0]);
                if (file.isDirectory()) {
                    XMLWriter.translateList(XMLWriter.dirToList(file));
                } else {
                    XMLWriter.translateList(XMLWriter.argsToList(stringArray));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static class XMLHarnessObserver
    extends BasicObserver {
        private final boolean mustVerify;
        private final PrintWriter harnessOut;
        private final PrintWriter harnessErr;

        private XMLHarnessObserver() {
            this.harnessOut = null;
            this.harnessErr = null;
            this.mustVerify = false;
        }

        public XMLHarnessObserver(boolean bl, PrintWriter printWriter, PrintWriter printWriter2) {
            this.harnessOut = printWriter;
            this.harnessErr = printWriter2;
            this.mustVerify = bl;
        }

        @Override
        public void finishedTest(TestResult testResult) {
            try {
                super.finishedTest(testResult);
                new XMLWriter(testResult, this.mustVerify, this.harnessOut, this.harnessErr).toXML();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(this.harnessOut);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace(this.harnessOut);
            }
            catch (TestResult.Fault fault) {
                fault.printStackTrace(this.harnessOut);
            }
        }
    }
}

