/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.tool.RuntimeVersion;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Version
implements Comparable<Version> {
    private static Version currentVersion;
    private Properties manifest;
    public final String versionString;
    public final String product;
    public final String version;
    public final String milestone;
    public final String build;
    public final String buildJavaVersion;
    public final String buildDate;

    public static Version getCurrent() {
        if (currentVersion == null) {
            currentVersion = new Version();
        }
        return currentVersion;
    }

    private Version() {
        this.manifest = this.getManifestForClass(this.getClass());
        if (this.manifest == null) {
            this.manifest = new Properties();
        }
        this.product = this.getManifestProperty("jtreg-Name");
        this.versionString = this.getManifestProperty("jtreg-VersionString");
        if (this.versionString == null) {
            this.version = this.getManifestProperty("jtreg-Version");
            this.milestone = this.getManifestProperty("jtreg-Milestone");
            this.build = this.getManifestProperty("jtreg-Build");
        } else {
            RuntimeVersion runtimeVersion = RuntimeVersion.parse(this.versionString);
            this.version = runtimeVersion.version().stream().map(Object::toString).collect(Collectors.joining("."));
            this.milestone = runtimeVersion.pre().orElse(null);
            this.build = runtimeVersion.build().isPresent() ? runtimeVersion.build().get().toString() : null;
        }
        this.buildJavaVersion = this.getManifestProperty("jtreg-BuildJavaVersion");
        this.buildDate = this.getManifestProperty("jtreg-BuildDate");
    }

    private String getManifestProperty(String string) {
        return System.getProperty("OVERRIDE-" + string, this.manifest.getProperty(string));
    }

    public Version(String string) {
        if (string != null) {
            Pattern pattern = Pattern.compile("(?<version>[0-9.]+)(\\s+b|\\+)(?<build>[0-9]+)");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(string);
            }
            this.versionString = null;
            this.version = matcher.group("version");
            this.build = matcher.group("build");
        } else {
            this.versionString = null;
            this.version = null;
            this.build = null;
        }
        this.product = null;
        this.milestone = null;
        this.buildJavaVersion = null;
        this.buildDate = null;
    }

    String getProperty(String string, String string2) {
        return this.manifest.getProperty(string, string2);
    }

    private Properties getManifestForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL == null) {
            return null;
        }
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                int n;
                String string;
                URL uRL2;
                URL uRL3 = enumeration.nextElement();
                if (!uRL3.getProtocol().equals("jar") || !(uRL2 = new URL((string = uRL3.getPath()).substring(0, n = string.lastIndexOf("!")))).equals(uRL)) continue;
                Properties properties = new Properties();
                try (InputStream inputStream = uRL3.openStream();){
                    properties.load(inputStream);
                }
                return properties;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> clazz) {
        try {
            URL uRL = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
            if (uRL.getProtocol().equals("jar")) {
                String string = uRL.getPath();
                int n = string.lastIndexOf("!");
                return new URL(string.substring(0, n));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static int[] parseDottedInts(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    @Override
    public int compareTo(Version version) {
        int n;
        int n2;
        if (this.version == null || version.version == null) {
            return 0;
        }
        int[] nArray = Version.parseDottedInts(this.version);
        int[] nArray2 = Version.parseDottedInts(version.version);
        for (n2 = 0; n2 < Math.max(nArray.length, nArray2.length); ++n2) {
            int n3;
            n = n2 < nArray.length ? nArray[n2] : 0;
            int n4 = n3 = n2 < nArray2.length ? nArray2[n2] : 0;
            if (n > n3) {
                return 1;
            }
            if (n >= n3) continue;
            return -1;
        }
        n2 = this.getBuild();
        n = version.getBuild();
        if (n2 == 0 || n == 0) {
            return 0;
        }
        return Integer.compare(n2, n);
    }

    private int getBuild() {
        if (this.build == null) {
            return 0;
        }
        if (this.build.matches("b?[0-9]+")) {
            String string = this.build.startsWith("b") ? this.build.substring(1) : this.build;
            return Integer.parseInt(string);
        }
        return 0;
    }

    String getVersionBuildString() {
        return this.versionString != null ? this.versionString : String.format("%s b%s", this.version, this.build);
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.versionString != null) {
            arrayList.add("versionString=" + this.versionString);
        }
        if (this.version != null) {
            arrayList.add("version=" + this.version);
        }
        if (this.milestone != null) {
            arrayList.add("milestone=" + this.milestone);
        }
        if (this.build != null) {
            arrayList.add("build=" + this.build);
        }
        return "Version[" + String.join((CharSequence)",", arrayList) + "]";
    }
}

